DROP TABLE applicants;

CREATE TABLE `applicants` (
  `id` int(11) unsigned NOT NULL,
  `role_id` int(11) NOT NULL COMMENT 'whether candidate or system user',
  `type_id` int(11) NOT NULL COMMENT '1- ug 2 -pg',
  `cart_id` int(11) NOT NULL COMMENT 'Not in use for now',
  `faculty_id` int(11) NOT NULL COMMENT 'not in use for now',
  `department_id` int(11) NOT NULL,
  `programme_id` int(13) NOT NULL,
  `programme_type_applied_for` int(11) NOT NULL COMMENT '1- ug 2 -pg',
  `department_applied_for` int(11) NOT NULL,
  `programme_applied_for` int(11) NOT NULL COMMENT 'The programme a candidate applies for',
  `application_number` varchar(222) NOT NULL,
  `application_status` int(3) NOT NULL COMMENT '0 not applied yet , 1- applied already',
  `country_id` int(11) NOT NULL,
  `state_id` int(11) NOT NULL,
  `lga_id` int(11) NOT NULL,
  `first_name` varchar(255) NOT NULL,
  `other_names` varchar(255) NOT NULL,
  `phone_no` varchar(222) NOT NULL,
  `qualification` varchar(222) NOT NULL,
  `qualification_grade` varchar(222) NOT NULL,
  `pdf_file` varchar(222) NOT NULL,
  `gender` varchar(255) NOT NULL,
  `religion` int(11) NOT NULL COMMENT '1- islam, 2- christianity, 3 - traditional, 4 - others',
  `nationality` varchar(222) NOT NULL,
  `day` varchar(22) NOT NULL,
  `month` varchar(22) NOT NULL,
  `year` varchar(22) NOT NULL,
  `marital_status` varchar(222) NOT NULL,
  `number` varchar(222) NOT NULL,
  `username` varchar(255) NOT NULL,
  `password` char(100) NOT NULL,
  `email` varchar(255) NOT NULL,
  `birthdate` varchar(255) NOT NULL,
  `place_of_birth` varchar(255) NOT NULL,
  `phone_number` varchar(255) NOT NULL,
  `security_id` varchar(255) NOT NULL,
  `address` text NOT NULL,
  `permanent_address` text NOT NULL,
  `image` varchar(255) NOT NULL,
  `H_status` varchar(222) NOT NULL,
  `blood_type` varchar(12) NOT NULL,
  `disability` varchar(12) NOT NULL,
  `medi` text NOT NULL,
  `user_status` int(5) NOT NULL COMMENT '0 for blocked, 1 fior active',
  `online_status` int(5) NOT NULL COMMENT '0 for offline and 1 for online',
  `ontoken` int(20) NOT NULL,
  `last_login_ip` varchar(255) NOT NULL,
  `last_login` datetime NOT NULL,
  `last_logout` datetime NOT NULL,
  `town` varchar(255) NOT NULL,
  `level` varchar(25) NOT NULL,
  `status` varchar(222) NOT NULL COMMENT '0 - published, 1- unpublished, 2 - trashed, 3 - archived, 4- deleted from trash',
  `final_submission` int(11) NOT NULL COMMENT '0- not submitted, 1- submitted',
  `date_trashed` datetime NOT NULL COMMENT 'date deleted',
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `added_by` varchar(255) NOT NULL,
  `modified_by` varchar(255) NOT NULL,
  `guardian_name` varchar(255) NOT NULL,
  `guardian_tel` varchar(255) NOT NULL,
  `guardian_address` varchar(255) NOT NULL,
  `guardian_relationship` varchar(255) NOT NULL,
  `sponsorship_type` int(5) NOT NULL COMMENT '1- private, 2- self, 3-governmental, 4- others, nil',
  `sponsorship_name` varchar(255) NOT NULL,
  `sponsorship_address` text NOT NULL,
  `admission_status` int(11) NOT NULL COMMENT '0 - for not admitted 1 - for admitted',
  `admission_criteria` text NOT NULL,
  `admission_batch` int(5) NOT NULL COMMENT 'batch of admissions 1 first batch, 2 - seond batch',
  `date_admitted` datetime NOT NULL,
  `admission_serial_no` varchar(11) NOT NULL,
  `working_experience` int(5) NOT NULL COMMENT 'working experience',
  `school1` varchar(255) NOT NULL,
  `cert1` int(5) NOT NULL COMMENT '1 -D, 2- NCE, 3 - HND, 4 -B.Sc. 5 -Bed, 6 - Msc. 7 -MPhil, 8 -Mtech , 9 -other ',
  `start_year1` year(4) NOT NULL,
  `end_year1` year(4) NOT NULL,
  `result1` int(5) NOT NULL COMMENT '1 -first class, 2 -distinction, 3- 2nd class upper, 4 -upper division, 5 - 2nd clas lower, 6- lower division, 7 -third class, 8 -pass ',
  `school2` varchar(255) NOT NULL,
  `cert2` int(5) NOT NULL COMMENT '1 -D, 2- NCE, 3 - HND, 4 -B.Sc. 5 -Bed, 6 - Msc. 7 -MPhil, 8 -Mtech , 9 -other ',
  `start_year2` year(4) NOT NULL,
  `end_year2` year(4) NOT NULL,
  `result2` int(5) NOT NULL COMMENT '1 -first class, 2 -distinction, 3- 2nd class upper, 4 -upper division, 5 - 2nd clas lower, 6- lower division, 7 -third class, 8 -pass ',
  `school3` varchar(255) NOT NULL,
  `cert3` int(5) NOT NULL COMMENT '1 -D, 2- NCE, 3 - HND, 4 -B.Sc. 5 -Bed, 6 - Msc. 7 -MPhil, 8 -Mtech , 9 -other ',
  `start_year3` year(4) NOT NULL,
  `end_year3` year(4) NOT NULL,
  `result3` int(5) NOT NULL COMMENT '1 -first class, 2 -distinction, 3- 2nd class upper, 4 -upper division, 5 - 2nd clas lower, 6- lower division, 7 -third class, 8 -pass ',
  `qualified` int(5) NOT NULL COMMENT '0 = Not Qualified, 1 = Qualified',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT COMMENT='this table holds information about students and activities';

INSERT INTO applicants VALUES("1","0","0","0","0","0","0","1","1","1","0001","0","0","27","541","","ALHASSAN UMAR","07030994004","","","2019-04-20-132941CREDENTIALS.pdf.pdf","M","1","Nigerian","22","3","1991","married","","","","hassanu783@gmail.com","","BIDA","07030994004","","GRA EXTENSION, HOUSE NO. A3174, BIDA NIGER STATE","GRA EXTENSION, HOUSE NO. A3174, BIDA NIGER STATE","2019-04-20-131217.jpg","Normal","O","None","","1","0","0","197.210.53.31","2019-09-23 09:10:22","2019-09-23 09:51:17","","","","0","0000-00-00 00:00:00","2019-04-20 13:03:47","0000-00-00 00:00:00","","","UMAR","08052027470","GRA EXTENSION, HOUSE NO. A3174, BIDA NIGER STATE","FATHER","1","UMAR","GRA EXTENSION, HOUSE NO. A3174, BIDA NIGER STATE","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("2","0","0","0","0","0","0","1","4","12","0002","0","0","0","0","","SUWAIBA YUSUF","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08147798593","","","","","","","","","1","1","0","105.112.120.225","2019-09-23 08:54:20","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-04-20 15:21:43","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("3","0","1","0","0","4","4","1","4","4","0003","0","0","27","563","","ABUBAKAR MOHAMMED YASIN","08160086260","","","2019-04-23-111053Scan.pdf.pdf","M","1","Nigerian","5","9","1996","single","","","","idinupe@gmail.com","","MINNA","08160086260","","OFF OKADA ROAD MINNA,NIGER STATE","OFF OKADA ROAD MINNA,NIGER STATE","2019-04-23-111136.jpg","Normal","O","None","HEALTH CARE","1","0","0","197.210.85.22","2020-01-02 15:54:20","2020-01-02 15:55:09","","","","1","0000-00-00 00:00:00","2019-04-23 10:51:35","0000-00-00 00:00:00","","","ALHAJI ABUBAKAR MUSA WUSHISHI","08086624369","OFF OKADA ROAD MINNA,NIGER STATE","FATHER","3","ALHAJI ABUBAKAR MUSA WUSHISHI","OFF OKADA ROAD MINNA,NIGER STATE","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0031","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("4","0","1","0","0","10","21","1","10","21","0004","0","0","27","546","","FATIMA MUHAMMAD","09026270805","","","2019-05-01-132253Fatima Mohammed.pdf.pdf.pdf","F","1","Nigerian","21","3","1994","married","","","","muhammadfatima456@gmail.com","","Niger","09026270805","","Plot 54, New Flayout, beside Al-Ali International School, Minna","Plot 54, New Flayout, beside Al-Ali International School, Minna","2019-05-01-131937.jpeg","Normal","O","None","Nil","1","0","0","105.112.115.177","2020-01-16 14:09:37","2020-01-16 14:09:47","","","","1","0000-00-00 00:00:00","2019-04-23 14:40:20","0000-00-00 00:00:00","","","Mallam Muhammad Ndagi","08065391480","Plot 54, New Flayout, beside Al-Ali International School, Minna","Father","4","Self","Plot 54, New Flayout, beside Al-Ali International School, Minna","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0354","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("5","0","0","0","0","0","0","1","4","13","0005","0","0","0","0","","Nakordi Madami","","","","","","0","","","","","","","","","abdulmuhdboku@gmail.com","","","08065311306","","","","","","","","","1","1","0","197.210.52.20","2019-04-23 18:26:13","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-04-23 18:25:25","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("6","0","1","0","0","10","20","1","10","20","0006","0","0","27","543","","IBRAHIM ISHAQ","08168670724","","","2019-04-24-125540Scan Documents.pdf.pdf","M","1","Nigerian","1","1","1993","single","","","","mrbreman78@gmail.com","","Minna","08168670724","","Western Bye pass Opposite Imurat International , Minna, Niger State","Western Bye pass Opposite Imurat International , Minna, Niger State","2019-04-24-120302.jpg","Normal","O","None","NONE","1","0","0","41.190.14.202","2019-11-23 09:58:06","2019-11-23 09:58:44","","","","1","0000-00-00 00:00:00","2019-04-24 11:55:18","0000-00-00 00:00:00","","","ISAHQ ABDULRAFIU","08053439008","Western Bye pass Opposite Imurat International , Minna, Niger State","Father","1","IBRAHIM ISHAQ","Western Bye pass Opposite Imurat International , Minna, Niger State","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0008","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("7","0","0","0","0","0","0","1","4","4","0007","0","0","27","544","","ARMAYAU MUHAMMAD SANI","08061596345","","","2019-05-02-110037Documents.pdf.pdf","M","1","Nigerian","10","6","1992","single","","","","armayaumohammed@gmail.com","","Minna","08061596345","","House No. 3 Opposite FUT Minna, former Best-Way Nursery/Primary School, Bosso,  Minna, Niger State","House No. 3 Opposite FUT Minna, former Best-Way Nursery/Primary School, Bosso,  Minna, Niger State","2019-04-24-194056.jpg","Normal","O","None","NONE","1","0","0","41.203.73.159","2019-09-19 11:46:37","2019-09-19 11:47:01","","","","0","0000-00-00 00:00:00","2019-04-24 19:39:49","0000-00-00 00:00:00","","","MUHAMMAD SANI","08061596345","House No. 3 Opposite FUT Minna, former Best-Way Nursery/Primary School, Bosso,  Minna, Niger State","FATHER","1","ARMAYAU MUHAMMAD SANI","House No. 3 Opposite FUT Minna, former Best-Way Nursery/Primary School, Bosso,  Minna, Niger State","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("8","0","0","0","0","0","0","1","4","13","0008","0","0","27","551","","Mohammed Ibrahim Dabban","08068162104","","","2019-04-30-110832DOCN.pdf.pdf","M","1","Nigerian","22","4","1982","married","","","","ibrahimdabban2016@gmail.com","","Dabban","08068162104","","No 33, Dabban Avenue Zango  Bwari Abuja","No. 4 Langifu Dabban Lavun Niger State","2019-04-30-103917.jpg","Normal","O","None","","1","1","0","41.203.73.234","2020-01-22 17:52:36","2019-09-23 20:26:53","","","","1","0000-00-00 00:00:00","2019-04-25 09:37:12","0000-00-00 00:00:00","","","Engr. Ahmed Muhammadu","No. 4 Langifu Dabban Lavun Niger State","No. 4 Langifu Dabban Lavun Niger State","Father","3","Mohammed Ibrahim Dabban","No 33, Dabban Avenue Zango  Bwari Abuj","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("9","0","0","0","0","0","0","1","10","21","0009","0","0","27","550","","YAKUBU ABDULLAHI ALIYU","07061159236","","","2019-04-25-105227ALIYU DOCUMENTS.pdf.pdf","M","1","Nigerian","27","7","1994","single","","","","aliyuyakubu2019@yaho.com","","MINNA","07061159236","","OFF OKADA ROAD BAUCHI STREET HOUSE NO4 MINNA,NIGER STATE","OFF OKADA ROAD BAUCHI STREET HOUSE NO4 MINNA,NIGER STATE","2019-04-25-104206.jpg","Normal","B+","None","NIL","1","0","0","41.203.73.210","2019-10-26 19:11:37","2019-10-26 19:11:50","","","","1","0000-00-00 00:00:00","2019-04-25 10:33:19","0000-00-00 00:00:00","","","ALIYU ABDULLAHI","07016687348","OFF OKADA ROAD BAUCHI STREET HOUSE NO4 MINNA,NIGER STATE","FATHER","3","ALIYU ABDULLAHI","OFF OKADA ROAD BAUCHI STREET HOUSE NO4 MINNA,NIGER STATE","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("10","0","1","0","0","2","2","1","2","2","0010","0","0","27","541","","KHADIJA ABUBAKAR","08109263240","","","2019-04-29-212821Documents.pdf.pdf","F","1","Nigerian","6","11","2001","single","","","","khadijaabubakar2612@gmail.com","","New Bussa","08109263240","","Edduma Microfinance Bank Bida, Niger state","Opposite Hajj Camp Tudun Fulani Bosso, Minna, Niger State","2019-04-25-132553.jpg","Normal","O","None","NONE","1","0","0","197.210.54.221","2019-10-13 20:21:44","2019-10-13 20:22:01","","","","1","0000-00-00 00:00:00","2019-04-25 12:04:03","0000-00-00 00:00:00","","","ABUBAKAR A.S GARBA","08032906565","Edduma Microfinance Bank Bida, Niger state","FATHER","1","ABUBAKAR A.S GARBA","Edduma Microfinance Bank Bida, Niger state","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("11","0","1","0","0","1","11","1","1","11","0011","0","0","27","560","","MOHAMMED YAHAYA KUTA","07038310269","","","","M","1","Nigerian","8","7","1975","married","","","","angoaliyu76@yahoo.com","","SHIRORO","07038310269","","ALKALI HOUSE SABON GARI, KUTA","","","Normal","O","None","","1","0","0","105.112.114.140","2020-01-16 09:23:39","2020-01-16 09:24:17","","","","1","0000-00-00 00:00:00","2019-04-26 11:15:04","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0161","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("12","0","1","0","0","1","10","1","1","10","0012","0","0","27","560","","MADAKI AFINIKI","08145085539","","","","F","2","Nigerian","25","4","1974","married","","","","angoaliyu76@yahoo.com","","SHIRORO","08145085539","","ERENA, SHIRORO LOCAL GOVERNMENT ","","","Normal","O","None","","1","0","0","197.210.84.253","2020-01-14 20:42:42","2020-01-14 20:43:07","","","","1","0000-00-00 00:00:00","2019-04-26 11:27:26","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0160","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("13","0","0","0","0","0","0","1","7","16","0013","0","0","27","563","","ISYAKU ABDULLAHI","08036807759","","","","M","1","Nigerian","2","1","1981","married","","","","balasupply42@gmail.com","","WUSHISHI","08036807759","","PLOT 415 OFF ADAMAWA ROAD, DUTSEN KURAN HAUSA","","","Normal","B+","None","","1","0","0","197.210.55.215","2019-06-03 13:05:01","2019-06-03 13:05:53","","","","1","0000-00-00 00:00:00","2019-04-26 11:41:18","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("14","0","1","0","0","1","10","1","1","10","0014","0","0","27","544","","SULEIMAN AMINA","08067984241","","","","F","1","Nigerian","26","4","1975","married","","","","aminasuleiman2675@gmail.com","","CHANCHAGA","08067984241","","137, MUSTAPHA BABANGIDA ROAD TUNGA, MINNA","","","Normal","B+","None","","1","1","0","197.210.84.253","2020-01-14 21:16:34","2020-01-02 14:52:53","","","","1","0000-00-00 00:00:00","2019-04-26 11:51:28","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0127","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("15","0","1","0","0","10","21","1","10","21","0015","0","0","27","544","","ABDULLAHI HALIMA","07030700229","","","","F","1","Nigerian","21","10","1997","single","","","","haleemah496@gmail.com","","CHANCHAGA","07030700229","","USMAN NAGOGO STREET BARIKIN SALEH MINNA","","2019-09-19-155223.jpg","Normal","O","None","","1","0","0","105.112.112.20","2020-01-28 16:34:58","2020-01-28 16:35:07","","","","1","0000-00-00 00:00:00","2019-04-26 12:00:29","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0039","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("16","0","1","0","0","2","15","1","2","15","0016","0","0","27","549","","ABDULLAHI BASHIR","07030072512","","","","M","1","Nigerian","5","5","1983","married","","","","kontagora4real@gmail.com","","KONTAGORA","07030072512","","NO 39 DR. YAHAYA BAWA BOSSO STREET UNGUWAN BIRI BOSSO, MINNA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 13:04:42","2020-01-16 13:04:53","","","","1","0000-00-00 00:00:00","2019-04-26 12:09:42","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0105","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("17","0","1","0","0","2","15","1","2","15","0017","0","0","27","560","","ABDULLAHI MOHAMMED DADA","08035993204","","","2019-04-29-101129Documents.pdf.pdf","M","1","Nigerian","17","3","1980","married","","","","abdulehsan1@gmail.com","","Minna","08035993204","","Tunga Opposite Mobile Quarters, Minna, Niger State","Tunga Opposite Mobile Quarters, Minna, Niger State","2019-04-26-122716.jpg","Normal","O","None","NONE","1","0","0","105.112.115.177","2020-01-16 12:52:46","2020-01-16 12:52:56","","","","1","0000-00-00 00:00:00","2019-04-26 12:09:42","0000-00-00 00:00:00","","","AISHA ABDULLAHI ERENA","08032100432","Tunga Opposite Mobile Quarters, Minna, Niger State","WIFE","1","ABDULLAHI MOHAMMED DADA","Tunga Opposite Mobile Quarters, Minna, Niger State","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0111","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("18","0","1","0","0","4","12","1","4","12","0018","0","0","27","560","","YUSUF GALADIMA NUHU","08062231212","","","","M","1","Nigerian","15","6","1988","married","","","","nyg4real@yahoo.com","","SHIRORO","08062231212","","OPPOSITE MYPA JUNCTION BESIDE KAMMAR HOTEL BOSSO, MINNA","","2019-09-20-112206.jpg","Normal","A+","None","","1","0","0","105.112.115.177","2020-01-16 12:43:13","2020-01-16 12:44:13","","","","1","0000-00-00 00:00:00","2019-04-26 12:17:50","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0019","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("19","0","1","0","0","7","16","1","2","14","0019","0","0","27","543","","UMAR AMINU TUKURA","07063181117","","","","M","1","Nigerian","5","6","1988","single","","","","aminuumartukura@gmail.com","","BOSSO","07063181117","","DUTSEN KURAN GWARI, KWASAU MYPA COLLEGE JUNCTON, MINNA","","","Normal","O","None","","1","0","0","105.112.112.20","2020-01-28 16:24:41","2020-01-28 16:24:57","","","","1","0000-00-00 00:00:00","2019-04-26 12:28:36","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-03 08:25:20","0485","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("20","0","1","0","0","1","10","1","1","10","0020","0","0","27","541","","ALHASSAN UMAR","07030994004","","","","M","1","Nigerian","25","3","1991","married","","","","hassanu783@gmail.com","","BIDA","07030994004","","GRA EXTENTION BIDA ","","","Normal","O","None","","1","0","0","105.112.113.95","2020-01-15 10:23:24","2020-01-15 10:23:54","","","","1","0000-00-00 00:00:00","2019-04-26 12:36:58","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0194","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("21","0","1","0","0","4","12","1","4","13","0021","0","0","27","548","","WACHIKO MOHAMMED MUSA","07037757410","","","","M","1","Nigerian","16","10","1971","married","","","","wachikomohdmusa@gmail.com","","katcha","07037757410","","makarat","","","Normal","O","None","","1","0","0","105.112.112.20","2020-01-28 16:03:38","2020-01-28 16:03:58","","","","1","0000-00-00 00:00:00","2019-04-26 12:44:34","0000-00-00 00:00:00","","","","","MAKARATAKO TAKO GBAKO BADEGGI","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2020-01-03 12:16:04","0020","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("22","0","1","0","0","2","15","1","2","15","0022","0","0","27","551","","TSADO KASHI JESSICA","08034510227","","","","F","2","Nigerian","27","4","1967","married","","","","ikdrewkay@gmail.com","","LAVUN","08034510227","","FABULOUS ESTATE, OFF SADIA ROAD SAUKA KAHUTA MINNA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 13:01:00","2020-01-16 13:01:12","","","","1","0000-00-00 00:00:00","2019-04-26 12:55:27","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0361","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("23","0","1","0","0","10","21","1","10","21","0023","0","0","27","544","","RILWAN ABDULLAHI","08135952436","","","","M","1","Nigerian","17","5","1988","married","","","","princeabdul5050@gmail.com","","CHANCHAGA","08135952436","","HOUSE NO. 84 KPAKUNGU OPP CENTRAL MOSQUE MINNA","","","Normal","O","None","","1","0","0","197.210.65.223","2020-01-03 12:37:01","2020-01-03 12:37:34","","","","1","0000-00-00 00:00:00","2019-04-26 13:05:17","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0363","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("24","0","1","0","0","4","12","1","4","12","0024","0","0","27","543","","YUSUF MOMBAI ESTHER","08062435623","","","","F","2","Nigerian","21","10","1984","married","","","","angoaliyu76@yahoo.com","","BOSSO","08062435623","","DUTSEN KURA GWARI, OPPOSITE KWASAU PRIMARY SCHOOL MINNA","","","Normal","O","None","","1","0","0","197.210.65.202","2020-01-02 20:25:34","2020-01-02 20:26:07","","","","1","0000-00-00 00:00:00","2019-04-26 13:18:49","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-03 07:56:24","0439","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("25","0","1","0","0","4","12","1","4","12","0025","0","0","27","539","","YUNUSA MUSA","08032911954","","","2019-09-19-163241MUSA CREDENTIALS.pdf.pdf","M","1","Nigerian","1","2","1991","single","","","","angoaliyu76@yahoo.com","","AGAIE","08032911954","","IC3 IDRIS ALHASSAN  ROAD OLD AIRPORT QUARTERS MINNA","","2019-09-19-152341.jpg","Normal","O","None","","1","0","0","197.210.47.225","2020-01-02 23:48:47","2020-01-02 23:49:21","","","","1","0000-00-00 00:00:00","2019-04-26 13:28:20","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0021","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("26","0","1","0","0","9","18","1","9","18","0026","0","0","27","545","","IDRIS IDRIS","08065680286","","","","M","1","Nigerian","3","4","1978","married","","","","idrisgbamache@gmail.com","","EDATI","08065680286","","S.W 363 KETEREN GWARI ROAD MINNA","","","Normal","O","None","","1","0","0","197.210.85.77","2020-02-08 15:22:27","2020-02-08 15:24:16","","","","1","0000-00-00 00:00:00","2019-04-26 13:36:21","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0134","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("27","0","1","0","0","10","21","1","10","21","0027","0","0","27","544","","ALIYU MOHAMMED","08135949896","","","","M","1","Nigerian","2","2","1992","single","","","","mohammedsaifullahi30@gmail.com","","CHANCHAGA","08135949896","","TUNGA FARM CENTER OPPOSITE CBN QUARTERS PAIKO ROAD MINNA","","","Normal","O","None","","1","0","0","197.210.55.215","2019-06-03 13:33:36","2019-06-03 13:34:05","","","","1","0000-00-00 00:00:00","2019-04-26 13:48:40","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0040","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("28","0","1","0","0","2","14","1","2","14","0028","0","0","27","544","","INUWA JIBRIN","08065713568","","","","M","1","Nigerian","11","5","1989","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08065713568","","NIKANGBE ALONG BIDA ROAD","","","Normal","B+","None","","1","0","0","105.112.115.177","2020-01-16 12:53:47","2020-01-16 12:53:57","","","","1","0000-00-00 00:00:00","2019-04-26 14:22:30","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0123","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("29","0","0","0","0","0","0","1","10","21","0029","0","0","27","550","","ALIYU IDRIS","08030592901","","","","M","1","Nigerian","12","2","1990","married","","","","angoaliyu76@yahoo.com","","LAPAI","08030592901","","NO4 BUCHI STREET OFF OKADA ROAD MINNA","","","Normal","O","None","","1","0","0","197.210.227.72","2019-06-10 08:12:27","2019-06-10 08:13:02","","","","1","0000-00-00 00:00:00","2019-04-26 14:30:20","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("30","0","0","0","0","0","0","1","10","21","0030","0","0","0","0","","0@gmail.com","","","","","","0","","","","","","","","","sandausman90@gmail.com","","","07031183052","","","","","","","","","1","0","0","197.210.54.121","2019-04-26 14:38:06","2019-04-26 14:39:53","","","","0","0000-00-00 00:00:00","2019-04-26 14:37:44","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("31","0","1","0","0","2","14","1","2","14","0031","0","0","27","541","","KUDU MOHAMMED ASMAU","08065891792","","","","F","1","Nigerian","15","7","1983","married","","","","angoaliyu76@yahoo.com","","BIDA","08065891792","","BEHIND QUEEN VIEW ACADEMY FADIKPE MINNA ","","","Normal","A+","None","","1","0","0","105.112.115.177","2020-01-16 13:05:00","2020-01-16 13:05:09","","","","1","0000-00-00 00:00:00","2019-04-26 14:42:13","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0260","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("32","0","1","0","0","2","15","1","2","15","0032","0","0","27","539","","MUHAMMAD KPOTUN TUKUR","08063952086","","","","M","1","Nigerian","10","10","1970","married","","","","angoaliyu76@yahoo.com","","AGAIE","08063952086","","EMI TSADUYA, AGAIE EKOWUGI WARD, AGAIE","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 13:04:15","2020-01-16 13:04:23","","","","1","0000-00-00 00:00:00","2019-04-26 14:50:06","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0399","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("33","0","1","0","0","7","16","1","7","16","0033","0","0","27","544","","GARBA MAIBASIRA ABBAS","08036561580","","","","M","1","Nigerian","15","6","1978","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08036561580","","NW 25A LIMAWA ROAD MINNA","","","Normal","O","None","","1","0","0","197.210.64.13","2020-01-02 22:19:04","2020-01-02 22:19:39","","","","1","0000-00-00 00:00:00","2019-04-26 15:01:39","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0015","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("34","0","1","0","0","4","12","1","4","12","0034","0","0","27","563","","MAIMUNA IBRAHIM","08036209307","","","","F","1","Nigerian","15","3","1976","married","","","","angoaliyu76@yahoo.com","","WUSHISHI","08036209307","","ANGUWAR SARKI ZUNGERU","","","Normal","O","None","","1","0","0","197.210.85.22","2020-01-02 15:51:41","2020-01-02 15:52:15","","","","1","0000-00-00 00:00:00","2019-04-26 15:11:36","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0109","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("35","0","1","0","0","9","18","1","9","18","0035","0","0","27","544","","SANI AHMED AMINU","08034554605","","","","M","1","Nigerian","25","5","1993","single","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08034554605","","TUNGA BAY CLINIC ROAD, MINNA","","","Normal","O","None","","1","0","0","197.210.45.38","2020-01-03 15:07:11","2020-01-03 15:07:42","","","","1","0000-00-00 00:00:00","2019-04-26 15:24:48","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0034","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("36","0","1","0","0","10","21","1","10","21","0036","0","0","27","557","","USMAN SANDA","07031183052","","","","M","1","Nigerian","25","8","1991","single","","","","angoaliyu76@yahoo.com","","PAIKORO","07031183052","","YANDAYI","","","Normal","O","None","","1","0","0","197.210.47.207","2020-01-02 23:23:11","2020-01-02 23:23:39","","","","1","0000-00-00 00:00:00","2019-04-26 15:33:12","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0192","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("37","0","1","0","0","4","12","1","2","14","0037","0","0","27","542","","MOHAMMED SULEIMAN","08112527942","","","","M","1","Nigerian","3","3","1973","married","","","","angoaliyu76@yahoo.com","","BORGU","08112527942","","SWASHI MAIN ROAD","","","Normal","O","None","","1","0","0","105.112.112.20","2020-01-28 16:05:15","2020-01-28 16:05:38","","","","1","0000-00-00 00:00:00","2019-04-26 15:39:14","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2019-12-13 10:31:32","0523","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("38","0","1","0","0","1","10","1","1","10","0038","0","0","27","544","","SARKI VICTOR ANDREW","08069714145","","","","M","2","Nigerian","2","8","1989","single","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08069714145","","SP82 SAYAKO, ALONG MAITUMBI ROAD MINNA","","","Normal","O","None","","1","0","0","105.112.113.95","2020-01-15 12:03:41","2020-01-15 12:08:05","","","","1","0000-00-00 00:00:00","2019-04-26 15:44:29","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0188","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("39","0","1","0","0","2","15","1","2","15","0039","0","0","27","543","","JOHN GODWIN","08036377539","","","","M","2","Nigerian","9","10","1994","single","","","","angoaliyu76@yahoo.com","","BOSSO","08036377539","","OFF TOP MEDICAL ROAD, MINNA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 12:53:29","2020-01-16 12:53:38","","","","1","0000-00-00 00:00:00","2019-04-26 15:51:23","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0122","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("40","0","1","0","0","9","18","1","9","18","0040","0","0","27","544","","KABIRU SHUAIBU","08035837399","","","","M","1","Nigerian","11","10","1984","married","","","","kabirufulani507@gmail.com","","CHANCHAGA","08035837399","","621 BOSSO JAFARU MAIRIGA STREET BOSSO AREA","","","Normal","O","None","","1","0","0","197.210.45.38","2020-01-03 13:57:19","2020-01-03 13:57:49","","","","1","0000-00-00 00:00:00","2019-04-29 13:52:12","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0040","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("41","0","1","0","0","4","4","1","4","4","0041","0","0","27","544","","MUHAMMAD FATIMA","07036017090","","","","F","1","Nigerian","2","1","1990","married","","","","fatinamagaru@gmail.com","","CHANCHAGA","07036017090","","SHIRORO ROAD, HOUSE NO 1 MINNA","","","Normal","O","None","","1","0","0","105.112.112.20","2020-01-28 16:14:54","2020-01-28 16:15:09","","","","1","0000-00-00 00:00:00","2019-04-29 14:00:33","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0396","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("42","0","0","0","0","0","0","1","10","20","0042","0","0","27","544","","TEMURU GRACE","08135188167","","","","F","2","Nigerian","29","9","1997","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08135188167","","41 MECHANIC JUNCTION OLD WADATA CHANCHAGA, MINNA","","","Normal","AB","None","","1","0","0","197.210.227.141","2019-06-10 08:21:12","2019-06-10 08:21:35","","","","1","0000-00-00 00:00:00","2019-04-29 14:06:32","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("43","0","1","0","0","2","14","1","2","14","0043","0","0","27","542","","USMAN GARBA","07039062352","","","","M","1","Nigerian","14","9","1979","married","","","","angoaliyu76@yahoo.com","","BORGU","07039062352","","OPP. UBA NEW BUSSA","","","Normal","A+","None","","1","0","0","197.210.226.235","2019-06-10 08:21:44","2019-06-10 08:22:08","","","","1","0000-00-00 00:00:00","2019-04-29 14:11:36","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("44","0","1","0","0","9","18","1","10","21","0044","0","0","27","544","","AHMED BILYAMINU","08065904053","","","","M","1","Nigerian","22","4","1985","married","","","","ahmedbilyaminu@yahoo.com","","CHANCHAGA","08065904053","","ANGUWAN GWARI CHANCHAGA, MINNA","","","Normal","A+","None","","1","0","0","197.210.226.253","2020-02-07 17:47:15","2020-02-07 17:48:25","","","","1","0000-00-00 00:00:00","2019-04-29 14:24:24","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2019-12-06 15:32:03","0666","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("45","0","1","0","0","1","10","1","1","10","0045","0","0","27","541","","MUHAMMAD AISHA RAJI","07031545145","","","","M","1","Nigerian","27","9","1986","married","","","","angoaliyu76@yahoo.com","","BIDA","07031545145","","EMI ALHAJI IBRAHIM SAUKI AREA BIDA","","","Normal","A+","None","","1","0","0","105.112.113.95","2020-01-15 10:43:05","2020-01-15 10:43:29","","","","1","0000-00-00 00:00:00","2019-04-29 14:33:37","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0332","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("46","0","1","0","0","2","2","1","2","2","0046","0","0","27","557","","BALA SALAMATU","08134329616","","","","F","1","Nigerian","5","7","1993","married","","","","sweetysalamanas@gmail.com","","PAIKORO","08134329616","","OPPOSITE TAYI JUMMAT MOSQUE MINNA","","","Normal","B+","None","","1","0","0","197.210.70.15","2020-02-04 17:29:15","2020-02-04 17:30:51","","","","1","0000-00-00 00:00:00","2019-04-29 14:43:33","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0147","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("47","0","0","0","0","0","0","1","2","14","0047","0","0","27","560","","ALIYU SANUSI","08025691378","","","","M","1","Nigerian","14","4","1992","single","","","","sanusialiyu099@gmail.com","","SHIRORO","08025691378","","BAHAGO BISI GWADA","","","Normal","O","None","","1","0","0","197.210.226.235","2019-06-10 08:24:22","2019-06-10 08:24:36","","","","1","0000-00-00 00:00:00","2019-04-29 14:49:55","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("48","0","1","0","0","1","1","1","1","1","0048","0","0","27","548","","MOHAMMED AHMED BALA","07036874549","","","2019-09-25-134954CREDENICALS.pdf.pdf","M","1","Nigerian","20","10","1989","married","","","","angoaliyu76@yahoo.com","","KATCHA","07036874549","","EMI ALH. MOHAMMED KPAKUNGU, OPPOSITE POLICE STATION MINNA","","2019-09-25-134849.jpg","Normal","B+","None","","1","0","0","197.210.226.205","2020-02-05 15:03:19","2020-02-05 15:05:44","","","","1","0000-00-00 00:00:00","2019-04-29 14:55:36","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0143","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("49","0","1","0","0","4","13","1","4","13","0049","0","0","27","550","","MOHAMMED ALHAJI HALIRU","08036248738","","","","M","1","Nigerian","1","5","1976","married","","","","angoaliyu76@yahoo.com","","LAPAI","08036248738","","TAYI VILLAGE AT THE BACK OF EL AMIN BAKERY MINNA","","","Normal","O","None","","1","0","0","105.112.112.20","2020-01-28 15:53:25","2020-01-28 15:53:46","","","","1","0000-00-00 00:00:00","2019-04-29 15:02:51","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0036","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("50","0","1","0","0","2","14","1","2","14","0050","0","0","27","547","","MUHAMMAD ALIYU ZAINAB","07056613800","","","","F","1","Nigerian","4","6","1982","married","","","","angoaliyu76@yahoo.com","","GURARA","07056613800","","S.E 98E SABON GARI MINNA","","","Normal","A+","None","","1","0","0","197.210.65.0","2020-01-02 21:43:31","2020-01-02 21:44:56","","","","1","0000-00-00 00:00:00","2019-04-29 15:11:00","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-10-30 09:54:26","0374","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("51","0","1","0","0","2","15","1","2","15","0051","0","0","27","544","","HUSSAINI MOHAMMED","08036088583","","","","M","1","Nigerian","27","1","1976","married","","","","mohammedhuss001@gmail.com","","CHANCHAGA","08036088583","","NO. 20 SULEIMAN HUSSAINI AVENUE, WESTERN BYE PASS MINNA","","","Normal","A+","None","","1","0","0","105.112.115.177","2020-01-16 12:55:25","2020-01-16 12:55:34","","","","1","0000-00-00 00:00:00","2019-04-29 15:17:44","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0045","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("52","0","1","0","0","1","10","1","1","10","0052","0","0","27","557","","ABUBAKAR NASIRU","08065172949","","","","M","1","Nigerian","14","2","1980","married","","","","nasiruabubakar159@gmail.com","","PAIKORO","08065172949","","GALADIMA YANDAYI HOUSE NO 005 PAIKO VILLAGE ","","","Normal","O","None","","1","0","0","105.112.113.95","2020-01-15 10:30:07","2020-01-15 10:30:24","","","","1","0000-00-00 00:00:00","2019-04-29 15:26:16","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0010","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("53","0","1","0","0","10","21","1","10","21","0053","0","0","27","543","","HAMZA ABDUL-WAHAB","08063207761","","","","M","1","Nigerian","30","10","1996","married","","","","adeyimikaeasy1@gmail.com","","BOSSO","08063207761","","CHAN CH II/3II ANGUWAN GWARI CLOSE TO BLESSED AMBASSADOR SCHOOL, CHANCHAGA MINNA","","","Normal","O","None","","1","0","0","197.210.54.187","2019-07-03 14:49:25","2019-07-03 14:50:08","","","","1","0000-00-00 00:00:00","2019-04-29 15:35:13","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("54","0","1","0","0","10","20","1","10","20","0054","0","0","27","558","","SHAHABUDEEN HABIBA","08144528806","","","","F","1","Nigerian","20","9","1997","married","","","","angoaliyu76@yahoo.com","","M","08144528806","","KUCH AFAKALLA PLAZA TAYI MINNA","","","Normal","B+","None","","1","0","0","197.210.45.38","2020-01-03 13:46:42","2020-01-03 13:47:20","","","","1","0000-00-00 00:00:00","2019-04-29 15:42:17","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0037","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("55","0","0","0","0","0","0","1","10","21","0055","0","0","0","0","","UMAR HUSSAINI","","","","","","0","","","","","","","","","gogohama01@yahoo.com","","","07086861163","","","","","","","","","1","0","0","197.210.52.166","2019-10-09 20:49:41","2019-10-09 20:49:52","","","","0","0000-00-00 00:00:00","2019-04-29 15:43:51","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("56","0","1","0","0","7","5","1","7","5","0056","0","0","27","539","","AISHA MOHAMMED MAHMUD","08146349927","","","2019-04-30-095313AISHA 12.pdf.pdf","F","1","Nigerian","13","11","2001","married","","","","aishammahmud@gmail.com","","MINNA","08146349927","","HOUSE NO 150 BOSSO LOW-COST MINNA, NIGER STATE","HOUSE NO 150 BOSSO LOW-COST MINNA, NIGER STATE","2019-04-30-094939.jpg","Normal","O","None","Good","1","0","0","197.210.47.190","2020-01-02 22:27:00","2020-01-02 22:27:41","","","","1","0000-00-00 00:00:00","2019-04-29 17:16:06","0000-00-00 00:00:00","","","USMAN MAHMUD","08168171744","HOUSE NO 150 BOSSO LOW-COST MINNA, NIGER STATE","UNCLE","3","USMAN MAHMUD","HOUSE NO 150 BOSSO LOW-COST MINNA, NIGER STATE","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0048","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("57","0","0","0","0","0","0","1","7","5","0057","0","0","0","0","","AISHA MOHAMMED MAHMUD","","","","","","0","","","","","","","","","aishammahmud@gmail.com","","","08146349927","","","","","","","","","1","0","0","197.210.60.206","2019-11-13 19:54:02","2019-11-13 19:54:52","","","","0","0000-00-00 00:00:00","2019-04-29 17:25:56","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("58","0","0","0","0","0","0","1","7","5","0058","0","0","0","0","","AISHA MOHAMMED MAHMUD","","","","","","0","","","","","","","","","aishammahmud@gmail.com","","","08146349927","","","","","","","","","1","0","0","197.210.53.134","2019-10-09 20:45:42","2019-10-09 20:46:53","","","","0","0000-00-00 00:00:00","2019-04-29 17:26:23","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("59","0","1","0","0","4","13","1","4","13","0059","0","0","27","539","","Usman Mohammed ","07033366720","","","2019-05-09-152959Scan May 9, 2019 (1).pdf.pdf","M","1","Nigerian","28","2","1976","married","","","","umd813@gmail.com","","Minna ","07033366720","","S. W. 243 Hospital Road, Minna, Niger State ","S. W.  243 Hospital Road, Minna, Niger State ","2019-04-30-145339.jpg","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 11:29:21","2020-01-16 11:29:52","","","","1","0000-00-00 00:00:00","2019-04-29 17:29:23","0000-00-00 00:00:00","","","Zubairu K. Hussain ","0803 780 5062","Niger State Local Government Service Commission, Minna, Niger State ","Brother ","1","Self","Niger State Universal Basic Education Board, Minna. ","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0061","16","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("60","0","0","0","0","0","0","1","10","21","0060","0","0","0","0","","SANI MOHAMMED AWWAL","","","","","","0","","","","","","","","","sanimohammadawwal@gmail.com","","","08163389084","","","","","","","","","1","0","0","197.210.53.181","2019-10-09 20:48:03","2019-10-09 20:48:18","","","","0","0000-00-00 00:00:00","2019-04-29 18:04:24","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("61","0","0","0","0","0","0","1","9","6","0061","0","0","0","0","","FOLASHADE IGUNNUGBEMI","","","","","","0","","","","","","","","","shadelilous61@gmail.com","","","08180647661","","","","2019-04-29-193842.jpg","","","","","1","0","0","41.190.12.91","2019-04-29 19:32:12","2019-04-29 19:45:38","","","","0","0000-00-00 00:00:00","2019-04-29 19:28:28","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("62","0","0","0","0","0","0","1","2","14","0062","0","0","0","0","","UBAIDAT IBRAHIM","","","","","","0","","","","","","","","","ibrahimubaidat463@yahoo.com","","","09031952745","","","","2019-04-29-200422.jpg","","","","","1","0","0","41.190.12.91","2019-04-29 20:01:11","2019-04-29 20:09:07","","","","0","0000-00-00 00:00:00","2019-04-29 20:00:32","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("63","0","0","0","0","0","0","1","4","13","0063","0","0","0","0","","Abu Ahmed","","","","","","0","","","","","","","","","abuahmed12@yahoo.com","","","08036078394","","","","","","","","","1","0","0","105.112.121.100","2019-11-20 14:16:44","2019-11-20 14:17:08","","","","0","0000-00-00 00:00:00","2019-04-29 20:04:18","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("64","0","0","0","0","0","0","1","1","11","0064","0","0","17","304","","UWALAKA UGOCHUKWU PHILIP","08032800683","","","","M","2","Nigerian","15","9","1988","single","","","","philipope6@gmail.com","","IMO STATE","08032800683","","40 top medical tunga minna  Niger state ","House 8 43B akpan  s j close sahara 2 estate logokoma FCT ","2019-04-29-230201.jpg","Normal","AB","None","Normal","1","0","0","197.210.53.226","2019-09-20 15:45:32","2019-09-20 15:45:39","","","","0","0000-00-00 00:00:00","2019-04-29 22:58:21","0000-00-00 00:00:00","","","Uwalaka George","0703 573 4550","Umuike amafor imerienwe ngor okpala LGA IMO state ","Father ","4","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("65","0","0","0","0","0","0","1","4","13","0065","0","0","27","553","","UMAR M SHEHU","08023410333","","","2019-04-30-133013DN.pdf.pdf","M","1","Nigerian","11","9","1986","married","","","","iumarmshehu007@gmail.com","","mariga","08023410333","","BEHIND CENTRAL POLICE STATION MARIGA ","BEHIND CENTRAL POLICE STATION MARIGA","2019-04-30-131351.jpg","Normal","O","None","","1","0","0","105.112.113.17","2019-09-28 14:59:50","2019-09-28 15:00:09","","","","1","0000-00-00 00:00:00","2019-04-30 13:06:14","0000-00-00 00:00:00","","","MOHAMMED SHEHU","08024564003","BEHIND CENTRAL POLICE STATION MARIGA","BROTHER ","1","UMAR M SHEHU","BEHIND CENTRAL POLICE STATION MARIGA","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("66","0","0","0","0","0","0","1","1","11","0066","0","0","27","550","","ISAH UMAR","08106709696","","","","M","1","Nigerian","7","5","1990","married","","","","isahsoje@gmail.com","","LAPAI","08106709696","","A205 DINDIGA ROAD LAPAI, NIGER STATE","A205 DINDIGA ROAD LAPAI, NIGER STATE","2019-04-30-142121.jpg","Normal","O","None","NORMAL","1","0","0","41.203.78.145","2019-05-10 12:46:17","2019-05-10 12:46:22","","","","0","0000-00-00 00:00:00","2019-04-30 13:31:13","0000-00-00 00:00:00","","","SULEIMAN UMAR SOJE","08095190521","A205 DINDIGA ROAD LAPAI, NIGER STATE","BROTHER ","1","SELF","A205 DINDIGA ROAD LAPAI","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("67","0","0","0","0","0","0","1","2","15","0067","0","0","0","0","","AUWALU ibrahim","","","","","","0","","","","","","","","","auwaldanamana@gmail.com","","","08084847262","","","","2019-04-30-133947.jpg","","","","","1","0","0","197.210.227.95","2019-04-30 13:38:39","2019-04-30 14:00:08","","","","0","0000-00-00 00:00:00","2019-04-30 13:38:00","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("68","0","1","0","0","7","16","1","7","16","0068","0","0","27","546","","HUSSAINI SULEIMAN LEMU","07030197637","","","","M","1","Nigerian","27","2","1992","single","","","","angoaliyu76@yahoo.com","","GBAKO","07030197637","","HOUSE NO 42, ZONE 4 SHANGO","","2019-09-20-093934.jpg","Normal","O","None","","1","0","0","197.210.47.214","2020-01-02 22:24:02","2020-01-02 22:24:37","","","","1","0000-00-00 00:00:00","2019-04-30 15:22:16","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0038","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("69","0","1","0","0","4","13","1","4","13","0069","0","0","27","543","","BARUWA G. MOHAMMED","08055959811","","","","M","1","Nigerian","31","12","1970","married","","","","angoaliyu76@yahoo.com","","BOSSO","08055959811","","NEW YORK BOSSO","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 11:38:47","2020-01-16 11:38:59","","","","1","0000-00-00 00:00:00","2019-04-30 15:28:17","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-03 08:22:56","0471","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("70","0","1","0","0","7","16","1","7","16","0070","0","0","27","555","","SULEIMAN USMAN","08060292008","","","","M","1","Nigerian","20","12","1986","married","","","","angoaliyu76@yahoo.com","","MOKWA","08060292008","","BOKANI TAKO EMI TSUYANKPA","","","Normal","O","None","","1","0","0","105.112.122.37","2019-09-25 12:27:32","2019-09-25 12:27:59","","","","1","0000-00-00 00:00:00","2019-04-30 15:34:03","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("71","0","1","0","0","1","10","1","1","10","0071","0","0","27","550","","ABDULKADIR BAWA","08064988268","","","","M","1","Nigerian","6","3","1979","married","","","","angoaliyu76@yahoo.com","","LAPAI","08064988268","","MOHAMMED ARAHS HOUSE TUNGA GORO MINNA","","","Normal","A+","None","","1","0","0","105.112.113.95","2020-01-15 10:22:53","2020-01-15 10:23:08","","","","1","0000-00-00 00:00:00","2019-04-30 15:39:59","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0280","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("72","0","1","0","0","10","20","1","10","20","0072","0","0","27","543","","UMAR IBRAHIM","08035468236","","","","M","1","Nigerian","3","6","1984","married","","","","angoaliyu76@yahoo.com","","BOSSO","08035468236","","NO C64 OPPOSITE 2ND IZALA MOSQUE ALADY JUNCTION CHANCHAGA MINNA","","","Normal","A+","None","","1","0","0","197.210.65.72","2020-01-03 12:48:16","2020-01-03 12:48:45","","","","1","0000-00-00 00:00:00","2019-04-30 15:43:23","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0083","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("73","0","0","0","0","0","0","1","4","12","0073","0","0","27","560","","SAMIRA UMAR","08135949494","","","","F","1","Nigerian","25","11","1988","married","","","","angoaliyu76@yahoo.com","","SHIRORO","08135949494","","BEHIND BRIGHTER SCHOOL","","","Normal","O","None","","1","0","0","105.112.120.71","2019-12-02 14:47:18","2019-12-02 14:47:50","","","","1","0000-00-00 00:00:00","2019-04-30 15:48:25","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("74","0","1","0","0","4","13","1","4","13","0074","0","0","27","543","","TANIMU ISAH","08036367584","","","","M","1","Nigerian","3","2","1968","married","","","","angoaliyu76@yahoo.com","","BOSSO","08036367584","","BEHIND MAITUMBI PRIMARY BETWAY NURSERY AND PRIMARY SCHOOL MINNA","","","Normal","AB","None","","1","0","0","105.112.115.177","2020-01-16 11:34:24","2020-01-16 11:34:38","","","","1","0000-00-00 00:00:00","2019-04-30 15:56:27","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0297","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("75","0","1","0","0","2","14","1","2","14","0075","0","0","27","560","","JAPHETH BARNABAS","08159535888","","","","M","2","Nigerian","12","9","1995","single","","","","japhethbarnabas3003@gmail.com","","SHIRORO","08159535888","","OPP TEXACO FILLING STATION SAIKO MINNA","","","Normal","O","None","","1","0","0","197.210.64.180","2020-01-02 21:40:59","2020-01-02 21:41:55","","","","1","0000-00-00 00:00:00","2019-04-30 16:01:34","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0009","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("76","0","1","0","0","10","22","1","10","22","0076","0","0","27","560","","MUSTAPHA ADAMU ALHASSAN","08064469443","","","","M","1","Nigerian","3","5","1973","married","","","","angoaliyu76@yahoo.com","","SHIRORO","08064469443","","POLICE SECONDARY SCHOOL","","","Normal","AB","None","","1","1","0","105.112.112.20","2020-01-28 14:20:35","2020-01-16 14:10:06","","","","1","0000-00-00 00:00:00","2019-04-30 16:08:21","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0328","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("77","0","0","0","0","0","0","1","2","14","0077","0","0","27","539","","MUHAMMAD NDAMAN MUHAMMAD","08103174782","","","","M","1","Nigerian","25","5","1998","single","","","","angoaliyu76@yahoo.com","","AGAIE","08103174782","","BEHIND SUPREME WATER KPAKUNGU","","","Normal","O","None","","1","0","0","197.210.227.72","2019-06-10 08:34:48","2019-06-10 08:35:21","","","","1","0000-00-00 00:00:00","2019-04-30 16:14:26","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("78","0","1","0","0","2","15","1","2","15","0078","0","0","27","563","","MOHAMMED MUSA DAN\'AZUMI","08036838012","","","","M","1","Nigerian","10","10","1979","married","","","","angoaliyu76@yahoo.com","","WUSHISHI","08036838012","","MD HOUSE NO 2 GADAN TULU RAILWAY STATION ZUNGERU","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 12:57:52","2020-01-16 12:58:05","","","","1","0000-00-00 00:00:00","2019-04-30 16:20:44","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0108","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("79","0","1","0","0","4","12","1","4","12","0079","0","0","27","541","","MOHAMMED ALHAJI BABA","08065133713","","","","M","1","Nigerian","12","5","1982","married","","","","angoaliyu76@yahoo.com","","BIDA","08065133713","","HOUSE NO816N GUDUKO VIA MOKWALLA AREA BIDA","","","Normal","O","None","","1","0","0","197.210.60.119","2020-01-03 10:25:00","2020-01-03 10:25:35","","","","1","0000-00-00 00:00:00","2019-04-30 16:29:00","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0216","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("80","0","1","0","0","4","4","1","4","4","0080","0","0","27","557","","ABDULAZEEZ HASSANA DAUDA","08054440885","","","","F","1","Nigerian","3","3","1992","married","","","","angoaliyu76@yahoo.com","","PAIKORO","08054440885","","29, OPP MAGIJIRAJE COURT PAIKO","","","Normal","B+","None","","1","0","0","105.112.115.194","2020-01-29 08:41:59","2020-01-29 08:44:11","","","","1","0000-00-00 00:00:00","2019-04-30 16:35:09","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-15 16:26:39","0545","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("81","0","0","0","0","0","0","1","2","14","0081","0","0","27","557","","DANLADI SAIDU","08053440292","","","","M","1","Nigerian","11","12","1978","married","","","","angoaliyu76@yahoo.com","","PAIKO","08053440292","","GBADNA AREA, PAIKO","","","Normal","O","None","","1","0","0","197.210.227.141","2019-06-10 08:37:34","2019-06-10 08:38:06","","","","1","0000-00-00 00:00:00","2019-04-30 16:40:28","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("82","0","1","0","0","7","5","1","4","12","0082","0","0","27","560","","BABANGIDA WASSA KUDODO","09094013400","","","2019-05-01-101402Doc4.pdf.pdf","M","1","Nigerian","10","10","1993","single","","","","zahradeenhumble@gmail.com","","KUDODO","09094013400","","BIHIND CUSTOMS OFFICE FARM CENTER TUNGA MINNA","BIHIND CUSTOMS OFFICE FARM CENTER TUNGA MINNA","2019-05-01-101828.jpg","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 13:54:12","2020-01-16 13:54:36","","","","1","0000-00-00 00:00:00","2019-05-01 09:09:46","0000-00-00 00:00:00","","","YUNANA PJ CHUKUBA","08034533631","BIHIND CUSTOMS OFFICE FARM CENTER TUNGA MINNA","UNCLE","4","BABANGIDA","BIHIND CUSTOMS OFFICE FARM CENTER TUNGA MINNA","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0372","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("83","0","0","0","0","0","0","1","7","5","0083","0","0","0","0","","USMAN MOHAMMED LADAN","","","","","","0","","","","","","","","","zakiremix1@gmail.com","","","08035574283","","","","2019-05-01-155057.jpg","","","","","1","0","0","197.210.44.48","2019-11-20 12:56:43","2019-11-20 14:51:47","","","","0","0000-00-00 00:00:00","2019-05-01 12:02:48","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("84","0","1","0","0","7","16","1","7","16","0084","0","0","27","543","","Ladidi Sarah Yunusa","08031845169","","","2019-05-10-081608DOC.pdf.pdf","F","2","Nigerian","27","5","1982","single","","","","chebeya2012@gmail.com","","Niger State","08031845169","","magayaki house, tagwai-dam, Minna, Niger state","magayaki house, tagwai-dam, Minna, Niger state","2019-05-09-134714.jpg","Normal","B+","None","","1","0","0","105.112.112.20","2020-01-28 16:25:27","2020-01-28 16:25:36","","","","1","0000-00-00 00:00:00","2019-05-01 14:32:26","0000-00-00 00:00:00","","","Mr & Mrs Usman Gunduma ","0802 809 4254","magayaki house, tagwai-dam, Minna, Niger state","Mother","4","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0418","1","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("85","0","0","0","0","0","0","1","7","5","0085","0","0","27","548","","USMAN MUHAMMAD LADAN","08060699637","","","","M","1","Nigerian","25","8","1995","single","","","","ladanzaki0@gmail.com","","BIDA","08060699637","","EMI LIMAN TURAKIN NUPE BIDA, NIGER STATE","EMI LIMAN TURAKIN NUPE BIDA, NIGER STATE","2019-10-03-114418.jpg","Normal","O","None","NILL","1","1","0","197.210.44.46","2019-11-21 15:28:51","2019-11-20 13:06:45","","","","0","0000-00-00 00:00:00","2019-05-01 16:17:32","0000-00-00 00:00:00","","","UMAR AUDU YARO","08098259532","EMI LIMAN TURAKIN NUPE BIDA, NIGER STATE","BROTHER","4","NIL","EMI LIMAN TURAKIN NUPE BIDA, NIGER STATE","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("86","0","1","0","0","2","2","1","2","2","0086","0","0","20","407","","IBRAHIM HAUWA","08065989103","","","2019-05-02-112014convert-jpg-to-pdf.net_2019-05-02_12-19-49.pdf.pdf","F","1","Nigerian","23","11","1992","married","","","","hauwa258@gmail.com","","Minna","08065989103","","MINNA, NIGER STATE","MINNA, NIGER STATE","2019-05-02-103242.jpg","Normal","O","None","None","1","0","0","197.210.45.38","2020-01-03 14:34:58","2020-01-03 14:35:36","","","","1","0000-00-00 00:00:00","2019-05-02 10:26:15","0000-00-00 00:00:00","","","Mahmood Mohammed Katun","08065989103","Minna, Niger State","Husband","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0228","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("87","0","0","0","0","0","0","1","4","12","0087","0","0","27","560","","ABUBAKAR ZAINAB","07063939925","","","","F","1","Nigerian","4","4","1990","married","","","","zabubakar015@gmail.com","","SHIRORO","07063939925","","NO. 2 ESTERN BYEPASS BEHIND TOP-MAN BLOCK INDUSTRY MINNA","","","Normal","O","None","","1","0","0","197.210.227.72","2019-06-10 08:39:34","2019-06-10 08:39:48","","","","1","0000-00-00 00:00:00","2019-05-02 10:48:35","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("88","0","0","0","0","0","0","1","2","15","0088","0","0","27","551","","MOHAMMED GANA ABDULLAHI","07033517885","","","","M","1","Nigerian","31","12","1968","married","","","","angoaliyu76@yahoo.com","","LAVUN","07033517885","","LAVUN LOCAL GOVERNMENT AREA","","","Normal","O","None","","1","0","0","197.210.53.90","2019-11-20 10:23:13","2019-11-20 10:34:19","","","","1","0000-00-00 00:00:00","2019-05-02 11:03:10","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("89","0","1","0","0","2","14","1","2","14","0089","0","0","27","541","","AHMED MOHAMMED","07030638845","","","","M","1","Nigerian","1","6","1977","married","","","","angoaliyu76@yahoo.com","","BIDA","07030638845","","OPPOSITE ST. MARRY CHURCH MINNA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 13:10:34","2020-01-16 13:10:44","","","","1","0000-00-00 00:00:00","2019-05-02 11:17:56","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0229","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("90","0","0","0","0","0","0","1","2","15","0090","0","0","27","563","","ABDULLAHI ABDULLAHI ALHAJI","08035153073","","","","M","1","Nigerian","15","1","1976","married","","","","angoaliyu76@yahoo.com","","WUSHISHI","08035153073","","FATI LAMI ABUBAKAR INSTITUTE FOR LEGAL AND ADMINISTRATIVE STUDIES PMB 133 MINNA","","","Normal","A+","None","","1","0","0","197.210.226.235","2019-06-10 08:41:43","2019-06-10 08:42:27","","","","1","0000-00-00 00:00:00","2019-05-02 11:28:06","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("91","0","1","0","0","4","13","1","4","13","0091","0","0","27","545","","YAHAYA MOHAMMED","08036214214","","","","M","1","Nigerian","3","3","1970","married","","","","angoaliyu76@yahoo.com","","EDATI","08036214214","","MINISTRY OF LOCAL GOVERNMENT, COMMUNITY DEVELOPMENT AND CHIEFTANCY AFFAIRS MINNA","","","Normal","B+","None","","1","0","0","197.210.60.119","2020-01-03 10:49:04","2020-01-03 10:50:01","","","","1","0000-00-00 00:00:00","2019-05-02 11:37:49","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2019-11-15 12:46:28","0538","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("92","0","1","0","0","10","20","1","7","17","0092","0","0","27","560","","AHMAD IDRIS IDRIS","08063697272","","","2019-05-02-120113AHMAD IDRIS.pdf.pdf","M","1","Nigerian","6","12","1999","single","","","","idrisahmad7272@gmail.com","","MINNA","08063697272","","TUDUN FULANI BOSSO MINNA NIGER STATE","TUDUN FULANI BOSSO MINNA NIGER STATE","2019-05-02-114529.jpg","Normal","O","None","NIL","1","0","0","105.112.115.84","2020-02-12 16:43:37","2020-02-12 16:45:27","","","","1","0000-00-00 00:00:00","2019-05-02 11:43:14","0000-00-00 00:00:00","","","AHMAD A. IDRIS","08127764618","TUDUN FULANI BOSSO MINNA NIGER STATE","FATHER","1","AHMAD A. IDRIS","TUDUN FULANI BOSSO MINNA NIGER STATE","1","                                
\n                                                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                                                 
\n                                ","3","2020-02-11 17:01:09","0295","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("93","0","1","0","0","2","2","1","2","2","0093","0","0","27","548","","ISAH MOHAMMED KABIR","08038874191","","","","M","1","Nigerian","23","3","1983","married","","","","kabirm22@gmail.com","","katcha","08038874191","","PRISON QUARTERS AREA","","","Normal","A+","None","","1","0","0","105.112.113.95","2020-01-15 12:08:10","2020-01-15 12:09:55","","","","1","0000-00-00 00:00:00","2019-05-02 11:45:13","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0087","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("94","0","1","0","0","10","21","1","10","21","0094","0","0","24","504","","OLUYEMI ABIODUN FUNMILOLA","08135190512","","","","F","1","Nigerian","30","12","1977","married","","","","oluyemifunmilola@gmail.com","","OYUN","08135190512","","GIDAN MADARA AREA BESIDE HIMMA INTERNATIONAL COLLEGE MINNA","","","Normal","A+","None","","1","0","0","197.210.45.38","2020-01-03 15:00:31","2020-01-03 15:01:03","","","","1","0000-00-00 00:00:00","2019-05-02 11:50:14","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0367","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("95","0","1","0","0","4","13","1","4","13","0095","0","0","27","557","","ADAMU YUNUSA","08036061706","","","","M","1","Nigerian","31","5","1972","married","","","","yunusaboyd@hotmail.com","","PAIKORO","08036061706","","SKP 158 SAYAKO MUMBI ROAD MINNA","","","Normal","O","None","","1","1","0","197.210.55.123","2019-07-05 14:06:35","2019-06-10 09:01:56","","","","1","0000-00-00 00:00:00","2019-05-02 12:03:02","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-10-31 16:36:54","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("96","0","0","0","0","0","0","1","4","13","0096","0","0","27","543","","SANI G. BARDE SHATTA","08069506624","","","","M","1","Nigerian","7","7","1986","married","","","","angoaliyu76@yahoo.com","","BOSSO","08069506624","","SHATTA BOSSO","","","Normal","B+","None","","1","0","0","197.210.227.141","2019-06-10 09:02:03","2019-06-10 09:02:22","","","","1","0000-00-00 00:00:00","2019-05-02 12:14:25","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("97","0","1","0","0","1","11","1","1","11","0097","0","0","27","558","","IBRAHIM ABDULLAHI KARAYA","08065795367","","","","M","1","Nigerian","26","8","1968","married","","","","angoaliyu76@yahoo.com","","RAFI","08065795367","","TUDUN WADA KAGARA","","","Normal","O","None","","1","0","0","105.112.114.140","2020-01-16 09:32:32","2020-01-16 09:33:05","","","","1","0000-00-00 00:00:00","2019-05-02 12:25:07","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0221","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("98","0","1","0","0","1","11","1","1","11","0098","0","0","27","558","","SHEHU ABUBAKAR MOHAMMED","08036271135","","","","M","1","Nigerian","14","4","1975","married","","","","angoaliyu76@yahoo.com","","RAFI","08036271135","","SHEHU ABUBAKAR MOHAMMED C/O UNGUWAN GARBA MAIKUJERI","","","Normal","B+","None","","1","0","0","105.112.114.140","2020-01-16 09:33:29","2020-01-16 09:33:51","","","","1","0000-00-00 00:00:00","2019-05-02 12:34:48","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0222","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("99","0","1","0","0","7","16","1","7","16","0099","0","0","27","544","","RUKAYYA NATA\'ALA","08142482167","","","","F","1","Nigerian","11","3","1995","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08142482167","","SE 129 SABON GARI MINNA ","","","Normal","O","None","","1","0","0","197.210.64.184","2020-01-02 22:19:55","2020-01-02 22:20:39","","","","1","0000-00-00 00:00:00","2019-05-02 12:44:18","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0055","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("100","0","0","0","0","0","0","1","2","14","0100","0","0","27","546","","MOHAMMED IBN MOHAMMED","08039694753","","","","M","1","Nigerian","10","4","1973","married","","","","ibnmoh73@gmail.com","","GBAKO","08039694753","","GBEGANU MINNA BACK OF ANGUWAN ZAKA PRIMARY SCHOOL","","","Normal","O","None","","1","0","0","105.112.112.20","2020-01-28 15:49:51","2020-01-28 15:52:28","","","","1","0000-00-00 00:00:00","2019-05-02 12:51:13","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("101","0","1","0","0","2","14","1","2","14","0101","0","0","27","551","","USMAN HAFSAT","08131272629","","","","F","1","Nigerian","20","8","1987","single","","","","hafsatusman85@gmail.com","","LAVUN","08131272629","","D75 KUTIGI ROAD BOSSO LOWCOST MINNA","","","Normal","A+","None","","1","0","0","197.210.64.188","2020-01-02 21:55:39","2020-01-02 21:57:09","","","","1","0000-00-00 00:00:00","2019-05-02 12:58:48","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0341","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("102","0","1","0","0","1","11","1","1","11","0102","0","0","27","549","","AHMED IDRIS","08036505307","","","","M","1","Nigerian","17","10","1969","married","","","","angoaliyu76@yahoo.com","","KONTAGORA","08036505307","","MINISTRY FOR GOVERNMENT AND CHIEFTANCY AFFAIRS MINNA","","","Normal","A+","None","","1","0","0","197.210.60.119","2020-01-03 10:08:45","2020-01-03 10:09:55","","","","1","0000-00-00 00:00:00","2019-05-02 13:09:32","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-25 15:44:48","0613","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("103","0","1","0","0","2","15","1","2","15","0103","0","0","27","541","","ALIYU UMAR","07030380106","","","","M","1","Nigerian","2","8","1978","married","","","","angoaliyu76@yahoo.com","","BIDA","07030380106","","HIMMA ROAD, GIDAN MADARA BEHIND ARMY BARRACKS MINNA","","","Normal","B+","None","","1","0","0","105.112.115.177","2020-01-16 12:54:11","2020-01-16 12:54:23","","","","1","0000-00-00 00:00:00","2019-05-02 13:17:19","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0044","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("104","0","1","0","0","7","16","1","7","16","0104","0","0","7","130","","ABDUL MAGDALENE TERNGU","07035652520","","","","F","2","Nigerian","15","12","1994","single","","","","magdaleneabdul1994@gmail.com","","LOGO","07035652520","","GREEN SPOT HOUSE, BEHIND JOLATSEN MODEL SCHOOL, DAGIRI GWAGWALADA ABUJA","","","Normal","O","None","","1","1","0","197.210.85.94","2020-02-10 15:22:00","2020-02-03 19:26:06","","","","1","0000-00-00 00:00:00","2019-05-02 13:25:28","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0075","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("105","0","0","0","0","0","0","1","7","16","0105","0","0","27","543","","USMAN MA\'AJI","07037832191","","","","M","1","Nigerian","2","2","1982","married","","","","angoaliyu76@yahoo.com","","BOSSO","07037832191","","KUYI  VILLAGE MAIKUNKELE","","","Normal","O","None","","1","0","0","197.210.227.208","2019-06-10 09:06:29","2019-06-10 09:06:51","","","","1","0000-00-00 00:00:00","2019-05-02 13:37:30","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("106","0","1","0","0","10","21","1","10","21","0106","0","0","27","541","","AISHA YUSUF","08065234819","","","","F","1","Nigerian","19","7","1995","single","","","","aishaty686@gmail.com","","BIDA","08065234819","","HOUSE NO. 43 ABUBAKAR MU\'AZU ROAD TUNGA MINNA","","","Normal","A+","None","","1","0","0","197.210.65.187","2020-01-02 22:51:28","2020-01-02 22:52:01","","","","1","0000-00-00 00:00:00","2019-05-02 13:47:51","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0159","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("107","0","1","0","0","4","12","1","7","16","0107","0","0","27","539","","SALIHU ZUBAIRU","07037989863","","","","M","1","Nigerian","7","5","1979","married","","","","angoaliyu76@yahoo.com","","AGAIE","07037989863","","EMI LATE IMAM ESSUN MUTUM VIA BARO","","","Normal","O","None","","1","0","0","197.210.85.194","2020-02-11 14:50:30","2020-02-11 15:08:10","","","","1","0000-00-00 00:00:00","2019-05-02 13:56:54","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2020-02-11 15:02:34","0518","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("108","0","1","0","0","1","11","1","1","11","0108","0","0","27","557","","ALI MANSIR","08068935557","","","","M","1","Nigerian","21","6","1988","married","","","","mansirali88@gmail.com","","PAIKORO","08068935557","","NYSC QUARTERS PAIKO","","","Normal","A+","None","","1","0","0","105.112.122.121","2019-09-24 12:31:50","2019-09-24 16:06:47","","","","1","0000-00-00 00:00:00","2019-05-02 14:07:06","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0114","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("109","0","1","0","0","10","22","1","10","22","0109","0","0","27","555","","ADAMA ALHAJI SHEHU","07068295059","","","","F","1","Nigerian","8","9","1994","married","","","","angoaliyu76@yahoo.com","","MOKWA","07068295059","","EMI ALH. MUHAMMED YANDA GRA BIDA AREA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 14:08:40","2020-01-16 14:08:51","","","","1","0000-00-00 00:00:00","2019-05-02 14:50:27","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0089","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("110","0","1","0","0","10","21","1","10","21","0110","0","0","27","557","","DADA LAMI MALLAM","08068060447","","","","F","1","Nigerian","20","3","1978","married","","","","angoaliyu76@yahoo.com","","PAIKORO","08068060447","","FADAMA QUARTERS TUNGAN GORO, MINNA","","2019-10-28-211714.jpg","Normal","O","None","","1","0","0","197.210.226.89","2020-02-07 17:39:25","2020-02-07 17:46:09","","","","1","0000-00-00 00:00:00","2019-05-03 10:50:54","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0351","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("111","0","1","0","0","4","4","1","4","12","0111","0","0","27","557","","YUSUF SUWAIBA","08149798593","","","","F","1","Nigerian","6","4","1987","single","","","","angoaliyu76@yahoo.com","","PAIKORO","08149798593","","IBRAHIM KUCHI ROAD, BARIKIN SALE","","","Normal","O","None","","1","0","0","105.112.122.165","2020-02-03 19:14:29","2020-02-03 19:16:35","","","","1","0000-00-00 00:00:00","2019-05-03 10:59:26","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2019-12-12 11:55:40","0029","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("112","0","1","0","0","2","15","1","2","15","0112","0","0","27","550","","AHMED ABDULKADIR ALFA","08035795264","","","","M","1","Nigerian","6","5","1981","married","","","","ahmedabdulkadiralfa@gmail.com","","LAPAI","08035795264","","NO. 12 LAMIN MAKUN STREET, DUTSEN KUWARAN GWARI VIA KWOLKOTA VILLAGE MINNA","","","Normal","B+","None","","1","0","0","105.112.115.177","2020-01-16 12:55:06","2020-01-16 12:55:15","","","","1","0000-00-00 00:00:00","2019-05-03 11:11:04","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0079","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("113","0","1","0","0","10","21","1","10","21","0113","0","0","27","544","","ABDULSALAM ABDULRAHMAN","08133137335","","","","M","1","Nigerian","12","8","1987","single","","","","abdulsalamabdulrahman1010@gmail.com","","CHANCHAGA","08133137335","","TUNGA BEHIND SOGGI GUEST INN MINNA","","2019-10-07-181957.jpg","Normal","A+","None","","1","0","0","197.210.64.248","2020-01-02 23:27:14","2020-01-02 23:27:46","","","","1","0000-00-00 00:00:00","2019-05-03 11:24:51","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0251","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("114","0","1","0","0","2","14","1","2","14","0114","0","0","27","549","","ABUBAKAR IDRIS","07030302054","","","","M","1","Nigerian","3","7","1982","married","","","","abubakaridris518@gmail.com","","KONTAGORA","07030302054","","BESIDE HASKE CLINIC UNGUWAN DAJI MINNA","","","Normal","O","None","","1","0","0","105.112.115.194","2020-01-29 08:47:59","2020-01-29 08:49:40","","","","1","0000-00-00 00:00:00","2019-05-03 11:38:28","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0234","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("115","0","1","0","0","1","11","1","1","11","0115","0","0","27","559","","MIKA MUSTAPHA","08038166148","","","","M","1","Nigerian","3","4","1996","single","","","","mikamustapha9@gmail.com","","RIJAU","08038166148","","AREA 2, LONDON STREET, DUTSEN KURA MINNA","","","Normal","B+","None","","1","1","0","197.211.57.247","2020-01-27 09:54:02","2020-01-27 09:53:56","","","","1","0000-00-00 00:00:00","2019-05-03 11:55:11","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0286","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("116","0","0","0","0","0","0","1","1","11","0116","0","0","0","0","","Abubakar zakari Enegbaki","","","","","","0","","","","","","","","","enegbaki1970@yahoo.com","","","08065316650","","","","","","","","","1","1","0","197.210.57.45","2019-09-26 17:28:03","2019-05-07 09:03:18","","","","0","0000-00-00 00:00:00","2019-05-03 22:00:46","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("117","0","0","0","0","0","0","1","2","2","0117","0","0","23","479","","Muhammad Sani Isa","09092845217","","","","M","1","Nigerian","12","9","1999","single","","","","youngpolicy001@gmail.com",""," Okofi","09092845217","","Opp. PW Nigeria LTD along Paiko Minna Road Highway","Opp. PW Nigeria LTD along Paiko Minna Road Highway","2019-05-05-143205.jpg","Normal","B+","None","","1","1","0","41.190.14.218","2019-05-06 11:32:37","2019-05-06 11:30:31","","","","0","0000-00-00 00:00:00","2019-05-04 10:09:47","0000-00-00 00:00:00","","","Mal. Isa Ozi Sani","07084012172","Opp. PW Nigeria LTD along Paiko Minna Road Highway","Father","1","Mal. Isa Ozi Sani","Opp. PW Nigeria LTD along Paiko Minna Road Highway","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("118","0","1","0","0","7","16","1","7","16","0118","0","0","0","0","","JAMILA SALIHU","","","","2019-05-04-154655Document 222.pdf.pdf","","0","","","","","","","","","jamila12@gmail.com","","","07039047001","","","","2019-05-04-153834.jpg","","","","","1","0","0","105.112.115.177","2020-01-16 13:52:02","2020-01-16 13:53:47","","","","1","0000-00-00 00:00:00","2019-05-04 15:03:47","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-03 08:33:02","0505","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("119","0","0","0","0","0","0","1","10","21","0119","0","0","27","559","","SA\'AD MUSA HASSANA","09038085258","","","","F","1","Nigerian","1","10","1998","married","","","","seenerth@gmail.com","","Minna","09038085258","","Ayan Gwari off Okada Road Minna Niger State","Ayan Gwari off Okada Road Minna Niger State","2019-05-04-154824.jpg","Normal","O","None","Good","1","0","0","197.210.8.189","2019-05-14 11:33:05","2019-05-14 11:34:04","","","","1","0000-00-00 00:00:00","2019-05-04 15:10:18","0000-00-00 00:00:00","","","Musa","09038085258","Ayan Gwari off Okada Road Minna Niger State","Father","1","Musa ","Ayan Gwari off Okada Road Minna Niger State","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("120","0","0","0","0","0","0","1","11","24","0120","0","0","0","0","","isyaku muhammed buhari ","","","","2019-05-17-121558t.pdf.pdf","","0","","","","","","","","","ishaqbuhari80@gmail.com","","","07051952204","","","","2019-05-17-135746.jpg","","","","","1","1","0","185.26.180.192","2019-08-13 08:13:24","2019-05-17 14:25:45","","","","1","0000-00-00 00:00:00","2019-05-05 13:48:14","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("121","0","0","0","0","0","0","1","1","11","0121","0","0","0","0","","Peter John","","","","","","0","","","","","","","","","enyo12291@gmail.com","","","08086255994","","","","","","","","","1","1","0","105.112.122.3","2019-10-30 12:02:38","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-05-05 22:16:44","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("122","0","0","0","0","0","0","1","10","22","0122","0","0","0","0","","AISHA BABA ZAKARI","","","","","","0","","","","","","","","","aishababazakari69@gmail.com","","","07037746731","","","","","","","","","1","1","0","82.145.223.64","2019-05-06 06:03:49","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-05-06 06:00:20","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("123","0","0","0","0","0","0","1","10","22","0123","0","0","0","0","","AISHA BABA ZAKARI","","","","","","0","","","","","","","","","aishababazakari69@gmail.com","","","07037746731","","","","","","","","","1","0","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-05-06 06:00:25","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("124","0","1","0","0","2","14","1","2","14","0124","0","0","27","539","","ALIYU TETENGI TSAKPATI","08102679206","","","","M","1","Nigerian","31","12","1979","married","","","","aliyutetenitsakpati@gmail.com","","AGAIE","08102679206","","GURARA MINNA","","","Normal","B+","None","","1","0","0","105.112.115.177","2020-01-16 13:05:41","2020-01-16 13:05:50","","","","1","0000-00-00 00:00:00","2019-05-06 09:54:05","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0028","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("125","0","0","0","0","0","0","1","1","11","0125","0","0","0","0","","MOHAMMED ABUBAKAR EBATINTI","","","","","","0","","","","","","","","","ebatintiabubakar@gmail.com","","","07065779999","","","","","","","","","1","1","0","105.112.122.185","2019-09-19 18:38:29","2019-09-09 12:56:10","","","","0","0000-00-00 00:00:00","2019-05-06 10:02:44","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("126","0","1","0","0","7","16","1","7","16","0126","0","0","27","550","","MOHAMMED MOHAMMED BELLO","07067603889","","","","M","1","Nigerian","10","12","1992","single","","","","angoaliyu76@yahoo.com","","LAPAI","07067603889","","SAMUEL BAWA KUTA ROAD TUNGA LOWCOST MINNA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 14:07:05","2020-01-16 14:07:41","","","","1","0000-00-00 00:00:00","2019-05-06 10:03:35","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0193","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("127","0","1","0","0","4","13","1","4","13","0127","0","0","27","552","","HASSAN IBRAHIM","08029020624","","","","M","1","Nigerian","14","10","1969","married","","","","angoaliyu76@yahoo.com","","MAGAMA","08029020624","","C/O DISTRICT HEAD, DISTRICT HEAD OFFICE AUNA MAGAMA LGA ","","","Normal","O","None","","1","0","0","197.210.60.119","2020-01-03 11:00:26","2020-01-03 11:01:24","","","","1","0000-00-00 00:00:00","2019-05-06 10:13:47","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0658","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("128","0","0","0","0","0","0","1","7","5","0128","0","0","27","546","","JIYA JUMMAI PATIENCE","08065125889","","","","F","2","Nigerian","3","3","1994","single","","","","patiencejiya36954@gmail.com","","GBAKO","08065125889","","NEW LAYOUT BEHIND SCHOOL OF HEALTH MINNA","","","Normal","A+","None","","1","0","0","197.210.226.235","2019-06-10 08:49:52","2019-06-10 08:50:17","","","","1","0000-00-00 00:00:00","2019-05-06 10:32:51","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("129","0","1","0","0","2","14","1","2","14","0129","0","0","27","551","","ISAH HAUWA","08064151705","","","","F","1","Nigerian","26","8","1986","married","","","","hauwabbshehu@gmail.com","","LAVUN","08064151705","","NO. G6 AHMADU WAY G.R.A MINNA","","","Normal","O","None","","1","0","0","105.112.112.20","2020-01-28 16:22:11","2020-01-28 16:22:20","","","","1","0000-00-00 00:00:00","2019-05-06 10:42:52","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2019-12-12 12:10:43","0527","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("130","0","1","0","0","2","2","1","2","2","0130","0","0","27","563","","LAWAL GARBA","07032133710","","","","M","1","Nigerian","25","5","1986","single","","","","lawalgarbawushishi1986@gmail.com","","WUSHISHI","07032133710","","OFF OKADA ROAD BEHIND FUT SMALL GATE BOSSO MINNA","","","Normal","O","None","","1","1","0","105.112.120.113","2019-10-02 13:29:04","2019-06-10 08:52:39","","","","1","0000-00-00 00:00:00","2019-05-06 10:56:59","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0224","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("131","0","1","0","0","10","22","1","10","22","0131","0","0","27","557","","MACHI HADIZA YAKUBU","08036779662","","","","F","1","Nigerian","18","3","1985","married","","","","angoaliyu76@yahoo.com","","PAIKORO","08036779662","","ZONE F30 FARM CENTRE MINNA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 14:08:03","2020-01-16 14:08:15","","","","1","0000-00-00 00:00:00","2019-05-06 11:08:51","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0233","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("132","0","1","0","0","4","4","1","4","12","0132","0","0","27","560","","YUSUF HASSANA","07057666549","","","","F","1","Nigerian","6","6","1990","single","","","","yhassana2@gmail.com","","SHIRORO","07057666549","","KPAKUNGU MINNA","","","Normal","A+","None","","1","0","0","105.112.112.20","2020-01-28 16:07:16","2020-01-28 16:07:40","","","","1","0000-00-00 00:00:00","2019-05-06 11:17:56","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-21 15:07:15","0598","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("133","0","1","0","0","4","13","1","4","13","0133","0","0","27","544","","IBRAHIM SAIDU COMFORT","08032537931","","","","F","2","Nigerian","28","6","1985","married","","","","comfortibrahim2019@gmail.com","","CHANCHAGA","08032537931","","NO. 1 BEHIND CHANCHAGA GSS GBAKOITA MINNA","","","Normal","B+","None","","1","0","0","105.112.116.72","2020-01-24 12:35:08","2020-01-24 12:37:12","","","","1","0000-00-00 00:00:00","2019-05-06 11:30:58","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0219","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("134","0","0","0","0","0","0","1","4","12","0134","0","0","0","0","","Ibrahim musa danladi","","","","","","0","","","","","","","","","ibrahimsh247@gmail.com","","","07034675409","","","","","","","","","1","0","0","41.190.12.155","2019-05-06 11:46:01","2019-05-06 11:46:40","","","","0","0000-00-00 00:00:00","2019-05-06 11:41:28","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("135","0","1","0","0","4","13","1","4","13","0135","0","0","27","541","","Fatima Faruk","08032428277","","","2019-05-11-181656ff.pdf.pdf","F","1","Nigerian","16","5","1972","married","","","","fateemafk@gmail.com","","Bida","08032428277","","ER 2.  Yakubu Lame, GRA, Minna,\\r\\nNiger State","ER 2.  Yakubu Lame, GRA, Minna,\\r\\nNiger State","2019-05-13-095513.jpg","Normal","A+","None","","1","0","0","105.112.115.177","2020-01-16 11:35:10","2020-01-16 11:35:19","","","","1","0000-00-00 00:00:00","2019-05-06 11:52:18","0000-00-00 00:00:00","","","Muhammad Danjuma Ali","08035881667","ER 2.  Yakubu Lame, GRA, Minna,
\nNiger State","Husband","1","Muhammad Danjuma Ali","ER 2.  Yakubu Lame, GRA, Minna,
\nNiger State","1","                                
\n                                                                 
\n                                ","3","2019-10-30 04:19:44","0393","21","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("136","0","1","0","0","10","21","1","10","21","0136","0","0","27","551","","MUHAMMAD ABDULLAHI SHESHI","08065159142","","","","M","1","Nigerian","26","4","1990","married","","","","ibnabdullahimuhammad@gmail.com","","LAVUN","08065159142","","ANGUWAN RAHMA MINNA","","","Normal","O","None","","1","0","0","197.210.65.127","2020-01-02 22:50:29","2020-01-02 22:51:15","","","","1","0000-00-00 00:00:00","2019-05-06 12:07:41","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0068","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("137","0","1","0","0","2","14","1","2","14","0137","0","0","27","546","","JAMES YISA","08069567595","","","","M","2","Nigerian","27","3","1987","married","","","","angoaliyu76@yahoo.com","","GBAKO","08069567595","","GBADAFU VILLAGE","","2019-09-23-135956.jpg","Normal","O","None","","1","0","0","197.210.226.253","2020-02-07 12:42:10","2020-02-07 12:45:58","","","","1","0000-00-00 00:00:00","2019-05-06 12:22:50","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0090","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("138","0","0","0","0","0","0","1","7","5","0138","0","0","27","556","","ISAH FARUQ MAKAMA","08068303994","","","","M","1","Nigerian","25","3","1994","single","","","","faruqmakamaisah@gmail.com","","MUNYA","08068303994","","ZHALAPE-GUNI MUNYA LOCAL GOVERNMENT ","","","Normal","B+","None","","1","0","0","197.210.227.141","2019-06-10 08:56:52","2019-06-10 08:57:14","","","","1","0000-00-00 00:00:00","2019-05-06 12:35:05","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("139","0","1","0","0","1","11","1","1","11","0139","0","0","27","542","","Hauwa Ahmed","08038613586","","","2019-05-13-155618Hauwa Ahmed.pdf.pdf","F","1","Nigerian","26","5","1973","married","","","","hauwa3227@gmail.com","","New Bussa","08038613586","","c/o Fatima Faruk 
\nNiger State Universal Basic Education Board, Minna ","Hauwa Ahmed
\nAccount Section, Borgu LGA
\nNiger State ","2019-05-13-163028.jpg","Normal","AB","None","","1","0","0","105.112.114.140","2020-01-16 09:48:12","2020-01-16 09:48:28","","","","1","0000-00-00 00:00:00","2019-05-06 12:44:58","0000-00-00 00:00:00","","","Abubakar Saidu ","08165292068","Finance Department, 
\nNiger State Universal Basic Education Board, 
\nMinna ","Brother ","1","Self","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0053","23","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("140","0","0","0","0","0","0","1","2","14","0140","0","0","27","544","","BELLO ABDULLAHI","07030516573","","","","M","1","Nigerian","15","2","1969","married","","","","nbmafara247@gmail.com","","CHANCHAGA","07030516573","","N.W 63A KATSINA STREET LIMAWA A\' WARD MINNA","","","Normal","O","None","","1","1","0","168.235.194.132","2020-01-17 18:34:48","2019-11-28 15:05:46","","","","1","0000-00-00 00:00:00","2019-05-06 12:45:02","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("141","0","0","0","0","0","0","1","11","24","0141","0","0","27","557","","THOMAS MICHAEL MAIYAKI","07065808493","","","","M","2","Nigerian","31","3","1993","single","","","","michaelthomasmaiyaki@yahoo.com","","PAIKORO","07065808493","","S.E 92 SABON GARI MINNA","","","Normal","O","None","","1","1","0","141.0.13.57","2019-09-20 00:38:03","2019-06-10 08:58:16","","","","1","0000-00-00 00:00:00","2019-05-06 13:08:40","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("142","0","0","0","0","0","0","1","2","2","0142","0","0","27","541","","NMAMUSA ISAH","07033970120","","","2019-05-08-151942NMAMUSA CERTIFICATES-min (4).pdf.pdf","M","1","Nigerian","1","1","1990","single","","","","nmamusa2015@gmail.com","","BIDA","07033970120","","SMECCA HOUSE TUNGANGORO AREA, MINNA","WADATA EMIR\'S PALACE QUARTERS, BIDA","2019-05-07-160221.jpg","Normal","O","None","NIL","1","1","0","197.210.54.157","2019-09-30 15:33:43","2019-05-10 09:20:56","","","","1","0000-00-00 00:00:00","2019-05-06 13:11:48","0000-00-00 00:00:00","","","ISAH KASIMU","07068416580","WADATA EMIR\'S PALACE QUARTERS, BIDA","FATHER","1","ISAH NMAMUSA","SMECCA HOUSE TUNGANGORO AREA, MINNA","0","","0","0000-00-00 00:00:00","","7","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("143","0","1","0","0","10","21","1","2","14","0143","0","0","27","541","","MOHAMMED MUSTAPHA ALHAJI","07032301953","","","","M","1","Nigerian","8","8","1989","married","","","","angoaliyu76@yahoo.com","","BIDA","07032301953","","HOUSE 127 AWAL IBRAHIM ROAD BOSSO MINNA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 14:33:20","2020-01-16 14:33:29","","","","1","0000-00-00 00:00:00","2019-05-06 13:25:03","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-12 12:20:56","0474","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("144","0","1","0","0","1","1","1","1","10","0144","0","0","27","548","","GIMBA AHMADU NDAGI","07031256851","","","","M","1","Nigerian","6","4","1994","married","","","","angoaliyu76@yahoo.com","","KATCHA","07031256851","","BARIKIN SALE MINNA NEAR PRIMARY SCHOOL","","","Normal","O","None","","1","0","0","197.210.85.194","2020-02-11 17:25:21","2020-02-11 18:22:03","","","","1","0000-00-00 00:00:00","2019-05-06 13:55:04","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                                                 
\n                                                                 
\n                                ","3","2020-02-11 17:26:32","0011","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("145","0","1","0","0","2","14","1","2","14","0145","0","0","27","544","","MOHAMMED BELLO","07066104631","","","","M","1","Nigerian","17","1","1990","married","","","","bellomohammed784@gmail.com","","CHANCHAGA","07066104631","","no. 14 back of antena 2nd gate suleja","","2019-09-20-121708.jpg","Normal","O","None","","1","0","0","197.210.65.63","2020-01-02 21:03:34","2020-01-02 21:04:04","","","","1","0000-00-00 00:00:00","2019-05-06 14:13:22","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0013","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("146","0","1","0","0","9","18","1","7","5","0146","0","0","27","544","","USMAN FATIMA","07056372791","","","","F","1","Nigerian","15","10","1984","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","07056372791","","N.W 20 LIMAWA MINNA","","","Normal","A+","None","","1","0","0","105.112.117.216","2020-02-11 16:10:55","2020-02-11 16:35:25","","","","1","0000-00-00 00:00:00","2019-05-06 14:31:33","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                                                 
\n                                                                 
\n                                ","3","2020-02-17 10:20:29","0066","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("147","0","1","0","0","2","15","1","2","15","0147","0","0","27","541","","HAUWA ABDULLAHI NNAMA","07037788877","","","","F","1","Nigerian","29","10","1980","married","","","","jamcy000@gmail.com","","bida","07037788877","","BEHIND HOUSE OF ASSEMBLY QTRS ALONG ESTERN BYE PASS MINNA","","2019-09-20-172631.jpg","Normal","A+","None","","1","0","0","105.112.115.177","2020-01-16 12:52:22","2020-01-16 12:52:34","","","","1","0000-00-00 00:00:00","2019-05-06 14:36:03","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0030","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("148","0","1","0","0","7","16","1","7","16","0148","0","0","27","541","","ABDULLAHI AISHA ABDULKADIR","07038202077","","","","F","1","Nigerian","2","2","1998","single","","","","abkadaeesha@gmail.com","","BIDA","07038202077","","NO. D221 MI WUSHISHI ESTATE MINNA","","","Normal","O","None","","1","0","0","105.112.112.20","2020-01-28 16:28:24","2020-01-28 16:28:36","","","","1","0000-00-00 00:00:00","2019-05-06 14:43:49","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0410","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("149","0","1","0","0","2","2","1","2","2","0149","0","0","27","543","","SANI USMAN","08134511727","","","","M","1","Nigerian","3","5","1993","married","","","","angoaliyu76@yahoo.com","","BOSSO","08134511727","","GIDAN MANGORO MINNA","","","Normal","O","None","","1","0","0","105.112.112.20","2020-01-28 16:21:43","2020-01-28 16:21:52","","","","1","0000-00-00 00:00:00","2019-05-06 14:49:53","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0656","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("150","0","1","0","0","4","12","1","4","12","0150","0","0","27","550","","MUSA HAMZA","08022152080","","","","M","1","Nigerian","12","8","1997","single","","","","hamzamusa739@gmail.com","","LAPAI","08022152080","","KPAKUNGU BESIDE DAYAMAZ GUEST INN","","","Normal","B+","None","","1","0","0","197.210.85.22","2020-01-02 15:46:23","2020-01-02 15:46:55","","","","1","0000-00-00 00:00:00","2019-05-06 14:57:13","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0124","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("151","0","0","0","0","0","0","1","2","14","0151","0","0","27","544","","SANI ABUBAKAR SADIQ","08051349220","","","","M","1","Nigerian","24","4","1990","single","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08051349220","","N.W 61 LIMAWA KATSINA ROAD MINNA","","","Normal","B+","None","","1","0","0","105.112.122.121","2019-09-24 14:27:27","2019-09-24 14:27:33","","","","1","0000-00-00 00:00:00","2019-05-06 15:11:46","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("152","0","0","0","0","0","0","1","2","14","0152","0","0","27","545","","KHADIJAT MAHMUD ENAGI","08064042229","","","","F","1","Nigerian","20","7","1980","married","","","","angoaliyu76@yahoo.com","","EDATI","08064042229","","NO. J 24 IBRAHIM ALIYU ROAD DUTSEN KURA MINNA","","","Normal","O","None","","1","0","0","197.210.53.17","2019-06-11 13:33:27","2019-06-11 13:34:02","","","","1","0000-00-00 00:00:00","2019-05-06 15:18:49","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("153","0","0","0","0","0","0","1","1","11","0153","0","0","0","0","","Sylvester shitnaan Bikut","","","","","","0","","","","","","","","","bikutsylvester@gmail.com","","","07034563663","","","","","","","","","1","1","0","105.112.122.19","2019-05-06 20:36:40","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-05-06 20:33:56","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("154","0","0","0","0","0","0","1","4","13","0154","0","0","27","548","","ALIYU ABDULLAHI","08036125917","","","2019-05-06-233950ALIYU ABDULLAHI.pdf.pdf","M","1","Nigerian","1","1","1991","single","","","","abdullahinma@yahoo.com","","BIDA","08036125917","","FLAT 17 AND 18 BCC BAKERY BANWUYA AREA BIDA","FLAT 17 AND 18 BCC BAKERY BANWUYA AREA BIDA","2019-05-06-230139.jpg","Normal","O","None","NILL","1","0","0","197.210.84.147","2019-11-11 23:18:38","2019-11-11 23:19:02","","","","1","0000-00-00 00:00:00","2019-05-06 22:54:19","0000-00-00 00:00:00","","","ALHAJI MAHMUD AUDU BIDA","08036990668","FLAT 17 AND 18 BCC BAKERY BANWUYA AREA BIDA","BROTHER","1","SELF","FLAT 17 AND 18 BCC BAKERY BANWUYA AREA BIDA","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("155","0","0","0","0","0","0","1","7","17","0155","0","0","0","0","","IDRIS Umar Faruk ","","","","","","0","","","","","","","","","olufaruk50@gmail.com","","","08167730553","","","","2019-05-07-085147.jpg","","","","","1","1","0","105.112.11.225","2019-09-23 09:20:30","2019-05-07 09:12:28","","","","0","0000-00-00 00:00:00","2019-05-07 08:39:36","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("156","0","0","0","0","0","0","1","1","11","0156","0","0","27","541","","Sani Sayuti Yahaya","08065685170","","","2019-05-07-112847SAYUTI 001.pdf.pdf","M","1","Nigerian","1","2","1988","married","","","","sayuti4all@gmail.com","","Bida","08065685170","","G.R.A Gen. Graba Street Area Bida, Niger State","G.R.A Gen. Graba Street Area Bida, Niger State","2019-05-07-103858.jpg","Normal","O","None","","1","1","0","41.190.12.229","2019-05-07 11:27:16","2019-05-07 11:25:15","","","","1","0000-00-00 00:00:00","2019-05-07 10:25:36","0000-00-00 00:00:00","","","Halidu Sayuti Yahaya ","08035871773","Life Camp Abuja","Brother","3","Halidu Sayuti Yahaya","Life Camp Abuja","0","","0","0000-00-00 00:00:00","","3","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("157","0","1","0","0","7","5","1","7","5","0157","0","0","27","547","","MOHAMMED ZAKARI","08072828917","","","2019-05-07-112834convert-jpg-to-pdf.net_2019-05-07_12-28-11.pdf.pdf","M","1","Nigerian","11","12","1993","single","","","","mohammedzaks0019@yahoo.com","","Labata","08072828917","","London Street, Minna, Niger State","London Street, Minna, Niger State","2019-05-07-112017.jpeg","Normal","O","None","None","1","1","0","197.210.226.136","2020-02-11 15:37:03","2020-02-10 18:27:58","","","","1","0000-00-00 00:00:00","2019-05-07 11:15:29","0000-00-00 00:00:00","","","Binta Mamman","08062992075","London Street, Minna, Niger State","Aunty","1","Private","Private","1","                                
\n                                                                 
\n                                ","3","2019-10-30 04:22:37","0513","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("158","0","1","0","0","1","11","1","1","11","0158","0","0","23","479","","Abubakar zakari Enegbaki","08065316650","","","2019-05-14-094313MY CREDENTIALS.pdf.pdf","M","1","Nigerian","14","1","1970","married","","","","enegbaki1970@yahoo.com","","Enegbaki","08065316650","","Plot 176A Lambata, behind essential petroleum, Kwali Abuja","Plot 176A , Lambata, behind essential petroleum , kwali, Abuja","2019-05-08-121521.jpg","Normal","O","None","No medical challenge","1","1","0","41.203.73.200","2019-10-19 06:03:47","2019-05-27 17:32:49","","","","1","0000-00-00 00:00:00","2019-05-07 12:57:30","0000-00-00 00:00:00","","","Mahmud bilikisu","08065930707","Plot 176A, Lambata,behind essential petroleum, kwali Abuja","Wife","3","FCT water Board, Area 3, Garki, Abuja","Area  3,Garki,Abuja","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0290","16","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("159","0","0","0","0","0","0","1","11","23","0159","0","0","0","0","","Yunusa Musa","","","","","","0","","","","","","","","","yunusakuta@gmail.com","","","09096617636","","","","","","","","","1","1","0","105.112.120.48","2019-11-14 12:15:56","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-05-07 13:15:33","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("160","0","0","0","0","0","0","1","2","2","0160","0","0","0","0","","Sonmaji Abubakar Hassan","","","","","","0","","","","","","","","","sonmajiabubakar@gmail.com","","","08037917752","","","","","","","","","1","1","0","82.145.222.86","2019-05-07 14:17:39","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-05-07 14:15:07","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("161","0","1","0","0","10","21","1","4","12","0161","0","0","32","668","","FATIMA SALEH ALIYU","09032598484","","","2019-05-07-155749Hajiya Fatima.pdf.pdf","F","1","Nigerian","11","7","1992","married","","","","fatimasalehaliyu@gmail.com","","JOS","09032598484","","BEFORE POLICE STATION BARIKIN SALE  MINNA NIGER STATE","BEFORE POLICE STATION BARIKIN SALE  MINNA NIGER STATE","2019-05-07-154822.jpg","Normal","B+","None","","1","0","0","105.112.113.198","2020-02-05 11:56:55","2020-02-05 11:58:45","","","","1","0000-00-00 00:00:00","2019-05-07 15:34:48","0000-00-00 00:00:00","","","SALEH ALI","08053131908","ZARA ZON JOS EAST LOCAL GOV\'T","FATHER","3","SALEH ALI","ZARA ZON JOS EAST LOCAL GOV\'T","1","                                
\n                                                                 
\n                                ","3","2019-11-06 16:53:42","0499","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("162","0","1","0","0","4","4","1","4","4","0162","0","0","27","559","","TANIMU NURA","08072640086","","","2019-06-11-104638NURA TANIMU.pdf.pdf","M","1","Nigerian","23","10","1995","single","","","","nura123oyinbo@gmail.com","","RIJAU","08072640086","","MORRIS FERTILIZER BEHIND ISLAMIYA HOUSE N0. E14 MINNA NIGER STATE","BARKIN SALE BEHIND IMANI HOSPITAL OPP. AMI GLO PURE WATER, MINNA NIGER STATE.","2019-05-08-102905.jpg","Normal","AB","None","","1","1","0","41.190.19.99","2020-02-24 09:39:11","2020-01-02 15:50:35","","","","1","0000-00-00 00:00:00","2019-05-08 08:55:18","0000-00-00 00:00:00","","","HAJIYA NAFISAT","07060950500","BARKIN SALE BEHIND IMANI HOSPITAL OPP. AMI GLO PURE WATER, MINNA NIGER STATE.","SISTER","4","SELF","MORRIS FERTILIZER BEHIND ISLAMIYA HOUSE N0. E14 MINNA NIGER STATE","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0097","4","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("163","0","1","0","0","4","4","1","4","4","0163","0","0","27","544","","VIVIAN OKPOR","07031163672","","","","F","2","Nigerian","2","2","1988","single","","","","vivianokpor50@gmail.com","","Minna","07031163672","","Zone D 35 Farm Center,  Tunga Minna","Zone D 35 Farm Center,  Tunga Minna","2019-05-08-093836.jpg","Normal","O","None","Good","1","0","0","197.210.85.22","2020-01-02 15:53:15","2020-01-02 15:54:03","","","","1","0000-00-00 00:00:00","2019-05-08 09:08:47","0000-00-00 00:00:00","","","Petien Okpor","08039203590","No41 Major Salawu street agbowo,  u.i ibadan Oyo State ","Sister","1","Petien Okpor","No41 Major Salawu street agbowo,  u.i ibadan Oyo State ","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0100","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("164","0","0","0","0","0","0","1","4","4","0164","0","0","0","0","","MOHAMMED ABUBAKAR EBATINTI","","","","2019-05-10-105226ABUBAKAR EBATINTI.pdf.pdf","","0","","","","","","","","","ebatintiabubakar@gmail.com","","","07033336966","","","","2019-05-10-105314.jpg","","","","","1","0","0","197.210.44.29","2019-05-20 10:00:43","2019-05-20 10:00:56","","","","1","0000-00-00 00:00:00","2019-05-08 11:07:56","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("165","0","0","0","0","0","0","1","2","2","0165","0","0","27","541","","ABUBAKAR AISHAT EBATINTI ","08130644777","","","2019-05-09-105240EBANTI.pdf.pdf","F","1","Nigerian","27","5","2000","single","","","","aishaabubakar439@gmail.com","","BIDA","08130644777","","ndazabo area, bida niger state","ndazabo area, bida niger state","2019-05-09-100926.jpg","Normal","O","None","","1","0","0","197.210.129.14","2019-10-06 23:14:02","2019-10-06 23:14:38","","","","1","0000-00-00 00:00:00","2019-05-08 11:15:16","0000-00-00 00:00:00","","","ABUBAKAR MOHAMMED EBATINTI","080353338687","ndazabo area, bida niger state","FATHER","1","MUHAMMAD ABDULMALIK","ndazabo area, bida niger state","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("166","0","0","0","0","0","0","1","2","15","0166","0","0","14","274","","UGWA CHURKS CELESTINE","08054913268","","","2019-05-08-130015nysc.pdf.pdf","M","2","Nigerian","7","1","1983","married","","","","nzegote2220@yahoo.com","","SOKOTO STATE","08054913268","","NO 6,ECWA CHURCH ROAD, OPP. LABOUR HOUSE KUJE ROAD GWAGWA ABUJA F.C.T","AFFA UDI ENUGU STATE","","Normal","A+","None","","1","1","0","154.113.16.226","2019-05-13 12:17:17","2019-05-08 13:45:56","","","","0","0000-00-00 00:00:00","2019-05-08 11:26:02","0000-00-00 00:00:00","","","UGWA CEJUS CHUKWUMA","08055961713","NO 9. BELJIN WATER ROAD, BEHIND CONOIL KWANKWASHE SULEJA NIGER STATE","PARENT","1","UGWA CHURKS CELESTINE","AS THESAME AS ABOVE","0","","0","0000-00-00 00:00:00","","3","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("167","0","1","0","0","7","16","1","7","16","0167","0","0","27","555","","TSADO SARETU MARTHA","08036109368","","","","F","2","Nigerian","5","5","1969","married","","","","angoaliyu76@yahoo.com","","MOKWA","08036109368","","OPPOSITE MAI ANGUWAN HOUSE FADIKPE INSIDE NEW ROAD","","","Normal","B+","None","","1","0","0","197.210.60.119","2020-01-03 11:33:20","2020-01-03 11:35:35","","","","1","0000-00-00 00:00:00","2019-05-08 11:31:53","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0180","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("168","0","1","0","0","4","4","1","4","4","0168","0","0","13","250","","OKE OLUWADAMILOLA","08061297292","","","","M","2","Nigerian","19","5","1992","single","","","","oluwadamilolaoke018@gmail.com","","IDO OSI","08061297292","","HUD 58 FEDERAL SECRETARIAT STAFF QRTS MINNA","","","Normal","O","None","","1","0","0","197.210.45.38","2020-01-03 14:18:13","2020-01-03 14:18:40","","","","1","0000-00-00 00:00:00","2019-05-08 11:40:00","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0212","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("169","0","0","0","0","0","0","1","4","13","0169","0","0","0","0","","TIJANI ABIMBOLA ELIZABETH","","","","","","0","","","","","","","","","elizabethtijani@gmail.com","","","08130272500","","","","","","","","","1","1","0","197.210.45.83","2019-10-03 11:34:08","2019-05-08 13:29:11","","","","0","0000-00-00 00:00:00","2019-05-08 11:41:55","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("170","0","1","0","0","9","18","1","9","18","0170","0","0","23","469","","ORE RACHAEL OVAYOZA","07030337992","","","","F","2","Nigerian","26","5","1981","married","","","","orehcd@gmail.com","","ADAVI EBA","07030337992","","NO. 5 BARIKIN SALE OPPOSITE SCORPION HOUSE MINNA","","","Normal","B+","None","","1","0","0","197.210.45.38","2020-01-03 14:03:23","2020-01-03 14:04:38","","","","1","0000-00-00 00:00:00","2019-05-08 11:45:17","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0402","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("171","0","1","0","0","9","6","1","9","6","0171","0","0","27","544","","ABDULLAHI MOHAMMED SANI","07033396085","","","","M","1","Nigerian","7","4","1986","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","07033396085","","BEHIND DIAMOND BANK YUNGA MINNA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 14:50:52","2020-01-16 14:51:27","","","","1","0000-00-00 00:00:00","2019-05-08 11:46:30","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0086","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("172","0","1","0","0","2","14","1","2","14","0172","0","0","27","550","","MOHAMMED ZAKARI LAPAI","08034514273","","","","M","1","Nigerian","25","1","1974","married","","","","mohammedzakari190@gmail.com","","LAPAI","08034514273","","INDEPENDENT NATIONAL ELECTORAL COMMISION DAVID MARK ROAD TUNGA MINNA","","","Normal","O","None","","1","0","0","197.210.65.2","2020-01-02 21:09:19","2020-01-02 21:09:54","","","","1","0000-00-00 00:00:00","2019-05-08 11:48:45","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0093","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("173","0","1","0","0","7","16","1","7","16","0173","0","0","27","547","","MIKAILU UMAR","08072016998","","","","M","1","Nigerian","8","6","1986","married","","","","umarmikailu189@yahoo.com","","GURARA","08072016998","","ALH. MUH\'D SANI EIF123 PAIDA MINNA ALONG NEW MARKET MAITUMBI MINNA","","","Normal","A+","None","","1","0","0","197.210.64.31","2020-01-02 22:18:13","2020-01-02 22:18:47","","","","1","0000-00-00 00:00:00","2019-05-08 11:50:30","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0145","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("174","0","1","0","0","2","14","1","2","14","0174","0","0","27","557","","ADAMU HELEN","08032852684","","","","F","2","Nigerian","4","8","1982","married","","","","adamuhelen92@gmail.com","","PAIKORO","08032852684","","148C PAIDA MINNA NIGER STATE","","","Normal","O","None","","1","0","0","197.210.47.127","2020-01-02 20:56:12","2020-01-02 20:56:46","","","","1","0000-00-00 00:00:00","2019-05-08 11:52:17","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0067","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("175","0","1","0","0","7","5","1","7","5","0175","0","0","27","557","","IORNGER EMMANUEL TERYANGE","08163229285","","","","M","2","Nigerian","30","10","1997","single","","","","emmanueliornge2@gmail.com","","PAIKORO","08163229285","","NEW GRA MAITUN BEHIND EL AMIN INTL SCH MINNA","","","Normal","AB","None","","1","0","0","197.210.226.230","2019-06-10 09:20:15","2019-06-10 09:20:33","","","","1","0000-00-00 00:00:00","2019-05-08 11:53:49","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("176","0","0","0","0","0","0","1","10","21","0176","0","0","27","541","","FATI SANI","07034336215","","","","F","1","Nigerian","29","8","1975","married","","","","angoaliyu76@yahoo.com","","BIDA","07034336215","","TALBA ESTATE BIDA ","","","Normal","B+","None","","1","1","0","197.211.57.195","2019-11-20 15:14:06","2019-06-10 09:21:11","","","","1","0000-00-00 00:00:00","2019-05-08 11:54:44","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("177","0","1","0","0","2","14","1","2","14","0177","0","0","27","543","","ABDULLAHI AMINU","08066831443","","","","M","1","Nigerian","4","1","1982","married","","","","angoaliyu76@yahoo.com","","BOSSO","08066831443","","ANGUWAN ZAKKAH GBEGANU VILLAGE MINNA","","","Normal","A+","None","","1","0","0","105.112.113.95","2020-01-15 12:10:11","2020-01-15 12:11:17","","","","1","0000-00-00 00:00:00","2019-05-08 11:55:42","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0138","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("178","0","1","0","0","2","15","1","2","15","0178","0","0","27","543","","ISA FA\'IZA HABIS","08096832982","","","","F","1","Nigerian","13","12","1993","married","","","","angoaliyu76@yahoo.com","","BOSSO","08096832982","","BOSSO ESTATE MINNA","","","Normal","B+","None","","1","0","0","105.112.115.177","2020-01-16 12:50:27","2020-01-16 12:50:35","","","","1","0000-00-00 00:00:00","2019-05-08 11:56:49","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0130","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("179","0","0","0","0","0","0","1","10","21","0179","0","0","27","551","","MOHAMMED ABUBAKAR AISHA","07063182067","","","","F","1","Nigerian","26","2","1998","single","","","","angoaliyu76@yahoo.com","","LAVUN","07063182067","","DUTSEN KURA OFF ADAMAWA ROAD MINNA ","","","Normal","O","None","","1","0","0","197.210.227.198","2019-06-10 09:30:43","2019-06-10 09:31:06","","","","1","0000-00-00 00:00:00","2019-05-08 11:57:43","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("180","0","1","0","0","10","22","1","2","15","0180","0","0","27","557","","BITRUS ROSE","08038121560","","","","F","2","Nigerian","21","7","1974","married","","","","angoaliyu76@yahoo.com","","PAIKORO","08038121560","","MARYAM BABANGIDA GIRLS SCIENCE COLLEGE","","","Normal","B+","None","","1","0","0","105.112.117.216","2020-02-11 16:10:06","2020-02-11 16:10:19","","","","1","0000-00-00 00:00:00","2019-05-08 11:58:36","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-19 14:34:26","0579","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("181","0","1","0","0","4","12","1","2","14","0181","0","0","27","557","","MADAKI JULIANA MOSES","08026954417","","","","F","2","Nigerian","8","8","1988","married","","","","angoaliyu76@yahoo.com","","PAIKORO","08026954417","","OPP GOVT TECHNICAL COLLEGE TUNGAN GORO MINNA","","","Normal","O","None","","1","0","0","105.112.112.20","2020-01-28 16:06:19","2020-01-28 16:06:30","","","","1","0000-00-00 00:00:00","2019-05-08 11:59:39","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-19 14:28:20","0578","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("182","0","1","0","0","2","15","1","2","15","0182","0","0","27","557","","UMAR HADIZA MAGAJI","08035968996","","","","F","2","Nigerian","28","8","1976","single","","","","hadizamagaji@gmail.com","","PAIKORO","08035968996","","BEHIND ABDULSALAM PARK TUNGA MINNA","","","Normal","A+","None","","1","0","0","105.112.115.177","2020-01-16 12:57:30","2020-01-16 12:57:40","","","","1","0000-00-00 00:00:00","2019-05-08 12:01:22","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0128","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("183","0","1","0","0","4","13","1","4","13","0183","0","0","27","539","","MAMMAN IBRAHIM","08138877144","","","","M","1","Nigerian","2","10","1983","married","","","","angoaliyu76@yahoo.com","","AGAIE","08138877144","","EMI LEMUTA NAMI VIA AGAIE ALONG LAPAI AGAOE ROAD","","","Normal","O","None","","1","0","0","197.210.45.38","2020-01-03 14:19:51","2020-01-03 14:20:17","","","","1","0000-00-00 00:00:00","2019-05-08 12:02:23","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0230","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("184","0","1","0","0","9","18","1","9","18","0184","0","0","27","541","","IDRIS RAMATU","07033418708","","","","F","1","Nigerian","19","10","1993","single","","","","angoaliyu76@yahoo.com","","BIDA","07033418708","","KPAKUNGU BESIDE SAWABA BREAD MINNA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 14:39:40","2020-01-16 14:39:52","","","","1","0000-00-00 00:00:00","2019-05-08 12:03:42","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0226","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("185","0","1","0","0","4","13","1","4","13","0185","0","0","27","557","","ANDY DANGANA","07051155072","","","","M","2","Nigerian","24","4","1970","married","","","","andydanganat@gmail.com","","PAIKORO","07051155072","","BEHIND BUGBAFU WATER FACTORY, KURCHI ROAD KAFFIN KORO ","","","Normal","A+","None","","1","0","0","197.210.60.119","2020-01-03 10:45:30","2020-01-03 10:46:10","","","","1","0000-00-00 00:00:00","2019-05-08 12:05:54","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0360","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("186","0","1","0","0","7","16","1","2","14","0186","0","0","27","554","","ABDULLAHI BILYAMINU MAZAKUKA","08030574181","","","","M","1","Nigerian","6","12","1983","married","","","","angoaliyu76@yahoo.com","","MASHEGU","08030574181","","EL WAZIRI ESTATE BOSSO","","","Normal","B+","None","","1","0","0","105.112.115.177","2020-01-16 13:38:17","2020-01-16 13:39:01","","","","1","0000-00-00 00:00:00","2019-05-08 12:07:25","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                                                 
\n                                ","3","2019-12-13 10:26:59","0331","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("187","0","1","0","0","2","14","1","2","14","0187","0","0","27","558","","BAWA HASSAN","08063073837","","","","M","1","Nigerian","31","12","1970","married","","","","angoaliyu76@yahoo.com","","RAFI","08063073837","","BESIDE MI WUSHISHI HOUSING ESTATE MINNA","","","Normal","O","None","","1","0","0","197.210.47.109","2020-01-02 21:06:12","2020-01-02 21:06:49","","","","1","0000-00-00 00:00:00","2019-05-08 12:08:25","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0115","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("188","0","0","0","0","0","0","1","7","16","0188","0","0","27","555","","SULE ALIYU","08036749527","","","","M","1","Nigerian","29","7","1973","married","","","","angoaliyu76@yahoo.com","","MOKWA","08036749527","","CHIEF IMAM GUNGIGI HOUSE MOKWA LOCAL GOV\'T","","","Normal","O","None","","1","0","0","197.210.71.11","2019-12-10 07:44:21","2019-12-10 07:45:51","","","","1","0000-00-00 00:00:00","2019-05-08 12:09:50","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("189","0","1","0","0","10","21","1","10","21","0189","0","0","27","541","","YAKUB MARYAM","07066462640","","","","F","1","Nigerian","29","4","1986","married","","","","hajiyamaryam.yaq@gmail.com","","BIDA","07066462640","","MADARA AREA 3, HIMMA ROAD MINNA","","","Normal","A+","None","","1","0","0","197.210.47.211","2020-01-02 22:53:00","2020-01-02 22:53:38","","","","1","0000-00-00 00:00:00","2019-05-08 12:12:21","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0208","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("190","0","1","0","0","7","16","1","7","16","0190","0","0","27","548","","MOHAMMED MOHAMMED SIDISABA","08066544997","","","","M","1","Nigerian","11","3","1982","married","","","","sidisaba45@gmail.com","","KATCHA","08066544997","","EMI YADOKOZHI SIDISABA VILLAGE VIA KATCHA ","","","Normal","AB","None","","1","1","0","105.112.123.37","2020-02-26 17:36:14","2020-02-12 18:06:44","","","","1","0000-00-00 00:00:00","2019-05-08 12:14:45","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-15 14:17:36","0537","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("191","0","1","0","0","2","2","1","2","2","0191","0","0","27","550","","ILIYASU ADAMU NAZAKA","08077103184","","","","M","1","Nigerian","2","9","1997","married","","","","angoaliyu76@yahoo.com","","LAPAI","08077103184","","PHC 1224 SHAKU TAKUTI","","","Normal","AB","None","","1","0","0","197.210.227.102","2019-06-10 09:40:13","2019-06-10 09:40:38","","","","1","0000-00-00 00:00:00","2019-05-08 12:16:20","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("192","0","0","0","0","0","0","1","2","14","0192","0","0","27","543","","ABUBAKAR SA\'ADATU","08162995886","","","","F","1","Nigerian","7","5","1988","married","","","","angoaliyu76@yahoo.com","","BOSSO","08162995886","","BESIDE MAGAJI MEMORIAL SCHOOL ANGUWAN DAKACI MAIKUNKELE","","","Normal","B+","None","","1","0","0","197.210.226.8","2019-06-10 09:40:50","2019-06-10 09:41:16","","","","1","0000-00-00 00:00:00","2019-05-08 12:17:20","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("193","0","1","0","0","2","15","1","2","15","0193","0","0","27","552","","IBRAHIM ABUBAKAR IBELU","08056646262","","","","M","1","Nigerian","15","6","1977","married","","","","angoaliyu76@yahoo.com","","MAGAMA","08056646262","","KC 17 NO OLD NEPA ROAD KONTAGORA","","","Normal","A+","None","","1","0","0","105.112.115.177","2020-01-16 13:06:29","2020-01-16 13:06:38","","","","1","0000-00-00 00:00:00","2019-05-08 12:18:27","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0267","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("194","0","0","0","0","0","0","1","2","14","0194","0","0","27","546","","MUHAMMAD ZAINAB MALAGI","07068637245","","","","F","1","Nigerian","8","5","1996","married","","","","angoaliyu76@yahoo.com","","GBAKO","07068637245","","C/O PHARM SHEHU ATTAHIRU MALAGI, NIGER STATE","","","Normal","B+","None","","1","0","0","197.210.227.216","2019-06-10 09:42:04","2019-06-10 09:42:37","","","","1","0000-00-00 00:00:00","2019-05-08 12:20:08","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("195","0","1","0","0","1","11","1","1","11","0195","0","0","27","539","","SHAFIYI SABA MAYAKI","08149817535","","","","M","1","Nigerian","27","4","1970","married","","","","angoaliyu76@yahoo.com","","AGAIE","08149817535","","EMI MAYAKI TIFFIN EKOWUNA AGAIE","","","Normal","O","None","","1","0","0","105.112.114.140","2020-01-16 09:47:10","2020-01-16 09:47:52","","","","1","0000-00-00 00:00:00","2019-05-08 12:21:51","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0417","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("196","0","1","0","0","9","18","1","4","12","0196","0","0","7","137","","JAMES JENNIFER","08132836739","","","","F","2","Nigerian","28","2","1989","single","","","","gutterjenny@yahoo.com","","OTUKPO","08132836739","","TUNGA LOW COST KABAWA STREET OPPOSITE SAUKA KA HUTA","","","Normal","B+","None","","1","0","0","105.112.115.177","2020-01-16 14:42:47","2020-01-16 14:43:15","","","","1","0000-00-00 00:00:00","2019-05-08 12:23:30","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-07 07:54:07","0515","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("197","0","1","0","0","2","15","1","4","13","0197","0","0","27","543","","SHEHU GARBA","08038336651","","","","M","1","Nigerian","1","1","1980","married","","","","angoaliyu76@yahoo.com","","KONTAGORO","08038336651","","BS/AP190 ANGUWAN SARKIN HAUSAWA BOSSO CENTRAL II","","","Normal","A+","None","","1","0","0","197.210.71.191","2020-02-24 17:37:26","2020-02-24 17:42:03","","","","1","0000-00-00 00:00:00","2019-05-08 12:24:48","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2020-02-24 17:39:22","0586","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("198","0","1","0","0","10","21","1","2","14","0198","0","0","27","556","","ALI ROSEMARY","08059803474","","","","F","2","Nigerian","1","11","1980","married","","","","angoaliyu76@yahoo.com","","MUNYA","08059803474","","IW 3 AHMED LEMU ROAD OLD AIRPORT QRTRS, MINNA","","","Normal","B+","None","","1","0","0","197.210.227.19","2020-02-03 15:24:08","2020-02-03 15:32:12","","","","1","0000-00-00 00:00:00","2019-05-08 12:25:41","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0106","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("199","0","1","0","0","10","20","1","10","20","0199","0","0","27","551","","HASSAN IBRAHIM","08144676747","","","","M","1","Nigerian","11","11","1980","married","","","","babsyteego@gmail.com","","LAVUN","08144676747","","TUNGA TUNDUN WADA OPPOSITE TOP MEDICAL JUNCTION  HOUSE NO STD 125 KUTIGI","","","Normal","O","None","","1","0","0","197.210.226.8","2019-06-10 09:45:17","2019-06-10 09:45:38","","","","1","0000-00-00 00:00:00","2019-05-08 12:27:08","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("200","0","1","0","0","4","13","1","4","13","0200","0","0","27","541","","ABUBAKAR ASMAU HAJIYA","08138211707","","","","F","1","Nigerian","22","5","1982","married","","","","abubakarasmau2013@gmail.com","","BIDA","08138211707","","NO. 1 KOLAWOLE STREET TUNGA OPPOSITE BILLWAY HOTEL MINNA","","","Normal","O","None","","1","0","0","197.210.60.119","2020-01-03 10:53:33","2020-01-03 10:54:09","","","","1","0000-00-00 00:00:00","2019-05-08 12:28:24","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0189","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("201","0","1","0","0","10","21","1","10","21","0201","0","0","27","548","","SAHEED ZAINAB","08131240718","","","","F","1","Nigerian","10","4","1994","single","","","","saheedzainab@yahoo.com","","KATCHA","08131240718","","OLD AIRPORT QRTRS MINNA","","","Normal","B+","None","","1","0","0","197.210.45.38","2020-01-03 13:36:09","2020-01-03 13:36:45","","","","1","0000-00-00 00:00:00","2019-05-08 12:31:02","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0362","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("202","0","1","0","0","10","21","1","10","21","0202","0","0","27","562","","BALA BLESSING","08036727725","","","","F","2","Nigerian","28","10","1993","single","","","","blessingbala1028@gmail.com","","TAFA","08036727725","","NO. 29 SADIYA STREET SAUKA KAHUTA","","","Normal","O","None","","1","0","0","197.210.60.119","2020-01-03 12:10:48","2020-01-03 12:11:26","","","","1","0000-00-00 00:00:00","2019-05-08 12:32:44","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-13 11:37:56","0497","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("203","0","0","0","0","0","0","1","7","17","0203","0","0","27","550","","ISAH UMAR","08036839528","","","2019-05-08-133450ISAH PGDE.pdf.pdf","M","1","Nigerian","23","3","1968","married","","","","uisah651@gmail.com","","GULU-VULEGBO","08036839528","","FCT UBEB AREA II GARKI, ABUJA","GULU-VULEGBO HOUSE NO. 23 LAPAI, MIGER STATE","2019-05-08-131420.jpg","Normal","AB","None","","1","0","0","41.203.72.231","2019-05-14 10:12:09","2019-05-14 10:12:19","","","","1","0000-00-00 00:00:00","2019-05-08 12:47:38","0000-00-00 00:00:00","","","","","","","3","ISAH UMAR","FCT UBEB AREA II GARKI, ABUJA","0","","0","0000-00-00 00:00:00","","25","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("204","0","1","0","0","4","12","1","4","13","0204","0","0","0","0","","Umar Saleh","","","","2019-05-09-170841files.pdf.pdf","","0","","","","","","","","","sumar7481@gmail.com","","","08068315098","","","","2019-05-09-165838.jpg","","","","","1","0","0","105.112.122.11","2020-02-08 14:55:33","2020-02-08 14:56:06","","","","1","0000-00-00 00:00:00","2019-05-08 13:07:12","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-19 14:58:25","0588","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("205","0","1","0","0","7","16","1","7","16","0205","0","0","27","541","","Amina Umar Chado","07053305330","","","2019-05-16-121840AMINA CHADO 2.pdf.pdf","F","1","Nigerian","12","6","1988","married","","","","myandalu@gmail.com","","Bida","07053305330","","Emi Dan-Iyan Nupe,\\\\r\\\\nUmaru Majigi Palace\\\\r\\\\nBida\\\\r\\\\nNiger State","","2019-05-16-120359.jpg","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 13:50:07","2020-01-16 13:51:53","","","","1","0000-00-00 00:00:00","2019-05-08 17:47:21","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0009","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("206","0","1","0","0","7","16","1","7","16","0206","0","0","27","546","","MOHAMMED KASIMU","08064277410","","","","M","1","Nigerian","6","5","1996","single","","","","mkasimu3076@gmail.com","","GBAKO","08064277410","","BEHIND DAYAMAZ GUEST INN KPAKUNGU MINNA","","","Normal","O","None","","1","0","0","197.210.60.119","2020-01-03 11:45:37","2020-01-03 11:46:17","","","","1","0000-00-00 00:00:00","2019-05-09 09:56:18","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0146","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("207","0","1","0","0","4","12","1","4","12","0207","0","0","27","550","","LIMAN ALIYU IBRAHIM","08036108100","","","","M","1","Nigerian","18","6","1969","married","","","","angoaliyu76@yahoo.com","","LAPAI","08036108100","","BEHIND NITEL OFFICE LAPAI","","2019-10-02-150547.jpg","Normal","B+","None","","1","0","0","105.112.112.20","2020-01-28 16:12:50","2020-01-28 16:12:59","","","","1","0000-00-00 00:00:00","2019-05-09 10:01:17","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0227","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("208","0","0","0","0","0","0","1","10","21","0208","0","0","27","562","","AYUBA FLORENCE","07036188636","","","","F","2","Nigerian","13","2","1985","married","","","","emmanueldavid705@gmail.com","","TAFA","07036188636","","IJA GBAGYI TAFA LGA SABON WUSE ","","","Normal","O","None","","1","0","0","197.210.226.124","2019-06-10 09:49:52","2019-06-10 09:50:35","","","","1","0000-00-00 00:00:00","2019-05-09 10:02:45","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("209","0","0","0","0","0","0","1","2","15","0209","0","0","27","547","","GARBA SHIFILO","08030593295","","","","M","2","Nigerian","16","6","1969","married","","","","shifilogarba2017@gmai.com","","GURARA","08030593295","","HOUSE  NO 038 KOPATI ROAD GAWU BABANGIDA ","","","Normal","O","None","","1","0","0","105.112.112.20","2020-01-28 16:08:01","2020-01-28 16:08:24","","","","1","0000-00-00 00:00:00","2019-05-09 10:04:37","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("210","0","1","0","0","2","2","1","2","14","0210","0","0","27","551","","SARATU ALHAJI LIMAN","08034762251","","","","F","1","Nigerian","25","4","1993","married","","","","angoaliyu76@yahoo.com","","LAVUN","08034762251","","AREA 2 LONDON STREET MINNA","","","Normal","O","None","","1","0","0","197.210.227.117","2019-06-10 09:51:37","2019-06-10 09:52:33","","","","1","0000-00-00 00:00:00","2019-05-09 10:06:20","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("211","0","0","0","0","0","0","1","4","4","0211","0","0","27","544","","IBRAHIM ZAYYANU ABDULLAHI","08095116305","","","","M","1","Nigerian","12","2","1994","single","","","","zayyanu1991@gmail.com","","CHANCHAGA","08095116305","","NO. D3 ALH SANI CLOSED 123 QRTRS MINNA","","","Normal","A+","None","","1","0","0","105.112.115.177","2020-01-16 14:34:13","2020-01-16 14:34:35","","","","1","0000-00-00 00:00:00","2019-05-09 10:08:22","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("212","0","1","0","0","7","16","1","2","14","0212","0","0","27","543","","MUSA IBRAHIM","08066768535","","","","M","1","Nigerian","20","2","1991","single","","","","musaibraheembosso@gmail.com","","BOSSO","08066768535","","BOSSO ANGUWAN SARKI TOWN MINNA","","","Normal","O","None","","1","0","0","105.112.115.84","2020-02-12 16:35:08","2020-02-12 16:36:05","","","","1","0000-00-00 00:00:00","2019-05-09 10:10:23","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2020-02-11 15:11:16","0549","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("213","0","1","0","0","2","2","1","2","2","0213","0","0","7","123","","AKIGHIR DOMINIC ORDUEN","08099223065","","","","M","2","Nigerian","3","12","1996","single","","","","akighir2525@yahoo.com","","GBOKO","08099223065","","CHEMBER MARKET GBOKO BENUE STATE","","","Normal","A+","None","","1","0","0","41.190.14.68","2019-09-20 16:22:38","2019-09-20 19:06:39","","","","1","0000-00-00 00:00:00","2019-05-09 10:15:11","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0026","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("214","0","1","0","0","1","10","1","1","10","0214","0","0","27","543","","ABDULAZEEZ MOSHOOD","08032078931","","","","M","1","Nigerian","28","10","1995","single","","","","moshoodabdulazeez2810@gmail.com","","BOSSO","08032078931","","JAFARU MAIRIGA STREET, ANGUWAN KANAWA BOSSO","","","Normal","O","None","","1","0","0","197.210.84.253","2020-01-14 20:44:00","2020-01-14 20:44:14","","","","1","0000-00-00 00:00:00","2019-05-09 10:20:07","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0041","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("215","0","1","0","0","2","14","1","2","14","0215","0","0","17","317","","OPARANOZIE COLLECT","07039651651","","","","F","2","Nigerian","10","10","1980","single","","","","collectoparanozie@gmail.com","","OWERRI NORTH","07039651651","","UMUAWUKA EMI OWERRI, IMO STATE","","","Normal","O","None","","1","0","0","197.210.65.38","2020-01-02 20:54:41","2020-01-02 20:55:56","","","","1","0000-00-00 00:00:00","2019-05-09 10:25:15","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0073","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("216","0","1","0","0","9","6","1","9","6","0216","0","0","32","681","","DAHIRU AHMED HABIBA","07037958751","","","","F","1","Nigerian","15","4","1995","married","","","","habibatdahiru23@gmail.com","","WASE","07037958751","","ALBISHIRI AREA 1, ALONG BIDA ROAD, BEHIND SANJO MOTTO MINNA","","","Normal","O","None","","1","0","0","105.112.122.11","2020-02-08 14:52:34","2020-02-08 14:55:24","","","","0","0000-00-00 00:00:00","2019-05-09 10:29:38","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0022","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("217","0","1","0","0","10","22","1","2","15","0217","0","0","27","541","","ALIYU ABDULLAHI","08069442644","","","","M","1","Nigerian","1","4","1989","married","","","","abdullahi735@gmail.com","","BIDA","08069442644","","IMAM SHAFIYI ROAD, BANMA BIDA","","","Normal","O","None","","1","0","0","197.210.227.184","2019-06-10 09:57:46","2019-06-10 09:58:12","","","","1","0000-00-00 00:00:00","2019-05-09 10:31:02","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-03 08:17:42","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("218","0","1","0","0","2","15","1","2","15","0218","0","0","27","550","","IDRIS MUSA VATSA","08036928717","","","","M","1","Nigerian","12","12","1978","married","","","","angoaliyu76@yahoo.com","","LAPAI","08036928717","","GURARA AREA ALONG BIDA ROAD MINNA","","","Normal","O","None","","1","0","0","105.112.116.159","2020-02-17 09:10:03","2020-02-17 09:10:28","","","","1","0000-00-00 00:00:00","2019-05-09 10:33:05","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-19 15:59:37","0585","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("219","0","1","0","0","1","11","1","1","11","0219","0","0","17","304","","UWALAKA UGOCHUKWU PHILIP","08032800683","","","","F","2","Nigerian","15","9","1988","single","","","","philipope6@gmail.com","","NGORO OKPALA","08032800683","","NO 4 TOP MEDICAL ROAD TUNGA MINNA","","2019-09-20-152902.jpg","Normal","AB","None","","1","0","0","105.112.115.194","2020-01-29 08:37:40","2020-01-29 08:41:13","","","","1","0000-00-00 00:00:00","2019-05-09 10:39:23","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0023","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("220","0","0","0","0","0","0","1","10","20","0220","0","0","27","549","","NUHU GAMBO","07066820490","","","","M","1","Nigerian","10","11","1993","single","","","","muhammedfawwaz1@gmail.com","","KONTAGORA","07066820490","","MECHANIC BYE PASS MINNA","","","Normal","O","None","","1","0","0","197.210.227.207","2019-06-10 09:59:05","2019-06-10 09:59:58","","","","1","0000-00-00 00:00:00","2019-05-09 10:41:27","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("221","0","0","0","0","0","0","1","1","10","0221","0","0","27","544","","MOSES GALADIMA","09060214724","","","2019-05-09-122109jpg2pdf(70).pdf.pdf","M","2","Nigerian","23","10","1984","married","","","","galadima3434@gmail.com","","KAFFINKORO","09060214724","","BEHIND NEW MARKET KAFFINKORO, NIGER STATE","BEHIND NEW MARKET KAFFINKORO, NIGER STATE","2019-05-09-122123.jpg","Normal","A+","None","NORMAL","1","1","0","41.190.14.207","2019-05-09 12:04:45","0000-00-00 00:00:00","","","","1","0000-00-00 00:00:00","2019-05-09 12:04:31","0000-00-00 00:00:00","","","GALADIMA YERIMA","07056283095","BEHIND NEW MARKET KAFFINKORO, NIGER STATE","FATHER","1","MOSES GALADIMA","BEHIND NEW MARKET KAFFINKORO, NIGER STATE","0","","0","0000-00-00 00:00:00","","3","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("222","0","0","0","0","0","0","1","7","17","0222","0","0","0","0","","ISAH UMAR","","","","","","0","","","","","","","","","uisah651@gmail.com","","","08036839528","","","","","","","","","1","1","0","41.203.72.223","2019-05-09 13:42:11","2019-05-09 13:42:06","","","","0","0000-00-00 00:00:00","2019-05-09 13:39:08","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("223","0","1","0","0","7","16","1","7","16","0223","0","0","27","557","","ABDULLAHI YUSUF DADA","08162427411","","","","M","1","Nigerian","6","8","1994","single","","","","fatimaumardada@gmail.com","","PAIKORO","08162427411","","OPPOSITE MAGAJI SPECIALIST HOOSPITAL PAIKO","","","Normal","O","None","","1","0","0","105.112.120.40","2019-12-02 13:18:14","2019-12-02 13:21:33","","","","1","0000-00-00 00:00:00","2019-05-09 13:48:10","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-05 17:22:00","0651","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("224","0","1","0","0","4","12","1","4","12","0224","0","0","27","548","","HASSAN MOHAMMED","08069194498","","","","M","1","Nigerian","20","4","1989","married","","","","mohammedh487@gmail.com","","KATCHA","08069194498","","KPAKUNGU BESIDE LIMAWA MODEL ","","","Normal","A+","None","","1","0","0","197.210.85.22","2020-01-02 15:52:30","2020-01-02 15:53:02","","","","1","0000-00-00 00:00:00","2019-05-09 13:49:40","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0014","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("225","0","1","0","0","1","1","1","1","1","0225","0","0","27","544","","SHUAIBU ISMAIL ALI","08166479199","","","","M","1","Nigerian","10","3","1995","single","","","","shuaibuismail@gmail.com","","CHANCHAGA","08166479199","","NO. 34 ZONE A GIDAN MADARA,  BEHIND NECO STAFF OFFICE MINNA","","","Normal","O","None","","1","0","0","105.112.113.95","2020-01-15 11:45:55","2020-01-15 11:54:17","","","","1","0000-00-00 00:00:00","2019-05-09 13:51:07","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0036","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("226","0","1","0","0","4","13","1","4","13","0226","0","0","27","561","","BALA SAFIYA","07069686292","","","","F","1","Nigerian","15","7","1987","married","","","","safiyabala6292@gmail.com","","SULEJA","07069686292","","OLD ATC LAYOUT BACK OF PEUGEOT COMPANY BOSSO ROAD MINNA ","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 11:36:02","2020-01-16 11:36:12","","","","1","0000-00-00 00:00:00","2019-05-09 13:52:18","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0153","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("227","0","0","0","0","0","0","1","1","11","0227","0","0","27","550","","USMAN IDRIS GATI","08036364790","","","","M","1","Nigerian","1","7","1988","married","","","","idrisusman156@gmail.com","","LAPAI","08036364790","","LATE ALH. ABDULLAHI IBRAHIM GATI HOUSE BEHIND NSTA GARAGE TUNGA MINNA","","","Normal","O","None","","1","0","0","197.210.55.136","2019-06-10 10:32:35","2019-06-10 10:32:49","","","","1","0000-00-00 00:00:00","2019-05-09 13:56:43","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("228","0","0","0","0","0","0","1","10","20","0228","0","0","27","556","","MAHMOUD HARUNA RAMATU","08163422842","","","","F","1","Nigerian","12","12","1974","married","","","","angoaliyu76@yahoo.com","","MUNYA","08163422842","","HOUSE NO 157 BEHIND P.W YARO CHANCHAGA MINNA","","","Normal","O","None","","1","1","0","82.145.221.27","2019-11-04 12:26:45","2019-06-10 10:32:23","","","","1","0000-00-00 00:00:00","2019-05-09 13:58:25","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("229","0","0","0","0","0","0","1","2","2","0229","0","0","17","304","","EBERE MARCEL CHUKWUEMEKA","07032762272","","","","M","2","Nigerian","24","4","1976","married","","","","eberemarcel@yahoo.com","","NGOR OKPALA","07032762272","","UMUOGI UMUEKWUNE NGOR-OKPALA LGA","","","Normal","O","None","","1","0","0","197.210.55.136","2019-06-10 10:33:09","2019-06-10 10:34:40","","","","1","0000-00-00 00:00:00","2019-05-09 13:59:51","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("230","0","1","0","0","2","2","1","2","2","0230","0","0","27","550","","SONMAJI ABUBAKAR HASSAN","08037917752","","","","M","1","Nigerian","21","2","1993","single","","","","sonmajiabubakar@gmail.com","","LAPAI","08037917752","","NO 14 BEHIND FEDERAL INEC OFFICE MINNA","","","Normal","O","None","","1","1","0","105.112.120.141","2020-01-23 09:25:28","2020-01-02 21:05:58","","","","1","0000-00-00 00:00:00","2019-05-09 14:01:25","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0012","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("231","0","1","0","0","2","2","1","2","2","0231","0","0","27","555","","ABDULLAHI HALIMA","07015229714","","","","F","1","Nigerian","3","5","1993","single","","","","angoaliyu76@yahoo.com","","MOKWA","07015229714","","BARIKIN SALE OPPOSITE POLICE STATION","","","Normal","O","None","","1","0","0","197.210.47.169","2020-01-02 21:38:40","2020-01-02 21:39:13","","","","1","0000-00-00 00:00:00","2019-05-09 14:04:39","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0215","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("232","0","0","0","0","0","0","1","2","14","0232","0","0","27","557","","MOHAMMED SANI DANJUMA","08103335272","","","","M","1","Nigerian","2","2","1987","married","","","","angoaliyu76@yahoo.com","","PAIKORO","08103335272","","KAFFIN KORO SARKIN PAWA","","","Normal","B+","None","","1","0","0","197.210.55.85","2019-06-10 10:39:20","2019-06-10 10:39:44","","","","1","0000-00-00 00:00:00","2019-05-09 14:05:42","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("233","0","0","0","0","0","0","1","4","12","0233","0","0","27","541","","GIMBA ALHAJI NDAGI","07034194928","","","","M","1","Nigerian","7","5","1977","married","","","","angoaliyu76@yahoo.com","","BIDA","07034194928","","TAYI VILLAGE ","","","Normal","B+","None","","1","1","0","197.210.45.86","2019-10-06 15:55:47","2019-06-10 10:41:08","","","","1","0000-00-00 00:00:00","2019-05-09 14:06:35","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("234","0","1","0","0","7","5","1","7","5","0234","0","0","27","557","","BASHI TYAV JOSEPH","07033681121","","","","M","2","Nigerian","12","8","1987","married","","","","angoaliyu76@yahoo.com","","PAIKORO","07033681121","","OLD CUSTOM BARRACKS TUNGA MINNA","","","Normal","O","None","","1","0","0","197.210.60.119","2020-01-03 11:31:48","2020-01-03 11:32:19","","","","1","0000-00-00 00:00:00","2019-05-09 14:07:38","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0265","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("235","0","1","0","0","1","11","1","1","11","0235","0","0","27","554","","MAMMAN ABDULLAHI MATANE","08028530239","","","","M","1","Nigerian","7","1","1973","married","","","","angoaliyu76@yahoo.com","","MASHEGU","08028530239","","CHADON DADI KONTAGORA","","","Normal","A+","None","","1","0","0","197.210.60.119","2020-01-03 10:19:18","2020-01-03 10:19:49","","","","1","0000-00-00 00:00:00","2019-05-09 14:08:44","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0047","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("236","0","1","0","0","4","12","1","4","12","0236","0","0","27","549","","GARBA SHEHU","08036497060","","","","M","1","Nigerian","2","5","1976","married","","","","angoaliyu76@yahoo.com","","KONTAGORA","08036497060","","GRA 32 UNGUWAN GABAS MASALLACIN JUMMA KONTAGORA","","","Normal","A+","None","","1","0","0","197.210.60.119","2020-01-03 10:39:01","2020-01-03 10:39:34","","","","1","0000-00-00 00:00:00","2019-05-09 14:09:39","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0046","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("237","0","1","0","0","4","12","1","4","12","0237","0","0","27","560","","AWEYETU LARAI JANET","07060520959","","","","F","2","Nigerian","1","1","1974","married","","","","angoaliyu76@yahoo.com","","SHIRORO","07060520959","","C/O ECWA GOSPEL CHURCH SAUKA KA HUTA","","","Normal","O","None","","1","0","0","105.112.112.48","2020-02-21 12:29:56","2020-02-21 12:30:03","","","","1","0000-00-00 00:00:00","2019-05-09 14:10:40","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("238","0","1","0","0","10","21","1","10","21","0238","0","0","27","544","","SULEIMAN MARYAM","08163648863","","","","F","1","Nigerian","24","2","1983","married","","","","suleimanmaryam1983@gmail.com","","CHANCHAGA","08163648863","","DUTSEN KURA GWARI","","","Normal","O","None","","1","0","0","197.210.65.76","2020-01-02 22:54:47","2020-01-02 22:55:24","","","","1","0000-00-00 00:00:00","2019-05-09 14:11:50","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0156","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("239","0","0","0","0","0","0","1","2","14","0239","0","0","27","547","","BELLO ABUBAKAR ","09051097060","","","","M","1","Nigerian","2","2","1992","married","","","","angoaliyu76@yahoo.com","","GURARA","09051097060","","LEFU TAILE","","","Normal","B+","None","","1","0","0","197.210.55.136","2019-06-10 10:44:11","2019-06-10 10:45:27","","","","1","0000-00-00 00:00:00","2019-05-09 14:12:50","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("240","0","0","0","0","0","0","1","10","21","0240","0","0","0","0","","Shehu ","","","","","","0","","","","","","","","","nasirukatibu@gmail.com","","","07037769881","","","","","","","","","1","1","0","197.210.227.72","2019-05-10 01:46:41","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-05-10 01:45:45","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("241","0","1","0","0","1","11","1","1","11","0241","0","0","27","554","","MIKAILU ADAMU MAZAKUKA","08068113819","","","2019-05-10-102945MIKAIKU ADAMU MAZAKUKA-converted.pdf.pdf","M","1","Nigerian","23","2","1972","married","","","","alhassanisah111@gmail.com","","MAZAKUKA","08134068326","","MASHEGU LGA, MASGEGU
\n","MASHEGU LGA, MASGEGU
\n","2019-05-10-092107.jpg","Normal","O","None","NIL","1","0","0","105.112.122.89","2020-02-26 10:38:44","2020-02-26 10:43:34","","","","1","0000-00-00 00:00:00","2019-05-10 09:12:44","0000-00-00 00:00:00","","","ALH ABDULLAHI MAZAKUKA","08035882803"," EL-WAZIRI,BOSSO,MINNA","FATHER","1","ALHASSAN ISAH","MASHEGU LGA, MASGEGU
\n","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0270","15","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("242","0","1","0","0","4","12","1","4","12","0242","0","0","27","553","","Aliyu Galadima","08088665592","","","2019-05-10-103400convert-jpg-to-pdf.net_2019-05-10_11-33-20.pdf.pdf","M","1","Nigerian","4","3","1992","single","","","","littlebengseworld@gmail.com","","Kotonkoro","08088665592","","Minna, Niger State","Minna, Niger State","2019-05-10-100747.jpeg","Normal","O","None","None","1","0","0","105.112.115.177","2020-01-16 11:43:40","2020-01-16 11:43:52","","","","1","0000-00-00 00:00:00","2019-05-10 10:02:07","0000-00-00 00:00:00","","","Al-Amin Aliyu","08088665592","Minna, Niger State","Son","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-05 07:34:56","0509","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("243","0","0","0","0","0","0","1","4","12","0243","0","0","0","0","","MUSA IBRAHIM DANLADI","","","","","","0","","","","","","","","","ibrahimsh247@gmail.com","","","07034675409","","","","","","","","","1","0","0","41.190.12.191","2019-05-10 12:07:15","2019-05-10 14:05:54","","","","0","0000-00-00 00:00:00","2019-05-10 11:22:29","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("244","0","0","0","0","0","0","1","2","14","0244","0","0","0","0","","JOHN ONEYKA AGBARA","","","","","","0","","","","","","","","","johnjohnny913@gmail.com","","","07060816391","","","","","","","","","1","0","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-05-10 12:45:56","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("245","0","1","0","0","7","16","1","2","14","0245","0","0","27","550","","Fatima Hassana Mohammed","08030402720","","","2019-05-10-160314convert-jpg-to-pdf.net_2019-05-10_17-02-48.pdf.pdf","F","1","Nigerian","17","7","1991","married","","","","hassyelnass@gmail.com","","Minna","08030402720","","Minna, Niger State","Minna, Niger State","2019-05-10-150942.jpg","Normal","O","None","None","1","0","0","105.112.115.177","2020-01-16 13:39:50","2020-01-16 13:40:10","","","","1","0000-00-00 00:00:00","2019-05-10 15:03:18","0000-00-00 00:00:00","","","Mohammed Danladi Musa","07034612556","Minna, Niger State","Father","1","","Private","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0355","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("246","0","0","0","0","0","0","1","7","16","0246","0","0","27","541","","MUAZU ATTAHIRU NAGOGO","08066661957","","","","M","1","Nigerian","23","12","1991","single","","","","muazuattahirunagogo@gmail.com","","BIDA","08066661957","","E 508, MASAGA/BANTUWA AREA, BIDA, NIGER STATE","E 508, MASAGA/BANTUWA AREA, BIDA, NIGER STATE","2019-05-10-151751.jpg","Normal","A+","Others","NONE","1","1","0","41.190.12.92","2019-05-14 10:32:26","2019-05-13 14:51:50","","","","1","0000-00-00 00:00:00","2019-05-10 15:03:26","0000-00-00 00:00:00","","","MOHAMMED ATTAHIRU","08169656956","E 508, MASAGA/BANTUWA AREA, BIDA, NIGER STATE","FATHER","1","MOHAMMED ATTAHIRU","E 508, MASAGA/BANTUWA AREA, BIDA, NIGER STATE","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("247","0","0","0","0","0","0","1","1","11","0247","0","0","0","0","","MOHAMMED TANIMU SONFADA ","","","","","","0","","","","","","","","","mohammedtanimu112@gmail.com","","","08154065281","","","","","","","","","1","1","0","141.0.13.234","2019-05-10 15:19:01","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-05-10 15:15:05","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("248","0","0","0","0","0","0","1","4","13","0248","0","0","0","0","","YISA MARY LARE","","","","","","0","","","","","","","","","yisapeter@gmail.com","","","08068143931","","","","","","","","","1","0","0","105.112.112.151","2019-05-10 16:20:06","2019-05-10 16:24:32","","","","0","0000-00-00 00:00:00","2019-05-10 16:19:13","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("249","0","1","0","0","2","15","1","2","15","0249","0","0","27","544","","YISA MARY LARE","08068143931","","","2019-05-10-165001scan yisa0001.pdf.pdf","F","2","Nigerian","26","12","1979","single","","","","peteryisa@ymail.com","","DOKO","08068143931","","THE APOSTOLIC FAITH CHURCH LUGBE ABUJA","THE APOSTOLIC FAITH CHURCH DOKO TAKOGBODO","2019-05-10-162854.jpg","Normal","O","None","","1","0","0","197.210.60.119","2020-01-03 11:25:27","2020-01-03 11:26:43","","","","1","0000-00-00 00:00:00","2019-05-10 16:25:34","0000-00-00 00:00:00","","","PETER YISA","08061669331","THE APOSTOLIC FAITH CHURCH DOKO TAKOGBODO","BROTHER","3","SELF","THE APOSTOLIC FAITH CHURCH DOKO TAKOGBODO","1","                                
\n                                                                 
\n                                ","3","2019-11-08 10:20:24","0567","3","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("250","0","0","0","0","0","0","1","1","11","0250","0","0","27","551","","YISA PETER","08061669331","","","2019-05-10-172935scan Peter0001.pdf.pdf","M","2","Nigerian","3","7","1984","married","","","","yisapeter@gmail.com","","DOKO","08061669331","","TAKOGODO TACHI DOKO, LAVUN, NIGER STATE","TAKOGODO TACHI DOKO, LAVUN, NIGER STATE","2019-05-10-171009.jpg","Normal","O","None","","1","0","0","105.112.121.37","2019-05-18 14:03:39","2019-05-18 14:05:29","","","","1","0000-00-00 00:00:00","2019-05-10 17:08:10","0000-00-00 00:00:00","","","YISA MARY","08068143931","TAKOGODO TACHI DOKO, LAVUN, NIGER STATE","SISTER","1","SELF","TAKOGODO TACHI DOKO, LAVUN, NIGER STATE","0","","0","0000-00-00 00:00:00","","10","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("251","0","0","0","0","0","0","1","1","11","0251","0","0","27","541","","KUDU ALHAJI NASIRU","08060511103","","","2019-05-10-175115scan KUDU0001.pdf.pdf","M","1","Nigerian","1","2","1982","married","","","","kudualhaji@gmail.com","","BIDA","08060511103","","KARAKO DARACHITA AREA BIDA, NIGER STATE","KARAKO DARACHITA AREA BIDA, NIGER STATE","2019-05-10-173637.jpg","Normal","O","None","","1","0","0","41.190.14.128","2019-10-28 14:44:00","2019-10-28 14:44:37","","","","1","0000-00-00 00:00:00","2019-05-10 17:34:48","0000-00-00 00:00:00","","","MOHAMMED NASIRU","09067653100","KARAKO DARACHITA AREA BIDA, NIGER STATE","SON","1","SELF","KARAKO DARACHITA AREA BIDA, NIGER STATE","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("252","0","0","0","0","0","0","1","2","2","0252","0","0","27","560","","Moses Anthony","08106986746","","","2019-05-12-135137Upload.pdf.pdf","M","2","Nigerian","3","3","1990","married","","","","mosesanthony0303@gmail.com","","Baga ikko","08106986746","","Fadikpe Area, opposite central market, minna.","Baga ikko area, erena, Niger state.","2019-05-11-234432.jpg","Normal","B+","None","NILL","1","1","0","197.210.174.33","2020-02-08 14:07:19","2020-02-08 14:04:38","","","","1","0000-00-00 00:00:00","2019-05-10 19:14:40","0000-00-00 00:00:00","","","Mr Moses Daudu","08163142580","Baga ikko area, erena, Niger state.","Father","1","Mr Solomon Durodola","Nyinkangbe, off bida road, gurara junction, minna, Niger state.","0","","0","0000-00-00 00:00:00","","5","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("253","0","1","0","0","2","14","1","2","15","0253","0","0","27","544","","BALKISU YUNUSA","08138177687","","","2019-05-11-125317Document0.pdf.pdf","F","1","Nigerian","7","2","1983","married","","","","balkisuyunusa3887@gmail.com","","NIGER","08138177687","","No.142 Mu\'azu street central mosque minna Niger State","No.142 Mu\'azu street central mosque minna Niger State","2019-05-11-114248.jpg","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 13:05:19","2020-01-16 13:05:29","","","","1","0000-00-00 00:00:00","2019-05-11 11:28:43","0000-00-00 00:00:00","","","LIMAN MOHAMMED SALLAU","08033190865","No.142 Mu\'azu street central mosque minna Niger State","HUSBAND","1","BALKISU YUNUSA","No.142 Mu\'azu street central mosque minna Niger State","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2020-01-24 10:51:02","0490","8","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("254","0","0","0","0","0","0","1","9","6","0254","0","0","27","554","","ALHASSAN ISAH","08068113819","","","2019-05-11-170959ALHASSAN.pdf.pdf","M","1","Nigerian","23","2","1972","married","","","","alhassanisah111@gmail.com","","MAZAKUKA","08068113819","","MASHEGU LGA, MASHEGU","MASHEGU LGA, MASHEGU","2019-05-11-131218.jpg","Normal","O","None","NIL","1","1","0","197.210.226.205","2019-11-15 17:31:44","2019-10-31 10:06:53","","","","1","0000-00-00 00:00:00","2019-05-11 13:09:39","0000-00-00 00:00:00","","","ALH ABDULLAHI MAZAKUKA","08035882803"," EL-WAZIRI,BOSSO,MINNA","FATHER","1","ALHASSAN ISAH","MASHEGU LGA, MASHEGU","1","","1","0000-00-00 00:00:00","0551","15","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("255","0","1","0","0","9","18","1","9","18","0255","0","0","27","550","","HASSAN ROFYAN","08061610744","","","2019-05-13-152949hassan rofyan.pdf.pdf","M","1","Nigerian","4","6","1995","married","","","","hassanrofyan44@gmail.com","","LAPAI","08061610744","","Y50 BANI ROAD LAPAI, NIGER STATE","Y50 BANI ROAD LAPAI, NIGER STATE","2019-05-12-182655.jpg","Normal","B+","None","NORMAL","1","1","0","105.112.122.89","2019-12-02 09:37:24","2019-05-17 19:48:21","","","","1","0000-00-00 00:00:00","2019-05-12 18:24:48","0000-00-00 00:00:00","","","YAKUBU AHMED ILYASU","08136662733","AHMADU BELLO WAY LAPAI, NIGER STATE","FRIEND","1","HASSAN ROFYAN","Y50 BANI ROAD LAPAI, NIGER STATE","1","                                
\n                                                                 
\n                                ","3","2019-11-08 10:34:38","0648","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("256","0","0","0","0","0","0","1","4","13","0256","0","0","27","561","","ABDULLAHI NDAGI ABBAS","08060258638","","","","M","1","Nigerian","22","12","1983","married","","","","aaandagiabbas@gmail.com","","SULEJA","08060258638","","GIDAN BABAN ZARA- BEHIND OLD UBA BANK SULEJA LOCAL LGA","","","Normal","O","None","","1","0","0","105.112.120.159","2019-11-01 13:19:13","2019-11-01 13:19:28","","","","1","0000-00-00 00:00:00","2019-05-13 08:58:22","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("257","0","1","0","0","4","13","1","4","13","0257","0","0","27","551","","YAKPE ALHAJI MOHAMMED","08168762060","","","","M","1","Nigerian","27","5","1976","married","","","","mohammedalhajiyakpe@gmail.com","","LAVUN","08168762060","","EMILANGBA TAKO DOKO","","2019-09-23-153048.jpg","Normal","A+","None","","1","0","0","105.112.112.20","2020-01-28 16:02:28","2020-01-28 16:03:17","","","","1","0000-00-00 00:00:00","2019-05-13 09:00:52","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0095","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("258","0","1","0","0","2","15","1","2","15","0258","0","0","27","543","","ISAH SARAH TALATU","08065642655","","","","F","1","Nigerian","27","7","1973","single","","","","angoaliyu76@yahoo.com","","BOSSO","08065642655","","ANGUWAN SARKI KUNTUKO AFTER ANTENA BOSSO","","","Normal","A+","None","","1","0","0","105.112.115.177","2020-01-16 12:57:01","2020-01-16 12:57:11","","","","1","0000-00-00 00:00:00","2019-05-13 09:02:11","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0244","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("259","0","1","0","0","4","12","1","4","12","0259","0","0","29","600","","OGUNWARE ADEWALE AUGUSTINE","08079926789","","","","M","2","Nigerian","24","8","1984","married","","","","adewaleaugustine24@gmail.com","","OSE","08079926789","","BEHIND BRIGHTER SCHOOL MINNA","","","Normal","O","None","","1","0","0","105.112.112.20","2020-01-28 16:13:15","2020-01-28 16:13:32","","","","1","0000-00-00 00:00:00","2019-05-13 09:04:29","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","0000-00-00 00:00:00","0312","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("260","0","1","0","0","7","16","1","7","16","0260","0","0","27","557","","MOHAMMED RABIU","09031188333","","","","M","1","Nigerian","27","9","1994","married","","","","angoaliyu76@yahoo.com","","PAIKORO","09031188333","","FATIMA JIRAGO PAIKO","","","Normal","AB","None","","1","0","0","197.210.60.119","2020-01-03 11:57:24","2020-01-03 11:57:54","","","","1","0000-00-00 00:00:00","2019-05-13 09:05:38","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0670","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("261","0","1","0","0","7","16","1","7","16","0261","0","0","27","541","","SHEHU A ABUBAKAR","08036467477","","","","M","1","Nigerian","12","2","1967","married","","","","limatee20@gmail.com","","BIDA","08036467477","","NO 11 UBA STREET OFF OKADA ROAD MINNA","","","Normal","O","None","","1","0","0","197.210.70.15","2020-02-04 17:30:59","2020-02-04 17:33:04","","","","1","0000-00-00 00:00:00","2019-05-13 09:07:05","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0369","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("262","0","0","0","0","0","0","1","2","14","0262","0","0","27","539","","HARUNA AHMED","07068231974","","","","M","1","Nigerian","12","11","1978","married","","","","angoaliyu76@yahoo.com","","AGAIE","07068231974","","S.W 505 KETEREN GWARI ROAD, MINNA","","","Normal","O","None","","1","0","0","197.210.226.17","2019-06-01 13:47:04","2019-06-01 13:47:15","","","","1","0000-00-00 00:00:00","2019-05-13 09:07:59","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("263","0","1","0","0","1","11","1","1","11","0263","0","0","27","556","","HAMSON NICHOLAS DANGANA","08036385238","","","","M","2","Nigerian","1","10","1975","married","","","","angoaliyu76@yahoo.com","","MUNYA","08036385238","","G.G.S.S.KAFFIN KORO","","","Normal","AB","None","","1","0","0","197.210.45.142","2019-05-31 08:44:07","2019-05-31 08:45:08","","","","0","0000-00-00 00:00:00","2019-05-13 09:09:14","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("264","0","0","0","0","0","0","1","4","12","0264","0","0","27","560","","ABDULLAHI ISIYAKU","08055953600","","","","M","1","Nigerian","30","6","1979","married","","","","angoaliyu76@yahoo.com","","SHIRORO","08055953600","","MTB 39 MAITUMBI MINNA","","","Normal","AB","None","","1","0","0","197.210.45.142","2019-05-31 08:48:42","2019-05-31 08:55:47","","","","1","0000-00-00 00:00:00","2019-05-13 09:10:19","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("265","0","0","0","0","0","0","1","1","11","0265","0","0","27","550","","YUSUF ALIYU GABI","07032918670","","","","M","1","Nigerian","5","1","1963","married","","","","angoaliyu76@yahoo.com","","LAPAI","07032918670","","GABI VIA LAPAI LGA","","","Normal","O","None","","1","0","0","197.210.45.142","2019-05-31 08:59:11","2019-05-31 09:00:14","","","","1","0000-00-00 00:00:00","2019-05-13 09:11:20","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("266","0","1","0","0","7","16","1","7","16","0266","0","0","27","539","","ABUBAKAR TALATU","07062329390","","","","F","1","Nigerian","15","11","1978","married","","","","talatuabubakar72@gmail.com","","AGAIE","07062329390","","BEHIND BANANA LOGUMA RESIDENCE TUNGA LOWCOST MINNA","","","Normal","B+","None","","1","0","0","197.210.226.253","2020-02-07 17:54:12","2020-02-07 18:04:01","","","","1","0000-00-00 00:00:00","2019-05-13 09:12:49","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0285","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("267","0","0","0","0","0","0","1","7","5","0267","0","0","27","557","","MAIKARFI ISAIAH JUDITH","08065071678","","","","F","2","Nigerian","19","9","1986","single","","","","judithmaikarfi@gmail.com","","PAIKORO","08065071678","","BEHIND GBANGBAPI PRI SCH. SAUKA KA HUTA","","","Normal","O","None","","1","0","0","197.210.45.142","2019-05-31 09:01:11","2019-05-31 09:01:52","","","","1","0000-00-00 00:00:00","2019-05-13 09:15:03","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("268","0","1","0","0","1","11","1","1","11","0268","0","0","27","552","","YUSUF UMAR","07082026212","","","","M","1","Nigerian","20","4","1971","married","","","","angoaliyu76@yahoo.com","","MAGAMA``","07082026212","","UNGUWAN DAKA AUNA MAGAMA LGA NASKO","","","Normal","O","None","","1","0","0","105.112.114.140","2020-01-16 09:45:48","2020-01-16 09:46:08","","","","1","0000-00-00 00:00:00","2019-05-13 09:15:59","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0345","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("269","0","0","0","0","0","0","1","2","15","0269","0","0","27","556","","BATURE EMMANUEL","08033668901","","","","M","2","Nigerian","25","12","1974","married","","","","emmabature@gmail.com","","MUNYA","08033668901","","OPP. CUSTOM BARRACKS, SADIA ROAD SAUKA KA HUTA","","","Normal","O","None","","1","0","0","197.210.45.142","2019-05-31 09:02:45","2019-05-31 09:03:40","","","","1","0000-00-00 00:00:00","2019-05-13 09:18:26","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("270","0","1","0","0","10","21","1","10","21","0270","0","0","19","356","","YUSUF AMIRA ABDULLAHI","08136101037","","","","F","1","Nigerian","31","7","1988","married","","","","angoaliyu76@yahoo.com","","KADUNA SOUTH","08136101037","","SE 146 SABON GARI MINNA","","2019-11-04-115257.jpg","Normal","A+","None","","1","0","0","197.210.65.89","2020-01-02 23:30:32","2020-01-02 23:31:05","","","","1","0000-00-00 00:00:00","2019-05-13 09:19:29","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0430","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("271","0","1","0","0","10","22","1","2","15","0271","0","0","16","282","","MAGAJI SALATI","08032593685","","","","M","2","Nigerian","29","12","1983","married","","","","magajisalati123@gmail.com","","AKKO","08032593685","","FLAT 5 ECWA STREET NASARAWA","","","Normal","A+","None","","1","1","0","197.210.84.198","2020-03-12 21:37:33","2020-02-11 15:51:26","","","","1","0000-00-00 00:00:00","2019-05-13 09:20:51","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2019-12-13 10:39:59","0190","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("272","0","0","0","0","0","0","1","2","14","0272","0","0","27","541","","ALHAJI BABA","08069503080","","","","M","1","Nigerian","15","2","1974","married","","","","angoaliyu76@yahoo.com","","BIDA","08069503080","","EMI NDAIJI AMINU, DZUKOGI MASABA AREA BIDA","","","Normal","AB","None","","1","0","0","197.210.45.142","2019-05-31 09:06:05","2019-05-31 09:06:50","","","","1","0000-00-00 00:00:00","2019-05-13 09:22:26","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("273","0","1","0","0","10","21","1","7","16","0273","0","0","27","557","","SULEIMAN GAMBO RABIU","08033419477","","","2019-06-07-105615IBBUL1.pdf.pdf","M","1","Nigerian","23","5","1969","married","","","","abusudais77@gmail.com","","PAIKORO","08033419477","","ANINIGI PHAPI AREA PAIKORO LGA","","2019-06-07-105458.jpg","Normal","B+","None","","1","0","0","105.112.115.177","2020-01-16 14:14:05","2020-01-16 14:14:17","","","","1","0000-00-00 00:00:00","2019-05-13 09:28:38","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-15 16:21:08","0544","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("274","0","1","0","0","10","22","1","4","13","0274","0","0","27","557","","SHUAIBU ALIYU","08060974678","","","","M","1","Nigerian","6","12","1970","married","","","","angoaliyu76@yahoo.com","","PAIKORO","08060974678","","BEHIND MAGISTRATE COURT PAIKO","","","Normal","B+","None","","1","0","0","197.210.45.142","2019-05-31 09:07:58","2019-05-31 09:08:36","","","","1","0000-00-00 00:00:00","2019-05-13 09:36:06","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-06 22:49:37","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("275","0","0","0","0","0","0","1","4","13","0275","0","0","27","543","","ADAMU YUSUF","07058939336","","","","M","1","Nigerian","13","9","1990","married","","","","yusufad435@gmail.com","","BOSSO","07058939336","","HOUSE NO 43 BEHIND WHITE HEART KPAKUNGU BIDA ROAD MINNA","","","Normal","O","None","","1","0","0","197.210.45.142","2019-05-31 09:08:47","2019-05-31 09:09:27","","","","1","0000-00-00 00:00:00","2019-05-13 09:37:19","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("276","0","1","0","0","2","14","1","2","14","0276","0","0","27","553","","SHEHU ALIYU","07089789995","","","","M","1","Nigerian","27","6","1978","married","","","","angoaliyu76@yahoo.com","","MARIGA","07089789995","","ANGUWAN SARKIN BANGI MARIGA LGA","","","Normal","B+","None","","1","0","0","105.112.115.177","2020-01-16 13:21:28","2020-01-16 13:22:18","","","","1","0000-00-00 00:00:00","2019-05-13 09:38:20","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-05 07:33:14","0508","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("277","0","1","0","0","10","20","1","10","20","0277","0","0","27","555","","IDRIS AMINA","08167893855","","","","F","1","Nigerian","10","3","1992","married","","","","angoaliyu76@yahoo.com","","MOKWA","08167893855","","SHANU VILLAGE GIDAN KUR","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 14:15:28","2020-01-16 14:15:39","","","","1","0000-00-00 00:00:00","2019-05-13 09:39:12","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0409","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("278","0","1","0","0","10","21","1","7","16","0278","0","0","27","557","","ABDULAZEEZ AISHA DAUDU","07035277523","","","","F","1","Nigerian","13","12","1993","married","","","","aishadauda33@gmail.com","","PAIKORO","07035277523","","HOUSE NO 1 IBB ROAD PAIKO","","","Normal","B+","None","","1","1","0","105.112.114.117","2020-01-30 17:28:07","2020-01-16 14:14:37","","","","1","0000-00-00 00:00:00","2019-05-13 09:40:17","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-15 12:02:13","0528","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("279","0","1","0","0","2","14","1","2","14","0279","0","0","27","551","","SULEIMAN ABDULLAHI","07055304026","","","","M","1","Nigerian","6","2","1988","married","","","","angoaliyu76@yahoo.com","","LAVUN","07055304026","","C/O YUSAHAT NUG LTD GWAGWALADA FCT ABUJA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 13:06:10","2020-01-16 13:06:19","","","","1","0000-00-00 00:00:00","2019-05-13 09:41:11","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-15 08:54:17","0525","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("280","0","0","0","0","0","0","1","4","13","0280","0","0","27","547","","ABUBAKAR SHUAIBU MAGAJI","08066088991","","","","M","1","Nigerian","30","1","1980","married","","","","angoaliyu76@yahoo.com","","GURARA","08066088991","","HOUSE NO. 1 ETSU ABU ROAD KAURA GAWU BABANGIDA  GURARA LGA","","","Normal","O","None","","1","0","0","197.210.226.17","2019-06-01 13:47:23","2019-06-01 13:47:34","","","","1","0000-00-00 00:00:00","2019-05-13 09:44:26","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("281","0","1","0","0","4","13","1","4","13","0281","0","0","27","560","","SAIDU ILIYASU","07018966677","","","","M","1","Nigerian","16","7","1979","married","","","","saiduierena@gmail.com","","SHIRORO","07018966677","","FM AREA MAITUMBI MINNA","","","Normal","O","None","","1","0","0","105.112.116.72","2020-01-24 12:32:10","2020-01-24 12:35:03","","","","1","0000-00-00 00:00:00","2019-05-13 09:47:07","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0112","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("282","0","1","0","0","10","20","1","10","20","0282","0","0","27","560","","JIBRIN MARYAM DADA","08038336514","","","","F","1","Nigerian","3","3","1991","married","","","","maryamdjibrin980@gmail.com","","SHIRORO","08038336514","","BEHIND TIPA GARAGE MAITUMBI MINNA","","","Normal","A+","None","","1","0","0","197.210.47.104","2020-01-03 12:33:47","2020-01-03 12:34:15","","","","1","0000-00-00 00:00:00","2019-05-13 09:48:22","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0118","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("283","0","1","0","0","2","15","1","2","15","0283","0","0","27","558","","ABUBAKAR ABDULLAHI HUDU","09038847777","","","","M","1","Nigerian","10","10","1983","married","","","","angoaliyu76@yahoo.com","","RAFI","09038847777","","RAFI KAGARA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 12:59:56","2020-01-16 13:00:07","","","","1","0000-00-00 00:00:00","2019-05-13 09:49:16","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","0000-00-00 00:00:00","0316","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("284","0","1","0","0","1","10","1","1","10","0284","0","0","27","543","","MOHAMMED LAMI MAIKUNKELE","08052112749","","","","F","1","Nigerian","19","2","1969","married","","","","angoaliyu76@yahoo.com","","BOSSO","08052112749","","BOSSO ESTATE BEHIND HANDICAP SCHOOL","","","Normal","O","None","","1","0","0","105.112.113.95","2020-01-15 10:24:47","2020-01-15 10:25:02","","","","1","0000-00-00 00:00:00","2019-05-13 09:50:23","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0104","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("285","0","0","0","0","0","0","1","4","13","0285","0","0","27","544","","Jibril Hussaini ","07031269051","","","2019-05-13-111659jt.pdf.pdf","M","2","Nigerian","4","12","1988","single","","","","jthussaini@gmail.com","","Bida","07031269051","","Bida Clinic and Maternity Home Bida, Niger State  ","Bida Clinic and Maternity Home Bida, Niger State  ","2019-05-13-104636.jpg","Normal","O","None","","1","1","0","105.112.113.253","2019-11-23 13:16:44","2019-06-12 16:09:34","","","","1","0000-00-00 00:00:00","2019-05-13 10:43:07","0000-00-00 00:00:00","","","Dr Jimoh .O. Jibril ","08036283585","Bida Clinic and Maternity Home Bida, Niger State  ","Father ","3","Fatima Jibril Magaji","Samande Area Minna Niger State","0","","0","0000-00-00 00:00:00","","5","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("286","0","0","0","0","0","0","1","9","18","0286","0","0","27","551","","Zainab Musa","07034612839","","","2019-05-13-114844jpg2pdf(13).pdf.pdf","F","1","Nigerian","14","1","1985","married","","","","zainabmusa4we@gmail.com","","Dabban","07034612839","","Block 156 Flat Army Barack Quarters Minna Niger State","Block 156 Flat Army Barack Quarters Minna Niger State","2019-05-13-112939.jpg","Normal","O","None","","1","0","0","41.203.72.224","2019-05-13 12:50:30","2019-05-13 13:22:06","","","","1","0000-00-00 00:00:00","2019-05-13 11:26:32","0000-00-00 00:00:00","","","Alh. Attahiru","08034686580","Shiroro road, Via Deeper Life Church Minna Niger State ","Uncle","1","Kasim Muhammad ","Block 156 Flat Army Barack Quarters Minna Niger State","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("287","0","0","0","0","0","0","1","9","18","0287","0","0","27","550","","Aishetu Musa Alhaji","08069666103","","","2019-05-13-122429jpg2pdf(14).pdf.pdf","F","1","Nigerian","9","4","1982","married","","","","aishatumalhaji@gmail.com","","Hankuri cu","08069666103","","Tungan Back of Technical, Nurses House ","Tungan Back of Technical, Nurses House ","2019-05-13-120947.jpg","Normal","O","None","","1","0","0","41.203.72.224","2019-05-13 12:03:18","2019-05-13 12:44:35","","","","1","0000-00-00 00:00:00","2019-05-13 12:03:04","0000-00-00 00:00:00","","","Alhaji Musa","08060228022","72 Niteco road, Minna niger State ","Father","1","Dantala Ibn UMar","Tungan Back of Technical, Nurses House ","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("288","0","0","0","0","0","0","1","2","15","0288","0","0","31","652","","David Gideon Ayan","08054481902","","","2019-05-13-161207Merge Correct.pdf.pdf","M","2","Nigerian","1","11","1983","married","","","","valour4dave@yahoo.com","","","08054481902","","ICT Center, Niger State Polytechnic PMB 1 Zungeru","","2019-05-13-145059.jpg","Normal","A+","None","","1","1","0","197.211.57.132","2019-05-13 16:12:49","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-05-13 14:48:31","0000-00-00 00:00:00","","","David Solomon","08039671650","C/O Mrs Deborah A. Solomon, Niger State Polytechnic Health Center Zungeru","Father","4","","","0","","0","0000-00-00 00:00:00","","3","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("289","0","1","0","0","2","14","1","2","14","0289","0","0","27","555","","ADAMU SALIHU IBRAHIM","07062298233","","","","M","1","Nigerian","22","3","1988","single","","","","angoaliyu76@yahoo.com","","MOKWA","07062298233","","KPAKUNGU OPPOSITE MATRIX FUEL STATION MINNA","","","Normal","O","None","","1","0","0","105.112.121.59","2019-11-01 14:21:51","2019-11-01 14:35:35","","","","1","0000-00-00 00:00:00","2019-05-13 14:50:20","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-01 14:20:48","0415","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("290","0","1","0","0","2","14","1","2","14","0290","0","0","27","551","","AHMED MUSTAPHA","08036896530","","","","M","1","Nigerian","2","2","1986","married","","","","mustaphaahmedk@gmail.com","","LAVUN","08036896530","","EMI NCHAMA KUTIGI, LAVUN LGA","","","Normal","O","None","","1","0","0","197.210.45.38","2020-01-03 14:34:11","2020-01-03 14:34:47","","","","1","0000-00-00 00:00:00","2019-05-13 14:51:43","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0206","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("291","0","1","0","0","10","22","1","2","15","0291","0","0","27","550","","ABUBAKAR HASSAN","08139106449","","","","M","1","Nigerian","22","6","1993","married","","","","angoaliyu76@yahoo.com","","LAPAI","08139106449","","BACK OF MOBILE QRTRS TUNGA MINNA","","","Normal","O","None","","1","0","0","105.112.122.89","2020-02-26 10:43:49","2020-02-26 10:55:18","","","","1","0000-00-00 00:00:00","2019-05-13 14:53:02","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2020-02-24 17:47:28","0049","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("292","0","1","0","0","10","21","1","2","14","0292","0","0","27","550","","ABUBAKAR YAHAYA","07035621121","","","","M","1","Nigerian","15","3","1985","married","","","","angoaliyu76@yahoo.com","","LAPAI","07035621121","","NO. 1 OKADA ROAD, JIKPANI BOSSO","","","Normal","A+","None","","1","0","0","105.112.112.20","2020-01-28 16:34:00","2020-01-28 16:34:13","","","","1","0000-00-00 00:00:00","2019-05-13 14:54:01","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2019-12-13 10:27:45","0378","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("293","0","1","0","0","2","2","1","2","2","0293","0","0","27","550","","SULEIMAN ABDULRAZAK","08069203922","","","","M","1","Nigerian","13","7","1991","single","","","","angoaliyu76@yahoo.com","","LAPAI","08069203922","","214F IJ12 ALH ABUBAKAR ROAD OLD AIRPORT QRTRS MINNA","","","Normal","O","None","","1","1","0","129.205.113.80","2020-02-17 17:48:46","2020-02-17 17:23:54","","","","1","0000-00-00 00:00:00","2019-05-13 14:55:00","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0214","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("294","0","0","0","0","0","0","1","2","15","0294","0","0","27","543","","LAWU ABDULKADIR","08165031418","","","","M","1","Nigerian","5","5","1979","married","","","","abdulkadir75@gmail.com","","BOSSO","08165031418","","BOSSO NEW YORK","","","Normal","B+","None","","1","0","0","197.210.45.142","2019-05-31 09:26:20","2019-05-31 09:27:10","","","","1","0000-00-00 00:00:00","2019-05-13 14:56:24","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("295","0","1","0","0","2","2","1","2","14","0295","0","0","27","544","","MOHAMMED HAMZA","07080776764","","","","M","1","Nigerian","17","8","1979","married","","","","babaagogo.h@gmail.com","","CHANCHAGA","07080776764","","N.E 150 MU\'AZU STREET MINNA NASARAWA B WARD MINNA","","","Normal","B+","None","","1","0","0","197.210.60.119","2020-01-03 11:15:32","2020-01-03 11:16:37","","","","1","0000-00-00 00:00:00","2019-05-13 14:58:20","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0543","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("296","0","0","0","0","0","0","1","7","5","0296","0","0","27","543","","HARUNA AISHAT","09038882010","","","","F","1","Nigerian","22","7","1994","single","","","","royaltysamson1@gmail.com","","BOSSO","09038882010","","CHANCHAGA SHARIA COURT JUNCTION OPP MAKOLO FARM ","","","Normal","O","None","","1","0","0","197.210.45.142","2019-05-31 09:29:44","2019-05-31 09:29:55","","","","1","0000-00-00 00:00:00","2019-05-13 14:59:40","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("297","0","1","0","0","2","15","1","2","15","0297","0","0","27","558","","ADO ABDULSALAM","08031801918","","","","M","1","Nigerian","2","2","1972","married","","","","angoaliyu76@yahoo.com","","RAFI","08031801918","","ABDULSALAM RESIDENCE MADAKA ROAD SABON GARI KAGARA","","","Normal","B+","None","","1","0","0","197.210.60.119","2020-01-03 11:19:30","2020-01-03 11:19:55","","","","1","0000-00-00 00:00:00","2019-05-13 15:00:32","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-15 13:43:39","0619","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("298","0","1","0","0","4","12","1","4","12","0298","0","0","27","539","","MOHAMMED UMAR","08058177360","","","","M","1","Nigerian","25","8","1980","married","","","","umarcpt2@gmail.com","","AGAIE","08058177360","","EKOWUNA BEHIND HAMDALA BREAD KATCHA","","","Normal","A+","None","","1","0","0","197.210.84.253","2020-01-14 20:29:39","2020-01-14 20:39:11","","","","1","0000-00-00 00:00:00","2019-05-13 15:02:42","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-04 14:10:32","0461","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("299","0","1","0","0","10","20","1","7","17","0299","0","0","27","550","","IDRIS ILIYASU ANYILO","08070784851","","","2019-05-13-155314IDRIS NECO 1.pdf.pdf","M","1","Nigerian","15","9","1994","single","","","","idrisiliyasuanyilo2019@gmail.com","","TAKUTI","08070784851","","TAKUTI, VIA LAPAI, NIGER STATE","TAKUTI, VIA LAPAI, NIGER STATE","2019-05-13-155004.jpg","Normal","O","None","NIL","1","0","0","105.112.113.177","2020-02-19 10:43:28","2020-02-19 10:44:51","","","","1","0000-00-00 00:00:00","2019-05-13 15:02:51","0000-00-00 00:00:00","","","IDRIS IBRAHIM","","","FATHER","1","IDRIS IBRAHIM ","TAKUTI, VIA LAPAI, NIGER STATE","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2020-02-11 17:13:11","0438","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("300","0","0","0","0","0","0","1","7","5","0300","0","0","27","558","","USMAN SAGIR","08060774610","","","","M","1","Nigerian","1","4","1989","married","","","","angoaliyu76@yahoo.com","","RAFI","08060774610","","EMIR PALACE KAG","","","Normal","B+","None","","1","1","0","82.145.223.135","2019-11-28 13:47:42","2019-11-28 13:45:47","","","","1","0000-00-00 00:00:00","2019-05-13 15:03:44","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("301","0","0","0","0","0","0","1","2","2","0301","0","0","27","541","","MOHAMMED ABDULKADIR KOLOGBO","07067549438","","","","M","1","Nigerian","23","3","1989","single","","","","creaters9@yahoo.com","","BIDA","07067549438","","PLT 165 NASS AREA ANGUWAN DAJI","","","Normal","O","None","","1","0","0","197.210.45.142","2019-05-31 09:34:37","2019-05-31 09:35:06","","","","1","0000-00-00 00:00:00","2019-05-13 15:05:10","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("302","0","0","0","0","0","0","1","2","2","0302","0","0","27","550","","MOHAMMED IBRAHIM GULU","07065377298","","","","M","1","Nigerian","17","3","1982","married","","","","angoaliyu76@yahoo.com","","LAPAI","07065377298","","NO. 2 ETSU ISMAILA STREET GULU","","","Normal","O","None","","1","0","0","197.210.45.142","2019-05-31 09:35:14","2019-05-31 09:35:46","","","","1","0000-00-00 00:00:00","2019-05-13 15:06:32","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("303","0","1","0","0","9","18","1","4","12","0303","0","0","27","557","","SHUAIBU ZAINAB","08036311913","","","","F","1","Nigerian","15","6","1975","married","","","","angoaliyu76@yahoo.com","","PAIKORO","08036311913","","ALHASSAN BABA\' S HOUSE OPP  PW CANTEEN ","","","Normal","B+","None","","1","0","0","197.210.47.73","2020-01-02 23:51:10","2020-01-02 23:51:39","","","","1","0000-00-00 00:00:00","2019-05-13 15:07:24","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0084","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("304","0","1","0","0","4","12","1","4","12","0304","0","0","27","560","","AYUBA RUTH HABILA","07067768029","","","","F","2","Nigerian","19","3","1990","married","","","","angoaliyu76@yahoo.com","","SHIRORO","07067768029","","HOUSE NO 2 BEHIND CHRIST THE KING MINOR SEMINARY TAWALI GWADA","","","Normal","O","None","","1","0","0","197.210.45.38","2020-01-03 14:18:58","2020-01-03 14:19:36","","","","1","0000-00-00 00:00:00","2019-05-13 15:08:27","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0242","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("305","0","1","0","0","4","13","1","4","13","0305","0","0","27","543","","YAKUBU ABUBAKAR BOSSO","08036558443","","","","M","1","Nigerian","30","5","1970","married","","","","abubakar.y.bosso@gmail.com","","BOSSO","08036558443","","BEHIND ID GROUND KINKAPA NEW YORK","","","Normal","A+","None","","1","0","0","197.210.60.119","2020-01-03 10:36:18","2020-01-03 10:36:56","","","","1","0000-00-00 00:00:00","2019-05-13 15:09:42","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0623","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("306","0","1","0","0","2","14","1","2","14","0306","0","0","23","484","","MUSA OTARU IBRAHIM","07068167570","","","","M","1","Nigerian","3","3","1975","married","","","","angoaliyu76@yahoo.com","","OKEHI","07068167570","","L15 LAGOS ROAD, IKUEHI IHIMA KOGI","","","Normal","O","None","","1","0","0","197.210.47.109","2020-01-02 21:13:39","2020-01-02 21:14:14","","","","1","0000-00-00 00:00:00","2019-05-13 15:10:50","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0072","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("307","0","1","0","0","4","12","1","2","14","0307","0","0","27","549","","MUHAMMED ADAMU","08060212926","","","2019-05-13-155006adamu.pdf.pdf","M","1","Nigerian","12","1","1979","married","","","","adamu2440@gmail.com","","KONTAGORA","08060212926","","KONTAGORA LOCAL GOVERNMENT COUNCIL, KONTAGORA, NIGER STATE","GANGAREN SAGI, TUDUN WADA, KONTAGORA, NIGER STATE","2019-05-13-151449.jpg","Normal","O","None","","1","0","0","105.112.114.138","2019-11-24 17:13:09","2019-11-24 17:14:06","","","","1","0000-00-00 00:00:00","2019-05-13 15:13:52","0000-00-00 00:00:00","","","BALA ADAMU","07033972156","GANGAREN SAGI, TUDUN WADA, KONTAGORA, NIGER STATE","BROTHER","2","KONTAGORA LOCAL GOVERNMENT COUNCIL","KONTAGORA LOCAL GOVERNMENT COUNCIL, KONTAGORA, NIGER STATE","1","                                
\n                                                                 
\n                                ","3","2019-11-24 14:09:22","0611","20","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("308","0","1","0","0","7","5","1","7","5","0308","0","0","27","551","","MOHAMMED TWO HUSSAINI","09093776597","","","","M","1","Nigerian","13","2","1988","single","","","","hussainimohnagari@gmail.com","","MINNA","09093776597","","BOSSO LOWCOST, OFF MATASA DRIVE MINNA NIGER STATE","BOSSO LOWCOST, OFF MATASA DRIVE MINNA NIGER STATE","2019-05-13-162539.jpg","Normal","O","None","","1","0","0","197.210.65.202","2020-01-02 22:32:38","2020-01-02 22:33:53","","","","1","0000-00-00 00:00:00","2019-05-13 16:16:00","0000-00-00 00:00:00","","","MUHAMMAD NMA MUHAMMAD","08055962349","BOSSO LOWCOST, OFF MATASA DRIVE MINNA NIGER STATE","BROTHER","1","MUHAMMAD NMA MUHAMMAD","BOSSO LOWCOST, OFF MATASA DRIVE MINNA NIGER STATE","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0279","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("309","0","0","0","0","0","0","1","1","10","0309","0","0","19","356","","BULUS WILSON A","08034715461","","","2019-05-14-111723convert-jpg-to-pdf.net_2019-05-14_12-11-58.pdf.pdf","M","2","Nigerian","10","9","1970","married","","","","ellowimi3@gmail.com","","KADUNA","08034715461","","BURSARY DEPARTMENT FCE, KONTAGORA","BURSARY DEPARTMENT FCE, KONTAGORA","2019-05-14-111635.jpg","Normal","O","None","","1","1","0","105.112.120.241","2019-05-16 11:05:34","2019-05-14 11:28:40","","","","1","0000-00-00 00:00:00","2019-05-13 16:50:54","0000-00-00 00:00:00","","","MR. BULUS BAMAI","070033908600","BARNAWA LOW-COST, KADUNA","FATHER","1","MR. BULUS WILSON","BURSARY DEPARTMENT FCE, KONTAGORA","0","","0","0000-00-00 00:00:00","","13","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("310","0","0","0","0","0","0","1","2","14","0310","0","0","27","541","","UMAR SANDA ISMAIL","08069503222","","","2019-05-13-173428New Doc 2019-05-13 (1).pdf.pdf","M","1","Nigerian","15","3","1989","married","","","","Sanda6232@gmail.com","","Bida","08069503222","","Emi Majin Kimpa Imamu Shafii Road, Masaba Area Bida Niger State.","Emi Majin Kimpa Imamu Shafii Road, Masaba Area Bida Niger State.","2019-05-13-174346.jpg","Normal","O","None","Nil","1","1","0","197.210.52.250","2019-05-14 12:31:23","2019-05-14 12:31:10","","","","0","0000-00-00 00:00:00","2019-05-13 16:58:18","0000-00-00 00:00:00","","","Muhammad Ismail","08036487998","Emi Majin Kimpa Imamu Shafii Road, Masaba Area Bida Niger State.","Brother","4","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("311","0","1","0","0","4","13","1","4","13","0311","0","0","27","558","","YAHAYA BASHAR","07068113990","","","","M","1","Nigerian","5","3","1984","married","","","","basharyahaya3@gmail.com","","RAFI","07068113990","","C/O LATE YAHAYA MARAFA KUREBE HOUSE MADAKA ROAD SABON GARI KAGARA","","","Normal","B+","None","","1","0","0","105.112.115.177","2020-01-16 11:33:49","2020-01-16 11:33:59","","","","1","0000-00-00 00:00:00","2019-05-14 09:22:43","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0255","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("312","0","1","0","0","10","20","1","10","20","0312","0","0","27","557","","HALIRU ISAH","08079872423","","","","M","1","Nigerian","1","2","1994","married","","","","angoaliyu76@yahoo.com","","PAIKORO","08079872423","","ANGUWAN MAKERA PAIKO","","","Normal","B+","None","","1","0","0","197.210.45.142","2019-05-31 09:41:41","2019-05-31 09:42:56","","","","1","0000-00-00 00:00:00","2019-05-14 09:23:43","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("313","0","1","0","0","2","2","1","2","2","0313","0","0","27","545","","MOHAMMED BABA SAKPE","07039712724","","","","M","1","Nigerian","11","10","1983","married","","","","babamohammed@gmail.com","","EDATI","07039712724","","GIDAN KUKA SANU VILLAGE MINNA","","","Normal","O","None","","1","0","0","197.210.64.191","2020-01-03 12:34:28","2020-01-03 12:35:10","","","","1","0000-00-00 00:00:00","2019-05-14 09:25:01","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0085","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("314","0","0","0","0","0","0","1","10","21","0314","0","0","27","548","","MOHAMMED UMAR YABAGI","08067656423","","","","M","1","Nigerian","1","1","1994","married","","","","angoaliyu76@yahoo.com","","KATCHA","08067656423","","HOUSE NO 81 GBAGBANU AREA BESIDE VIGILANTEE OFFICE MINNA","","","Normal","O","None","","1","0","0","197.210.45.142","2019-05-31 09:44:34","2019-05-31 09:45:29","","","","1","0000-00-00 00:00:00","2019-05-14 09:26:07","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("315","0","1","0","0","2","2","1","2","14","0315","0","0","27","551","","FATIMA USMAN","07067733268","","","","F","1","Nigerian","1","1","1991","single","","","","angoaliyu76@yahoo.com","","LAVUN","07067733268","","CHANCHAGA ALLADEY STREET MINNA","","","Normal","A+","None","","1","0","0","105.112.122.11","2020-02-08 14:44:44","2020-02-08 14:48:09","","","","1","0000-00-00 00:00:00","2019-05-14 09:27:10","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-05 08:36:40","0491","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("316","0","1","0","0","9","18","1","9","18","0316","0","0","13","250","","OLOOPO BUNM JOSEPH","07063041848","","","","M","2","Nigerian","6","7","1981","married","","","","boloopo@yahoo.com","","IDO OSI","07063041848","","FEDERAL AIRPORT AUTHORITY OF NIGERIA QRTR","","","Normal","O","None","","1","0","0","197.210.47.23","2020-02-04 12:14:13","2020-02-04 12:15:03","","","","1","0000-00-00 00:00:00","2019-05-14 09:29:07","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0171","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("317","0","0","0","0","0","0","1","1","11","0317","0","0","27","541","","KUDU MUBARAK MOHAMMED","08068868589","","","","M","1","Nigerian","23","9","1983","married","","","","mubarakkudu@gmail.com","","BIDA","08068868589","","EMI MAJIN KUDU HUSSAIN IBRAHIM TAKO AREA BIDA SW 550 GUDUNDASA","","","Normal","B+","None","","1","0","0","197.210.227.218","2019-10-05 20:48:32","2019-10-05 20:51:26","","","","1","0000-00-00 00:00:00","2019-05-14 09:30:57","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("318","0","1","0","0","9","18","1","9","18","0318","0","0","27","561","","RUKAYA SAIDU AHMED","08065318338","","","","F","1","Nigerian","8","6","1984","married","","","","angoaliyu76@yahoo.com","","SULEJA","08065318338","","BOSSO OPP FUT MINNA","","","Normal","AB","None","","1","0","0","197.210.45.38","2020-01-03 13:56:33","2020-01-03 13:57:03","","","","1","0000-00-00 00:00:00","2019-05-14 09:32:04","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-10-30 04:14:10","0565","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("319","0","1","0","0","4","4","1","4","4","0319","0","0","27","544","","SABA ALHAJI SADIYA","07061312100","","","","F","1","Nigerian","21","7","1990","married","","","","idisaheed@gmail.com","","CHANCHAGA","07061312100","","26 KING FAD STREET FAD STREET NEW LONDON CITY, BARIKIN SALE MINNA","","","Normal","O","None","","1","0","0","197.210.45.38","2020-01-03 14:25:41","2020-01-03 14:26:12","","","","1","0000-00-00 00:00:00","2019-05-14 09:33:05","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0296","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("320","0","0","0","0","0","0","1","1","11","0320","0","0","27","552","","YAKUBU HASHIMU","08023107890","","","","M","1","Nigerian","1","1","1990","married","","","","angoaliyu76@yahoo.com","","MAGAMA","08023107890","","ALHAJI YAKUBU ZANGO WARD","","","Normal","O","None","","1","0","0","197.210.45.142","2019-05-31 09:52:58","2019-05-31 09:53:28","","","","1","0000-00-00 00:00:00","2019-05-14 09:34:25","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("321","0","0","0","0","0","0","1","2","14","0321","0","0","27","556","","ISYAKU NURUDEEN DAZA","08163689666","","","","M","1","Nigerian","26","4","1994","married","","","","nurudeendaza@gmail.com","","MUNYA","08163689666","","F.M AREA MAITUMBI MINNA","","","Normal","A+","None","","1","0","0","105.112.112.41","2019-11-01 11:59:29","2019-11-01 12:00:05","","","","1","0000-00-00 00:00:00","2019-05-14 09:36:04","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("322","0","1","0","0","10","20","1","10","20","0322","0","0","27","557","","LAWAL ABUBAKAR","07031300238","","","","M","1","Nigerian","24","3","1992","married","","","","lawalabubakar0703@gmail.com","","PAIKORO","07031300238","","BEHIND MAGISTRATE COURT GBADNA, PAIKO","","","Normal","A+","None","","1","0","0","197.210.45.142","2019-05-31 09:54:29","2019-05-31 09:55:10","","","","1","0000-00-00 00:00:00","2019-05-14 09:37:10","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("323","0","0","0","0","0","0","1","2","15","0323","0","0","14","274","","UGWA CHUKS CELESTINE","08054913268","","","","M","2","Nigerian","7","1","1983","married","","","","nzegote2220@yahoo.com","","UDI","08054913268","","NO. 6 ECWA ROAD OPP LABOUR HOUSE KUJE ROAD GWAGWALADA ABUJA","","","Normal","A+","None","","1","0","0","197.210.45.142","2019-05-31 09:55:17","2019-05-31 09:56:03","","","","1","0000-00-00 00:00:00","2019-05-14 09:38:42","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("324","0","1","0","0","10","21","1","10","21","0324","0","0","27","551","","MAHMUD ALIYU KUCHI","08036654565","","","","M","1","Nigerian","25","6","1991","married","","","","angoaliyu76@yahoo.com","","LAVUN","08036654565","","BARIKIN SALE AFTER CORPERS LODGE MINNA","","","Normal","O","None","","1","0","0","105.112.113.95","2020-01-15 14:20:40","2020-01-15 14:21:18","","","","1","0000-00-00 00:00:00","2019-05-14 09:39:44","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-01 15:25:29","0484","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("325","0","1","0","0","2","14","1","2","14","0325","0","0","14","271","","AGBO MAUREEN","07068005622","","","","F","2","Nigerian","25","6","1975","married","","","","angoaliyu76@yahoo.com","","NSUKKA","07068005622","","ANGWAN BANANA TUNGA MINNA","","","Normal","O","None","","1","0","0","197.210.64.22","2020-01-02 22:00:05","2020-01-02 22:00:39","","","","1","0000-00-00 00:00:00","2019-05-14 09:40:47","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0357","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("326","0","0","0","0","0","0","1","4","13","0326","0","0","23","476","","ONOJA ADAH NELSON","08065697182","","","","M","2","Nigerian","25","2","1990","single","","","","nelsonadahonoja@gmail.com","","IGALAMELA","08065697182","","STREET J ALONG MAMI MARKET 72 BARRACK ROAD MAKURDI BENUE STATE","","","Normal","O","None","","1","0","0","197.210.45.142","2019-05-31 10:01:58","2019-05-31 10:02:38","","","","1","0000-00-00 00:00:00","2019-05-14 09:42:05","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("327","0","1","0","0","1","11","1","1","11","0327","0","0","27","553","","ABUBAKAR HASSAN","08035550446","","","","M","1","Nigerian","5","5","1986","married","","","","talk2bobi@gmail.com","","MARIGA","08035550446","","NO. 1 MAJIDADI ROAD, KONTAGORA","","","Normal","O","None","","1","0","0","197.210.71.245","2020-02-24 14:31:51","2020-02-24 15:36:26","","","","1","0000-00-00 00:00:00","2019-05-14 09:43:22","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                                                 
\n                                                                 
\n                                ","3","2020-02-24 14:35:59","0389","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("328","0","0","0","0","0","0","1","1","11","0328","0","0","27","541","","LIMAN HUSSAINI","08082938349","","","","M","1","Nigerian","1","11","1979","married","","","","angoaliyu76@yahoo.com","","BIDA","08082938349","","HOUSE NO. 6 ALIYU MAKAMA ROAD GRA MINNA","","","Normal","O","None","","1","0","0","197.210.45.142","2019-05-31 10:03:29","2019-05-31 10:04:05","","","","1","0000-00-00 00:00:00","2019-05-14 09:45:12","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("329","0","1","0","0","10","21","1","10","21","0329","0","0","27","560","","IBRAHIM AMINAT","08053802992","","","","F","1","Nigerian","5","5","1985","married","","","","aminatibrahim4real@gmail.com","","SHIRORO","08053802992","","SAUKA KA HUTA OPPOSITE HIGH TENSION","","","Normal","O","None","","1","0","0","105.112.112.41","2019-11-01 12:00:22","2019-11-01 12:11:39","","","","1","0000-00-00 00:00:00","2019-05-14 09:46:43","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0411","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("330","0","1","0","0","7","5","1","7","16","0330","0","0","27","551","","MUHAMMAD AISHA ETSUWORO","08163386722","","","","F","1","Nigerian","2","1","1991","married","","","","angoaliyu76@yahoo.com","","LAVUN","08163386722","","HOUSE NO. 4 MUSA ZAGO ROAD, TYPE B QRTRS MINNA","","","Normal","O","None","","1","1","0","105.112.120.20","2020-02-10 11:36:18","2020-01-16 13:37:14","","","","1","0000-00-00 00:00:00","2019-05-14 09:47:53","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0352","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("331","0","1","0","0","10","20","1","10","21","0331","0","0","27","541","","SANI RAKIYA","08038658056","","","","F","1","Nigerian","13","7","1995","single","","","","angoaliyu76@yahoo.com","","BIDA","08038658056","","KPAKUNGU OPPOSITE TENDER CARE","","","Normal","O","None","","1","0","0","197.210.45.142","2019-05-31 10:44:52","2019-05-31 10:45:29","","","","1","0000-00-00 00:00:00","2019-05-14 09:48:54","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("332","0","1","0","0","4","4","1","4","4","0332","0","0","27","554","","SABA SUZANNA AMINA","07035138414","","","","F","2","Nigerian","13","10","1999","single","","","","angoaliyu76@yahoo.com","","MASHEGU","07035138414","","GEN MI WUSHISHI HOUSING ESTATE MINNA","","","Normal","O","None","","1","0","0","197.210.60.119","2020-01-03 10:41:08","2020-01-03 10:41:36","","","","1","0000-00-00 00:00:00","2019-05-14 09:50:18","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0162","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("333","0","1","0","0","10","21","1","4","12","0333","0","0","27","541","","SABA YABAGI HADIZA","08169180734","","","","F","1","Nigerian","26","5","1987","married","","","","hadizasabayabagi@gmail.com","","BIDA","08169180734","","FARM CENTER AFTER AJUBA HOTEL HOUSE NO. ZONE E 21","","","Normal","B+","None","","1","1","0","105.112.120.126","2019-10-31 15:37:55","2019-05-31 10:47:20","","","","1","0000-00-00 00:00:00","2019-05-14 09:51:58","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0382","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("334","0","1","0","0","2","2","1","2","2","0334","0","0","27","561","","SAIDU HAIRAT","08069453994","","","","F","1","Nigerian","21","12","1990","married","","","","khairatsaid@yahoo.com","","SULEJA","08069453994","","BOSSO BEHIND VETRINARY HOSPITAL MINNA","","","Normal","O","None","","1","0","0","197.210.47.193","2020-01-02 21:16:08","2020-01-02 21:16:51","","","","1","0000-00-00 00:00:00","2019-05-14 09:53:30","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0121","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("335","0","1","0","0","1","10","1","1","10","0335","0","0","27","561","","IBRAHIM HAUWA BARDE","08033608677","","","","F","1","Nigerian","27","7","1986","married","","","","angoaliyu76@yahoo.com","","SULEJA","08033608677","","TYPE B QRTRS NO 10 JOS STREET ABUKUTA ROAD MINNA","","","Normal","O","None","","1","0","0","105.112.114.140","2020-01-16 09:34:12","2020-01-16 09:34:44","","","","1","0000-00-00 00:00:00","2019-05-14 09:54:35","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0179","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("336","0","0","0","0","0","0","1","2","2","0336","0","0","27","544","","MUSA BASHIR","08036569672","","","","M","1","Nigerian","11","11","1993","single","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08036569672","","SAUKA KA HUTA CENTRAL MOSQUE SHEIKH NAFIU COMPOUND MINNA","","","Normal","B+","None","","1","0","0","197.210.45.142","2019-05-31 10:48:58","2019-05-31 10:49:47","","","","1","0000-00-00 00:00:00","2019-05-14 09:55:39","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("337","0","0","0","0","0","0","1","9","18","0337","0","0","27","543","","LAWAL USMAN","07082227427","","","2019-05-14-174309LAWAL DOC.pdf.pdf","M","1","Nigerian","15","3","1967","married","","","","lawalusman123@yahoo.com","","MAIKUNKELE","07082227427","","MAIKUNKELE, BOSSO LGA, MINNA, NIGER STATE","MAIKUNKELE, BOSSO LGA, MINNA, NIGER STATE","2019-05-14-171910.jpg","Normal","O","None","FIT","1","0","0","105.112.121.82","2019-05-15 16:51:14","2019-05-15 17:26:35","","","","1","0000-00-00 00:00:00","2019-05-14 12:01:50","0000-00-00 00:00:00","","","USMAN AHMED","","MAIKUNKELE, BOSSO LGA, MINNA, NIGER STATE","FATHER","1","SELF","SECURITY UNIT, IBB UNIVERSITY, LAPAI","0","","0","0000-00-00 00:00:00","","14","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("338","0","0","0","0","0","0","1","10","21","0338","0","0","27","544","","AISHATU ABUBAKAR ALIYU","08064395514","","","2019-05-14-142749Aishatuabubakaraliyu doc1-converted.pdf.pdf","F","1","Nigerian","15","3","1987","married","","","","aishatuabubakaraliyu3@gmail.com","","MINNA","08064395514","","Benin Street S.W 209 Limawa A. Minna, Niger State.","Benin Street S.W 209 Limawa A. Minna, Niger State.","2019-05-14-132903.jpg","Normal","B+","None","","1","1","0","41.190.12.179","2019-11-23 11:04:16","2019-05-28 12:57:10","","","","1","0000-00-00 00:00:00","2019-05-14 13:16:27","0000-00-00 00:00:00","","","Aliyu Abubakar","","Benin Street S.W 209 Limawa A. Minna, Niger State.","Father","3","Shehu Umar","Gbwaganu before Helbetal International School Minna, Niger State","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("339","0","0","0","0","0","0","1","2","15","0339","0","0","27","556","","SANI IBRAHIM","08027378353","","","","M","1","Nigerian","15","5","1973","married","","","","angoaliyu76@yahoo.com","","MUNYA","08027378353","","UNGUWAN KADARA MAITUMBI","","","Normal","AB","None","","1","0","0","197.210.45.142","2019-05-31 10:49:56","2019-05-31 10:50:33","","","","1","0000-00-00 00:00:00","2019-05-14 13:24:01","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("340","0","1","0","0","2","2","1","2","2","0340","0","0","27","544","","UMAR MUSA IBRAHIM","08165491689","","","","M","1","Nigerian","1","1","1999","single","","","","musaumar872@yahoo.com","","CHANCHAGA","08165491689","","HOUSE NO 2 BESIDE TRANSFORMER HASSAN LEMU HOUSE ","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 13:11:49","2020-01-16 13:12:25","","","","1","0000-00-00 00:00:00","2019-05-14 13:28:33","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0298","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("341","0","1","0","0","10","20","1","10","20","0341","0","0","27","550","","MANDATSU MUZZAMMIL","08100800309","","","","M","1","Nigerian","29","7","1993","single","","","","muzzammilnda@gmail.com","","LAPAI","08100800309","","DAVID UMAR STREET SHIRORO ROAD MINNA","","","Normal","O","None","","1","0","0","197.210.226.253","2020-02-07 18:04:12","2020-02-07 18:05:25","","","","1","0000-00-00 00:00:00","2019-05-14 13:45:54","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-19 15:36:41","0584","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("342","0","0","0","0","0","0","1","2","15","0342","0","0","27","560","","AHMED ADAMU ERENA","08033189807","","","","M","1","Nigerian","13","6","1969","married","","","","angoaliyu76@yahoo.com","","SHIRORO","08033189807","","NEAR KUTA OVER HEAD TANK SHIRORO LGA","","","Normal","A+","None","","1","0","0","197.210.45.142","2019-05-31 10:59:39","2019-05-31 11:01:54","","","","1","0000-00-00 00:00:00","2019-05-14 13:47:01","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("343","0","1","0","0","10","20","1","4","4","0343","0","0","27","551","","YUSUF HAJARA","07039390789","","","","F","1","Nigerian","8","4","1994","married","","","","hajarayusuf789@gmail.com","","LAVUN","07039390789","","BEHIND FEDERAL POLYTECHNIC BIDA","","","Normal","A+","None","","1","0","0","41.190.14.12","2020-01-28 14:51:14","2020-01-28 14:56:21","","","","1","0000-00-00 00:00:00","2019-05-14 13:48:09","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0320","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("344","0","1","0","0","4","4","1","4","4","0344","0","0","23","482","","ADAMA ABDULKARIM","08069635262","","","","M","1","Nigerian","2","2","1987","married","","","","adamakareem@yahoo.com","","OFU","08069635262","","IBRAHIM KUCHI STREET OFF DEEPER LIFE CHURCH SHIRORO ROAD MINNA","","","Normal","O","None","","1","0","0","197.210.45.142","2019-05-31 11:03:30","2019-05-31 11:04:09","","","","1","0000-00-00 00:00:00","2019-05-14 13:49:54","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("345","0","1","0","0","2","14","1","2","14","0345","0","0","27","550","","NMA ABDULLAHI","08037309449","","","","M","1","Nigerian","13","3","1973","married","","","","angoaliyu76@yahoo.com","","LAPAI","08037309449","","Y.I DAUDU MAZA ROAD LAPAI","","","Normal","B+","None","","1","0","0","105.112.115.177","2020-01-16 13:07:11","2020-01-16 13:07:23","","","","1","0000-00-00 00:00:00","2019-05-14 13:50:50","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-03 08:29:29","0558","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("346","0","1","0","0","2","14","1","2","14","0346","0","0","27","550","","ABDULSALAM YUNUSA","08037346002","","","","M","1","Nigerian","1","6","1970","married","","","","angoaliyu76@yahoo.com","","LAPAI","08037346002","","A194 LIMAN ROAD LAPAI","","","Normal","O","None","","1","0","0","197.210.45.142","2019-05-31 11:07:54","2019-05-31 11:08:52","","","","1","0000-00-00 00:00:00","2019-05-14 14:05:18","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("347","0","1","0","0","9","18","1","9","18","0347","0","0","23","480","","GODWIN BLESSING","07060635272","","","","F","2","Nigerian","27","10","1983","married","","","","angoaliyu76@yahoo.com","","LOKOJA","07060635272","","NO. 19 MORRIS MINNA","","","Normal","O","None","","1","0","0","197.210.45.38","2020-01-03 15:06:25","2020-01-03 15:06:57","","","","1","0000-00-00 00:00:00","2019-05-14 14:06:32","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0249","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("348","0","0","0","0","0","0","1","10","22","0348","0","0","23","477","","OLORUNDA SAMSON OLUSEGUN","08036524092","","","","M","2","Nigerian","24","7","1974","married","","","","angoaliyu76@yahoo.com","","IJEMU","08036524092","","S34 BAY CLINIC ROAD TUNGA MINNA","","","Normal","O","None","","1","0","0","197.210.45.142","2019-05-31 11:12:15","2019-05-31 11:12:44","","","","1","0000-00-00 00:00:00","2019-05-14 14:08:14","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("349","0","1","0","0","1","11","1","1","11","0349","0","0","27","541","","IBRAHIM MUHAMMAD MUSTAPHA","07037764028","","","","M","1","Nigerian","24","9","1988","married","","","","ibrahimmustapha3776@gmail.com","","BIDA","07037764028","","BLOCK 9 HOUSE NO 6 BARIKIN SALE MINNA","","","Normal","O","None","","1","1","0","41.190.12.123","2020-02-04 09:23:39","2020-01-24 12:33:59","","","","1","0000-00-00 00:00:00","2019-05-14 14:09:37","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0519","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("350","0","1","0","0","2","15","1","2","15","0350","0","0","27","562","","DIKO TANKO","08052678994","","","","M","1","Nigerian","6","2","1982","married","","","","angoaliyu76@yahoo.com","","TAFA","08052678994","","TAFA LGA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 12:59:07","2020-01-16 12:59:16","","","","1","0000-00-00 00:00:00","2019-05-14 14:10:55","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0157","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("351","0","1","0","0","1","10","1","1","10","0351","0","0","27","550","","AHMED YAKUBU","08037823299","","","","M","1","Nigerian","6","3","1979","married","","","","angoaliyu76@yahoo.com","","LAPAI","08037823299","","FADIKPE","","","Normal","O","None","","1","0","0","105.112.113.95","2020-01-15 10:13:37","2020-01-15 10:20:14","","","","1","0000-00-00 00:00:00","2019-05-14 14:11:56","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0178","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("352","0","0","0","0","0","0","1","2","14","0352","0","0","0","0","","ABDULMALIK HAMZA KUTA","","","","","","0","","","","","","","","","abdulmalikhamza10@gmail.com","","","08037417440","","","","","","","","","1","0","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-05-14 16:17:22","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("353","0","0","0","0","0","0","1","2","14","0353","0","0","27","560","","ABDULMALIK HAMZA KUTA","08037417440","","","","M","1","Nigerian","2","2","1994","single","","","","abdulmalikhamza10@gmail.com","","minna","08037417440","","OFF OKADA ROAD BEHIND SCORPION HOUSE MINNA,NIGER STATE","OFF OKADA ROAD BEHIND SCORPION HOUSE MINNA,NIGER STATE","2019-05-14-162652.jpg","Normal","O","None","HEALTH CARE INTERNATIONAL MINNA","1","1","0","197.210.70.226","2020-01-14 00:43:04","2019-12-27 17:24:37","","","","1","0000-00-00 00:00:00","2019-05-14 16:17:25","0000-00-00 00:00:00","","","ALHAJI HAMZA  ABDUL","08034140538","OFF OKADA ROAD BEHIND SCORPION HOUSE MINNA,NIGER STATE","F","4","ALHAJI HAMZA  ABDUL","OFF OKADA ROAD BEHIND SCORPION HOUSE MINNA,NIGER STATE","0","","0","0000-00-00 00:00:00","","3","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("354","0","0","0","0","0","0","1","4","13","0354","0","0","27","549","","YUSUF JATAU","08030545970","","","2019-05-14-172443jatau.pdf.pdf","M","1","Nigerian","14","10","1973","married","","","","yusufjatau70@gmail.com","","KONTAGORA","08030545970","","FINANCE AND SUPPLY DEPT. KONTAGORA LOCAL GOVERNMENT COUNCIL, KONTAGORA, NIGER STATE","BESIDE MAI-UNGUWAN\'S RESIDENCE, DADIN KOWA AREA, KONTAGORA, NIGER STATE","2019-05-14-171638.jpg","Normal","B+","None","NONE","1","0","0","197.210.227.62","2019-05-14 17:16:07","2019-05-14 17:31:31","","","","1","0000-00-00 00:00:00","2019-05-14 17:15:44","0000-00-00 00:00:00","","","MUSA JATAU","08066059689","GOVERNMENT SECONDARY SCHOOL, KONTAGORA, NIGER STATE","BROTHER","1","SELF","BESIDE MAI-UNGUWAN\'S RESIDENCE, DADIN KOWA AREA, KONTAGORA, NIGER STATE","0","","0","0000-00-00 00:00:00","","10","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("355","0","1","0","0","10","20","1","2","2","0355","0","0","27","555","","ALHASSAN ABU EDUGI","08025048827","","","2019-05-15-092405convert-jpg-to-pdf.net_2019-05-15_10-21-58.pdf.pdf","M","1","Nigerian","1","1","1999","single","","","","alhassanabuedugi@gmail.com","","EDUGI","08025048827","","EDUGI MOKWA L G A NIGER STATE","EDUGI MOKWA L G A NIGER STATE","2019-05-15-091530.jpg","Normal","O","None","NIL","1","1","0","105.112.120.93","2020-03-13 11:39:53","2020-02-08 15:27:33","","","","1","0000-00-00 00:00:00","2019-05-15 08:42:49","0000-00-00 00:00:00","","","MR AND MRS ABUBAKAR ALHASSAN","07016925577","EDUGI MOKWA L G A NIGER STATE","FATHER","1","MR ABUBAKAR ALHASSAN","EDUGI MOKWA L G A NIGER STATE","1","                                
\n                                                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                                                 
\n                                ","3","2019-12-13 10:22:38","0018","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("356","0","1","0","0","7","5","1","7","5","0356","0","0","27","547","","ALIYU MUHAMMED LAWAL","08078813058","","","","M","1","Nigerian","11","2","1984","married","","","","buzhlefu2@gmail.com","","GURARA","08078813058","","NO. 22 BAYAN PAIDA FADUKPE MINNA","","","Normal","A+","None","","1","0","0","197.210.227.19","2020-02-03 15:39:33","2020-02-03 15:41:13","","","","1","0000-00-00 00:00:00","2019-05-15 09:46:10","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-20 13:39:13","0592","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("357","0","1","0","0","10","21","1","2","14","0357","0","0","27","543","","ABDULLAHI DADA MARYAM","08038509947","","","","F","1","Nigerian","20","7","1981","married","","","","angoaliyu76@yahoo.com","","BOSSO","08038509947","","GIDAN MARAFA OPPOSITE OLD POLICE STATION MAIKUNKELE","","","Normal","AB","None","","1","1","0","41.190.14.49","2019-10-03 12:30:47","2019-05-31 11:41:46","","","","1","0000-00-00 00:00:00","2019-05-15 09:48:24","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2019-12-13 10:28:27","0239","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("358","0","1","0","0","10","20","1","10","20","0358","0","0","27","550","","ABDULLAHI AISHA MUYE","08069573507","","","","F","1","Nigerian","15","3","1988","married","","","","angoaliyu76@yahoo.com","","LAPAI","08069573507","","NO. G3C 75, LONDON STREET DUTSEN KURA MINNA","","","Normal","B+","None","","1","0","0","197.210.45.38","2020-01-03 14:55:49","2020-01-03 14:56:20","","","","1","0000-00-00 00:00:00","2019-05-15 09:49:45","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0070","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("359","0","1","0","0","10","20","1","10","21","0359","0","0","27","544","","UMAR SANDA HASSANA","08140742305","","","","F","1","Nigerian","3","3","1993","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08140742305","","SUPREME PURE WATER ROAD BARIKIN SALE MINNA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 14:06:23","2020-01-16 14:06:33","","","","1","0000-00-00 00:00:00","2019-05-15 09:50:53","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0071","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("360","0","0","0","0","0","0","1","4","12","0360","0","0","28","575","","BANJO SEUN TAYO","08069219559","","","","M","2","Nigerian","25","1","1992","single","","","","seunbanjo0@gmail.com","","IKENNE","08069219559","","MAITUMBI FLAMINGO SAWMAIL MINNA","","","Normal","O","None","","1","0","0","105.112.120.193","2019-09-30 10:39:23","2019-09-30 10:39:37","","","","1","0000-00-00 00:00:00","2019-05-15 09:52:13","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("361","0","1","0","0","2","2","1","2","2","0361","0","0","27","543","","IBRAHIM YUNUSA ","08036666604","","","","M","1","Nigerian","23","2","1958","married","","","","musaisyaku@gmail.com","","BOSSO","08036666604","","ADAMAWA ROAD ALONG DUTSEN KURAN HAUSA MINNA","","","Normal","O","None","","1","0","0","197.210.47.41","2020-01-02 20:52:47","2020-01-02 20:53:26","","","","1","0000-00-00 00:00:00","2019-05-15 09:54:42","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0243","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("362","0","1","0","0","9","18","1","9","18","0362","0","0","27","550","","ALIYU MUSA KANDI","09033899749","","","","M","1","Nigerian","15","9","1995","single","","","","musaaliyu191@gmail.com","","LAPAI","09033899749","","GULU KANDI EMIKO LAPAI","","","Normal","AB","None","","1","0","0","197.210.45.38","2020-01-03 15:03:04","2020-01-03 15:04:06","","","","1","0000-00-00 00:00:00","2019-05-15 09:55:48","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0195","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("363","0","1","0","0","10","21","1","10","21","0363","0","0","27","550","","JIBRIN HAUWA","08132955178","","","","F","1","Nigerian","9","10","1993","married","","","","angoaliyu76@yahoo.com","","LAPAI","08132955178","","DUTSEN KURAN GWARI BEHIND SHEIKH JAFAR JUMMAT MOSQUE","","","Normal","O","None","","1","0","0","197.210.47.127","2020-01-02 22:49:46","2020-01-02 22:50:16","","","","1","0000-00-00 00:00:00","2019-05-15 09:56:39","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0133","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("364","0","1","0","0","1","11","1","1","11","0364","0","0","27","555","","MAMMAN ISAH ABUBAKAR ABDULLAHI","08067904757","","","","M","1","Nigerian","2","4","1968","married","","","","abubakaramisah6@gmail.com","","MOKWA","08067904757","","MUREGI EMITIFIN DEKE DISTRICT MOKWA LGA","","","Normal","A+","None","","1","0","0","105.112.114.140","2020-01-16 09:30:20","2020-01-16 09:32:11","","","","1","0000-00-00 00:00:00","2019-05-15 09:58:24","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0139","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("365","0","1","0","0","1","11","1","1","11","0365","0","0","27","545","","MOHAMMED NDAKOTSU MOHAMMED","08036908674","","","","M","1","Nigerian","1","5","1970","married","","","","mohammedndakotsu11@gmail.com","","EDATI","08036908674","","GBAMACHE VIA EDATI LGA","","","Normal","A+","None","","1","0","0","105.112.114.140","2020-01-16 09:29:07","2020-01-16 09:29:31","","","","1","0000-00-00 00:00:00","2019-05-15 10:00:03","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0140","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("366","0","0","0","0","0","0","1","2","14","0366","0","0","27","544","","ABDULRAHAMAN IBRAHIM","08032455836","","","","M","1","Nigerian","10","9","1989","single","","","","ibabdulrahaman@gmail.com","","CHANCHAGA","08032455836","","BEHIND ASSEMBLY OF GDA CHURCH KPAKUNGU MINNA","","","Normal","O","None","","1","0","0","197.210.45.142","2019-05-31 11:57:01","2019-05-31 11:57:56","","","","1","0000-00-00 00:00:00","2019-05-15 10:01:36","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("367","0","1","0","0","1","10","1","1","10","0367","0","0","27","550","","AUDU SALIHU","08153627770","","","","M","1","Nigerian","31","12","1977","married","","","","angoaliyu76@yahoo.com","","LAPAI","08153627770","","TAKUTI SHABA VIA LAPAI","","","Normal","O","None","","1","0","0","197.210.45.142","2019-05-31 11:58:05","2019-05-31 11:59:02","","","","1","0000-00-00 00:00:00","2019-05-15 10:02:59","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("368","0","1","0","0","1","11","1","1","11","0368","0","0","27","563","","MAKAMA YUSUF NASIR","08058229200","","","","M","1","Nigerian","30","6","1968","married","","","","nasirumakamay@gmail.com","","WUSHISHI","08058229200","","WAZIRI RESIDENCE BAKIN KASUWA WUSHISHI","","","Normal","O","None","","1","0","0","105.112.113.95","2020-01-15 10:49:11","2020-01-15 10:50:07","","","","1","0000-00-00 00:00:00","2019-05-15 10:04:17","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0348","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("369","0","0","0","0","0","0","1","2","14","0369","0","0","27","544","","INUWA FATI","07035752062","","","","F","1","Nigerian","24","4","1981","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","07035752062","","HOUSE NO 413 OFF BULUS DAUDA STREET 123 QRTRS MINNA","","","Normal","B+","None","","1","0","0","197.210.45.142","2019-05-31 12:02:55","2019-05-31 12:03:40","","","","1","0000-00-00 00:00:00","2019-05-15 10:05:19","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("370","0","1","0","0","2","2","1","2","2","0370","0","0","27","550","","MUHAMMAD AHMAD AISHATU","08133868244","","","","F","1","Nigerian","30","12","1972","married","","","","angoaliyu76@yahoo.com","","LAPAI","08133868244","","NO. 1 BEHIND NIGER STATE TELEVISION TUNGA MINNA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 13:09:44","2020-01-16 13:09:53","","","","1","0000-00-00 00:00:00","2019-05-15 10:07:41","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0347","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("371","0","1","0","0","2","15","1","2","15","0371","0","0","27","558","","ISAH MOHAMMED IDRIS","08050465790","","","","M","1","Nigerian","6","2","1978","married","","","","angoaliyu76@yahoo.com","","RAFI","08050465790","","TEGINA ANGUWAN LIMAN ","","","Normal","O","None","","1","0","0","197.210.60.119","2020-01-03 11:20:08","2020-01-03 11:20:48","","","","1","0000-00-00 00:00:00","2019-05-15 10:10:55","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-19 15:58:37","0587","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("372","0","0","0","0","0","0","1","2","14","0372","0","0","0","0","","ALIYU SHEHU AHMADU","","","","","","0","","","","","","","","","aliyushehuahmadu@gmail.com","","","09030962366","","","","","","","","","1","1","0","107.170.202.185","2019-05-15 12:01:34","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-05-15 10:12:15","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("373","0","1","0","0","4","13","1","4","13","0373","0","0","27","558","","ISAH MOHAMMED","07034583988","","","","M","1","Nigerian","11","9","1969","married","","","","yushauisah33@gmail.com","","RAFI","07034583988","","UP MAI ANGUWAN HOUSE SABON GARI TEGINA ","","","Normal","O","None","","1","1","0","41.190.12.198","2020-01-27 11:23:25","2020-01-16 11:39:51","","","","1","0000-00-00 00:00:00","2019-05-15 10:16:16","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0448","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("374","0","1","0","0","10","20","1","7","16","0374","0","0","27","551","","YUSUF HASSANA","08032427115","","","2019-09-24-100430Document.pdf.pdf","M","1","Nigerian","24","12","1995","single","","","","angoaliyu76@yahoo.com","","LAVUN","08032427115","","HOUSE NO. D47 FARM CENTRE TUNGA MINNA","","2019-09-24-100007.jpg","Normal","AB","None","","1","0","0","105.112.115.177","2020-01-16 13:31:04","2020-01-16 13:31:49","","","","1","0000-00-00 00:00:00","2019-05-15 10:17:17","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0101","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("375","0","1","0","0","7","16","1","7","16","0375","0","0","27","544","","TANKO YUSUF","08038071818","","","","M","1","Nigerian","8","8","1980","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08038071818","","NE 220 ARAYI CLOSE MINNA","","","Normal","O","None","","1","0","0","105.112.112.20","2020-01-28 16:25:55","2020-01-28 16:26:05","","","","1","0000-00-00 00:00:00","2019-05-15 10:18:11","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0442","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("376","0","0","0","0","0","0","1","2","14","0376","0","0","27","548","","ALHASSAN FATIMA","08064777598","","","","F","1","Nigerian","15","12","1984","married","","","","angoaliyu76@yahoo.com","","KATCHA","08064777598","","CHANCHAGA OPPOSITE UNITY NURSERY AND PRIMARY SCHOOL","","","Normal","O","None","","1","0","0","197.210.45.142","2019-05-31 12:11:37","2019-05-31 12:12:18","","","","1","0000-00-00 00:00:00","2019-05-15 10:19:29","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("377","0","0","0","0","0","0","1","2","14","0377","0","0","27","544","","AHMED HALIRAT","08148288409","","","","F","1","Nigerian","18","3","1997","single","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08148288409","","DUTSEN KURAN GWARI NEAR MYPA COLLEGE","","","Normal","O","None","","1","0","0","197.210.45.142","2019-05-31 12:12:24","2019-05-31 12:13:05","","","","1","0000-00-00 00:00:00","2019-05-15 10:22:12","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("378","0","1","0","0","9","18","1","10","21","0378","0","0","27","548","","MOHAMMED ABDULLAHI","08133196446","","","","M","1","Nigerian","22","5","1987","married","","","","mohammedabdullahi8787@yahoo.com","","KATCHA","08133196446","","PLOT 246 BY AP JUNCTION ALONG FEDERAL POLYTECHNIC BIDA","","","Normal","A+","None","","1","0","0","105.112.115.177","2020-01-16 14:55:45","2020-01-16 14:56:15","","","","1","0000-00-00 00:00:00","2019-05-15 10:23:45","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-22 15:06:26","0607","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("379","0","1","0","0","7","16","1","7","16","0379","0","0","27","560","","YUSUF ABDULLAHI HAKIMI","08060775182","","","","M","1","Nigerian","10","6","1996","married","","","","abdullahihakimiyusuf@gmail.com","","SHIRORO","08060775182","","ABGUWAN APAWYI KUTA GIDAN MALLAM ARABI","","","Normal","O","None","","1","0","0","197.210.64.37","2020-01-02 22:29:11","2020-01-02 22:30:14","","","","1","0000-00-00 00:00:00","2019-05-15 10:24:58","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0136","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("380","0","1","0","0","9","18","1","2","14","0380","0","0","27","544","","MUHAMMAD ILIYASU","08146587705","","","","M","1","Nigerian","8","6","1987","married","","","","iliyasumuhammad912@yahoo.com","","CHANCHAGA","08146587705","","TEMBER SHEET SAYAKO MAITUMBI ROAD MINNA","","","Normal","A+","None","","1","0","0","105.112.115.177","2020-01-16 14:54:53","2020-01-16 14:55:35","","","","1","0000-00-00 00:00:00","2019-05-15 10:26:29","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-26 12:46:18","0621","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("381","0","1","0","0","9","6","1","9","18","0381","0","0","26","534","","AZAMU YUSUF INALOKO","07057799186","","","","M","1","Nigerian","2","8","1993","married","","","","angoaliyu76@yahoo.com","","NASARAWA","07057799186","","KAFFIN KORO","","","Normal","A+","None","","1","1","0","197.211.58.120","2019-11-19 09:41:00","2019-05-31 12:17:28","","","","1","0000-00-00 00:00:00","2019-05-15 10:29:51","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-13 11:12:25","0574","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("382","0","1","0","0","9","18","1","9","18","0382","0","0","27","557","","ALIYU SULEIMAN PAIKO","08031985029","","","","M","1","Nigerian","1","4","1982","married","","","","angoaliyu76@yahoo.com","","PAIKORO","08031985029","","NO. 3 ETSU ZUBAIRU ROAD MAKERA PAIKO","","","Normal","O","None","","1","0","0","105.112.117.154","2020-02-11 16:12:26","2020-02-11 16:53:23","","","","1","0000-00-00 00:00:00","2019-05-15 10:31:56","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0003","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("383","0","1","0","0","4","13","1","4","13","0383","0","0","31","638","","FAWOLE ABIODUN OMOLEYE","08035693292","","","","M","2","Nigerian","1","1","1975","married","","","","ommamillenium@yahoo.com","","IBADAN","08035693292","","STATE UNIT","","","Normal","B+","None","","1","0","0","105.112.115.177","2020-01-16 11:39:18","2020-01-16 11:39:27","","","","1","0000-00-00 00:00:00","2019-05-15 10:33:26","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-04 14:16:34","0469","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("384","0","1","0","0","4","12","1","4","12","0384","0","0","27","539","","MOHAMMED YABAGI","07036446678","","","","M","1","Nigerian","13","1","1983","married","","","","muyab6678@gmail.com","","AGAIE","07036446678","","ALHAJI YABAGI MAAJI RESIDENCE EFU KENCHI AGAEI","","","Normal","A+","None","","1","0","0","197.210.85.22","2020-01-02 15:56:39","2020-01-02 15:57:14","","","","1","0000-00-00 00:00:00","2019-05-15 10:34:57","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0076","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("385","0","1","0","0","1","11","1","1","11","0385","0","0","17","309","","AGHA CHINELO IFEYINWA","07030690554","","","","F","2","Nigerian","4","3","1968","married","","","","chineloagha@gmail.com","","OGUTA","07030690554","","PLOT B222 NNAMDI AZIKWE STREET PENT HOUSE ESTATE III LUGBE AIRPORT ROAD ABUJA","","2019-09-23-144200.jpg","Normal","O","None","","1","0","0","105.112.114.140","2020-01-16 09:27:36","2020-01-16 09:28:02","","","","1","0000-00-00 00:00:00","2019-05-15 10:37:25","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0094","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("386","0","1","0","0","2","15","1","2","15","0386","0","0","15","276","","USMAN TIJANI MOHAMMED","08032918140","","","2019-05-15-114612usman tijani.pdf.pdf","M","1","Nigerian","22","7","1967","married","","","","world2tj56@gmail.com","","OKENE","08032918140","","FEDERAL MEDICAL CENTER BIDA, NIGER STATE","AP POLY ROAD BIDA, NIGER STATE","2019-05-15-113942.jpg","Normal","B+","None","","1","0","0","197.210.45.38","2020-01-03 13:52:50","2020-01-03 13:53:26","","","","1","0000-00-00 00:00:00","2019-05-15 10:49:14","0000-00-00 00:00:00","","","","","","","4","","","1","                                
\n                                                                 
\n                                ","3","2019-11-24 10:57:23","0610","20","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("387","0","0","0","0","0","0","1","9","21","0387","0","0","27","551","","Muhammad Jibrin Sokomba","08032912211","","","2019-05-16-111207sokom docx-converted.pdf.pdf","M","1","Nigerian","30","11","1993","married","","","","mjsokomba@gmail.com","","Sokomba Village","08032912211","","Kpakungu along Bida road, Mrs. Sokomba House Via Ndakpakpan house","Kpakungu along Bida road, Mrs. Sokomba House Via Ndakpakpan house","2019-05-16-105514.jpg","Normal","AB","None","","1","0","0","41.190.12.157","2019-05-18 14:46:25","2019-05-18 14:47:27","","","","0","0000-00-00 00:00:00","2019-05-15 10:57:32","0000-00-00 00:00:00","","","Muhammad Zubairu Sokomba","08038131053","Kpakungu along Bida road, Mrs. Sokomba House Via Ndakpakpan house","Father","2","Muhammad Zubairu Sokomba","Kpakungu along Bida road, Mrs. Sokomba House Via Ndakpakpan house","0","","0","0000-00-00 00:00:00","","1","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("388","0","1","0","0","7","16","1","7","16","0388","0","0","27","551","","Mohammed Zainab Danjuma","08060206308","","","2019-05-15-111924convert-jpg-to-pdf.net_2019-05-15_12-18-40.pdf.pdf","F","1","Nigerian","1","3","1986","married","","","","mddanjuma2017@gmail.com","","Minna","08060206308","","Behind A A Rano Filing Station Minna, Niger State","Behind A A Rano Filing Station Minna, Niger State","2019-05-15-110630.jpg","Normal","O","None","None","1","0","0","197.210.45.38","2020-01-03 14:51:06","2020-01-03 14:51:33","","","","1","0000-00-00 00:00:00","2019-05-15 11:04:01","0000-00-00 00:00:00","","","Mohammed Danjuma","08034532347","Behind A A Rano Filing Station Minna, Niger State","Husband","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0330","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("389","0","0","0","0","0","0","1","7","17","0389","0","0","27","550","","IDRIS ALHAJI SALIHU","08068196615","","","2019-05-15-122845SALIHU NCE.pdf.pdf","M","1","Nigerian","2","11","1998","single","","","","idrissalihu69@gmail.com","","EMU","08068196615","","EMU VIA LAPAI, NIGER STATE","EMU VIA LAPAI, NIGER STATE","2019-05-15-123002.jpg","Normal","O","None","NIL","1","1","0","197.210.55.162","2019-10-02 13:00:18","0000-00-00 00:00:00","","","","1","0000-00-00 00:00:00","2019-05-15 12:00:42","0000-00-00 00:00:00","","","ALHAJI SALIHU","","EMU VIA LAPAI, NIGER STATE","FATHER","1","ALHAJI SALIHU","EMU VIA LAPAI, NIGER STATE","0","","0","0000-00-00 00:00:00","","2","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("390","0","0","0","0","0","0","1","2","14","0390","0","0","0","0","","ALIYU SHEHU AHMADU","","","","","","0","","","","","","","","","aliyushehuahmadu@gmail.com","","","09030962366","","","","","","","","","1","0","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-05-15 12:02:16","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("391","0","1","0","0","1","1","1","1","1","0391","0","0","27","549","","Muazu Ibrahim","08119610289","","","2019-05-15-231408Credentials.pdf.pdf","M","1","Nigerian","15","2","1996","single","","","","muazuibrahim45@yahoo.com","","Kontagora","08119610289","","No 1 Mustapha Babangida road, Opposite Sch. of Midwifery  Off Bay Clinic road.
\nTunga, Minna","No 1 Mustapha Babangida road, Opposite Sch. of Midwifery  Off Bay Clinic road.
\nTunga, Minna","2019-05-15-230019.jpg","Normal","O","None","Mentally and Physically Fit.","1","1","0","41.203.73.146","2019-09-02 17:49:19","2019-05-15 23:53:25","","","","1","0000-00-00 00:00:00","2019-05-15 12:37:28","0000-00-00 00:00:00","","","Abdullahi Aliyu Anaba","08039139023","No 1 Mustapha Babangida road, Opposite Sch. of Midwifery  Off Bay Clinic road.
\nTunga, Minna","Uncle","1","Abdullahi Aliyu Anaba","Development Finance Office, Central Bank of Nigeria, Paiko road Minna, Niger State","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","1","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("392","0","0","0","0","0","0","1","1","10","0392","0","0","27","544","","AHMED SARKI ALIYU","07063544000","","","","M","1","Nigerian","15","2","1982","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","07063544000","","NE 23B KUTA ROAD","","","Normal","B+","None","","1","0","0","197.210.45.142","2019-05-31 12:22:23","2019-05-31 12:22:54","","","","1","0000-00-00 00:00:00","2019-05-15 13:32:20","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("393","0","1","0","0","1","11","1","1","11","0393","0","0","27","550","","MUSA GIMBA JANKARA","08036071304","","","","M","1","Nigerian","17","7","1970","married","","","","musagimbajankara@gmail.com","","lapai","08036071304","","ABUGI JANKARA VIA LAPAI LGA ","","","Normal","O","None","","1","0","0","197.210.45.142","2019-05-31 12:23:08","2019-05-31 12:24:00","","","","1","0000-00-00 00:00:00","2019-05-15 13:37:36","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("394","0","1","0","0","1","11","1","1","11","0394","0","0","27","550","","MOHAMMED IBN IBRAHIM","08055555236","","","","M","1","Nigerian","30","6","1969","married","","","","mibazhi@gmail.com","","LAPAI","08055555236","","BARIKIN SALE MINNA","","","Normal","O","None","","1","0","0","197.210.45.142","2019-05-31 12:24:11","2019-05-31 12:24:39","","","","1","0000-00-00 00:00:00","2019-05-15 13:44:11","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("395","0","1","0","0","2","14","1","2","14","0395","0","0","27","550","","UMAR HAMZA SANDA","07037638726","","","","M","1","Nigerian","13","6","1990","married","","","","angoaliyu76@yahoo.com","","LAPAI","07037638726","","BARIKIN SALE OPPOSITE MORRIS JUNCTION","","","Normal","B+","None","","1","0","0","105.112.112.20","2020-01-28 16:20:19","2020-01-28 16:20:31","","","","1","0000-00-00 00:00:00","2019-05-15 13:51:31","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0287","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("396","0","1","0","0","9","18","1","11","24","0396","0","0","27","550","","RAMATU ABDULLAHI","08032135231","","","2019-05-15-141543ramat.pdf.pdf","F","1","Nigerian","21","2","1984","married","","","","johnjohnny913@gmail.com","","LAPAI","08032135231","","BANI ROAD LAPAI, NIGER STATE","BANI ROAD LAPAI, NIGER STATE","2019-05-15-135441.jpg","Normal","O","None","NORMAL ","1","0","0","197.210.227.133","2019-12-02 12:44:37","2019-12-02 13:08:46","","","","1","0000-00-00 00:00:00","2019-05-15 13:53:30","0000-00-00 00:00:00","","","ABDULLAHI NDEJI","08103303030","BANI ROAD LAPAI, NIGER STATE","FATHER","1","ABDULLAHI NDEJI","BANI ROAD LAPAI, NIGER STATE","1","                                
\n                                                                 
\n                                ","3","2019-11-08 10:38:20","0644","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("397","0","1","0","0","2","14","1","2","14","0397","0","0","27","544","","ABDULLAHI MUSA GALADIMA","08036120816","","","","M","1","Nigerian","19","8","1966","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08036120816","","NE 229 ABAYI CLOSE MINNA","","","Normal","O","None","","1","0","0","197.210.45.38","2020-01-03 14:44:12","2020-01-03 14:44:49","","","","1","0000-00-00 00:00:00","2019-05-15 14:12:26","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0163","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("398","0","0","0","0","0","0","1","1","11","0398","0","0","27","560","","KOJE SAMUEL","08038081265","","","","M","2","Nigerian","4","7","1984","married","","","","all4samzen@gmail.com","","SHIRORO","08038081265","","BEHIND ADEX CONSTRUCTION COMPANY BYE PASS ANGUWAR KADARA MAITUMBI","","","Normal","O","None","","1","0","0","197.210.45.142","2019-05-31 12:27:37","2019-05-31 12:28:08","","","","1","0000-00-00 00:00:00","2019-05-15 14:17:26","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("399","0","1","0","0","9","18","1","9","18","0399","0","0","27","544","","HARUNA BALKISU","07031962605","","","","F","1","Nigerian","20","8","1983","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","07031962605","","YUSUF KOLAWOLE ROAD TUNGA MINNA","","","Normal","O","None","","1","0","0","197.210.226.253","2020-02-07 17:24:39","2020-02-07 17:25:41","","","","1","0000-00-00 00:00:00","2019-05-15 14:25:26","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0272","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("400","0","0","0","0","0","0","1","2","2","0400","0","0","27","544","","Yakubu Shuaibu","08166683776","","","2019-05-15-150346Graphic1.pdf.pdf","M","2","Nigerian","16","4","1983","married","","","","Shaibu202030@gmail.com","","Niger","08166683776","","Saukakahuta area minna Niger State","Saukakahuta area minna Niger State","2019-05-15-150536.jpg","Normal","O","None","","1","1","0","197.210.52.24","2019-11-27 08:59:34","2019-05-15 15:13:12","","","","1","0000-00-00 00:00:00","2019-05-15 14:26:16","0000-00-00 00:00:00","","","Yakubu usman","08142510403","","Father","4","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("401","0","0","0","0","0","0","1","7","16","0401","0","0","27","550","","MENEGBE AJECHI MEDINAT","07034421429","","","","F","1","Nigerian","16","3","1991","single","","","","dinatu4shaibu@gmail.com","","LAPAI","07034421429","","BEHIND BAHAGO PLAZA TUNG","","","Normal","O","None","","1","0","0","197.210.45.142","2019-05-31 12:29:02","2019-05-31 12:29:39","","","","1","0000-00-00 00:00:00","2019-05-15 14:30:11","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("402","0","0","0","0","0","0","1","2","14","0402","0","0","27","557","","AKINWALE SEYI","08032826515","","","","M","2","Nigerian","10","6","1984","married","","","","akinwaleseyi303@gmail.com","","PAIKORO","08032826515","","FIRST BAPTIST CHURCH PO BOX 67 PAIKO ","","","Normal","O","None","","1","0","0","197.210.57.87","2019-06-18 16:58:18","2019-06-18 17:09:28","","","","1","0000-00-00 00:00:00","2019-05-15 14:37:37","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("403","0","0","0","0","0","0","1","1","1","0403","0","0","27","544","","AJIYA HASSAN","08104860265","","","","M","1","Nigerian","14","4","1997","single","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08104860265","","ALBASHIRI MINNA ","","","Normal","O","None","","1","1","0","105.112.120.119","2019-12-05 11:12:36","2019-10-22 09:11:15","","","","1","0000-00-00 00:00:00","2019-05-15 14:51:56","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("404","0","0","0","0","0","0","1","10","21","0404","0","0","27","544","","NURUDEEN MOHAMMED INUWA","08148477088","","","","M","1","Nigerian","27","8","1992","married","","","","Nurudeeninuwa@gmail.com","","Minna","08148477088","","Dutsen Kuran Hausa off Adamawa Road Minna Niger State","Dutsen Kuran Hausa off Adamawa Road Minna Niger State","","Normal","O","None","Good","1","0","0","105.112.96.169","2020-01-07 13:00:22","2020-01-07 13:02:24","","","","1","0000-00-00 00:00:00","2019-05-15 16:15:47","0000-00-00 00:00:00","",""," MUHAMMED INUWA","08148477088","Dutsen Kuran Hausa off Adamawa Road Minna Niger State","Father","1","Father","Dutsen Kuran Hausa off Adamawa Road Minna Niger State","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("405","0","1","0","0","9","18","1","9","18","0405","0","0","27","553","","SULEIMAN GARBA","07080054503","","","2019-05-16-093405jpg2pdf(3).pdf.pdf","M","1","Nigerian","15","12","1995","single","","","","kotonkorosuleiman72@gmail.com","","Sabon Garin Kotonkoro","07080054503","","SABON GARIN KOTONKORO VIA MARIGA LGA","SABON GARIN KOTONKORO VIA MARIGA LGA","2019-05-16-091403.jpg","Normal","O","None","NORMAL","1","0","0","105.112.120.74","2019-11-15 10:47:30","2019-11-15 10:51:35","","","","1","0000-00-00 00:00:00","2019-05-16 09:12:41","0000-00-00 00:00:00","","","ABDULLAHI AHMED","09013826131","SABON GARIN KOTONKORO VIA MARIGA LGA","BROTHER","1","SULEIMAN GARBA","SABON GARIN KOTONKORO VIA MARIGA LGA","1","                                
\n                                                                 
\n                                ","3","2019-11-03 08:39:43","0521","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("406","0","0","0","0","0","0","1","2","14","0406","0","0","27","541","","SALIHU USMAN","08065737910","","","","M","1","Nigerian","26","1","1982","married","","","","salihuuthman@gmail.com","","BIDA","08065737910","","V/A 50 BACK OF ST MARY CHURCH KPAKUNGU AREA MINNA","","","Normal","O","None","","1","0","0","197.210.45.142","2019-05-31 12:32:52","2019-05-31 12:33:44","","","","1","0000-00-00 00:00:00","2019-05-16 09:27:22","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("407","0","1","0","0","10","22","1","2","15","0407","0","0","27","541","","BELLO NUHU","07061612824","","","","M","1","Nigerian","1","10","1984","single","","","","angoaliyu76@yahoo.com","","BIDA","07061612824","","EMI ALH. BELLO BAZUMAGI AREA BIDA","","","Normal","O","None","","1","0","0","197.210.45.142","2019-05-31 12:33:57","2019-05-31 12:34:39","","","","1","0000-00-00 00:00:00","2019-05-16 09:29:21","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-03 08:50:11","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("408","0","0","0","0","0","0","1","2","15","0408","0","0","27","541","","MOHAMMED MOHAMMED","07039344453","","","","M","1","Nigerian","5","5","1986","single","","","","angoaliyu76@yahoo.com","","BIDA","07039344453","","EMI ALHAJI MOHAAMMED BAWUYA BIDA AREA","","","Normal","O","None","","1","0","0","197.210.45.142","2019-05-31 12:34:49","2019-05-31 12:35:27","","","","1","0000-00-00 00:00:00","2019-05-16 09:30:20","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("409","0","0","0","0","0","0","1","2","15","0409","0","0","27","541","","IBRAHIM NDAMAN","08032894441","","","","M","1","Nigerian","2","7","1983","single","","","","alibrahimiyyah@gmail.com","","BIDA","08032899444","","EMI ALHAJI IBRAHIM BANYAGI AREA BIDA","","","Normal","O","None","","1","1","0","197.210.129.14","2019-12-03 15:33:12","2019-05-31 12:36:28","","","","1","0000-00-00 00:00:00","2019-05-16 09:31:21","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("410","0","1","0","0","2","15","1","2","15","0410","0","0","27","541","","MAIMUNAT ALHAJI TAUHEED","08033715200","","","","M","1","Nigerian","28","12","1978","married","","","","angoaliyu76@yahoo.com","","BIDA","08033715200","","EMI DANMASANIN TUTIJINBA AREA BIDA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 13:06:47","2020-01-16 13:07:02","","","","1","0000-00-00 00:00:00","2019-05-16 09:33:06","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2019-11-12 12:11:56","0470","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("411","0","1","0","0","7","16","1","7","16","0411","0","0","27","560","","ABDULLAHI IDRIS","07038860204","","","","M","1","Nigerian","2","4","1990","single","","","","angoaliyu76@yahoo.com","","SHIRORO","07038860204","","ANGUWAN SARKIN MINNA KUTA SHIRORO LGA","","","Normal","B+","None","","1","0","0","197.210.45.142","2019-05-31 12:37:49","2019-05-31 12:38:33","","","","1","0000-00-00 00:00:00","2019-05-16 09:34:33","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("412","0","1","0","0","4","12","1","4","12","0412","0","0","27","541","","ALHASSAN FATIMA","07036083268","","","","F","1","Nigerian","24","6","1990","married","","","","angoaliyu76@yahoo.com","","BIDA","07036083268","","BEHIND BRIGHTER SCHOOL MINNA","","","Normal","B+","None","","1","0","0","197.210.60.119","2020-01-03 10:51:59","2020-01-03 10:52:33","","","","1","0000-00-00 00:00:00","2019-05-16 09:36:17","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0541","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("413","0","0","0","0","0","0","1","7","16","0413","0","0","23","487","","MAJI SOLOMON","08163738722","","","","M","2","Nigerian","2","3","1987","married","","","","majisolomon63@gmail.com","","OMALA","08163738722","","MAJI IBRAHIM COMPOUND ALONG IKEDE ROAD ABEJUKOLOYE OMALA LGA","","","Normal","AB","None","","1","1","0","82.145.220.57","2019-11-20 14:12:30","2019-05-31 12:40:56","","","","1","0000-00-00 00:00:00","2019-05-16 09:53:41","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("414","0","1","0","0","7","5","1","7","5","0414","0","0","7","659","","SUNDAY EDU","09064143272","","","","M","2","Nigerian","22","9","1994","single","","","","angoaliyu76@yahoo.com","","BENUE","09064143272","","OPPOSITE DEEPER LIFE COMPOUND MINNA","","","Normal","O","None","","1","0","0","197.210.45.142","2019-05-31 12:41:04","2019-05-31 12:41:45","","","","1","0000-00-00 00:00:00","2019-05-16 09:56:14","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("415","0","1","0","0","2","15","1","2","15","0415","0","0","12","225","","OBOH VICTORIA OGEDENGBE","08063508224","","","","F","2","Nigerian","12","6","1990","married","","","","victoriaoboh2016@gmail.com","","AKOKO EDO","08063508224","","AFITOUCHA STREET IKPENA OSOS EDO STATE","","","Normal","A+","None","","1","0","0","105.112.115.177","2020-01-16 12:59:36","2020-01-16 12:59:45","","","","1","0000-00-00 00:00:00","2019-05-16 09:59:13","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0376","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("416","0","1","0","0","10","21","1","2","14","0416","0","0","27","557","","ISAH WAZIRI AISHA","09039158015","","","","F","1","Nigerian","11","9","1990","single","","","","angoaliyu76@yahoo.com","","PAIKO","09039158015","","DUTSEN KURAN GWARI MINNA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 14:10:48","2020-01-16 14:10:57","","","","1","0000-00-00 00:00:00","2019-05-16 10:00:28","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0338","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("417","0","1","0","0","10","21","1","10","21","0417","0","0","27","544","","AHMADU MAIMUNA","09038609900","","","","F","1","Nigerian","10","7","1996","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","09038609900","","FLAY OUT TUKURA ROAD HOUSE NO 21 MINNA","","","Normal","A+","None","","1","0","0","197.210.45.38","2020-01-03 14:53:27","2020-01-03 14:54:00","","","","1","0000-00-00 00:00:00","2019-05-16 10:01:51","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0253","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("418","0","1","0","0","4","13","1","4","13","0418","0","0","27","559","","TURAKI ALIYU","07030115197","","","","M","1","Nigerian","9","12","1988","single","","","","aturaki7@gmail.com","","RIJAU","07030115197","","HOUSE NO 55, VIA REWARD ACADEMIC PRIMARY SCHOOL SULEJA","","","Normal","B+","None","","1","0","0","197.210.45.142","2019-05-31 12:46:24","2019-05-31 12:47:18","","","","1","0000-00-00 00:00:00","2019-05-16 10:03:26","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("419","0","1","0","0","10","22","1","4","13","0419","0","0","27","541","","AHMED MOHAMMED LAWAL","08069727819","","","","M","1","Nigerian","17","1","1990","married","","","","auwalmkahmed@gmail.com","","BIDA","08069727819","","NO 7 OFF OKADA ROAD, DUTSEN KURAN HAUSA MINNA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 14:15:50","2020-01-16 14:15:59","","","","1","0000-00-00 00:00:00","2019-05-16 10:05:56","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-16 09:53:44","0553","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("420","0","0","0","0","0","0","1","2","14","0420","0","0","27","560","","DANIYA ANTHONIA","08065642666","","","","F","2","Nigerian","24","10","1974","single","","","","angoaliyu76@yahoo.com","","SHIRORO","08065642666","","OPPOSITE MAITUMBI PRIMARY SCHOOL MINNA","","","Normal","A+","None","","1","0","0","197.210.45.142","2019-05-31 12:48:27","2019-05-31 12:49:24","","","","1","0000-00-00 00:00:00","2019-05-16 10:07:29","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("421","0","1","0","0","1","10","1","1","10","0421","0","0","27","544","","BULUS SUNDAY","08039504263","","","","M","2","Nigerian","22","1","1987","married","","","","sundaybulus05@gmail.com","","CHANCHAGA","08039504263","","BEHIND BLUE SPRING SCHOOL ANGUWAN KADARA MAITUMBI","","","Normal","B+","None","","1","0","0","105.112.113.95","2020-01-15 10:11:51","2020-01-15 10:12:16","","","","1","0000-00-00 00:00:00","2019-05-16 10:08:50","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0203","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("422","0","0","0","0","0","0","1","10","21","0422","0","0","27","544","","EDU ANGELA","07060860652","","","","F","2","Nigerian","28","1","1993","single","","","","angelaedu2016@gmail.com","","CHANCHAGA","07060860652","","OPPOSITE DEEPER LIFE COMPOUND MINNA","","","Normal","B+","None","","1","0","0","197.210.45.142","2019-05-31 12:50:21","2019-05-31 12:51:01","","","","1","0000-00-00 00:00:00","2019-05-16 10:10:12","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("423","0","0","0","0","0","0","1","2","14","0423","0","0","27","539","","ABDULLAHI KATAMBA","08136851165","","","","M","1","Nigerian","15","4","1974","married","","","","angoaliyu76@yahoo.com","","AGAIE","08136851165","","EMI YA KATAMBA EKO WUNA AGAIE","","","Normal","O","None","","1","0","0","105.112.120.200","2019-12-13 11:09:58","2019-12-13 11:10:50","","","","1","0000-00-00 00:00:00","2019-05-16 10:11:17","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("424","0","0","0","0","0","0","1","4","13","0424","0","0","27","544","","AHMED SAEED","08038359021","","","","M","1","Nigerian","28","4","1989","single","","","","saeedsd29@yahoo.com","","CHANCHAGA","08038359021","","BESIDE MYPA COLLEGE DUTSEN KURAN GWARI KWASAU","","","Normal","B+","None","","1","0","0","197.210.45.142","2019-05-31 12:51:55","2019-05-31 12:52:28","","","","1","0000-00-00 00:00:00","2019-05-16 10:13:49","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("425","0","1","0","0","9","18","1","9","18","0425","0","0","27","543","","MOHAMMAD ALHAJI ABDULLAHI","08155126730","","","","M","1","Nigerian","14","12","1986","married","","","","angoaliyu76@yahoo.com","","BOSSO","08155126730","","SABON DAGAH OPPOSITE MAIZUBE FARMS ALONG BIDA ROAD MINNA","","","Normal","B+","None","","1","0","0","197.210.45.142","2019-05-31 12:52:54","2019-05-31 12:53:37","","","","1","0000-00-00 00:00:00","2019-05-16 10:15:17","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("426","0","0","0","0","0","0","1","1","11","0426","0","0","27","549","","MUSA ABUBAKAR","08036489053","","","","M","1","Nigerian","2","5","1970","married","","","","angoaliyu76@yahoo.com","","","08036489053","","AE 67 FOBIO HOUSE KONTAGORA (SARILIN BAUCHI COMPOUND)","","","Normal","O","None","","1","0","0","197.210.57.90","2019-06-18 17:09:41","2019-06-18 17:20:30","","","","1","0000-00-00 00:00:00","2019-05-16 10:16:21","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("427","0","1","0","0","1","11","1","1","11","0427","0","0","27","553","","ABDULLAHI NUHU SA\'AD","08038165873","","","","M","1","Nigerian","29","4","1964","married","","","","saadnuhu@100.comm","","MARIGA","08038165873","","UNGUWAN WAZIRIMARIGA TOWN ","","","Normal","B+","None","","1","0","0","105.112.114.140","2020-01-16 09:49:25","2020-01-16 09:49:43","","","","1","0000-00-00 00:00:00","2019-05-16 10:17:43","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0256","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("428","0","0","0","0","0","0","1","2","14","0428","0","0","0","0","","SANI YAHAYA ","","","","","","0","","","","","","","","","saniyahaya127@gmail.com","","","08064424330","","","","","","","","","1","0","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-05-16 10:19:31","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("429","0","0","0","0","0","0","1","2","14","0429","0","0","27","548","","SANI YAHAYA ESSA","08064424330","","","","M","1","Nigerian","14","11","1984","married","","","","saniyahaya127@gmail.com","","KATCHA","08064424330","","IJ 9 ALHAJI ABUBAKAR ROAD OLD AIRPORT QRTRS MINNA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 13:58:03","2020-01-16 13:58:19","","","","1","0000-00-00 00:00:00","2019-05-16 10:20:06","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("430","0","1","0","0","4","4","1","4","4","0430","0","0","27","557","","DANLADI ABUBAKAR","09093025136","","","","M","1","Nigerian","16","3","1995","single","","","","angoaliyu76@yahoo.com","","PAIKORO","09093025136","","PAIKO T/MALLAM VIA MINNA","","","Normal","O","None","","1","0","0","197.210.45.142","2019-05-31 12:56:51","2019-05-31 12:57:26","","","","1","0000-00-00 00:00:00","2019-05-16 10:23:50","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("431","0","0","0","0","0","0","1","4","13","0431","0","0","27","551","","MOHAMMED AISHETU","08034594750","","","","F","1","Nigerian","18","11","1983","married","","","","angoaliyu76@yahoo.com","","LAVUN","08034594750","","HOUSE NO. 25 LOWCOST KUTIGI ","","","Normal","A+","None","","1","0","0","197.210.52.144","2019-06-20 13:38:30","2019-06-20 13:39:45","","","","1","0000-00-00 00:00:00","2019-05-16 10:25:26","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("432","0","0","0","0","0","0","1","2","15","0432","0","0","27","546","","MOHAMMED CHADO","07030738803","","","","M","1","Nigerian","1","3","1983","married","","","","mohammedchado@yahoo.com","","ZANCHITA","07030738803","","HOUSE NO. BK9/40 BARKIN SALE AREA WAKILI ROAD MINNA, NIGER STATE ","HOUSE NO. BK9/40 BARKIN SALE AREA WAKILI ROAD MINNA, NIGER STATE ","2019-05-16-112500.jpg","Normal","O","None","","1","0","0","41.190.14.68","2019-09-20 13:14:08","2019-09-20 13:14:21","","","","1","0000-00-00 00:00:00","2019-05-16 10:27:18","0000-00-00 00:00:00","","","GANA MOHAMMED","08065647982","HOUSE NO. BK9/40 BARKIN SALE AREA WAKILI ROAD MINNA, NIGER STATE ","BROTHER","1","GANA MOHAMMED","HOUSE NO. BK9/40 BARKIN SALE AREA WAKILI ROAD MINNA, NIGER STATE ","0","","0","0000-00-00 00:00:00","","16","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("433","0","1","0","0","1","11","1","1","11","0433","0","0","27","555","","MOHAMMED SALIHU EZHI","08034058123","","","","M","1","Nigerian","23","3","1970","married","","","","angoaliyu76@yahoo.com","","MOKWA","08034058123","","EMI TSWAYAN EZHI TAKUMA DISTRICT IN MOKWA LGA","","","Normal","B+","None","","1","0","0","105.112.114.140","2020-01-16 09:24:47","2020-01-16 09:25:15","","","","1","0000-00-00 00:00:00","2019-05-16 10:28:52","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0107","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("434","0","1","0","0","1","10","1","1","10","0434","0","0","27","553","","ABDULLAHI TAMBAYA","08069207468","","","","M","1","Nigerian","22","1","1968","married","","","","angoaliyu76@yahoo.com","","MARIGA","08069207468","","GARBA AUDIS STREET BOSSO MINNA","","","Normal","O","None","","1","0","0","197.210.84.253","2020-01-14 20:45:29","2020-01-14 20:46:02","","","","1","0000-00-00 00:00:00","2019-05-16 10:30:51","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0177","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("435","0","0","0","0","0","0","1","10","21","0435","0","0","18","328","","ABDULHAMEED KAMALUDDEEN","08136828255","","","","M","1","Nigerian","19","12","1979","married","","","","agambokama30@gmail.com","","GUMEL","08136828255","","EMIR ROAD, TANDA QRTRS GUMEL LGA","","","Normal","O","None","","1","0","0","197.210.45.142","2019-05-31 13:00:47","2019-05-31 13:01:44","","","","1","0000-00-00 00:00:00","2019-05-16 10:32:49","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("436","0","1","0","0","1","11","1","1","11","0436","0","0","27","544","","GARBA UMARU USMAN","08034531264","","","","M","1","Nigerian","4","11","1964","married","","","","kurfah@gmail.com","","CHANCHAGA","08034531264","","ZONE D 32 FARM CENTER TUNGA MINNA","","","Normal","O","None","","1","0","0","105.112.114.140","2020-01-16 09:25:36","2020-01-16 09:26:16","","","","1","0000-00-00 00:00:00","2019-05-16 10:34:27","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0032","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("437","0","1","0","0","9","6","1","2","2","0437","0","0","27","541","","MOHAMMED ISAH KAKAWUSA","08068586695","","","","M","1","Nigerian","1","1","1987","married","","","","isakakawusat@gmail.com","","BIDA","08068586695","","EMI ETSU GWARI BIDA","","","Normal","B+","None","","1","0","0","105.112.112.20","2020-01-28 16:35:31","2020-01-28 16:40:49","","","","1","0000-00-00 00:00:00","2019-05-16 10:35:41","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2019-12-13 10:24:21","0001","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("438","0","1","0","0","10","21","1","10","21","0438","0","0","27","544","","JOHN BLESSING","08065924162","","","","F","2","Nigerian","23","12","1989","single","","","","blessingjohn1989@gmail.com","","CHANCHAGA","08065924162","","PAIDA BEHIND EMIR PALACE","","","Normal","O","None","","1","0","0","197.210.45.38","2020-01-03 13:48:18","2020-01-03 13:48:57","","","","1","0000-00-00 00:00:00","2019-05-16 10:37:06","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0235","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("439","0","1","0","0","7","16","1","2","14","0439","0","0","27","548","","MUSTAPHA FATIMA","08160030992","","","","F","1","Nigerian","24","6","1989","married","","","","angoaliyu76@yahoo.com","","KATCHA","08160030992","","KPAKUNGU","","","Normal","A+","None","","1","0","0","105.112.112.20","2020-01-28 16:29:22","2020-01-28 16:29:34","","","","1","0000-00-00 00:00:00","2019-05-16 10:38:31","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-12-09 19:12:08","0673","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("440","0","1","0","0","2","14","1","2","14","0440","0","0","0","0","","UMAR MOHAMMED CHECHE","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07067875001","","","","","","","","","1","0","0","105.112.115.177","2020-01-16 13:18:54","2020-01-16 13:19:45","","","","1","0000-00-00 00:00:00","2019-05-16 10:39:21","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0271","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("441","0","1","0","0","2","14","1","2","14","0441","0","0","17","299","","EBERENDU ESTHER CHIDINMA","07066334548","","","","F","1","Nigerian","19","6","1995","single","","","","angoaliyu76@yahoo.com","","IHIHE UBOMA","07066334548","","OPPOSITE TOP MEDICAL HOSPITAL TUNGA MINNA","","","Normal","A+","None","","1","0","0","197.210.47.228","2020-01-02 20:50:12","2020-01-02 20:50:48","","","","1","0000-00-00 00:00:00","2019-05-16 10:40:32","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0103","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("442","0","1","0","0","10","21","1","10","21","0442","0","0","27","543","","USMAN SUWAIBA ","08172752331","","","","F","1","Nigerian","10","6","1970","married","","","","angoaliyu76@yahoo.com","","BOSSO","08172752331","","SW 491 KETEREN GWARI MINNA","","","Normal","O","None","","1","0","0","197.210.45.38","2020-01-03 13:52:10","2020-01-03 13:52:37","","","","1","0000-00-00 00:00:00","2019-05-16 10:41:28","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0168","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("443","0","1","0","0","4","4","1","4","4","0443","0","0","27","560","","BABAFADA AMINU MUHAMMAD","08105904781","","","","M","1","Nigerian","4","10","1988","married","","","","angoaliyu76@yahoo.com","","SHIRORO","08105904781","","ALONG MARKET ROAD KUTA","","","Normal","B+","None","","1","1","0","82.145.222.81","2019-09-19 13:59:41","2019-05-31 13:08:45","","","","1","0000-00-00 00:00:00","2019-05-16 10:42:41","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("444","0","1","0","0","10","21","1","10","21","0444","0","0","27","551","","TSADO MARTHA","07061913887","","","","F","2","Nigerian","7","9","1980","married","","","","angoaliyu76@yahoo.com","","LAVUN","07061913887","","GBEGANU BIDA ROAD MINNA","","","Normal","AB","None","","1","0","0","197.210.45.38","2020-01-03 14:54:15","2020-01-03 14:54:48","","","","1","0000-00-00 00:00:00","2019-05-16 10:43:37","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0210","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("445","0","1","0","0","4","12","1","4","12","0445","0","0","23","477","","IBRAHIM ROSELINE GBEKELE","07065532656","","","","F","2","Nigerian","19","3","1980","married","","","","temibelly@rocketmail.com","","IJUMU","07065532656","","32 FARM CENTER MINNA","","","Normal","O","None","","1","0","0","197.210.45.38","2020-01-03 14:26:26","2020-01-03 14:26:53","","","","1","0000-00-00 00:00:00","2019-05-16 10:45:17","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0262","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("446","0","1","0","0","7","16","1","7","16","0446","0","0","27","546","","YISA JUSTINA","08162119861","","","","F","2","Nigerian","1","12","1995","married","","","","angoaliyu76@yahoo.com","","GBAKO","08162119861","","ZUNGERU","","","Normal","O","None","","1","0","0","197.210.70.15","2020-02-04 17:35:02","2020-02-04 17:36:29","","","","1","0000-00-00 00:00:00","2019-05-16 10:46:15","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0213","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("447","0","1","0","0","9","18","1","9","18","0447","0","0","27","557","","ABUBAKAR DADA HADIZA","07037478186","","","2019-05-17-104503rrr.pdf.pdf","F","1","Nigerian","7","6","1982","married","","","","abubakarhadiza615@gmail.com","","ZARIYA","07037478186","","PAIKORO LOCAL GOVERNMENT AREA","","2019-05-16-130225.jpg","Normal","A+","None","","1","1","0","197.210.64.104","2020-02-14 22:29:33","2020-02-11 23:01:19","","","","1","0000-00-00 00:00:00","2019-05-16 10:46:46","0000-00-00 00:00:00","","","BELLO DANJUMA","","PAIKORO LOCAL GOVERNMENT AREA","HUSBAND","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-18 11:31:30","0566","2","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("448","0","1","0","0","7","5","1","7","5","0448","0","0","27","544","","HASSAN SADDAM","08065771081","","","","M","1","Nigerian","5","6","1996","married","","","","saddamhassan93@yahoo.com","","CHANCHAGA","08065771081","","ABDULSALAM QRTRS MINNA","","","Normal","B+","None","","1","0","0","197.210.57.87","2019-06-18 17:29:14","2019-06-18 17:31:51","","","","1","0000-00-00 00:00:00","2019-05-16 10:47:47","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0021","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("449","0","1","0","0","10","22","1","7","17","0449","0","0","27","541","","SAYUTI MUHAMMAD YAHAYA","07032063800","","","2019-05-16-120827yahaya.pdf.pdf","M","1","Nigerian","15","12","1991","single","","","","bellyamoh@gmail.com","","BIDA","07032063800","","HOUSE NO 8 GENERAL M A GARBA STREE GRA BIDA","HOUSE NO 8 GENERAL M A GARBA STREE GRA BIDA","2019-05-16-114839.jpg","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 13:33:45","2020-01-16 13:34:48","","","","1","0000-00-00 00:00:00","2019-05-16 10:50:02","0000-00-00 00:00:00","","","ALHAJI MUHAMMAD SAYUTI","PARENT","HOUSE NO 8 GENERAL M A GARBA STREE GRA BIDA","FATHER","4","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("450","0","1","0","0","4","12","1","4","12","0450","0","0","27","544","","Hassana Alhassan Umar","08035575220","","","2019-05-20-165955Alhassan 1.pdf.pdf","F","1","Nigerian","25","10","1985","married","","","","hassanaalhassan3@gmail.com","","Gwagwalada","08035575220","","Behind Diamond Bank Tunga Minna, Niger State ","Behind Diamond Bank Tunga Minna, Niger State ","2019-05-17-121930.jpg","Normal","O","None","Nil","1","1","0","197.210.85.62","2020-03-04 12:04:41","2020-01-03 10:47:01","","","","1","0000-00-00 00:00:00","2019-05-16 10:58:12","0000-00-00 00:00:00","","","Haruna Alhassan Muhammed","07061690700","Behind Diamond Bank Tunga Minna, Niger State ","Husband","1","Haruna Alhassan Muhammed","Behind Diamond Bank Tunga Minna, Niger State ","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0424","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("451","0","0","0","0","0","0","1","9","6","0451","0","0","27","548","","ABDULLAHI SANI BABA","07067537283","","","2019-05-16-165335credential.pdf.pdf","M","2","Nigerian","11","7","1994","married","","","","babdullahisani@gmail.com","","KAKAKPANGI","07067537283","","BEHIND ST. JOHN CHURCH, CHANCHAGA, MINNA, NIGER STATE","BEHIND ST. JOHN CHURCH, CHANCHAGA, MINNA, NIGER STATE","2019-05-16-170037.jpg","Normal","O","None","-","1","1","0","105.112.120.225","2019-09-23 08:51:54","2019-05-21 10:27:10","","","","1","0000-00-00 00:00:00","2019-05-16 11:11:34","0000-00-00 00:00:00","","","MR. MATTHEW TSADO","08035895392","DUTSEN KURA, MINNA, NIGER STATE","GUARDIAN","1","ABDULLAHI SANI BABA","DUTSEN KURA, MINNA, NIGER STATE","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("452","0","0","0","0","0","0","1","10","21","0452","0","0","27","546","","MOHAMMED USMAN","08109009836","","","2019-05-16-120732OI.pdf.pdf","M","1","Nigerian","1","1","1995","married","","","","mohammedusman900@yahoo.com","","minna","08109009836","","mallam usman malagi saiko minna ","mallam usman malagi saiko minna ","2019-05-16-112904.jpg","Normal","O","None","good health ","1","0","0","41.203.72.231","2019-05-23 16:23:36","2019-05-23 16:25:52","","","","1","0000-00-00 00:00:00","2019-05-16 11:14:57","0000-00-00 00:00:00","","","usman mammah ","08130670508","mallam usman malagi saiko minna ","father ","1","usman mammah","mallam usman malagi saiko minna ","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("453","0","0","0","0","0","0","1","4","12","0453","0","0","27","552","","LUKA KAMASHI MAGAJI","08168060634","","","2019-05-16-121356luka.pdf.pdf","M","2","Nigerian","14","7","1969","married","","","","kamashiluka@gmail.com","","KURA","08168060634","","FEDERAL COLLEGE OF EUCATION, PMB 39, KONTAGORA, NIGER STATE","KWANGWARA OPP. CATHOLIC CHURCH, KONTAGORA, NIGER STATE","2019-05-16-120319.jpg","Normal","O","None","NONE","1","1","0","185.243.12.59","2019-10-11 10:45:21","2019-09-23 15:40:40","","","","1","0000-00-00 00:00:00","2019-05-16 12:02:22","0000-00-00 00:00:00","","","EMMANUEL MAKOSHI","08036967352","NIGERIAN IMMIGRATION SERVICE, KONTAGORA, NIGER STATE","BROTHER","1","SELF","FEDERAL COLLEGE OF EUCATION, PMB 39, KONTAGORA, NIGER STATE","0","","0","0000-00-00 00:00:00","","20","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("454","0","0","0","0","0","0","1","2","14","0454","0","0","27","545","","Danjuma Mohammed Gonagi","07035514994","","","2019-05-16-130243Combined-1.pdf.pdf","M","1","Nigerian","17","8","1980","married","","","","mohammeddanjumagonagi@gmail.com","","Gonagi Edati LGA","07035514994","","Gonagi Edati LGA Niger State","Gonagi Edati LGA Niger State","2019-05-16-122541.jpg","Normal","AB","None","","1","1","0","129.205.113.58","2019-08-27 15:25:58","2019-05-17 12:42:32","","","","1","0000-00-00 00:00:00","2019-05-16 12:05:51","0000-00-00 00:00:00","","","Mallam Mayaki","07035514994","Gonagi Edati LGA Niger State","Father","1","","","0","","0","0000-00-00 00:00:00","","10","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("455","0","0","0","0","0","0","1","2","14","0455","0","0","27","542","","AHMED ISMAIL ANFANI","08034679105","","","2019-05-17-105952my credentials.pdf.pdf","M","1","Nigerian","27","6","1969","married","","","","itec.kainji@gmail.com","","Wawa","08034679105","","D7/D8 Bahago Plaza\\\\r\\\\nTunga\\\\r\\\\nMinna\\\\r\\\\nNiger State","Tudunwali Layout\\\\r\\\\nOff Kainji Road\\\\r\\\\nBehind MAN School\\\\r\\\\nNew Bussa\\\\r\\\\nNiger State","2019-05-17-122637.jpg","Normal","A+","None","","1","1","0","41.203.73.35","2019-11-09 17:16:15","2019-10-24 11:10:27","","","","1","0000-00-00 00:00:00","2019-05-16 12:08:19","0000-00-00 00:00:00","","","Dr. Isah Adamu","07039613418","Dr. Isah Adamu\\\\r\\\\nDepartment of Public Administration\\\\r\\\\nIBBU\\\\r\\\\nLapai\\\\r\\\\n","Brother","1","Self","Tudunwali Layout\\\\r\\\\nOff Kainji Road\\\\r\\\\nBehind MAN School\\\\r\\\\nNew Bussa\\\\r\\\\nNiger State","0","","0","0000-00-00 00:00:00","","24","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("456","0","0","0","0","0","0","1","1","11","0456","0","0","27","560","","MAGAJI DANLADI","08034594758","","","2019-05-16-132333CREDENTIAL.pdf.pdf","M","2","Nigerian","3","10","1993","single","","","","magajid080@gmail.com","","GWADA","08034594758","","BEHIND NUPE MOTOR, TUNGA, MINNA, NIGER STATE","BEHIND NUPE MOTOR, TUNGA, MINNA, NIGER STATE","2019-05-16-131314.jpg","Normal","O","None","-","1","0","0","105.112.122.112","2019-11-14 12:00:46","2019-11-14 12:03:58","","","","1","0000-00-00 00:00:00","2019-05-16 13:10:17","0000-00-00 00:00:00","","","MAGAJI DAVID","07062874499","BWARI, ABUJA, F.C.T","FATHER","1","MAGAJI DAVID","BWARI, ABUJA, F.C.T","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("457","0","1","0","0","9","18","1","9","18","0457","0","0","27","558","","ABDULMUTALLIB MUSA GUNNA","07033850705","","","2019-05-16-144028Graphic1.pdf.pdf","M","1","Nigerian","13","8","1990","married","","","","guna203060@gmail.com","","Gunna","07033850705","","Minna Niger State ","Minna niger state","2019-05-16-143611.jpg","Normal","O","None","","1","0","0","197.210.45.38","2020-01-03 13:55:14","2020-01-03 13:55:39","","","","1","0000-00-00 00:00:00","2019-05-16 13:41:15","0000-00-00 00:00:00","","","Musa","0703 385 0705","Niger State ","Father","4","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0245","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("458","0","0","0","0","0","0","1","1","11","0458","0","0","29","597","","ADETUYI AYOTUNDE SOLOMON","08099332252","","","","M","2","Nigerian","14","4","1987","married","","","","solad4real@yahoo.com","","Lagos","08099332252","","Behind trade fair, city gate, mInna,  Niger state","10, Emmanuel  daodu street , Araromi bus stop Iya na I pajamas Lagos state","","Normal","O","None","Nil","1","1","0","105.112.120.225","2019-09-23 08:52:21","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-05-16 14:00:08","0000-00-00 00:00:00","","","Mr Sam Adeyelure ","08055281037","10 Emmanuel daodu street, Araromi bus stop  Iya na ipaja","Father","1","Adetuyi Ayotunde ","Behind trade fair city gate minna","0","","0","0000-00-00 00:00:00","","8","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("459","0","0","0","0","0","0","1","1","1","0459","0","0","27","541","","YABAGI AMINU MUHAMMAD","08035890351","","","","M","1","Nigerian","19","3","1992","married","","","","aminuyabagi2019@gmail.com","","BIDA","08035890351","","HOUSE NO 43, BAY CLINIC ROAD, TUNGA, MINNA, NIGER STATE","HOUSE NO 43, BAY CLINIC ROAD, TUNGA, MINNA, NIGER STATE","","Normal","O","None","-","1","0","0","41.190.14.160","2019-11-23 12:14:51","2019-11-23 12:16:56","","","","0","0000-00-00 00:00:00","2019-05-16 15:09:38","0000-00-00 00:00:00","","","ALH. AHMAD NMA","08032856709","BEHIND INEC  OFFICE, OFF DAVID MARK ROAD, MINNA, NIGER STATE","GUARDIAN","1","YABAGI AMINU MUHAMMAD","HOUSE NO 43, BAY CLINIC ROAD, TUNGA, MINNA, NIGER STATE","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("460","0","0","0","0","0","0","1","1","1","0460","0","0","0","0","","JEPHTHAH DAVID","","","","","","0","","","","","","","","","jephthahdavid7@gmail.com","","","08144791966","","","","","","","","","1","1","0","105.112.112.236","2019-05-16 15:40:19","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-05-16 15:39:25","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("461","0","1","0","0","4","4","1","4","4","0461","0","0","0","0","","SADIYA ABDULKAREEM","","","","2019-05-16-164800SADIYA ABDULKAREEMMMMM_compressed.pdf.pdf","","0","","","","","","","","","sadiyaabdulkareem41@gmail.com","","","08075151701","","","","2019-05-16-161507.jpg","","","","","1","1","0","197.210.64.48","2019-05-16 16:06:19","0000-00-00 00:00:00","","","","1","0000-00-00 00:00:00","2019-05-16 16:01:46","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-08 14:33:32","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("462","0","0","0","0","0","0","1","4","13","0462","0","0","23","482","","MOHAMMED AUWAL YAHAYA","07055702268","","","2019-05-16-174803AUWAL M.pdf.pdf","M","1","Nigerian","19","3","1985","married","","","","yahamed019@gmail.com","","KADUNA","07055702268","","UNG. HAKIMI KUTA","ZC 19 ROCK ROAD TUDUN NUPAWA KADUNA","2019-05-16-172941.jpg","Normal","B+","None","","1","0","0","105.112.121.120","2019-10-27 15:34:01","2019-10-27 15:34:10","","","","1","0000-00-00 00:00:00","2019-05-16 16:16:41","0000-00-00 00:00:00","","","YAHAYA OJOGBANE","08169528148","ZC 19 ROCK ROAD TUDUN NUPAWA KADUNA","FATHER","4","MOHAMMED AUWAL YAHAYA","UNG. HAKIMI KUTA","0","","0","0000-00-00 00:00:00","","8","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("463","0","1","0","0","2","2","1","2","14","0463","0","0","27","539","","Aisha Abdulkadir","07037055454","","","2019-05-16-170210Aisha Pdf.pdf.pdf","F","1","Nigerian","29","2","1999","married","","","","littlemiil@yahoo.com","","Agaie","07037055454","","Barkin Sale, Minna Niger State","Barkin Sale, Minna Niger State","2019-05-16-165112.jpg","Normal","O","None","Nil","1","0","0","105.112.115.194","2020-01-29 08:45:51","2020-01-29 08:46:18","","","","1","0000-00-00 00:00:00","2019-05-16 16:42:33","0000-00-00 00:00:00","","","Abdulkadir Mohammed","08039719524","Barkin Sale, Minna Niger State","Father","1","Abdulkadir Mohammed","Barkin Sale, Minna Niger State","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0322","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("464","0","1","0","0","2","2","1","2","14","0464","0","0","27","539","","Nafisa Abdulkadir","07019271676","","","2019-05-16-171516convert-jpg-to-pdf.net_2019-05-16_18-14-54.pdf.pdf","F","1","Nigerian","25","5","1997","married","","","","adeoyesx@gmail.com","","Agaie","07019271676","","Minna, Niger State","Minna, Niger State","2019-05-16-170151.jpg","Normal","O","None","None","1","0","0","105.112.115.194","2020-01-29 08:46:38","2020-01-29 08:47:31","","","","1","0000-00-00 00:00:00","2019-05-16 16:57:44","0000-00-00 00:00:00","","","Abdulkadir Mohammed","08039719524","Minna, Niger State","Father","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0321","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("465","0","0","0","0","0","0","1","2","2","0465","0","0","0","0","","Danlami Gideon Zhami","","","","","","0","","","","","","","","","danlamijoel.jd@gmail.com","","","08062075721","","","","","","","","","1","0","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-05-16 17:23:30","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("466","0","0","0","0","0","0","1","10","20","0466","0","0","22","466","","IBRAHIM GARBA ","08061639399","","","2019-05-16-174027maersk.pdf.pdf","M","1","Nigerian","6","9","1975","married","","","","ibrahimgraba01.ig@gmail.com","","ADAMAWA","08061639399","","HQ TRADOC NIGERIA ARMY MINNA ","HQ TRADOC NIGERIA ARMY MINNA ","2019-05-16-172632.jpg","Normal","B+","None","GOOD HEALTH ","1","0","0","41.203.72.231","2019-05-23 16:26:01","2019-05-23 16:26:32","","","","0","0000-00-00 00:00:00","2019-05-16 17:25:53","0000-00-00 00:00:00","","","ASABE ISAH ","08101867179","WASAGU/DANKO KEBBI STATE ","SISTER ","1","IBRAHIM GARBA ","HQ TRADOC NIGERIA ARMY MINNA ","0","","0","0000-00-00 00:00:00","","22","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("467","0","0","0","0","0","0","1","2","2","0467","0","0","27","543","","Danlami Gideon Zhami","08062075721","","","2019-05-16-183827gidjg.pdf.pdf","M","2","Nigerian","12","9","1980","married","","","","danlamijoel.jd@gmail.com","","MINNA","08062075721","","LEA/ABUJA MUNICIPAL AREA COUNCIL FCT. WUSE ZONE 2","LEA/ABUJA MUNICIPAL AREA COUNCIL FCT. WUSE ZONE 2 ","2019-05-16-181400.jpg","Normal","O","None","NONE","1","0","0","105.112.121.43","2020-01-24 15:21:07","2020-01-24 15:23:54","","","","1","0000-00-00 00:00:00","2019-05-16 17:25:58","0000-00-00 00:00:00","","","DANLAMI ZHAMI","09036058655","CHANCHAGA MINNA NIGER STATE","FATHER","1","DANLAMI GIDEON ZHAMI","LEA/ABUJA MUNICIPAL AREA COUNCIL FCT. WUSE ZONE 2","0","","0","0000-00-00 00:00:00","","10","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("468","0","1","0","0","9","6","1","4","4","0468","0","0","27","550","","GARBA  AMINA AMINU","08109424576","","","2019-05-17-114227MUYE AMIN.pdf.pdf","F","1","Nigerian","2","3","1997","married","","","","aminaaminu111@gmail.com","","Minna","08109424576","","338a  peter sarki road,talba crescent  tunga minna","338a  peter sarki road,talba crescent  tunga minna","2019-05-16-182829.jpg","Normal","O","None","NIL","1","0","0","105.112.122.165","2020-02-03 19:31:16","2020-02-03 19:32:31","","","","1","0000-00-00 00:00:00","2019-05-16 18:10:56","0000-00-00 00:00:00","","","AHMADU SAIDU MUYE ","08067186170","338a  peter sarki road,talba crescent  tunga minna","HUSBAND","1","AHMADU SAIDU MUYE","338a  peter sarki road,talba crescent  tunga minna","1","                                
\n                                                                 
\n                                ","3","2019-11-08 10:36:16","0647","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("469","0","1","0","0","4","13","1","4","13","0469","0","0","27","549","","Danlami Ibrahim ","07033414541","","","2019-05-16-224401Credentials.pdf.pdf","M","1","Nigerian","15","8","1985","married","","","","mustaphaibrahimdanladi403@gmail.com","","Kontagora","07033414541","","No 1 Mustapha Babangida road, Opposite Sch. of Midwifery  Off Bay Clinic road.
\nTunga, Minna","","2019-05-16-222920.jpg","Normal","B+","None","Mentality and physically fit","1","0","0","197.210.64.132","2020-01-02 20:47:02","2020-01-02 20:47:46","","","","1","0000-00-00 00:00:00","2019-05-16 22:24:47","0000-00-00 00:00:00","","","","","","","1","Danlami Ibrahim","Niger State Ministry of Investment,Commerce and Cooperative, 
\nAbdulkareem Lafene Secretariat Minna","1","                                
\n                                                                 
\n                                ","3","2019-11-15 09:16:05","0535","10","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("470","0","1","0","0","1","11","1","1","11","0470","0","0","15","276","","Shuaibu O. Salamatu","07033555519","","","2019-05-17-104340Doc1.pdf.pdf","F","1","Nigerian","31","12","1980","married","","","","salamatshuaib05@gmail.com","","FCT","07033555519","","No.9 Adegbarga Adeyemi Street Hajji Camp Gwagwalada Abuja","No.9 Adegbarga Adeyemi Street Hajji Camp Gwagwalada Abuja","2019-05-17-092226.jpg","Normal","O","None","","1","0","0","197.210.85.77","2020-02-08 15:44:57","2020-02-08 15:49:50","","","","1","0000-00-00 00:00:00","2019-05-17 08:56:43","0000-00-00 00:00:00","","","Dr. Usman Naji Gimba","07057204446","Biological Sciences Department, Ibrahim Badamasi Babangida University Lapai Niger State
\n
\n","Guardian ","4","","","1","                                
\n                                                                 
\n                                ","3","2019-11-03 08:06:50","0604","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("471","0","1","0","0","2","2","1","2","14","0471","0","0","27","543","","ZAKARI JIBRIL YAU","08135332353","","","","M","1","Nigerian","1","1","1996","single","","","","jibrilzakariyya492@gmail.com","","bosso","08135332353","","ADAMU LAKA STREET BOSSO","","","Normal","O","None","","1","1","0","105.112.117.167","2020-01-09 16:29:05","2019-05-31 14:44:49","","","","1","0000-00-00 00:00:00","2019-05-17 09:03:39","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2020-01-09 16:27:01","0030","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("472","0","1","0","0","10","21","1","1","10","0472","0","0","27","543","","MUSA YAHAYA MUAZU DOMA","07035973639","","","","M","1","Nigerian","4","7","1980","married","","","","yahayam.dmusa@yahoo.com","","BOSSO","07035973639","","NO. 28 M.D MUSA RESIDENCE VIA TALBA FARM MINNA","","","Normal","O","None","","1","1","0","41.190.14.22","2019-11-19 12:00:27","2019-05-31 14:50:05","","","","1","0000-00-00 00:00:00","2019-05-17 09:05:35","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-15 09:36:51","0575","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("473","0","1","0","0","2","15","1","2","15","0473","0","0","27","558","","DAHIRU ABUBAKAR KAKURI","08038157777","","","","M","1","Nigerian","15","1","1983","married","","","","angoaliyu76@yahoo.com","","RAFI","08038157777","","RAFI KAGARA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 13:00:30","2020-01-16 13:00:40","","","","1","0000-00-00 00:00:00","2019-05-17 09:06:44","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","0000-00-00 00:00:00","0315","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("474","0","0","0","0","0","0","1","4","12","0474","0","0","27","558","","USMAN MOHAMMED","08162667243","","","","M","1","Nigerian","28","2","1980","married","","","","angoaliyu76@yahoo.com","","RAFI","08162667243","","SABON GARI KAGARA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 11:34:14","2020-01-16 11:34:20","","","","1","0000-00-00 00:00:00","2019-05-17 09:07:42","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("475","0","1","0","0","9","6","1","9","6","0475","0","0","27","557","","MOHAMMED SHITTU ALIYU","08109708665","","","","M","1","Nigerian","1","6","1990","single","","","","ubandomajnr@gmail.com","","PAIKORO","08109708665","","BEHIND MAGISTRATE COURT PAIKO","","","Normal","O","None","","1","0","0","105.112.117.57","2020-02-06 13:56:02","2020-02-06 14:47:47","","","","1","0000-00-00 00:00:00","2019-05-17 09:08:40","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0445","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("476","0","1","0","0","2","2","1","2","2","0476","0","0","27","541","","KATUN MUSA GARBA","07065917535","","","","M","1","Nigerian","14","2","1985","married","","","","katunmusagarba@gmail.com","","BIDA","07065917535","","S.W 266 ALH. GARBA HOUSE ALH. NDAISAH TIPPER AREA, ","","","Normal","A+","None","","1","0","0","197.210.65.66","2020-01-02 21:42:24","2020-01-02 21:43:04","","","","1","0000-00-00 00:00:00","2019-05-17 09:10:08","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0187","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("477","0","0","0","0","0","0","1","7","16","0477","0","0","23","486","","RICHEAL AMODU","08069190687","","","","F","2","Nigerian","28","6","1980","married","","","","angoaliyu76@yahoo.com","","OLAMABURAU","08069190687","","MR. AMODU FROM GWAGWALADA FCT ABUJA","","","Normal","O","None","","1","0","0","197.210.52.68","2019-05-31 14:53:48","2019-05-31 14:55:53","","","","1","0000-00-00 00:00:00","2019-05-17 09:11:00","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("478","0","1","0","0","10","20","1","10","20","0478","0","0","27","555","","FATIMA MOHAMMED","09065124743","","","","F","1","Nigerian","9","3","1999","single","","","","angoaliyu76@yahoo.com","","MOKWA","09065124743","","EMI ALH. MUHAMMAD YANDA GRA BIDA","","","Normal","O","None","","1","0","0","197.210.47.162","2020-01-02 23:13:30","2020-01-02 23:14:09","","","","1","0000-00-00 00:00:00","2019-05-17 09:11:54","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0088","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("479","0","0","0","0","0","0","1","1","11","0479","0","0","27","555","","YAHAYA BOLOGI ABUBAKAR","08065560680","","","","M","1","Nigerian","3","11","1973","married","","","","angoaliyu76@yahoo.com","","MOKWA","08065560680","","OPPOSITE FILLING STATION POLY ROAD BIDA BY BANBARA JUNCTION","","","Normal","O","None","","1","0","0","197.210.53.133","2019-05-31 14:57:09","2019-05-31 14:57:54","","","","1","0000-00-00 00:00:00","2019-05-17 09:13:08","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("480","0","1","0","0","10","22","1","10","22","0480","0","0","27","551","","SOLOMON YISA","08032896471","","","","M","2","Nigerian","20","1","1978","married","","","","syisa182@gmail.com","","LAVUN","08032896471","","OPPOSITE ST JOHN BUS STOP TUNGAN GORO CHANCHAGA MINNA","","","Normal","O","None","","1","1","0","197.210.47.155","2020-03-22 21:30:33","2020-02-17 16:07:22","","","","1","0000-00-00 00:00:00","2019-05-17 09:14:15","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0191","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("481","0","1","0","0","2","15","1","2","15","0481","0","0","27","560","","IBRAHIM BELLO UBA KUTA","07065555709","","","","M","1","Nigerian","29","3","1971","married","","","","ibrahimbellokuta@gmail.com","","SHIRORO","07065555709","","NEW GRA BESIDE HILLTOP MODEL SCHOOL GBADNAYI MAITUMBI MINNA","","","Normal","B+","None","","1","0","0","197.210.60.119","2020-01-03 11:13:04","2020-01-03 11:13:41","","","","1","0000-00-00 00:00:00","2019-05-17 09:15:39","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0080","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("482","0","1","0","0","4","4","1","4","12","0482","0","0","27","551","","MAMMAN CHADO HUSSAINA","07032246635","","","","F","1","Nigerian","17","3","1991","married","","","","angoaliyu76@yahoo.com","","LAVUN","07032246635","","MANFU NDAKODINA DOKO, LAVUN LGA","","","Normal","O","None","","1","0","0","197.210.85.77","2020-02-08 15:40:13","2020-02-08 15:41:30","","","","1","0000-00-00 00:00:00","2019-05-17 09:17:23","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0403","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("483","0","1","0","0","4","4","1","4","4","0483","0","0","27","557","","FARUK FATIMA ABDULLAHI","08188918549","","","","F","1","Nigerian","2","6","1992","married","","","","fatimafaruk93@gmail.com","","PAIKORO","08188918549","","TUNGA MINNA","","","Normal","B+","None","","1","0","0","197.210.45.38","2020-01-03 14:27:08","2020-01-03 14:27:38","","","","1","0000-00-00 00:00:00","2019-05-17 09:18:38","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0248","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("484","0","1","0","0","4","4","1","4","4","0484","0","0","13","253","","KOMOLAFE OLUWAGBEMIGA TOSIN ","08100162533","","","","M","2","Nigerian","27","12","1993","single","","","","angoaliyu76@yahoo.com","","IKOLA","08100162533","","BOSSO ESTATE, ROAD 3 MINNA","","","Normal","O","None","","1","1","0","41.190.14.154","2020-01-31 14:02:05","2020-01-15 12:29:50","","","","1","0000-00-00 00:00:00","2019-05-17 09:20:27","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0174","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("485","0","1","0","0","4","12","1","4","12","0485","0","0","27","544","","TANIMU NDATSU","08054352893","","","","M","1","Nigerian","20","9","1977","married","","","","tanimu1977@gmail.com","","CHANCHAGA","08054352893","","SE 17 KUTA ROAD MINNA","","","Normal","O","None","","1","0","0","197.210.85.22","2020-01-02 15:50:46","2020-01-02 15:51:26","","","","1","0000-00-00 00:00:00","2019-05-17 09:21:58","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0150","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("486","0","1","0","0","10","22","1","2","15","0486","0","0","22","466","","UMAR ALIYU KANYA","09069710390","","","","M","1","Nigerian","3","6","1975","married","","","","angoaliyu76@yahoo.com","","DANKO","09069710390","","ALH. BOJO HOUSE NO. 3 GRA KANYA DANKO WASAGU ","","","Normal","O","None","","1","0","0","105.112.112.232","2019-11-22 12:14:12","2019-11-22 15:47:53","","","","1","0000-00-00 00:00:00","2019-05-17 09:23:08","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                                                 
\n                                ","3","2019-11-22 12:13:19","0597","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("487","0","0","0","0","0","0","1","7","5","0487","0","0","8","146","","ABDULRAHIM ABDULLAHI","07063282165","","","","M","1","Nigerian","10","11","1993","married","","","","angoaliyu76@yahoo.com","","BIU","07063282165","","ALH. ABDULLAHI HOUSE NO. 21 CHAZA SULEJA","","","Normal","O","None","","1","1","0","197.210.53.74","2019-11-28 18:32:19","2019-05-31 15:09:24","","","","1","0000-00-00 00:00:00","2019-05-17 09:24:14","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("488","0","0","0","0","0","0","1","10","20","0488","0","0","23","761","","YUNUSA  ISAH EDUME","08064926890","","","","M","1","Nigerian","30","11","1986","married","","","","angoaliyu76@yahoo.com","","ANKPA","08064926890","","DEPARTMENT OF STATE SECURITY SERVICE MINNA","","","Normal","B+","None","","1","0","0","197.210.53.133","2019-05-31 15:09:50","2019-05-31 15:11:25","","","","1","0000-00-00 00:00:00","2019-05-17 09:25:30","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("489","0","0","0","0","0","0","1","4","13","0489","0","0","27","552","","BULUS ADAMU SALKA","08064043232","","","","M","2","Nigerian","14","8","1977","married","","","","adamubulussalka@gmail.com","","MAGAMA","08064043232","","BEHIND PRIMARY SCHOOL SAUKA KA HUTA MINNA","","","Normal","O","None","","1","0","0","197.210.53.133","2019-05-31 15:11:40","2019-05-31 15:13:40","","","","1","0000-00-00 00:00:00","2019-05-17 09:29:38","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("490","0","1","0","0","2","14","1","2","14","0490","0","0","27","560","","ADAMU SULEIMAN GARBA","08066556816","","","","M","1","Nigerian","14","1","1971","married","","","","angoaliyu76@yahoo.com","","SHIRORO","08066556816","","LONDON STREET AREA 2, BAJAAGO CHANCHAG","","","Normal","A+","None","","1","0","0","105.112.115.177","2020-01-16 13:24:07","2020-01-16 13:24:44","","","","1","0000-00-00 00:00:00","2019-05-17 09:31:02","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0042","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("491","0","0","0","0","0","0","1","7","16","0491","0","0","27","555","","SUMAYYATU BINTU IDRIS ","08143807596","","","","F","1","Nigerian","25","2","1995","single","","","","sumayyabintuidris@gmail.com","","MOKWA","08143807596","","TAKOWANGWA EMI KPATAKI MOKWA","","","Normal","O","None","","1","0","0","105.112.112.77","2019-12-14 12:59:00","2019-12-14 12:59:33","","","","1","0000-00-00 00:00:00","2019-05-17 09:33:00","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("492","0","1","0","0","1","11","1","1","11","0492","0","0","7","124","","AUTA YUSUF BAKO","08051567868","","","","M","2","Nigerian","26","7","1985","single","","","","talktoauta1@gmail.com","","GUMA","08051567868","","SHIRORO DAM SITE ","","","Normal","A+","None","","1","0","0","105.112.114.140","2020-01-16 09:38:06","2020-01-16 09:38:41","","","","1","0000-00-00 00:00:00","2019-05-17 09:34:18","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0217","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("493","0","0","0","0","0","0","1","4","13","0493","0","0","28","582","","AWOTUBA SARAH OLUWAKEMI","08069643793","","","","F","2","Nigerian","24","4","1987","married","","","","kemisarah394@gmail.com","","REMO","08069643793","","BEHIND NNPC MEGA FILLING STATION ALONG HIMMA SCHOOL","","","Normal","A+","None","","1","0","0","197.210.53.68","2019-05-31 15:19:55","2019-05-31 15:20:34","","","","1","0000-00-00 00:00:00","2019-05-17 09:36:51","0000-00-00 00:00:00","","","","","A","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("494","0","0","0","0","0","0","1","1","10","0494","0","0","27","544","","YUSUF IBRAHIM","08076726262","","","","M","1","Nigerian","1","8","1998","single","","","","yusufibrahim1440@gmail.com","","CHANCHAGA","08076726262","","HOUSE L9 MALAM MAKARANTA ROAD MINNA","","","Normal","A+","None","","1","1","0","105.112.120.200","2019-12-13 11:31:34","2019-05-31 15:21:38","","","","1","0000-00-00 00:00:00","2019-05-17 09:38:01","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("495","0","1","0","0","2","15","1","2","15","0495","0","0","27","546","","AUDU ALHASSAN","07036875441","","","","M","1","Nigerian","31","12","1968","married","","","","angoaliyu76@yahoo.com","","GBAKO","07036875441","","EMI GIWA VIA LEMU IN GBAKO LGA","","","Normal","O","None","","1","0","0","197.210.60.119","2020-01-03 11:21:50","2020-01-03 11:22:28","","","","1","0000-00-00 00:00:00","2019-05-17 09:39:00","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0440","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("496","0","0","0","0","0","0","1","4","12","0496","0","0","27","541","","IBRAHIM IBRAHIM ALHAJI","08036432656","","","","M","1","Nigerian","13","9","1992","single","","","","alhajii513@gmail.com","","BIDA","08036432656","","UP HILL DAVID MARK ROAD OPP IBB MINNA","","","Normal","B+","None","","1","0","0","197.210.53.68","2019-05-31 15:22:57","2019-05-31 15:23:40","","","","1","0000-00-00 00:00:00","2019-05-17 09:40:06","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("497","0","1","0","0","2","15","1","2","15","0497","0","0","27","560","","USMAN ZAKARI KUTA","08065357313","","","","M","1","Nigerian","7","8","1977","single","","","","angoaliyu76@yahoo.com","","SHIRORO","08065357313","","SABON GARI SHIRORO LGA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 12:58:25","2020-01-16 12:58:36","","","","1","0000-00-00 00:00:00","2019-05-17 09:40:57","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0240","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("498","0","1","0","0","1","11","1","1","11","0498","0","0","27","562","","MUSA BEATRICE","08055434820","","","","F","2","Nigerian","2","10","1980","married","","","","angoaliyu76@yahoo.com","","TAFA","08055434820","","ZONE D FARM CENTRE TUNGA MINNA","","","Normal","O","None","","1","0","0","197.210.53.68","2019-05-31 15:25:06","2019-05-31 15:25:50","","","","1","0000-00-00 00:00:00","2019-05-17 09:41:50","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-03 08:21:03","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("499","0","1","0","0","1","10","1","1","10","0499","0","0","27","543","","IBRAHIM AMINA LOLO","08035981281","","","","M","1","Nigerian","6","1","1979","married","","","","angoaliyu76@yahoo.com","","BOSSO","08035981281","","BOSSO AREA COURT MINNA","","2019-11-18-160513.jpg","Normal","O","None","","1","0","0","197.210.227.98","2020-02-07 17:48:30","2020-02-07 17:49:51","","","","1","0000-00-00 00:00:00","2019-05-17 09:42:42","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-12 16:11:40","0550","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("500","0","0","0","0","0","0","1","2","15","0500","0","0","27","558","","DANTANI UMAR KUSHERKI","07060438364","","","","M","1","Nigerian","15","5","1985","married","","","","dantaniumarkusherki85@gmail.com","","RAFI","07060438364","","UNGUWAN NASARAWA KAGARA OPPOSITE QUEST INN","","","Normal","O","None","","1","0","0","197.210.53.172","2019-05-31 15:28:00","2019-05-31 15:28:52","","","","1","0000-00-00 00:00:00","2019-05-17 09:44:13","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("501","0","1","0","0","10","20","1","2","2","0501","0","0","27","541","","MUSA HAJARA MAMA","08038542187","","","","F","1","Nigerian","1","1","1989","married","","","","angoaliyu76@yahoo.com","","BIDA","08038542187","","NO D1 81 FLAYOUT MINNA","","","Normal","O","None","","1","0","0","105.112.114.211","2019-11-04 15:50:37","2019-11-06 17:10:12","","","","1","0000-00-00 00:00:00","2019-05-17 09:45:11","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-04 15:50:06","0435","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("502","0","1","0","0","4","13","1","4","13","0502","0","0","27","541","","LADIDI MOHAMMED","07062565245","","","","F","1","Nigerian","3","1","1980","married","","","","mohammedladidi80@gmail.com","","BIDA","07062565245","","NO D1 81 FLAYOUT MINNA","","","Normal","A+","None","","1","0","0","197.210.60.119","2020-01-03 10:44:11","2020-01-03 10:45:16","","","","1","0000-00-00 00:00:00","2019-05-17 09:46:52","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0205","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("503","0","0","0","0","0","0","1","4","12","0503","0","0","27","540","","ESTHER ISHAKU SHESKEN","08052310292","","","2019-05-17-100148esther1.pdf.pdf","F","2","Nigerian","15","5","1967","married","","","","estherishakushesken@gmail.com","","AGWARA","08052310292","","AGWARA LOCAL GOVERNMENT COUNCIL, AGWARA, NIGER STATE","UNGUWAN MISSION, ALONG MAGO ROAD, AGWARA, NIGER STATE","2019-05-17-094811.jpg","Normal","O","None","NONE","1","0","0","197.210.47.84","2019-05-17 09:47:32","2019-05-17 10:11:33","","","","1","0000-00-00 00:00:00","2019-05-17 09:47:12","0000-00-00 00:00:00","","","ISHAKU SHESKEN","08070453676","AGWARA LOCAL GOVERNMENT EDUCATION AUTHORITY, AGWARA, NIGER STATE","HUSBAND","2","AGWARA LOCAL GOVERNMENT COUNCIL","AGWARA LOCAL GOVERNMENT COUNCIL, AGWARA, NIGER STATE","0","","0","0000-00-00 00:00:00","","28","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("504","0","1","0","0","2","15","1","2","15","0504","0","0","27","559","","IBRAHIM RABI","07086840019","","","","F","1","Nigerian","11","3","1970","married","","","","angoaliyu76@yahoo.com","","RIJAU","07086840019","","CLOSE TO MYPA COLLEGE, DUTSEN KURA GWARI","","","Normal","O","None","","1","0","0","105.112.113.115","2019-10-31 11:01:45","2019-10-31 11:09:06","","","","1","0000-00-00 00:00:00","2019-05-17 09:47:46","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0391","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("505","0","0","0","0","0","0","1","10","21","0505","0","0","27","552","","BAWA MAGDALENE","08063887868","","","","M","2","Nigerian","21","5","1986","married","","","","angoaliyu76@yahoo.com","","MAGAMA","08063887868","","TUDUN WADA MAJINGA SALKA VIA KONTAGORA","","","Normal","O","None","","1","0","0","197.210.53.56","2019-05-31 15:36:04","2019-05-31 15:37:08","","","","1","0000-00-00 00:00:00","2019-05-17 09:48:37","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("506","0","1","0","0","1","10","1","1","10","0506","0","0","27","541","","NDAGI ALHASSAN NDA\'ABA","08069114019","","","","M","1","Nigerian","20","2","1976","married","","","","angoaliyu76@yahoo.com","","BIDA","08069114019","","NO. 7 BEHIND AL AMEEN BAKERY TAYI MINNA","","","Normal","B+","None","","1","0","0","41.190.12.205","2019-10-12 16:14:56","2019-10-12 16:16:27","","","","1","0000-00-00 00:00:00","2019-05-17 09:50:04","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0289","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("507","0","1","0","0","9","18","1","9","18","0507","0","0","27","539","","UMAR HAUWA SHEHU","08141312448","","","","F","1","Nigerian","18","10","1994","married","","","","umarhauwa1994@gmail.com","","AGAIE","08141312448","","SOJA A GIDAN ALH. VOLVO KPAKUNGU","","","Normal","B+","None","","1","0","0","197.210.84.122","2020-01-28 16:41:18","2020-01-28 16:41:40","","","","1","0000-00-00 00:00:00","2019-05-17 09:51:38","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2020-01-04 15:27:00","0022","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("508","0","0","0","0","0","0","1","1","10","0508","0","0","27","543","","USMAN AUDU","08050835981","","","","M","1","Nigerian","2","4","1976","married","","","","angoaliyu76@yahoo.com","","BOSSO","08050835981","","OFF GURARA JUNCTION BIDA ROAD MINNA","","","Normal","O","None","","1","0","0","197.210.53.157","2019-05-31 15:41:15","2019-05-31 15:42:25","","","","1","0000-00-00 00:00:00","2019-05-17 09:52:35","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("509","0","1","0","0","2","15","1","2","15","0509","0","0","22","456","","TANKO MONICA","08032593015","","","","F","2","Nigerian","11","1","1988","single","","","","angoaliyu76@yahoo.com","","FAKAI","08032593015","","FARM CENTRE ZONE","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 13:12:34","2020-01-16 13:13:06","","","","1","0000-00-00 00:00:00","2019-05-17 09:53:49","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0554","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("510","0","1","0","0","4","12","1","4","12","0510","0","0","27","543","","AMINU YUSUF","08169048682","","","","M","1","Nigerian","14","1","1996","single","","","","angoaliyu76@yahoo.com","","BOSSO","08169048682","","BCC SABON CHURCH ALONG BIDA ROAD MAIZUBE FARM","","","Normal","A+","None","","1","1","0","41.190.14.47","2019-09-20 16:05:17","2019-05-31 15:45:41","","","","1","0000-00-00 00:00:00","2019-05-17 09:54:58","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0025","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("511","0","0","0","0","0","0","1","2","14","0511","0","0","27","544","","AISHA UMAR","08030867197","","","","F","1","Nigerian","16","7","1990","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08030867197","","LONDON STREET SPRING DRIVE AREA II","","","Normal","B+","None","","1","0","0","197.210.53.179","2019-05-31 15:46:00","2019-05-31 15:46:47","","","","1","0000-00-00 00:00:00","2019-05-17 09:56:23","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("512","0","1","0","0","4","4","1","4","4","0512","0","0","27","544","","BAHAGO ELISHA","07032823581","","","","M","2","Nigerian","4","4","1992","single","","","","angoaliyu76@yahoo.com","","CHANCHAGA","07032823581","","OPPOSITE SHIRORO HOTEL MINNA","","","Normal","A+","None","","1","0","0","197.210.45.38","2020-01-03 14:24:13","2020-01-03 14:24:46","","","","1","0000-00-00 00:00:00","2019-05-17 09:57:27","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0049","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("513","0","1","0","0","1","11","1","1","11","0513","0","0","27","541","","USMAN ABUBAKAR BALA","08034586373","","","","M","1","Nigerian","10","9","1975","married","","","","balausman09@gmail.com","","BIDA","08034586373","","EMI ALHAJI USMAN BEHIND AP FILLING STATION TAKO JUMAA BIDA","","","Normal","B+","None","","1","0","0","105.112.114.140","2020-01-16 09:37:03","2020-01-16 09:37:22","","","","1","0000-00-00 00:00:00","2019-05-17 09:58:33","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0170","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("514","0","0","0","0","0","0","1","4","12","0514","0","0","27","544","","USMAN ABDULLAHI DANJUMA","08068024542","","","","M","1","Nigerian","2","2","1983","married","","","","el.uthman47@gmail.com","","CHANCHAGA","08068024542","","HOUSE NO 405 TALBA ESTATE MINNA","","","Normal","O","None","","1","0","0","197.210.52.12","2019-05-31 15:48:28","2019-05-31 15:49:14","","","","1","0000-00-00 00:00:00","2019-05-17 09:59:48","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("515","0","1","0","0","2","14","1","2","14","0515","0","0","27","542","","ALHASSAN SULEIMAN","07051868908","","","","M","1","Nigerian","24","4","1974","married","","","","angoaliyu76@yahoo.com","","BORGU","07051868908","","HOUSE NO. 171 KITORO ROAD NEW BUSSA","","","Normal","AB","None","","1","0","0","197.210.60.119","2020-01-03 11:17:44","2020-01-03 11:18:25","","","","1","0000-00-00 00:00:00","2019-05-17 10:01:09","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0427","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("516","0","0","0","0","0","0","1","9","18","0516","0","0","27","541","","ABDULLAHI AISHA BAGUDU","08136654420","","","","F","1","Nigerian","9","5","1988","married","","","","eeshaabdullah88@gmail.com","","BIDA","08136654420","","NTD 82 OPP. MAJE MARKET PAIKO ROAD TUNGA MINNA","","","Normal","A+","None","","1","0","0","197.210.53.61","2019-05-31 15:50:12","2019-05-31 15:51:50","","","","1","0000-00-00 00:00:00","2019-05-17 10:02:31","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("517","0","1","0","0","9","18","1","2","14","0517","0","0","27","547","","GALADIMA A. SAMIRAH","07052777122","","","","F","1","Nigerian","26","5","1990","single","","","","nil@gmail.com","","Minna","07052777122","","Eastern Bypass Gbayko Minna Niger State","Eastern Bypass Gbayko Minna Niger State","2019-05-17-114254.jpg","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 14:44:25","2020-01-16 14:48:11","","","","1","0000-00-00 00:00:00","2019-05-17 10:22:18","0000-00-00 00:00:00","","","Mr. Galadima","","Eastern Bypass Gbayko Minna Niger State","Father","1","Mal. Galadima","Eastern Bypass Gbayko Minna Niger State","1","                                
\n                                                                 
\n                                ","3","2019-11-19 13:55:57","0577","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("518","0","1","0","0","9","18","1","4","12","0518","0","0","27","550","","Umar Mohammed","08063216292","","","2019-05-20-165556Umar1.pdf.pdf","M","1","Nigerian","5","4","1988","married","","","","umarmb2017@yahoo.com","","Abugi jankara","08063216292","","Chanchaga Aladey junction minna niger state","Chanchaga Aladey junction minna niger state","2019-05-17-121758.jpg","Normal","O","None","","1","1","0","105.112.112.225","2019-11-09 18:21:32","2019-11-09 18:16:33","","","","1","0000-00-00 00:00:00","2019-05-17 10:28:51","0000-00-00 00:00:00","","","Umar ","08063216292","Chanchaga Aladey junction minna niger state","father","1","Umar Mohammed","Chanchaga Aladey junction minna niger state","1","                                
\n                                                                 
\n                                ","3","2019-11-08 11:36:40","0463","2","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("519","0","1","0","0","10","21","1","10","21","0519","0","0","27","549","","ABBAS ABBA JIBRIN","08132304666","","","2019-05-17-114339convert-jpg-to-pdf.net_2019-05-17_12-42-49.pdf.pdf","M","1","Nigerian","2","1","1996","single","","","","abbajaaay@gmail.com","","KONTAGORA","08132304666","","UNGWAN GALADIMA KONTAGORA, NIGER STATE","UNGWAN GALADIMA KONTAGORA, NIGER STATE","2019-05-17-120714.jpg","Normal","B+","None","NIL","1","1","0","197.210.53.251","2020-03-19 13:40:12","2020-02-24 17:46:05","","","","1","0000-00-00 00:00:00","2019-05-17 10:29:24","0000-00-00 00:00:00","","","ALHAJI JIBRIN TANKO ABDULLAHI","08032873525","UNGWAN GALADIMA KONTAGORA, NIGER STATE","FATHER","1","ALHAJI JIBRIN TANKO ABDULLAHI","UNGWAN GALADIMA KONTAGORA, NIGER STATE","1","                                
\n                                                                
\n                                                                
\n                                                                
\n                                                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                                                 
\n                                                                 
\n                                                                 
\n                                                                 
\n                                ","3","2020-03-19 13:50:57","0564","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("520","0","1","0","0","10","21","1","2","14","0520","0","0","27","549","","ZEENATU SAIDU NAMASKA","09065504555","","","2019-05-17-105139ZEENATU.pdf.pdf","F","1","Nigerian","15","6","1992","married","","","","zeenatnamaska@gmail.com","","KONTAGORA","09065504555","","EMIRS PALACE, KONTAGORA, NIGER STATE","EMIRS PALACE, KONTAGORA, NIGER STATE","2019-05-17-104026.jpg","Normal","O","None","NONE","1","0","0","105.112.115.177","2020-01-16 14:14:50","2020-01-16 14:15:00","","","","1","0000-00-00 00:00:00","2019-05-17 10:38:05","0000-00-00 00:00:00","","","HARUNA SALE","08037736405","EMIRS PALACE, KONTAGORA, NIGER STATE","BROTHER","1","PARENTS","EMIRS PALACE, KONTAGORA, NIGER STATE","1","                                
\n                                                                 
\n                                ","3","2019-10-31 16:20:25","0512","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("521","0","1","0","0","4","4","1","4","4","0521","0","0","27","550","","MOHAMMED SAIDU SALISU","08038940393","","","2019-05-17-112838SALISU PDF.pdf.pdf","M","1","Nigerian","17","11","1985","married","","","","ibrahimmuyesaeed2@gmail.com","","MUYE","08038940393","","338A PETER SARKI ROAD, TALBA CRESCENT TUNGA MINNA","338A PETER SARKI ROAD, TALBA CRESCENT TUNGA MINNA","2019-05-17-111708.jpg","Normal","O","None","NIL","1","0","0","197.210.85.22","2020-01-02 15:47:08","2020-01-02 15:47:46","","","","1","0000-00-00 00:00:00","2019-05-17 11:03:06","0000-00-00 00:00:00","","","ALH. SAIDU ADAMU","08050709938","338A PETER SARKI ROAD TALBA CRESCENT TUNGA MINNA","FATHER","1","MOHAMMED SAIDU","338A PETER SARKI ROAD TALBA CRESCENT TUNGA MINNA","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0175","3","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("522","0","1","0","0","1","1","1","1","1","0522","0","0","27","550","","Shuaib Sidi Umar","07030565665","","","2019-05-17-174859New Doc 2019-05-17 17.44.54.pdf.pdf","M","1","Nigerian","6","7","1999","married","","","","ushuaibsidi@gmail.com","","Lapai","07030565665","","NO 1 AHMADU BELLO WAY LAPAI NIGER STATE ","NO 1 AHMADU BELLO WAY LAPAI NIGER STATE","2019-05-17-173715.jpg","Normal","O","None","","1","0","0","197.210.84.253","2020-01-14 20:43:20","2020-01-14 20:43:44","","","","1","0000-00-00 00:00:00","2019-05-17 11:12:15","0000-00-00 00:00:00","","","ALH. SAIDU SIDI","08069776106","NO 1 AHMADU BELLO WAY LAPAI NIGER STATE","FATHER","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0198","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("523","0","1","0","0","4","13","1","4","13","0523","0","0","27","549","","SALISU MAMMAN","08062594131","","","2019-05-17-120409SALISU.pdf.pdf","M","1","Nigerian","27","8","1970","married","","","","mamman_salisu@yahoo.com","","KONTAGORA","08062594131","","KONTAGORA LOCAL GOVERNMENT COUNCIL, KONTAGORA, NIGER STATE","BEHIND OLD NEPA OFFICE, KONTAGORA, NIGER STATE","2019-05-17-114508.jpg","Normal","O","None","NONE","1","0","0","197.210.64.59","2019-05-17 12:51:25","2019-05-17 12:55:01","","","","0","0000-00-00 00:00:00","2019-05-17 11:44:07","0000-00-00 00:00:00","","","IBRAHIM AHMED MARAFA","08036328482","258 GRA PHASE II, KONTAGORA, NIGER STATE","BROTHER","1","SELF","BEHIND OLD NEPA OFFICE, KONTAGORA, NIGER STATE","1","                                
\n                                                                 
\n                                ","3","2019-11-01 10:51:31","","16","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("524","0","1","0","0","1","11","1","1","11","0524","0","0","27","551","","LIMAN ALIYU DOKO","08065622941","","","2019-05-17-121549ND33.pdf.pdf","M","1","Others","22","6","1969","married","","","","aliyudokoliman@gmail.com","","DOKO","08065622941","","GRA BIDA","GRA BIDA","2019-05-17-114907.jpeg","Normal","O","None","FIT","1","0","0","105.112.113.95","2020-01-15 10:25:21","2020-01-15 10:25:49","","","","1","0000-00-00 00:00:00","2019-05-17 11:47:01","0000-00-00 00:00:00","","","MAHMADU LIMAN","08105288377","GRA BIDA","BROTHER","1","LIMAN DOKO ALIYU","GRA BIDA","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0259","26","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("525","0","1","0","0","10","21","1","10","21","0525","0","0","27","553","","RABIAT MOHAMMED ILIYASU","07032132997","","","2019-05-17-163302Doc7.pdf.pdf","F","1","Nigerian","6","9","1994","married","","","","modilrab@gmail.com","","","07032132997","","HOUSE NO. ZA 55, KPADIPE MINNA, NIGER STATE","HOUSE NO. ZA 55, KPADIPE MINNA, NIGER STATE","2019-05-17-161838.jpg","Normal","O","None","","1","1","0","197.210.53.55","2020-01-09 09:10:11","2020-01-03 12:41:22","","","","1","0000-00-00 00:00:00","2019-05-17 11:50:25","0000-00-00 00:00:00","","","RABIU ALHAJI YABAGI","08035850777","HOUSE NO. ZA 55, KPADIPE MINNA, NIGER STATE","HUSBAND","1","SELF","HOUSE NO. ZA 55, KPADIPE MINNA, NIGER STATE","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0431","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("526","0","0","0","0","0","0","1","4","13","0526","0","0","27","549","","IBRAHIM MOHAMMED","08069209843","","","2019-05-17-123226IBRAHIM.pdf.pdf","M","1","Nigerian","11","3","1976","married","","","","shamboknt@gmail.com","","KONTAGORA","08069209843","","KONTAGORA LOCAL GOVERNMENT COUNCIL, KONTAGORA, NIGER STATE","GRA, PHASE II, KONTAGORA, NIGER STATE","2019-05-17-121341.jpg","Normal","O","None","NONE","1","0","0","197.210.64.59","2019-05-17 12:13:12","2019-05-17 12:35:47","","","","0","0000-00-00 00:00:00","2019-05-17 12:12:50","0000-00-00 00:00:00","","","IBRAHIM AHMED MARAFA","08036328482","258 GRA PHASE II, KONTAGPORA, NIGER STATE","BROTHER","1","SELF","GRA, PHASE II, KONTAGORA, NIGER STATE","0","","0","0000-00-00 00:00:00","","16","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("527","0","1","0","0","4","13","1","4","13","0527","0","0","27","549","","MAMUDA IBELU","08033568797","","","2019-05-17-124913IBELU.pdf.pdf","M","1","Nigerian","22","12","1974","married","","","","ibelson2@gmail.com","","KONTAGORA","08033568797","","KONTAGORA LOCAL GOVERNMENT COUNCIL, KONTAGORA, NIGER STATE","OLD NEPA ROAD, KONTAGORA, NIGER STATE","2019-05-17-123927.jpg","Normal","O","None","NONE","1","0","0","197.210.60.119","2020-01-03 10:55:08","2020-01-03 10:56:01","","","","0","0000-00-00 00:00:00","2019-05-17 12:36:59","0000-00-00 00:00:00","","","IBRAHIM AHMED MARAFA","08036328482","258 GRA PHASE II, KONTAGORA, NIGER STATE","BROTHER","1","SELF","OLD NEPA ROAD, KONTAGORA, NIGER STATE","1","                                
\n                                                                 
\n                                ","3","2019-11-01 10:49:39","0506","16","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("528","0","1","0","0","1","11","1","1","11","0528","0","0","27","551","","MUHAMMAD IBN JIBREEL","08164319597","","","","M","1","Nigerian","25","8","1979","married","","","","jibreelmuhammed2@gmail.com","","NUWADZURUGI","08164319597","","AREA 12, STREET 1, POLY ROAD BIDA","AREA 12, STREET 1, POLY ROAD BIDA","2019-05-17-123900.jpeg","Normal","O","None","FIT","1","0","0","105.112.114.140","2020-01-16 09:44:28","2020-01-16 09:44:44","","","","1","0000-00-00 00:00:00","2019-05-17 12:38:09","0000-00-00 00:00:00","","","MOHAMMED SHABA","09033759640","AREA 12, STREET 1, POLY ROAD BIDA","SON","1","MUHAMMED IBN JIBREEL","AREA 12, STREET 1, POLY ROAD BIDA","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0258","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("529","0","0","0","0","0","0","1","2","15","0529","0","0","27","545","","Ndana Shabako Sakpe","08068698543","","","2019-05-17-130829SAAAKPE 12.pdf.pdf","M","1","Nigerian","3","1","1985","married","","","","ndanasakpe@gmail.com","","Sakpe Edati LGA","08068698543","","Emilegboduma Tifin Area Sakpe Edati LGA Niger State","Emilegboduma Tifin Area Sakpe Edati LGA Niger State","2019-05-17-130602.jpg","Normal","B+","None","","1","1","0","129.205.112.146","2019-05-17 12:49:53","0000-00-00 00:00:00","","","","1","0000-00-00 00:00:00","2019-05-17 12:41:36","0000-00-00 00:00:00","","","Alh. Umar Idris","08034902141","Emilegboduma Tifin Area Sakpe Edati LGA Niger State","Father","1","","","0","","0","0000-00-00 00:00:00","","18","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("530","0","0","0","0","0","0","1","4","4","0530","0","0","27","555","","JIBRIL ABUBAKAR KETSO","08034028805","","","2019-05-17-133202KETSO.pdf.pdf","M","1","Nigerian","20","12","1989","married","","","","jibrilketso@gmail.com","","KETSO","08034028805","","OPPOSITE MYPA SECONDARY SCHOOL DUTSEN KURA GWARI MINNA, NIGER STATE","OPPOSITE MYPA SECONDARY SCHOOL DUTSEN KURA GWARI MINNA, NIGER STATE","2019-05-17-131021.jpg","Normal","O","None","","1","0","0","105.112.120.210","2019-12-27 17:23:55","2019-12-27 17:24:09","","","","1","0000-00-00 00:00:00","2019-05-17 13:05:57","0000-00-00 00:00:00","","","ABDULLAHI ABUBAKAR KETSO","08034599365","OPPOSITE MYPA SECONDARY SCHOOL DUTSEN KURA GWARI MINNA, NIGER STATE","BROTHER","4","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("531","0","1","0","0","4","12","1","10","21","0531","0","0","27","541","","Aishatu Hussaini","07069256682","","","2019-05-17-134900Aishat Hussaini.pdf.pdf","F","1","Nigerian","2","10","1993","single","","","","aysha6925@gmail.com","","Kaduna","07069256682","","Anguwan Biri, Bosso, Minna, Niger State","Anguwan Biri, Bosso, Minna, Niger State","2019-05-17-133826.jpeg","Normal","O","None","Nil","1","0","0","197.210.85.194","2020-02-11 15:49:37","2020-02-11 16:07:26","","","","1","0000-00-00 00:00:00","2019-05-17 13:29:46","0000-00-00 00:00:00","","","Mohammed Yahaya","07061004283","Anguwan Biri, Bosso, Minna, Niger State","Father","1","Mohammed Yahaya","Anguwan Biri, Bosso, Minna, Niger State","1","                                
\n                                                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                                                 
\n                                ","3","2020-02-11 15:50:57","0570","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("532","0","1","0","0","7","16","1","7","16","0532","0","0","27","555","","FATIMA ALIYU YELWA","08060002822","","","","F","1","Nigerian","23","6","1992","single","","","","talk2phateema@gmail.com","","MOKWA","08060002822","","OPP. WHITEHEART KPAKUNGU MINNA, NIGER STATE","OPP. WHITEHEART KPAKUNGU MINNA, NIGER STATE","2019-05-17-142013.jpg","Normal","O","None","","1","0","0","197.210.70.15","2020-02-04 17:36:35","2020-02-04 17:38:26","","","","1","0000-00-00 00:00:00","2019-05-17 14:07:05","0000-00-00 00:00:00","","","MAL. ALIYU YELWA","08038291042","MOKWA, NIGER STATE","FATHER","1","MAL. ALIYU YELWA","MOKWA, NIGER STATE","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0325","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("533","0","1","0","0","4","4","1","4","4","0533","0","0","27","560","","SHUAIBU AISHA","08027889345","","","","F","1","Nigerian","15","5","1996","single","","","","angoaliyu76@yahoo.com","","SHIRORO","08027889345","","NO. 10 MOHAMMED NASIRU CLOSE GARDEN CITY BOSSO EST","","","Normal","B+","None","","1","0","0","197.210.85.22","2020-01-02 15:45:34","2020-01-02 15:46:06","","","","1","0000-00-00 00:00:00","2019-05-17 14:33:28","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0268","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("534","0","0","0","0","0","0","1","2","15","0534","0","0","27","560","","BALA MARIA","08035592029","","","","F","2","Nigerian","17","12","1986","single","","","","angoaliyu76@yahoo.com","","SHIRORO","08035592029","","ZB 27 FADEKPE DUTSEN KURA","","","Normal","AB","None","","1","0","0","197.210.53.207","2019-05-31 15:53:00","2019-05-31 15:55:54","","","","1","0000-00-00 00:00:00","2019-05-17 14:38:01","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("535","0","1","0","0","9","18","1","9","19","0535","0","0","27","539","","Ramatu Abdulkadir","09039590665","","","2019-05-17-151024Ramatu.pdf.pdf","F","1","Nigerian","13","4","1992","married","","","","littlebengseworld@gmail.com","","Agaie","09039590665","","Tunga, Minna Niger State","Tunga, Minna Niger State","2019-05-17-145923.jpeg","Normal","O","None","Nil","1","0","0","105.112.122.11","2020-02-08 14:42:43","2020-02-08 14:43:17","","","","1","0000-00-00 00:00:00","2019-05-17 14:51:35","0000-00-00 00:00:00","","","Abdulkadir Mohammed","08039719524","Tunga, Minna Niger State","Father","1","Abdulkadir Mohammed","Tunga, Minna Niger State","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0323","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("536","0","1","0","0","4","12","1","4","12","0536","0","0","7","133","","JERRY AIDOKO","07030308003","","","","M","2","Nigerian","17","3","1992","married","","","","jerryaidoko3030@gmail.com","","BENUE","07030308003","","IBBU ESTATE ALONG NSTA TUNGA, MINNA NIGER STATE","IBBU ESTATE ALONG NSTA TUNGA, MINNA NIGER STATE","2019-05-17-145924.jpg","Normal","A+","None","","1","0","0","105.112.112.20","2020-01-28 15:59:49","2020-01-28 15:59:59","","","","1","0000-00-00 00:00:00","2019-05-17 14:57:14","0000-00-00 00:00:00","","","MR. PETER AIDOKO","","IBBU ESTATE ALONG NSTA TUNGA, MINNA NIGER STATE","FATHER","1","MR. PETER AIDOKO","IBBU ESTATE ALONG NSTA TUNGA, MINNA NIGER STATE","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0326","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("537","0","0","0","0","0","0","1","4","12","0537","0","0","0","0","","MOHAMMED BABADOKO ABUBAKAR","","","","","","0","","","","","","","","","ndanusa006@gmail.com","","","08061243134","","","","","","","","","1","0","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-05-17 15:39:49","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("538","0","1","0","0","4","12","1","4","12","0538","0","0","27","539","","MOHAMMED BABADOKO ABUBAKAR","08061243134","","","2019-05-17-163121BABADOKO.pdf.pdf","M","1","Nigerian","19","5","1982","married","","","","ndanusa006@gmail.com","","MINNA","08061243134","","NO 91B(W7), JIYA VATSA ROAD OLD AIRPORT QUARTERS MINNA
\n","NO 91B(W7), JIYA VATSA ROAD OLD AIRPORT QUARTERS MINNA
\n","2019-05-17-163238.jpg","Normal","O","None","NIL","1","0","0","197.210.85.77","2020-02-08 15:30:41","2020-02-08 15:31:27","","","","1","0000-00-00 00:00:00","2019-05-17 15:46:56","0000-00-00 00:00:00","","","ALHAJI ABUBAKAR CHADO TSAKPATI","08052549456","NO 91B(W7), JIYA VATSA ROAD OLD AIRPORT QUARTERS MINNA","FATHER","1","MOHAMMED BABADOKO","NO 91B(W7), JIYA VATSA ROAD OLD AIRPORT QUARTERS MINNA","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0453","9","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("539","0","1","0","0","7","16","1","7","16","0539","0","0","0","0","","HUSSAINA YUSUF MUHAMMAD","","","","2019-05-20-151510CHANGE OF NAME.pdf.pdf","","0","","","","","","","","","bndanusa@gmail.com","","","07038615576","","","","2019-05-17-162124.jpg","","","","","1","0","0","197.210.53.51","2019-11-07 16:52:34","2019-11-08 12:39:17","","","","1","0000-00-00 00:00:00","2019-05-17 16:05:27","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0451","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("540","0","0","0","0","0","0","1","1","10","0540","0","0","0","0","","SANUSI MUHAMMAD","","","","","","0","","","","","","","","","kabirumohammed55@gmail.com","","","08065090664","","","","","","","","","1","0","0","197.210.226.30","2019-05-17 19:45:02","2019-05-17 19:45:49","","","","0","0000-00-00 00:00:00","2019-05-17 18:15:35","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("541","0","1","0","0","1","10","1","1","10","0541","0","0","27","544","","SANUSI MOHAMMED","08077204024","","","2019-05-18-144701CREDENTIAL.pdf.pdf","M","1","Nigerian","1","6","1983","married","","","","balkisumusa496@gmail.com","","MINNA","08077204024","","OPPOSITE NEPA OFFICE, FARM CENTER, TUNGA, MINNA NIGER STATE.","OPPOSITE NEPA OFFICE, FARM CENTER, TUNGA, MINNA NIGER STATE.","2019-05-17-185303.jpg","Normal","O","None","","1","1","0","197.210.85.194","2020-02-11 18:30:55","2020-01-16 10:38:55","","","","1","0000-00-00 00:00:00","2019-05-17 18:28:29","0000-00-00 00:00:00","","","MOHAMMED SANI","08065090664","OPPOSITE NEPA OFFICE, FARM CENTER, TUNGA, MINNA NIGER STATE.","FATHER","1","SANUSI MOHAMMED","OPPOSITE NEPA OFFICE, FARM CENTER, TUNGA, MINNA NIGER STATE.","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2020-02-11 18:32:53","0416","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("542","0","0","0","0","0","0","1","2","15","0542","0","0","27","550","","MOHAMMED ABUBAKAR","08076223007","","","","M","1","Nigerian","28","8","1980","married","","","","gamboabu9@gmail.com","","MINNA","08076223007","","no 5 mohammed makeri resident ","no 5 mohammed makeri resident ","2019-05-18-131847.jpg","Normal","A+","None","","1","0","0","41.190.14.74","2019-05-18 12:59:35","2019-05-18 13:21:04","","","","1","0000-00-00 00:00:00","2019-05-17 23:29:11","0000-00-00 00:00:00","","","mohammed abubakar","08076223007","no 5 mohammed makeri resident ","FATHER","1","mohammed abubakar","no 5 mohammed makeri resident ","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("543","0","0","0","0","0","0","1","2","2","0543","0","0","0","0","","ALHASSAN SULEIMAN NASIDI","","","","","","0","","","","","","","","","sulaimanalhassan1990@gmail.com","","","08032902293","","","","","","","","","1","0","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-05-17 23:32:55","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("544","0","1","0","0","2","2","1","2","2","0544","0","0","27","550","","ALHASSAN SULEIMAN NASIDI","08032902293","","","2019-05-17-234824nce form.pdf.pdf","M","1","Nigerian","24","11","1986","married","","","","sulaimanalhassan1990@gmail.com","","MINNA","08032902293","","no g15 mechanic junction chanchaga ","no g15 mechanic junction chanchaga ","2019-05-18-132128.jpg","Normal","O","None","","1","0","0","105.112.116.72","2020-01-24 12:47:47","2020-01-24 12:48:39","","","","1","0000-00-00 00:00:00","2019-05-17 23:32:56","0000-00-00 00:00:00","","","suleiman alhassan","08032902293","no g15 mechanic junction chanchaga ","FATHER ","1","alhassan suleiman","no g15 mechanic junction chanchaga ","1","                                
\n                                                                 
\n                                ","3","2019-11-05 07:37:08","0569","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("545","0","0","0","0","0","0","1","1","10","0545","0","0","0","0","","Abubakar Bala Mohammed","","","","","","0","","","","","","","","","abubalmoh2011@gmail.com","","","08069086872","","","","","","","","","1","0","0","105.112.122.219","2019-09-18 09:11:50","2019-09-18 09:15:19","","","","0","0000-00-00 00:00:00","2019-05-18 05:48:52","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("546","0","1","0","0","10","21","1","10","21","0546","0","0","27","543","","AISHA MOHAMMED","07035863909","","","","F","1","Nigerian","5","5","1990","married","","","","angoaliyu76@yahoo.com","","BOSSO","07035863909","","BESIDE TALBA HOUSING ESTATE, BIDA ROAD MINNA","","2019-09-20-101629.jpg","Normal","B+","None","","1","0","0","197.210.45.38","2020-01-03 14:58:12","2020-01-03 14:58:45","","","","1","0000-00-00 00:00:00","2019-05-18 08:27:07","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0246","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("547","0","0","0","0","0","0","1","7","16","0547","0","0","27","541","","YUSUF AHMED","09035190078","","","","M","1","Nigerian","11","8","1982","married","","","","danladiyusufa@gmail.com","","BIDA","09035190078","","TUNGA MAJE MINNA","","","Normal","O","None","","1","0","0","105.112.122.219","2019-09-18 09:15:29","2019-09-18 09:16:30","","","","1","0000-00-00 00:00:00","2019-05-18 08:28:11","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("548","0","1","0","0","4","13","1","4","13","0548","0","0","31","652","","OJETOKUN EZEKIEL KAYODE","07063939825","","","","M","2","Nigerian","28","8","1981","married","","","","kayodejett@gmail.com","","OGBOMOSO","07063939825","","BEHIND NECO STAFF QRTRS BRIGHTER MINNA","","","Normal","O","None","","1","0","0","105.112.112.20","2020-01-28 16:17:33","2020-01-28 16:17:42","","","","1","0000-00-00 00:00:00","2019-05-18 08:29:36","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-21 15:12:55","0599","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("549","0","1","0","0","2","15","1","2","15","0549","0","0","29","591","","AKINBINU OLAYIWOLA","08169709702","","","","M","2","Nigerian","24","2","1992","single","","","","aoymola@gmail.com","","IDANRE","08169709702","","FRANK GUEST INN, BESIDE BAHAGO PLAZA TUNGA MINNA","","","Normal","O","None","","1","1","0","197.210.8.70","2019-12-21 12:03:39","2019-12-21 10:48:59","","","","1","0000-00-00 00:00:00","2019-05-18 08:31:27","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0010","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("550","0","1","0","0","9","6","1","2","2","0550","0","0","27","548","","BALA MOHAMMED","07064684766","","","","M","1","Nigerian","3","3","1977","married","","","","balakayarda2019@gmail.com","","KATCHA","07064684766","","KATAEREGI","","","Normal","B+","None","","1","0","0","105.112.115.177","2020-01-16 14:58:07","2020-01-16 14:58:46","","","","1","0000-00-00 00:00:00","2019-05-18 08:33:23","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-03 08:44:10","0004","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("551","0","1","0","0","10","21","1","10","21","0551","0","0","27","544","","MUHAMMAD ASMA\'U","09032475195","","","","F","1","Nigerian","2","2","1978","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","09032475195","","L9 MALLAM MAKARANTA ROAD 123 QRTRS MINNA","","","Normal","O","None","","1","0","0","197.210.47.199","2020-01-02 22:55:38","2020-01-02 22:56:15","","","","1","0000-00-00 00:00:00","2019-05-18 08:34:38","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0098","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("552","0","1","0","0","2","2","1","2","2","0552","0","0","27","546","","MUHAMMAD NDACHE HADIZA","07063518301","","","","F","1","Nigerian","18","6","1986","married","","","","angoaliyu76@yahoo.com","","GBAKO","07063518301","","L9 MALLAM MAKARANTA ROAD MINNA","","","Normal","O","None","","1","0","0","105.112.114.118","2019-12-13 09:57:38","2019-12-13 10:09:50","","","","1","0000-00-00 00:00:00","2019-05-18 08:36:05","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-12-12 16:27:10","0005","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("553","0","1","0","0","10","21","1","10","21","0553","0","0","27","539","","ABDULLAHI BALA ","08036534901","","","","M","1","Nigerian","3","7","1980","married","","","","angoaliyu76@yahoo.com","","AGAIE","08036534901","","NO. 7 BEHIND MI WUSHISHI ESTATE TUNGA MINNA","","","Normal","O","None","","1","0","0","197.210.45.38","2020-01-03 13:50:39","2020-01-03 13:51:12","","","","1","0000-00-00 00:00:00","2019-05-18 08:37:51","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-01 10:29:42","0510","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("554","0","0","0","0","0","0","1","4","12","0554","0","0","27","560","","UMAR AISHATU","07068007414","","","","F","1","Nigerian","28","8","1982","married","","","","angoaliyu76@yahoo.com","","SHIRORO","07068007414","","BOSSO ANGUWAN BIRI","","","Normal","O","None","","1","0","0","197.210.52.36","2019-05-31 16:05:14","2019-05-31 16:06:02","","","","1","0000-00-00 00:00:00","2019-05-18 08:39:59","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("555","0","0","0","0","0","0","1","4","12","0555","0","0","27","550","","YUNUSA ALHASSAN","09031199765","","","","M","1","Nigerian","2","2","1970","married","","","","angoaliyu76@yahoo.com","","LAPAI","09031199765","","LATE ETSU ALHASSAN EWUGI VIA GULU DISTRICT","","","Normal","O","None","","1","0","0","197.210.52.158","2019-05-31 16:06:15","2019-05-31 16:06:49","","","","1","0000-00-00 00:00:00","2019-05-18 08:42:44","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("556","0","0","0","0","0","0","1","1","10","0556","0","0","27","543","","IBRAHIM ALHASSAN","08052113917","","","","M","1","Nigerian","7","3","1979","married","","","","alhassan0740@yahoo.com","","BOSSO","08052113917","","GIDAN HASSAN MADAKI MAIKUNKELE BOSSO LGA","","","Normal","O","None","","1","0","0","197.210.52.36","2019-05-31 16:06:57","2019-05-31 16:07:48","","","","1","0000-00-00 00:00:00","2019-05-18 08:44:35","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("557","0","1","0","0","4","12","1","4","12","0557","0","0","23","488","","DAVID IFEOLUWA","08161392490","","","","F","2","Nigerian","8","10","1996","single","","","","davidifeoluwa01@gmail.com","","YAGBA","08161392490","","PRISON FARM CENTER KUJAMA KADUNA STATE","","","Normal","O","None","","1","0","0","197.210.52.222","2019-05-31 16:08:05","2019-05-31 16:08:42","","","","1","0000-00-00 00:00:00","2019-05-18 08:52:19","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("558","0","1","0","0","10","22","1","10","22","0558","0","0","27","557","","YAKUBU HASSANA","08036969757","","","","F","1","Nigerian","11","3","1973","married","","","","angoaliyu76@yahoo.com","","PAIKORO","08036969757","","OPP HOUSE OF ASSEMBLY QRTRS EASTERN BYE PASS","","","Normal","B+","None","","1","0","0","105.112.115.177","2020-01-16 14:09:18","2020-01-16 14:09:29","","","","1","0000-00-00 00:00:00","2019-05-18 08:53:34","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0155","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("559","0","0","0","0","0","0","1","1","11","0559","0","0","23","484","","SIDIQ ISMAILA OHIARE","09038384582","","","","M","1","Nigerian","6","6","1969","married","","","","sidiqismaila@gmail.com","","OKEHI","09038384582","","NO. JS 94 NRC QRTRS ZARIA KADUNA STATE","","","Normal","O","None","","1","0","0","197.210.52.5","2019-05-31 16:09:41","2019-05-31 16:10:17","","","","1","0000-00-00 00:00:00","2019-05-18 08:55:09","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("560","0","1","0","0","1","11","1","1","11","0560","0","0","27","546","","IBRAHIM ABDULRAHMAN LEMU","08034060085","","","","M","1","Nigerian","20","4","1970","married","","","","angoaliyu76@yahoo.com","","GBAKO","08034060085","","NO. 6 BEHIND PRISON QTRS TUNGA MINNA","","","Normal","O","None","","1","0","0","105.112.113.95","2020-01-15 10:50:49","2020-01-15 10:51:03","","","","1","0000-00-00 00:00:00","2019-05-18 08:56:29","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0493","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("561","0","0","0","0","0","0","1","1","10","0561","0","0","27","547","","HAMIDU AMINU","07065066297","","","","M","1","Nigerian","27","2","1995","single","","","","angoaliyu76@yahoo.com","","GURARA","07065066297","","NO. 156 KOPATI GAWU BABANGIDA GURARA LGA","","","Normal","B+","None","","1","0","0","197.210.52.10","2019-05-31 16:11:14","2019-05-31 16:11:56","","","","1","0000-00-00 00:00:00","2019-05-18 08:57:40","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("562","0","0","0","0","0","0","1","10","21","0562","0","0","27","550","","AHMED SALIHU MOHAMMED","08059813864","","","","M","1","Nigerian","18","4","1984","married","","","","angoaliyu76@yahoo.com","","LAPAI","08059813864","","K47 IBRAHIM ROAD LAPAI","","","Normal","O","None","","1","0","0","197.210.53.68","2019-05-31 16:13:18","2019-05-31 16:15:26","","","","1","0000-00-00 00:00:00","2019-05-18 08:58:55","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("563","0","1","0","0","10","21","1","4","12","0563","0","0","27","541","","LADAN MOHAMMED YA\'ABA","08033565919","","","","M","1","Nigerian","10","4","1986","married","","","","mohammedyaabaladan@gmail.com","","BIDA","08033565919","","LATE ALHAJI LADAN ALIYU OZUKOGI ESSAN BIDA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 14:20:02","2020-01-16 14:20:14","","","","1","0000-00-00 00:00:00","2019-05-18 09:00:29","0000-00-00 00:00:00","","","","","A","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-15 12:42:15","0534","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("564","0","1","0","0","10","21","1","7","16","0564","0","0","27","555","","BUHARI MAIMUNA","08035574108","","","","F","1","Nigerian","19","4","1991","single","","","","munambuhari888@gmail.com","","MOKWA","08035574108","","BARIKIN SALE OPPOSITE DEEPER LIFE CHURCH IBRAHIM KURCHI ROAD MINNA","","","Normal","O","None","","1","0","0","197.210.85.194","2020-02-11 16:38:50","2020-02-11 16:52:37","","","","1","0000-00-00 00:00:00","2019-05-18 09:01:52","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2020-02-11 16:46:19","0340","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("565","0","0","0","0","0","0","1","7","16","0565","0","0","27","544","","ABDULAZEEZ ABDULRASHEED OLAREWAJU","07030981614","","","","M","1","Nigerian","10","6","1993","single","","","","angoaliyu76@yahoo.com","","CHANCHAGA","07030981614","","BOSSO MINNA","","","Normal","O","None","","1","0","0","197.210.226.58","2019-06-01 12:22:02","2019-06-01 12:22:48","","","","1","0000-00-00 00:00:00","2019-05-18 09:03:29","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("566","0","1","0","0","2","2","1","2","14","0566","0","0","27","539","","MOHAMMED MUNDI","08158268691","","","","M","1","Nigerian","28","12","1991","single","","","","angoaliyu76@yahoo.com","","AGAIE","08158268691","","EMI ETSUYANKPA KUTIRKO VIA AGAIE LGA","","","Normal","O","None","","1","0","0","197.210.70.15","2020-02-04 17:23:19","2020-02-04 17:24:43","","","","1","0000-00-00 00:00:00","2019-05-18 09:04:26","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0306","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("567","0","1","0","0","9","18","1","9","18","0567","0","0","27","544","","YUSUF ISAH PAIKO","08067417550","","","","M","1","Nigerian","12","12","1986","single","","","","isahpaiko@gmail.com","","CHANCHAGA","08067417550","","S.E 167, SABON GARI MINNA","","","Normal","A+","None","","1","0","0","197.210.227.60","2019-06-01 12:24:09","2019-06-01 12:25:13","","","","1","0000-00-00 00:00:00","2019-05-18 09:05:35","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("568","0","0","0","0","0","0","1","2","14","0568","0","0","27","541","","MUSA MARYAM","07066276545","","","","F","1","Nigerian","6","5","1983","married","","","","maryamsadiqmu@gmail.com","","BIDA","07066276545","","TUNGA SHIRORO ROAD OFF BAY CLINIC ROAD MINNA","","","Normal","O","None","","1","0","0","197.210.226.147","2019-06-01 12:25:28","2019-06-01 12:26:28","","","","1","0000-00-00 00:00:00","2019-05-18 09:06:51","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("569","0","1","0","0","1","11","1","1","11","0569","0","0","27","557","","HAMISU DOMA SADA","08055614340","","","","M","1","Nigerian","5","6","1966","married","","","","hamdosa1@gmail.com","","PAIKORO","08055614340","","NP 19A GWARI ROAD BAHAGO DRIVE MINNA","","","Normal","B+","None","","1","0","0","105.112.114.140","2020-01-16 09:46:26","2020-01-16 09:46:49","","","","1","0000-00-00 00:00:00","2019-05-18 09:07:59","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0350","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("570","0","1","0","0","2","2","1","2","2","0570","0","0","27","563","","HURAIRA MUHAMMAD WUSHISHI","08130904542","","","","F","1","Nigerian","26","6","1993","single","","","","wushishihmw@gmail.com","","WUSHISHI","08130904542","","MILITARY CONTORMENT TRADOC MINNA","","","Normal","B+","None","","1","0","0","197.210.45.38","2020-01-03 14:45:05","2020-01-03 14:45:30","","","","1","0000-00-00 00:00:00","2019-05-18 09:09:23","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0257","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("571","0","1","0","0","10","21","1","10","21","0571","0","0","27","560","","FATIMA GAMBO","08032561368","","","","F","1","Nigerian","20","8","1985","married","","","","angoaliyu76@yahoo.com","","SHIRORO","08032561368","","FADIKPE","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 14:32:22","2020-01-16 14:33:05","","","","1","0000-00-00 00:00:00","2019-05-18 09:13:05","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0428","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("572","0","0","0","0","0","0","1","2","14","0572","0","0","29","584","","ADEOSUN DAYO","08065761042","","","","M","2","Nigerian","25","7","1984","married","","","","adeosundayo42@yahoo.com","","AKOKO","08065761042","","PRISON QTRS MINNA","","","Normal","O","None","","1","0","0","197.210.226.147","2019-06-01 12:29:36","2019-06-01 12:30:08","","","","1","0000-00-00 00:00:00","2019-05-18 09:14:20","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("573","0","1","0","0","4","13","1","4","13","0573","0","0","27","551","","NDAMAJIN CHADO","08066411199","","","","M","1","Nigerian","20","9","1974","married","","","","angoaliyu76@yahoo.com","","LAVUN","08066411199","","EMI NDAMAJIN TSWACI DOKO","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 11:29:00","2020-01-16 11:29:11","","","","1","0000-00-00 00:00:00","2019-05-18 09:15:32","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0016","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("574","0","0","0","0","0","0","1","7","16","0574","0","0","27","539","","SHU\'AIBU SA\'IDU","08026290335","","","","M","1","Nigerian","11","1","1995","married","","","","angoaliyu76@yahoo.com","","AGAIE","08026290335","","FOGBE EMI ALHAJI SHUAIBU FOGBE VIA AGAIE LGA","","","Normal","O","None","","1","0","0","197.210.226.147","2019-06-01 12:31:20","2019-06-01 12:32:18","","","","1","0000-00-00 00:00:00","2019-05-18 09:17:02","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("575","0","1","0","0","4","12","1","2","14","0575","0","0","27","539","","ALIYU ALHAJI SALIHU","08168471608","","","","M","1","Nigerian","4","4","1983","married","","","","angoaliyu76@yahoo.com","","AGAIE","08168471608","","GIDAN ENGINEER BALA DARUSALAM BEHIND RAHAMA BREAD KPAKUNGU","","","Normal","B+","None","","1","0","0","105.112.112.20","2020-01-28 16:10:24","2020-01-28 16:10:42","","","","1","0000-00-00 00:00:00","2019-05-18 09:19:20","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-05 08:40:19","0472","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("576","0","1","0","0","4","4","1","4","4","0576","0","0","27","541","","MUHAMMAD ADAMA\'U BALARABA","09036712796","","","","F","1","Nigerian","16","10","1996","single","","","","adamaumuhammad@gmail.com","","BIDA","09036712796","","ODUOYE QTRS MINNA","","","Normal","O","None","","1","1","0","41.203.73.183","2019-09-27 09:03:24","2019-06-01 12:34:37","","","","1","0000-00-00 00:00:00","2019-05-18 12:06:26","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0173","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("577","0","0","0","0","0","0","1","2","15","0577","0","0","27","548","","YABAGI SHABA","08065697265","","","","M","1","Nigerian","1","4","1970","married","","","","angoaliyu76@yahoo.com","","KATCHA","08065697265","","RADIO NIGER MINNA PMB 88","","","Normal","O","None","","1","0","0","197.210.226.26","2019-06-01 12:34:49","2019-06-01 12:35:36","","","","1","0000-00-00 00:00:00","2019-05-18 12:11:28","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("578","0","0","0","0","0","0","1","7","16","0578","0","0","27","557","","KARMA YAKUBU ","08038357273","","","","M","1","Nigerian","2","8","1988","married","","","","yakubukarma49@gmail.com","","PAIKORO","08038357273","","OLD MARKET MAI ANGUWA HOUSE PAIKO","","","Normal","O","None","","1","0","0","197.210.226.147","2019-06-01 12:35:57","2019-06-01 12:36:45","","","","1","0000-00-00 00:00:00","2019-05-18 12:20:01","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("579","0","1","0","0","7","16","1","7","16","0579","0","0","27","541","","MUHAMMED AISHATU DAUDA","07018092563","","","","F","1","Nigerian","29","11","1984","married","","","","ummuameena@gmail.com","","BIDA","07018092563","","MILLIONAIRE OPP YAKUBU SALLAUS RESIDENCE BOSSO ROAD MINNA","","","Normal","B+","None","","1","0","0","197.210.60.119","2020-01-03 11:39:26","2020-01-03 11:39:57","","","","1","0000-00-00 00:00:00","2019-05-18 12:26:35","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0220","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("580","0","1","0","0","10","22","1","2","15","0580","0","0","27","544","","ABDUL-KAREEM YUNUSA","07033674516","","","","M","1","Nigerian","15","2","1988","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","07033674516","","TUDUN FULANI CAIS QTRS","","","Normal","B+","None","","1","0","0","105.112.115.177","2020-01-16 14:05:44","2020-01-16 14:05:54","","","","1","0000-00-00 00:00:00","2019-05-18 12:35:15","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0131","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("581","0","0","0","0","0","0","1","1","11","0581","0","0","27","557","","BELLO YOHANA ","07034904354","","","","M","2","Nigerian","19","6","1983","married","","","","angoaliyu76@yahoo.com","","PAIKORO","07034904354","","OPP. ZUBAIRU PRIMARY SCHOOL PAIKO ","","","Normal","B+","None","","1","0","0","197.210.226.18","2019-06-01 12:39:09","2019-06-01 12:39:52","","","","1","0000-00-00 00:00:00","2019-05-18 12:48:04","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("582","0","1","0","0","7","16","1","7","16","0582","0","0","27","541","","ISIYAKU RUKAYYA","07037638303","","","","F","1","Nigerian","1","12","1997","married","","","","angoaliyu76@yahoo.com","","BIDA","07037638303","","GBEGANU OPP CENTRAL MOSQUE","","","Normal","O","None","","1","0","0","197.210.60.119","2020-01-03 11:42:52","2020-01-03 11:43:19","","","","1","0000-00-00 00:00:00","2019-05-18 12:58:22","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0293","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("583","0","0","0","0","0","0","1","10","21","0583","0","0","23","475","","USMAN DANLAMI SHERIFF","08106920394","","","2019-05-18-141853my second doc.pdf.pdf","M","2","Nigerian","6","4","1988","single","","","","dansheriff1234@gmail.com","","IDAH","08106920394","","BEHIND NEPA OFFICE CHANCHAGA MINNA, NIGER STATE","BEHIND NEPA OFFICE CHANCHAGA MINNA, NIGER STATE","2019-05-18-134707.jpg","Normal","A+","None","","1","0","0","197.210.52.66","2019-12-09 14:32:36","2019-12-09 14:32:51","","","","1","0000-00-00 00:00:00","2019-05-18 13:02:22","0000-00-00 00:00:00","","","USMAN YUSUF","09066640594","BEHIND NEPA OFFICE CHANCHAGA MINNA, NIGER STATE","FATHER","1","","","0","","0","0000-00-00 00:00:00","","3","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("584","0","1","0","0","1","10","1","1","10","0584","0","0","27","550","","MAIGUWA SHABA FAPO","07083981671","","","","M","1","Nigerian","13","2","1973","married","","","","angoaliyu76@yahoo.com","","LAPAI","07083981671","","FAPO GULU INN LAPAI LGA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 14:17:55","2020-01-16 14:18:37","","","","1","0000-00-00 00:00:00","2019-05-18 13:06:48","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("585","0","0","0","0","0","0","1","4","4","0585","0","0","27","560","","ADAMU MATHEW","08093196588","","","","M","2","Nigerian","3","6","1998","married","","","","mathew.goni@yahoo.com","","SHIRORO","08093196588","","NO 12 BEHIND CHALLENGE NURSARY AND PRIMARY SCHOOL MAITUMBI MINNA","","","Normal","B+","None","","1","0","0","197.210.226.18","2019-06-01 12:41:49","2019-06-01 12:42:29","","","","1","0000-00-00 00:00:00","2019-05-18 13:17:01","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("586","0","1","0","0","2","14","1","4","12","0586","0","0","27","557","","HUSSAINI JANET","08170562066","","","","F","2","Nigerian","21","10","1989","single","","","","janethussainionline@gmail.com","","PAIKORO","08170562066","","DNABO SHIRORO DAM ","","","Normal","B+","None","","1","0","0","105.112.115.177","2020-01-16 13:23:20","2020-01-16 13:23:54","","","","1","0000-00-00 00:00:00","2019-05-18 13:21:39","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2019-12-12 12:03:07","0668","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("587","0","0","0","0","0","0","1","11","25","0587","0","0","0","0","","Mohammed ndana","","","","","","0","","","","","","","","","Sodi4few276@gmail.com","","","08109336205","","","","","","","","","1","0","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-05-18 13:24:22","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("588","0","1","0","0","1","10","1","1","10","0588","0","0","27","556","","MAMMAN MARKUS","08146740472","","","","M","2","Nigerian","17","7","1990","single","","","","angoaliyu76@yahoo.com","","MUNYA","08146740472","","DANDAUDU OPPOSITE BAPTIST CHURCH ANGWAN SARKI","","","Normal","B+","None","","1","0","0","197.210.226.19","2019-06-01 12:44:06","2019-06-01 12:44:44","","","","1","0000-00-00 00:00:00","2019-05-18 13:27:25","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("589","0","0","0","0","0","0","1","2","14","0589","0","0","27","557","","ABDULMALIK USMAN","08060805634","","","","M","1","Nigerian","13","8","1984","married","","","","abdulmalikusman2525@gmail.com","","PAIKORO","08060805634","","PAIKORO LGA QTRS","","","Normal","O","None","","1","0","0","197.210.62.31","2019-08-21 12:21:59","2019-08-21 12:22:32","","","","1","0000-00-00 00:00:00","2019-05-18 13:33:29","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("590","0","1","0","0","7","16","1","7","16","0590","0","0","27","551","","TAUHIDI ABUBAKAR","08066188951","","","","M","1","Nigerian","12","4","1979","married","","","","angoaliyu76@yahoo.com","","LAVUN","08066188951","","NO. 4 NASARAFU KUTIGI LAVUN LGA","","","Normal","O","None","","1","0","0","197.210.227.72","2020-02-05 15:05:58","2020-02-05 15:08:07","","","","1","0000-00-00 00:00:00","2019-05-18 13:42:59","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0300","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("591","0","1","0","0","9","6","1","9","6","0591","0","0","27","544","","UMAR S. HALIMA","07030678822","","","","F","1","Nigerian","16","4","1988","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","07030678822","","HOUSE NO. E34 FARM CENTER MINNA","","","Normal","O","None","","1","0","0","197.210.226.253","2020-02-07 12:33:24","2020-02-07 12:40:12","","","","1","0000-00-00 00:00:00","2019-05-18 13:50:56","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0292","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("592","0","1","0","0","4","4","1","4","12","0592","0","0","27","550","","HASSAN NDAGI","07062047848","","","","M","1","Nigerian","22","12","1992","married","","","","hassanndagi@yahoomail.com","","LAPAI","07062047848","","OPPOSITE MAGAJI PRIMARY SCHOOL","","","Normal","B+","None","","1","0","0","105.112.120.240","2020-01-29 11:53:53","2020-01-29 12:02:23","","","","1","0000-00-00 00:00:00","2019-05-18 13:57:44","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2020-01-02 13:59:52","0012","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("593","0","0","0","0","0","0","1","4","13","0593","0","0","27","541","","SANI HARUNA","08065424143","","","","M","1","Nigerian","9","12","1966","married","","","","harunasani2@gmail.com","","bida","08065424143","","NO. 3 MUAZU BABANGIDA ALIYU LIFE CAMP ABUJA FCT","","","Normal","A+","None","","1","0","0","197.210.54.59","2019-06-03 11:05:49","2019-06-03 11:06:19","","","","1","0000-00-00 00:00:00","2019-05-18 14:26:24","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("594","0","1","0","0","9","18","1","9","18","0594","0","0","27","551","","Muhammad Jibrin Sokomba","08032912211","","","2019-05-20-172132SOKOMMBBAA-converted.pdf.pdf","M","1","Nigerian","30","11","1993","married","","","","mjsokomba@gmail.com","","Sokomba Village","08032912211","","Kpakungu along Bida road, Mrs. Sokomba House Via Ndakpakpan house","Kpakungu along Bida road, Mrs. Sokomba House Via Ndakpakpan house","2019-05-18-143636.jpg","Normal","AB","None","","1","0","0","105.112.122.165","2020-02-03 19:29:02","2020-02-03 19:31:08","","","","1","0000-00-00 00:00:00","2019-05-18 14:26:46","0000-00-00 00:00:00","","","Muhammad Zubairu Sokomba","08038131053","Kpakungu along Bida road, Mrs. Sokomba House Via Ndakpakpan house","Father","3","Muhammad Zubairu Sokomba","Kpakungu along Bida road, Mrs. Sokomba House Via Ndakpakpan house","1","                                
\n                                                                 
\n                                ","3","2019-11-13 14:11:31","0520","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("595","0","0","0","0","0","0","1","11","25","0595","0","0","0","0","","Mohammed  Ndana","","","","","","0","","","","","","","","","Sodi4few276@gmail.com","","","08109336205","","","","","","","","","1","0","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-05-18 14:35:22","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("596","0","0","0","0","0","0","1","4","12","0596","0","0","27","557","","BALA SHAGABE MOHAMMED","08055729496","","","","M","1","Nigerian","2","2","1982","married","","","","angoaliyu76@yahoo.com","","PAIKORO","08055729496","","ANGUWAN ZEBUPI","","","Normal","B+","None","","1","0","0","197.210.52.226","2019-08-21 14:18:13","2019-08-21 14:18:35","","","","1","0000-00-00 00:00:00","2019-05-18 14:35:58","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("597","0","1","0","0","10","21","1","10","21","0597","0","0","27","551","","USMAN AISHA GOGO","08138546602","","","","F","1","Nigerian","25","6","1987","married","","","","angoaliyu76@yahoo.com","","LAVUN","08138546602","","TOP MEDICAL ROAD KAFIN TELA TUNGA MINNA","","","Normal","A+","None","","1","0","0","197.210.45.38","2020-01-03 14:58:59","2020-01-03 14:59:33","","","","1","0000-00-00 00:00:00","2019-05-18 14:40:00","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0077","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("598","0","0","0","0","0","0","1","2","15","0598","0","0","27","541","","MOHAMMED ABDULLATEEF O.","08061372739","","","","M","1","Nigerian","1","1","1990","single","","","","abdullateef.olumide@yahoo.com","","BIDA","08061372739","","OPPOSITE WADATA PALACE BIDA ","","","Normal","O","None","","1","0","0","197.210.55.69","2019-06-03 11:09:02","2019-06-03 11:11:25","","","","1","0000-00-00 00:00:00","2019-05-18 14:44:48","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("599","0","1","0","0","2","15","1","2","15","0599","0","0","27","544","","MOHAMMED BAWA IBRAHIM","08035964255","","","","M","1","Nigerian","2","2","1981","married","","","","mohbaibrahim@gmail.com","","CHANCHAGA","08035964255","","BARIKIN SALE MINNA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 12:51:37","2020-01-16 12:51:54","","","","1","0000-00-00 00:00:00","2019-05-18 14:51:56","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0059","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("600","0","0","0","0","0","0","1","9","18","0600","0","0","27","554","","HARUNA B. ISAH","08069660977","","","","M","1","Nigerian","4","8","1981","married","","","","isahrunabala00@gmail.com","","MASHEGU","08069660977","","KABOJI PALACE","","","Normal","O","None","","1","0","0","197.210.226.91","2019-06-01 12:56:36","2019-06-01 12:57:15","","","","1","0000-00-00 00:00:00","2019-05-20 09:29:47","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("601","0","1","0","0","1","10","1","1","10","0601","0","0","27","551","","MOHAMMED SALIHU","08036929445","","","","M","1","Nigerian","22","2","1977","married","","","","salihukutigi2010@yahoo.com","","LAVUN","08036929445","","EKPAGI SHEKPATANKO AREA KUTIGI","","","Normal","B+","None","","1","0","0","105.112.113.95","2020-01-15 10:37:45","2020-01-15 10:38:03","","","","1","0000-00-00 00:00:00","2019-05-20 09:31:11","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0421","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("602","0","1","0","0","4","12","1","4","12","0602","0","0","27","557","","LUKA AGNES","08167592188","","","","F","2","Nigerian","21","2","1997","single","","","","agneslukabarde4@gmail.com","","PAIKORO","08167592188","","NO. 6 BAGUDU ROAD F-LAYOUT BOSSO ROAD MINNA","","","Normal","O","None","","1","1","0","41.203.73.234","2020-01-24 18:57:17","2020-01-02 20:39:16","","","","1","0000-00-00 00:00:00","2019-05-20 09:36:20","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-03 08:38:44","0456","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("603","0","1","0","0","1","11","1","1","11","0603","0","0","27","549","","GARBA NURA","08069647443","","","","M","1","Nigerian","13","3","1984","married","","","","narage10@gmail.com","","KONTAGORA","08069647443","","MORRIS AREA OPPOSITE RAILWAY ","","","Normal","A+","None","","1","0","0","105.112.113.95","2020-01-15 10:50:14","2020-01-15 10:50:37","","","","1","0000-00-00 00:00:00","2019-05-20 09:44:09","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0302","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("604","0","0","0","0","0","0","1","2","15","0604","0","0","27","562","","ADAMU SALEH SAMU BWARI","08035901569","","","","M","1","Nigerian","17","4","1964","married","","","","samubwari83@gmail.com","","TAFA","08035901569","","MTP 65 WUSHISHI ROAD ANGUWAN DAJI WESTERN BYE-PASS MINNA","","","Normal","B+","None","","1","0","0","197.210.226.17","2019-06-01 13:00:56","2019-06-01 13:02:06","","","","1","0000-00-00 00:00:00","2019-05-20 09:45:48","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("605","0","1","0","0","4","13","1","4","13","0605","0","0","30","608","","TIJANI ABIMBOLA ELIZABETH","08130272500","","","","F","1","Nigerian","1","8","1992","single","","","","elizabethtijani@gmail.com","","EDE NORTH","08130272500","","BEHIND EDE SOUTH LGA OFFICE OLMIN GBEBE STREET EDE OSUN STATE","","","Normal","O","None","","1","0","0","197.210.227.239","2019-06-01 13:02:20","2019-06-01 13:03:07","","","","1","0000-00-00 00:00:00","2019-05-20 09:47:17","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("606","0","1","0","0","2","15","1","2","15","0606","0","0","27","541","","BENU AISHA","08067368737","","","","M","1","Nigerian","20","3","1983","married","","","","aishabenu72@gmail.com","","BIDA","08067368737","","DARACHITA AREA BIDA ","","","Normal","O","None","","1","0","0","197.210.60.119","2020-01-03 11:22:44","2020-01-03 11:23:19","","","","1","0000-00-00 00:00:00","2019-05-20 09:48:40","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-12-09 14:01:38","0669","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("607","0","1","0","0","2","15","1","2","15","0607","0","0","23","471","","ENAPE BLESSING OJONE","07036962737","","","","F","1","Nigerian","22","2","1992","married","","","","blessingmaji6@gmail.com","","ANKPA","07036962737","","NATIONAL CEREAL INSTITUTE (NCRI) BADDEGI BIDA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 13:09:21","2020-01-16 13:09:33","","","","1","0000-00-00 00:00:00","2019-05-20 09:53:38","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-21 11:57:05","0594","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("608","0","1","0","0","10","20","1","10","21","0608","0","0","27","557","","IBRAHIM FATIMA","07030632710","","","","F","1","Nigerian","12","9","1986","married","","","","angoaliyu76@yahoo.com","","PAIKORO","07030632710","","PRISON QTRS TUNGA MINNA","","","Normal","B+","None","","1","0","0","197.210.227.239","2019-06-01 13:05:32","2019-06-01 13:06:47","","","","1","0000-00-00 00:00:00","2019-05-20 09:54:28","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("609","0","1","0","0","1","10","1","1","10","0609","0","0","27","539","","ALIYU MADIWU GALADIMA","08035091293","","","","M","1","Nigerian","5","5","1980","married","","","","angoaliyu76@yahoo.com","","AGAIE","08035091293","","GRA PHASE II AGAIE BESIDE IBRAHIM","","","Normal","O","None","","1","0","0","105.112.113.95","2020-01-15 10:30:41","2020-01-15 10:32:27","","","","1","0000-00-00 00:00:00","2019-05-20 09:56:08","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0405","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("610","0","0","0","0","0","0","1","4","12","0610","0","0","27","548","","AHMADU YAHAYA","07067612710","","","","M","1","Nigerian","5","5","1997","single","","","","ahmaduyahaya@gmail.com","","KATCHA","07067612710","","KPAKUNGU OPPOSITE POLICE STATION MINNA","","","Normal","O","None","","1","0","0","197.210.227.239","2019-06-01 13:08:56","2019-06-01 13:10:33","","","","1","0000-00-00 00:00:00","2019-05-20 09:57:49","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("611","0","1","0","0","10","21","1","10","21","0611","0","0","27","543","","ABUBAKAR ABDULKADIR","08077214706","","","","F","1","Nigerian","17","1","1975","married","","","","angoaliyu76@yahoo.com","","BOSSO","08077214706","","MUSA ABUBAKAR STREET BOSSO","","","Normal","O","None","","1","0","0","105.112.114.100","2020-02-20 11:32:29","2020-02-20 11:39:44","","","","1","0000-00-00 00:00:00","2019-05-20 09:59:33","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0452","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("612","0","1","0","0","10","20","1","7","16","0612","0","0","27","541","","YUSUF YAHAYA","07063643375","","","","M","1","Nigerian","16","12","1993","single","","","","yusufyahaya5050@gmail.com","","BIDA","07063643375","","MINNA TUNGA LOWCOST BEHIND BANANA HOUSE","","","Normal","O","None","","1","0","0","197.210.226.91","2019-06-01 13:11:46","2019-06-01 13:13:52","","","","1","0000-00-00 00:00:00","2019-05-20 10:01:07","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("613","0","1","0","0","7","5","1","7","16","0613","0","0","27","551","","HASHIRU MOHAMMED SAIDU","07063365628","","","","M","1","Nigerian","2","8","1992","single","","","","hashirusaidu200@gmail.com","","LAVUN","07063365628","","TUNGA MINNA OFF BAY CLINIC ROAD ","","","Normal","O","None","","1","0","0","197.210.227.50","2019-06-01 13:14:13","2019-06-01 13:27:59","","","","1","0000-00-00 00:00:00","2019-05-20 10:02:13","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("614","0","0","0","0","0","0","1","7","16","0614","0","0","27","557","","MIKAILU ISHAQ","08038372650","","","","M","1","Nigerian","12","4","1985","married","","","","angoaliyu76@yahoo.com","","PAIKORO","08038372650","","PAIKO DISTRICT NIGER STATE","","","Normal","B+","None","","1","0","0","197.210.227.93","2019-06-01 13:28:19","2019-06-01 13:31:07","","","","1","0000-00-00 00:00:00","2019-05-20 10:03:32","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("615","0","0","0","0","0","0","1","4","12","0615","0","0","27","541","","MOHAMMED YAHAYA YAKUBU","07035908940","","","","M","1","Nigerian","10","12","1990","married","","","","myyakub27@gmail.com","","BIDA","07035908940","","EMI ALHAJI NMA YAWO BANMA BIDA","","","Normal","A+","None","","1","1","0","105.112.120.101","2020-01-14 14:07:51","2019-06-01 13:33:05","","","","1","0000-00-00 00:00:00","2019-05-20 10:05:38","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("616","0","1","0","0","10","21","1","10","21","0616","0","0","27","544","","ADEJUMO BLESSING ADA","08136279666","","","","F","2","Nigerian","4","12","1980","married","","","","blessingada28@gmail.com","","CHANCHAGA","08136279666","","GBEGANU AREA ALONG BIDA ROAD MINNA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 14:09:01","2020-01-16 14:09:11","","","","1","0000-00-00 00:00:00","2019-05-20 10:07:27","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0379","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("617","0","1","0","0","4","12","1","4","12","0617","0","0","27","550","","ALIYU MOHAMMED ANGULU","08032814653","","","","M","1","Nigerian","25","10","1982","married","","","","amohammedangulu@gmail.com","","LAPAI","08032814653","","HOUSE NO 309 OPPOSITE CENTRAL HOSPITAL ROAD MINN","","","Normal","O","None","","1","0","0","105.112.112.20","2020-01-28 16:18:35","2020-01-28 16:19:00","","","","1","0000-00-00 00:00:00","2019-05-20 10:09:11","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0542","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("618","0","0","0","0","0","0","1","10","21","0618","0","0","27","558","","JOSEPH BULUS","07063860648","","","","M","2","Nigerian","5","10","1996","single","","","","josephbulus4me@gmail.com","","RAFI","07063860648","","SABON TASHAN USHIBA KAGARA RAFI LGA","","","Normal","B+","None","","1","0","0","197.210.226.17","2019-06-01 13:38:28","2019-06-01 13:39:02","","","","1","0000-00-00 00:00:00","2019-05-20 10:10:15","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("619","0","0","0","0","0","0","1","7","16","0619","0","0","27","547","","AMINA HARUNA","08165770966","","","","F","1","Nigerian","5","7","1992","single","","","","angoaliyu76@yahoo.com","","GURARA","08165770966","","ALLAH DEY CHANCHAGA ANGUWAN GWARI","","","Normal","O","None","","1","0","0","197.210.227.227","2019-06-01 13:39:14","2019-06-01 13:40:46","","","","1","0000-00-00 00:00:00","2019-05-20 10:11:09","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("620","0","1","0","0","10","21","1","10","21","0620","0","0","27","563","","UMAR B. BASHIR","08067410019","","","","M","1","Nigerian","1","6","1984","married","","","","bashirumar14@gmail.com","","WUSHISHI","08067410019","","NO. 6 BACK OF IMMIGRATION QTRS ANGUWAN BIRI MINNA","","","Normal","A+","None","","1","0","0","197.210.226.199","2020-01-06 21:10:43","2020-01-06 21:34:08","","","","1","0000-00-00 00:00:00","2019-05-20 10:13:09","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0299","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("621","0","1","0","0","10","21","1","10","21","0621","0","0","27","546","","BABA N. MARY","07063846604","","","","F","2","Nigerian","20","3","1984","married","","","","enockjiya@gmail.com","","GBAKO","07063846604","","DATI SHABA KOLO PO BOX 264 BIDA","","","Normal","O","None","","1","0","0","197.210.227.227","2019-06-01 13:41:56","2019-06-01 13:43:15","","","","1","0000-00-00 00:00:00","2019-05-20 10:14:15","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("622","0","1","0","0","4","4","1","4","4","0622","0","0","27","555","","MOHAMMED YUSUF","07033680146","","","","M","1","Nigerian","22","11","1996","married","","","","yusufmohammed993@gmail.com","","MOKWA","07033680146","","HAKIMI HOUSE GUNUBA MOKWA","","","Normal","A+","None","","1","0","0","197.210.226.91","2019-06-01 13:43:29","2019-06-01 13:44:32","","","","1","0000-00-00 00:00:00","2019-05-20 10:15:43","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("623","0","1","0","0","4","13","1","4","13","0623","0","0","27","556","","DANIEL JOHN","08032054488","","","","M","2","Nigerian","17","2","1983","married","","","","jikadanieljohn@gmail.com","","MUNYA","08032054488","","BARIKIN SALE MINNA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 11:28:26","2020-01-16 11:28:37","","","","1","0000-00-00 00:00:00","2019-05-20 10:17:21","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0060","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("624","0","1","0","0","2","14","1","2","14","0624","0","0","27","557","","AUDU SA\'ADATU","08073502210","","","","F","1","Nigerian","22","5","1983","married","","","","angoaliyu76@yahoo.com","","PAIKORO","08073502210","","BEHIND BAPTIST CHURCH WADATA PAIKO","","","Normal","O","None","","1","0","0","197.210.60.119","2020-01-03 11:23:31","2020-01-03 11:24:12","","","","1","0000-00-00 00:00:00","2019-05-20 10:18:05","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0455","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("625","0","0","0","0","0","0","1","1","10","0625","0","0","27","557","","IBRAHIM SALAMAT O.","07018459046","","","","F","1","Nigerian","8","12","1992","married","","","","rambasone@gmail.com","","PAIKORO","07018459046","","LINE F212 TUNGA LOWCOST MINNA","","","Normal","O","None","","1","0","0","197.210.55.200","2019-06-03 10:42:57","2019-06-03 10:43:42","","","","1","0000-00-00 00:00:00","2019-05-20 10:19:05","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("626","0","0","0","0","0","0","1","4","13","0626","0","0","27","548","","MAMMAN MARY","08035862467","","","","F","2","Nigerian","25","12","1973","married","","","","angoaliyu76@yahoo.com","","KATCHA","08035862467","","SACHI VIA ARMY BARRACK BIDA","","","Normal","O","None","","1","0","0","197.210.54.158","2019-06-03 10:43:57","2019-06-03 10:44:38","","","","1","0000-00-00 00:00:00","2019-05-20 10:20:00","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("627","0","1","0","0","7","16","1","7","16","0627","0","0","27","541","","HASSAN DANLADI IDRIS","08036108507","","","","M","1","Nigerian","27","4","1964","married","","","","angoaliyu76@yahoo.com","","BIDA","08036108507","","GENERAL MI WUSHISHI HOUSING ESTATE MINNA","","","Normal","O","None","","1","0","0","197.210.28.222","2019-11-09 12:59:39","2019-11-09 12:59:55","","","","1","0000-00-00 00:00:00","2019-05-20 10:21:07","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0052","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("628","0","1","0","0","2","15","1","2","15","0628","0","0","27","539","","HADIZA SANI KANGIWA","08037904356","","","","F","1","Nigerian","25","12","1976","married","","","","angoaliyu76@yahoo.com","","AGAIE","08037904356","","OKADA ROAD ALH. MUSA ZAGO RESIDENCE","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 13:24:52","2020-01-16 13:25:53","","","","1","0000-00-00 00:00:00","2019-05-20 10:22:08","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0064","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("629","0","1","0","0","2","14","1","2","14","0629","0","0","27","544","","IDRIS SALIHU","08061688550","","","","M","1","Nigerian","12","6","1988","married","","","","idrisshanu100@gmail.com","","CHANCHAGA","08061688550","","MOHAMMED TECHNO ROAD F/LAYOUT MINNA","","","Normal","B+","None","","1","0","0","197.210.60.119","2020-01-03 11:24:25","2020-01-03 11:25:10","","","","1","0000-00-00 00:00:00","2019-05-20 10:23:19","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-15 14:39:54","0539","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("630","0","1","0","0","7","16","1","7","16","0630","0","0","27","544","","MOHAMMED BALA SADIQ ABUBAKAR","08033747372","","","","M","1","Nigerian","9","11","1977","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08033747372","","NID 61C OFF MASALACI ROAD TUNGA MINNA","","","Normal","A+","None","","1","1","0","105.112.113.12","2019-09-22 22:14:02","2019-06-03 10:50:44","","","","1","0000-00-00 00:00:00","2019-05-20 10:24:50","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0063","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("631","0","1","0","0","2","14","1","2","14","0631","0","0","27","555","","ADAMU ADAMU USMAN","08037831999","","","","M","1","Nigerian","13","3","1993","single","","","","yngbarrister7312@gmail.com","","MOKWA","08037831999","","NO. 1 ALIYU BABA DOKO STREET TUNGA MINNA","","","Normal","A+","None","","1","0","0","105.112.115.177","2020-01-16 13:17:55","2020-01-16 13:18:38","","","","1","0000-00-00 00:00:00","2019-05-20 10:26:23","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-12-18 16:50:48","0008","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("632","0","1","0","0","10","21","1","10","21","0632","0","0","27","549","","HAMIDU UMAR","07036939550","","","","M","1","Nigerian","10","5","1991","married","","","","umarhamidu190@mail.com","","KONTAGORA","07036939550","","TUNGA FARM CENTER  ZONE E29 MINNA","","","Normal","O","None","","1","1","0","197.210.70.15","2020-02-04 17:42:22","2020-02-03 19:38:14","","","","1","0000-00-00 00:00:00","2019-05-20 10:27:27","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2020-02-21 13:48:58","0625","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("633","0","1","0","0","7","5","1","7","5","0633","0","0","27","560","","ZAINAB G. ABUBAKAR","07063154265","","","2020-01-31-165325ZAINAB DOC.pdf.pdf","F","1","Nigerian","10","11","1995","married","","","","zeebang155@gmail.com","","SHIRORO","07063154265","","SKP 156 KUTA ROAD MINNA","","2020-01-31-165728.jpg","Normal","O","None","","1","1","0","105.112.112.38","2020-01-31 16:52:32","2020-01-31 16:51:18","","","","1","0000-00-00 00:00:00","2019-05-20 10:29:08","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0119","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("634","0","0","0","0","0","0","1","2","14","0634","0","0","27","539","","ISAH T. ISAH","08136654587","","","","M","1","Nigerian","14","9","1990","married","","","","isahisah199@gmail.com","","AGAIE","08136654587","","BEHIND IMANI HOSPITAL MINNA SHIRORO TRAFFIC JUNCTION MINNA","","","Normal","B+","None","","1","1","0","105.112.114.125","2019-11-26 08:04:22","2019-11-15 12:10:47","","","","1","0000-00-00 00:00:00","2019-05-20 10:31:08","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("635","0","1","0","0","9","6","1","9","6","0635","0","0","27","557","","ASHIRU S. MOHAMMED","08065426613","","","","M","1","Nigerian","17","6","1993","married","","","","angoaliyu76@yahoo.com","","PAIKORO","08065426613","","LODNAGBE VIA PAIKO","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 14:51:49","2020-01-16 14:51:58","","","","1","0000-00-00 00:00:00","2019-05-20 10:33:16","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0266","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("636","0","1","0","0","7","5","1","7","5","0636","0","0","27","544","","JAMILA ABDULLAHI YUNUSA","08167140198","","","","F","1","Nigerian","7","8","1993","single","","","","jamilayunusa10@gmail.com","","CHANCHAGA","08167140198","","FADIKPE","","","Normal","B+","None","","1","0","0","197.210.60.119","2020-01-03 11:43:31","2020-01-03 11:44:02","","","","1","0000-00-00 00:00:00","2019-05-20 10:36:36","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0576","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("637","0","1","0","0","4","4","1","4","4","0637","0","0","5","107","","HASSAN RUTH MAKANIKI","08065124567","","","","F","1","Nigerian","28","8","1995","single","","","","ruthh0686@gmail.com","","TAFAWA BALEWA","08065124567","","HOUSE ZONE F 69 FARM CENTER TUNGA MINNA","","","Normal","O","None","","1","0","0","197.210.55.166","2019-06-03 11:01:12","2019-06-03 11:01:39","","","","1","0000-00-00 00:00:00","2019-05-20 10:37:45","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("638","0","0","0","0","0","0","1","4","13","0638","0","0","27","560","","ISAH ADAMU ","09032026204","","","","M","1","Nigerian","7","3","1985","married","","","","angoaliyu76@yahoo.com","","SHIRORO","09032026204","","KUTA","","","Normal","O","None","","1","0","0","197.210.55.166","2019-06-03 11:01:47","2019-06-03 11:02:33","","","","1","0000-00-00 00:00:00","2019-05-20 10:39:07","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("639","0","0","0","0","0","0","1","10","21","0639","0","0","27","557","","NDAGIWA MUSTAPHA","07051318477","","","","M","1","Nigerian","1","1","1997","married","","","","angoaliyu76@yahoo.com","","PAIKORO","07051318477","","NAGOPITA","","","Normal","A+","None","","1","0","0","197.210.57.87","2019-06-18 11:39:17","2019-06-18 11:42:51","","","","1","0000-00-00 00:00:00","2019-05-20 10:40:31","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("640","0","0","0","0","0","0","1","1","11","0640","0","0","24","495","","Akanni Kehinde Yusuf","08060251003","","","2019-05-20-115301A.K YUSUF CREDENTIALS.pdf.pdf","M","1","Nigerian","16","9","1992","single","","","","yruffai@gmail.com","","Minna","08060251003","","No72 Niteco Road, Tunga Minna
\nOld Alheri street","No72 Niteco Road, Tunga Minna
\nOld Alheri street","2019-05-20-110251.jpg","Normal","A+","None","","1","1","0","105.112.114.208","2020-02-06 13:47:58","2020-02-06 13:47:50","","","","0","0000-00-00 00:00:00","2019-05-20 10:50:58","0000-00-00 00:00:00","","","Rufai Akanni","08164808355","No72 Niteco Road, Tunga Minna
\nOld Alheri street","Father","2","Rufai Akanni","No72 Niteco Road, Tunga Minna
\nOld Alheri street","0","","0","0000-00-00 00:00:00","","3","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("641","0","0","0","0","0","0","1","10","20","0641","0","0","27","541","","MOHAMMED YAHAYA","08038888021","","","2019-05-20-112647MOHAMMED YAHAYA IBB DOCUMENTS.pdf.pdf","M","1","Nigerian","17","9","1997","married","","","","ym8631181@gmail.com","","BIDA","08038888021","","EMI ALHAJI ALFA POPULATION, BANGAIE AREA BIDA, NIGER STATE","EMI ALHAJI ALFA POPULATION, BANGAIE AREA BIDA, NIGER STATE","2019-05-20-110532.jpg","Normal","B+","None","NIL","1","0","0","41.190.12.77","2019-05-20 10:55:08","2019-05-20 11:56:08","","","","0","0000-00-00 00:00:00","2019-05-20 10:54:37","0000-00-00 00:00:00","","","DR. MUSTAPHA YAHAYA MAKANTA","08036341183","GENERAL HOSPITAL, MINNA","UNCLE","3","MUSTAPHA YAHAYA MAKANTA","GENERAL HOSPITAL, MINNA","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("642","0","1","0","0","10","20","1","10","20","0642","0","0","27","541","","mohammed ibrahim lawal","08091101809","","","2019-06-17-140733MOHA,D1 001.pdf.pdf","M","1","Nigerian","22","2","1996","single","","","","ithjay001@gmail.com","","WUSE ABUJA","08091101809","","SSQ9B FED,STAFF QUARTERS BARNAWA KADUNA SSQ9B","SSQ9B FED,STAFF QUARTERS BARNAWA KADUNA SSQ9B","2019-05-21-121356.jpg","Normal","O","None","NORMAL","1","1","0","41.190.12.162","2019-11-17 12:46:48","2019-11-06 14:55:38","","","","1","0000-00-00 00:00:00","2019-05-20 11:31:42","0000-00-00 00:00:00","","","ALHAJI IBRAHIM MUHAMMAD","08033229588","SSQ9B FED,STAFF QUARTERS BARNAWA KADUNA SSQ9B","FATHER","1","MOHAMMED IBRAHIM","SSQ9B FED,STAFF QUARTERS BARNAWA KADUNA SSQ9B","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0303","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("643","0","0","0","0","0","0","1","10","21","0643","0","0","0","0","","Rabiatu Yahaya","","","","","","0","","","","","","","","","muhammadkenchi@gmail.com","","","08069648804","","","","","","","","","1","1","0","105.112.113.43","2019-05-20 16:41:39","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-05-20 16:40:17","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("644","0","0","0","0","0","0","1","10","20","0644","0","0","0","0","","Isma\'il Isah","","","","2019-06-10-155953nnpc_recruitment_candidate_info190314121907.pdf.pdf","","0","","","","","","","","","ismailisah3030@gmail.com","","","07065514827","","","","2019-05-21-202720.jpg","","","","","1","1","0","197.211.57.129","2019-06-10 15:45:11","2019-06-07 16:18:26","","","","0","0000-00-00 00:00:00","2019-05-20 17:18:08","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("645","0","0","0","0","0","0","1","1","10","0645","0","0","0","0","","Salamatu Idris Alfa ","","","","","","0","","","","","","","","","ndatsuidrisu@yahoo.com","","","08032356261","","","","","","","","","1","0","0","197.210.52.11","2019-05-20 18:34:19","2019-05-20 18:37:09","","","","0","0000-00-00 00:00:00","2019-05-20 18:32:55","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("646","0","1","0","0","1","11","1","2","15","0646","0","0","27","545","","ADAMU MOHAMMED YAHAYA","08038895665","","","","M","1","Nigerian","10","4","1983","married","","","","Hamzaemjay14@gmail.com","","Minna","08038895665","","House No3 Dusten Kuran Hausa off Okada Road Minna,  Niger State","House No3 Dusten Kuran Hausa off Okada Road Minna,  Niger State","2019-10-03-062014.jpg","Normal","O","None","Good","1","0","0","105.112.112.20","2020-01-28 15:57:02","2020-01-28 15:57:38","","","","1","0000-00-00 00:00:00","2019-05-20 22:33:32","0000-00-00 00:00:00","","","Kasim Moh\'d ","08033738207","House No3 Dusten Kuran Hausa off Okada Road Minna,  Niger State","Brother","1","Self","House No3 Dusten Kuran Hausa off Okada Road Minna,  Niger State","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2019-11-27 12:18:37","0480","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("647","0","1","0","0","9","18","1","9","18","0647","0","0","27","550","","USMAN FATI ASABE","08037333001","","","","F","1","Nigerian","2","2","1975","married","","","","angoaliyu76@yahoo.com","","LAPAI","08037333001","","PLOT 5719 LONDON STREET DUTSEN KURA MINNA","","2019-09-25-130613.jpg","Normal","B+","None","","1","0","0","105.112.115.177","2020-01-16 14:42:07","2020-01-16 14:42:17","","","","1","0000-00-00 00:00:00","2019-05-21 09:24:26","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0137","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("648","0","1","0","0","2","14","1","2","14","0648","0","0","27","543","","MARKUS YAKUBU","09034243497","","","","M","2","Nigerian","3","2","1995","married","","","","markusyakubu2000@gmail.com","","BOSSO","09034243497","","BUKPE GIDAN KINANU ALONG BIDA ROAD MINNA","","","Normal","O","None","","1","0","0","105.112.112.20","2020-01-28 16:21:16","2020-01-28 16:21:27","","","","1","0000-00-00 00:00:00","2019-05-21 09:25:57","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0201","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("649","0","0","0","0","0","0","1","2","14","0649","0","0","27","543","","ALIYU IBRAHIM","08136032685","","","","M","1","Nigerian","5","5","1992","single","","","","superb3422@gmail.com","","BOSSO","08136032685","","CHANCHAGA ANGUWAN GHANA BLOCK NO 132","","","Normal","B+","None","","1","0","0","105.112.115.177","2020-01-16 11:41:59","2020-01-16 11:43:27","","","","1","0000-00-00 00:00:00","2019-05-21 09:27:23","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("650","0","1","0","0","4","13","1","4","13","0650","0","0","27","560","","ABDULLAHI DANJUMA MOHAMMED","08066559117","","","","M","1","Nigerian","28","2","1967","married","","","","angoaliyu76@yahoo.com","","SHIRORO","08066559117","","HOUSE NO 71 ABATTOIR ROAD TAYI BEHIND BAHAGO SECONDARY SCHOOL TAYI ","","","Normal","O","None","","1","0","0","105.112.117.56","2020-02-17 11:24:13","2020-02-17 11:24:34","","","","1","0000-00-00 00:00:00","2019-05-21 09:28:46","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0200","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("651","0","1","0","0","10","21","1","10","21","0651","0","0","27","541","","USMAN ADAMA","07031106700","","","","F","1","Nigerian","14","5","1990","single","","","","angoaliyu76@yahoo.com","","BIDA","07031106700","","SAUKA KAHUTA OPPOSITE GARIMA MINNA","","","Normal","O","None","","1","0","0","197.210.60.119","2020-01-03 12:13:18","2020-01-03 12:13:54","","","","1","0000-00-00 00:00:00","2019-05-21 09:29:44","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0397","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("652","0","1","0","0","4","12","1","4","12","0652","0","0","14","265","","OKIKE EVELYN CHIZOBA","08168907326","","","","F","2","Nigerian","10","12","1995","single","","","","angoaliyu76@yahoo.com","","IGBO ETITI","08168907326","","AKU TOWN, ETITI LGA","","","Normal","O","None","","1","0","0","105.112.112.20","2020-01-28 16:04:14","2020-01-28 16:05:00","","","","1","0000-00-00 00:00:00","2019-05-21 09:31:01","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0283","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("653","0","1","0","0","10","21","1","1","10","0653","0","0","27","551","","ALIYU MOHAMMED","08134530600","","","","M","1","Nigerian","26","7","1992","married","","","","mohammedaliyu4040@mail.com","","LAVUN","08134530600","","EMITSU NCRI BADEGGI KATCHA LGA","","","Normal","O","None","","1","0","0","197.210.227.234","2020-02-20 13:42:06","2020-02-20 13:49:30","","","","1","0000-00-00 00:00:00","2019-05-21 09:32:17","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                                                 
\n                                ","3","2020-02-20 13:43:57","0603","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("654","0","1","0","0","2","14","1","2","14","0654","0","0","27","549","","ABUBAKAR RAMATU ALHAJI","07030389265","","","","F","1","Nigerian","19","7","1989","single","","","","rahamatabubakar7@gmail.com","","KONTAGORA","07030389265","","GARKI AREA 1 SECTION 2 BLOCK 11 FLAT 1 KANO STREET ABUJA","","","Normal","A+","None","","1","0","0","197.210.70.15","2020-02-04 17:26:22","2020-02-04 17:27:38","","","","1","0000-00-00 00:00:00","2019-05-21 09:33:37","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-12-10 14:57:31","0674","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("655","0","1","0","0","1","10","1","2","14","0655","0","0","27","549","","FARIDA GAMBO","08060834947","","","","F","1","Nigerian","7","7","1982","single","","","","fgambo450@gmail.com","","KONTAGORA","08060834947","","NO 1 NIGER STATE OF ASS QTRS MINNA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 11:07:07","2020-01-16 11:07:46","","","","1","0000-00-00 00:00:00","2019-05-21 09:35:00","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0425","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("656","0","1","0","0","2","15","1","2","15","0656","0","0","30","615","","KARIM SHADE","08036621296","","","","F","2","Nigerian","26","11","1994","single","","","","karimshade94@gmail.com","","EJIGBO ","08036621296","","NO 72 FLAT 6 FOUGEROLLE LIFE CAMP 1 AJAOKUTA KOGI STATE","","","Normal","B+","None","","1","0","0","197.210.227.234","2020-02-20 13:41:41","2020-02-20 13:41:53","","","","1","0000-00-00 00:00:00","2019-05-21 09:36:29","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("657","0","1","0","0","7","5","1","2","14","0657","0","0","27","549","","BELLO IBRAHIM MOHAMMED","07034818103","","","","M","1","Nigerian","29","11","1990","married","","","","angoaliyu76@yahoo.com","","KONTAGORA","07034818103","","DAVID MARK ROAD TUNGA MINNA","","","Normal","O","None","","1","0","0","41.190.14.144","2020-02-12 10:10:24","2020-02-12 10:11:27","","","","1","0000-00-00 00:00:00","2019-05-21 09:37:26","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2019-12-13 10:33:02","0492","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("658","0","1","0","0","4","13","1","4","13","0658","0","0","27","550","","UMAR ABUBAKAR TAKA","08068698484","","","","M","1","Nigerian","13","7","1979","married","","","","sadeeqalwayz@gmail.com","","LAPAI","08068698484","","K49 IBRAHIM ROAD LAPAI","","","Normal","A+","None","","1","1","0","197.210.71.125","2020-01-21 13:30:06","2020-01-03 10:28:25","","","","1","0000-00-00 00:00:00","2019-05-21 09:38:35","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-20 13:33:07","0591","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("659","0","0","0","0","0","0","1","4","12","0659","0","0","27","551","","ZHITSU SABA","08139394908","","","","M","1","Nigerian","2","1","1993","married","","","","zhitsu4all@gmail.com","","lavun","08139394908","","NDASUASUN HOUSE, NTIFIN AREA DANCHITAGI","","","Normal","B+","None","","1","0","0","197.210.54.101","2019-06-03 11:24:43","2019-06-03 11:25:27","","","","1","0000-00-00 00:00:00","2019-05-21 09:40:02","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("660","0","1","0","0","7","16","1","7","16","0660","0","0","27","554","","JIYA AISHA IDRIS","08094576155","","","","F","1","Nigerian","23","9","1992","married","","","","jiyaaisha27@gmail.com","","MASHEGU","08094576155","","NO 2 MUNDI YUSUF CRESENT OFF NITECO ROAD TUNGA MINNA","","","Normal","O","None","","1","0","0","105.112.120.40","2019-12-02 14:21:22","2019-12-02 14:49:15","","","","1","0000-00-00 00:00:00","2019-05-21 09:41:16","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0646","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("661","0","1","0","0","2","14","1","2","14","0661","0","0","27","550","","IBRAHIM MUSA MOHAMMED","08089376335","","","","M","1","Nigerian","1","1","1977","married","","","","angoaliyu76@yahoo.com","","LAPAI","08089376335","","SHAKU, LAPAI LGA","","","Normal","A+","None","","1","0","0","197.210.85.77","2020-02-08 15:43:41","2020-02-08 15:44:51","","","","1","0000-00-00 00:00:00","2019-05-21 09:42:20","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0433","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("662","0","0","0","0","0","0","1","4","13","0662","0","0","28","583","","FOLAKE LYDIA WILLIAMS","08036614945","","","","F","2","Nigerian","14","7","1980","married","","","","angoaliyu76@yahoo.com","","SHAGAMU","08036614945","","NKANGBE BEHIND NKANGBE PRIMARY SCHOOL","","","Normal","O","None","","1","0","0","197.210.55.222","2019-06-03 11:27:19","2019-06-03 11:28:13","","","","1","0000-00-00 00:00:00","2019-05-21 09:43:30","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("663","0","0","0","0","0","0","1","2","14","0663","0","0","27","550","","USMAN ADAMU MUYE","07036911313","","","","M","1","Nigerian","15","6","1993","single","","","","adamuusman785@gmail.com","","LAPAI","07036911313","","OPPOSITE AHK TABLE WATER LAPAI","","","Normal","O","None","","1","0","0","197.210.55.222","2019-06-03 11:28:26","2019-06-03 11:29:45","","","","1","0000-00-00 00:00:00","2019-05-21 09:45:35","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("664","0","1","0","0","1","11","1","1","11","0664","0","0","27","541","","YUNUSA MOHAMMED NASIR","09036352570","","","","M","1","Nigerian","22","3","1975","married","","","","angoaliyu76@yahoo.com","","BIDA","09036352570","","NO 205 SHEHU AHMADU KATCHA ROAD TUNGA OFF NITECO ROAD TUNGA MINNA","","","Normal","O","None","","1","1","0","105.112.122.95","2020-01-15 12:05:32","2019-06-03 11:30:35","","","","1","0000-00-00 00:00:00","2019-05-21 09:46:54","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0032","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("665","0","0","0","0","0","0","1","1","11","0665","0","0","27","558","","SULEIMAN JIBRIN SANI","08139185154","","","","M","1","Nigerian","12","1","1968","married","","","","angoaliyu76@yahoo.com","","RAFI","08139185154","","RAFI LGA","","","Normal","AB","None","","1","0","0","197.210.55.215","2019-06-03 11:30:48","2019-06-03 11:31:21","","","","1","0000-00-00 00:00:00","2019-05-21 09:48:14","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("666","0","1","0","0","2","2","1","2","2","0666","0","0","27","541","","MOHAMMED RUKAYAT","09033027954","","","","F","1","Nigerian","24","12","1992","married","","","","myrukayyate@gmail.com","","BIDA","09033027954","","MULTI BUILDERS QTRS BOSSO ESTATE MINNA","","","Normal","O","None","","1","0","0","197.210.65.251","2020-01-02 20:53:45","2020-01-02 20:54:23","","","","1","0000-00-00 00:00:00","2019-05-21 09:49:49","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0082","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("667","0","1","0","0","10","21","1","10","21","0667","0","0","27","544","","YUSUF IBRAHIM","08053442008","","","","M","1","Nigerian","25","5","1985","married","","","","jeges7@gmail.com","","CHANCHAGA","08053442008","","SW 381 KETEREN GWARI MINNA","","","Normal","O","None","","1","0","0","197.210.45.38","2020-01-03 13:47:35","2020-01-03 13:48:05","","","","1","0000-00-00 00:00:00","2019-05-21 09:51:20","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-18 18:28:17","0573","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("668","0","1","0","0","2","15","1","2","15","0668","0","0","27","544","","YUNUSA KABIR","08038098686","","","","M","1","Nigerian","27","6","1969","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08038098686","","NE 143 STADIUM ROAD MINNA","","","Normal","O","None","","1","0","0","197.210.85.64","2020-02-19 14:10:52","2020-02-19 14:12:23","","","","1","0000-00-00 00:00:00","2019-05-21 09:52:17","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                                                 
\n                                ","3","2020-02-17 17:52:35","0197","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("669","0","1","0","0","4","12","1","4","12","0669","0","0","27","547","","AUTA FRIDAY","07081568399","","","","M","2","Nigerian","4","5","1993","single","","","","autafriday@yahoo.com","","GURARA","07081568399","","NO 184 BOSSO LOW COST MINNA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 11:33:33","2020-01-16 11:33:40","","","","1","0000-00-00 00:00:00","2019-05-21 09:53:30","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0269","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("670","0","1","0","0","10","22","1","7","16","0670","0","0","27","550","","ADAMU MARYAM","07031898432","","","","F","1","Nigerian","12","4","1989","married","","","","maryamgodadi@gmail.com","","LAPAI","07031898432","","NO MORRIS ","","","Normal","O","None","","1","0","0","197.210.226.205","2020-02-05 15:10:57","2020-02-05 15:12:10","","","","1","0000-00-00 00:00:00","2019-05-21 09:55:16","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0373","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("671","0","1","0","0","4","12","1","4","12","0671","0","0","27","549","","MUHAMMAD BALKISU BAWA","08032492866","","","","F","1","Nigerian","22","9","1986","married","","","","angoaliyu76@yahoo.com","","KONTAGORA","08032492866","","TUNGA OFF NITECO ROAD MINNA","","","Normal","B+","None","","1","0","0","105.112.115.177","2020-01-16 11:27:48","2020-01-16 11:27:59","","","","1","0000-00-00 00:00:00","2019-05-21 10:06:16","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0099","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("672","0","0","0","0","0","0","1","2","15","0672","0","0","27","560","","GARBA MUSA KUTA","09038994717","","","","M","1","Nigerian","1","4","1978","single","","","","angoaliyu76@yahoo.com","","SHIRORO","09038994717","","NO 2 DR. MUNDI YUSUF CRESCENT OFF NITECO ROAD TUDUN WADA MINNA","","","Normal","B+","None","","1","0","0","197.210.55.222","2019-06-03 11:35:58","2019-06-03 11:36:35","","","","1","0000-00-00 00:00:00","2019-05-21 10:07:41","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("673","0","0","0","0","0","0","1","7","5","0673","0","0","27","541","","SONGUBI MOHAMMED ALHAJI","07035108383","","","","M","1","Nigerian","7","8","1985","married","","","","mohammedsongubi@gmail.com","","BIDA","07035108383","","EMI MAYAKI DANGANA ANNI BANWUYA AREA BIDA","","","Normal","O","None","","1","0","0","197.210.55.222","2019-06-03 11:36:45","2019-06-03 11:37:10","","","","1","0000-00-00 00:00:00","2019-05-21 10:09:27","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("674","0","1","0","0","1","11","1","1","11","0674","0","0","27","553","","YAHI BABANGIDA","07032700395","","","","M","1","Nigerian","11","6","1973","married","","","","babangidayahi@gmail.com","","MARIGA","07032700395","","UNGUWAN NASARAWA KONTAGORA","","","Normal","B+","None","","1","0","0","197.210.85.77","2020-02-08 15:24:24","2020-02-08 15:26:00","","","","1","0000-00-00 00:00:00","2019-05-21 10:11:33","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2020-01-27 13:10:19","0039","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("675","0","1","0","0","2","15","1","2","15","0675","0","0","27","555","","NDAGI AMINA","07039528909","","","","F","1","Nigerian","3","1","1984","married","","","","angoaliyu76@yahoo.com","","MOKWA","07039528909","","BESIDE BYE WATER MOKWA","","","Normal","B+","None","","1","0","0","105.112.112.20","2020-01-28 16:09:24","2020-01-28 16:09:35","","","","1","0000-00-00 00:00:00","2019-05-21 10:12:48","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0468","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("676","0","1","0","0","2","14","1","2","14","0676","0","0","27","551","","FATIMA LADAN","08064176449","","","","F","1","Nigerian","29","10","1990","married","","","","angoaliyu76@yahoo.com","","LAVUN","08064176449","","HOUSE NO 153 BOSSO LOW COST","","","Normal","O","None","","1","0","0","197.210.45.38","2020-01-03 14:40:06","2020-01-03 14:40:42","","","","1","0000-00-00 00:00:00","2019-05-21 10:14:08","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0277","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("677","0","0","0","0","0","0","1","2","14","0677","0","0","27","544","","GUNDUMA ASIBI","08063954706","","","","F","1","Nigerian","15","12","1977","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08063954706","","BACK OF MAI ANGUWA RESIDENCE BARIKIN SALE MINNA","","","Normal","AB","None","","1","0","0","197.210.55.222","2019-06-03 11:42:53","2019-06-03 11:43:53","","","","1","0000-00-00 00:00:00","2019-05-21 10:16:03","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("678","0","1","0","0","10","20","1","10","20","0678","0","0","27","544","","ABDULRAHMAN TALATU","07031654627","","","","F","1","Nigerian","4","4","1969","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","07031654627","","BRIGHTER QTRS BEHIND NECO STAFF  QTRS MINNA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 14:27:18","2020-01-16 14:31:07","","","","1","0000-00-00 00:00:00","2019-05-21 10:17:09","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","0000-00-00 00:00:00","0390","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("679","0","1","0","0","2","2","1","2","2","0679","0","0","27","557","","ISAH SAHABI","08175910053","","","","M","1","Nigerian","3","8","1998","single","","","","angoaliyu76@yahoo.com","","PAIKORO","08175910053","","GBADNA AREA PAIKO","","","Normal","O","None","","1","0","0","197.210.55.222","2019-06-03 11:45:41","2019-06-03 11:46:15","","","","1","0000-00-00 00:00:00","2019-05-21 10:18:10","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("680","0","1","0","0","4","12","1","4","12","0680","0","0","27","557","","LUKA JULIANA","08038045789","","","","F","2","Nigerian","3","7","1995","single","","","","lukajuliana31@gmail.com","","PAIKORO","08038045789","","NO 6 BAGUDU ROAD F LAYOUT BOSSO ROAD MINNA","","","Normal","O","None","","1","0","0","105.112.112.20","2020-01-28 16:05:52","2020-01-28 16:06:04","","","","1","0000-00-00 00:00:00","2019-05-21 10:19:41","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0142","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("681","0","1","0","0","10","21","1","10","21","0681","0","0","29","585","","OLASENI EZEKIEL LEKAN","08149232420","","","","M","2","Nigerian","5","8","1993","single","","","","laketunez@gmail.com","","AKOKO NW","08149232420","","OPPOSITE REDEEM CHURCH SAUKA KA HUTA MINNA","","","Normal","O","None","","1","0","0","105.112.112.20","2020-01-28 16:34:29","2020-01-28 16:34:47","","","","1","0000-00-00 00:00:00","2019-05-21 10:21:31","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0294","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("682","0","1","0","0","2","14","1","2","14","0682","0","0","27","558","","ABUBAKAR MUDASSIR KAYI","08091678171","","","","M","1","Nigerian","21","2","1995","single","","","","abumudassir019@yahoo.com","","RAFI","08091678171","","ANGUWAN LIMAN KAGARA","","","Normal","O","None","","1","0","0","105.112.117.154","2020-02-11 16:10:39","2020-02-11 16:20:57","","","","1","0000-00-00 00:00:00","2019-05-21 10:23:26","0000-00-00 00:00:00","","","HUSSAINI AHMED","08097062147","UNGUWAN LIMAN KAGARA","FATHER","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2020-02-11 16:10:11","0319","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("683","0","1","0","0","2","14","1","1","10","0683","0","0","27","539","","JIYA MOHAMMED BAHASANA","08060585474","","","","M","1","Nigerian","31","3","1972","married","","","","angoaliyu76@yahoo.com","","AGAIE","08060585474","","KPAKUNGU ALBISHIRI BIDA ROAD MINNA","","","Normal","B+","None","","1","0","0","197.210.85.194","2020-02-11 15:19:53","2020-02-11 15:49:32","","","","1","0000-00-00 00:00:00","2019-05-21 10:25:21","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2020-01-03 11:03:40","0141","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("684","0","1","0","0","4","13","1","4","13","0684","0","0","27","543","","AYUBA AUDU SHABA","08079900011","","","","M","1","Nigerian","15","3","1984","married","","","","ayubadshaba50@gmail.com","","BOSSO","08079900011","","SAUKA KA HUTA MINNA","","2019-10-07-162627.jpg","Normal","AB","None","","1","0","0","105.112.115.177","2020-01-16 11:32:52","2020-01-16 11:33:02","","","","1","0000-00-00 00:00:00","2019-05-21 10:26:32","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0250","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("685","0","0","0","0","0","0","1","11","24","0685","0","0","27","548","","BABA MOHAMMED","08069751359","","","2019-05-21-132300BABA MOHAMMED IBB DOCUMENTS.pdf.pdf","M","1","Nigerian","20","5","1991","married","","","","Babamohammed1239@gmail.com","","BIDA","08069751359","","EMI ALHAJI KATCHA KARAKO AREA BIDA, NIGER STATE","EMI ALHAJI KATCHA KARAKO AREA BIDA, NIGER STATE","2019-05-21-131030.jpg","Normal","B+","None","NIL","1","1","0","197.210.47.131","2019-10-29 09:13:12","2019-09-20 08:50:53","","","","1","0000-00-00 00:00:00","2019-05-21 13:06:52","0000-00-00 00:00:00","","","MOHAMMED ABDULLAHI","08060707179","EMI ALHAJI NMA PHOTO KARAKO AREA BIDA, NIGER STATE","FATHER","3","MOHAMMED ABDULLAHI","EMI ALHAJI NMA PHOTO KARAKO AREA BIDA, NIGER STATE","0","","0","0000-00-00 00:00:00","","2","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("686","0","0","0","0","0","0","1","11","23","0686","0","0","0","0","","IBRAHIM BAWA","","","","","","0","","","","","","","","","talk2ibrahimbawa2019@gmail.com","","","08079530054","","","","","","","","","1","0","0","197.210.28.13","2019-05-21 16:17:51","2019-05-21 16:18:41","","","","0","0000-00-00 00:00:00","2019-05-21 16:16:45","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("687","0","1","0","0","10","20","1","10","20","0687","0","0","27","551","","IBRAHIM AISHA PANTI","07032827173","","","","F","1","Nigerian","20","11","1997","married","","","","aishapantee@gmail.com","","LAVUN","07032827173","","NO. 27 BOSSO LOWCOST MINNA","","","Normal","B+","None","","1","0","0","197.210.55.222","2019-06-03 11:57:38","2019-06-03 11:58:21","","","","1","0000-00-00 00:00:00","2019-05-23 09:11:40","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("688","0","1","0","0","2","2","1","2","2","0688","0","0","27","549","","ABUBAKAR SAFIYA BUDA","08065612831","","","","F","1","Nigerian","25","5","1990","married","","","","angoaliyu76@yahoo.com","","KONTAGORA","08065612831","","TUNGA FARM CENTER MINNA","","","Normal","A+","None","","1","0","0","197.210.60.119","2020-01-03 10:07:58","2020-01-03 10:08:37","","","","1","0000-00-00 00:00:00","2019-05-23 09:12:59","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0291","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("689","0","1","0","0","2","14","1","2","2","0689","0","0","27","544","","SABO MARYAM","07038082245","","","","F","1","Nigerian","22","8","1982","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","07038082245","","NO. 6 DARUSSALAM WESTERN BYE PASS MINNA","","","Normal","O","None","","1","0","0","197.210.57.24","2020-02-12 17:27:47","2020-02-12 17:28:38","","","","1","0000-00-00 00:00:00","2019-05-23 09:14:07","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2020-02-12 16:57:02","0489","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("690","0","0","0","0","0","0","1","2","2","0690","0","0","23","485","","YAHAYA FATIMA","08034207774","","","","F","1","Nigerian","26","1","1986","married","","","","adokene2010@gmail.com","","OKENE","08034207774","","BEHIND SOLEK FILLING STATION, EASTERN BYE PASS MINNA","","","Normal","B+","None","","1","0","0","197.210.54.31","2019-06-03 12:01:00","2019-06-03 12:01:27","","","","1","0000-00-00 00:00:00","2019-05-23 09:15:16","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("691","0","0","0","0","0","0","1","2","14","0691","0","0","27","554","","MOHAMMAD FATIMA DAJA","08103704865","","","","F","1","Nigerian","13","3","1996","married","","","","fatimadaja65@gmail.com","","MASHEGU","08103704865","","CHANCHAGA KOROKPAN","","","Normal","O","None","","1","0","0","197.210.55.215","2019-06-03 12:01:38","2019-06-03 12:02:10","","","","1","0000-00-00 00:00:00","2019-05-23 09:16:38","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("692","0","1","0","0","2","2","1","2","2","0692","0","0","27","557","","SALIHU ISMAILA","08105627459","","","","M","1","Nigerian","23","8","1999","single","","","","angoaliyu76@yahoo.com","","PAIKORO","08105627459","","KANJERE OPP PROJECT PRIMARY SCHOOL","","","Normal","B+","None","","1","0","0","197.210.70.15","2020-02-04 17:27:44","2020-02-04 17:29:06","","","","1","0000-00-00 00:00:00","2019-05-23 09:17:36","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0276","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("693","0","1","0","0","2","14","1","2","14","0693","0","0","27","547","","ISTIFANUS SARAH MAKSAT","08057565880","","","","F","2","Nigerian","14","5","1987","married","","","","sundayaliyu@gmail.com","","GURARA","08057565880","","MADAKI STREET ANGWAN TUKURA BOSSO","","","Normal","O","None","","1","0","0","105.112.112.20","2020-01-28 16:01:46","2020-01-28 16:02:17","","","","1","0000-00-00 00:00:00","2019-05-23 09:19:06","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0304","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("694","0","1","0","0","1","10","1","1","10","0694","0","0","7","546","","ANKYOOR TERDOO JUDE","07056172662","","","","M","2","Nigerian","17","7","1989","single","","","","judeankyoor@gmail.com","","GBOKO","07056172662","","NIGER RAILWAY QTRS MINNA","","","Normal","O","None","","1","1","0","197.210.57.16","2019-10-03 12:32:14","2019-06-03 12:07:41","","","","1","0000-00-00 00:00:00","2019-05-23 09:20:25","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0238","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("695","0","1","0","0","1","11","1","1","11","0695","0","0","23","478","","ADEYEMI OMODUNNI JEMIMA","08166035014","","","","F","2","Nigerian","13","5","1992","married","","","","jemimaadeyemi@gmail.com","","KABBA BUNU","08166035014","","NIGER CHAMBER OF COMMERCE PAIKO ROAD MINNA","","","Normal","O","None","","1","0","0","105.112.114.140","2020-01-16 09:26:46","2020-01-16 09:27:13","","","","1","0000-00-00 00:00:00","2019-05-23 09:23:35","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0207","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("696","0","1","0","0","1","10","1","1","10","0696","0","0","27","544","","IBRAHIM AMINU","07063848888","","","","M","1","Nigerian","12","3","1975","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","07063848888","","NW 45, LIMAWA ROAD MINNA","","","Normal","A+","None","","1","0","0","105.112.113.95","2020-01-15 10:21:46","2020-01-15 10:22:03","","","","1","0000-00-00 00:00:00","2019-05-23 09:24:49","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0081","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("697","0","1","0","0","4","13","1","4","13","0697","0","0","27","559","","HALIDU ISAH ABARA","08102877515","","","","M","1","Nigerian","25","5","1975","married","","","","halidisa789@gmail.com","","RIJAU","08102877515","","KETARE SABON GARI RATAYAGIWA ROAD RIJAU","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 11:37:01","2020-01-16 11:37:15","","","","1","0000-00-00 00:00:00","2019-05-23 09:26:08","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0252","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("698","0","0","0","0","0","0","1","7","16","0698","0","0","27","544","","APEH BLESSED","07051011173","","","","F","2","Nigerian","28","3","1994","single","","","","blessedapeh2014@gmail.com","","CHANCHAGA","07051011173","","BLOCK 154 KARO ABUJA","","","Normal","B+","None","","1","0","0","197.210.55.222","2019-06-03 12:13:32","2019-06-03 12:14:24","","","","1","0000-00-00 00:00:00","2019-05-23 09:27:33","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("699","0","1","0","0","1","11","1","1","11","0699","0","0","23","477","","ALEMEDE SOLOMON OLORUNFEMI","08065824030","","","","F","2","Nigerian","20","8","1978","married","","","","elega2why@gmail.com","","IJUMU","08065824030","","HOUSE NO BK 12/240 BARIKIN SALE MINNA","","","Normal","O","None","","1","0","0","105.112.114.140","2020-01-16 09:28:24","2020-01-16 09:28:49","","","","1","0000-00-00 00:00:00","2019-05-23 09:29:32","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0218","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("700","0","1","0","0","1","11","1","1","11","0700","0","0","27","542","","MOHAMMED YAKUBU","08035886912","","","","M","1","Nigerian","7","4","1964","married","","","","angoaliyu76@yahoo.com","","BORGU","08035886912","","FINANCE AND SUPPLY DEPARTMENT BORGU LGA","","","Normal","AB","None","","1","1","0","105.112.120.197","2019-11-04 12:53:15","2019-06-03 12:18:41","","","","1","0000-00-00 00:00:00","2019-05-23 09:31:01","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0432","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("701","0","1","0","0","10","21","1","7","16","0701","0","0","27","539","","AHMED MOHAMMED ALHAJI","08164763768","","","","M","1","Nigerian","22","1","1990","single","","","","angoaliyu76@yahoo.com","","AGAIE","08164763768","","OPPOSITE OLD UNITY CLINIC KPAKUNGU MINNA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 14:11:20","2020-01-16 14:11:29","","","","1","0000-00-00 00:00:00","2019-05-23 09:33:45","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2019-12-13 10:45:42","0356","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("702","0","0","0","0","0","0","1","1","10","0702","0","0","27","541","","MUHAMMAD TANGBO HAUWA","08065680340","","","","M","1","Nigerian","19","3","1980","married","","","","angoaliyu76@yahoo.com","","BIDA","08065680340","","OPPOSITE ODUOYE QTRS MINNA","","","Normal","O","None","","1","0","0","197.210.54.59","2019-06-03 12:19:49","2019-06-03 12:20:36","","","","1","0000-00-00 00:00:00","2019-05-23 09:34:41","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("703","0","0","0","0","0","0","1","2","14","0703","0","0","0","0","","DIKKO UMAR","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08132460529","","","","","","","","","1","0","0","197.210.60.119","2020-01-03 10:31:52","2020-01-03 10:32:30","","","","0","0000-00-00 00:00:00","2019-05-23 09:35:36","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("704","0","1","0","0","9","18","1","2","14","0704","0","0","27","557","","DIKKO UMAR","08132460529","","","","M","1","Nigerian","1","1","1990","married","","","","angoaliyu76@yahoo.com","","PAIKO","08132460529","","PAIKO","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 14:40:52","2020-01-16 14:41:06","","","","1","0000-00-00 00:00:00","2019-05-23 09:35:54","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-03 08:59:19","0496","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("705","0","1","0","0","10","20","1","10","20","0705","0","0","27","553","","YUSUF MUSA","08107983011","","","","M","1","Nigerian","7","5","1996","single","","","","angoaliyu76@yahoo.com","","MARIGA","08107983011","","TAYI VILLAGE MINNA","","","Normal","B+","None","","1","0","0","197.210.65.64","2020-01-02 23:14:22","2020-01-02 23:14:54","","","","1","0000-00-00 00:00:00","2019-05-23 09:36:51","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0346","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("706","0","0","0","0","0","0","1","4","12","0706","0","0","0","0","","OGUNSHOLA  MICHAEL ABIOLA","","","","","","0","","","","","","","","","mogunshola@gmail.com","","","07036083805","","","","","","","","","1","0","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-05-23 09:39:38","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("707","0","1","0","0","4","12","1","4","12","0707","0","0","24","504","","OGUNSHOLA  MICHAEL ABIOLA","07036083805","","","","M","2","Nigerian","18","9","1988","married","","","","mogunshola@gmail.com","","OYUM","07036083805","","BARIKIN SALE ALONG SUPREME ROAD MINNA","","2019-09-27-091418.jpg","Normal","O","None","","1","0","0","197.210.45.38","2020-01-03 14:21:22","2020-01-03 14:21:50","","","","1","0000-00-00 00:00:00","2019-05-23 09:39:42","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0172","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("708","0","1","0","0","10","20","1","10","20","0708","0","0","27","548","","ABDULLAHI IBRAHIM","07039353256","","","","M","1","Nigerian","31","8","2000","single","","","","ibrahimabdullahi3256@gmail.com","","KATCHA","07039353256","","AL BASHIRI AREA 1 ALONG BIDA ROAD MINNA","","","Normal","O","None","","1","0","0","197.210.226.89","2020-02-07 18:07:16","2020-02-08 15:03:19","","","","1","0000-00-00 00:00:00","2019-05-23 09:42:15","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-01 13:36:03","0414","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("709","0","1","0","0","2","15","1","2","15","0709","0","0","27","560","","HAMIDU MUSA","08036318110","","","","M","1","Nigerian","2","2","1996","married","","","","musahamidu@gmail.com","","SHIRORO","08036318110","","OPPOSITE CENTRAL MOSQUE SHIRORO LGA","","","Normal","AB","None","","1","0","0","197.210.60.119","2020-01-03 11:13:53","2020-01-03 11:14:25","","","","1","0000-00-00 00:00:00","2019-05-23 09:44:01","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0335","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("710","0","1","0","0","1","11","1","1","11","0710","0","0","27","547","","ADAMU ZUBAIRU","08035930894","","","","M","1","Nigerian","2","1","1978","married","","","","zubadamu12@gmail.com","","GURARA","08035930894","","JAN GURARA GAWU BABANGIDA GURARA LGA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 10:59:05","2020-01-16 11:00:09","","","","1","0000-00-00 00:00:00","2019-05-23 09:45:08","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-17 14:18:36","0560","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("711","0","1","0","0","2","15","1","2","15","0711","0","0","27","539","","ABDULLAHI YAHAYA","08065381453","","","","M","1","Nigerian","21","11","1988","married","","","","angoaliyu76@yahoo.com","","AGAIE","08065381453","","DARU SALAM KPAKUNGU MINNA","","","Normal","AB","None","","1","0","0","105.112.115.177","2020-01-16 13:03:33","2020-01-16 13:03:43","","","","1","0000-00-00 00:00:00","2019-05-23 09:46:14","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0408","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("712","0","1","0","0","10","21","1","10","21","0712","0","0","27","551","","GANA ESTHER BABA","08036220672","","","","F","2","Nigerian","12","4","1982","married","","","","angoaliyu76@yahoo.com","","DOKO","08036220672","","SAUKA KA HUTA OPPOSITE AMPHANY SCHOOL MINNA","","","Normal","B+","None","","1","1","0","41.190.14.216","2019-09-26 13:54:51","2019-06-03 12:32:27","","","","1","0000-00-00 00:00:00","2019-05-23 12:15:56","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0167","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("713","0","1","0","0","9","6","1","9","6","0713","0","0","27","541","","BABA MUSA MAIMUNA","08036252161","","","","F","1","Nigerian","19","7","1977","married","","","","maimunabmusa81@gmail.com","","BIDA","08036252161","","DUTSEN KURAN GWARI MINNA","","","Normal","O","None","","1","0","0","197.210.64.76","2020-01-02 23:39:03","2020-01-02 23:40:11","","","","1","0000-00-00 00:00:00","2019-05-23 12:17:04","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0158","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("714","0","1","0","0","2","14","1","2","14","0714","0","0","27","541","","ABUBAKAR A. YAHAYA","08166193112","","","","M","1","Nigerian","18","2","1988","married","","","","abubakarayahaya9400@gmail.com","","BIDA","08166193112","","SHANU VILLAGE BEHIND POLICE SECONDARY  SCHOOL MINNA","","","Normal","A+","None","","1","0","0","197.210.65.100","2020-01-02 20:51:52","2020-01-02 20:52:24","","","","1","0000-00-00 00:00:00","2019-05-23 12:18:19","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0096","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("715","0","0","0","0","0","0","1","1","10","0715","0","0","27","541","","TUKUR MOHAMMED","08065894388","","","","M","1","Nigerian","5","6","1991","single","","","","angoaliyu76@yahoo.com","","BIDA","08065894388","","HOUSE NO 158 BOSSO LOW COST MINNA","","","Normal","B+","None","","1","0","0","197.210.55.215","2019-06-03 12:35:18","2019-06-03 12:36:09","","","","1","0000-00-00 00:00:00","2019-05-23 12:36:16","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("716","0","1","0","0","7","16","1","10","21","0716","0","0","27","557","","Aliyu Halira","08105077722","","","2019-05-23-142217Aliyu .pdf.pdf","F","1","Nigerian","1","11","1990","married","","","","littlebengseworld@gmail.com","","Paiko","08105077722","","Behind Ibadat Fuel Station, Paiko, Paikoro LGA, NIger State","Behind Ibadat Fuel Station, Paiko, Paikoro LGA, NIger State","2019-05-23-140933.jpg","Normal","O","None","Nil","1","0","0","105.112.115.177","2020-01-16 13:47:25","2020-01-16 13:47:55","","","","1","0000-00-00 00:00:00","2019-05-23 14:07:07","0000-00-00 00:00:00","","","Aliyu Baba","08105077722","Behind Ibadat Fuel Station, Paiko, Paikoro LGA, NIger State","Father","1","Aliyu Baba","Behind Ibadat Fuel Station, Paiko, Paikoro LGA, NIger State","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2019-12-09 13:50:35","0665","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("717","0","0","0","0","0","0","1","9","6","0717","0","0","0","0","","Paul Mathew","","","","","","0","","","","","","","","","mathewp955@gmail.com","","","08096636025","","","","","","","","","1","0","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-05-23 15:36:22","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("718","0","0","0","0","0","0","1","9","6","0718","0","0","7","119","","PAUL","08096636025","","","2019-05-23-160606mathew.pdf.pdf","M","2","Nigerian","19","9","1994","married","","","","mathewp955@gmail.com","","minna","08096636025","","BARKIN SALE MINNA NIGER STATE","BARKIN SALE MINNA NIGER STATE","2019-05-23-154645.jpg","Normal","O","None","","1","1","0","41.190.14.70","2019-12-14 09:37:07","2019-06-10 13:45:53","","","","1","0000-00-00 00:00:00","2019-05-23 15:42:40","0000-00-00 00:00:00","","","MATHEW","08083523327","BARKIN SALE MINNA NIGER STATE","FATHER","1","HAJIYA HAUWA","BIRTHER MINNA ","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("719","0","1","0","0","4","13","1","4","13","0719","0","0","27","551","","LOIS TSADO","08065465040","","","2019-05-23-175916LOUS.pdf.pdf","F","2","Nigerian","27","8","1975","married","","","","loistsado2019@gmail.com","","DOKO","08065465040","","St. John\'s Anglican Church Bida  
\n  ","St. Peter Anglican Church Bida  
\n  ","2019-05-23-174819.jpg","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 11:37:30","2020-01-16 11:37:40","","","","1","0000-00-00 00:00:00","2019-05-23 17:44:42","0000-00-00 00:00:00","","","MR ISAAC BALA TAIDI","08065398611","St. Peter Anglican Church Bida  
\n  ","HUSBAND","4","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0169","10","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("720","0","0","0","0","0","0","1","4","13","0720","0","0","27","563","","MOHAMMED BABA KODO","07036035545","","","2019-05-24-095050MOHAMMED.pdf.pdf","M","1","Nigerian","15","1","1978","married","","","","mbkodo721@gmail.com","","KODO","07036035545","","GURARA BIDA ROAD, MINNA NIGER STATE","GURARA BIDA ROAD, MINNA NIGER STATE","2019-05-24-094826.jpg","Normal","O","None","NORMAL","1","0","0","41.190.14.35","2019-05-27 15:56:48","2019-05-27 15:59:51","","","","1","0000-00-00 00:00:00","2019-05-24 09:26:14","0000-00-00 00:00:00","","","MOHAMMED BABA KODO","08059090601","GURARA BIDA ROAD, MINNA NIGER STATE","FATHER","1","MOHAMMED BABA KODO","GURARA BIDA ROAD, MINNA NIGER STATE","0","","0","0000-00-00 00:00:00","","18","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("721","0","1","0","0","10","20","1","10","20","0721","0","0","27","550","","JIBRIN HAUWA","09037139828","","","","F","1","Nigerian","19","8","1987","married","","","","angoaliyu76@yahoo.com","","LAPAI","09037139828","","A 200 ALIYU GANA ROAD LAPAI LGA","","","Normal","A+","None","","1","0","0","197.210.45.38","2020-01-03 13:45:05","2020-01-03 13:45:37","","","","1","0000-00-00 00:00:00","2019-05-24 10:02:06","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0370","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("722","0","1","0","0","2","15","1","2","15","0722","0","0","27","557","","AMINU HARUNA SHABA","08036916037","","","","M","1","Nigerian","30","10","1976","married","","","","angoaliyu76@yahoo.com","","PAIKORO","08036916037","","NE 7A KUTA ROAD MINNA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 12:54:37","2020-01-16 12:54:58","","","","1","0000-00-00 00:00:00","2019-05-24 10:03:59","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0231","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("723","0","1","0","0","2","15","1","2","15","0723","0","0","27","552","","MOHAMMED GARBA AUNA","08034518003","","","","M","1","Nigerian","15","5","1978","married","","","","angoaliyu76@yahoo.com","","MAGAMA","08034518003","","DISTRICT HEAD RESIDENCE AUNA TOWN MAGAMAA LGA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 12:53:08","2020-01-16 12:53:17","","","","1","0000-00-00 00:00:00","2019-05-24 10:05:01","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0050","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("724","0","1","0","0","7","16","1","7","16","0724","0","0","27","544","","AMINU ABDULMAJID ALI","08039721478","","","","M","1","Nigerian","24","12","1994","married","","","","aminuabdulmajid5@gmail.com","","CHANCHAGA","08039721478","","NO. 1 KUTA  ROAD, MINNA","","","Normal","A+","None","","1","0","0","105.112.115.177","2020-01-16 13:33:11","2020-01-16 13:33:38","","","","1","0000-00-00 00:00:00","2019-05-24 10:06:35","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0074","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("725","0","1","0","0","10","20","1","2","14","0725","0","0","27","541","","YAHAYA RAMATU","08060341282","","","","F","1","Nigerian","7","9","1991","married","","","","umar.ahmed3388@gmail.com","","BIDA","08060341282","","NO. 2 VEEZ GARDEN AREA 3 LONDON STREET MINNA","","","Normal","A+","None","","1","0","0","197.210.227.19","2020-02-03 15:36:48","2020-02-03 15:39:18","","","","1","0000-00-00 00:00:00","2019-05-24 10:08:29","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-04 14:07:45","0516","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("726","0","1","0","0","4","12","1","4","12","0726","0","0","27","541","","SHUAIBU ASMAU LIMAN","08036207437","","","","F","1","Nigerian","8","3","1994","married","","","","shuaiyakubu@gmail.com","","BIDA","08036207437","","PLOT 418 ADAMAWA ROAD, DUTSEN KURA MINNA","","","Normal","O","None","","1","0","0","197.210.60.119","2020-01-03 10:42:34","2020-01-03 10:43:14","","","","1","0000-00-00 00:00:00","2019-05-24 10:10:09","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-29 10:30:31","0629","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("727","0","1","0","0","2","2","1","2","2","0727","0","0","27","560","","MAIGIDA RITA CHRISTOPHER","08156223941","","","","F","1","Nigerian","26","1","1996","married","","","","ritaemmanuel748@gmail.com","","SHIRORO","08156223941","","D1E 379, TAYI VILLAGE MINNA","","","Normal","O","None","","1","0","0","197.210.55.85","2019-06-10 10:51:10","2019-06-10 10:51:39","","","","1","0000-00-00 00:00:00","2019-05-24 10:12:21","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("728","0","1","0","0","4","12","1","4","12","0728","0","0","27","551","","AHMADU JIBRIN","07037581987","","","","M","1","Nigerian","10","5","1985","married","","","","angoaliyu76@yahoo.com","","LAVUN","07037581987","","TUNGA FARM CENTER MINNA","","","Normal","O","None","","1","0","0","197.210.60.119","2020-01-03 10:33:22","2020-01-03 10:33:53","","","","1","0000-00-00 00:00:00","2019-05-24 10:13:25","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0324","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("729","0","1","0","0","1","11","1","1","11","0729","0","0","27","558","","SANI YAKUBU IDRIS","07061827702","","","","M","1","Nigerian","11","9","1990","single","","","","yakubusani85@gmail.com","","RAFI","07061827702","","SABON GARIN TEGINA RAFI LGA","","","Normal","O","None","","1","0","0","105.112.114.140","2020-01-16 09:50:38","2020-01-16 09:50:55","","","","1","0000-00-00 00:00:00","2019-05-24 10:14:53","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0441","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("730","0","1","0","0","10","20","1","2","2","0730","0","0","27","543","","YUSUF BALARABE ALHASSAN","08084440104","","","","M","1","Nigerian","15","8","1995","single","","","","angoaliyu76@yahoo.com","","BOSSO","08084440104","","TUDUN FULANI OPP SALIHI FILLING STATION MINNA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 14:26:57","2020-01-16 14:27:09","","","","1","0000-00-00 00:00:00","2019-05-24 10:16:52","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-12-03 11:31:13","0654","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("731","0","0","0","0","0","0","1","1","11","0731","0","0","27","560","","IBRAHIM SAMAILA","08157932770","","","","M","1","Nigerian","5","2","1978","married","","","","dattimaje10@gmail.com","","SHIRORO","08157932770","","OPPOSITE 91.3 FM RADIO STATION MAITUMBI MINNA","","","Normal","A+","None","","1","0","0","197.210.54.57","2019-06-10 10:55:19","2019-06-10 10:55:43","","","","1","0000-00-00 00:00:00","2019-05-24 10:19:23","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("732","0","0","0","0","0","0","1","1","10","0732","0","0","27","560","","ADAMU BALKISU","08161820072","","","","F","1","Nigerian","26","6","1985","married","","","","angoaliyu76@yahoo.com","","SHIRORO","08161820072","","OPPOSITE 91.3FM RADIO  STATION MAITUMBI MINNA","","","Normal","O","None","","1","0","0","197.210.55.85","2019-06-10 10:55:52","2019-06-10 10:56:14","","","","1","0000-00-00 00:00:00","2019-05-24 10:20:56","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("733","0","1","0","0","2","2","1","2","2","0733","0","0","27","561","","IBRAHIM ZULAIHA SANI ","08033769803","","","","F","1","Nigerian","10","11","1989","married","","","","zulaihaibrahim1988@gmail.com","","SULEJA","08033769803","","BESIDE ZIK FRANK INTERNATIONAL SCHOOL PDP QTRS SULEJA NIGER","","","Normal","B+","None","","1","1","0","105.112.122.158","2019-10-04 10:44:42","2019-06-10 10:56:49","","","","1","0000-00-00 00:00:00","2019-05-24 11:48:07","0000-00-00 00:00:00","","","","","","","1"," STAT","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0241","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("734","0","1","0","0","10","21","1","10","21","0734","0","0","27","549","","TASI\'U BALA","08138067514","","","","M","1","Nigerian","13","3","1983","married","","","","angoaliyu76@yahoo.com","","KONTAGORA","08138067514","","BEHIND NEPA OFFICE GRA KONTAGORA","","","Normal","A+","None","","1","1","0","41.203.78.135","2019-09-23 11:40:07","2019-06-10 10:58:09","","","","1","0000-00-00 00:00:00","2019-05-24 11:49:01","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0078","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("735","0","1","0","0","1","10","1","1","10","0735","0","0","27","555","","ISAH MUSA","08060836089","","","","M","1","Nigerian","2","1","1982","married","","","","angoaliyu76@yahoo.com","","MOKWA","08060836089","","KPEGE MOKWA EMI MALL ISAH YAKUBU COMPOUND ","","","Normal","O","None","","1","0","0","197.210.85.22","2020-01-02 15:12:15","2020-01-02 15:13:04","","","","1","0000-00-00 00:00:00","2019-05-24 12:03:00","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0164","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("736","0","0","0","0","0","0","1","10","20","0736","0","0","27","544","","ABDULLAHI AMINU","07067335338","","","","M","1","Nigerian","11","10","1992","single","","","","aminshakur27@gmail.com","","CHANCHAGA","07067335338","","SAUKA KA HUTA BEHIND EL AUDAYYA INTERNATIONAL SCHOOL MINNA","","","Normal","O","None","","1","0","0","197.210.54.57","2019-06-10 10:59:02","2019-06-10 10:59:43","","","","1","0000-00-00 00:00:00","2019-05-24 12:04:24","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("737","0","1","0","0","2","2","1","2","2","0737","0","0","27","539","","SADIQ UMAR RABI","08036485911","","","","M","1","Nigerian","19","8","1989","married","","","","angoaliyu76@yahoo.com","","AGAIE","08036485911","","EMI ALHAJI NDAGI MAMUDU MUTAWALI\'S RESIDENCE AGAIE","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 12:56:37","2020-01-16 12:56:47","","","","1","0000-00-00 00:00:00","2019-05-24 12:06:13","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0135","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("738","0","0","0","0","0","0","1","1","10","0738","0","0","0","0","","Ahmed baba umar","","","","","","0","","","","","","","","","Babaumar1986@gmail.com","","","07036048992","","","","","","","","","1","0","0","197.210.52.190","2019-05-26 17:41:27","2019-05-26 17:51:07","","","","0","0000-00-00 00:00:00","2019-05-26 17:40:59","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("739","0","0","0","0","0","0","1","7","16","0739","0","0","27","551","","Shehu Abdullahi Mohammed","08139423882","","","2019-05-27-142559credentials.pdf.pdf","M","1","Nigerian","3","7","1994","single","","","","abdul4ril35@gmail.com","","NIGER STATE","08139423882","","142B PAIKO ROAD TUNGA, MINNA. NIGER STATE","142B PAIKO ROAD TUNGA, MINNA. NIGER STATE","2019-05-27-142357.jpeg","Normal","O","None","NIL","1","1","0","105.112.112.8","2019-07-11 08:12:29","2019-05-27 21:57:47","","","","1","0000-00-00 00:00:00","2019-05-26 18:39:48","0000-00-00 00:00:00","","","M.A SHEHU","08022233584","142B PAIKO ROAD TUNGA, MINNA. NIGER STATE","FATHER","4","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("740","0","0","0","0","0","0","1","2","15","0740","0","0","12","225","","Philip Adebisi","08064735077","","","2019-05-27-123918IBBULAPAI.pdf.pdf","M","2","Nigerian","21","6","1992","single","","","","philipdavid318@gmail.com","","Minna","08064735077","","Fadikpe,Behind Sacred Heart Catholic Church, Minna, Niger State.
\n","Fadikpe,Behind Sacred Heart Catholic Church, Minna, Niger State.
\n","2019-05-27-123614.jpg","Normal","O","None","","1","1","0","105.112.112.213","2019-05-27 12:32:57","2019-05-26 19:46:30","","","","0","0000-00-00 00:00:00","2019-05-26 18:43:54","0000-00-00 00:00:00","","","ADEBISI DAVID AFEKNOKARE","07033188123","Fadikpe,Behind ECWA Church, Minna, Niger State.","FATHER","4","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("741","0","0","0","0","0","0","1","10","21","0741","0","0","0","0","","Patrick Emmanuel Aondugu","","","","","","0","","","","","","","","","dpathillz@gmail.com","","","07067733083","","","","","","","","","1","1","0","197.210.61.138","2019-05-26 20:05:37","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-05-26 20:04:42","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("742","0","0","0","0","0","0","1","2","14","0742","0","0","0","0","","Japheth Barnabas","","","","","","0","","","","","","","","","Japhethbarnabas001@yahoo.com","","","08159535888","","","","","","","","","1","1","0","41.203.72.224","2019-05-27 08:57:56","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-05-27 08:55:34","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("743","0","0","0","0","0","0","1","2","14","0743","0","0","27","541","","ADAMU BALA","08032420365","","","2019-05-27-102907ADAMU BALA.pdf.pdf","M","1","Nigerian","11","6","1983","married","","","","orentebally@gmail.com","","BIDA","08032420365","","FLAT 9 GIDAN MATASA QUARTERS OFF OKADA ROAD MINNA,NIGER STATE","MAYAKI NDAJIYA AREA BIDA ","2019-05-27-101834.jpg","Normal","O","None","HEALTH CARE INTERNATIONAL","1","0","0","105.112.120.210","2019-12-27 17:22:24","2019-12-27 17:23:46","","","","1","0000-00-00 00:00:00","2019-05-27 10:15:45","0000-00-00 00:00:00","","","ALHAJI ADAMU ORETE","08036377017","MAYAKI NDAJIYA AREA BIDA ","FATHER","3","ALHAJI ADAMU ORETE","MAYAKI NDAJIYA AREA BIDA ","0","","0","0000-00-00 00:00:00","","2","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("744","0","0","0","0","0","0","1","2","14","0744","0","0","27","556","","BULUS MERCY WEBE","09094431901","","","2019-05-27-135834MERCY PART TIME.pdf.pdf","F","2","Nigerian","11","12","1992","single","","","","webebulus@gmail.com","","kwaki village","09094431901","","Behind Diamond bank tunga Minna Niger State","Behind Diamond bank tunga Minna Niger State","2019-05-27-115521.jpg","Normal","O","None","Nil","1","0","0","197.210.52.29","2019-11-10 16:18:35","2019-11-10 16:18:57","","","","1","0000-00-00 00:00:00","2019-05-27 11:07:47","0000-00-00 00:00:00","","","Bulus webe","09094431901","Behind Diamond bank tunga Minna Niger State","father","1","Mercy  Webe","Behind Diamond bank tunga Minna Niger State","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("745","0","1","0","0","4","4","1","10","20","0745","0","0","27","552","","MUSA SULEIMAN","09037553015","","","","M","1","Nigerian","12","2","1988","married","","","","musa1.nasko@gmail.com","","MAGAMA","09037553015","","HOUSE NO 20 MANDELLA ROAD MINNA","","","Normal","O","None","","1","0","0","105.112.117.216","2020-02-11 15:51:33","2020-02-11 16:09:43","","","","1","0000-00-00 00:00:00","2019-05-27 12:24:31","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2020-02-04 10:18:05","0045","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("746","0","1","0","0","1","1","1","1","1","0746","0","0","27","551","","ADAMU ILIYASU","07068630181","","","","M","1","Nigerian","13","6","1983","married","","","","iliyasuadamu413@gmail.com","","LAVUN","07068630181","","BARIKIN SALE NEW EXTENSION AREA MINNA","","","Normal","O","None","","1","0","0","105.112.112.20","2020-01-28 15:46:58","2020-01-28 15:47:10","","","","1","0000-00-00 00:00:00","2019-05-27 12:27:01","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0275","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("747","0","1","0","0","1","1","1","1","1","0747","0","0","14","659","","ODILO PRINCESS CHIAMAKA","08166048922","","","","F","1","Nigerian","17","7","1996","single","","","","angoaliyu76@yahoo.com","","ORJI RIVER","08166048922","","NO 24 MOROCCO SULEJA ","","","Normal","O","None","","1","0","0","105.112.115.42","2020-02-22 09:18:18","2020-02-22 12:18:26","","","","1","0000-00-00 00:00:00","2019-05-27 12:29:14","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0199","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("748","0","1","0","0","2","15","1","2","15","0748","0","0","27","560","","UMAR SALIHU KUTA","08036899356","","","","M","1","Nigerian","13","4","1978","married","","","","angoaliyu76@yahoo.com","","SHIRORO","08036899356","","ANGUWAN MAMMAN KUTA GIDAN HAKIMI EGWA OPPOSITE GARBATI PHARMACY KUTA","","","Normal","O","None","","1","0","0","197.210.226.205","2020-02-05 11:04:12","2020-02-05 14:59:34","","","","1","0000-00-00 00:00:00","2019-05-27 12:30:53","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-20 11:50:25","0593","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("749","0","1","0","0","4","12","1","4","12","0749","0","0","27","541","","YAHAYA UMARU EDOTA","08062618199","","","","M","1","Nigerian","25","5","1983","married","","","","angoaliyu76@yahoo.com","","BIDA","08062618199","","GALADIMA IBRAHIM TAKO AREA BIDA","","","Normal","O","None","","1","0","0","105.112.112.20","2020-01-28 16:09:58","2020-01-28 16:10:08","","","","1","0000-00-00 00:00:00","2019-05-27 12:31:56","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0102","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("750","0","1","0","0","1","11","1","1","11","0750","0","0","27","552","","ADAMU MAIRIGA MAMBA","07067795595","","","","M","1","Nigerian","12","12","1972","married","","","","angoaliyu76@yahoo.com","","MAGAMA","07067795595","","MAMBA MAGAMA LGA","","","Normal","O","None","","1","0","0","105.112.113.95","2020-01-15 11:03:41","2020-01-15 11:05:03","","","","1","0000-00-00 00:00:00","2019-05-27 12:33:18","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-05 07:31:05","0458","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("751","0","1","0","0","2","14","1","2","14","0751","0","0","27","560","","MOHAMMED ALIYU","08036539326","","","","M","1","Nigerian","3","1","1971","married","","","","mbaerena@gmail.com","","SHIRORO","08036539326","","SKP SAYAKO, NEW MARKET OPPOSITE RAHAMA BREAD MINNA","","","Normal","A+","None","","1","0","0","105.112.115.177","2020-01-16 13:14:58","2020-01-16 13:15:46","","","","1","0000-00-00 00:00:00","2019-05-27 12:35:12","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-29 10:18:32","0627","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("752","0","1","0","0","7","5","1","4","12","0752","0","0","27","539","","ABUBAKAR ABDULLAHI SHEHU","07032782829","","","","M","1","Nigerian","5","8","1987","married","","","","abubakarabdullahishehu@gmail.com","","AGAIE","07032782829","","SW 491 KETEREN GWARI ROAD MINNA","","","Normal","B+","None","","1","0","0","105.112.115.177","2020-01-16 13:45:43","2020-01-16 13:46:07","","","","1","0000-00-00 00:00:00","2019-05-27 12:37:48","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-12-03 14:41:32","0660","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("753","0","1","0","0","10","21","1","10","21","0753","0","0","27","539","","SHUAIBU MOHAMMED","08036690475","","","","M","1","Nigerian","26","6","1974","married","","","","angoaliyu76@yahoo.com","","AGAIE","08036690475","","SW 26 ISA ABDULKADIR ROAD OPP GENERAL HOSPITAL","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 14:17:29","2020-01-16 14:17:43","","","","1","0000-00-00 00:00:00","2019-05-27 12:38:56","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0344","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("754","0","1","0","0","10","20","1","10","21","0754","0","0","27","546","","NDAKOTSU JOSEPH","07061199432","","","","M","2","Nigerian","7","3","1977","single","","","","josephndakotsu@yahoo.com","","GBAKO","08058177360","","KPAKUNGU MINNA","","","Normal","A+","None","","1","1","0","105.112.114.143","2019-10-03 12:25:42","2019-10-02 13:28:52","","","","1","0000-00-00 00:00:00","2019-05-27 12:40:40","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0223","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("755","0","1","0","0","1","1","1","1","1","0755","0","0","27","541","","MOHAMMED ALIYU TUKUR","08130673931","","","","M","1","Nigerian","22","5","1994","single","","","","angoaliyu76@yahoo.com","","BIDA","08130673931","","HOUSE NO 158 BOSSO LOWCOST MINNA","","","Normal","B+","None","","1","0","0","105.112.115.177","2020-01-16 10:54:47","2020-01-16 10:55:28","","","","1","0000-00-00 00:00:00","2019-05-27 12:42:43","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0385","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("756","0","1","0","0","7","16","1","7","16","0756","0","0","27","546","","AISHA MUHAMMAD","08030677720","","","","F","1","Nigerian","28","7","1996","married","","","","angoaliyu76@yahoo.com","","GBAKO","08030677720","","HOUSE NO 149 TUNGA LOW COST MINNA","","","Normal","B+","None","","1","0","0","105.112.115.177","2020-01-16 13:44:54","2020-01-16 13:45:23","","","","1","0000-00-00 00:00:00","2019-05-27 12:45:27","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0342","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("757","0","0","0","0","0","0","1","7","16","0757","0","0","27","554","","USMAN KHADIJAT","08058177360","","","","F","1","Nigerian","15","4","1989","single","","","","khadijatadabo89@gmail.com","","MASHEGU","08058177360","","ANGUWAN KWANKWARA KONTAGORA","","","Normal","O","None","","1","0","0","197.210.52.20","2019-06-10 15:59:46","2019-06-10 16:00:27","","","","1","0000-00-00 00:00:00","2019-05-27 12:46:45","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("758","0","0","0","0","0","0","1","4","12","0758","0","0","27","560","","USMAN ISAH","07033366691","","","2019-05-27-135116JJJJ.pdf.pdf","M","1","Nigerian","15","7","1989","married","","","","uisah823@gmail.com","","GWADA","07033366691","","ALBISHIRI A.U.G FILLINING STATION, BIDA ROAD NIGER STATE","ALBISHIRI A.U.G FILLINING STATION, BIDA ROAD NIGER STATE","2019-05-27-133650.jpg","Normal","O","None","NORMAL","1","0","0","105.112.115.19","2020-01-16 09:24:54","2020-01-16 09:27:17","","","","1","0000-00-00 00:00:00","2019-05-27 13:24:15","0000-00-00 00:00:00","","","ISAH YAKUBU","08144626700","ALBISHIRI A.U.G FILLINING STATION, BIDA ROAD NIGER STATE","FATHER","1","USMAN ISAH","ALBISHIRI A.U.G FILLINING STATION, BIDA ROAD NIGER STATE","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("759","0","0","0","0","0","0","1","9","6","0759","0","0","0","0","","Hassan Musa Baba","","","","","","0","","","","","","","","","Mbhassan@gmail.com","","","09067560494","","","","","","","","","1","0","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-05-27 13:55:08","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("760","0","1","0","0","9","6","1","9","6","0760","0","0","27","539","","Hassan Musa Baba","09067560494","","","2019-05-29-121622New Doc 2019-05-29 11_comp_compressPDF.pdf.pdf","M","1","Nigerian","16","11","1997","single","","","","Mbhassan15@gmail.com","","Agaie","09067560494","","Emi manati ekossa ward agaie","Emi manati ekossa ward agaie","2019-05-29-112022.jpg","Normal","O","None","","1","1","0","129.205.113.83","2019-09-26 15:00:11","2019-09-26 15:00:04","","","","1","0000-00-00 00:00:00","2019-05-27 16:44:15","0000-00-00 00:00:00","","","Alh. Musa Masin","08037035559","Emi manati ekossa ward agaie","Father","1","Alh. Musa Masin","Emi manati ekossa ward agaie","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0035","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("761","0","1","0","0","10","21","1","10","21","0761","0","0","4","82","","BENJAMIN ARINZE ","08069557575","","","2019-05-27-202136OBI.pdf.pdf","M","2","Nigerian","22","7","1989","married","","","","benjaminarize@gmail.com","","KADUNA","08069557575",""," HOUSE NO 5. GIDAN MANGORO BEHIND ASSALAM  FILLING  STATION  OF NECO  HEAD QUARTER BIDA  ROAD  MINNA"," HOUSE NO 5. GIDAN MANGORO BEHIND ASSALAM  FILLING  STATION  OF NECO  HEAD QUARTER BIDA  ROAD  MINNA","2019-05-27-181148.jpg","Normal","O","None","PHYSICAL FIT","1","0","0","197.210.227.72","2020-02-05 09:18:19","2020-02-05 11:03:58","","","","1","0000-00-00 00:00:00","2019-05-27 18:09:06","0000-00-00 00:00:00","","","REUBEN  ARINZE ","07039674635","NAF BASE  AIR  FLEET  ABUJA","BROTHER","4","SELF"," HOUSE NO 5. GIDAN MANGORO BEHIND ASSALAM  FILLING  STATION  OF NECO  HEAD QUARTER BIDA  ROAD  MINNA","1","                                
\n                                                                 
\n                                ","3","2019-10-30 22:08:28","0398","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("762","0","0","0","0","0","0","1","2","14","0762","0","0","27","559","","SULEIMAN TURAKI","07089326662","","","2019-05-28-110456sulee.pdf.pdf","M","1","Nigerian","5","3","1982","married","","","","suleimanturaki5050@gmail.com","","Rijau","07089326662","","Top medical Road, tunga Minna Niger State ","Top medical Road, tunga Minna Niger State ","2019-05-28-104902.jpg","Normal","O","None","Nill","1","1","0","41.203.72.229","2019-05-28 11:24:15","2019-05-28 11:22:44","","","","1","0000-00-00 00:00:00","2019-05-28 10:24:02","0000-00-00 00:00:00","","","Umar Turaki","08033150148","Top medical Road, tunga Minna Niger State ","Brother ","1","Suleiman Turaki","Top medical Road, tunga Minna Niger State ","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("763","0","1","0","0","2","14","1","2","14","0763","0","0","19","358","","JOHN PATIENCE TUMAN","08029990151","","","2019-06-10-105026patiencee.pdf.pdf","F","2","Nigerian","31","3","1988","married","","","","tudurba@gmail.com","","ZARIA","08029990151","","FLAT2 UCHE  EZINWANNE ESTATE BEHIND TRADE FAIR COMPLEX GIDAN MADARA , MINNA NIGER STATE.","FLAT2 UCHE  EZINWANNE ESTATE BEHIND TRADE FAIR COMPLEX GIDAN MADARA , MINNA NIGER STATE.","2019-05-28-114039.jpg","Normal","A+","None","NIL","1","0","0","105.112.115.177","2020-01-16 13:16:05","2020-01-16 13:16:51","","","","1","0000-00-00 00:00:00","2019-05-28 11:27:50","0000-00-00 00:00:00","","","","08022220512","FLAT2 UCHE  EZINWANNE ESTATE BEHIND TRADE FAIR COMPLEX GIDAN MADARA , MINNA NIGER STATE.","HUSBAND","1","PATIENCE TUMAN","FLAT2 UCHE  EZINWANNE ESTATE BEHIND TRADE FAIR COMPLEX GIDAN MADARA , MINNA NIGER STATE.","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2019-11-29 15:36:18","0632","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("764","0","1","0","0","10","22","1","2","15","0764","0","0","27","550","","Salihu Garba","08062083042","","","2019-05-28-161732garba.pdf.pdf","M","1","Nigerian","13","5","1990","married","","","","sglapai@gmail.com","","Lapai","08062083042","","G.66 Jannari Road Lapai, Niger State","G.66 Jannari Road Lapai, Niger State","2019-05-28-161929.jpg","Normal","O","None","","1","1","0","141.0.12.10","2019-11-15 11:45:02","2019-05-28 16:16:13","","","","1","0000-00-00 00:00:00","2019-05-28 14:46:52","0000-00-00 00:00:00","","","Abdul Garba","08036094820","G.66 Jannari Road Lapai, Niger State","Brother","1","Abdul Garba","G.66 Jannari Road Lapai, Niger State","1","                                
\n                                                                 
\n                                ","3","2019-11-15 09:04:07","0526","3","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("765","0","1","0","0","10","20","1","10","20","0765","0","0","27","541","","MUSTAPHA IBRAHIM","07036621480","","","2019-05-30-215636MUSTAPHA IBRAHIM.pdf.pdf","M","1","Nigerian","1","6","1996","single","","","","mustaphaibrahim1480@yahoo.com","","BIDA","07036621480","","NO W246 KOFARWUYA HOUSE BANWUYA AREA, BIDA NIGER STATE","NO W246 KOFARWUYA HOUSE BANWUYA AREA, BIDA NIGER STATE","2019-05-30-213812.jpg","Normal","O","None","NIL","1","1","0","129.205.112.250","2020-01-31 18:23:50","2020-01-16 14:21:35","","","","1","0000-00-00 00:00:00","2019-05-28 22:12:59","0000-00-00 00:00:00","","","IBRAHIM ABDULLAHI NMA","08032602784","NO W246 KOFARWUYA HOUSE BANWUYA AREA, BIDA NIGER STATE","BROTHER","1","IBRAHIM ABDULLAHI NMA","NO W246 KOFARWUYA HOUSE BANWUYA AREA, BIDA NIGER STATE","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0204","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("766","0","0","0","0","0","0","1","10","21","0766","0","0","0","0","","Maryam Larai Adamu","","","","2019-05-29-131155SCAN 123.pdf.pdf","","0","","","","","","","","","paikolupa@gmail.com","","","09023129667","","","","2019-05-29-115946.jpg","","","","","1","1","0","105.112.122.110","2019-10-27 09:50:35","2019-10-27 09:48:04","","","","1","0000-00-00 00:00:00","2019-05-29 11:16:36","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("767","0","0","0","0","0","0","1","2","2","0767","0","0","0","0","","MOHAMMED TSWANKWA KPAKIKO","","","","","","0","","","","","","","","","tswankwamohammed70@gmail.com","","","08035074063","","","","","","","","","1","1","0","105.112.120.230","2019-05-29 16:03:16","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-05-29 16:02:26","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("768","0","1","0","0","10","22","1","2","15","0768","0","0","27","555","","MOHAMMED TSWANKWA KPAKIKO","08035074063","","","2019-05-29-174149CREDENTIALpdf.pdf.pdf","M","1","Nigerian","7","10","1984","married","","","","tswankwamohammed70@gmail.com","","KPAKIKO","08035074063","","NTD 57 ABDULLAHI MAISASSAKA ROAD, TUNGA MINNA.","NTD 57 ABDULLAHI MAISASSAKA ROAD, TUNGA MINNA.","2019-05-29-161047.jpg","Normal","O","None","","1","1","0","197.210.52.29","2019-12-03 13:59:08","2019-05-29 17:40:36","","","","1","0000-00-00 00:00:00","2019-05-29 16:04:34","0000-00-00 00:00:00","","","ALHAJI ALHASSAN A. KPAKIKO","08033586096","NTD 57 ABDULLAHI MAISASSAKA ROAD, TUNGA MINNA.","UNCLE","1","ALHAJI ALHASSAN KPAKIKO","NTD 57 ABDULLAHI MAISASSAKA ROAD, TUNGA MINNA.","1","                                
\n                                                                 
\n                                ","3","2019-11-03 08:35:56","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("769","0","0","0","0","0","0","1","4","12","0769","0","0","0","0","","Umar Sanda Abdullahi","","","","2019-05-29-171353scan 0010001.pdf.pdf","","0","","","","","","","","","umars446@gmail.com","","","07038732130","","","","2019-05-29-162612.jpg","","","","","1","0","0","129.205.101.46","2019-05-29 17:12:52","2019-05-29 17:29:03","","","","0","0000-00-00 00:00:00","2019-05-29 16:19:34","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("770","0","0","0","0","0","0","1","2","14","0770","0","0","27","550","","Fatima Alfa","08036094820","","","2019-05-30-111854FATIMA ALFA.pdf.pdf","F","1","Nigerian","21","4","1985","married","","","","garbaabdul236@yahoo.com","","Lapai","08036094820","","G. 66 Jannary Road Lapai, Niger State","G. 66 Jannary Road Lapai, Niger State","2019-05-30-111909.jpg","Normal","O","None","","1","1","0","197.210.84.227","2019-11-12 17:50:18","2019-11-12 17:50:16","","","","1","0000-00-00 00:00:00","2019-05-30 11:04:17","0000-00-00 00:00:00","","","Abdul Garba","08036094820","G. 66 Jannary Road Lapai, Niger State","Husband","1","Abdul Garba","Ibrahim Badamasi Babangida University P.M.B 11 Lapai, Niger State","0","","0","0000-00-00 00:00:00","","2","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("771","0","1","0","0","1","10","1","1","10","0771","0","0","27","553","","Kakihum Halidu Abdullahi","08082557085","","","2019-05-30-165016Kakihum.pdf.pdf","M","1","Nigerian","1","1","1980","single","","","","littlebengseworld@gmail.com","","Kakihun","08082557085","","Kakikum Village, Mariga LGA Niger State","Kakikum Village, Mariga LGA Niger State","2019-05-30-164729.jpg","Normal","O","None","Nil","1","0","0","105.112.112.20","2020-01-28 15:54:03","2020-01-28 15:54:31","","","","1","0000-00-00 00:00:00","2019-05-30 16:30:28","0000-00-00 00:00:00","","","Abdullahi Danlami","08082557085","Kakikum Village, Mariga LGA Niger State","Father","1","Halidu Abdullahi Kakihum","Kakikum Village, Mariga LGA Niger State","1","                                
\n                                                                 
\n                                ","3","2019-11-15 09:24:59","0561","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("772","0","1","0","0","4","4","1","4","4","0772","0","0","27","557","","Inuwa Rilwanu","08039269295","","","2019-06-01-220224RilwanuInuwa.pdf.pdf","M","1","Nigerian","15","7","1983","married","","","","inuwarilwanu57@gmail.com","","Paiko","08039269295","","Maigoro residence, unguwan fulani, paiko Niger State ","Maigoro residence, unguwan fulani, paiko Niger State","2019-06-01-215654.jpg","Normal","B+","None","Normal","1","1","0","197.210.70.15","2019-11-26 09:50:38","2019-11-26 09:50:35","","","","1","0000-00-00 00:00:00","2019-05-30 16:45:31","0000-00-00 00:00:00","","","Alhaji Danlami Danhausa","08030633444","Maigoro residence, unguwan fulani, paiko Niger State","Brother","1","Rilwanu Inuwa","Maigoro residence, unguwan fulani, paiko Niger State","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0057","9","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("773","0","0","0","0","0","0","1","4","4","0773","0","0","0","0","","abdullahi saidu kutigi","","","","","","0","","","","","","","","","s.kutigi027@Gmail.com","","","09063127485","","","","","","","","","1","0","0","129.205.112.164","2019-05-31 13:53:15","2019-05-31 13:56:22","","","","0","0000-00-00 00:00:00","2019-05-31 13:51:48","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("774","0","0","0","0","0","0","1","11","23","0774","0","0","0","0","","MOHAMMED NDANUSA","","","","","","0","","","","","","","","","ndanusam779@gmail.com","","","08136686909","","","","","","","","","1","1","0","197.210.226.97","2019-06-02 10:01:43","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-06-02 10:00:05","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("775","0","0","0","0","0","0","1","2","15","0775","0","0","0","0","","LIMAN NDAKOLO","","","","","","0","","","","","","","","","limanndakolo@yahoo.com","","","08060684746","","","","","","","","","1","0","0","41.190.14.51","2019-06-02 10:20:58","2019-06-02 10:22:45","","","","0","0000-00-00 00:00:00","2019-06-02 10:19:52","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("776","0","0","0","0","0","0","1","7","5","0776","0","0","27","550","","Haruna Mohammed","08067247331","","","2019-06-03-121211MOhammed Haruna.pdf.pdf","M","1","Nigerian","15","7","1989","married","","","","harunamohammed018@gmail.com","","Katakpa","08067247331","","Barkin Sale, Behind Mai Anguwan House, Minna Niger State","Barkin Sale, Behind Mai Anguwan House, Minna Niger State","2019-06-03-121007.jpg","Normal","O","None","Barkin Sale, Behind Mai Anguwan House, Minna Niger State","1","1","0","105.112.120.123","2019-06-03 13:15:06","0000-00-00 00:00:00","","","","1","0000-00-00 00:00:00","2019-06-03 11:50:13","0000-00-00 00:00:00","","","Abubakar Haruna","08035954308","FCT Abuja","Brother","1","Mohammed Haruna","Barkin Sale, Behind Mai Anguwan House, Minna Niger State","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("777","0","0","0","0","0","0","1","1","1","0777","0","0","27","560","","ABRAHAM JOHN","08079834322","","","2019-06-07-154359supporting documents.pdf.pdf","M","2","Nigerian","5","5","1994","single","","","","erekaaterzungwe@yahoo.com","","ZUMBA","08079834322","","SNCC BUILDING,
\nSHIRORO HYDRO POWER PLANT,
\nSHIRORO,
\nPMB 027 MINNA, NIGER STATE","BEHIND ANE OIL FILLING STATION,
\nAKWAITA AREA, ZUMBA,
\nSHIRORO,  NIGER STATE","2019-06-07-161103.jpg","Normal","O","None","NOT ON MEDICATION","1","0","0","105.112.120.225","2019-09-23 09:13:13","2019-09-23 09:13:25","","","","0","0000-00-00 00:00:00","2019-06-03 12:27:30","0000-00-00 00:00:00","","","MOSES BARDE","","BEHIND ANE OIL FILLING STATION,
\nAKWAITA AREA, ZUMBA,
\nSHIRORO,  NIGER STATE","UNCLE","1","ENGR. TITUS ","SHIRORO HYDRO POWER PLANT, SHIRORO, NIGER STATE","0","","0","0000-00-00 00:00:00","","2","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("778","0","0","0","0","0","0","1","2","15","0778","0","0","27","551","","SOLOMON YISA","08062238895","","","2019-06-05-211159credentials2.pdf.pdf","M","2","Nigerian","4","6","1974","married","","","","yisasolomon7@gmail.com","","DOKO","08062238895","","NIGER STATE POLYTECHNIC BIDA","NIGER STATE POLYTECHNIC BIDA","2019-06-05-190748.jpg","Normal","A+","None","","1","1","0","41.190.12.6","2019-10-30 13:10:29","2019-06-05 19:30:16","","","","1","0000-00-00 00:00:00","2019-06-05 19:01:42","0000-00-00 00:00:00","","","MR PAUL YISA DOKO","08036367909","NIGER STATE POLYTECHNIC BIDA","GUIDIAN","1","YISA SOLOMON","NIGER STATE POLYTECHNIC BIDA","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("779","0","0","0","0","0","0","1","4","13","0779","0","0","27","558","","Abdulrazak Ibrahim","08065495857","","","2019-06-07-080755ABDULRAZAK IBRAHIM CREDENTIALS.pdf.pdf","M","1","Nigerian","29","10","1981","married","","","","abdulrazak124114@gmail.com","","KAGARA","08065495857","","NO. 28 SABON GARI KAGARA, RAFI LOCAL GOVERNMENT, NIGER STATE.","NO. 28 SABON GARI KAGARA, RAFI LOCAL GOVERNMENT, NIGER STATE.","2019-06-07-074825.jpg","Normal","O","None","NILL","1","1","0","197.211.57.178","2019-11-07 16:54:07","2019-06-12 12:49:07","","","","1","0000-00-00 00:00:00","2019-06-06 10:36:25","0000-00-00 00:00:00","","","GARBA IBRAHIM","08031520739","NO. 28 SABON GARI KAGARA, RAFI LOCAL GOVERNMENT, NIGER STATE.","BROTHER","1","SELF","NO. 28 SABON GARI KAGARA, RAFI LOCAL GOVERNMENT, NIGER STATE.","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("780","0","0","0","0","0","0","1","10","21","0780","0","0","27","554","","AMINA YAHAYA","08077033054","","","2019-06-06-125755AMINAT.pdf.pdf","F","1","Nigerian","1","1","1993","married","","","","yahayaameenat@gmail.com","","BABAGI","08077033054","","UNGUWAN DANNI, SAHON RAMI, NGER STATE","UNGUWAN DANNI, SAHON RAMI, NGER STATE","2019-06-06-123010.jpg","Normal","B+","None","FIT","1","1","0","197.210.44.31","2019-10-08 08:29:44","2019-09-28 14:24:38","","","","1","0000-00-00 00:00:00","2019-06-06 12:22:00","0000-00-00 00:00:00","","","ADAMU ABDULLAHI","07056091101","UNGUWAN DANNI, SAHON RAMI, NGER STATE","FATHER","1","SELF","UNGUWAN DANNI, SAHON RAMI, NGER STATE","0","","0","0000-00-00 00:00:00","","2","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("781","0","0","0","0","0","0","1","1","10","0781","0","0","27","541","","SULEIMAN MUSA ADAMU","08035725207","","","2019-06-07-110117adamu s.pdf.pdf","M","1","Nigerian","2","12","1995","married","","","","mssulaiman@gmail.com","","MINNA","08035725207","","OFF OKADA ROAD MINNA,NIGER STATE","OFF OKADA ROAD MINNA,NIGER STATE","2019-06-07-120453.jpg","Normal","O","None","HEALTH CARE INTERNATIONAL","1","0","0","105.112.120.210","2019-12-27 17:24:46","2019-12-27 17:25:38","","","","1","0000-00-00 00:00:00","2019-06-06 18:23:10","0000-00-00 00:00:00","","","IBRAHIM ADAMU SULEIMAN","08148396974","OFF OKADA ROAD MINNA,NIGER STATE","BROTHER","3","MUSA ADAMU SULEIMAN","OFF OKADA ROAD MINNA,NIGER STATE","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("782","0","0","0","0","0","0","1","4","4","0782","0","0","27","548","","Idris Ahmad","07036048779","","","","M","1","Nigerian","4","4","1990","single","","","","ahmadidrisbadeggi@gmail.com","","Badeggi","07036048779","","Kpakungu after jfla, Bida road Minna","","","Normal","O","None","","1","1","0","197.210.46.151","2019-06-07 06:26:59","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-06-06 20:56:02","0000-00-00 00:00:00","","","Ahmad Alhaji Idris","08035095383","Badeggi","Father","1","","","0","","0","0000-00-00 00:00:00","","3","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("783","0","0","0","0","0","0","1","1","1","0783","0","0","0","0","","USMAN ABUBAKAR MANZUMA","","","","","","0","","","","","","","","","manzuma2012@gmail.com","","","08038152334","","","","2019-06-06-212119.jpg","","","","","1","1","0","105.112.27.23","2019-06-06 21:18:28","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-06-06 21:17:40","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("784","0","0","0","0","0","0","1","10","20","0784","0","0","27","550","","SAFIYA HAMIDU HAMZAT","08032463852","","","2019-06-08-123412MY CREDENTIAL-converted.pdf.pdf","F","1","Nigerian","17","9","1980","married","","","","safiyahamidu26@gmail.com","","LAPAI","08032463852","","G40 JANTABO ROAD LAPAI ","G40 JANTABO ROAD LAPAI ","2019-06-08-113629.jpg","Normal","O","None","MENTALLY AND PHYSICALLY FIT ","1","1","0","105.112.120.198","2019-06-08 13:15:38","2019-06-08 13:15:27","","","","1","0000-00-00 00:00:00","2019-06-08 11:24:10","0000-00-00 00:00:00","","","ALHAJI HAMIDU HAMZAT","08034541185","K55 JANTABO ROAD LAPAI ","FATHER","1","SAFIYA HAMIDU HAMZAT","G40 JANTABO ROAD LAPAI ","0","","0","0000-00-00 00:00:00","","10","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("785","0","0","0","0","0","0","1","7","5","0785","0","0","0","0","","Hauwa shuaibu","","","","","","0","","","","","","","","","Aminahalilulapai@gmail.com","","","07060853500","","","","","","","","","1","1","0","197.210.54.253","2019-06-09 10:51:52","2019-06-09 10:45:49","","","","0","0000-00-00 00:00:00","2019-06-09 09:52:40","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("786","0","0","0","0","0","0","1","4","4","0786","0","0","0","0","","Tijjani","","","","","","0","","","","","","","","","Tijjani@gmail.com","","","08099661236","","","","","","","","","1","1","0","105.112.112.16","2019-10-15 15:31:33","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-06-09 17:32:34","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("787","0","0","0","0","0","0","1","4","4","0787","0","0","0","0","","Tijjani","","","","","","0","","","","","","","","","Tijjani@gmail.com","","","08099661236","","","","","","","","","1","0","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-06-09 17:32:36","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("788","0","0","0","0","0","0","1","7","16","0788","0","0","0","0","","Shehu Ahmad Shafii","","","","","","0","","","","","","","","","shehushafii80@gmail.com","","","08064482228","","","","","","","","","1","0","0","105.112.120.225","2019-09-23 09:06:12","2019-09-23 09:19:43","","","","0","0000-00-00 00:00:00","2019-06-10 12:06:26","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("789","0","1","0","0","2","2","1","2","2","0789","0","0","27","541","","ABDULLATEEF  MARIYA ALKALI","08034520145","","","","F","1","Nigerian","17","11","1997","married","","","","imamalfaooq@yahoo.com","","BIDA","08034520145","","C/O BOSSO ESTATE JUMMAT MOSQUE MINNA","","","Normal","A+","None","","1","0","0","105.112.115.177","2020-01-16 12:50:06","2020-01-16 12:50:16","","","","1","0000-00-00 00:00:00","2019-06-10 12:45:37","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0117","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("790","0","0","0","0","0","0","1","2","15","0790","0","0","27","539","","IBRAHIM SALIHU","08027642591","","","","M","1","Nigerian","1","1","1980","married","","","","angoaliyu76@yahoo.com","","AGAIE","08027642591","","EMI BABA HALILU EKOBADEGI WARD AGAIE","","","Normal","A+","None","","1","0","0","197.210.54.159","2019-06-29 13:25:51","2019-06-29 13:27:07","","","","1","0000-00-00 00:00:00","2019-06-10 12:52:07","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("791","0","1","0","0","1","11","1","1","11","0791","0","0","27","550","","ABDULRAHMAN ABUBAKAR","09033200691","","","","M","1","Nigerian","11","11","1974","married","","","","payrell@ibbu.edu.ng","","LAPAI","09033200691","","HOUSE NO 174 BARIKIN SALE MINNA","","","Normal","O","None","","1","0","0","105.112.114.140","2020-01-16 09:38:47","2020-01-16 09:39:04","","","","1","0000-00-00 00:00:00","2019-06-10 12:53:46","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0069","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("792","0","1","0","0","1","11","1","1","11","0792","0","0","27","563","","BAKARE AMINA LADIDI","08026258486","","","","F","1","Nigerian","12","3","1971","married","","","","aminabakare6@gmail.com","","WUSHISHI","08026258486","","C/O SANI NUHU RESIDENCE WATER BOARD ROAD MAIKUNKELE","","","Normal","O","None","","1","0","0","105.112.112.20","2020-01-28 15:48:17","2020-01-28 15:48:35","","","","1","0000-00-00 00:00:00","2019-06-10 12:56:01","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0381","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("793","0","1","0","0","7","16","1","7","16","0793","0","0","27","541","","ABUBAKAR ALIYU KAWU","08065444469","","","","M","1","Nigerian","1","6","1982","married","","","","angoaliyu76@yahoo.com","","BIDA","08065444469","","E785 MOKWALLA AREA BIDA OPPOSITE  ","","","Normal","B+","None","","1","0","0","197.210.55.232","2019-06-29 13:29:00","2019-06-29 13:29:40","","","","1","0000-00-00 00:00:00","2019-06-10 12:58:06","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-05 17:24:03","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("794","0","1","0","0","9","18","1","11","24","0794","0","0","27","543","","ABDULAZEEZ YUSUF","08032712601","","","","M","1","Nigerian","6","6","1993","single","","","","abdulazeezyusuf893@gmail.com","","BOSSO","08032712601","","ALADEY GUEST INN CHANCHAGA ","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 14:52:46","2020-01-16 14:52:56","","","","1","0000-00-00 00:00:00","2019-06-10 12:59:43","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-20 13:06:27","0590","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("795","0","0","0","0","0","0","1","2","14","0795","0","0","27","545","","TASHA GANA","08054229570","","","","M","1","Nigerian","12","2","1973","married","","","","angoaliyu76@yahoo.com","","EDATI","08054229570","","FLAY OUT UNGUWAN DAJI","","","Normal","A+","None","","1","0","0","197.210.54.159","2019-06-29 13:30:40","2019-06-29 13:31:37","","","","1","0000-00-00 00:00:00","2019-06-10 13:01:03","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("796","0","1","0","0","7","16","1","7","16","0796","0","0","27","540","","MUHAMMAD RABI","07066713044","","","","F","1","Nigerian","28","8","1986","single","","","","angoaliyu76@yahoo.com","","AGWARA","07066713044","","MAITUMBI MINNA","","","Normal","B+","None","","1","1","0","105.112.113.179","2020-01-28 13:56:57","2020-01-24 12:49:22","","","","1","0000-00-00 00:00:00","2019-06-10 13:02:09","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0154","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("797","0","1","0","0","10","22","1","10","22","0797","0","0","3","66","","NKOK EKAETTE MONDAY","08037668931","","","","F","2","Nigerian","18","3","1978","married","","","","ekymum@gmail.com","","UKANAFUN","08037668931","","CHANCHAGA MINNA","","","Normal","O","None","","1","0","0","105.112.112.217","2020-01-29 08:50:02","2020-01-29 08:50:21","","","","1","0000-00-00 00:00:00","2019-06-10 13:04:38","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0151","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("798","0","1","0","0","2","15","1","2","14","0798","0","0","27","544","","BABANGIDA NASIRU","08035548939","","","","M","1","Nigerian","6","6","1979","married","","","","babangidanasir@gmail.com","","CHANCHAGA","08035548939","","PURE WATER AREA BARIKIN SALE","","","Normal","B+","None","","1","0","0","105.112.122.136","2020-02-07 13:42:36","2020-02-07 14:13:59","","","","1","0000-00-00 00:00:00","2019-06-10 13:06:03","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0406","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("799","0","1","0","0","9","18","1","10","21","0799","0","0","27","544","","ISYAKU HAUWAWU","08060685761","","","","M","1","Nigerian","8","4","1964","married","","","","hauwaadamu64@gmail.com","","CHANCHAGA","08060685761","","NO 24 USMAN NAGOGO STREET OFF SHIRORO HOTEL ROAD","","","Normal","O","None","","1","1","0","105.112.122.152","2019-12-23 11:41:53","2019-06-29 13:51:26","","","","1","0000-00-00 00:00:00","2019-06-10 13:08:03","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-12-23 11:31:35","0011","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("800","0","1","0","0","10","20","1","10","20","0800","0","0","27","544","","LAWAN BASHIR","08143913093","","","","M","1","Nigerian","1","12","1999","single","","","","albashirlawangsw@gmail.com","","CHANCHAGA","08143913093","","COOL CAT MAITUMBI ROAD MINNA","","","Normal","O","None","","1","0","0","197.210.47.251","2020-01-02 22:47:23","2020-01-02 22:47:53","","","","1","0000-00-00 00:00:00","2019-06-10 13:12:23","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0007","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("801","0","0","0","0","0","0","1","2","15","0801","0","0","27","539","","ABUBAKAR AISHETU TALATU","09098301803","","","","F","1","Nigerian","1","3","1982","married","","","","angoaliyu76@yahoo.com","","AGAIE","09098301803","","EMI NAKORDI AGAIE","","","Normal","A+","None","","1","0","0","197.210.55.96","2019-06-29 13:53:22","2019-06-29 13:54:19","","","","1","0000-00-00 00:00:00","2019-06-10 13:14:01","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("802","0","0","0","0","0","0","1","1","11","0802","0","0","27","539","","NUHU ETSU ABUBAKAR","08038511887","","","","M","1","Nigerian","24","3","1979","married","","","","angoaliyu76@yahoo.com","","AGAIE","08038511887","","EMI ETSU ATTAHIRU AGAIE","","","Normal","A+","None","","1","0","0","197.210.54.234","2019-06-29 13:54:32","2019-06-29 13:55:22","","","","1","0000-00-00 00:00:00","2019-06-10 13:15:31","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("803","0","1","0","0","4","4","1","4","4","0803","0","0","27","544","","HUZAIFA UMAR","08176962136","","","","M","1","Nigerian","12","12","1994","single","","","","huzaifaumar221@gmail.com","","CHANCHAGA","08176962136","","NTD 19B TUDUN WADA TUNGA MINNA","","","Normal","B+","None","","1","1","0","165.22.44.194","2020-02-18 11:58:18","2020-02-03 19:18:19","","","","1","0000-00-00 00:00:00","2019-06-10 13:17:31","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0420","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("804","0","1","0","0","10","20","1","2","2","0804","0","0","27","544","","UMAR MUAZU","08162057849","","","","M","1","Nigerian","12","10","1995","single","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08162057849","","N.E 139 MU\'AZU STREET MAITUMBI","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 14:13:00","2020-01-16 14:13:10","","","","1","0000-00-00 00:00:00","2019-06-10 13:18:36","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-10-31 11:45:18","0394","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("805","0","0","0","0","0","0","1","2","14","0805","0","0","27","550","","HADIZA SHUAIBU","07034793040","","","","F","1","Nigerian","8","3","1988","single","","","","angoaliyu76@yahoo.com","","MUYE","07034793040","","XW 342 KWANGILA ROAD MINNA","","","Normal","B+","None","","1","0","0","197.210.52.217","2019-08-19 16:56:32","2019-08-19 16:58:37","","","","1","0000-00-00 00:00:00","2019-06-10 13:19:53","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("806","0","1","0","0","7","16","1","7","16","0806","0","0","27","557","","MOHAMMED FATIMA","08058264485","","","","F","1","Nigerian","11","11","1986","married","","","","angoaliyu76@yahoo.com","","PAIKORO","08058264485","","BEHIND BI-WATER TATIKO VIA PAIKO ","","","Normal","O","None","","1","0","0","105.112.112.20","2020-01-28 16:26:47","2020-01-28 16:26:57","","","","1","0000-00-00 00:00:00","2019-06-10 13:21:03","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0473","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("807","0","1","0","0","2","15","1","2","15","0807","0","0","27","562","","KURAH JOHN","08059697869","","","","M","2","Nigerian","25","11","1974","married","","","","angoaliyu76@yahoo.com","","TAFA","08059697869","","TUNGA ADAKA VILLAGE  NEW BWARI DISTRICT","","","Normal","B+","None","","1","0","0","197.210.54.234","2019-06-29 13:59:47","2019-06-29 14:00:23","","","","1","0000-00-00 00:00:00","2019-06-10 13:22:44","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("808","0","0","0","0","0","0","1","2","14","0808","0","0","27","550","SALAMATU","ABDULLAHI JANKARA","08037420669","","","2019-06-11-150002salma...pdf.pdf","F","1","Nigerian","18","6","1988","married","","","","yakubsalamatu@yahoo.com","","Abugi jankara","08037420669","","Behind tunga market Minna Niger State","Behind tunga market Minna Niger State","2019-06-11-135153.jpg","Normal","O","None","nil","1","0","0","197.210.226.100","2020-02-03 15:32:21","2020-02-03 15:36:30","","","","1","0000-00-00 00:00:00","2019-06-10 14:51:08","0000-00-00 00:00:00","","","Abulhamid","07039104987","Behind tunga market Minna Niger State","father","1","Alhaji yakubu","Behind tunga market Minna Niger State","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("809","0","0","0","0","0","0","1","2","15","0809","0","0","0","0","","MOHAMMED NDAGI","","","","2019-06-10-215652IMG_20190610_153041.pdf.pdf","","0","","","","","","","","","ndagimohammed47@gmail.com","","","08035124628","","","","2019-06-10-151004.jpg","","","","","1","1","0","41.203.78.202","2019-06-15 10:13:58","2019-06-13 12:01:27","","","","0","0000-00-00 00:00:00","2019-06-10 14:52:45","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("810","0","0","0","0","0","0","1","7","16","0810","0","0","0","0","","Alfa b. Ndana","","","","","","0","","","","","","","","","alfasenior39@gmail.com","","","08168196214","","","","","","","","","1","1","0","41.203.78.184","2019-06-10 17:49:51","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-06-10 17:48:56","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("811","0","0","0","0","0","0","1","4","4","0811","0","0","27","539","","Ahmed Abdullahi","08134806197","","","2019-06-11-061648Ahmed Abdullahi.pdf.pdf","M","1","Nigerian","26","9","1992","single","","","","Aabdullahi748@gmail.com","","Agaie","08134806197","","Emi tswagaiechi ekowuna ward agaie","Emi tswagaiechi ekowuna ward agaie","2019-06-11-003044.jpg","Normal","O","None","","1","0","0","129.205.113.83","2019-09-26 14:58:54","2019-09-26 14:59:05","","","","0","0000-00-00 00:00:00","2019-06-11 00:07:24","0000-00-00 00:00:00","","","Abubakar Abdullahi","07036086888","Emi tswagaiechi ekowuna ward agaie","Father","1","Abubakar Abdullahi","Emi tswagaiechi ekowuna ward agaie","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("812","0","1","0","0","4","13","1","4","13","0812","0","0","27","544","","JOSEPH ANDREW","07037167525","","","","M","2","Nigerian","13","7","1981","married","","","","dreho4u@gmail.com","","CHANCHAGA","07037167525","","IH 16 SALIHU AUDI ROAD OLD AIRPORT QUARTERS MINNA","","","Normal","B+","None","","1","0","0","105.112.115.177","2020-01-16 11:30:02","2020-01-16 11:31:01","","","","1","0000-00-00 00:00:00","2019-06-11 08:33:51","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0273","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("813","0","1","0","0","2","2","1","2","2","0813","0","0","27","541","","ABDULRAHMAN ABDULKADIR","08036411048","","","","M","1","Nigerian","8","2","1980","married","","","","abdulrahmanabdulkadira@yahoo.com","","BIDA","08036411048","","NO. 157 MU\'AZU STREET MINNA","","","Normal","A+","None","","1","0","0","105.112.112.20","2020-01-28 16:22:40","2020-01-28 16:22:49","","","","1","0000-00-00 00:00:00","2019-06-11 08:36:17","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0196","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("814","0","1","0","0","7","16","1","7","16","0814","0","0","27","544","","TANKO UMAR DANTANI","08030590150","","","","F","1","Nigerian","22","11","1976","married","","","","umartanks@gmail.com","","CHANCHAGA","08030590150","","NE 149B ALONG BOSSO ROAD MINNA","","","Normal","A+","None","","1","0","0","105.112.112.20","2020-01-28 16:26:20","2020-01-28 16:26:31","","","","1","0000-00-00 00:00:00","2019-06-11 08:38:09","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-10-30 04:31:54","0581","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("815","0","1","0","0","4","12","1","4","12","0815","0","0","27","541","","ABUBAKAR BABA MOHAMMED","09032738921","","","","M","1","Nigerian","27","4","1994","single","","","","bmohammedabubakar@gmail.com","","BIDA","09032738921","","BARIKIN SALE MINNA","","","Normal","B+","None","","1","0","0","105.112.113.15","2019-09-26 10:08:38","2019-09-26 10:08:57","","","","1","0000-00-00 00:00:00","2019-06-11 08:39:51","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0149","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("816","0","1","0","0","2","14","1","2","14","0816","0","0","27","539","","NASIRU SALE","09038617171","","","","M","1","Nigerian","10","8","1998","single","","","","angoaliyu76@yahoo.com","","AGAIE","09038617171","","MORRIS FERTILIZER COMPANY MINNA","","","Normal","B+","None","","1","0","0","197.210.53.175","2020-02-04 11:41:33","2020-02-04 17:20:50","","","","1","0000-00-00 00:00:00","2019-06-11 08:41:08","0000-00-00 00:00:00","","","","","","","1","","","1","","2","0000-00-00 00:00:00","0148","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","1");
INSERT INTO applicants VALUES("817","0","1","0","0","10","21","1","10","21","0817","0","0","27","544","","IBEH SIMON","07065259011","","","","M","2","Nigerian","19","12","1985","married","","","","ibehson4real@gmail.com","","CHANCHAGA","07065259011","","OPP. CENTRAL BANK QUARTERS TUNGA MINNA","","","Normal","O","None","","1","1","0","105.112.120.190","2020-02-06 02:24:34","2020-01-24 12:58:31","","","","1","0000-00-00 00:00:00","2019-06-11 08:42:25","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0209","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("818","0","0","0","0","0","0","1","2","2","0818","0","0","27","539","","ABDULLAHI BALA","08060053044","","","","M","1","Nigerian","18","3","1977","married","","","","angoaliyu76@yahoo.com","","AGAIE","08060053044","","EMI BAMATOR BANGBARA AREA BIDA","","","Normal","O","None","","1","0","0","197.210.54.67","2019-06-29 14:06:32","2019-06-29 14:07:58","","","","1","0000-00-00 00:00:00","2019-06-11 08:43:46","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("819","0","1","0","0","2","14","1","2","14","0819","0","0","27","544","","ALIYU USMAN","08055152482","","","","M","1","Nigerian","6","4","1968","married","","","","alusman56@gmail.com","","CHANCHAGA","08055152482","","NE 205 YAHAYA, YAHAYA CLOSE MINNA","","","Normal","AB","None","","1","0","0","197.210.54.177","2019-06-29 14:08:07","2019-06-29 14:09:26","","","","1","0000-00-00 00:00:00","2019-06-11 08:45:03","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("820","0","0","0","0","0","0","1","7","16","0820","0","0","7","127","","TSEGBA SIMON","08028432225","","","","M","1","Nigerian","24","10","1969","married","","","","tsegbasimon@gmail.com","","KATSINA ALA","08028432225","","BEHIND MYPA COLLEGE DUTSEN KURA MINNA","","","Normal","O","None","","1","0","0","197.210.54.177","2019-06-29 14:10:10","2019-06-29 14:11:28","","","","1","0000-00-00 00:00:00","2019-06-11 08:46:32","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("821","0","1","0","0","10","22","1","10","22","0821","0","0","27","550","","IBRAHIM MUSA","09051638341","","","","M","1","Nigerian","15","7","1972","married","","","","lafaimusa2@gmail.com","","LAPAI","09051638341","","G 59 JANARI ROAD LATE LAFARMA\'S HOUSE","","","Normal","O","None","","1","0","0","197.210.226.253","2020-02-07 17:34:05","2020-02-07 17:34:37","","","","1","0000-00-00 00:00:00","2019-06-11 08:48:16","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","0000-00-00 00:00:00","0412","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("822","0","1","0","0","9","18","1","9","18","0822","0","0","27","555","","JIBRIN ALHASSAN","08039219135","","","","M","1","Nigerian","5","3","1984","married","","","","angoaliyu76@yahoo.com","","MOKWA","08039219135","","EFU GORO COMPOUND MOKWA ","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 14:50:32","2020-01-16 14:50:44","","","","1","0000-00-00 00:00:00","2019-06-11 08:49:25","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0659","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("823","0","0","0","0","0","0","1","2","14","0823","0","0","27","561","","MUKTAR SULEIMAN","09030130188","","","","M","1","Nigerian","25","2","1990","single","","","","angoaliyu76@yahoo.com","","SULEJA","09030130188","","GHS 7 TUNGA LOW COST MINNA","","","Normal","O","None","","1","0","0","197.210.55.102","2019-06-29 14:14:52","2019-06-29 14:15:44","","","","1","0000-00-00 00:00:00","2019-06-11 08:50:42","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("824","0","1","0","0","2","2","1","2","2","0824","0","0","2","27","","TIZHE ZIRA","08023489293","","","","M","1","Nigerian","7","6","1972","married","","","","ziratizhe10@gmail.com","","MADAGALI","08023489293","","C/O MOMO WANDU EYU CHURCH MADAGALI LGA ADAMAWA STATE","","","Normal","A+","None","","1","0","0","105.112.120.225","2019-09-23 09:12:38","2019-09-23 09:12:58","","","","1","0000-00-00 00:00:00","2019-06-11 08:52:16","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("825","0","1","0","0","4","4","1","4","4","0825","0","0","27","544","","SABA ADAMU","08067973394","","","","M","1","Nigerian","5","5","1995","single","","","","adamusaba10@gmail.com","","CHANCHAGA","08067973394","","KPAKUNGU MINNA","","","Normal","O","None","","1","0","0","197.210.54.225","2019-06-29 14:16:44","2019-06-29 14:17:51","","","","1","0000-00-00 00:00:00","2019-06-11 08:53:29","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("826","0","1","0","0","4","13","1","4","13","0826","0","0","27","555","","ALIYU D. ABUBAKAR","08065760665","","","","M","1","Nigerian","12","5","1985","married","","","","angoaliyu76@yahoo.com","","MOKWA","08065760665","","NO 12 IBRAHIM KUCHI ROAD BARIKIN SALE MINNA","","","Normal","A+","None","","1","0","0","105.112.115.177","2020-01-16 11:35:45","2020-01-16 11:35:55","","","","1","0000-00-00 00:00:00","2019-06-11 08:54:44","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0284","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("827","0","1","0","0","10","22","1","2","15","0827","0","0","27","544","","UMAR AISHETU","08055958025","","","","F","1","Nigerian","5","1","1972","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08055958025","","OFF OKADA BAJEGO MINNA","","","Normal","O","None","","1","0","0","197.210.54.57","2019-06-29 14:18:49","2019-06-29 14:19:28","","","","1","0000-00-00 00:00:00","2019-06-11 08:56:09","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-01 14:48:41","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("828","0","1","0","0","2","2","1","2","2","0828","0","0","27","558","","BAWA MU\'AZU LIMAN","07063102726","","","","F","1","Nigerian","28","6","1978","single","","","","angoaliyu76@yahoo.com","","RAFI","07063102726","","GIDAN ALHAJI BAWA LIMAN CIKIN GARI TEGINA","","","Normal","O","None","","1","0","0","41.190.12.124","2019-10-10 11:35:22","2019-10-10 11:58:36","","","","1","0000-00-00 00:00:00","2019-06-11 08:57:11","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0281","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("829","0","0","0","0","0","0","1","2","14","0829","0","0","27","551","","FATIMA SULEIMAN","07064626147","","","","F","1","Nigerian","11","5","1993","married","","","","angoaliyu76@yahoo.com","","LAVUN","07064626147","","GURARA","","","Normal","A+","None","","1","0","0","197.210.54.159","2019-06-29 14:20:32","2019-06-29 14:22:04","","","","1","0000-00-00 00:00:00","2019-06-11 08:59:25","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("830","0","1","0","0","7","16","1","4","12","0830","0","0","27","551","","HADIZA ABUBAKAR BAWA","08035583220","","","","F","1","Nigerian","30","10","1980","married","","","","angoaliyu76@yahoo.com","","LAVUN","08035583220","","HOUSE NO4 ADJERSCENT EL-BATHEL PRIMARY AND SECONDARY SCHOOL GBEGANU AREA MINNA","","","Normal","A+","None","","1","0","0","105.112.112.20","2020-01-28 16:27:13","2020-01-28 16:27:28","","","","1","0000-00-00 00:00:00","2019-06-11 09:00:42","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-25 16:07:01","0614","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("831","0","1","0","0","2","15","1","2","15","0831","0","0","27","539","","MUSA ABDULLAHI","08066038296","","","","M","1","Nigerian","14","5","1983","married","","","","angoaliyu76@yahoo.com","","AGAIE","08066038296","","HOUSE NO 29 BOSSO ESTATE MINNA","","","Normal","O","None","","1","0","0","105.112.120.131","2019-10-29 13:31:34","2019-10-29 13:36:47","","","","1","0000-00-00 00:00:00","2019-06-11 09:01:48","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0366","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("832","0","0","0","0","0","0","1","7","16","0832","0","0","27","550","","ABDULRAHMAN ATTAHIRU MOHAMMED","08035916691","","","","M","1","Nigerian","6","8","1973","married","","","","angoaliyu76@yahoo.com","","LAPAI","08035916691","","OKADA ROAD, MINNA","","","Normal","O","None","","1","0","0","197.210.54.57","2019-06-29 14:26:34","2019-06-29 14:27:30","","","","1","0000-00-00 00:00:00","2019-06-11 09:03:24","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("833","0","1","0","0","1","11","1","1","11","0833","0","0","27","557","","MOSES PAUL","08036505658","","","","M","1","Nigerian","27","2","1984","married","","","","paulmoses010@gmail.com","","PAIKORO","08036505658","","DOWN SADIA GUESS HOUSE, SAUKA KA HUTA BEHIND TRANSFORMER MINNA","","","Normal","AB","None","","1","0","0","105.112.115.177","2020-01-16 11:00:50","2020-01-16 11:02:05","","","","1","0000-00-00 00:00:00","2019-06-11 09:04:36","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-16 18:55:31","0559","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("834","0","1","0","0","9","18","1","2","14","0834","0","0","27","550","","IDRIS AHMED MOHAMMED","08036349221","","","","M","1","Nigerian","25","12","1978","married","","","","onomeahmed1988@gmail.com","","LAPAI","08036349221","","MI WUSHISHI ESTATE NO 409 MINNA","","","Normal","O","None","","1","1","0","105.112.112.184","2020-02-19 14:57:41","2019-06-29 14:30:21","","","","1","0000-00-00 00:00:00","2019-06-11 09:06:31","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-03 08:41:55","0595","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("835","0","0","0","0","0","0","1","4","12","0835","0","0","27","550","","IBRAHIM YAKUBU KAKARAJI","08148158201","","","2019-06-11-114819GGG.pdf.pdf","M","1","Nigerian","1","2","1988","married","","","","ibrahimyakubukakaraji@gmail.com","","KAKARAJI","08148158201","","KAKARAJI","KAKARAJI","2019-06-11-101359.jpg","Normal","O","None","FIT.","1","1","0","197.210.62.36","2019-09-23 14:04:32","2019-09-23 13:46:52","","","","1","0000-00-00 00:00:00","2019-06-11 09:46:21","0000-00-00 00:00:00","","","MAIMUNAT YAKUBU","08137512758","KAKARAJI","MOTHER","1","IBRAHIM YAKUBU KAKARAJI","KAKARAJI","0","","0","0000-00-00 00:00:00","","3","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("836","0","1","0","0","10","21","1","10","21","0836","0","0","27","560","","SADIYA YUSUF","07065083535","","","2019-06-11-124517HAJARA.pdf.pdf","F","1","Nigerian","23","11","1987","single","","","","sadeeyusuf@gmail.com","","NIGER","07065083535","","AR 15 YAKUBU LAMI ROAD G.R.A MINNA NIGER STATE","AR 15 YAKUBU LAMI ROAD G.R.A MINNA NIGER STATE","2019-06-11-120724.jpg","Normal","O","None","","1","0","0","105.112.121.7","2019-10-14 14:13:00","2019-10-14 14:13:14","","","","1","0000-00-00 00:00:00","2019-06-11 11:42:11","0000-00-00 00:00:00","","","","","","","4","","","1","                                
\n                                                                 
\n                                ","3","2019-11-08 12:21:52","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("837","0","0","0","0","0","0","1","7","16","0837","0","0","27","560","","Kuluwa Ahmed","08159299464","","","2019-06-11-120935NCE PDF.pdf.pdf","M","1","Nigerian","20","6","2000","single","","","","kuluwaahmed1101@gmail.com","","Maikunkele","08159299464","","she Shiroro Local Government ","she Shiroro Local Government ","2019-06-11-115005.jpg","Normal","O","None","","1","1","0","105.112.115.135","2019-12-10 09:43:14","2019-12-10 09:43:04","","","","1","0000-00-00 00:00:00","2019-06-11 11:46:47","0000-00-00 00:00:00","","","Abdulkarim Sani","08159299464","she Shiroro Local Government ","Brother","1","Abdulkarim Sani","she Shiroro Local Government ","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("838","0","0","0","0","0","0","1","7","16","0838","0","0","27","557","","MUSTAPHA MUSA","08035170852","","","2019-06-12-100935MUU.pdf.pdf","M","1","Nigerian","8","8","1988","married","","","","mustaphababapaiko@gmail.com","","PAIKO","08035170852","","TUNGA LOCOST MINNA","TUNGA LOCOST MINNA","2019-06-14-120757.jpg","Normal","B+","None","NILL","1","1","0","105.112.120.120","2019-10-10 10:08:36","2019-06-14 12:08:09","","","","1","0000-00-00 00:00:00","2019-06-11 13:46:27","0000-00-00 00:00:00","","","MUSTAPHA","08035170852","TUNGA LOCOST MINNA","FATHER","4","MUSTAPHA","TUNGA LOCOST MINNA","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("839","0","0","0","0","0","0","1","2","14","0839","0","0","27","550","","IDRIS MOHAMMED ABDULKADIR","08136214015","","","","M","1","Nigerian","26","5","1993","single","","","","callabdulkadir@gmail.com","","LAPAI","08136214015","","NO. 43 BAY CLINIC ROAD TUNGA MINNA","","","Normal","O","None","","1","0","0","197.210.55.161","2019-06-29 14:30:34","2019-06-29 14:31:16","","","","1","0000-00-00 00:00:00","2019-06-11 14:56:01","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("840","0","0","0","0","0","0","1","2","14","0840","0","0","27","555","","ABDULLAHI SANI KUDU","08130123004","","","","M","1","Nigerian","13","3","1987","married","","","","sanikudu16@gmail.com","","MOKWA","08130123004","","LATE CHIEF IMAMS COMPOUND EMI KPANGI KUDU","","","Normal","B+","None","","1","0","0","41.190.14.99","2019-11-15 18:29:55","2019-11-15 18:30:01","","","","1","0000-00-00 00:00:00","2019-06-11 14:58:07","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("841","0","1","0","0","4","12","1","4","12","0841","0","0","27","560","","AYUBA MICHAEL","07038002721","","","","M","2","Nigerian","10","5","1992","single","","","","michaelayuba20@gmail.com","","SHIRORO","07038002721","","BESIDE ADEX BORE-HOLE MAITUMBI MINNA","","2019-09-20-090829.jpg","Normal","B+","None","","1","1","0","105.112.95.31","2020-01-28 16:08:47","2020-01-27 16:54:54","","","","1","0000-00-00 00:00:00","2019-06-11 15:01:03","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0186","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("842","0","1","0","0","9","6","1","9","6","0842","0","0","27","551","","KOLO NNAOZURU JOY","08160086126","","","","F","2","Nigerian","19","10","1991","single","","","","kolojoy19@gmail.com","","LAVUN","08160086126","","ALBASHIRI OFF BIDA ROAD CLOSE TO BRIGHT FUTURE PRIMARY SCHOOL","","","Normal","A+","None","","1","0","0","197.210.227.151","2019-07-20 13:57:56","2019-07-20 13:58:36","","","","1","0000-00-00 00:00:00","2019-06-11 15:03:07","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("843","0","1","0","0","10","20","1","10","20","0843","0","0","27","544","","AHMAD RABI SAMBO","08103088620","","","","F","1","Nigerian","9","10","1998","married","","","","ahmadrabi0019@gmail.com","","CHANCHAGA","08103088620","","NE 122 SOKOTO STREET","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 14:22:35","2020-01-16 14:22:44","","","","1","0000-00-00 00:00:00","2019-06-11 15:05:31","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-12-02 12:43:10","0652","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("844","0","1","0","0","4","4","1","4","4","0844","0","0","27","549","","IBRAHIM AMINA LADAN","07030727741","","","","F","1","Nigerian","27","9","2000","single","","","","angoaliyu76@yahoo.com","","KONTAGORA","07030727741","","NO 6 MAITUMBI MUAZU QRT","","","Normal","A+","None","","1","0","0","105.112.115.177","2020-01-16 11:34:49","2020-01-16 11:34:59","","","","1","0000-00-00 00:00:00","2019-06-11 15:06:52","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0247","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("845","0","0","0","0","0","0","1","4","12","0845","0","0","7","134","","OGWUCHE SAMUEL INALEGWU","07038329734","","","","M","2","Nigerian","15","4","1995","single","","","","samuelogwuche48@gmail.com","","OHIMINI","07038329734","","NO 15 LOKOJA STREET OTUKPO BENUE STATE","","","Normal","O","None","","1","0","0","197.210.55.155","2019-06-29 14:36:30","2019-06-29 14:37:27","","","","1","0000-00-00 00:00:00","2019-06-11 15:15:43","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("846","0","0","0","0","0","0","1","4","0","0846","0","0","27","541","","AHMED MAHMUD","08068421870","","","2019-06-11-182233CREDENTIALS.pdf.pdf","M","1","Nigerian","20","7","1979","married","","","","mbm2659@gmail.com","","BIDA","08068421870","","EMI ALHAJI MAKANTA BIDA NIGER STATE","EMI ALHAJI MAKANTA BIDA NIGER STATE","2019-06-11-183024.jpg","Normal","O","None","NA","1","1","0","41.190.14.237","2019-06-11 18:32:40","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-06-11 17:45:44","0000-00-00 00:00:00","","","MOHAMMED BABA BIDA","09036056235","EMI ALHAJI MAKANTA BIDA NIGER STATE","FATHER","1","AHMED MAHMUD","EMI ALHAJI MAKANTA BIDA NIGER STATE","0","","0","0000-00-00 00:00:00","","2","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("847","0","0","0","0","0","0","1","7","16","0847","0","0","27","541","","HAUWA MUHAMMAD","08034672098","","","2019-06-11-231705Doc1.pdf.pdf","F","1","Nigerian","13","3","1984","married","","","","aminamuhammad86@gmail.com","","NIGER","08095736842","","C/o Abubakar umar sanda Cpdu/currency office central bank of Nigeria Minna branch, Niger state.","C/o Abubakar umar sanda Cpdu/currency office central bank of Nigeria Minna branch, Niger state.","2019-06-11-223516.jpg","Normal","O","None","VERY FINE","1","0","0","41.190.14.128","2020-01-13 09:38:04","2020-01-13 09:38:29","","","","1","0000-00-00 00:00:00","2019-06-11 22:32:40","0000-00-00 00:00:00","","","MUHAMMAD MUSA BABAYAGI","08034530962","C/o Abubakar umar sanda Cpdu/currency office central bank of Nigeria Minna branch, Niger state.","FATHER","1","Abubakar Umar ","C/o Abubakar umar sanda Cpdu/currency office central bank of Nigeria Minna branch, Niger state.","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("848","0","0","0","0","0","0","1","7","5","0848","0","0","27","558","","YAKUBU YUSUF","08064391400","","","","M","1","Nigerian","2","12","1969","married","","","","yusufyakubu152@gmail.com","","RAFI","08064391400","","FEDERAL LOW COST NEAR ZION BAPTIST CHURCH MAIKUNKELE MINNA","","","Normal","O","None","","1","0","0","197.210.54.51","2019-06-29 14:37:38","2019-06-29 14:38:45","","","","1","0000-00-00 00:00:00","2019-06-12 10:11:13","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("849","0","0","0","0","0","0","1","10","21","0849","0","0","7","135","","ANDREW MARIA","08138927377","","","","F","1","Nigerian","4","6","1993","single","","","","andrewmaria812@gmail.com","","OJU","08138927377","","CHANCHAGA BEHIND ANGLICAN CHURCH","","","Normal","O","None","","1","0","0","197.210.55.155","2019-06-29 14:38:55","2019-06-29 14:39:31","","","","1","0000-00-00 00:00:00","2019-06-12 10:16:34","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("850","0","0","0","0","0","0","1","2","2","0850","0","0","27","550","","DAUDA USMAN EGGUN","08066182860","","","","M","1","Nigerian","2","2","1995","single","","","","angoaliyu76@yahoo.com","","LAPAI","08066182860","","EGGUN LAPAI, NIGER STATE","","","Normal","O","None","","1","0","0","197.210.54.143","2019-06-29 14:39:44","2019-06-29 14:40:30","","","","1","0000-00-00 00:00:00","2019-06-12 10:20:51","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("851","0","1","0","0","4","13","1","4","13","0851","0","0","27","549","","GARBA TIJJANI AHMED","08054236717","","","","M","1","Nigerian","15","3","1973","married","","","","ahmedtgarba2018@gmail.com","","KONTAGORA","08054236717","","BAY CLINIC ROAD BY AHMADU KAGO STREET TUNGA MIINNA","","","Normal","O","None","","1","0","0","105.112.112.20","2020-01-28 16:16:43","2020-01-28 16:16:52","","","","1","0000-00-00 00:00:00","2019-06-12 10:25:35","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0529","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("852","0","1","0","0","9","18","1","9","18","0852","0","0","27","555","","ABUBAKAR MOHAMMED KUDU","08174374750","","","","M","1","Nigerian","1","2","1990","single","","","","mohammedabubakarkudu@gmail.com","","MOKWA","08174374750","","A SULE HOUSE, BEHIND LEA PRIMARY SCHOOL KUDU MOKWA LGA","","","Normal","B+","None","","1","0","0","105.112.115.177","2020-01-16 14:56:26","2020-01-16 14:56:59","","","","1","0000-00-00 00:00:00","2019-06-12 10:27:25","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0254","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("853","0","1","0","0","7","16","1","7","16","0853","0","0","27","561","","LADAN ISYAKU JIBRIN","08093710078","","","","M","1","Nigerian","20","2","1985","single","","","","angoaliyu76@yahoo.com","","SULEJA","08093710078","","MATASA DRIVE BOSSO LOW COST HOUSE NO 143","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 13:36:09","2020-01-16 13:36:28","","","","1","0000-00-00 00:00:00","2019-06-12 10:28:20","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0309","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("854","0","0","0","0","0","0","1","2","14","0854","0","0","27","541","","ABUBAKAR ABDULMALIK","08037008982","","","","M","1","Nigerian","6","4","1968","married","","","","angoaliyu76@yahoo.com","","BIDA","08037008982","","GOVERNMENT HOUSE MINNA PROTOCOL ","","","Normal","O","None","","1","0","0","197.210.54.241","2019-06-29 14:43:37","2019-06-29 14:44:21","","","","1","0000-00-00 00:00:00","2019-06-12 10:29:42","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("855","0","1","0","0","2","14","1","2","14","0855","0","0","27","558","","ADAMU UMAR ALLAWA","08065696512","","","","M","1","Nigerian","14","5","1978","married","","","","angoaliyu76@yahoo.com","","RAFI","08065696512","","GIDAN KUKA NYIKANGBE AREA MINNA","","","Normal","B+","None","","1","0","0","105.112.115.177","2020-01-16 12:58:43","2020-01-16 12:58:54","","","","1","0000-00-00 00:00:00","2019-06-12 10:31:23","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0120","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("856","0","1","0","0","9","18","1","9","18","0856","0","0","7","136","","EMMANUEL ESTHER","08075468901","","","","F","2","Nigerian","27","2","1983","married","","","","obsimforall98@yahoo.com","","OKPOKWU ","08075468901","","POLICE SECONDARY SCHOOL MINNA","","","Normal","O","None","","1","0","0","197.210.54.241","2019-06-29 14:45:22","2019-06-29 14:46:16","","","","1","0000-00-00 00:00:00","2019-06-12 10:32:43","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-06 22:39:15","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("857","0","0","0","0","0","0","1","1","10","0857","0","0","0","0","","RASHIDA YAHAYA","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07064520982","","","","","","","","","1","0","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-06-12 10:34:08","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("858","0","0","0","0","0","0","1","1","10","0858","0","0","27","544","","RASHIDA YAHAYA","07064520982","","","","F","1","Nigerian","6","2","1981","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","07064520982","","DR. SULEIMAN STREET CHANCHAGA MINNA","","","Normal","O","None","","1","0","0","105.112.120.177","2019-11-19 13:49:55","2019-11-19 13:50:13","","","","1","0000-00-00 00:00:00","2019-06-12 10:34:09","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("859","0","0","0","0","0","0","1","2","2","0859","0","0","27","541","","DAUDA SALIHU","07036990063","","","","M","1","Nigerian","15","12","1989","married","","","","angoaliyu76@yahoo.com","","BIDA","07036990063","","MORRIS FERTILIZER COMPANY","","","Normal","B+","None","","1","0","0","197.210.54.6","2019-06-29 15:05:07","2019-06-29 15:05:17","","","","1","0000-00-00 00:00:00","2019-06-12 10:35:52","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("860","0","0","0","0","0","0","1","7","5","0860","0","0","0","0","","MOHAMMED IDRIS","","","","","","0","","","","","","","","","idrismohammed72@yahoo.com","","","08063128436","","","","","","","","","1","0","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-06-12 10:37:06","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("861","0","1","0","0","10","20","1","7","5","0861","0","0","27","551","","MOHAMMED IDRIS","08063128436","","","","M","1","Nigerian","4","3","1990","single","","","","idrismohammed72@yahoo.com","","LAVUN","08063128436","","BUSU","","","Normal","B+","None","","1","0","0","105.112.116.72","2020-01-24 13:00:41","2020-01-24 13:00:56","","","","1","0000-00-00 00:00:00","2019-06-12 10:37:06","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0395","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("862","0","0","0","0","0","0","1","1","11","0862","0","0","27","541","","MOHAMMED AHMED SHEHU","08060037476","","","","M","1","Nigerian","25","5","1984","married","","","","shehuahmadm@gmail.com","","BIDA","08060037476","","EFU ETSU YISA AREA FMC ROAD BIDA","","","Normal","AB","None","","1","0","0","197.210.55.13","2019-06-29 14:52:16","2019-06-29 15:00:38","","","","1","0000-00-00 00:00:00","2019-06-12 10:38:42","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("863","0","0","0","0","0","0","1","9","18","0863","0","0","0","0","","NGWU IFEOMA JESSICA","","","","","","0","","","","","","","","","jessicangwu@yahoo.com","","","08033442155","","","","","","","","","1","0","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-06-12 10:40:40","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("864","0","0","0","0","0","0","1","9","18","0864","0","0","0","0","","NGWU IFEOMA JESSICA","","","","","","0","","","","","","","","","jessicangwu@yahoo.com","","","08033442155","","","","","","","","","1","0","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-06-12 10:40:40","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("865","0","1","0","0","9","18","1","9","18","0865","0","0","14","268","","NGWU IFEOMA JESSICA","08033442155","","","","F","2","Nigerian","2","1","1990","married","","","","jessicangwu@yahoo.com","","ISI UZO ","08033442155","","OFF NITECO ROAD TUNGA MINNA","","","Normal","O","None","","1","0","0","105.112.121.59","2019-11-01 15:17:58","2019-11-01 15:18:20","","","","1","0000-00-00 00:00:00","2019-06-12 10:40:41","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-01 15:19:16","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("866","0","0","0","0","0","0","1","1","10","0866","0","0","27","541","","ABDULLAHI TUKUR MUHAMMED","08065242953","","","","M","1","Nigerian","16","7","1982","single","","","","abdultukur45@gmail.com","","BIDA","08065242953","","158 BOSSO LOWCOST MINNA","","","Normal","O","None","","1","0","0","197.210.54.241","2019-06-29 15:01:45","2019-06-29 15:02:27","","","","1","0000-00-00 00:00:00","2019-06-12 10:42:55","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("867","0","0","0","0","0","0","1","4","13","0867","0","0","27","541","","MUSA MUHAMMAD ABDULQUDDUS","08060104779","","","","M","1","Nigerian","19","1","1967","married","","","","bokunfari@gmail.com","","BIDA","08060104779","","PO BOX 59, EDATI MASABA AREA","","","Normal","O","None","","1","0","0","197.210.55.141","2019-06-29 15:02:41","2019-06-29 15:03:29","","","","1","0000-00-00 00:00:00","2019-06-12 10:44:48","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("868","0","0","0","0","0","0","1","1","11","0868","0","0","27","563","","USMAN MOHAMMED","07055822128","","","","M","1","Nigerian","1","1","1972","married","","","","angoaliyu76@yahoo.com","","WUSHISHI","07055822128","","TUDUN WADA WUSHISHI","","","Normal","O","None","","1","0","0","197.210.54.110","2019-06-29 15:03:42","2019-06-29 15:04:57","","","","1","0000-00-00 00:00:00","2019-06-12 10:45:50","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("869","0","0","0","0","0","0","1","10","21","0869","0","0","27","558","","MUHAMMAD SANI","07062247121","","","","M","1","Nigerian","1","1","1991","single","","","","angoaliyu76@yahoo.com","","RAFI","07062247121","","KAGARA RAFI LOCAH GOVIMASOYI CIKIN GARI KAGARA","","","Normal","A+","None","","1","1","0","105.112.120.225","2019-09-23 08:53:17","2019-08-19 17:11:53","","","","1","0000-00-00 00:00:00","2019-06-12 10:46:48","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("870","0","0","0","0","0","0","1","4","4","0870","0","0","27","541","","ABDULLAHI IBN MUSA","08039571476","","","","M","1","Nigerian","6","9","1984","married","","","","ibnmusaabdullahi@yahoo.com","","BIDA","08039571476","","EFUTURI AREA BIDA","","","Normal","A+","None","","1","1","0","165.227.213.62","2019-12-20 08:02:04","2019-12-05 22:41:01","","","","1","0000-00-00 00:00:00","2019-06-12 10:48:25","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("871","0","0","0","0","0","0","1","7","5","0871","0","0","27","541","","HAMEED MANI MUHAMMED AWWAL","08068159050","","","","M","1","Nigerian","9","11","1993","married","","","","angoaliyu76@yahoo.com","","BIDA","08068159050","","NO 206 E OLD AIRPORT CURTERS","","","Normal","O","None","","1","0","0","197.210.54.90","2019-06-29 15:06:35","2019-06-29 15:07:18","","","","1","0000-00-00 00:00:00","2019-06-12 10:49:41","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("872","0","0","0","0","0","0","1","10","21","0872","0","0","27","544","","KALAMU HAMZA MUSA","08166478385","","","","M","1","Nigerian","8","12","1992","single","","","","hamzakalamu@gmail.com","","","08166478385","","MAITUNBI OPPOSITE ADP MINNA ,NIGER STATE","","","Normal","O","None","","1","0","0","197.210.54.90","2019-06-29 15:07:29","2019-06-29 15:09:03","","","","1","0000-00-00 00:00:00","2019-06-12 10:51:54","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("873","0","0","0","0","0","0","1","4","12","0873","0","0","27","551","","LIMAN HUSSAINI BASHIRU","08136669091","","","","M","1","Nigerian","22","9","1992","single","","","","limanbashirbam@gmail.com","","LAVUN","08136669091","","BLOCK 8 FLAT 1 P.W KUBWA ABUJA ALEIRO CRECENT","","","Normal","A+","None","","1","0","0","197.210.55.7","2019-06-29 15:09:18","2019-06-29 15:14:36","","","","1","0000-00-00 00:00:00","2019-06-12 10:53:37","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("874","0","1","0","0","4","4","1","4","4","0874","0","0","27","547","","JATAU ANYITOBOZUKIN ADRIAN","08162324952","","","","M","2","Nigerian","11","7","1984","single","","","","ajatau52@gmail.com","","GURARA","08162324952","","NO 174 OFF GIDAN MATASA, BOSSO LOW-COST HOUSING ESTATE MINNA NIGER STATE.","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 11:32:07","2020-01-16 11:32:20","","","","1","0000-00-00 00:00:00","2019-06-12 10:55:39","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0301","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("875","0","0","0","0","0","0","1","4","12","0875","0","0","27","560","","ALHASSAN SAKINA GAMBO","09036361709","","","","F","1","Nigerian","12","2","1994","married","","","","angoaliyu76@yahoo.com","","SHIRORO","09036361709","","BARKIN SALE (C) BEFORE HILL POINT INTERNATIONAL SCHOOL","","","Normal","O","None","","1","0","0","197.210.52.54","2019-08-19 17:13:34","2019-08-19 17:16:24","","","","1","0000-00-00 00:00:00","2019-06-12 10:57:02","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("876","0","0","0","0","0","0","1","10","21","0876","0","0","27","546","","ABDULLAHI BALKISU","07061297207","","","","F","1","Nigerian","23","6","1993","married","","","","nanabilqeesemindako@gmail.com","","GBAKO","07061297207","","OKADA ROAD","","","Normal","A+","None","","1","0","0","105.112.120.131","2019-07-01 11:20:38","2019-07-01 11:21:51","","","","0","0000-00-00 00:00:00","2019-06-12 10:58:43","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("877","0","1","0","0","4","12","1","4","12","0877","0","0","27","541","","MUSA NDAGI RAMATU","08035962987","","","","F","1","Nigerian","22","5","1981","married","","","","angoaliyu76@yahoo.com","","BIDA","08035962987","","BESIDE SHIRORO HOTEL TUNGA MINNA NIGER STATE.","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 11:46:36","2020-01-16 11:46:45","","","","1","0000-00-00 00:00:00","2019-06-12 10:59:55","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0236","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("878","0","1","0","0","2","15","1","2","15","0878","0","0","27","550","","MUHAMMAD FAUZIYA YUNUSA","07032186628","","","","F","1","Nigerian","1","11","1995","single","","","","fauz95@gmail.com","","LAPAI","07032186628","","GURARA ALBISHRI BIDA ROAD MINNA NIGER STATE.","","","Normal","B+","None","","1","0","0","105.112.112.20","2020-01-28 16:23:46","2020-01-28 16:23:58","","","","1","0000-00-00 00:00:00","2019-06-12 11:01:38","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-04 16:04:02","0467","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("879","0","1","0","0","10","20","1","10","20","0879","0","0","27","541","","USMAN HALIMA","07065663062","","","","F","1","Nigerian","2","7","1993","married","","","","angoaliyu76@yahoo.com","","BIDA","07065663062","","OPPOSITE KHAISAL ISLAMIC SCHOOL AL-BISHIRI BIDA ROAD MINNA","","","Normal","O","None","","1","0","0","197.210.64.232","2020-01-02 22:58:03","2020-01-02 22:58:35","","","","1","0000-00-00 00:00:00","2019-06-12 11:03:12","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0225","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("880","0","0","0","0","0","0","1","1","10","0880","0","0","23","478","","AGUDA FOLORUNSHO MICHAEL","08038232364","","","","M","2","Nigerian","26","7","1975","married","","","","angoaliyu76@yahoo.com","","KABBA BUNU","08038232364","","NO 50C FARM CENTRE","","","Normal","O","None","","1","0","0","197.210.62.31","2019-08-21 12:12:09","2019-08-21 12:13:30","","","","1","0000-00-00 00:00:00","2019-06-12 11:05:06","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("881","0","1","0","0","2","15","1","2","15","0881","0","0","27","563","","ALIYU MUHAMMED","08036200070","","","","M","1","Nigerian","10","7","1970","married","","","","angoaliyu76@yahoo.com","","WUSHISHI","08036200070","","BEHIND PRESION QUATERS TUNGA","","","Normal","O","None","","1","0","0","105.112.122.165","2020-02-03 19:20:27","2020-02-03 19:22:00","","","","1","0000-00-00 00:00:00","2019-06-12 11:27:32","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0449","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("882","0","1","0","0","10","21","1","7","16","0882","0","0","27","551","","JIYA JANET JUMMAI","08034858013","","","","F","1","Nigerian","21","1","1966","married","","","","angoaliyu76@yahoo.com","","LAVUN","08034858013","","HOUSE G ESTATE NO 350 TALBA HOUSING ESTATE MINNA NIGER STATE","","","Normal","O","None","","1","0","0","105.112.117.56","2020-02-17 11:26:57","2020-02-17 11:34:25","","","","1","0000-00-00 00:00:00","2019-06-12 11:28:37","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                                                 
\n                                ","3","2020-02-26 15:20:08","0498","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("883","0","0","0","0","0","0","1","4","12","0883","0","0","0","0","","ABUBAKAR USMAN KUDU","","","","","","0","","","","","","","","","sadeeqwunangi@gmail.com","","","09063626468","","","","","","","","","1","0","0","197.210.57.2","2019-07-09 16:38:17","2019-07-09 16:38:24","","","","0","0000-00-00 00:00:00","2019-06-12 18:49:58","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("884","0","0","0","0","0","0","1","4","12","0884","0","0","0","0","","ABUBAKAR USMAN KUDU","","","","","","0","","","","","","","","","sadeeqwunangi@gmail.com","","","09063626468","","","","","","","","","1","0","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-06-12 18:59:25","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("885","0","0","0","0","0","0","1","7","16","0885","0","0","0","0","","FIRDAUSI IBRAHIM SHAFII ","","","","2019-06-14-223844New Doc 2019-06-13 18.37.01.pdf.pdf","","0","","","","","","","","","firdausiibro@gmail.com","","","08033646508","","","","2019-06-12-205810.jpg","","","","","1","1","0","105.112.112.116","2019-11-05 19:23:34","2019-11-01 14:43:29","","","","1","0000-00-00 00:00:00","2019-06-12 19:22:40","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("886","0","0","0","0","0","0","1","4","13","0886","0","0","27","541","","MUHAMMAD BUHARI USMAN","07067312938","","","2019-07-04-093726Doc12.pdf.pdf","M","1","Nigerian","28","4","1995","single","","","","buharimuhammadusman@gmail.com","","BIDA","07067312938","","HOUSE NO. 23 TALBA HOUSING ESTATE MINNA, NIGER STATE","HOUSE NO. 23 TALBA HOUSING ESTATE MINNA, NIGER STATE","2019-06-28-155319.jpg","Normal","O","None","NIL","1","0","0","197.211.57.202","2019-12-05 11:36:44","2019-12-05 11:37:41","","","","1","0000-00-00 00:00:00","2019-06-13 08:58:22","0000-00-00 00:00:00","","","NDAKO LIMAN MUHAMMAD","07067360837","HOUSE NO. 23 TALBA HOUSING ESTATE MINNA, NIGER STATE","FATHER","1","MOHAMMED BUHARI ","HOUSE NO. 23 TALBA HOUSING ESTATE MINNA, NIGER STATE","0","","0","0000-00-00 00:00:00","","1","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("887","0","0","0","0","0","0","1","2","2","0887","0","0","0","0","","Muhammed yahaya","","","","2019-06-13-210340mk3.pdf.pdf","","0","","","","","","","","","emdeeejr@gmail.com","","","07069114110","","","","2019-06-13-210946.jpg","","","","","1","1","0","197.210.46.42","2019-06-13 20:39:58","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-06-13 12:48:20","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("888","0","0","0","0","0","0","1","10","20","0888","0","0","0","0","","MOHAMMED VATSA","","","","","","0","","","","","","","","","guluvat4real@gmail.com","","","08051987266","","","","","","","","","1","0","0","105.112.122.195","2019-09-24 09:46:52","2019-09-24 09:52:19","","","","0","0000-00-00 00:00:00","2019-06-13 13:42:39","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("889","0","1","0","0","2","2","1","2","14","0889","0","0","27","559","","MUHAMMAD FARIDA","08136937666","","","2019-06-13-140549Doc1.pdf.pdf","F","1","Nigerian","11","10","1994","married","","","","faridamuhammad25@gmail.com","","NIGER STATE","08136937666","","ADAMAWA DUTSEN KURA MINNA NIGER STATE","ADAMAWA DUTSEN KURA MINNA NIGER STATE","2019-06-13-135023.jpg","Normal","O","None","","1","0","0","105.112.112.20","2020-01-28 16:23:09","2020-01-28 16:23:20","","","","1","0000-00-00 00:00:00","2019-06-13 13:44:49","0000-00-00 00:00:00","","","MOHAMMED SUMAN","08136937666","ADAMAWA DUTSEN KURA MINNA NIGER STATE","FATHER","1","FARIDA MUHAMMAD","ADAMAWA DUTSEN KURA MINNA NIGER STATE","1","                                
\n                                                                 
\n                                ","3","2019-12-28 12:31:42","0014","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("890","0","0","0","0","0","0","1","2","14","0890","0","0","0","0","","MUHAMMAD FARIDA","","","","","","0","","","","","","","","","faridamuhammad25@gmail.com","","","08136937666","","","","","","","","","1","0","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-06-13 13:47:55","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("891","0","0","0","0","0","0","1","4","4","0891","0","0","0","0","","Al-kasim Muhammad","","","","","","0","","","","","","","","","alqasimjr@gmail.com","","","08140798703","","","","","","","","","1","1","0","197.210.226.119","2019-06-14 06:03:55","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-06-14 06:02:52","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("892","0","0","0","0","0","0","1","4","12","0892","0","0","27","551","","AWWAL MOHAMMED","07030612333","","","2019-06-14-110051Doc1.pdf.pdf","M","1","Nigerian","19","11","1992","married","","","","awwalmakun@gmail.com","","NIGER STATE","07030612333","","BEHIND UNITY CLINIC BIDA ROAD KPAKUNGU MINNA","BEHIND UNITY CLINIC BIDA ROAD KPAKUNGU MINNA","2019-06-14-100801.jpg","Normal","O","None","","1","0","0","41.190.14.106","2019-06-14 11:28:50","2019-06-14 11:32:36","","","","1","0000-00-00 00:00:00","2019-06-14 09:58:36","0000-00-00 00:00:00","","","MALLAM MOHAMMED CHADO","08036387666","BEHIND UNITY CLINIC BIDA ROAD KPAKUNGU MINNA","FATHER","1","MALLAM MOHAMMED CHADO","BEHIND UNITY CLINIC BIDA ROAD KPAKUNGU MINNA","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("893","0","1","0","0","4","13","1","4","13","0893","0","0","27","550","","MOHAMMED A IBRAHIM","08037185850","","","2019-06-14-155934MADE.pdf.pdf","M","1","Nigerian","20","9","1972","married","","","","muhatsu721@gmail.com","","GBAGE","08037185850","","SSG OFFICE ( GOVERNMENT HOUSE MINNA NIGER STATE)","SSG OFFICE ( GOVERNMENT HOUSE MINNA NIGER STATE)","","Normal","O","None","nill","1","0","0","105.112.115.177","2020-01-16 11:48:11","2020-01-16 11:48:22","","","","1","0000-00-00 00:00:00","2019-06-14 11:14:17","0000-00-00 00:00:00","","","IBRAHIM","08033185850","SSG OFFICE ( GOVERNMENT HOUSE MINNA NIGER STATE)","father","4","NIL","SSG OFFICE ( GOVERNMENT HOUSE MINNA NIGER STATE)","1","                                
\n                                                                 
\n                                ","3","2019-11-08 11:33:43","0462","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("894","0","0","0","0","0","0","1","2","14","0894","0","0","27","539","","MOHAMMED HARUNA","09063777307","","","2019-06-14-162407mohammed haruna.pdf.pdf","M","1","Nigerian","1","1","1980","married","","","","mohammedharuna77307@gmail.com","","Wanigi","09063777307","","Emi nda goshi Wanigi via Agaie, Niger State","Emi nda goshi Wanigi via Agaie, Niger State","2019-06-14-160314.jpg","Normal","A+","None","","1","0","0","129.205.113.215","2019-06-14 16:23:34","2019-06-14 16:31:06","","","","0","0000-00-00 00:00:00","2019-06-14 15:21:47","0000-00-00 00:00:00","","","Haruna Mamman","08077397293","Emi nda goshi Wanigi via Agaie, Niger State","Father","1","Mohammed Haruna","Emi nda goshi Wanigi via Agaie, Niger State","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("895","0","1","0","0","9","6","1","11","23","0895","0","0","27","539","","Ahmadu Ibrahim Hassan","08088023518","","","2019-06-16-115039AHMADU HASSAN IBRAHIM_compressPDF.pdf.pdf","M","1","Nigerian","5","5","1997","single","","","","Ahmaduhibrahim303@gmail.com","","Agaie","08088023518","","A21 emi kpokpota ekossa ward agaie","A21 emi kpokpota ekossa ward agaie","2019-06-16-105803.jpg","Normal","O","None","","1","1","0","105.112.112.184","2020-01-17 16:12:27","2019-09-20 23:53:07","","","","1","0000-00-00 00:00:00","2019-06-15 07:56:35","0000-00-00 00:00:00","","","Alh. Ibrahim Abdullahi","08068786303","A21 emi kpokpota ekossa ward agaie","Father","1","Alh. Ibrahim Abdullahi","A21 emi kpokpota ekossa ward agaie","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("896","0","0","0","0","0","0","1","11","23","0896","0","0","27","562","","Muhammad Naziru Akawu","08059336286","","","2019-06-16-164438NAZIRU AKAWU MUHAMMAD_compressPDF.pdf.pdf","M","1","Nigerian","7","5","2002","single","","","","Akawunaziru@yahoo.com","","Tafa","08059336286","","Opposite central primary school new-wuse","Opposite central primary school new-wuse","2019-07-04-105550.jpg","Normal","O","None","","1","0","0","129.205.113.83","2019-09-20 23:53:46","2019-09-20 23:53:55","","","","0","0000-00-00 00:00:00","2019-06-16 16:05:24","0000-00-00 00:00:00","","","Haj. Hauwa Muhammad","08072529095","Opposite central primary school new-wuse","Mother","1","Haj. Hauwa Muhammad","Opposite central primary school new-wuse","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("897","0","0","0","0","0","0","1","2","2","0897","0","0","0","0","","Ahmadu Aliyu Haruna","","","","","","0","","","","","","","","","elharuonven@yahoo.com","","","08034541486","","","","","","","","","1","0","0","197.210.58.59","2019-06-16 19:49:39","2019-06-16 19:50:28","","","","0","0000-00-00 00:00:00","2019-06-16 19:49:04","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("898","0","0","0","0","0","0","1","4","12","0898","0","0","27","550","","MOHAMMED K FATIMA","07033353033","","","2019-06-17-160250FATIMA.pdf.pdf","F","1","Nigerian","13","4","1996","single","","","","2019fatimamohammed@gmail.com","","LAPAI","07033353033","","FEDERAL LOWCOST LAPAI. NIGER STATE","FEDERAL LOWCOST LAPAI. NIGER STATE","2019-06-17-160725.jpg","Normal","O","None","NIL","1","1","0","197.210.60.175","2019-06-17 15:39:09","0000-00-00 00:00:00","","","","1","0000-00-00 00:00:00","2019-06-17 15:38:17","0000-00-00 00:00:00","","","MOHAMMED ISAH","08027761585","FEDERAL LOWCOST LAPAI. NIGER STATE","FATHER","1","MOHAMMED ISAH","FEDERAL LOWCOST LAPAI. NIGER STATE","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("899","0","0","0","0","0","0","1","11","25","0899","0","0","0","0","","MOHAMMED ISAH GALADIMA","","","","","","0","","","","","","","","","mohammedisahpk@gmail.com","","","08111160644","","","","","","","","","1","0","0","197.210.53.56","2019-06-30 10:10:06","2019-06-30 10:10:46","","","","0","0000-00-00 00:00:00","2019-06-17 16:33:16","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("900","0","0","0","0","0","0","1","11","23","0900","0","0","0","0","","MOHAMMED ISAH GALADIMA","","","","","","0","","","","","","","","","mohammedisahpk@gmail.com","","","08111160644","","","","","","","","","1","1","0","197.210.58.60","2019-06-17 16:52:15","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-06-17 16:51:44","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("901","0","0","0","0","0","0","1","1","10","0901","0","0","27","539","","BABA SALISU .MOHAMMED","08169373910","","","","M","1","Nigerian","15","10","1980","married","","","","angoaliyu76@yahoo.com","","AGAIE","08169373910","","BEHIND POLICE STATION BAREIKINSALE MINNA","","","Normal","O","None","","1","0","0","197.210.54.159","2019-06-29 15:23:50","2019-06-29 15:24:50","","","","1","0000-00-00 00:00:00","2019-06-18 10:18:21","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("902","0","1","0","0","1","11","1","1","11","0902","0","0","27","544","","ABUBAKAR MIJIYAWA UMAR","08034938873","","","2019-12-24-141446Abubakar Umar IBBUL.pdf.pdf","M","1","Nigerian","20","6","1979","married","","","","umarmijinyawa62@gmail.com","","CHANCHAGA","08034938873","","MINNA EMIR PALACE ","","2019-12-24-132804.jpg","Normal","O","None","","1","0","0","105.112.112.20","2020-01-28 15:44:53","2020-01-28 15:46:37","","","","1","0000-00-00 00:00:00","2019-06-18 10:39:48","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0664","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("903","0","1","0","0","1","11","1","1","11","0903","0","0","0","0","","ISAH LIMAN YIDDAN","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08033405588","","","","","","","","","1","0","0","105.112.114.140","2020-01-16 09:48:45","2020-01-16 09:49:12","","","","1","0000-00-00 00:00:00","2019-06-18 10:48:41","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0380","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("904","0","0","0","0","0","0","1","10","21","0904","0","0","0","0","","YO. MAR","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08035840678","","","","","","","","","1","0","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-06-18 11:07:21","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("905","0","1","0","0","10","21","1","10","21","0905","0","0","27","544","","ABBAH O. MARY","08035840678","","","","F","2","Nigerian","3","1","1978","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08035840678","","BEHIND MYPA COLLEGE DUTSEN KURAN GWARI, MINNA NIGER STATE","","","Normal","B+","None","","1","0","0","197.210.64.158","2020-01-02 23:18:55","2020-01-02 23:19:37","","","","1","0000-00-00 00:00:00","2019-06-18 11:08:29","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0400","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("906","0","0","0","0","0","0","1","7","5","0906","0","0","27","555","","ABUBAKAR MAHMUD BOKANU","09032521212","","","","M","1","Nigerian","19","8","1993","single","","","","mudex088@gmail.com","","MOKWA","09032521212","","NO 12 BEHIND ACCESS BANK, CLOSE TO CENTRAL MOSQUE MINNA NIGER STATE","","","Normal","O","None","","1","0","0","197.210.54.187","2019-06-29 15:27:57","2019-06-29 15:28:44","","","","1","0000-00-00 00:00:00","2019-06-18 11:10:00","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("907","0","1","0","0","9","6","1","9","6","0907","0","0","27","544","","IBRAHIM NDAKO","08060830380","","","","M","1","Nigerian","20","11","1995","single","","","","chiyamamakee2011@gmail.com","","CHANCHAGA","08060830380","","N.E  173 NASSARAWA \"B\" WARD MINNA OPP POLICE MEDICAL CLINIC MINNA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 14:49:54","2020-01-16 14:50:03","","","","1","0000-00-00 00:00:00","2019-06-18 11:11:01","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","0000-00-00 00:00:00","0426","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("908","0","1","0","0","9","6","1","9","6","0908","0","0","0","0","","KUDU MAIMUNA MOHAMMED","","","","","","0","","","","","","","","","kudumaimunamohammed@yahoo.ocm","","","08128004066","","","","","","","","","1","0","0","197.210.54.216","2019-06-29 15:29:57","2019-06-29 15:31:11","","","","1","0000-00-00 00:00:00","2019-06-18 11:12:18","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("909","0","0","0","0","0","0","1","2","2","0909","0","0","27","539","","USMAN MOHAMMED ","08054647082","","","","M","1","Nigerian","4","6","1975","married","","","","angoaliyu76@yahoo.com","","AGAIE","08054647082","","MOBIL QUATERS BEHIND TUNGA MARKET","","","Normal","O","None","","1","0","0","105.112.120.197","2019-11-04 08:31:16","2019-11-04 08:45:40","","","","1","0000-00-00 00:00:00","2019-06-18 11:13:15","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("910","0","1","0","0","9","6","1","4","4","0910","0","0","27","544","","USMAN HUZAIFAH","08130282303","","","","M","1","Nigerian","17","9","1997","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08130282303","","N.P 18 NASARAWA B\\\' WARD MINNA NIGER STATE","","","Normal","O","None","","1","0","0","105.112.112.43","2019-11-19 15:27:48","2019-11-19 15:29:58","","","","1","0000-00-00 00:00:00","2019-06-18 11:14:18","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-19 13:44:34","0583","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("911","0","1","0","0","7","16","1","4","12","0911","0","0","27","546","","ABDULLAHI MAMA HADIZA","08036819494","","","","F","1","Nigerian","21","11","1982","married","","","","angoaliyu76@yahoo.com","","GBAKO","08036819494","","KUTRIKO AREA","","","Normal","A+","None","","1","0","0","105.112.116.72","2020-01-24 12:51:55","2020-01-24 12:52:35","","","","1","0000-00-00 00:00:00","2019-06-18 11:15:33","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2019-12-12 11:57:32","0237","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("912","0","1","0","0","2","14","1","2","14","0912","0","0","27","550","","ABUBAKAR AMINA GANA","07030436185","","","","F","1","Nigerian","23","3","1978","married","","","","angoaliyu76@yahoo.com","","LAPAI","07030436185","","TUNGA CUSTOM BARRACK MINNA NIGER STATE","","","Normal","A+","None","","1","0","0","105.112.122.165","2020-02-03 19:22:08","2020-02-03 19:23:55","","","","1","0000-00-00 00:00:00","2019-06-19 09:44:12","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0305","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("913","0","1","0","0","1","1","1","1","1","0913","0","0","27","541","","FATIMA MOHAMMED","08039655388","","","","F","1","Nigerian","11","3","1982","married","","","","angoaliyu76@yahoo.com","","BIDA","08039655388","","HOUSE OPPOSITE SUPREME WATER KPAKUNGU MINNA NIGER STATE.","","","Normal","O","None","","1","0","0","105.112.112.20","2020-01-28 15:47:36","2020-01-28 15:47:52","","","","1","0000-00-00 00:00:00","2019-06-19 10:01:42","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0407","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("914","0","0","0","0","0","0","1","10","21","0914","0","0","27","123","","FELICIA ORTESSE","07065543459","","","","F","2","Nigerian","17","5","1990","single","","","","angoaliyu76@yahoo.com","","GBOKO","07065543459","","BEHIND HOUSE OF ASSEMBLY QUARTERS TUNGA MINNA NIGER STATE","","","Normal","O","None","","1","0","0","197.210.227.188","2019-07-20 11:51:43","2019-07-20 11:52:41","","","","1","0000-00-00 00:00:00","2019-06-19 10:20:11","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("915","0","1","0","0","2","2","1","2","2","0915","0","0","23","477","","AJIBOYE EMMANUEL","08168382858","","","","M","2","Nigerian","7","7","1996","single","","","","angoaliyu76@yahoo.com","","IJUMU","08168382858","","NO 158 GBAKOITA CHANCHAGA MINNA NIGER STATE.","","","Normal","B+","None","","1","0","0","197.210.226.240","2019-07-20 11:52:50","2019-07-20 11:53:53","","","","1","0000-00-00 00:00:00","2019-06-19 11:26:22","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("916","0","1","0","0","2","15","1","2","15","0916","0","0","27","560","","TANKO SHEHU","08034350944","","","","M","1","Nigerian","28","1","1972","married","","","","angoaliyu76@yahoo.com","","SHIRORO","08034350944","","BEHIND CENTRAL PRIMARY SCHOOL SHO VILLAGE SHIRORO LOCAL GOVERNMENT AREA MINNA NIGER STATE","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 13:22:25","2020-01-16 13:23:07","","","","1","0000-00-00 00:00:00","2019-06-19 11:52:26","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-08 10:25:27","0517","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("917","0","0","0","0","0","0","1","1","11","0917","0","0","27","548","","IBRAHIM MOHAMMED","07065529713","","","","M","1","Nigerian","15","2","1985","married","","","","angoaliyu76@yahoo.com","","KATCHA","07065529713","","EMI ALHAJI YANDA BADEGGI EFU KYADE AREA BIDA","","","Normal","O","None","","1","0","0","197.210.226.240","2019-07-20 11:55:18","2019-07-20 11:56:09","","","","1","0000-00-00 00:00:00","2019-06-19 12:07:42","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("918","0","0","0","0","0","0","1","4","4","0918","0","0","27","541","","AHMED MAHMUD","08053399489","","","","M","1","Nigerian","20","7","1979","married","","","","angoaliyu76@yahoo.com","","BIDA","08053399489","","OFFICE NO. 7 BALTIC CRESCENT BANURE STREET MAITAMA ABUJA","","","Normal","O","None","","1","0","0","197.210.227.142","2019-07-20 11:56:18","2019-07-20 11:57:06","","","","1","0000-00-00 00:00:00","2019-06-19 12:11:42","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("919","0","0","0","0","0","0","1","4","12","0919","0","0","27","539","","IDRIS YABAGI UMARU","08028018155","","","","M","1","Nigerian","2","6","1969","married","","","","angoaliyu76@yahoo.com","","AGAIE","08028018155","","GBAGANU AREA ALONG BIDA ROAD MINNA NIGER STATE","","","Normal","B+","None","","1","0","0","197.210.227.151","2019-07-20 11:57:19","2019-07-20 11:58:26","","","","1","0000-00-00 00:00:00","2019-06-19 12:13:20","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("920","0","1","0","0","4","12","1","2","14","0920","0","0","27","544","","USMAN LARAI","08061562480","","","","F","1","Nigerian","2","2","1994","married","","","","angoaliyu76@yahoo.com","","","08061562480","","OPPOSITE GIDAN KWANU TUNGA MINNA NIGER STATE,","","","Normal","A+","None","","1","0","0","197.210.227.164","2019-07-20 11:58:31","2019-07-20 11:59:18","","","","1","0000-00-00 00:00:00","2019-06-19 13:03:55","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-04 10:02:09","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("921","0","1","0","0","1","1","1","1","10","0921","0","0","27","539","","UMAR YAKUBU MOHAMMED","08155361842","","","","M","1","Nigerian","10","5","1986","married","","","","angoaliyu76@yahoo.com","","","08155361842","","KOROKPAN ALONG DANU ROAD PAIKORO LOCAL GOVERRMENT MINNA NIGER STATE ","","","Normal","B+","None","","1","0","0","105.112.112.20","2020-01-28 15:49:06","2020-01-28 15:49:24","","","","1","0000-00-00 00:00:00","2019-06-19 13:24:31","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2019-12-12 11:32:18","0333","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("922","0","1","0","0","4","4","1","4","4","0922","0","0","27","554","","ABDULMAJID SHUAIBU","09066677123","","","","M","1","Nigerian","10","1","1996","single","","","","angoaliyu76@yahoo.com","","MASHEGU","09066677123","","LONDON STREET, BAJEGO MINNA NIGER STATE","","","Normal","A+","None","","1","0","0","105.112.115.177","2020-01-16 12:51:03","2020-01-16 12:51:11","","","","1","0000-00-00 00:00:00","2019-06-19 13:42:28","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0401","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("923","0","0","0","0","0","0","1","2","2","0923","0","0","27","544","","MUHAMMED MUHAMMED KABIR","08166900079","","","","M","1","Nigerian","5","6","1993","single","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08166900079","","FADIKPE MINNA NIGER STATE","","","Normal","O","None","","1","0","0","197.210.226.240","2019-07-20 12:01:28","2019-07-20 12:03:27","","","","1","0000-00-00 00:00:00","2019-06-19 13:59:28","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("924","0","1","0","0","9","6","1","9","18","0924","0","0","27","551","","DANJUMA ABDULLAHI","08169105375","","","","M","1","Nigerian","5","1","1992","married","","","","angoaliyu76@yahoo.com","","LAVUN","08169105375",""," BARINKIN-SALE MINNA NEAR PRIMARY SCHOOL / CLINIC","","","Normal","A+","None","","1","0","0","105.112.115.177","2020-01-16 14:52:06","2020-01-16 14:52:15","","","","1","0000-00-00 00:00:00","2019-06-19 14:08:53","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2019-12-12 11:47:30","0017","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("925","0","1","0","0","2","14","1","2","14","0925","0","0","27","560","","ALIYU KANJIWA","07081869450","","","","M","1","Nigerian","6","8","1997","single","","","","angoaliyu76@yahoo.com","","SHIRORO","07081869450","","NEW MAITUNBI G.R.A MINNA NIGER STATE","","","Normal","O","None","","1","0","0","197.210.84.221","2019-11-13 10:12:49","2019-11-13 10:16:22","","","","1","0000-00-00 00:00:00","2019-06-19 14:23:07","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-03 09:07:35","0486","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("926","0","0","0","0","0","0","1","2","14","0926","0","0","27","541","","MUHAMMED INMA SAN","07036085616","","","","M","1","Nigerian","4","10","1973","married","","","","mnmasani@gmail.com","","BIDA","07036085616","","ANGUNWA LIMAN SOJE A\' KPAKUNGU MINNA NIGER STATE.","","","Normal","A+","None","","1","0","0","197.210.227.151","2019-07-20 12:06:46","2019-07-20 12:07:51","","","","1","0000-00-00 00:00:00","2019-06-19 14:36:09","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("927","0","0","0","0","0","0","1","2","2","0927","0","0","27","550","","ATTAHIRU AHMED GULU","08038822499","","","","M","1","Nigerian","17","10","1975","married","","","","angoaliyu76@yahoo.com","","LAPAI","08038822499","","HAMADU HARUNA KPOTUN OF GULU","","","Normal","A+","None","","1","0","0","197.210.227.151","2019-07-20 12:07:57","2019-07-20 12:08:39","","","","1","0000-00-00 00:00:00","2019-06-19 14:49:22","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("928","0","0","0","0","0","0","1","2","14","0928","0","0","27","552","","ABDULLAI USMAN SALKA","08094474381","","","","M","1","Nigerian","11","5","1978","married","","","","angoaliyu76@yahoo.com","","MAGAMA","08094474381","","BARIKIN SALE MINA NIGER STATE","","","Normal","O","None","","1","0","0","197.210.226.240","2019-07-20 12:08:50","2019-07-20 12:09:45","","","","1","0000-00-00 00:00:00","2019-06-19 15:05:16","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("929","0","1","0","0","2","14","1","2","14","0929","0","0","27","544","","AHMED GAMBO YUSUF MAIBASIRA","07063080522","","","","M","1","Nigerian","12","2","1980","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","07063080522","","N.W 25 LIMAWA ROAD MINNA NIGER STATE","","","Normal","O","None","","1","0","0","105.112.121.124","2020-02-17 17:24:02","2020-02-17 17:25:20","","","","1","0000-00-00 00:00:00","2019-06-19 15:13:33","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0020","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("930","0","1","0","0","4","13","1","4","13","0930","0","0","27","544","","SABO NASIRU","09014930572","","","","M","1","Nigerian","5","2","1975","married","","","","angoaliyu76@yahoo.com","","SHIRORO","09014930572","","UNGUNWA SARKIN MINNA KUTA SHIROROBLOCAL GOVERNMENT.","","","Normal","B+","None","","1","0","0","105.112.112.20","2020-01-28 16:01:10","2020-01-28 16:01:29","","","","1","0000-00-00 00:00:00","2019-06-20 10:30:27","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-15 08:59:44","0531","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("931","0","0","0","0","0","0","1","4","4","0931","0","0","27","557","","USMAN SAIDU","08037146533","","","","M","1","Nigerian","25","10","1963","married","","","","angoaliyu76@yahoo.com","","PAIKORO","08037146533","","PAIKO TOWN PAIKORO LOCAL GOVERNMENT MINNA NIGER STATE","","","Normal","O","None","","1","0","0","197.210.227.151","2019-07-20 12:12:09","2019-07-20 12:13:09","","","","1","0000-00-00 00:00:00","2019-06-20 10:42:38","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("932","0","1","0","0","2","15","1","2","15","0932","0","0","19","356","","BASAHUWA ALHERI","08036052095","","","","F","2","Nigerian","25","11","1970","married","","","","angoaliyu76@yahoo.com","","KADUNA SOUTH","08036052095","","29 LAMSON STREET ULPAMA SABON - TASHA KADUNA STATE.","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 13:01:20","2020-01-16 13:01:30","","","","1","0000-00-00 00:00:00","2019-06-20 10:51:13","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0364","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("933","0","1","0","0","4","13","1","4","13","0933","0","0","27","540","","PETER ILIYA","08059417438","","","","M","2","Nigerian","4","5","1983","married","","","","angoaliyu76@yahoo.com","","AGWARA","08059417438","","UMCA CHURCH GALLAH, UNGUWAN SARKIN","","","Normal","B+","None","","1","0","0","105.112.115.177","2020-01-16 11:48:32","2020-01-16 11:48:41","","","","1","0000-00-00 00:00:00","2019-06-20 11:08:35","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-03 08:27:59","0464","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("934","0","1","0","0","2","14","1","2","14","0934","0","0","27","544","","DANSABO IBRAHIM ABUBAKAR","08135486004","","","","M","1","Nigerian","17","9","1992","single","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08135486004","","DUTSEN KURA HAUSA, OFF OKADA ROAD MINNA NIGER STATE.","","","Normal","B+","None","","1","0","0","197.210.70.15","2020-02-04 17:24:48","2020-02-04 17:26:16","","","","1","0000-00-00 00:00:00","2019-06-20 11:23:13","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                                                 
\n                                ","3","2020-02-12 16:38:53","0392","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("935","0","1","0","0","2","14","1","2","14","0935","0","0","27","551","","YUSUF HAUWA","08039359550","","","","F","1","Nigerian","6","3","1980","married","","","","angoaliyu76@yahoo.com","","LAVUN","08039359550","","KONUFU COMPOUND OPP. CENTRAL MOSQUE DOKO NIGER STATE.","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 13:07:34","2020-01-16 13:07:44","","","","1","0000-00-00 00:00:00","2019-06-20 11:39:37","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0446","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("936","0","1","0","0","2","15","1","2","15","0936","0","0","27","541","","SHAFII AMINA ALHAJI","08165823302","","","","F","1","Nigerian","28","5","1972","married","","","","angoaliyu76@yahoo.com","","BIDA","08165823302","","NO 15. 123 QUATRERS MINNA NIGER STATE ","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 13:11:29","2020-01-16 13:11:39","","","","1","0000-00-00 00:00:00","2019-06-20 11:54:43","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-12-02 11:58:48","0650","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("937","0","0","0","0","0","0","1","2","2","0937","0","0","27","551","","MUHAMMED ADAMU A.","08187833690","","","","M","1","Nigerian","27","11","1997","single","","","","angoaliyu76@yahoo.com","","LAVUN","08187833690","","BARKINSALE OPPOSITE MAI ANGUWA HOUSE MINNA NIGER STATE.","","","Normal","A+","None","","1","0","0","197.210.226.122","2019-07-20 12:21:05","2019-07-20 12:22:54","","","","1","0000-00-00 00:00:00","2019-06-20 12:29:09","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("938","0","0","0","0","0","0","1","4","4","0938","0","0","14","269","","ANIEZE NICHOLAS FRIDAY","08065360226","","","","M","2","Nigerian","30","11","1996","married","","","","angoaliyu76@yahoo.com","","NKANU EAST","08065360226","","BEHIND PDP SECRETARIAT  MAITUNBI BYPASS MINNA.","","","Normal","O","None","","1","0","0","197.210.226.77","2019-07-20 12:23:09","2019-07-20 12:24:11","","","","1","0000-00-00 00:00:00","2019-06-20 12:39:48","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("939","0","0","0","0","0","0","1","2","14","0939","0","0","27","544","","SULEIMAN BILQIS","08075757298","","","","F","1","Nigerian","19","8","1989","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08075757298","","124 WUSHISHI ROAD OFF GWARI ROAD STADIUM ROAD MINNA","","","Normal","O","None","","1","0","0","197.210.226.195","2019-07-20 12:24:28","2019-07-20 12:25:43","","","","1","0000-00-00 00:00:00","2019-06-20 12:41:03","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("940","0","1","0","0","10","21","1","10","21","0940","0","0","27","558","","ISA KAGARA HAFIZA","07061806272","","","","F","1","Nigerian","9","5","1993","single","","","","angoaliyu76@yahoo.com","","RAFI","07061806272","","SHANGO BEHIND IBRAHIM BADAMASI GUEST INN MINNA.","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 14:20:48","2020-01-16 14:20:57","","","","1","0000-00-00 00:00:00","2019-06-20 12:43:01","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0132","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("941","0","1","0","0","1","11","1","1","11","0941","0","0","31","640","","ADEGOKE LAMIDI ABDULHAMID","08036092981","","","","M","1","Nigerian","23","5","1976","married","","","","angoaliyu76@yahoo.com","","IBADAN SOUTH - EAST","08036092981","","NI 10 ALH, JIMOH JAMIU STREET ALUTA AJUWO OGUN STATE","","","Normal","A+","None","","1","0","0","105.112.113.95","2020-01-15 10:48:01","2020-01-15 10:48:36","","","","1","0000-00-00 00:00:00","2019-06-20 12:44:34","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-12-05 12:20:20","0663","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("942","0","1","0","0","2","15","1","2","15","0942","0","0","27","548","","ABDULLAHI ZAINAB","08034769920","","","","F","1","Nigerian","5","1","1969","married","","","","angoaliyu76@yahoo.com","","KATCHA","08034769920","","ANGUWA HAUSAWA EMI LATE NYAGA KATCHA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 13:20:49","2020-01-16 13:21:19","","","","1","0000-00-00 00:00:00","2019-06-20 12:45:54","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0129","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("943","0","0","0","0","0","0","1","4","13","0943","0","0","27","551","","MUSTAPHA ISAH","08056666343","","","","M","1","Nigerian","22","10","1984","married","","","","angoaliyu76@yahoo.com","","LAVUN","08056666343","","AY PRESIDENT , GURARA AREA MINNA NIGER STATE","","","Normal","O","None","","1","0","0","197.210.227.59","2019-07-20 12:30:45","2019-07-20 12:31:48","","","","1","0000-00-00 00:00:00","2019-06-20 12:47:36","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("944","0","0","0","0","0","0","1","10","21","0944","0","0","27","555","","KETURAH NNAIYE LANDU","07033414516","","","","F","2","Nigerian","6","9","1991","single","","","","angoaliyu76@yahoo.com","","MOKWA","07033414516","","BEHIND TRADE FAIR COMPLEX MINNA SHANGO","","","Normal","O","None","","1","0","0","197.210.226.122","2019-07-20 12:31:57","2019-07-20 12:33:05","","","","1","0000-00-00 00:00:00","2019-06-20 12:50:00","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("945","0","0","0","0","0","0","1","4","13","0945","0","0","27","543","","SABO USMAN PYATA","08036060891","","","","M","2","Nigerian","16","3","1972","married","","","","angoaliyu76@yahoo.com","","BOSSO","08036060891","","MALL USMAN BATIST CHURCH BOX 2335 MINNA.","","","Normal","AB","None","","1","0","0","141.0.13.140","2019-10-16 21:46:11","2019-10-16 21:48:24","","","","1","0000-00-00 00:00:00","2019-06-20 12:52:14","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("946","0","1","0","0","9","18","1","10","20","0946","0","0","27","555","","ZAINAB ABUBAKAR","08050332789","","","","F","1","Nigerian","11","2","1988","married","","","","angoaliyu76@yahoo.com","","MOKWA","08050332789","","OPPOSITE HOUSE OF ASSEMBLY QUARTERS MINNA.","","","Normal","O","None","","1","0","0","197.210.85.194","2020-02-11 18:22:36","2020-02-11 18:30:50","","","","1","0000-00-00 00:00:00","2019-06-20 12:53:45","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2020-02-11 18:27:42","0318","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("947","0","0","0","0","0","0","1","2","15","0947","0","0","27","544","","MURTALA IBRAHIM","08035176963","","","","M","1","Nigerian","2","2","1991","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08035176963","","CENTRAL MOSEQ MINNA NIGER STATE","","","Normal","A+","None","","1","0","0","197.210.227.151","2019-07-20 12:52:07","2019-07-20 12:53:12","","","","1","0000-00-00 00:00:00","2019-06-20 12:55:03","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("948","0","1","0","0","2","2","1","2","14","0948","0","0","27","539","","YUSUF ABUBAKAR","08036467543","","","","M","1","Nigerian","10","4","1985","married","","","","angoaliyu76@yahoo.com","","AGAIE","08036467543","","HOUSE NO 15 BOSSO LOW - COST OFF OKADA ROAD MINNA","","","Normal","B+","None","","1","0","0","197.210.227.151","2019-07-20 12:53:43","2019-07-20 12:54:56","","","","1","0000-00-00 00:00:00","2019-06-20 12:56:35","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-03 09:06:35","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("949","0","1","0","0","4","12","1","4","12","0949","0","0","27","544","","MANI BALA","08032919991","","","","M","1","Nigerian","12","6","1976","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08032919991","","NIE. 77 NASSARAWA A. WARD MINNA NIGER STATE","","","Normal","O","None","","1","0","0","105.112.112.20","2020-01-28 16:17:10","2020-01-28 16:17:18","","","","1","0000-00-00 00:00:00","2019-06-20 13:05:41","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-13 13:31:25","0540","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("950","0","0","0","0","0","0","1","4","4","0950","0","0","27","543","","GARBA HARUNA","07063641608","","","","M","1","Nigerian","6","6","1984","married","","","","angoaliyu76@yahoo.com","","BOSSO","07063641608","","HOUSE NO 1 ADJECENT F.M ROAD STATION MAITUNBI MINNA NIGER STATE","","","Normal","O","None","","1","0","0","197.210.227.151","2019-07-20 12:56:45","2019-07-20 12:57:34","","","","1","0000-00-00 00:00:00","2019-06-20 13:07:18","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("951","0","1","0","0","4","13","1","1","11","0951","0","0","27","544","","OMONIYI KEMI FUNMILAYO","07068877815","","","","F","2","Nigerian","27","6","1984","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","07068877815","","S.E 162 SABO GERI MINNA NIGER STATE","","","Normal","A+","None","","1","0","0","105.112.112.20","2020-01-28 16:06:47","2020-01-28 16:06:57","","","","1","0000-00-00 00:00:00","2019-06-20 13:08:43","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2019-12-12 11:35:43","0152","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("952","0","1","0","0","10","20","1","10","20","0952","0","0","27","541","","BELLO MUHAMMED SABA ","07069002540","","","","M","1","Nigerian","1","10","1997","single","","","","angoaliyu76@yahoo.com","","BIDA","07069002540","","KAPKUNGU SOJE \'A\' MINNA","","","Normal","O","None","","1","0","0","105.112.122.219","2019-09-18 09:11:12","2019-09-18 09:11:38","","","","1","0000-00-00 00:00:00","2019-06-21 10:35:11","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-08 10:15:26","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("953","0","1","0","0","10","20","1","10","20","0953","0","0","27","549","","MUAZU UMAR","08065959116","","","","M","1","Nigerian","7","6","1996","single","","","","angoaliyu76@yahoo.com","","KONTAGORA","08065959116","","UNGUWAN KANWURI KONTAGORA NIGER STATE","","","Normal","O","None","","1","0","0","105.112.120.10","2019-10-30 08:48:40","2019-10-30 08:50:14","","","","1","0000-00-00 00:00:00","2019-06-21 10:45:49","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0054","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("954","0","1","0","0","4","4","1","4","4","0954","0","0","27","555","","SULEIMAN ISMAIL","08065819431","","","","M","1","Nigerian","9","4","2000","single","","","","angoaliyu76@yahoo.com","","MOKWA","08065819431","","BRIGHTER ROAD BEHIND DONMAC CHURCH MINNA.","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 11:49:15","2020-01-16 11:49:24","","","","1","0000-00-00 00:00:00","2019-06-21 10:54:59","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0263","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("955","0","1","0","0","2","2","1","2","2","0955","0","0","27","541","","UMAR IBRAHIM","08068895256","","","","M","1","Nigerian","22","2","1987","single","","","","angoaliyu76@yahoo.com","","BIDA","08068895256","","EMI AYAKI ANNI BANWUYA BIDA NIGER STATE","","","Normal","AB","None","","1","1","0","197.210.227.98","2020-02-07 17:29:47","2019-10-09 13:50:33","","","","1","0000-00-00 00:00:00","2019-06-21 11:03:46","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0274","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("956","0","0","0","0","0","0","1","7","5","0956","0","0","27","555","","MUHAMMED USMAN YAHAYA","07061513964","","","","M","1","Nigerian","7","7","1997","single","","","","angoaliyu76@yahoo.com","","MOKWA","07061513964","","EMI TSADO KAFINTA KPEGE MOKWA NIGER STATE","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 13:01:39","2020-01-16 13:01:56","","","","1","0000-00-00 00:00:00","2019-06-21 11:15:01","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("957","0","1","0","0","4","4","1","4","4","0957","0","0","30","607","","SAMUEL VICTORIA","09052622552","","","2019-09-27-101512VICTORIC DOC.pdf.pdf","F","2","Nigerian","20","9","1995","single","","","","angoaliyu76@yahoo.com","","BORIPE","09052622552","","BGEGANU MINNA NIGER STATE","","2019-09-27-095954.jpg","Normal","O","None","","1","0","0","197.210.45.38","2020-01-03 14:25:01","2020-01-03 14:25:28","","","","1","0000-00-00 00:00:00","2019-06-21 11:23:28","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0176","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("958","0","1","0","0","7","5","1","7","5","0958","0","0","27","557","","IDRIS SADIYA","09035515530","","","","F","1","Nigerian","10","8","1998","married","","","","angoaliyu76@yahoo.com","","PAIKORO","09035515530","","BLK/G260 TUNGA LOWCOST MINNA","","","Normal","O","None","","1","0","0","197.210.65.112","2020-01-02 22:27:52","2020-01-02 22:28:58","","","","1","0000-00-00 00:00:00","2019-06-21 11:39:07","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0125","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("959","0","1","0","0","1","1","1","1","1","0959","0","0","27","555","","MUHAMMED UMAR","08168186912","","","","M","1","Nigerian","6","2","1998","single","","","","angoaliyu76@yahoo.com","","MOKWA","08168186912","","122 BEHIND BRIGHTER SCHOOL AREA MINNA.","","","Normal","B+","None","","1","0","0","105.112.113.95","2020-01-15 10:53:02","2020-01-15 10:53:22","","","","1","0000-00-00 00:00:00","2019-06-21 11:48:02","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0264","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("960","0","1","0","0","2","14","1","2","14","0960","0","0","27","548","","MAHMUDU ALIYU","07036669769","","","","M","1","Nigerian","6","3","1994","married","","","","angoaliyu76@yahoo.com","","KATCHA","07036669769","","BARKI SALE AFTER POLICE STATION MINNA NIGER STATE.","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 13:19:59","2020-01-16 13:20:40","","","","1","0000-00-00 00:00:00","2019-06-21 11:57:40","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-12-09 16:11:17","0672","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("961","0","1","0","0","2","14","1","2","14","0961","0","0","27","128","","IORAKPERA GODWIN AONDOHEMBA","07036058753","","","","M","1","Nigerian","1","1","1976","married","","","","angoaliyu76@yahoo.com","","KONSHISHA","07036058753","","CHAIR MAIGUMERI BARRACKS LOKOJA KOGI STATE.","","","Normal","A+","None","","1","0","0","105.112.116.72","2020-01-24 12:41:27","2020-01-24 12:42:22","","","","1","0000-00-00 00:00:00","2019-06-21 12:18:44","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0051","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("962","0","0","0","0","0","0","1","4","12","0962","0","0","27","551","","ALIYU USMAN KOTSU","08161213171","","","","M","1","Nigerian","30","11","1991","single","","","","angoaliyu76@yahoo.com","","LAVUN","08161213171","","BARKIN SALE UPPER BASE OPPOSITE UTURN SUPPER MARKET JUNCTION MINNA.","","","Normal","O","None","","1","0","0","197.210.227.193","2019-07-20 13:16:50","2019-07-20 13:17:40","","","","1","0000-00-00 00:00:00","2019-06-21 12:20:55","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("963","0","0","0","0","0","0","1","2","14","0963","0","0","27","544","","YUSUF HAUWA","08142448123","","","","F","1","Nigerian","8","10","1997","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08142448123","","S.W 1 OLD AIRPORT ROAD LIMAWA A\' WARD MINNA NIIGER STATE.","","","Normal","B+","None","","1","0","0","105.112.115.177","2020-01-16 13:11:01","2020-01-16 13:11:22","","","","1","0000-00-00 00:00:00","2019-06-21 12:35:04","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("964","0","1","0","0","4","12","1","4","12","0964","0","0","27","560","","YUSUF KABULU MUSA","08039455368","","","","M","1","Nigerian","25","5","1993","single","","","","angoaliyu76@yahoo.com","","SHIRORO","08039455368","","SABON GARI ROAD IDDAH KUTA","","","Normal","B+","None","","1","0","0","105.112.112.20","2020-01-28 16:10:57","2020-01-28 16:11:20","","","","1","0000-00-00 00:00:00","2019-06-21 12:46:42","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-22 12:01:46","0602","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("965","0","1","0","0","1","11","1","1","11","0965","0","0","27","131","","DAKU GABRIEL","07062207064","","","","M","2","Nigerian","10","8","1984","married","","","","angoaliyu76@yahoo.com","","MAKURDI","07062207064","","PLOT 175, EMMANUEL AGIDI STREET MAKURDI","","","Normal","O","None","","1","1","0","105.112.121.20","2019-11-07 16:10:39","2019-07-20 13:26:28","","","","1","0000-00-00 00:00:00","2019-06-21 13:22:47","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0450","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("966","0","1","0","0","10","21","1","10","21","0966","0","0","31","634","","MARY JEWOOLA","08064691891","","","","F","2","Nigerian","30","1","1990","single","","","","angoaliyu76@yahoo.com","","ATIBA","08064691891","","BAYCLINIC ROAD TUNGA MINNA NIGER STATE.","","","Normal","O","None","","1","0","0","197.210.227.151","2019-07-20 13:27:47","2019-07-20 13:28:22","","","","1","0000-00-00 00:00:00","2019-06-21 13:40:19","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("967","0","1","0","0","10","22","1","10","22","0967","0","0","27","557","","HASSAN MARYAM ABUBAKAR","08034513067","","","","F","1","Nigerian","22","11","1956","married","","","","angoaliyu76@yahoo.com","","PAIKORO","08034513067","","NO.25 UNGUWAN GWARI BY ALLADEH JUCTION CHANCHAGA MINNA,","","","Normal","B+","None","","1","0","0","105.112.115.177","2020-01-16 14:04:45","2020-01-16 14:04:55","","","","1","0000-00-00 00:00:00","2019-06-21 14:04:13","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0043","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("968","0","0","0","0","0","0","1","2","15","0968","0","0","23","483","","ADEPOJU  DAVID AFFA","08036352165","","","","M","2","Nigerian","24","1","1985","single","","","","angoaliyu76@yahoo.com","","OGORI-MAGONGO","08036352165","","E.W 59 LAGOS STREET MINNA NIGER STATE","","","Normal","A+","None","","1","0","0","197.210.227.151","2019-07-20 13:22:38","2019-07-20 13:24:10","","","","1","0000-00-00 00:00:00","2019-06-21 14:22:48","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("969","0","0","0","0","0","0","1","1","11","0969","0","0","27","541","","SULEIMAN MOHAMMED","08063327861","","","","M","1","Nigerian","2","2","1976","married","","","","angoaliyu76@yahoo.com","","BIDA","08063327861","","ALBISHIRI AREA ONE","","","Normal","O","None","","1","0","0","197.210.227.151","2019-07-20 13:26:41","2019-07-20 13:27:37","","","","1","0000-00-00 00:00:00","2019-06-21 14:38:19","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("970","0","0","0","0","0","0","1","1","1","0970","0","0","27","549","","ALIYU FARIDA","08136262835","","","","F","1","Nigerian","1","7","1995","married","","","","angoaliyu76@yahoo.com","","KONTAGORA","08136262835","","NO 13 SENIOR QUARTERS BOSSO LOWCOST MINNA.","","","Normal","O","None","","1","0","0","197.210.227.151","2019-07-20 13:28:30","2019-07-20 13:29:08","","","","1","0000-00-00 00:00:00","2019-06-21 15:00:32","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("971","0","0","0","0","0","0","1","2","2","0971","0","0","35","734","","ABDULLAHI IBRAHIM JALINGO","07064510355","","","","M","1","Nigerian","9","1","1992","single","","","","angoaliyu76@yahoo.com","","JALINGO","07064510355","","NO 36 SHANGO KIRE STREET","","","Normal","O","None","","1","0","0","197.210.227.151","2019-07-20 13:29:20","2019-07-20 13:30:25","","","","1","0000-00-00 00:00:00","2019-06-21 15:11:39","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("972","0","1","0","0","9","6","1","2","2","0972","0","0","27","543","","ABUBAKAR MUHAMMED AHMAD","08036725168","","","","M","1","Nigerian","18","8","1999","single","","","","angoaliyu76@yahoo.com","","BOSSO","08036725168","","BOSSO ESTATE BEHIN ABDULSALAM QUARTERS FLAT A8.","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 14:40:32","2020-01-16 14:40:43","","","","1","0000-00-00 00:00:00","2019-06-21 15:22:34","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-08 10:17:00","0466","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("973","0","1","0","0","10","22","1","10","22","0973","0","0","27","557","","ADAMU SHUAIBU PAIKO","08055516662","","","","M","1","Nigerian","7","7","1970","married","","","","angoaliyu76@yahoo.com","","pai","08055516662","","OPP. PAIKO TWON HALL OLD SULEJA ROAD PAIKO NIGER STATE.","","","Normal","O","None","","1","0","0","105.112.112.20","2020-01-28 16:32:49","2020-01-28 16:32:59","","","","1","0000-00-00 00:00:00","2019-06-21 16:16:02","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-03 09:02:52","0503","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("974","0","0","0","0","0","0","1","10","21","0974","0","0","27","543","","ABDULRAHMAN HALIMA","08064175321","","","","F","1","Nigerian","18","8","1971","married","","","","angoaliyu76@yahoo.com","","BOSSO","08064175321","","GIDAN NA\'IBI MAITUNBI TOWN MINNA NIGER STATE.","","","Normal","O","None","","1","0","0","197.210.227.151","2019-07-20 13:34:07","2019-07-20 13:34:59","","","","1","0000-00-00 00:00:00","2019-06-21 16:30:18","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("975","0","1","0","0","10","21","1","10","21","0975","0","0","27","539","","MOHAMMED MAHMUD","07039242901","","","","M","1","Nigerian","22","5","1995","married","","","","angoaliyu76@yahoo.com","","AGAIE","07039242901","","S.W 491 KETEREN GWARI","","","Normal","B+","None","","1","0","0","105.112.115.177","2020-01-16 14:21:06","2020-01-16 14:21:15","","","","1","0000-00-00 00:00:00","2019-06-21 16:44:08","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-29 14:22:28","0639","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("976","0","1","0","0","4","13","1","4","12","0976","0","0","19","354","","MAIROGO EMMANUEL","08037948294","","","","M","1","Nigerian","27","9","1970","married","","","","angoaliyu76@yahoo.com","","KACHIA","08037948294","","ECWAC CHURCH SAUCAKAWUTA MINNA.","","","Normal","O","None","","1","0","0","197.210.227.151","2019-07-20 13:35:10","2019-07-20 13:37:02","","","","1","0000-00-00 00:00:00","2019-06-21 17:25:38","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("977","0","0","0","0","0","0","1","10","21","0977","0","0","23","478","","Samuel Adekanye","08032170095","","","","M","2","Nigerian","7","7","1981","single","","","","adesam0707@gmail.com","","Keats State","08032170095","","Ibrahim Badamasi Babangida University, Abubakar Gimba Library, Lapai, Niger State. ","Local Government Quater, Paiko,  Minna Road, Niger State. ","","Normal","A+","None","","1","1","0","197.210.54.249","2019-06-24 11:41:24","2019-06-23 18:30:41","","","","0","0000-00-00 00:00:00","2019-06-23 10:44:26","0000-00-00 00:00:00","","","Ezekiel Adekamye","08032170095","Offa Garage Ilorin, Kwara State.","Parents ","1","Self ","Self","0","","0","0000-00-00 00:00:00","","15","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("978","0","0","0","0","0","0","1","10","21","0978","0","0","0","0","","RAMATU HAMZAT ","","","","","","0","","","","","","","","","ramatuhamzat23@gmail.com","","","08109191523","","","","","","","","","1","1","0","197.210.227.229","2019-06-24 13:58:10","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-06-24 13:57:36","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("979","0","0","0","0","0","0","1","4","4","0979","0","0","27","541","","AHMAD IBRAHIM","07061198759","","","","M","1","Nigerian","13","3","1992","single","","","","angoaliyu76@yahoo.com","","BIDA","07061198759","","OPPOSITE MAI-NASSARA CLINIC SOJE  \"B\" PKAKUNGU MINNA.","","","Normal","O","None","","1","0","0","197.210.226.77","2019-07-20 13:37:54","2019-07-20 13:38:44","","","","1","0000-00-00 00:00:00","2019-06-25 14:13:28","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("980","0","0","0","0","0","0","1","2","2","0980","0","0","0","0","","SABO MARYAM","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07038082245","","","","","","","","","1","0","0","197.210.57.66","2019-06-25 14:45:58","2019-06-25 14:46:17","","","","0","0000-00-00 00:00:00","2019-06-25 14:40:12","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("981","0","0","0","0","0","0","1","4","12","0981","0","0","27","548","","ASMAU MAHMUD","08131801096","","","","F","1","Nigerian","12","8","1994","single","","","","angoaliyu76@yahoo.com","","KATCHA","08131801096","","TUNGA FARM CENTER","","","Normal","A+","None","","1","0","0","197.210.226.122","2019-07-20 13:38:53","2019-07-20 13:39:35","","","","1","0000-00-00 00:00:00","2019-06-25 14:48:45","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("982","0","0","0","0","0","0","1","4","13","0982","0","0","27","549","","ABDULLAHI JIBRIL","08036974513","","","","M","1","Nigerian","1","3","1976","married","","","","angoaliyu76@yahoo.com","","KONTAGORA","08036974513","","AB 52 OLD MARKET ROAD SABON GARI, KONTAGORA NIGER STATE","","","Normal","O","None","","1","0","0","197.210.227.151","2019-07-20 13:39:55","2019-07-20 13:40:43","","","","1","0000-00-00 00:00:00","2019-06-25 15:11:03","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("983","0","1","0","0","4","12","1","4","12","0983","0","0","8","146","","SULEIMAN DIKKO SAFINA","08034152502","","","","F","1","Nigerian","12","7","1995","single","","","","angoaliyu76@yahoo.com","","BIU","08034152502","","AREA 2 LONDON STREET CLOSE TO NASFAH ACADEMY BOSSO MINNA ","","","Normal","O","None","","1","0","0","197.210.64.151","2020-01-02 20:34:14","2020-01-02 20:35:19","","","","1","0000-00-00 00:00:00","2019-06-25 15:27:00","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","0000-00-00 00:00:00","0349","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("984","0","1","0","0","10","20","1","10","20","0984","0","0","27","555","","USMAN UMAR KITAR","08036092392","","","","M","1","Nigerian","10","6","1995","married","","","","angoaliyu76@yahoo.com","","MOKWA","08036092392","","TIF MADZA MOKWA ","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 14:23:13","2020-01-16 14:23:25","","","","1","0000-00-00 00:00:00","2019-06-25 15:42:10","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0307","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("985","0","1","0","0","9","18","1","4","12","0985","0","0","27","544","","JOSEPH SILVANUS","08122444224","","","","M","2","Nigerian","1","10","1987","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08122444224","","NO 4, GREEN ESTATE BESIDE MTN MASS BEHIND NURSES HOUSE CHANCHAGE  MINNA NIGER STATE,","","","Normal","A+","None","","1","0","0","197.210.84.122","2020-01-28 16:41:50","2020-01-28 16:42:01","","","","1","0000-00-00 00:00:00","2019-06-25 15:50:51","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2019-12-12 11:59:39","0500","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("986","0","0","0","0","0","0","1","4","12","0986","0","0","27","544","","IBRAHIM NAFISAT","07063622586","","","","F","1","Nigerian","22","6","1985","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","07063622586","","B 69 M.I WUSHISHI ESTATE   ","","","Normal","O","None","","1","0","0","197.210.226.122","2019-07-20 13:43:32","2019-07-20 13:46:11","","","","1","0000-00-00 00:00:00","2019-06-25 16:11:48","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("987","0","0","0","0","0","0","1","7","16","0987","0","0","27","539","","AISHA SAYED YUNUSA","08034024213","","","","F","1","Nigerian","31","1","1981","married","","","","angoaliyu76@yahoo.com","","AGAIE","08034024213","","075 OLD ATC BOSSO","","","Normal","A+","None","","1","0","0","105.112.123.52","2019-11-08 11:38:37","2019-11-08 11:42:03","","","","1","0000-00-00 00:00:00","2019-06-25 16:28:28","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("988","0","0","0","0","0","0","1","1","11","0988","0","0","0","0","","MOHAMMED TANIMU SONFADA","","","","","","0","","","","","","","","","mohammedtanimu112@gmail.com","","","08069760090","","","","","","","","","1","1","0","82.145.211.219","2019-06-26 10:00:20","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-06-26 09:57:11","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("989","0","1","0","0","7","16","1","7","16","0989","0","0","27","542","","OLADEJI GANIYAT TOYIN","08100170876","","","","F","2","Nigerian","7","7","1984","married","","","","angoaliyu76@yahoo.com","","BORGU","08100170876","","BEHIND NECO QUARTERS, BRIGHTER SCHOOL MINNA. ","","","Normal","O","None","","1","0","0","197.210.60.119","2020-01-03 11:35:52","2020-01-03 11:36:22","","","","1","0000-00-00 00:00:00","2019-06-26 12:55:33","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-01 10:38:54","0444","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("990","0","1","0","0","2","14","1","2","14","0990","0","0","2","99","","RUKAYAT ALIYU TAHIR","08169346378","","","","F","1","Nigerian","16","11","1989","married","","","","angoaliyu76@yahoo.com","","GIREI","08169346378","","NIGER STATE GOVERNMENT HOUSE  MINNA.","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 12:51:19","2020-01-16 12:51:29","","","","1","0000-00-00 00:00:00","2019-06-26 13:08:46","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0092","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("991","0","1","0","0","10","21","1","10","21","0991","0","0","27","560","","ABDULLAHI U. SALAMATU","08060197554","","","","F","1","Nigerian","1","1","1987","married","","","","angoaliyu76@yahoo.com","","SHIRORO","08060197554","","OKADA ROAD 0PP0SITE GIDAN MATASA MINNA.","","","Normal","A+","None","","1","0","0","197.210.227.93","2019-07-20 13:51:28","2019-07-20 13:52:34","","","","1","0000-00-00 00:00:00","2019-06-26 13:29:42","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("992","0","1","0","0","2","15","1","2","15","0992","0","0","2","37","","ISA MURTALA RAJ","08033577896","","","","M","1","Nigerian","1","1","1976","married","","","","angoaliyu76@yahoo.com","","YOLA","08033577896","","NIIGER STATE GOVERNMENT HOUSE MINNA.","","","Normal","O","None","","1","0","0","197.210.65.249","2020-01-02 20:58:55","2020-01-02 20:59:32","","","","1","0000-00-00 00:00:00","2019-06-26 16:42:27","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0091","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("993","0","0","0","0","0","0","1","4","13","0993","0","0","27","563","","BARAU SANUSI","08168124124","","","","M","1","Nigerian","12","6","1982","married","","","","angoaliyu76@yahoo.com","","WUSHISHI","08168124124","","ALHAJI YUSUF BARAU CIKI RECIDENCE , LIMAWA WUSHISHI ","","","Normal","O","None","","1","0","0","197.210.226.126","2019-07-20 13:53:55","2019-07-20 13:54:34","","","","1","0000-00-00 00:00:00","2019-06-26 16:51:48","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("994","0","1","0","0","4","13","1","4","13","0994","0","0","27","549","","ABDULLAHI IBRAHIM","08065315546","","","","M","1","Nigerian","24","4","1974","married","","","","angoaliyu76@yahoo.com","","KONTAGORA","08065315546","","OPP. POLICE SECONDARY SCHOOL MINNA DUTSEN KURA GWARI","","","Normal","O","None","","1","0","0","105.112.112.20","2020-01-28 16:00:23","2020-01-28 16:00:59","","","","1","0000-00-00 00:00:00","2019-06-26 17:05:51","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-15 09:16:42","0546","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("995","0","1","0","0","1","1","1","1","1","0995","0","0","27","539","","ETSU ABDULLAHI","08037374880","","","","M","1","Nigerian","16","1","1997","single","","","","angoaliyu76@yahoo.com","","AGAIE","08037374880","","EMIR PALACE AGAIE","","","Normal","A+","None","","1","0","0","105.112.115.177","2020-01-16 13:08:12","2020-01-16 13:08:53","","","","1","0000-00-00 00:00:00","2019-06-26 17:20:29","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("996","0","0","0","0","0","0","1","1","11","0996","0","0","27","541","","NDAYAKO HANIFAT AYOKA","08025014908","","","","F","1","Nigerian","11","2","1970","married","","","","nadayakohanifat@gmail.con","","BIDA","08025014908","","HOUSE C4 ROAD C NASSARAWA COMM. BOSSO ESTATE MINNA NIGER STATE.","","","Normal","A+","None","","1","0","0","197.210.226.74","2019-07-20 13:57:06","2019-07-20 13:57:51","","","","1","0000-00-00 00:00:00","2019-06-26 17:32:31","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("997","0","0","0","0","0","0","1","1","11","0997","0","0","0","0","","MOHAMMED TANIMU SONFADA ","","","","","","0","","","","","","","","","mohammedtanimu112@gmail.com","","","08069760090","","","","","","","","","1","1","0","82.145.211.161","2019-06-26 22:08:04","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-06-26 22:02:37","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("998","0","0","0","0","0","0","1","1","11","0998","0","0","27","541","","MOHAMMED TANIMU SONFADA ","08069760090","","","2019-06-27-163436Doc7_compressed (1).pdf.pdf","M","1","Nigerian","15","2","1981","married","","","","mohammedtanimu112@gmail.com","","Abdul Garba","08069760090","","Alhaji Haliru Sonfada House via Madami Area","","2019-06-27-161132.jpg","Normal","O","None","","1","1","0","82.145.223.27","2019-11-24 14:43:59","2019-11-17 14:29:09","","","","1","0000-00-00 00:00:00","2019-06-26 22:10:05","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("999","0","1","0","0","10","22","1","7","17","0999","0","0","27","550","","Habibu Idrisu","08060838918","","","2019-06-27-095535Idrisu Habibu.pdf.pdf","M","1","Nigerian","23","4","1976","married","","","","habibuidris12121@gmail.com","","Lapai Niger State","08060838918","","Niger State College of Agriculture Mokwa","Niger State College of Agriculture Mokwa","2019-06-27-094548.jpg","Normal","O","None","Nil","1","1","0","105.112.112.129","2019-10-28 09:50:28","2019-06-27 10:28:56","","","","1","0000-00-00 00:00:00","2019-06-27 09:33:19","0000-00-00 00:00:00","","","Adamu Mayaki","07036096229","Nigerian Immigration Service, Minna Command","Brother","1","Idrisu Habibu","Niger State College of Agriculture Mokwa","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0337","13","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1000","0","0","0","0","0","0","1","2","14","1000","0","0","0","0","","HUSSAINI IBRAHIM","","","","2019-06-27-161948HUSSAINI IBRAHIM.pdf.pdf","","0","","","","","","","","","hussainiibrahim43@gmail.com","","","07066126454","","","","2019-06-27-161331.jpg","","","","","1","1","0","8.37.233.214","2019-11-13 16:18:48","2019-07-22 14:36:21","","","","1","0000-00-00 00:00:00","2019-06-27 13:11:10","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1001","0","1","0","0","10","22","1","7","17","1001","0","0","1","4","","Joel Eucharia Egbichi","08063498270","","","2019-06-27-160924Joel Eucharia Egbichi.pdf.pdf","F","2","Nigerian","6","10","1988","married","","","","kenshawnjkj@gmail.com","","Abia","08063498270","","Old Custom Office Opposite FUT Minna Bosso Niger State","Old Custom Office Opposite FUT Minna Bosso Niger State","2019-06-27-155424.jpg","Normal","O","None","Nil","1","0","0","105.112.115.177","2020-01-16 14:12:36","2020-01-16 14:12:53","","","","1","0000-00-00 00:00:00","2019-06-27 15:52:56","0000-00-00 00:00:00","","","Joel Kehinde","08032496664","Old Custom Office Opposite FUT Minna Bosso Niger State","Husband","1","Joel Kehinde","Old Custom Office Opposite FUT Minna Bosso Niger State","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0404","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1002","0","0","0","0","0","0","1","1","10","1002","0","0","7","129","","TYOAPINE MIRIAM MHUNGUR","08139094859","","","2019-06-28-123028CREDENTIAL.pdf.pdf","F","2","Nigerian","22","2","1984","married","","","","miriamtyo2018@gail.com","","GBOKO","08139094859","","SS 18A, RAILWAY QUARTERS, MINNA, NIGER STATE","SS 18A, RAILWAY QUARTERS, MINNA, NIGER STATE","2019-06-28-121310.jpg","Normal","O","None","-","1","0","0","41.190.14.197","2019-11-25 14:31:57","2019-11-25 14:32:31","","","","1","0000-00-00 00:00:00","2019-06-28 12:08:06","0000-00-00 00:00:00","","","TYOAPINE GBUGHUL","08063554200","SS 18A, RAILWAY QUARTERS, MINNA, NIGER STATE","HUSBAND","1","TYOAPINE GBUGHUL","SS 18A, RAILWAY QUARTERS, MINNA, NIGER STATE","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1003","0","0","0","0","0","0","1","7","16","1003","0","0","27","546","","Shuaibu Abubakar","08065962764","","","2019-06-28-122928Shuaibu Abubakar.pdf.pdf","M","1","Nigerian","22","3","1968","married","","","","littlebengseworld@gmail.com","","Niger State","08065962764","","Majoyi  Gbako LGA Niger State","Majoyi  Gbako LGA Niger State","2019-06-28-121611.jpg","Normal","O","None","Nil","1","0","0","105.112.120.74","2019-11-15 10:53:59","2019-11-15 12:24:09","","","","1","0000-00-00 00:00:00","2019-06-28 12:15:13","0000-00-00 00:00:00","","","Shuaibu Abubakar","08065962764","Majoyi  Gbako LGA Niger State","Self","1","Shuaibu Abubakar","Majoyi  Gbako LGA Niger State","0","","0","0000-00-00 00:00:00","","26","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1004","0","0","0","0","0","0","1","2","2","1004","0","0","0","0","","abdullahi saidu kutigi","","","","","","0","","","","","","","","","abdullahikutigi2001@gmail.com","","","08168300192","","","","","","","","","1","0","0","105.112.120.179","2019-06-28 16:04:56","2019-06-28 16:05:13","","","","0","0000-00-00 00:00:00","2019-06-28 12:45:50","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1005","0","0","0","0","0","0","1","1","10","1005","0","0","24","502","","LAWAL ABDULWAHEED","08163367557","","","","M","1","Nigerian","29","10","1995","single","","","","angoaliyu76@yahoo.com","","OFFA","08163367557","","GBAGANU AREA MINNA NIGER STATE","","","Normal","A+","None","","1","0","0","197.210.45.108","2019-07-19 18:20:37","2019-07-19 18:31:00","","","","1","0000-00-00 00:00:00","2019-06-28 14:57:12","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1006","0","0","0","0","0","0","1","1","10","1006","0","0","31","633","","OLADIPUPO OLADEJO OLATUNDE","08036919291","","","","M","2","Nigerian","20","3","1978","married","","","","angoaliyu76@yahoo.com","","AKINYELE","08036919291","","94 PANAF DRIVER DAWAKI ABUJA","","","Normal","O","None","","1","0","0","41.203.73.167","2019-11-23 10:02:58","2019-11-23 10:03:38","","","","1","0000-00-00 00:00:00","2019-06-28 15:00:01","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1007","0","1","0","0","2","2","1","2","2","1007","0","0","27","544","","UMAR FATIMA","08163339755","","","","F","1","Nigerian","4","4","1996","single","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08163339755","","SINIZO LAGOS STREET MINNA NIGER STATE ","","","Normal","O","None","","1","0","0","197.210.64.69","2020-01-02 21:57:29","2020-01-02 21:58:29","","","","1","0000-00-00 00:00:00","2019-06-28 15:01:18","0000-00-00 00:00:00","","","","","","","3","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0261","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1008","0","1","0","0","4","4","1","4","4","1008","0","0","27","545","","MOHAMMED A. MOHAMMED","08149725292","","","","M","1","Nigerian","4","2","1993","single","","","","angoaliyu76@yahoo.com","","EDATI","08149725292","","C/O OF MAL. CHADO ,ISAH  DEPT. OF BIOLOGY IBBUL.","","","Normal","B+","None","","1","0","0","197.210.226.89","2020-02-07 17:43:24","2020-02-07 17:47:05","","","","1","0000-00-00 00:00:00","2019-06-28 15:02:54","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0353","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1009","0","1","0","0","9","18","1","4","12","1009","0","0","27","557","","IBRAHIM SALEH","07033186653","","","","M","1","Nigerian","21","7","1975","married","","","","angoaliyu76@yahoo.com","","PAIKORO","07033186653","","HOUSE NO. C49 ALADEY CHANCHAGA ","","","Normal","O","None","","1","0","0","197.210.58.226","2020-02-12 17:28:46","2020-02-12 18:00:54","","","","1","0000-00-00 00:00:00","2019-06-28 15:04:23","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2020-02-12 17:30:13","0419","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1010","0","1","0","0","2","2","1","2","2","1010","0","0","27","539","","MOHAMMED IBRAHIM","07065162338","","","","M","1","Nigerian","31","5","1989","single","","","","angoaliyu76@yahoo.com","","AGAIE","07065162338","","HOUSE NO. 36 ANGUWAN NASSARAWA CHANCHAGA MINNA NIGER STATE","","","Normal","B+","None","","1","0","0","105.112.115.177","2020-01-16 13:14:09","2020-01-16 13:14:52","","","","1","0000-00-00 00:00:00","2019-06-28 15:06:00","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0422","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1011","0","1","0","0","10","21","1","10","21","1011","0","0","27","544","","IBRAHIM AHMED","08034045451","","","","M","1","Nigerian","25","11","1990","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08034045451","","MANDELLA ROAD SAUKA - KAHUTA MINNA ,NIGER STATE.","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 14:21:43","2020-01-16 14:21:53","","","","1","0000-00-00 00:00:00","2019-06-28 15:07:30","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-16 10:46:50","0555","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1012","0","1","0","0","1","1","1","1","10","1012","0","0","27","539","","MOHAMMED NDASABE ABUBAKAR","08033689725","","","","M","1","Nigerian","10","2","1982","married","","","","angoaliyu76@yahoo.com","","AGAIE","08033689725","","08033689725","","","Normal","O","None","","1","0","0","105.112.117.154","2020-02-11 16:01:39","2020-02-11 16:10:05","","","","1","0000-00-00 00:00:00","2019-06-28 15:10:58","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2019-11-27 12:37:10","0624","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1013","0","1","0","0","10","20","1","10","20","1013","0","0","27","544","","HASSAN ABDULKARIM","09034586969","","","","M","2","Nigerian","4","8","1987","single","","","","angoaliyu76@yahoo.com","","CHANCHAGA","09034586969","","AFGHANISTAN, KPAKUNGU OPPOSITE OLD UNITY CLINIC MINNA NIGER STATE.","","","Normal","O","None","","1","0","0","197.210.45.38","2020-01-03 14:57:29","2020-01-03 14:58:05","","","","1","0000-00-00 00:00:00","2019-06-28 16:42:26","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0202","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1014","0","1","0","0","2","14","1","2","14","1014","0","0","27","541","","MOHAMMED ALIYU MOHAMMED","07034488138","","","","M","1","Nigerian","15","6","1980","married","","","","angoaliyu76@yahoo.com","","BIDA","07034488138","","HOUSE NO. C164 CAPTAIN TELLA B. TUNGA MINNA NIGER STATE","","","Normal","O","None","","1","1","0","197.210.70.149","2020-01-18 16:57:16","2020-01-02 21:49:45","","","","1","0000-00-00 00:00:00","2019-06-29 10:25:10","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0429","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1015","0","1","0","0","7","5","1","7","5","1015","0","0","27","541","","AHMED GIRAGI HADIZA","07060789903","","","","F","1","Nigerian","3","9","1997","single","","","","angoaliyu76@yahoo.com","","BIDA","07060789903","","ANTTENA NO 2  FADIKWAI OPPOSITE NEW MARKET MINNA NIGER STATE.","","","Normal","O","None","","1","0","0","197.210.60.119","2020-01-03 11:30:25","2020-01-03 11:31:33","","","","1","0000-00-00 00:00:00","2019-06-29 12:36:54","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0375","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1016","0","1","0","0","10","21","1","10","20","1016","0","0","27","557","","SANDA ALIYU ZALIYAT","09030426297","","","","F","1","Nigerian","3","3","1982","married","","","","angoaliyu76@yahoo.com","","PAIKORO","09030426297","","UNGUWAN TUKURAN CIKIN GARIN PAIKO","","","Normal","A+","None","","1","0","0","105.112.115.177","2020-01-16 14:15:07","2020-01-16 14:15:18","","","","1","0000-00-00 00:00:00","2019-06-29 13:28:50","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2019-12-12 12:07:50","0339","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1017","0","1","0","0","9","18","1","10","21","1017","0","0","27","556","","NAOMI O GODWIN","08134616566","","","2019-07-03-113936NONO.pdf.pdf","F","2","Nigerian","15","11","1988","single","","","","Naomigodwin2016@gmail.com","","SARKIN PAWA","08134616566","","CBN QTRS FARM CENTRE TUNGA MINNA","CBN QTRS FARM CENTRE TUNGA MINNA","2019-07-03-114343.jpg","Normal","O","None","CBN QTRS FARM CENTRE TUNGA MINNA","1","0","0","105.112.122.89","2020-02-26 10:34:53","2020-02-26 10:38:38","","","","1","0000-00-00 00:00:00","2019-07-01 13:46:25","0000-00-00 00:00:00","","","ODOJI GODWIN","08168835772","CBN QTRS FARM CENTRE TUNGA MINNA","FATHER","1","NIL","CBN QTRS FARM CENTRE TUNGA MINNA","1","                                
\n                                                                 
\n                                ","3","2019-11-08 12:04:24","0460","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1018","0","1","0","0","2","14","1","2","14","1018","0","0","27","550","","UMAR ISAH HAJARA","08039385243","","","","F","1","Nigerian","7","3","1981","married","","","","angoaliyu76@yahoo.com","","LAPAI","08039385243","","NO4 IDRIS HASSAN ROAD MINNA NIGER STATE","","","Normal","O","None","","1","0","0","197.210.65.178","2020-01-02 21:07:15","2020-01-02 21:07:45","","","","1","0000-00-00 00:00:00","2019-07-02 10:42:26","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0058","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1019","0","1","0","0","9","18","1","9","18","1019","0","0","27","539","","RAKIYA SULEIMAN MAHMUD","08034414141","","","","F","1","Nigerian","15","6","1969","married","","","","angoaliyu76@yahoo.com","","AGAIE","08034414141","","NO4 BEHIND NAT PRIMARY HEALTH CARE, F/ LAY OUT, MINNA.","","","Normal","O","None","","1","0","0","105.112.122.121","2019-09-24 14:19:59","2019-09-24 16:19:55","","","","1","0000-00-00 00:00:00","2019-07-02 11:00:07","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0116","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1020","0","0","0","0","0","0","1","2","15","1020","0","0","27","549","","ABDULLAHI YUSUF","08036638828","","","","M","1","Nigerian","16","2","1970","married","","","","angoaliyu76@yahoo.com","","KONTAGORA","08036638828","","SULEIMAN ATTIKU ROAD G.C8 UNGUWAN GWARI KONTAGORA ","","","Normal","A+","None","","1","0","0","197.210.226.240","2019-07-20 10:46:14","2019-07-20 10:47:48","","","","1","0000-00-00 00:00:00","2019-07-02 11:29:31","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1021","0","1","0","0","4","12","1","4","12","1021","0","0","27","557","","SAHABI SULEIMAN ","09051666675","","","","M","1","Nigerian","4","3","1999","single","","","","angoaliyu76@yahoo.com","","PAIKORO","09051666675","","SHAMPAPI / WAZOBIA PRIMARY SCHOOL ","","","Normal","O","None","","1","0","0","105.112.112.20","2020-01-28 16:13:59","2020-01-28 16:14:08","","","","1","0000-00-00 00:00:00","2019-07-02 11:55:26","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-12-09 15:23:59","0671","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1022","0","0","0","0","0","0","1","2","2","1022","0","0","19","365","","MOHAMMED ABDULLAHI IBRAHIM","08065605352","","","","M","1","Nigerian","4","3","1989","single","","","","angoaliyu76@yahoo.com","","SABON GARI","08065605352","","TOP MEDICAL ROAD MINNA NIGER STATE","","","Normal","A+","None","","1","0","0","197.210.227.151","2019-07-20 10:51:19","2019-07-20 10:51:52","","","","1","0000-00-00 00:00:00","2019-07-02 12:53:54","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1023","0","0","0","0","0","0","1","10","21","1023","0","0","27","557","","GARBA JOHN BALA","08066350403","","","","M","2","Nigerian","24","6","1992","married","","","","angoaliyu76@yahoo.com","","PAIKO","08066350403","","DUTSEN KURA GWARI, OPP. MAINAGWA MIWWA NIGER STATE.","","","Normal","O","None","","1","1","0","197.210.70.231","2020-02-02 14:31:25","2019-07-20 10:52:40","","","","1","0000-00-00 00:00:00","2019-07-02 13:34:03","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1024","0","0","0","0","0","0","1","1","11","1024","0","0","27","557","","BELLO HAMZAT","08069192746","","","","M","1","Nigerian","6","5","1988","single","","","","angoaliyu76@yahoo.com","","PAIKORO","08069192746","","NTD 112 OPP CBN STAFF QUARTERS TUNGA MINNA NIGER STATE","","","Normal","B+","None","","1","0","0","197.210.226.178","2019-07-20 10:52:45","2019-07-20 10:53:35","","","","1","0000-00-00 00:00:00","2019-07-02 13:57:59","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1025","0","1","0","0","1","10","1","1","10","1025","0","0","27","541","","ABDULLAHI NDAGI SHABA","08032653419","","","","M","1","Nigerian","3","2","1963","married","","","","angoaliyu76@yahoo.com","","BIDA","08032653419","","M.I WUSHISHI QUATERS MINNA NIGER STATE","","","Normal","O","None","","1","0","0","105.112.116.72","2020-01-24 12:26:43","2020-01-24 12:26:58","","","","1","0000-00-00 00:00:00","2019-07-02 15:12:03","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0434","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1026","0","1","0","0","4","4","1","4","4","1026","0","0","27","550","","ABDULLAHI MOHAMMED HADI","08166281434","","","","M","1","Nigerian","12","12","1984","married","","","","angoaliyu76@yahoo.com","","LAPAI","08166281434","","NO.75, LONDON STREET DUTSEN KURA ,MINNA NIGER STATE.","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 11:49:32","2020-01-16 11:49:42","","","","1","0000-00-00 00:00:00","2019-07-05 12:42:32","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0113","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1027","0","1","0","0","10","21","1","2","14","1027","0","0","27","541","","AISHA FARDAUSI ABUBAKAR","08165404435","","","","F","1","Nigerian","5","12","1995","married","","","","angoaliyu76@yahoo.com","","BIDA","08165404435","","LONDON STREET OFF BAJAGO HOUSE NO. 37 ROCK STRRET. MINNA","","","Normal","O","None","","1","1","0","197.210.44.224","2020-02-10 18:28:08","2020-01-28 16:32:34","","","","1","0000-00-00 00:00:00","2019-07-05 14:20:48","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-04 13:53:46","0495","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1028","0","1","0","0","10","21","1","10","21","1028","0","0","27","541","","FATIMA BINTA MUSTAPHA","07034900066","","","","F","1","Nigerian","2","2","1991","single","","","","angoaliyu76@yahoo.com","","BIDA","07034900066","","ORPHANE QUARTERS MINNA NIGER STATE","","","Normal","O","None","","1","0","0","197.210.64.79","2020-01-03 12:43:10","2020-01-03 12:43:39","","","","1","0000-00-00 00:00:00","2019-07-05 16:50:55","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-29 16:46:25","0641","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1029","0","0","0","0","0","0","1","4","12","1029","0","0","27","555","","SARA CHRISTIANA","08035668614","","","","F","2","Nigerian","31","12","1979","married","","","","angoaliyu76@yahoo.com","","MOKWA","08035668614","","NO TH. 18 SALIU AUDI ROAD OLD AIRPORT QUARTERS MINNA.","","","Normal","B+","None","","1","0","0","197.210.226.122","2019-07-20 10:59:52","2019-07-20 11:00:27","","","","1","0000-00-00 00:00:00","2019-07-05 16:52:39","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1030","0","0","0","0","0","0","1","9","18","1030","0","0","22","450","","MOHAMMED AISHA LAWAL","08130617756","","","","F","1","Nigerian","15","3","1988","married","","","","angoaliyu76@yahoo.com","","ARGUNGU","08130617756","","BEHIND SHIRORO HOTEL TUNGA MINNA ","","","Normal","O","None","","1","0","0","197.210.226.122","2019-07-20 11:00:34","2019-07-20 11:01:24","","","","1","0000-00-00 00:00:00","2019-07-05 16:56:00","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1031","0","0","0","0","0","0","1","4","12","1031","0","0","27","551","","MUHAMMED IDRIS WACHIN","08105231260","","","","M","1","Nigerian","18","5","1993","single","","","","angoaliyu76@yahoo.com","","LAVUN","08105231260","","S.W 131 KETEREN GWARI MINNA NIGER STATE.","","","Normal","O","None","","1","0","0","105.112.112.243","2019-09-07 12:16:51","2019-09-07 12:21:56","","","","1","0000-00-00 00:00:00","2019-07-05 17:03:08","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1032","0","1","0","0","2","15","1","2","15","1032","0","0","27","539","","SANI JUMMAI","08065357016","","","","F","1","Nigerian","1","12","1973","married","","","","angoaliyu76@yahoo.com","","AGAIE","08065357016","","TUNGA MINNA NIGER STATE","","","Normal","O","Handicapped","","1","0","0","105.112.115.177","2020-01-16 13:07:52","2020-01-16 13:08:02","","","","1","0000-00-00 00:00:00","2019-07-05 17:04:27","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-10-31 16:39:53","0488","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1033","0","1","0","0","10","21","1","10","21","1033","0","0","27","560","","AHMED DENNIS","08059999695","","","","M","2","Nigerian","17","9","1972","married","","","","angoaliyu76@yahoo.com","","SHIRORO","08059999695","","ROYAL COMPRENSIVE SCHOOL KAFFIN KORO P.O BOX 2951 MINNA NIGER STATE.","","","Normal","O","None","","1","0","0","105.112.116.72","2020-01-24 12:58:48","2020-01-24 12:59:33","","","","1","0000-00-00 00:00:00","2019-07-05 17:05:51","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0166","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1034","0","1","0","0","7","5","1","7","5","1034","0","0","27","548","","ABUBAKAR ALHAJI LIMAN","07066614676","","","","M","1","Nigerian","1","5","1995","single","","","","angoaliyu76@yahoo.com","","KATCHA","07066614676","","DAWANFU VILLAGE KATCHA LOCAL GOVERNMENT","","","Normal","O","None","","1","0","0","197.210.227.151","2019-07-20 11:05:06","2019-07-20 11:10:27","","","","1","0000-00-00 00:00:00","2019-07-05 17:07:19","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1035","0","1","0","0","2","2","1","2","2","1035","0","0","27","550","","SAIDU HUSSAINA YELWA","08165374247","","","","F","1","Nigerian","25","8","1998","single","","","","angoaliyu76@yahoo.com","","LAPAI","08165374247","","BEHIND SUPREME SCHOOL KANGIWA ROAD CHANCHAGA","","","Normal","O","None","","1","0","0","105.112.112.74","2019-09-27 11:29:55","2019-09-27 11:31:28","","","","1","0000-00-00 00:00:00","2019-07-05 17:08:32","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0181","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1036","0","1","0","0","2","2","1","2","2","1036","0","0","27","544","","ABDULLAHI AISHA","08138387232","","","","F","1","Nigerian","14","12","1997","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08138387232","","S.N 507 KETEREN GWARI ROAD MINNA, NIGER STATE.","","","Normal","B+","None","","1","0","0","197.210.70.15","2020-02-04 17:02:23","2020-02-04 17:08:10","","","","1","0000-00-00 00:00:00","2019-07-05 17:09:52","0000-00-00 00:00:00","","","","","","","3","","","1","                                
\n                                                                 
\n                                ","3","2019-10-30 13:17:28","0384","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1037","0","0","0","0","0","0","1","1","11","1037","0","0","27","558","","IBRAHIM MUHAMMED KAGARA","07052734551","","","","M","1","Nigerian","25","6","1968","married","","","","angoaliyu76@yahoo.com","","RAFI","07052734551","","SABON GARIN KAGARA OPPOSITE GIDAN ZAURE","","","Normal","O","None","","1","0","0","105.112.122.237","2019-09-19 14:45:50","2019-09-19 14:47:15","","","","1","0000-00-00 00:00:00","2019-07-05 17:13:11","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1038","0","0","0","0","0","0","1","1","10","1038","0","0","27","550","","HUSSAINA SULEIMAN","07035622001","","","","M","1","Nigerian","20","12","1990","single","","","","angoaliyu76@yahoo.com","","LAPAI","07035622001","","HOUSE NO. 11 FEDERAL HOUSING QUARTERS BARKIN SALE, MINNA NIGER STATE.","","","Normal","A+","None","","1","0","0","197.210.64.122","2019-07-06 14:24:43","2019-07-06 14:28:24","","","","0","0000-00-00 00:00:00","2019-07-05 17:15:28","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1039","0","1","0","0","10","21","1","10","21","1039","0","0","27","549","","UBANDOMA BAWA TANKO","08035977240","","","","M","1","Nigerian","20","3","1973","married","","","","angoaliyu76@yahoo.com","","KONTAGORA","08035977240","","AZ 22, BAKORI ROAD KADUNA KADUNA STATE","","","Normal","O","Handicapped","","1","0","0","105.112.117.154","2020-02-11 15:55:42","2020-02-11 15:57:37","","","","1","0000-00-00 00:00:00","2019-07-05 17:16:56","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0126","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1040","0","1","0","0","2","2","1","2","2","1040","0","0","27","550","","SAIDU HASSANA YELWA","08165374247","","","","F","1","Nigerian","25","8","1998","single","","","","angoaliyu76@yahoo.com","","LAPAI","08165374247","","BEHIND SUPREME SCHOOL KANGIWA ROAD CHANCHAGA","","","Normal","O","None","","1","0","0","105.112.112.74","2019-09-27 11:31:42","2019-09-27 11:33:10","","","","1","0000-00-00 00:00:00","2019-07-05 17:18:28","0000-00-00 00:00:00","","","","","","","3","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0182","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1041","0","1","0","0","4","13","1","4","13","1041","0","0","27","560","","AISHATU AHMADU","08031198464","","","","F","1","Nigerian","6","7","1968","married","","","","angoaliyu76@yahoo.com","","MUNYA","08031198464","","HOUSE NO 164 TUNGA GORO CHANCHAGA MINNA NIGER STATE.","","","Normal","B+","None","","1","1","0","197.210.52.24","2020-02-03 12:07:04","2020-01-28 16:15:34","","","","1","0000-00-00 00:00:00","2019-07-05 17:20:52","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-01 11:26:22","0532","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1042","0","1","0","0","7","16","1","10","21","1042","0","0","27","541","","SHEHU SA\'ADATU","08039269162","","","","F","1","Nigerian","25","3","1990","married","","","","angoaliyu76@yahoo.com","","BIDA","08039269162","","TUBA HOUSING ESTATE BIDA MINNA","","","Normal","B+","None","","1","0","0","197.210.44.171","2020-02-03 10:40:47","2020-02-03 14:01:40","","","","1","0000-00-00 00:00:00","2019-07-05 17:22:27","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2020-01-06 16:35:09","0025","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1043","0","0","0","0","0","0","1","10","21","1043","0","0","27","557","","MOHAMMED YUSUF ISMAILA","07065065571","","","","M","1","Nigerian","21","2","1986","married","","","","angoaliyu76@yahoo.com","","PAIKORO","07065065571","","LUGODNA PAIKO PAIKORO LOCAL GOVERNMENT AREA NGER STATE","","","Normal","O","None","","1","0","0","105.112.122.130","2020-02-03 14:11:50","2020-02-03 14:23:20","","","","1","0000-00-00 00:00:00","2019-07-05 17:23:59","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1044","0","1","0","0","2","14","1","2","14","1044","0","0","27","543","","SAUSATU OTAKEY HASSAN","07034937494","","","","F","1","Nigerian","15","12","1985","married","","","","angoaliyu76@yahoo.com","","BOSSO","07034937494","","HOUSE NO. 1 SARKIN BOSSO MINNA NIGER STATE.","","","Normal","O","None","","1","1","0","105.112.116.21","2020-02-26 19:46:51","2020-01-24 12:53:47","","","","1","0000-00-00 00:00:00","2019-07-05 17:25:59","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2020-02-26 17:21:33","0006","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1045","0","1","0","0","1","1","1","1","1","1045","0","0","27","551","","BABA SHABA MOHAMMED","08063228716","","","","M","1","Nigerian","1","3","1979","married","","","","angoaliyu76@yahoo.com","","LAVUN","08063228716","","LATIKO VIA GABA ,GABA DISTRIC LAVUN LOCAL GOV\'T  NIGER STATE","","","Normal","O","None","","1","0","0","105.112.114.140","2020-01-16 09:21:28","2020-01-16 09:23:34","","","","1","0000-00-00 00:00:00","2019-07-05 17:27:57","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0024","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1046","0","0","0","0","0","0","1","10","20","1046","0","0","11","222","","ONWUKWE ENYINNAYA BRIGHT","07033804193","","","","M","2","Nigerian","6","6","1991","married","","","","angoaliyu76@yahoo.com","","OHAOZARA","07033804193","","ONWUKWE OGO COMPOUND MGBOM ENU OKPOSI OHOZARE L.G.A EBNOYI STATE. ","","","Normal","O","None","","1","0","0","197.210.226.232","2019-07-20 11:36:40","2019-07-20 11:37:40","","","","1","0000-00-00 00:00:00","2019-07-05 17:30:29","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1047","0","0","0","0","0","0","1","10","21","1047","0","0","27","544","","AUDU HAJARA","08065073768","","","","F","1","Nigerian","28","2","1983","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08065073768","","KPAKUNGU, SOJE B\' MINNA BEHIND MAINASSARA CLINIC NIGER STATE ","","","Normal","A+","None","","1","0","0","197.210.227.151","2019-07-20 11:37:45","2019-07-20 11:38:45","","","","1","0000-00-00 00:00:00","2019-07-05 17:31:45","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1048","0","0","0","0","0","0","1","4","4","1048","0","0","27","544","","DUKULY MAMADEE DUX","08033737260","","","","M","1","Nigerian","20","12","1978","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08033737260","","ILMI AVENUE, P.O.BOX 3066, MINNA NIGER STATE.","","","Normal","A+","None","","1","0","0","197.210.227.151","2019-07-20 11:38:59","2019-07-20 11:40:09","","","","1","0000-00-00 00:00:00","2019-07-05 17:44:01","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1049","0","1","0","0","1","10","1","1","10","1049","0","0","0","0","","HUSSAINI SULEIMAN","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07035622001","","","","","","","","","1","0","0","105.112.122.165","2020-02-03 18:40:49","2020-02-03 19:12:43","","","","1","0000-00-00 00:00:00","2019-07-06 14:30:44","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-29 10:02:40","0626","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1050","0","1","0","0","1","10","1","1","10","1050","0","0","27","544","","HARUNA RABIU","07039178388","","","","M","1","Nigerian","19","4","1992","single","","","","angoaliyu76@yahoo.com","","CHANCHAGA","07039178388","","HOUSE NO 8 BAJEGO AREA. OFF OKADA ROAD MINNA","","","Normal","O","Handicapped","","1","0","0","105.112.112.20","2020-01-28 15:56:35","2020-01-28 15:56:56","","","","1","0000-00-00 00:00:00","2019-07-08 14:44:35","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-29 14:09:23","0638","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1051","0","1","0","0","2","14","1","2","14","1051","0","0","27","544","","SAIKOYE OLIVIA PAMBOLO","08035978543","","","","F","2","Nigerian","9","7","1974","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08035978543","","FAAN QUARTERS MINNA NIGER STATE.","","","Normal","O","None","","1","0","0","197.210.45.38","2020-01-03 14:47:30","2020-01-03 14:48:02","","","","1","0000-00-00 00:00:00","2019-07-08 14:46:58","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0358","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1052","0","1","0","0","10","20","1","10","20","1052","0","0","27","547","","IBRAHIM ADAMA","09061632177","","","","F","1","Nigerian","2","1","1996","married","","","","angoaliyu76@yahoo.com","","GURARA","09061632177","","LAMBATA GURARA","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 14:31:31","2020-01-16 14:32:04","","","","1","0000-00-00 00:00:00","2019-07-08 14:49:38","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0308","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1053","0","1","0","0","10","21","1","10","21","1053","0","0","27","557","","IBRAHIM ABDULLAHI KWATU","07039418994","","","","M","1","Nigerian","24","11","1983","married","","","","angoaliyu76@yahoo.com","","PAIKORO","07039418994","","TYPE B\' QUATERS HOUSE NO 7 ILORIN STREET MINNA NIGER STATE","","","Normal","A+","None","","1","0","0","105.112.112.20","2020-01-28 16:33:35","2020-01-28 16:33:45","","","","1","0000-00-00 00:00:00","2019-07-08 14:52:08","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0388","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1054","0","0","0","0","0","0","1","2","2","1054","0","0","27","550","","IBRAHIM AISHA","09094165912","","","","M","1","Nigerian","7","5","1987","married","","","","angoaliyu76@yahoo.com","","LAPAI","09094165912","","NO 1 OKADA ROAD MINNA NIGER STATE","","","Normal","A+","None","","1","0","0","197.210.226.126","2019-07-20 11:45:10","2019-07-20 11:47:00","","","","1","0000-00-00 00:00:00","2019-07-08 15:48:32","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1055","0","1","0","0","9","6","1","11","23","1055","0","0","27","559","","IBRAHIM IBRAHIM E.","07068729892","","","","M","2","Nigerian","4","9","1990","single","","","","ibrahimeibrahim@ymail.com","","RIJAU","07068729892","","ROAD 5. HOUSE  7 BRIGHTER MINNA OFF MANDELA.","","","Normal","O","None","","1","1","0","197.210.85.64","2019-11-20 15:38:01","2019-11-15 14:05:47","","","","1","0000-00-00 00:00:00","2019-07-10 10:50:55","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1056","0","1","0","0","1","10","1","1","10","1056","0","0","27","552","","ALIYU BADHIR AUNA","08034369633","","","","M","1","Nigerian","1","10","1980","single","","","","angoaliyu76@yahoo.com","","MAGAMA","08034369633","","TUNGA MINNA, OPP. NASFAH HOTELS","","","Normal","O","None","","1","0","0","105.112.112.20","2020-01-28 15:52:36","2020-01-28 15:53:03","","","","1","0000-00-00 00:00:00","2019-07-10 10:52:26","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-10-31 11:57:16","0536","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1057","0","1","0","0","10","21","1","10","20","1057","0","0","27","553","","BAKO HARUNA BANGI","08035997723","","","","M","1","Nigerian","16","5","1984","single","","","","angoaliyu76@yahoo.com","","MARIGA","08035997723","","MARIGA LOCAL GOVERNMENT BANGI NIGER STATE.","","","Normal","O","None","","1","0","0","197.210.71.227","2020-02-24 15:36:31","2020-02-24 15:40:54","","","","1","0000-00-00 00:00:00","2019-07-10 10:54:09","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                                                 
\n                                ","3","2020-02-24 15:38:48","0454","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1058","0","1","0","0","1","11","1","1","11","1058","0","0","27","560","","MOHAMMED YAHAYA","08034366153","","","","M","1","Nigerian","19","4","1968","married","","","","angoaliyu76@yahoo.com","","SHIRORO","08034366153","","UNGUWANDAJI MINNA","","","Normal","B+","None","","1","0","0","105.112.112.11","2019-10-29 14:15:51","2019-10-30 03:58:46","","","","1","0000-00-00 00:00:00","2019-07-10 10:55:47","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","0000-00-00 00:00:00","0368","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1059","0","1","0","0","10","21","1","10","21","1059","0","0","27","556","","MUHAMMED WAZIRI JAMILA","09038880246","","","","F","1","Nigerian","27","4","1992","single","","","","angoaliyu76@yahoo.com","","MUNYA","09038880246","","NO. 42 ALH . MIHD.WAZIRI STRRET DUTSEN KURA GWARI WESTERN BY-PASS, MINNA NIGER STATE","","","Normal","A+","None","","1","1","0","105.112.117.10","2020-02-14 14:13:28","2019-07-20 10:26:12","","","","1","0000-00-00 00:00:00","2019-07-10 10:57:25","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0282","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1060","0","0","0","0","0","0","1","10","21","1060","0","0","27","560","","HALIRU TANKO KUTA","08037849576","","","","M","1","Nigerian","21","5","1992","married","","","","angoaliyu76@yahoo.com","","SHIRORO","08037849576","","UP HILL DAVID MARK ROAD HOUSE NO2. MAIZUBE RESIDENCE MINNA","","","Normal","A+","None","","1","1","0","105.112.122.102","2019-11-29 11:16:42","2019-10-30 15:08:05","","","","1","0000-00-00 00:00:00","2019-07-10 12:36:28","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1061","0","1","0","0","7","16","1","7","16","1061","0","0","27","544","","ABDULLAHI RAHAMATU","08068868322","","","","F","1","Nigerian","3","8","1994","single","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08068868322","","OKADA ROAD MINNA NIGER STATE.","","","Normal","A+","None","","1","0","0","105.112.115.177","2020-01-16 13:37:30","2020-01-16 13:38:01","","","","1","0000-00-00 00:00:00","2019-07-10 12:37:42","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0423","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1062","0","1","0","0","10","21","1","10","21","1062","0","0","27","557","","ZAINAB MOHAMMED ","07034585125","","","","M","1","Nigerian","15","10","1981","married","","","","angoaliyu76@yahoo.com","","PAIKORO","07034585125","","TUNGA OPP. TOPMEDICAL ROAD TUNGA MINNA ","","","Normal","B+","None","","1","0","0","105.112.115.177","2020-01-16 14:20:27","2020-01-16 14:20:39","","","","1","0000-00-00 00:00:00","2019-07-10 13:12:13","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-05 17:25:28","0483","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1063","0","1","0","0","9","18","1","10","20","1063","0","0","27","541","","SALAMATU UTHMAN WACHIKO","08134615038","","","","F","1","Nigerian","18","12","1989","married","","","","angoaliyu76@yahoo.com","","BIDA","08134615038","","MAIAGUWA CLOSE, 171 SHOUKA KAWHUTA NIGER STATE MINNA.","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 14:52:25","2020-01-16 14:52:34","","","","1","0000-00-00 00:00:00","2019-07-10 13:22:36","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-19 15:04:31","0582","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1064","0","0","0","0","0","0","1","2","14","1064","0","0","27","539","","BAGUDU MAMUDU","07036013806","","","","M","1","Nigerian","24","8","1984","married","","","","angoaliyu76@yahoo.com","","AGAIE","07036013806","","ETSU ABDULLAHI 1 ANNEX EKOBADEGGI WARD AGAIE","","","Normal","O","Handicapped","","1","0","0","197.210.227.142","2019-07-20 10:34:10","2019-07-20 10:34:49","","","","1","0000-00-00 00:00:00","2019-07-10 13:47:09","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1065","0","1","0","0","2","15","1","2","15","1065","0","0","27","556","","ABDULMALIK WAKILI","07036310956","","","","M","1","Nigerian","13","3","1995","married","","","","angoaliyu76@yahoo.com","","MUNYA","07036310956","","TUTAKPMA DANDAUDU MUNYA LOCAL GOVERNMENT.","","","Normal","O","None","","1","0","0","197.210.64.39","2020-01-02 21:21:28","2020-01-02 21:22:18","","","","1","0000-00-00 00:00:00","2019-07-10 14:00:20","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0232","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1066","0","1","0","0","10","21","1","4","12","1066","0","0","27","560","","EZEKIEL MAUREEN SAIDU","07032296862","","","","F","2","Nigerian","12","12","1992","single","","","","angoaliyu76@yahoo.com","","SHIRORO","07032296862","","NO. 116 ANGUWANBIRI BOSSO MINNA NIGER STATE.","","","Normal","A+","None","","1","0","0","105.112.117.216","2020-02-11 15:27:39","2020-02-11 15:38:30","","","","1","0000-00-00 00:00:00","2019-07-11 15:24:57","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0413","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1067","0","1","0","0","10","21","1","10","21","1067","0","0","27","560","","IBRAHIM SHAZHIMI STELLA","07037573362","","","","F","2","Nigerian","8","11","1989","married","","","","angoaliyu76@yahoo.com","","SHIRORO","07037573362","","NO.24 KONTAGORA ROAD","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 14:22:12","2020-01-16 14:22:22","","","","1","0000-00-00 00:00:00","2019-07-11 15:27:22","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-01 15:14:07","0501","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1068","0","1","0","0","7","16","1","10","21","1068","0","0","27","544","","MUHAMMED D. MUHAMMED","08052658843","","","","M","1","Nigerian","24","4","1988","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08052658843","","FARM CENTRE BEHIND ETISALAT OFFICE MINNA.","","","Normal","O","None","","1","0","0","105.112.112.20","2020-01-28 16:27:54","2020-01-28 16:28:07","","","","1","0000-00-00 00:00:00","2019-07-11 15:28:48","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-21 14:45:07","0596","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1069","0","1","0","0","2","15","1","2","15","1069","0","0","27","539","","UMAR NDAGI IBRAHIM","08069715220","","","","M","1","Nigerian","2","2","1971","married","","","","angoaliyu76@yahoo.com","","AGAIE","08069715220","","EMI-SANKUCHI EKONUGI WARD AGAIE LOCAL GOV\'T.","","","Normal","B+","None","","1","0","0","197.210.53.66","2020-02-26 15:24:30","2020-02-26 15:42:18","","","","1","0000-00-00 00:00:00","2019-07-11 15:30:34","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","0000-00-00 00:00:00","0336","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1070","0","0","0","0","0","0","1","9","18","1070","0","0","27","545","","HAUWA HARUNA BABA","07035108373","","","","F","1","Nigerian","30","10","1991","married","","","","angoaliyu76@yahoo.com","","EDATI","07035108373","","KPAKUNGU SOKJE \'A\' MINNA NIGER STATE.","","","Normal","O","None","","1","0","0","197.210.226.126","2019-07-20 10:39:27","2019-07-20 10:40:01","","","","1","0000-00-00 00:00:00","2019-07-11 15:34:48","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1071","0","1","0","0","10","21","1","10","21","1071","0","0","27","546","","NMADU VICTOR","08160510005","","","","M","2","Nigerian","12","10","1993","single","","","","angoaliyu76@yahoo.com","","GBAKO","08160510005","","EEMAN SCHLLO TUNGA FULANI OPP. DEPPER LIFE CHURCH. ","","","Normal","O","Handicapped","","1","0","0","197.210.226.149","2020-02-07 12:27:31","2020-02-07 12:30:56","","","","1","0000-00-00 00:00:00","2019-07-11 15:36:41","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2020-01-02 12:54:47","0015","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1072","0","0","0","0","0","0","1","2","15","1072","0","0","27","551","","SAYEDI MOHAMMED BABA ALHAJI","08036217565","","","","M","1","Nigerian","14","3","1964","married","","","","angoaliyu76@yahoo.com","","LAVUN","08036217565","","ALH. SABA ROAD, TUMAKAKA KUTIGI LAVUN LOCAL GOV\'T NIGER STATE.","","","Normal","O","None","","1","0","0","197.210.52.152","2019-08-19 15:05:42","2019-08-19 15:07:54","","","","1","0000-00-00 00:00:00","2019-07-15 13:25:58","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1073","0","1","0","0","4","13","1","4","13","1073","0","0","27","551","","FATIMA AKUKI YAKUBU","08029452029","","","","F","1","Nigerian","6","12","1984","married","","","","angoaliyu76@yahoo.com","","LAVUN","08029452029","","OFF MASALLACIN JUMMA\\\'A FADIPE MINNA NIGER STATE.","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 11:37:48","2020-01-16 11:37:58","","","","1","0000-00-00 00:00:00","2019-07-15 13:28:56","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0447","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1074","0","0","0","0","0","0","1","7","16","1074","0","0","27","550","","IBRAHIM MUHAMMED EWUGI","07031654646","","","","M","1","Nigerian","15","9","1984","married","","","","angoaliyu76@yahoo.com","","LAPAI","07031654646","","NO.1 BABA IBRAHIM ROAD TUNGA MINNA NIGER STATE","","","Normal","O","None","","1","0","0","197.210.53.234","2019-08-19 15:09:14","2019-08-19 15:10:04","","","","1","0000-00-00 00:00:00","2019-07-15 13:31:34","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1075","0","1","0","0","2","15","1","2","15","1075","0","0","27","544","","GARBA MOHAMMED","08032861683","","","","M","1","Nigerian","9","7","1977","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08032861683","","BEHIND KPAKUNGU POLICE STATION","","","Normal","O","Handicapped","","1","0","0","105.112.115.177","2020-01-16 12:52:03","2020-01-16 12:52:13","","","","1","0000-00-00 00:00:00","2019-07-15 13:33:22","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0062","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1076","0","1","0","0","4","12","1","4","12","1076","0","0","27","555","","SHEHU ABUBAKAR KINBOKUN","08130402343","","","","M","1","Nigerian","17","9","1983","married","","","","angoaliyu76@yahoo.com","","MOKWA","08130402343","","EMI MAL. SHEHU SARKI MALAMI KINBOKUN","","","Normal","O","None","","1","0","0","197.210.45.38","2020-01-03 14:30:50","2020-01-03 14:31:23","","","","1","0000-00-00 00:00:00","2019-07-15 13:35:17","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0365","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1077","0","1","0","0","7","16","1","2","14","1077","0","0","27","557","","HUSSAINA USMAN","07032241173","","","","F","1","Nigerian","12","3","1983","married","","","","angoaliyu76@yahoo.com","","PAIKO","07032241173","","NIGER STATE PAIKO LOCAL GOVERNMENT ","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 13:48:18","2020-01-16 13:48:51","","","","1","0000-00-00 00:00:00","2019-07-17 15:33:41","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-12-06 14:48:57","0667","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1078","0","0","0","0","0","0","1","10","20","1078","0","0","27","539","","ABDULMALIK ABDULLAHI","08035325834","","","","M","1","Nigerian","20","5","1988","married","","","","angoaliyu76@yahoo.com","","AGAIE","08035325834","","S.W 491 KETEREGUWARI ROAD MINNA NIGER STATE.","","","Normal","O","None","","1","0","0","197.210.52.54","2019-08-19 15:15:18","2019-08-19 15:16:09","","","","1","0000-00-00 00:00:00","2019-07-17 15:35:14","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1079","0","1","0","0","10","21","1","7","16","1079","0","0","27","550","","SULEIMAN MAIMUNAT","08160668494","","","","M","1","Nigerian","15","4","1981","married","","","","angoaliyu76@yahoo.com","","LAPAI","08160668494","","BESIDE GOVERNMENT PRIMARY SCHOOL BARKIN SALE MINNA NIGER STATE","","","Normal","O","None","","1","0","0","197.210.60.119","2020-01-03 11:40:13","2020-01-03 11:40:41","","","","1","0000-00-00 00:00:00","2019-07-17 15:36:38","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                                                 
\n                                ","3","2020-02-11 16:40:43","0514","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1080","0","1","0","0","2","15","1","2","15","1080","0","0","27","544","","SANI ABDULLAHI","08060538998","","","","M","1","Nigerian","22","7","1968","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08060538998","","KETEREN GWARI MINNA NIGER STATE","","","Normal","A+","None","","1","0","0","105.112.116.48","2020-01-15 09:57:01","2020-01-16 07:57:43","","","","1","0000-00-00 00:00:00","2019-07-17 15:38:10","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2020-01-15 09:56:32","0031","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1081","0","1","0","0","2","2","1","2","2","1081","0","0","27","544","","MUSA HADIZA","08067608596","","","","F","1","Nigerian","21","5","1995","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08067608596","","S.E 91 SABON GARI MINNA NIGER STATE","","","Normal","O","None","","1","0","0","197.210.227.140","2020-02-07 12:19:34","2020-02-07 12:27:20","","","","1","0000-00-00 00:00:00","2019-07-17 15:40:18","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2020-01-03 10:38:55","0019","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1082","0","1","0","0","9","18","1","2","14","1082","0","0","27","557","","MOHAMMED ABDULLAHI ETSU","07033087165","","","","M","1","Nigerian","8","5","1993","single","","","","angoaliyu76@yahoo.com","","PAIKORO","07033087165","","CHANCHAGA BACK OF PRIMARY SCHOOL MINNA NIGER STATE.","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 14:50:12","2020-01-16 14:50:23","","","","1","0000-00-00 00:00:00","2019-07-17 15:42:25","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-05 17:28:27","0482","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1083","0","0","0","0","0","0","1","9","18","1083","0","0","27","544","","BAKO HASSANA ABDULLAHI","07033165208","","","","F","1","Nigerian","11","8","1989","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","07033165208","","NE 202 ABAYI CLOSE MINNA NIGER STATE","","","Normal","O","None","","1","0","0","197.210.53.113","2019-08-19 15:20:47","2019-08-19 15:21:38","","","","1","0000-00-00 00:00:00","2019-07-17 15:44:39","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1084","0","1","0","0","10","21","1","10","21","1084","0","0","27","541","","IBRAHIM ABDULLAHI","08068622661","","","","M","1","Nigerian","25","3","1988","married","","","","angoaliyu76@yahoo.com","","BIDA","08068622661","","AGUWAN BIRI BOSSO MINNA NIGER STATE","","","Normal","A+","None","","1","0","0","105.112.115.177","2020-01-16 14:05:17","2020-01-16 14:05:28","","","","1","0000-00-00 00:00:00","2019-07-17 15:46:02","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0056","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1085","0","1","0","0","1","11","1","1","11","1085","0","0","27","543","","SALIHU ISMAILA BEJI","08035875328","","","","M","1","Nigerian","13","12","1968","married","","","","angoaliyu76@yahoo.com","","BOSSO","08035875328","","DUTSEN - KURA LONDON STREET MINNA NIGER STATE. ","","","Normal","O","None","","1","0","0","105.112.113.95","2020-01-15 10:47:13","2020-01-15 10:47:48","","","","1","0000-00-00 00:00:00","2019-07-18 14:17:49","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-13 10:42:55","0552","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1086","0","0","0","0","0","0","1","1","11","1086","0","0","0","0","","EZE MODESTER NNEDINSO","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07031348441","","","","","","","","","1","0","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-07-22 15:27:00","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1087","0","0","0","0","0","0","1","9","19","1087","0","0","0","0","","EZE MODESTER NNEDINSO","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07031348441","","","","","","","","","1","0","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-07-22 15:28:34","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1088","0","0","0","0","0","0","1","1","11","1088","0","0","0","0","","EZE MODESTER NNEDINSO","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07031348441","","","","","","","","","1","0","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-07-22 15:30:28","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1089","0","0","0","0","0","0","1","2","15","1089","0","0","0","0","","ABUBAKAR YARIMA BELLO","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07069208341","","","","","","","","","1","0","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-07-22 15:34:19","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1090","0","0","0","0","0","0","1","2","15","1090","0","0","0","0","","ABUBAKAR YARIMA BELLO","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07069208341","","","","","","","","","1","0","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-07-22 15:36:00","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1091","0","0","0","0","0","0","1","2","15","1091","0","0","0","0","","ABUBAKAR YARIMA BELLO","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07069208341","","","","","","","","","1","0","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-07-22 15:42:46","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1092","0","0","0","0","0","0","1","2","15","1092","0","0","0","0","","ABUBAKAR YARIMA BELLO","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07069208341","","","","","","","","","1","0","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-07-22 16:01:31","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1093","0","0","0","0","0","0","1","2","15","1093","0","0","0","0","","ABUBAKAR YARIMA BELLO","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07031348441","","","","","","","","","1","0","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-07-22 16:56:11","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1094","0","0","0","0","0","0","1","2","15","1094","0","0","0","0","","ABUBAKAR YARIMA BELLO","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07069208341","","","","","","","","","1","0","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-07-24 15:03:46","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1095","0","0","0","0","0","0","1","2","15","1095","0","0","0","0","","ABUBAKAR YARIMA BELLO","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07069208341","","","","","","","","","1","0","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-07-24 15:28:49","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1096","0","1","0","0","2","2","1","2","15","1096","0","0","27","550","","ABUBAKAR YARIMA BELLO","07069208341","","","","M","1","Nigerian","27","5","1998","single","","","","angoaliyu76@yahoo.com","","LAPAI","07069208341","","NO 228A BAY CLINIC ROAD TUNGA MINNA","","","Normal","A+","None","","1","1","0","197.210.227.124","2019-12-12 22:42:37","2019-11-18 16:01:04","","","","1","0000-00-00 00:00:00","2019-07-24 15:32:17","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2019-12-03 12:09:58","0571","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1097","0","0","0","0","0","0","1","2","14","1097","0","0","27","546","","MOHAMMED AMINU","07037100940","","","","M","1","Nigerian","28","6","1978","married","","","","angoaliyu76@yahoo.com","","GBAKO","07037100940","","ANGUWA ROKA MAITUNBI MINNA","","","Normal","O","None","","1","0","0","197.210.52.225","2019-08-19 15:24:42","2019-08-19 15:25:25","","","","1","0000-00-00 00:00:00","2019-07-24 15:53:04","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1098","0","1","0","0","4","13","1","1","11","1098","0","0","14","271","","EZE MODESTER NNEDINSO","07031348441","","","","F","2","Nigerian","10","1","1979","married","","","","angoaliyu76@yahoo.com","","NSUKKA","07031348441","","BEHIND INEC OFFICE LAPAI NIGER STATE","","","Normal","A+","None","","1","0","0","105.112.112.20","2020-01-28 16:15:51","2020-01-28 16:16:00","","","","1","0000-00-00 00:00:00","2019-07-24 15:57:17","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2019-12-12 11:36:45","0383","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1099","0","0","0","0","0","0","1","2","15","1099","0","0","27","544","","IBRAHIM MAMA MALLAM","07066893541","","","","F","1","Nigerian","25","5","1968","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","07066893541","","OPPOSITE CONOIL TUNGA MINNA","","","Normal","O","None","","1","1","0","197.210.52.136","2019-08-19 15:26:22","2019-07-28 13:25:54","","","","1","0000-00-00 00:00:00","2019-07-24 15:58:40","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1100","0","1","0","0","7","16","1","7","16","1100","0","0","27","551","","JIBRIL ABDULRAHMAN DOKOCHI","07061688807","","","","M","1","Nigerian","7","4","1988","married","","","","angoaliyu76@yahoo.com","","LAVUN","07061688807","","ALAGBADO KPAKUNGU, BEHIND ASSEMBLY OF GOD CHURCH. ","","","Normal","O","None","","1","0","0","197.210.85.77","2020-02-08 15:32:00","2020-02-08 15:34:37","","","","1","0000-00-00 00:00:00","2019-07-24 16:00:09","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-03 08:45:18","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1101","0","1","0","0","4","12","1","4","12","1101","0","0","27","544","","IDRIS ALIYU","07063330663","","","","M","1","Nigerian","10","7","1989","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","07063330663","","NE. 87 NASSARAWA \"A\" WARD MOSQUE ROAD, MINNA.","","","Normal","B+","None","","1","0","0","105.112.115.177","2020-01-16 11:36:20","2020-01-16 11:36:30","","","","1","0000-00-00 00:00:00","2019-07-24 16:02:03","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0185","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1102","0","0","0","0","0","0","1","2","15","1102","0","0","27","541","","ABUBAKAR UMARU SANDA","08066862717","","","","M","1","Nigerian","21","2","1978","married","","","","angoaliyu76@yahoo.com","","BIDA","08066862717","","BEHIND HOUSE OF ASSEMBLY QUARTERS MINNA","","","Normal","O","None","","1","0","0","197.210.53.127","2019-08-19 15:31:05","2019-08-19 15:32:27","","","","1","0000-00-00 00:00:00","2019-07-24 16:03:56","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1103","0","1","0","0","4","13","1","4","13","1103","0","0","27","542","","ALIYU ABDULLAHI","08036342554","","","","M","1","Nigerian","20","2","1977","married","","","","angoaliyu76@yahoo.com","","BORGU","08036342554","","HOUSE NO 18 IBRAHIM ALIYU ROAD MINNA.","","2019-09-20-172031.jpg","Normal","O","None","","1","0","0","197.210.60.119","2020-01-03 10:37:14","2020-01-03 10:37:50","","","","1","0000-00-00 00:00:00","2019-07-24 16:05:24","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0027","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1104","0","1","0","0","4","12","1","4","12","1104","0","0","27","554","","ABDULLAHI FATIMA","08069274012","","","","F","1","Nigerian","15","3","1989","married","","","","angoaliyu76@yahoo.com","","MASHEGUN","08069274012","","MORRIS AREA MINNA","","","Normal","B+","None","","1","0","0","197.210.45.38","2020-01-03 14:31:36","2020-01-03 14:32:10","","","","1","0000-00-00 00:00:00","2019-07-24 16:06:44","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","0000-00-00 00:00:00","0311","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1105","0","0","0","0","0","0","1","10","20","1105","0","0","27","561","","ABUBAKAR UMAR PAI","08136596501","","","","M","1","Nigerian","15","3","1989","single","","","","angoaliyu76@yahoo.com","","SULEJA","08136596501","","ZI OLD AIRPORT QUARTERS MINNA","","","Normal","B+","None","","1","0","0","197.210.52.136","2019-08-19 15:34:44","2019-08-19 15:35:37","","","","1","0000-00-00 00:00:00","2019-07-26 11:26:33","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1106","0","0","0","0","0","0","1","1","11","1106","0","0","23","483","","JATTO STEVEN ITOPA","07016761497","","","","M","2","Nigerian","24","4","1980","married","","","","angoaliyu76@yahoo.com","","OGORI MAGOGO","07016761497","","D.6 OSHABNE STREET OGORI KOGI STATE","","","Normal","A+","None","","1","0","0","197.210.44.217","2019-09-20 21:28:26","2019-09-20 21:29:15","","","","1","0000-00-00 00:00:00","2019-07-26 11:28:00","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1107","0","0","0","0","0","0","1","1","11","1107","0","0","27","541","","AHMED MUSA IDRIS","08032941302","","","","M","1","Nigerian","11","3","1980","single","","","","angoaliyu76@yahoo.com","","BIDA","08032941302","","J.F 126, ALIYU BABADOKO STREET, WETERN BYPASS MINNA STATE.","","","Normal","AB","None","","1","1","0","105.112.121.124","2019-09-25 13:36:55","2019-08-19 15:37:38","","","","1","0000-00-00 00:00:00","2019-07-26 11:29:25","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1108","0","0","0","0","0","0","1","1","11","1108","0","0","27","561","","IDRIS MOHAMMED","08038155444","","","","M","1","Nigerian","1","1","1977","married","","","","angoaliyu76@yahoo.com","","SULEJA","08038155444","","NO.17 ANGUWAN KUREN KAKA SULEJA NIGER STATE","","","Normal","B+","None","","1","0","0","197.210.52.54","2019-08-19 15:37:49","2019-08-19 15:38:53","","","","1","0000-00-00 00:00:00","2019-07-26 11:42:14","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1109","0","1","0","0","10","21","1","10","21","1109","0","0","27","542","","ABUBAKAR HALIMA","08055928881","","","","F","1","Nigerian","7","4","1996","married","","","","angoaliyu76@yahoo.com","","BORGU","08055928881","","ADAMAWA ROAD DUSTSEN KURA HAUSE.","","","Normal","B+","None","","1","0","0","197.210.65.62","2020-01-03 12:43:53","2020-01-03 12:44:30","","","","1","0000-00-00 00:00:00","2019-07-26 12:05:59","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-15 09:12:02","0533","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1110","0","1","0","0","2","14","1","2","14","1110","0","0","27","539","","MAHMUD D IBRAHIM","07039608556","","","","M","1","Nigerian","20","3","1975","married","","","","angoaliyu76@yahoo.com","","AGAIE","07039608556","","NO D12 EKO - BADDEGI AGAIE NIGER STATE","","","Normal","B+","None","","1","0","0","197.210.65.185","2020-01-02 21:11:51","2020-01-02 21:12:30","","","","1","0000-00-00 00:00:00","2019-07-26 12:11:53","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0110","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1111","0","0","0","0","0","0","1","7","16","1111","0","0","0","0","","GHALI ABUBAKAR","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","09030290092","","","","","","","","","1","0","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-08-02 17:35:11","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1112","0","1","0","0","2","14","1","2","14","1112","0","0","27","544","","VERONICA IGNATIUS","08034530472","","","","F","2","Nigerian","16","7","1977","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08034530472","","NO 11D5 TUNGA LOWCOST TUNGA MINNA","","","Normal","O","None","","1","0","0","105.112.120.117","2020-02-04 09:56:08","2020-02-04 11:29:22","","","","1","0000-00-00 00:00:00","2019-08-02 22:26:05","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2020-01-07 11:07:01","0026","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1113","0","1","0","0","1","11","1","1","11","1113","0","0","27","559","","MOHAMMED GARBA RIJAU","08138212400","","","","M","1","Nigerian","7","3","1968","married","","","","angoaliyu76@yahoo.com","","RIJAU","08138212400","","SABON GARIN RIJAU","","","Normal","O","None","","1","0","0","197.210.60.119","2020-01-03 10:20:47","2020-01-03 10:21:27","","","","1","0000-00-00 00:00:00","2019-08-02 22:28:04","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-29 12:14:50","0635","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1114","0","0","0","0","0","0","1","7","16","1114","0","0","27","559","","GHALI ABUBAKAR","09030290092","","","","M","1","Nigerian","14","1","1994","single","","","","angoaliyu76@yahoo.com","","RIJAU","09030290092","","RIJAU LOCAL GOVERNMENT NIGER STATE  ","","","Normal","O","None","","1","0","0","197.210.53.67","2019-08-19 16:28:16","2019-08-19 16:32:49","","","","1","0000-00-00 00:00:00","2019-08-02 22:29:46","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1115","0","1","0","0","10","21","1","10","21","1115","0","0","27","551","","MOHAMMED SABA AISHATU","07030548199","","","","F","1","Nigerian","2","4","1983","married","","","","angoaliyu76@yahoo.com","","LAVUN","07030548199","","DOKOKO AREA CHANCHAGA  LOCAL GOVERNMENT ","","","Normal","B+","None","","1","0","0","197.210.53.234","2019-08-19 16:32:58","2019-08-19 16:33:41","","","","1","0000-00-00 00:00:00","2019-08-02 22:33:12","0000-00-00 00:00:00","","","","","","","3","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1116","0","1","0","0","10","21","1","10","21","1116","0","0","27","560","","GOJA JOHN GOJA","08065412625","","","","M","2","Nigerian","15","4","1988","married","","","","angoaliyu76@yahoo.com","","SHIRORO","08065412625","","ST\' JOHN CHANCHAGA  MINNA ","","","Normal","O","None","","1","0","0","197.210.64.230","2020-01-03 12:46:05","2020-01-03 12:46:37","","","","1","0000-00-00 00:00:00","2019-08-02 22:34:49","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0211","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1117","0","1","0","0","10","20","1","10","20","1117","0","0","27","551","","USMAN FATIMA LANDE","07060462440","","","","F","1","Nigerian","10","6","1992","married","","","","angoaliyu76@yahoo.com","","LAVUN","07060462440","","TUNGA LOWCOST","","","Normal","A+","None","","1","0","0","105.112.122.21","2020-02-04 11:05:33","2020-02-04 11:16:33","","","","1","0000-00-00 00:00:00","2019-08-02 22:36:08","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0278","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1118","0","1","0","0","1","11","1","1","11","1118","0","0","0","0","","ABDULMALIK SAADIYYA LADIDI","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08069836553","","","","","","","","","1","0","0","105.112.113.203","2020-03-05 09:47:37","2020-03-05 16:45:50","","","","1","0000-00-00 00:00:00","2019-08-02 22:38:03","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2020-02-08 12:18:21","0047","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1119","0","1","0","0","10","21","1","10","21","1119","0","0","27","544","","HABIBA SHEHU LADAN","08034502594","","","","F","1","Nigerian","20","9","1976","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08034502594","","OPPOSITE KURA MARKET MINNA NIGER STATE","","","Normal","B+","None","","1","0","0","197.210.53.122","2020-02-04 11:29:34","2020-02-04 11:41:20","","","","1","0000-00-00 00:00:00","2019-08-02 22:39:37","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","0000-00-00 00:00:00","0313","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1120","0","1","0","0","10","22","1","10","22","1120","0","0","27","544","","YAHAYA SALMA AHMED","08037871039","","","","F","1","Nigerian","17","8","1974","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08037871039","","N.E 222 ABAYI CLOSE MINNA ","","","Normal","O","None","","1","0","0","197.210.70.15","2020-02-04 17:38:35","2020-02-04 17:40:14","","","","1","0000-00-00 00:00:00","2019-08-02 22:41:35","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0183","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1121","0","0","0","0","0","0","1","4","13","1121","0","0","27","544","","MOHAMMED MUSA","08025150497","","","","M","1","Nigerian","14","8","1968","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08025150497","","NE57 MOSQUE ROAD MINNA","","","Normal","O","None","","1","0","0","197.210.53.127","2019-08-19 16:40:03","2019-08-19 16:40:42","","","","1","0000-00-00 00:00:00","2019-08-02 22:43:09","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1122","0","0","0","0","0","0","1","2","2","1122","0","0","27","557","","YAHAYA USMAN","08233487775","","","","M","1","Nigerian","3","3","1995","married","","","","angoaliyu76@yahoo.com","","PAIKO","08233487775","","DUTSEN KURA GWARI MINNA NIGER STATE.","","","Normal","O","None","","1","0","0","197.210.52.217","2019-08-19 16:41:05","2019-08-19 16:42:55","","","","1","0000-00-00 00:00:00","2019-08-02 22:44:34","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1123","0","1","0","0","4","13","1","4","13","1123","0","0","27","541","","ALHASSAN AHMED NDAGI","09056090016","","","","M","1","Nigerian","14","11","1982","married","","","","angoaliyu76@yahoo.com","","BIDA","09056090016","","NO.128A PAIKO ROAD TUNDUN WADA TUNGA MINNA.","","","Normal","O","None","","1","0","0","197.210.45.38","2020-01-03 14:17:13","2020-01-03 14:17:35","","","","1","0000-00-00 00:00:00","2019-08-02 22:46:22","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-01 10:36:21","0457","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1124","0","0","0","0","0","0","1","4","12","1124","0","0","27","550","","AUDU SULEIMAN","07065067251","","","","M","1","Nigerian","1","7","1974","married","","","","angoaliyu76@yahoo.com","","LAPAI","07065067251","","ALH. SULE RESIDENCE, BEHIND NUPE MOTORS.","","","Normal","AB","None","","1","0","0","197.210.52.54","2019-08-19 16:44:45","2019-08-19 16:45:26","","","","1","0000-00-00 00:00:00","2019-08-02 22:48:01","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1125","0","0","0","0","0","0","1","7","16","1125","0","0","27","560","","MOHAMMED IBRAHIM KUTA","08056805489","","","","M","1","Nigerian","2","2","1992","single","","","","angoaliyu76@yahoo.com","","SHIRORO","08056805489","","ANGUWAN ZOGALE KUTA","","","Normal","O","None","","1","0","0","197.210.53.64","2019-08-19 16:45:34","2019-08-19 16:46:29","","","","1","0000-00-00 00:00:00","2019-08-02 22:51:02","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1126","0","0","0","0","0","0","1","4","12","1126","0","0","27","560","","MOHAMMED SHEHU SARKIN ZANGO","08050511555","","","","M","1","Nigerian","7","4","1968","married","","","","angoaliyu76@yahoo.com","","SHIRORO","08050511555","","S. ZANGO\'. UNG\'S RES LIMANCHI KUTA NIGER STATE.","","","Normal","A+","None","","1","0","0","197.210.53.127","2019-08-19 16:46:37","2019-08-19 16:47:27","","","","1","0000-00-00 00:00:00","2019-08-02 22:52:34","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1127","0","0","0","0","0","0","1","4","12","1127","0","0","27","541","","MOHAMMED ABDULLAHI","07061952201","","","","M","1","Nigerian","2","2","1990","married","","","","angoaliyu76@yahoo.com","","BIDA","07061952201","","EFU LIMAN NASSARA EMI KODONDO","","","Normal","O","None","","1","0","0","197.210.53.64","2019-08-19 16:47:36","2019-08-19 16:48:15","","","","1","0000-00-00 00:00:00","2019-08-02 22:54:21","0000-00-00 00:00:00","","","","","","","3","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1128","0","0","0","0","0","0","1","4","12","1128","0","0","27","544","","DONALD DAVID","07032457515","","","","M","2","Nigerian","26","9","1990","single","","","","angoaliyu76@yahoo.com","","CHANCHAGA","07032457515","","DESAN KANNA GWARI MINNA OPP.CEWA CHURCH DUSEN GWARI MINNA.","","","Normal","O","None","","1","0","0","105.112.112.153","2019-12-16 11:02:19","2019-12-16 11:02:35","","","","1","0000-00-00 00:00:00","2019-08-02 22:57:24","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1129","0","1","0","0","10","21","1","10","21","1129","0","0","13","121","","OBABUEKI RUTH KEMISOLA","08034204298","","","","F","2","Nigerian","17","9","1984","married","","","","angoaliyu76@yahoo.com","","ADO","08034204298","","MTP 10B PLOT, PLOT 26, MAITUNBI HOUSING  SCHME","","","Normal","O","None","","1","0","0","197.210.60.119","2020-01-03 12:14:07","2020-01-03 12:14:57","","","","1","0000-00-00 00:00:00","2019-08-02 23:02:02","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-03 08:53:42","0504","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1130","0","0","0","0","0","0","1","10","20","1130","0","0","27","541","","HAMZA FATIMA MUHAMMAD","08135133593","","","","F","1","Nigerian","23","1","1996","married","","","","angoaliyu76@yahoo.com","","BIDA","08135133593","","BEHIND CAIS KPAKUNGU MINNA NIGER STATE","","","Normal","O","None","","1","0","0","197.210.53.127","2019-08-19 16:51:49","2019-08-19 16:53:19","","","","1","0000-00-00 00:00:00","2019-08-02 23:04:14","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1131","0","1","0","0","1","11","1","1","11","1131","0","0","27","539","","ABUBAKAR ADAMU","08182289647","","","","M","1","Nigerian","6","7","1984","married","","","","angoaliyu76@yahoo.com","","AGAIE","08182289647","","BEHIND WHITE HEART KPAKUNGU ALONG BIDA ROAD MINNA NIGER STATE.","","","Normal","A+","None","","1","0","0","105.112.116.72","2020-01-24 12:21:47","2020-01-24 12:25:00","","","","1","0000-00-00 00:00:00","2019-08-02 23:05:55","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-04 09:59:42","0478","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1132","0","1","0","0","10","21","1","10","21","1132","0","0","27","541","","USMAN AISHATU ALFA","08035895907","","","","F","1","Nigerian","30","10","1984","married","","","","angoaliyu76@yahoo.com","","BIDA","08035895907","","NO. 15 OKADA ROAD MINNA","","","Normal","A+","None","","1","0","0","197.210.64.171","2020-01-03 12:32:40","2020-01-03 12:33:33","","","","1","0000-00-00 00:00:00","2019-08-03 09:07:59","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-04 09:57:11","0524","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1133","0","1","0","0","7","16","1","7","16","1133","0","0","27","560","","ADAMU SHINFIDA GARBA","08038384748","","","","M","1","Nigerian","6","5","1982","married","","","","angoaliyu76@yahoo.com","","SHIRORO","08038384748","","BEHIND DANA PAAMA CUETICR LTD. MINNA","","","Normal","O","None","","1","0","0","105.112.117.154","2020-02-11 16:00:00","2020-02-11 16:01:27","","","","1","0000-00-00 00:00:00","2019-08-08 14:48:31","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0343","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1134","0","1","0","0","10","20","1","10","20","1134","0","0","27","544","","KAILANI SARATU","07039631619","","","","F","1","Nigerian","20","5","1984","single","","","","angoaliyu76@yahoo.com","","","07039631619","","MANDELA ROAD AFTER HIGH POINT INTERNATIONAL  SCHOOL MINNA","","","Normal","O","None","","1","0","0","105.112.120.240","2020-01-29 12:02:30","2020-01-29 12:03:53","","","","1","0000-00-00 00:00:00","2019-08-08 14:49:49","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0184","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1135","0","1","0","0","2","14","1","2","14","1135","0","0","27","544","","AISHA ABDULLAHI PAIKO","08036333627","","","","F","1","Nigerian","23","5","1983","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08036333627","","ROAD 1 HOUSE NO 1 BOSSO ESTATE MINNA","","","Normal","O","None","","1","0","0","105.112.120.240","2020-01-29 12:04:22","2020-01-29 12:04:51","","","","1","0000-00-00 00:00:00","2019-08-08 14:51:03","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2020-01-27 11:39:29","0038","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1136","0","1","0","0","7","16","1","2","14","1136","0","0","27","548","","MOHAMMED ALIYU","07034583071","","","","F","1","Nigerian","1","10","1992","married","","","","angoaliyu76@yahoo.com","","KATCHA","07034583071","","EMI ALH. MAMUD KATCHA TWON NIGER STATE","","","Normal","A+","None","","1","1","0","105.112.114.32","2020-01-06 12:25:26","2019-08-19 16:18:02","","","","1","0000-00-00 00:00:00","2019-08-08 14:52:21","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0024","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1137","0","1","0","0","2","15","1","2","15","1137","0","0","27","541","","BABA UMARU","08039114976","","","","M","1","Nigerian","10","2","1976","married","","","","angoaliyu76@yahoo.com","","BIDA","08039114976","","EMI ALHAJI BABAJABA BANWUYA ROAD BIDA","","","Normal","B+","None","","1","0","0","197.210.60.119","2020-01-03 11:04:31","2020-01-03 11:05:39","","","","1","0000-00-00 00:00:00","2019-08-08 14:53:48","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-24 10:55:21","0612","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1138","0","1","0","0","2","2","1","2","2","1138","0","0","27","563","","MOHAMMED NUHU","07063127015","","","","M","1","Nigerian","24","1","1990","single","","","","angoaliyu76@yahoo.com","","WUSHISHI","07063127015","","MUAZU QUARTERS WUSHISHI MINNA ","","","Normal","A+","None","","1","0","0","197.210.64.196","2020-01-02 21:45:11","2020-01-02 21:46:03","","","","1","0000-00-00 00:00:00","2019-08-08 14:58:17","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0359","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1139","0","1","0","0","2","2","1","2","2","1139","0","0","27","544","","ADAMU MOHAMMED ALIYU","08061291976","","","","M","1","Nigerian","30","12","1995","single","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08061291976","","LONDON STREET BEHIND MAWO SCHOOL ","","","Normal","A+","None","","1","0","0","197.210.53.234","2019-08-19 16:21:16","2019-08-19 16:22:29","","","","1","0000-00-00 00:00:00","2019-08-08 15:00:54","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1140","0","1","0","0","2","15","1","2","15","1140","0","0","27","563","","SULEIMAN ABDULLAHI","07039417980","","","","M","1","Nigerian","4","1","1969","married","","","","angoaliyu76@yahoo.com","","WUSHISHI","07039417980","","S.W 505 KETEREN GWARI ROAD MINNA NIGER STATE.","","","Normal","B+","None","","1","0","0","197.210.227.98","2020-02-07 17:36:20","2020-02-07 17:37:28","","","","1","0000-00-00 00:00:00","2019-08-08 15:03:59","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-12-10 16:18:06","0675","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1141","0","1","0","0","2","14","1","2","14","1141","0","0","27","556","","MATHEW DANIEL","08136007199","","","","M","2","Nigerian","16","4","1995","single","","","","angoaliyu76@yahoo.com","","MONYA","08136007199","","DAVID MARK ROAD 0PP MOBILE BASE MINNA","","","Normal","O","None","","1","0","0","105.112.113.203","2020-03-05 09:45:19","2020-03-05 09:47:16","","","","1","0000-00-00 00:00:00","2019-08-08 15:30:46","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0048","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1142","0","0","0","0","0","0","1","10","21","1142","0","0","0","0","","OGUNYOMI VICTORIA OLANIKE","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08109131348","","","","","","","","","1","0","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-08-27 15:22:59","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1143","0","0","0","0","0","0","1","10","21","1143","0","0","0","0","","OGUNYOMI VICTORIA OLANIKE","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08109131348","","","","","","","","","1","0","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-08-27 15:24:35","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1144","0","0","0","0","0","0","1","10","21","1144","0","0","27","556","","GABRIEL TABITHA","07038521282","","","","F","2","Nigerian","10","5","1986","married","","","","angoaliyu76@yahoo.com","","MUNYA","07038521282","","MAITUNBI SABON UNGUWA MINNA NIGER STATE","","","Normal","O","None","","1","0","0","105.112.121.36","2019-09-11 15:33:11","2019-09-11 15:36:13","","","","0","0000-00-00 00:00:00","2019-08-28 00:05:05","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1145","0","0","0","0","0","0","1","10","21","1145","0","0","27","556","","BARDE SARATU","08138217702","","","","F","1","Nigerian","27","8","1991","married","","","","angoaliyu76@yahoo.com","","MUNYA","08138217702","","POLICE DIVISION LINE GWADA.","","","Normal","O","None","","1","0","0","105.112.121.36","2019-09-11 15:36:26","2019-09-11 15:37:10","","","","0","0000-00-00 00:00:00","2019-08-28 00:06:51","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1146","0","0","0","0","0","0","1","2","15","1146","0","0","27","541","","MUSA BABA ABUBAKAR","08036282684","","","","M","1","Nigerian","8","8","1977","married","","","","angoaliyu76@yahoo.com","","BIDA","08036282684","","EMITSU BINDIGA NUPE","","","Normal","B+","None","","1","0","0","105.112.121.36","2019-09-11 15:37:27","2019-09-11 15:38:59","","","","0","0000-00-00 00:00:00","2019-08-28 00:08:59","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1147","0","1","0","0","1","11","1","1","11","1147","0","0","27","543","","BALA AHMED MAIKUNKELE","07083164883","","","","M","2","Nigerian","9","10","1969","married","","","","angoaliyu76@yahoo.com","","BOSSO","07083164883","","C/O VILLAGE HEATS OF MAIKUNKELE WATER BOARD ROAD, MAIKUNKELE MINNA.","","","Normal","O","None","","1","0","0","197.210.60.119","2020-01-03 10:10:26","2020-01-03 10:11:07","","","","0","0000-00-00 00:00:00","2019-08-28 00:11:19","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-15 09:27:31","0620","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1148","0","1","0","0","10","21","1","10","21","1148","0","0","24","617","","OGUNYOMI VICTORIA OLANIKE","07084434086","","","","F","2","Nigerian","28","9","1985","married","","","","angoaliyu76@yahoo.com","","IFELODUN","07084434086","","IFEOLUKOTUN (NO 26) CLOSE UNITY ROAD ILORIN KWARA STATE.","","","Normal","O","None","","1","0","0","105.112.113.95","2020-01-15 10:52:34","2020-01-15 10:52:49","","","","0","0000-00-00 00:00:00","2019-08-28 00:14:25","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-05 08:33:45","0459","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1149","0","0","0","0","0","0","1","1","11","1149","0","0","27","547","","IBRAHIM MURTALA","08034642836","","","","M","1","Nigerian","16","6","1972","married","","","","angoaliyu76@yahoo.com","","GURARA","08034642836","","FIADUPE HOUSE NO 84 MINNA","","","Normal","O","None","","1","0","0","105.112.121.36","2019-09-11 15:45:23","2019-09-11 15:46:43","","","","0","0000-00-00 00:00:00","2019-08-28 00:16:13","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1150","0","0","0","0","0","0","1","2","15","1150","0","0","0","0","","ZUBAIRU DANJUMA","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08168077717","","","","","","","","","1","0","0","105.112.122.97","2019-09-23 13:31:32","2019-09-23 13:32:06","","","","0","0000-00-00 00:00:00","2019-09-04 11:40:44","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1151","0","0","0","0","0","0","1","2","15","1151","0","0","27","541","","ZUBAIRU DANJUMA","08168077717","","","","M","1","Nigerian","13","5","1968","married","","","","angoaliyu76@yahoo.com","","BIDA","08168077717","","UNGUWA SARKI ZUNGERU OPPOSITE POST OFFICE (ZUNGERU)","","","Normal","B+","None","","1","0","0","105.112.121.36","2019-09-11 15:47:39","2019-09-11 15:48:54","","","","0","0000-00-00 00:00:00","2019-09-07 09:45:00","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1152","0","1","0","0","10","21","1","10","21","1152","0","0","27","544","","ALIYU MAMUDA","08063328328","","","","M","1","Nigerian","15","4","1980","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08063328328","","SKP 168 NEW MARKET","","","Normal","B+","None","","1","0","0","105.112.117.154","2020-02-11 15:57:49","2020-02-11 15:59:36","","","","0","0000-00-00 00:00:00","2019-09-07 09:46:51","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0387","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1153","0","1","0","0","4","4","1","4","4","1153","0","0","27","551","","ABUBAKAR MOHAMMED","08068586426","","","","M","1","Nigerian","2","10","1995","married","","","","angoaliyu76@yahoo.com","","LAVUN","08068586426","","GBAKUNGU MINNA OPPOSITE WHITE HOUSE ALONG BIDA ROAD","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 11:40:03","2020-01-16 11:40:16","","","","0","0000-00-00 00:00:00","2019-09-07 09:48:30","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-05 07:43:21","0507","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1154","0","0","0","0","0","0","1","1","11","1154","0","0","0","0","","ABDULHAMID MOHAMMED","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08166126822","","","","","","","","","1","1","0","105.112.113.139","2019-09-10 13:33:58","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-09-07 09:48:47","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1155","0","1","0","0","2","2","1","2","2","1155","0","0","27","557","","IBRAHIM ABBAS","08033906190","","","","M","1","Nigerian","19","2","1992","married","","","","angoaliyu76@yahoo.com","","PAIKORO","08033906190","","IBADAT PETROLEUM COMPANY PAIKO  ALONG LAPAI ROAD ","","","Normal","A+","None","","1","1","0","197.210.52.32","2019-12-17 17:00:39","2019-09-11 15:54:23","","","","1","0000-00-00 00:00:00","2019-09-07 09:49:29","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-12-17 15:46:43","0007","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1156","0","1","0","0","1","11","1","1","11","1156","0","0","27","557","","ABDULHAMID MOHAMMED","08166126822","","","","M","1","Nigerian","2","2","1982","married","","","","angoaliyu76@yahoo.com","","PAIKORO","08166126822","","HOUSE NO 45 MAITUNBI CHALENGE OPP. PRY SCH ","","","Normal","O","None","","1","0","0","105.112.113.95","2020-01-15 10:58:23","2020-01-15 11:03:14","","","","0","0000-00-00 00:00:00","2019-09-07 09:57:22","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0377","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1157","0","1","0","0","10","20","1","10","20","1157","0","0","27","560","","BALA HANNATU","08034618262","","","","F","2","Nigerian","8","4","1996","single","","","","angoaliyu76@yahoo.com","","SHIRORO","08034618262","","BEHIND MAITUNBI PRIMARY SCHOOL MINNA","","","Normal","O","None","","1","0","0","197.210.60.119","2020-01-03 12:09:04","2020-01-03 12:09:39","","","","0","0000-00-00 00:00:00","2019-09-07 09:58:33","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0334","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1158","0","0","0","0","0","0","1","2","14","1158","0","0","27","546","","USMAN UMAR","08067712719","","","","M","1","Nigerian","5","7","1983","married","","","","angoaliyu76@yahoo.com","","GBAKO","08067712719","","S.W 123 GRA BIDA","","","Normal","O","None","","1","0","0","105.112.121.36","2019-09-11 15:58:31","2019-09-11 16:09:56","","","","0","0000-00-00 00:00:00","2019-09-07 09:59:38","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1159","0","0","0","0","0","0","1","4","12","1159","0","0","27","550","","ABUBAKAR MOHAMMED SONFADA","07055826882","","","","M","1","Nigerian","6","2","1998","married","","","","angoaliyu76@yahoo.com","","LAPAI","07055826882","","SONFADA VIA LAPAI","","","Normal","B+","None","","1","0","0","105.112.121.36","2019-09-11 16:10:07","2019-09-11 16:11:36","","","","0","0000-00-00 00:00:00","2019-09-07 10:01:04","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1160","0","1","0","0","10","20","1","10","20","1160","0","0","27","558","","SUNDAY SARAH","08104128129","","","","F","2","Nigerian","19","12","1992","single","","","","angoaliyu76@yahoo.com","","RAFI","08104128129","","OLD GARAGE KAGARA","","","Normal","A+","None","","1","0","0","197.210.85.77","2020-02-08 15:27:39","2020-02-08 15:29:02","","","","1","0000-00-00 00:00:00","2019-09-07 10:03:07","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-10-30 15:11:39","0386","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1161","0","1","0","0","10","20","1","10","20","1161","0","0","27","539","","SANI KHADIJAT","08065761389","","","","F","1","Nigerian","24","3","2000","single","","","","angoaliyu76@yahoo.com","","AGAIE","08065761389","","HOUSE NO 20B DUTSEN KURA GWARI MINNA","","","Normal","B+","None","","1","0","0","197.210.45.38","2020-01-03 13:42:04","2020-01-03 13:42:57","","","","0","0000-00-00 00:00:00","2019-09-07 10:04:07","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0165","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1162","0","1","0","0","1","11","1","1","11","1162","0","0","27","559","","ADAMU MUSA","08065518006","","","","M","1","Nigerian","1","10","1969","married","","","","angoaliyu76@yahoo.com","","RIJAU","08065518006","","RIJAU","","","Normal","O","None","","1","0","0","197.210.60.119","2020-01-03 10:19:59","2020-01-03 10:20:33","","","","0","0000-00-00 00:00:00","2019-09-07 10:05:14","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-11-16 12:32:57","0556","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1163","0","0","0","0","0","0","1","10","21","1163","0","0","7","119","","PAUL PETER","07039198784","","","","M","2","Nigerian","30","12","1993","single","","","","angoaliyu76@yahoo.com","","AGATU","07039198784","","OCHALONOYA AGATU BENUE STATE","","","Normal","A+","None","","1","0","0","105.112.121.36","2019-09-11 16:21:27","2019-09-11 16:22:36","","","","0","0000-00-00 00:00:00","2019-09-07 10:06:14","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1164","0","1","0","0","10","21","1","10","21","1164","0","0","27","549","","MAHMUD SALE MAIKUDI","08033565156","","","","M","1","Nigerian","22","12","1991","married","","","","angoaliyu76@yahoo.com","","KONTAGORA","08033565156","","SABON GARI KONTAGORA","","","Normal","O","None","","1","0","0","197.210.60.119","2020-01-03 12:05:34","2020-01-03 12:06:03","","","","0","0000-00-00 00:00:00","2019-09-07 10:07:20","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","0000-00-00 00:00:00","0314","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1165","0","1","0","0","10","21","1","1","10","1165","0","0","27","549","","FARUK ALIYU","08130477451","","","","M","1","Nigerian","23","8","1992","married","","","","angoaliyu76@yahoo.com","","KONTAGORA","08130477451","","UNGUWAN TUNGAN WAWA UTAGU KONTAGORA","","","Normal","A+","None","","1","0","0","105.112.115.177","2020-01-16 14:22:53","2020-01-16 14:23:02","","","","0","0000-00-00 00:00:00","2019-09-07 10:08:26","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","3","2019-10-31 16:27:41","0661","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1166","0","1","0","0","1","11","1","1","11","1166","0","0","27","541","","ALHAJI DANLAMI","07032747722","","","","M","1","Nigerian","15","2","1986","married","","","","angoaliyu76@yahoo.com","","BIDA","07032747722","","5 MADINAT STREET DUTSEN KURA GWARI MINNA","","","Normal","O","None","","1","0","0","105.112.114.140","2020-01-16 09:50:03","2020-01-16 09:50:18","","","","0","0000-00-00 00:00:00","2019-09-07 10:09:29","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0327","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1167","0","1","0","0","10","21","1","10","21","1167","0","0","27","550","","OGIDO NURATU OZIOMA","07034651273","","","","F","1","Nigerian","3","7","1981","married","","","","angoaliyu76@yahoo.com","","LEMAFU","07034651273","","CUSTOM BARRACK TUNGA","","","Normal","O","None","","1","0","0","197.210.65.186","2020-01-02 22:57:18","2020-01-02 22:57:51","","","","0","0000-00-00 00:00:00","2019-09-07 10:11:52","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0144","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1168","0","1","0","0","10","20","1","10","20","1168","0","0","35","739","","JIBRIIL MUHAMMAD","08066353448","","","","M","1","Nigerian","1","8","1988","married","","","","angoaliyu76@yahoo.com","","TAKUM","08066353448","","BESIDES ALUMMA SEC. SCHOOL ABUJA","","","Normal","O","None","","1","0","0","197.210.45.38","2020-01-03 14:52:03","2020-01-03 14:52:36","","","","0","0000-00-00 00:00:00","2019-09-07 10:12:59","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0288","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1169","0","1","0","0","10","20","1","10","20","1169","0","0","27","548","","UMAR MOHAMMED ABUBAKAR","07067006593","","","","M","1","Nigerian","4","11","1991","married","","","","angoaliyu76@yahoo.com","","KATCHA","07067006593","","EMI SHESHI KATCHA","","","Normal","A+","None","","1","1","0","105.112.113.95","2020-01-15 13:06:52","2020-01-03 12:08:10","","","","0","0000-00-00 00:00:00","2019-09-08 14:30:18","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0436","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1170","0","1","0","0","10","21","1","2","15","1170","0","0","27","544","","USMAN MAHMUD","09034254040","","","","M","1","Nigerian","1","11","1980","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","09034254040","","SARKI USMAN COMPOUND TUDUN  FULANI BOSSO","","","Normal","O","None","","1","0","0","105.112.115.177","2020-01-16 14:13:46","2020-01-16 14:13:56","","","","0","0000-00-00 00:00:00","2019-09-08 14:32:11","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0494","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1171","0","0","0","0","0","0","1","10","21","1171","0","0","27","544","","ABRAHAM PETER","08066844678","","","","M","2","Nigerian","6","7","1986","single","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08066844678","","MAITUMBI ANGUWAN KADARA","","","Normal","O","None","","1","0","0","105.112.113.16","2019-12-03 12:37:07","2019-12-03 13:42:44","","","","1","0000-00-00 00:00:00","2019-09-08 14:33:16","0000-00-00 00:00:00","","","","","","","1","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1172","0","1","0","0","10","20","1","10","20","1172","0","0","27","544","","SAIDU AISHETU","08037018344","","","","F","1","Nigerian","17","3","1980","married","","","","angoaliyu76@yahoo.com","","CHANCHAGA","08037018344","","DUTSEN KURAN GWARI","","","Normal","O","None","","1","0","0","197.210.65.223","2020-01-02 22:48:06","2020-01-02 22:48:39","","","","0","0000-00-00 00:00:00","2019-09-09 11:05:53","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0065","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1173","0","1","0","0","9","18","1","9","18","1173","0","0","27","541","","MOHAMMED DAGACI HASSAN","08034054348","","","","M","1","Nigerian","1","1","1991","married","","","","angoaliyu76@yahoo.com","","BIDA","08034054348","","FADIKPE OPPOSITE MYPA SCHOOLS MINNA","","","Normal","O","None","","1","0","0","105.112.116.72","2020-01-24 13:01:32","2020-01-24 13:02:31","","","","0","0000-00-00 00:00:00","2019-09-09 15:07:41","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0443","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1174","0","1","0","0","7","5","1","7","5","1174","0","0","24","502","","SARATU MUSTAPHA","08163277280","","","","F","1","Nigerian","16","7","1997","married","","","","angoaliyu76@yahoo.com","","OFFA","08163277280","","NO 115 AREA 2 LONDON STREET DUTSEN KURA MINNA","","","Normal","O","None","","1","0","0","105.112.116.243","2020-03-04 11:46:33","2020-03-04 11:49:27","","","","1","0000-00-00 00:00:00","2019-09-09 15:18:54","0000-00-00 00:00:00","","","","","","","1","","","1","                                
\n                                                                 
\n                                ","1","0000-00-00 00:00:00","0033","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1175","0","0","0","0","0","0","1","10","22","1175","0","0","0","0","","ABUBAKAR MAKUN AISHA","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07036411644","","","","","","","","","1","1","0","105.112.112.240","2019-10-10 12:11:42","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-10-09 20:48:48","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1176","0","1","0","0","4","12","1","4","12","1176","0","0","0","0","","DANJUMA NAFISAT","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","09061605486","","","","","","","","","1","0","0","197.210.60.119","2020-01-03 10:47:25","2020-01-03 10:47:53","","","","0","0000-00-00 00:00:00","2019-10-09 20:50:26","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-29 17:39:19","0645","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1177","0","1","0","0","4","4","1","2","2","1177","0","0","0","0","","MUSA ABDULLAHI BAGUDU","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08130288665","","","","","","","","","1","0","0","105.112.112.20","2020-01-28 16:14:30","2020-01-28 16:14:40","","","","0","0000-00-00 00:00:00","2019-10-09 20:52:42","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2019-11-22 10:08:42","0562","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1178","0","1","0","0","4","4","1","4","4","1178","0","0","0","0","","HUSSAINI YUNUSA","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07063282490","","","","","","","","","1","0","0","105.112.115.194","2020-01-29 08:44:36","2020-01-29 08:45:29","","","","0","0000-00-00 00:00:00","2019-10-09 20:55:05","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-03 09:14:51","0563","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1179","0","1","0","0","1","1","1","1","1","1179","0","0","0","0","","DADA FATIMA TANKO","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08169554931","","","","","","","","","1","0","0","105.112.115.177","2020-01-16 11:02:12","2020-01-16 11:02:54","","","","0","0000-00-00 00:00:00","2019-10-09 20:56:26","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0437","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1180","0","1","0","0","10","21","1","10","21","1180","0","0","0","0","","RABI ADAMU","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07036064805","","","","","","","","","1","0","0","197.210.45.38","2020-01-03 14:59:49","2020-01-03 15:00:19","","","","0","0000-00-00 00:00:00","2019-10-09 20:57:46","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","0000-00-00 00:00:00","0317","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1181","0","0","0","0","0","0","1","7","5","1181","0","0","0","0","","SULEIMAN HINDATU IDRIS","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","09032466999","","","","","","","","","1","0","0","105.112.120.179","2019-11-15 12:42:45","2019-11-15 12:42:58","","","","0","0000-00-00 00:00:00","2019-10-09 20:59:07","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1182","0","1","0","0","10","22","1","10","22","1182","0","0","0","0","","MUSTAPHA ABUBAKAR TURAKI","","","","2019-11-22-183332MY SCAN DOUC.pdf.pdf","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08034641827","","","","2019-11-22-175832.jpg","","","","","1","0","0","197.210.64.123","2020-01-03 12:38:30","2020-01-03 12:38:56","","","","1","0000-00-00 00:00:00","2019-10-09 21:00:44","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-22 15:22:47","0608","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1183","0","0","0","0","0","0","1","10","20","1183","0","0","0","0","","GANA SULEIMAN MUHAMMED","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08160059344","","","","","","","","","1","1","0","105.112.114.104","2019-10-10 14:21:17","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-10-09 21:02:30","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1184","0","0","0","0","0","0","1","2","14","1184","0","0","0","0","","YAHAYA ALIYU ABDULLAHI","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08066545959","","","","","","","","","1","0","0","41.190.14.60","2020-01-08 11:55:16","2020-01-08 11:56:42","","","","0","0000-00-00 00:00:00","2019-10-09 21:04:14","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1185","0","1","0","0","10","21","1","10","21","1185","0","0","0","0","","ZAINAB ADAMU LIMAN","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08094417300","","","","","","","","","1","0","0","197.210.70.195","2020-02-15 12:15:39","2020-02-15 12:18:38","","","","0","0000-00-00 00:00:00","2019-10-09 21:05:26","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                                                 
\n                                ","3","2020-02-15 12:16:34","0027","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1186","0","1","0","0","10","22","1","10","22","1186","0","0","0","0","","HADIZA ALI MUSA","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08038604809","","","","","","","","","1","0","0","197.210.60.119","2020-01-03 12:08:22","2020-01-03 12:08:52","","","","0","0000-00-00 00:00:00","2019-10-09 21:06:52","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-01 10:43:35","0511","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1187","0","1","0","0","1","10","1","1","10","1187","0","0","0","0","","MOHAMMED ZAINAB","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08035293655","","","","","","","","","1","0","0","105.112.113.95","2020-01-15 12:30:03","2020-01-15 12:32:54","","","","1","0000-00-00 00:00:00","2019-10-09 21:08:22","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","0000-00-00 00:00:00","0329","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1188","0","1","0","0","1","11","1","1","11","1188","0","0","0","0","","JAYE DANJUMA","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07037944637","","","","","","","","","1","1","0","105.112.122.100","2020-01-09 14:12:48","2020-01-07 09:58:29","","","","0","0000-00-00 00:00:00","2019-10-09 21:09:54","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-10-31 11:59:49","0631","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1189","0","1","0","0","4","13","1","4","13","1189","0","0","0","0","","ISMAILA SALAMATU OMEYI","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08060728333","","","","","","","","","1","0","0","197.210.60.119","2020-01-03 10:28:44","2020-01-03 10:29:17","","","","1","0000-00-00 00:00:00","2019-10-09 21:11:27","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-01 14:53:32","0522","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1190","0","1","0","0","4","12","1","4","12","1190","0","0","0","0","","YAHAYA BABA","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08060970788","","","","","","","","","1","0","0","105.112.112.20","2020-01-28 16:17:58","2020-01-28 16:18:19","","","","1","0000-00-00 00:00:00","2019-10-09 21:12:42","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-10-30 04:09:17","0476","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1191","0","1","0","0","10","20","1","4","4","1191","0","0","0","0","","ABDULLAHI WALID","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08034532844","","","","","","","","","1","0","0","105.112.115.177","2020-01-16 14:08:23","2020-01-16 14:08:31","","","","1","0000-00-00 00:00:00","2019-10-09 21:14:43","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                                                 
\n                                ","3","2019-12-12 11:50:33","0371","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1192","0","0","0","0","0","0","1","2","14","1192","0","0","0","0","","AMINU MOHAMMED ADAMU","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08052538673","","","","","","","","","1","1","0","105.112.114.104","2019-10-10 14:45:26","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-10-09 21:16:21","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1193","0","0","0","0","0","0","1","2","2","1193","0","0","0","0","","BELLO ABUBAKAR SADIQ","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07030304744","","","","","","","","","1","1","0","105.112.114.104","2019-10-10 14:49:30","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-10-09 21:17:36","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1194","0","1","0","0","9","18","1","9","18","1194","0","0","0","0","","OYERAMIJI KIKELOMO","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07063939965","","","","","","","","","1","0","0","197.210.45.38","2020-01-03 14:01:00","2020-01-03 14:01:28","","","","0","0000-00-00 00:00:00","2019-10-09 21:19:11","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-01 15:01:08","0477","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1195","0","1","0","0","10","22","1","10","22","1195","0","0","0","0","","YUSUF DANJUMA BAIRE","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08036947407","","","","","","","","","1","0","0","105.112.115.177","2020-01-16 14:24:58","2020-01-16 14:25:36","","","","0","0000-00-00 00:00:00","2019-10-09 21:20:57","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-25 16:14:36","0615","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1196","0","1","0","0","7","16","1","7","16","1196","0","0","0","0","","MOHAMMED LAYUSA","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08136338890","","","","","","","","","1","0","0","105.112.120.184","2020-02-10 11:58:44","2020-02-10 11:59:04","","","","0","0000-00-00 00:00:00","2019-10-09 21:23:31","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-12-28 12:41:31","0013","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1197","0","1","0","0","10","21","1","10","21","1197","0","0","0","0","","MOHAMMED SALAMAT","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07030638480","","","","","","","","","1","0","0","197.210.64.35","2020-01-02 23:27:59","2020-01-02 23:28:28","","","","0","0000-00-00 00:00:00","2019-10-09 21:24:59","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","2","0000-00-00 00:00:00","0310","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1198","0","1","0","0","10","22","1","2","15","1198","0","0","0","0","","USMAN YAKUBU SHATTA","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08091356937","","","","","","","","","1","0","0","197.210.8.16","2019-11-18 17:18:42","2019-11-18 18:25:29","","","","0","0000-00-00 00:00:00","2019-10-09 21:26:21","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-15 08:58:41","0572","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1199","0","0","0","0","0","0","1","1","10","1199","0","0","0","0","","ABDULLAHI SALIHU","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07055829955","","","","","","","","","1","1","0","105.112.114.104","2019-10-10 15:11:15","2019-10-10 13:40:09","","","","0","0000-00-00 00:00:00","2019-10-09 21:27:34","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1200","0","1","0","0","4","13","1","1","10","1200","0","0","0","0","","MADAKI MALIK BOSSO","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08165800800","","","","","","","","","1","0","0","197.210.65.227","2020-02-26 10:38:05","2020-02-26 15:24:21","","","","0","0000-00-00 00:00:00","2019-10-25 21:18:55","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                
\n                                                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                                                 
\n                                                                 
\n                                ","3","2020-02-26 10:39:34","0050","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1201","0","1","0","0","7","5","1","7","5","1201","0","0","0","0","","SAIDU HAYATU","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08036675737","","","","","","","","","1","0","0","197.210.60.119","2020-01-03 11:55:15","2020-01-03 11:55:47","","","","0","0000-00-00 00:00:00","2019-10-25 21:20:47","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-05 07:49:14","0481","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1202","0","1","0","0","10","21","1","10","21","1202","0","0","0","0","","BUHARI KHADIJAT","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08037902929","","","","","","","","","1","0","0","197.210.226.89","2020-02-07 17:50:10","2020-02-07 17:51:32","","","","0","0000-00-00 00:00:00","2019-10-25 21:22:06","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                                                 
\n                                ","3","2019-11-13 10:36:52","0487","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1203","0","1","0","0","2","15","1","2","15","1203","0","0","0","0","","ABDULKADIR NDANUSA ABDULKADIR","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08067981825","","","","","","","","","1","0","0","105.112.112.20","2020-01-28 16:16:20","2020-01-28 16:16:30","","","","0","0000-00-00 00:00:00","2019-10-25 21:23:26","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-05 07:54:55","0547","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1204","0","1","0","0","9","6","1","9","18","1204","0","0","0","0","","AHMED MOHAMMED KAWU","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08169995973","","","","","","","","","1","0","0","105.112.115.177","2020-01-16 14:53:04","2020-01-16 14:53:46","","","","0","0000-00-00 00:00:00","2019-10-25 21:25:52","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-05 07:56:18","0479","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1205","0","0","0","0","0","0","1","2","15","1205","0","0","0","0","","ALIYU MUHAMMADU TSWACHI","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08032816716","","","","","","","","","1","1","0","105.112.120.76","2019-11-04 12:33:45","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-10-25 21:27:41","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1206","0","1","0","0","4","13","1","4","13","1206","0","0","0","0","","UMAR HALIDU ABUBAKAR","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07035991887","","","","","","","","","1","0","0","197.210.227.98","2020-02-07 17:52:56","2020-02-07 17:54:07","","","","0","0000-00-00 00:00:00","2019-10-25 21:30:11","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-05 08:00:07","0605","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1207","0","1","0","0","9","18","1","10","21","1207","0","0","0","0","","ISMAIL IMRAN","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08063853368","","","","","","","","","1","1","0","197.210.71.89","2020-02-24 15:40:58","2020-01-02 23:55:20","","","","0","0000-00-00 00:00:00","2019-10-25 21:31:43","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                
\n                                                                 
\n                                                                 
\n                                ","3","2020-02-24 15:41:37","0557","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1208","0","1","0","0","10","20","1","10","20","1208","0","0","0","0","","MUSTAPHA HAIRATU","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08035499522","","","","","","","","","1","0","0","197.210.65.39","2020-01-03 12:36:13","2020-01-03 12:36:49","","","","0","0000-00-00 00:00:00","2019-10-25 21:33:19","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-05 08:03:15","0568","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1209","0","1","0","0","4","13","1","4","13","1209","0","0","0","0","","ABUBAKAR ALIYU","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08029205307","","","","","","","","","1","0","0","105.112.120.4","2019-12-05 11:40:21","2019-12-05 12:15:35","","","","0","0000-00-00 00:00:00","2019-10-25 21:34:41","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-05 08:04:43","0662","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1210","0","1","0","0","7","16","1","2","14","1210","0","0","0","0","","AHMED UMAR","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08038886596","","","","","","","","","1","1","0","105.112.120.76","2019-11-04 12:42:51","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-10-25 21:36:07","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-05 08:21:18","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1211","0","1","0","0","7","16","1","7","16","1211","0","0","0","0","","OGBE PAUL","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07060733700","","","","","","","","","1","1","0","105.112.120.76","2019-11-04 12:44:16","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-10-25 21:37:21","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-05 08:08:17","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1212","0","0","0","0","0","0","1","1","1","1212","0","0","0","0","","MOHAMMED DAUDA NDAYAKA","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08063867366","","","","","","","","","1","0","0","105.112.120.195","2019-11-12 13:50:36","2019-11-12 19:43:12","","","","0","0000-00-00 00:00:00","2019-10-30 07:29:02","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1213","0","1","0","0","2","15","1","2","15","1213","0","0","0","0","","GANA YISA DAVID","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08064738463","","","","","","","","","1","0","0","197.210.47.20","2020-01-02 21:52:34","2020-01-02 21:53:32","","","","0","0000-00-00 00:00:00","2019-10-30 07:30:15","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-05 08:09:55","0475","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1214","0","1","0","0","4","13","1","4","13","1214","0","0","0","0","","MOHAMMED ISYAKU KUTA","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07032637212","","","","","","","","","1","0","0","105.112.115.177","2020-01-16 12:05:28","2020-01-16 12:08:23","","","","0","0000-00-00 00:00:00","2019-10-30 07:31:37","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-05 08:13:20","0502","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1215","0","1","0","0","10","21","1","2","14","1215","0","0","0","0","","AREWA ZAKARIYA GIDEON","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08078184519","","","","","","","","","1","1","0","105.112.120.76","2019-11-04 12:59:00","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-10-30 07:32:51","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-05 08:16:23","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1216","0","0","0","0","0","0","1","2","14","1216","0","0","0","0","","DATTI FATIMA YAKUBU","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08168176133","","","","","","","","","1","1","0","105.112.120.76","2019-11-04 12:52:33","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-10-30 07:34:30","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1217","0","1","0","0","9","18","1","2","14","1217","0","0","0","0","","YUSHAU  BELLO","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08065815659","","","","","","","","","1","0","0","197.210.53.28","2019-11-10 14:38:40","2019-11-10 14:40:16","","","","0","0000-00-00 00:00:00","2019-11-04 10:32:07","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-05 08:19:02","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1218","0","1","0","0","2","2","1","2","2","1218","0","0","0","0","","PATIENCE DANIEL","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08168343888","","","","","","","","","1","0","0","105.112.115.177","2020-01-16 13:10:02","2020-01-16 13:10:27","","","","0","0000-00-00 00:00:00","2019-11-04 10:33:32","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-05 07:44:40","0465","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1219","0","1","0","0","4","13","1","4","13","1219","0","0","0","0","","MARYAM UMAR","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08035864158","","","","","","","","","1","0","0","105.112.115.177","2020-01-16 11:40:27","2020-01-16 11:40:37","","","","0","0000-00-00 00:00:00","2019-11-12 14:28:51","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-15 08:51:04","0530","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1220","0","1","0","0","1","1","1","1","1","1220","0","0","0","0","","MOHAMMED DAUDA NDAYAKA","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08063867366","","","","","","","","","1","0","0","105.112.116.72","2020-01-24 12:25:28","2020-01-24 12:26:32","","","","0","0000-00-00 00:00:00","2019-11-14 10:32:12","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-15 16:44:02","0548","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1221","0","1","0","0","10","20","1","10","20","1221","0","0","0","0","","UMAR HALILU","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07063948792","","","","","","","","","1","0","0","197.210.60.119","2020-01-03 12:09:51","2020-01-03 12:10:26","","","","0","0000-00-00 00:00:00","2019-11-14 10:33:32","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-15 09:20:51","0580","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1222","0","1","0","0","7","5","1","7","5","1222","0","0","0","0","","KHADIJAT MOHAMMED LAWAL","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08036227606","","","","","","","","","1","0","0","197.210.70.15","2020-02-04 17:33:13","2020-02-04 17:34:30","","","","0","0000-00-00 00:00:00","2019-11-14 10:34:47","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-22 14:41:29","0606","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1223","0","1","0","0","7","5","1","7","5","1223","0","0","0","0","","IDRIS MUHSIN KAKURI","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08122232926","","","","","","","","","1","0","0","197.210.60.119","2020-01-03 11:40:55","2020-01-03 11:42:00","","","","0","0000-00-00 00:00:00","2019-11-14 10:36:02","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-20 11:17:18","0589","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1224","0","1","0","0","10","20","1","10","20","1224","0","0","0","0","","TITUS YISA","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07066179325","","","","","","","","","1","1","0","41.203.73.168","2019-11-25 17:29:08","2019-11-14 12:00:12","","","","0","0000-00-00 00:00:00","2019-11-14 10:39:46","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-25 16:32:00","0616","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1225","0","0","0","0","0","0","1","9","18","1225","0","0","0","0","","YUSUF VICTOR DEBORAH","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07068313313","","","","","","","","","1","0","0","105.112.112.132","2019-11-14 12:00:21","2019-11-14 12:01:25","","","","0","0000-00-00 00:00:00","2019-11-14 10:40:59","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1226","0","1","0","0","4","12","1","4","12","1226","0","0","0","0","","SHEHU SHAMSUDEEN","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07067312738","","","","","","","","","1","0","0","105.112.116.72","2020-01-24 12:39:34","2020-01-24 12:41:24","","","","0","0000-00-00 00:00:00","2019-11-14 10:52:44","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-24 13:36:30","0609","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1227","0","1","0","0","7","5","1","7","5","1227","0","0","0","0","","USMAN MOHAMMED LADAN","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08035574283","","","","","","","","","1","0","0","105.112.112.20","2020-01-28 16:31:08","2020-01-28 16:31:19","","","","0","0000-00-00 00:00:00","2019-11-20 21:14:19","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-21 15:31:24","0600","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1228","0","0","0","0","0","0","1","10","22","1228","0","0","0","0","","ALHASSAN BALA SHAFA\'ATU","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08029282039","","","","","","","","","1","0","0","105.112.114.133","2019-11-21 09:02:02","2019-11-21 09:04:30","","","","0","0000-00-00 00:00:00","2019-11-20 21:17:47","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1229","0","1","0","0","4","13","1","4","13","1229","0","0","0","0","","SIDI IBRAHIM RAKIYA","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08136697528","","","","","","","","","1","0","0","105.112.113.162","2019-11-26 12:10:36","2019-11-26 12:18:49","","","","0","0000-00-00 00:00:00","2019-11-20 21:19:56","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-26 12:05:13","0617","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1230","0","1","0","0","1","11","1","1","11","1230","0","0","0","0","","ZAINAB SIDI UMAR","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07067768136","","","","","","","","","1","0","0","105.112.120.40","2019-12-02 11:40:19","2019-12-02 11:57:09","","","","0","0000-00-00 00:00:00","2019-11-20 21:23:27","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-12-02 11:38:49","0649","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1231","0","0","0","0","0","0","1","4","12","1231","0","0","0","0","","SHEHU SHAMSUDEEN","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07067312738","","","","","","","","","1","0","0","105.112.114.199","2019-11-22 09:37:20","2019-11-22 09:40:22","","","","0","0000-00-00 00:00:00","2019-11-21 22:27:01","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1232","0","1","0","0","4","4","1","4","4","1232","0","0","0","0","","HASSAN ZAINAB","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08034532844","","","","","","","","","1","0","0","197.210.60.119","2020-01-03 10:43:26","2020-01-03 10:43:56","","","","0","0000-00-00 00:00:00","2019-11-21 22:28:33","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-28 15:21:35","0628","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1233","0","1","0","0","1","11","1","1","11","1233","0","0","0","0","","MOHAMMED  ZAKARI KAILE","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08038720221","","","","","","","","","1","0","0","105.112.113.95","2020-01-15 12:33:29","2020-01-15 13:06:37","","","","0","0000-00-00 00:00:00","2019-11-21 22:30:14","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-22 11:40:27","0601","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1234","0","1","0","0","4","12","1","4","12","1234","0","0","0","0","","SABIU SALIHU","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","09032255666","","","","","","","","","1","0","0","105.112.112.20","2020-01-28 16:12:19","2020-01-28 16:12:34","","","","0","0000-00-00 00:00:00","2019-11-23 06:17:40","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-12-02 14:48:58","0653","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1235","0","1","0","0","10","21","1","10","21","1235","0","0","0","0","","ALIYU KHADIJAH FAUZIYAH","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08028763222","","","","","","","","","1","0","0","105.112.116.72","2020-01-24 12:54:51","2020-01-24 12:56:41","","","","0","0000-00-00 00:00:00","2019-11-23 06:18:52","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-29 12:31:37","0636","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1236","0","1","0","0","10","22","1","10","22","1236","0","0","0","0","","LARAI HELEN YAKUBU","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08035503011","","","","","","","","","1","0","0","197.210.65.222","2020-01-03 12:37:44","2020-01-03 12:38:15","","","","0","0000-00-00 00:00:00","2019-11-23 06:20:09","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-26 12:18:03","0618","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1237","0","0","0","0","0","0","1","10","22","1237","0","0","0","0","","LARAI HELEN YAKUBU","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08035503011","","","","","","","","","1","0","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-11-24 10:48:50","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1238","0","1","0","0","7","5","1","7","5","1238","0","0","0","0","","SULEIMAN ZAINAB","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08038548500","","","","","","","","","1","0","0","105.112.115.177","2020-01-16 13:46:37","2020-01-16 13:46:58","","","","0","0000-00-00 00:00:00","2019-11-24 10:50:16","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-27 11:40:30","0622","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1239","0","1","0","0","2","14","1","2","14","1239","0","0","0","0","","MOHAMMED HAMISU","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08033894961","","","","","","","","","1","0","0","197.210.60.119","2020-01-03 11:18:38","2020-01-03 11:19:11","","","","0","0000-00-00 00:00:00","2019-11-24 10:51:45","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-29 10:41:06","0630","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1240","0","1","0","0","2","14","1","2","14","1240","0","0","0","0","","ADAMU JAMILU","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07036155357","","","","","","","","","1","0","0","105.112.114.214","2019-11-29 12:01:46","2019-11-29 12:15:07","","","","0","0000-00-00 00:00:00","2019-11-27 22:15:07","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-29 12:00:56","0634","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1241","0","1","0","0","2","2","1","2","2","1241","0","0","0","0","","MUHAMMAD RUKKAYA ERENA","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08065650077","","","","","","","","","1","0","0","105.112.114.214","2019-11-29 16:56:54","2019-11-29 17:00:20","","","","0","0000-00-00 00:00:00","2019-11-27 22:16:59","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-29 16:55:45","0642","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1242","0","1","0","0","2","14","1","2","14","1242","0","0","0","0","","MARYAM ABDULLAHI ERENA","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08032907084","","","","","","","","","1","0","0","105.112.114.214","2019-11-29 17:00:44","2019-11-29 17:40:07","","","","0","0000-00-00 00:00:00","2019-11-27 22:18:57","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-29 17:01:24","0643","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1243","0","1","0","0","7","16","1","7","16","1243","0","0","0","0","","USMAN HUDU ABDULLAHI","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08064914545","","","","","","","","","1","0","0","197.210.60.119","2020-01-03 11:53:14","2020-01-03 11:53:49","","","","0","0000-00-00 00:00:00","2019-11-27 22:20:36","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-29 11:58:00","0633","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1244","0","1","0","0","4","12","1","4","12","1244","0","0","0","0","","BAHAGO FAROUQ MUKTAR","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08032372050","","","","","","","","","1","0","0","197.210.60.119","2020-01-03 10:58:47","2020-01-03 10:59:22","","","","0","0000-00-00 00:00:00","2019-11-27 22:22:03","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-12-03 11:47:18","0655","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1245","0","1","0","0","4","12","1","4","12","1245","0","0","0","0","","BAHAGO FAROUQ ALIYU","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08109664465","","","","","","","","","1","0","0","197.210.60.119","2020-01-03 10:59:39","2020-01-03 11:00:10","","","","0","0000-00-00 00:00:00","2019-11-27 22:23:13","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-12-03 11:47:56","0657","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1246","0","1","0","0","7","16","1","7","16","1246","0","0","0","0","","MARYAM ADAMU","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","09054271476","","","","","","","","","1","0","0","197.210.60.119","2020-01-03 11:52:18","2020-01-03 11:52:58","","","","0","0000-00-00 00:00:00","2019-11-27 22:25:09","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-29 13:56:36","0637","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1247","0","1","0","0","1","1","1","1","1","1247","0","0","0","0","","OLAJIDE ABDULNURENI","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08069706557","","","","","","","","","1","0","0","197.210.71.189","2020-01-29 09:16:22","2020-01-29 11:20:04","","","","0","0000-00-00 00:00:00","2019-11-27 22:26:58","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-11-29 14:28:51","0640","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1248","0","0","0","0","0","0","1","2","15","1248","0","0","0","0","","MOHAMMED BABA WACHIKO","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07061806888","","","","","","","","","1","1","0","197.210.44.135","2019-12-05 20:41:02","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-12-03 07:34:17","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1249","0","1","0","0","9","18","1","9","18","1249","0","0","0","0","","JANET GANA","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07033267674","","","","","","","","","1","0","0","105.112.115.59","2019-12-11 14:02:14","2019-12-12 16:07:17","","","","0","0000-00-00 00:00:00","2019-12-03 07:35:47","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-12-11 14:00:49","0002","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1250","0","0","0","0","0","0","1","4","12","1250","0","0","0","0","","DANJUMA NAFISAT","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08035503011","","","","","","","","","1","1","0","105.112.121.127","2019-12-23 12:00:09","0000-00-00 00:00:00","","","","0","0000-00-00 00:00:00","2019-12-13 10:08:14","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1251","0","0","0","0","0","0","1","7","16","1251","0","0","0","0","","MOHAMMED LAYUSA","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08136338890","","","","","","","","","1","0","0","197.210.53.164","2019-12-31 19:00:58","2019-12-31 19:01:32","","","","0","0000-00-00 00:00:00","2019-12-23 11:49:17","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1252","0","0","0","0","0","0","1","2","2","1252","0","0","0","0","","AHMED ABDULLAHI","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08057146837","","","","","","","","","1","0","0","197.210.52.169","2019-12-31 19:01:38","2019-12-31 19:07:01","","","","0","0000-00-00 00:00:00","2019-12-23 11:50:44","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1253","0","0","0","0","0","0","1","2","15","1253","0","0","0","0","","NMA IDRIS TOROKO","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08065907402","","","","","","","","","1","0","0","197.210.52.169","2019-12-31 19:08:10","2019-12-31 19:10:50","","","","0","0000-00-00 00:00:00","2019-12-23 11:52:22","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1254","0","1","0","0","7","5","1","7","5","1254","0","0","0","0","","ADAMU ABUBAKAR BAIDA","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07033187976","","","","","","","","","1","0","0","105.112.112.20","2020-01-28 16:29:47","2020-01-28 16:29:56","","","","0","0000-00-00 00:00:00","2019-12-23 11:54:09","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2020-01-02 13:42:49","0016","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1255","0","1","0","0","7","5","1","7","5","1255","0","0","0","0","","MOHAMMED SANI","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08099559983","","","","","","","","","1","0","0","105.112.112.20","2020-01-28 16:30:09","2020-01-28 16:30:24","","","","0","0000-00-00 00:00:00","2019-12-23 11:55:27","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2020-01-02 13:43:05","0017","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1256","0","1","0","0","7","5","1","7","5","1256","0","0","0","0","","IDRIS SADIQ ABUBAKAR","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08099559983","","","","","","","","","1","0","0","105.112.112.20","2020-01-28 16:30:41","2020-01-28 16:30:52","","","","0","0000-00-00 00:00:00","2019-12-23 11:56:26","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2019-12-28 12:48:38","0018","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1257","0","1","0","0","1","1","1","1","1","1257","0","0","0","0","","ABDULMUMINI MIKAILU","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08109001227","","","","","","","","","1","0","0","105.112.122.165","2020-02-03 19:12:50","2020-02-03 19:14:23","","","","0","0000-00-00 00:00:00","2020-01-02 15:08:37","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2020-01-09 15:50:16","0029","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1258","0","1","0","0","2","2","1","2","2","1258","0","0","0","0","","YAKUBU ABDULSALAM","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","09050911517","","","","","","","","","1","0","0","197.210.227.140","2020-02-07 12:31:46","2020-02-07 12:33:05","","","","1","0000-00-00 00:00:00","2020-01-02 17:42:59","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2020-01-08 16:21:48","0028","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1259","0","1","0","0","2","14","1","2","14","1259","0","0","0","0","","HAMIDU FATIMA","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08061277971","","","","","","","","","1","0","0","105.112.112.20","2020-01-28 16:20:48","2020-01-28 16:21:04","","","","0","0000-00-00 00:00:00","2020-01-02 17:44:05","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2020-01-06 11:59:03","0023","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1260","0","1","0","0","10","20","1","10","20","1260","0","0","0","0","","TAHIR SHUARA IBRAHIM","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08062865350","","","","","","","","","1","0","0","105.112.116.72","2020-01-24 12:56:58","2020-01-24 12:57:35","","","","0","0000-00-00 00:00:00","2020-01-16 07:59:42","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2020-01-16 13:53:15","0033","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1261","0","1","0","0","7","5","1","7","5","1261","0","0","0","0","","YUSUF DANJUMA","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08037482204","","","","","","","","","1","1","0","105.112.122.34","2020-01-20 12:48:32","2020-01-16 13:51:28","","","","0","0000-00-00 00:00:00","2020-01-16 08:01:42","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2020-01-20 12:47:17","0035","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1262","0","1","0","0","2","15","1","2","15","1262","0","0","0","0","","ADAMU UMAR FARUK","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08033246046","","","","","","","","","1","0","0","197.210.226.89","2020-02-07 17:42:16","2020-02-07 17:43:19","","","","0","0000-00-00 00:00:00","2020-01-17 10:38:20","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2020-01-17 11:12:01","0034","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1263","0","1","0","0","4","12","1","4","12","1263","0","0","0","0","","ABDULLAHI ADAMU","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07062511449","","","","","","","","","1","1","0","197.210.71.213","2020-02-12 18:06:51","2020-01-22 10:29:18","","","","0","0000-00-00 00:00:00","2020-01-22 08:22:23","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2020-01-24 17:47:35","0037","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1264","0","0","0","0","0","0","1","2","2","1264","0","0","0","0","","MUSA IBRAHIM","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07034912380","","","","","","","","","1","0","0","197.210.29.38","2020-01-27 09:02:44","2020-01-27 09:12:15","","","","0","0000-00-00 00:00:00","2020-01-24 19:08:14","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1265","0","1","0","0","10","20","1","10","20","1265","0","0","0","0","","ABUBAKAR HADIZA","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08038229462","","","","","","","","","1","0","0","197.210.70.15","2020-02-04 17:40:22","2020-02-04 17:42:14","","","","0","0000-00-00 00:00:00","2020-01-27 07:44:48","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2020-02-01 16:02:59","0042","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1266","0","0","0","0","0","0","1","7","5","1266","0","0","0","0","","ABDULKADIR SULEIMAN","","","","","","0","","","","","","","","","asuleimanlapai@gmail.com","","","07068401380","","","","","","","","","1","0","0","105.112.120.19","2020-01-31 13:29:08","2020-01-31 13:30:30","","","","0","0000-00-00 00:00:00","2020-01-31 09:44:14","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1267","0","1","0","0","2","2","1","10","20","1267","0","0","0","0","","AMMAR MUSTAPHA","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08134487729","","","","","","","","","1","0","0","105.112.122.165","2020-02-03 19:18:26","2020-02-03 19:20:20","","","","0","0000-00-00 00:00:00","2020-01-31 10:36:25","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2020-01-31 17:18:47","0041","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1268","0","1","0","0","2","14","1","2","14","1268","0","0","0","0","","SAMIRA MOHAMMED SAMBO","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08112921232","","","","","","","","","1","1","0","105.112.115.106","2020-03-19 14:04:02","2020-02-05 15:03:06","","","","0","0000-00-00 00:00:00","2020-01-31 10:39:13","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2020-02-01 16:41:39","0043","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1269","0","1","0","0","9","18","1","9","18","1269","0","0","0","0","","HALIMA ABUBAKAR","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","08038826346","","","","","","","","","1","0","0","105.112.122.165","2020-02-03 19:27:16","2020-02-04 10:18:48","","","","0","0000-00-00 00:00:00","2020-01-31 10:41:12","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2020-02-03 11:48:20","0044","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1270","0","0","0","0","0","0","1","7","5","1270","0","0","0","0","","ADAMU SUMAIYA","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","07051550759","","","","","","","","","1","1","0","105.112.120.19","2020-01-31 14:56:35","2020-01-31 13:46:54","","","","0","0000-00-00 00:00:00","2020-01-31 10:43:51","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1271","0","0","0","0","0","0","1","1","1","1271","0","0","0","0","","swedfg","","","","","","0","","","","","","","","","as@h.com","","","07068401380","","","","","","","","","1","0","0","197.210.52.59","2020-01-31 12:42:23","2020-01-31 13:28:52","","","","0","0000-00-00 00:00:00","2020-01-31 12:42:12","0000-00-00 00:00:00","","","","","","","0","","","0","","0","0000-00-00 00:00:00","","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");
INSERT INTO applicants VALUES("1272","0","1","0","0","9","18","1","9","18","1272","0","0","0","0","","AJIB BOSE BUNMI","","","","","","0","","","","","","","","","angoaliyu76@yahoo.com","","","09097099820","","","","","","","","","1","0","0","197.210.226.253","2020-02-07 12:40:19","2020-02-08 12:19:00","","","","0","0000-00-00 00:00:00","2020-02-05 13:07:29","0000-00-00 00:00:00","","","","","","","0","","","1","                                
\n                                                                 
\n                                ","3","2020-02-06 15:07:38","0046","0","","0","0000","0000","0","","0","0000","0000","0","","0","0000","0000","0","0");



DROP TABLE assets;

CREATE TABLE `assets` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `action` varchar(255) NOT NULL COMMENT 'last action done',
  `done` int(5) NOT NULL COMMENT '0 not done, 1 done',
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=116 DEFAULT CHARSET=latin1;




DROP TABLE backups;

CREATE TABLE `backups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `file` varchar(255) NOT NULL,
  `status` int(5) NOT NULL COMMENT '0 - published, 1- unpublished, 2 - trashed, 3 - archived, 4- deleted from trash',
  `date_added` datetime NOT NULL,
  `date_trashed` datetime NOT NULL,
  `added_by` varchar(255) NOT NULL,
  `modified_by` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COMMENT='Keep up to date file.sql backups';

INSERT INTO backups VALUES("1","ibbulapai1435246963","0","2015-06-25 16:42:43","0000-00-00 00:00:00","ghost","");
INSERT INTO backups VALUES("2","ibbulapai1435260395","0","2015-06-25 20:26:35","0000-00-00 00:00:00","ghost","");
INSERT INTO backups VALUES("3","ibbulapai1435309944","0","2015-06-26 10:12:24","0000-00-00 00:00:00","ghost","");



DROP TABLE controls;

CREATE TABLE `controls` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL COMMENT 'different items to manage',
  `controls_value` varchar(255) NOT NULL COMMENT 'should contain dynamic strings with underscores',
  `description` text NOT NULL COMMENT 'briefly describing what the items are meant for',
  `status` int(5) NOT NULL COMMENT '0 - published, 1- unpublished, 2 - trashed, 3 - archived, 4- deleted from trash',
  `active` int(5) NOT NULL COMMENT '0 - inactive, 1 - active',
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `date_trashed` datetime NOT NULL,
  `added_by` varchar(255) NOT NULL,
  `modified_by` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1 COMMENT='This table keeps record whether all application modules are on or off';

INSERT INTO controls VALUES("1","application","","","1","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO controls VALUES("2","school_registration","","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO controls VALUES("3","school_fee_payment","","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO controls VALUES("4","admission_manager","","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO controls VALUES("5","Testingt","testing_controlst","                                descriptiont","1","1","2015-06-08 13:28:24","2015-06-09 06:02:03","2015-06-09 06:02:20","","ghost");
INSERT INTO controls VALUES("6","testing FACtt","testing_controlst","                                ffdsfs                                                                                                ","1","0","2015-06-08 13:29:48","2015-06-08 13:30:35","2015-06-08 13:30:03","ghost","ghost");



DROP TABLE departments;

CREATE TABLE `departments` (
  `id` int(11) unsigned NOT NULL,
  `faculty_id` int(11) NOT NULL COMMENT 'Not in Use For Now',
  `title` varchar(255) NOT NULL,
  `code` varchar(100) NOT NULL COMMENT 'not in use for nw',
  `description` text NOT NULL,
  `real_` int(11) NOT NULL COMMENT '0 - real dept, 1 -virtual dept',
  `status` int(5) NOT NULL COMMENT '0 - published, 1- unpublished, 2 - trashed, 3 - archived, 4- deleted from trash',
  `logo` varchar(255) NOT NULL,
  `hod_name` varchar(255) NOT NULL,
  `hod_picture` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `phone_contacts` text NOT NULL,
  `history_introduction` text NOT NULL,
  `department_image` varchar(255) NOT NULL COMMENT 'image of a particular dept',
  `mission` text NOT NULL COMMENT 'nfn- not functional for nw',
  `vision` text NOT NULL COMMENT 'nfn- not functional for nw',
  `location` text NOT NULL COMMENT 'cureent address of a dept',
  `objectives` text NOT NULL COMMENT 'nfn- not functional for nw',
  `staff_list_file` varchar(255) NOT NULL COMMENT 'keeps pdf file for staff list',
  `department_details` varchar(255) NOT NULL COMMENT 'keeps pdf file on a particular department',
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `date_trashed` datetime NOT NULL,
  `added_by` varchar(255) NOT NULL,
  `modified_by` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='This table stores all the departments in the school and link';

INSERT INTO departments VALUES("1","1","ACCOUNTING","ACCT","                                                         ","0","0","","","","","","","","","","","","","","0000-00-00 00:00:00","2015-09-05 16:05:24","0000-00-00 00:00:00","ghost","ghost");
INSERT INTO departments VALUES("2","1","PUBLIC ADMINISTRATION","PAD","","0","0","","","","","","","","","","","","","","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","ghost","ghost");
INSERT INTO departments VALUES("3","1","MEDIA AND COMMUNICATION STUDIES","MCS","","0","0","","","","","","","","","","","","","","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","ghost","ghost");
INSERT INTO departments VALUES("4","1","BUSINESS ADMINISTRATION","BUS","","0","0","","","","","","","","","","","","","","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO departments VALUES("5","0","GENERAL STUDIES","GST","Created to house all the virtual GST Courses                                                            ","1","0","","","","","","","","","","","","","","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO departments VALUES("6","0","STAND ALONE","SA","Created to house all the virtual stand alone  Courses                                                            ","1","0","","","","","","","","","","","","","","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO departments VALUES("7","1","SOCIOLOGY","SOC","","0","0","","","","","","","","","","","","","","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO departments VALUES("8","1","COMPUTER SCIENCE","CSC","","0","0","","","","","","","","","","","","","","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO departments VALUES("9","1","ADULT EDUCATION","AED","","0","0","","","","","","","","","","","","","","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO departments VALUES("10","1","COUNSELING PSYCHOLOGY ","COP","","0","0","","","","","","","","","","","","","","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO departments VALUES("11","1","EXERCISE AND SPORT SCIENCE","SHE","","0","0","","","","","","","","","","","","","","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");



DROP TABLE hostel_allocation;

CREATE TABLE `hostel_allocation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hostel_site` int(11) NOT NULL,
  `hostel_categories` int(11) NOT NULL,
  `room_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `status` enum('0','1','2','3') NOT NULL DEFAULT '1',
  `chk_in_date_time` varchar(222) NOT NULL,
  `n` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

INSERT INTO hostel_allocation VALUES("1","2","1","9","14","0","2020-06-08 01:24:52","0");
INSERT INTO hostel_allocation VALUES("2","2","1","9","16","0","2020-06-08 01:25:32","0");
INSERT INTO hostel_allocation VALUES("3","2","1","8","196","0","2020-06-08 01:26:26","0");
INSERT INTO hostel_allocation VALUES("4","2","1","8","200","0","2020-06-08 11:11:14","0");



DROP TABLE hostel_categories;

CREATE TABLE `hostel_categories` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `hostel_site` int(11) NOT NULL COMMENT 'logical foreign key from hostel_sites',
  `bed_space` int(11) NOT NULL DEFAULT '0',
  `gender` varchar(20) NOT NULL,
  `status` enum('0','1') NOT NULL DEFAULT '1',
  `hostel_amount` varchar(200) NOT NULL,
  `date_added` datetime NOT NULL,
  `added_by` varchar(200) NOT NULL,
  `date_modified` datetime NOT NULL,
  `modified_by` varchar(200) NOT NULL,
  `reserved` int(11) NOT NULL COMMENT '0 = not reserved, 1 = reserved',
  `trashed` enum('0','1') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COMMENT='table for different hostel categories';

INSERT INTO hostel_categories VALUES("1","Block A","Female Block (P.Site)","2","10","female","1","12400","2020-05-13 01:46:02","abbas","2020-06-02 23:56:28","mis","0","0");
INSERT INTO hostel_categories VALUES("2","Block B","Male Block (Kobo ffsfsr)","1","15","male","1","12400","2020-05-19 14:16:18","ghost","2020-06-02 23:57:52","ghost","0","0");
INSERT INTO hostel_categories VALUES("3","Block A","Female Block (Kobo campus)","1","20","female","1","12400","2020-05-19 14:19:50","ghost","2020-06-02 23:55:24","ghost","0","0");



DROP TABLE hostel_fee_payments;

CREATE TABLE `hostel_fee_payments` (
  `id` int(11) NOT NULL,
  `programme_type_id` int(11) NOT NULL COMMENT 'nfn',
  `department_id` int(11) NOT NULL COMMENT 'nfn',
  `programme_id` int(11) NOT NULL COMMENT 'nfn',
  `actual_programme_id` int(11) NOT NULL,
  `session` int(11) NOT NULL COMMENT 'session id from session table',
  `semester` int(11) NOT NULL COMMENT '1- 1st semester, 2 - 2nd semester',
  `student_id` int(11) NOT NULL,
  `payment_status` int(11) NOT NULL COMMENT 'state whether paid or not 0-not paid, 1 -paid',
  `payment_mode` int(5) NOT NULL COMMENT '0-default, 1- installment, 2 - full',
  `payment_type` varchar(222) NOT NULL COMMENT 'not functional for now',
  `payment_method` varchar(255) NOT NULL,
  `invoice_id` int(11) NOT NULL,
  `title` varchar(222) NOT NULL,
  `description` text NOT NULL,
  `amount` varchar(222) NOT NULL,
  `date_added` datetime NOT NULL,
  `added_by` varchar(255) NOT NULL COMMENT 'not functional for now',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='This table keeps all paid sch fee payments by session & stdn';




DROP TABLE hostel_rooms;

CREATE TABLE `hostel_rooms` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `hostel_site` int(11) NOT NULL COMMENT 'logical foreign key from hostel_sites',
  `hostel_categories` int(11) NOT NULL DEFAULT '0',
  `published` int(5) NOT NULL COMMENT '0 - published 1 - not to published',
  `bedspace` int(11) NOT NULL,
  `reserved` int(11) NOT NULL DEFAULT '0',
  `trashed` int(5) NOT NULL COMMENT '1- deleted to trash, 0 - not deleted to trash',
  `trash_delete` int(5) NOT NULL COMMENT '1 - cleared from trash , 0 - not cleared from trash',
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `added_by` varchar(255) NOT NULL,
  `modified_by` varchar(255) NOT NULL,
  `status` enum('0','1') NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1 COMMENT='table for different hostel categories';

INSERT INTO hostel_rooms VALUES("1","Room 001","Female Block (P.Site)","2","1","0","2","0","0","0","2020-06-08 01:16:43","0000-00-00 00:00:00","abbas","","1");
INSERT INTO hostel_rooms VALUES("2","Room 009","Female Block (Kobo)","1","3","0","2","0","0","0","2020-06-08 01:17:36","0000-00-00 00:00:00","abbas","","1");
INSERT INTO hostel_rooms VALUES("5","Room 003","Female Block (Kobo)","1","3","0","2","0","0","0","2020-06-08 01:23:01","0000-00-00 00:00:00","abbas","","1");
INSERT INTO hostel_rooms VALUES("6","Room 006","Female Block (Kobo)","1","3","0","2","0","0","0","2020-06-08 01:23:32","0000-00-00 00:00:00","abbas","","1");
INSERT INTO hostel_rooms VALUES("7","Room 007","Female Block (Kobo)","1","3","0","2","0","0","0","2020-06-08 01:23:51","0000-00-00 00:00:00","abbas","","1");
INSERT INTO hostel_rooms VALUES("8","Room 007","Female Block (P.Site)","2","1","0","2","0","0","0","2020-06-08 01:24:04","0000-00-00 00:00:00","abbas","","1");
INSERT INTO hostel_rooms VALUES("9","Room 004","Female Block (P.Site)","2","1","0","2","0","0","0","2020-06-08 01:24:20","0000-00-00 00:00:00","abbas","","1");
INSERT INTO hostel_rooms VALUES("10","room 005","Block A (P.Site)","1","2","0","2","0","0","0","2020-06-08 10:53:44","0000-00-00 00:00:00","ghost","","1");
INSERT INTO hostel_rooms VALUES("11","room 005","Block A Female (P.Site)","2","1","0","2","0","0","0","2020-06-08 10:59:14","0000-00-00 00:00:00","ghost","","1");
INSERT INTO hostel_rooms VALUES("12","Room 002","Block A Female (P.Site)","2","1","0","3","0","0","0","2020-06-08 11:03:21","0000-00-00 00:00:00","ghosts","","1");



DROP TABLE hostel_sites;

CREATE TABLE `hostel_sites` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `published` int(5) NOT NULL COMMENT '0 - published 1 - not to published',
  `trashed` int(5) NOT NULL COMMENT '1- deleted to trash, 0 - not deleted to trash',
  `trash_delete` varchar(50) NOT NULL COMMENT '1 - cleared from trash , 0 - not cleared from trash',
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `added_by` varchar(255) NOT NULL,
  `modified_by` varchar(255) NOT NULL,
  `status` enum('0','1') NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COMMENT='This table stores all hostel/residents cartegories';

INSERT INTO hostel_sites VALUES("1","Kobo Campus","Ibb University campus","0","0","0000-00-00 00:00:00","2020-05-19 11:52:55","0000-00-00 00:00:00","ghost","","1");
INSERT INTO hostel_sites VALUES("2","P.site","Ibb University permanet campus","0","0","0000-00-00 00:00:00","2020-05-19 11:53:58","2020-06-02 22:32:34","ghost","ghost","1");
INSERT INTO hostel_sites VALUES("3","FUT Minna Bosso Campus","Federal University of Technology Minna","0","0","0000-00-00 00:00:00","2020-06-02 12:06:08","2020-06-02 21:55:01","mis","mis","1");



DROP TABLE invoices;

CREATE TABLE `invoices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(255) NOT NULL,
  `invoice_type` int(11) NOT NULL COMMENT '0 - App fee 1- fresh stud, 2- returning students',
  `invoice_to` int(11) NOT NULL COMMENT 'in this case its student',
  `pay_to` varchar(255) NOT NULL COMMENT 'i this case its the institution',
  `invoice_for` int(5) NOT NULL COMMENT '0 - application fees,  1 - school -fee',
  `payment_mode` int(5) NOT NULL COMMENT '0-default, 1- installment, 2 - full',
  `payment_method` varchar(255) NOT NULL COMMENT 'interswitch colllege pay, bank  deposit, atm transfer, quick teller',
  `payment_status` int(5) NOT NULL COMMENT '0 -not paid, 1 -paid',
  `session` int(5) NOT NULL COMMENT 'session foreign key',
  `user_carts` int(5) NOT NULL COMMENT 'not in use for nw, can be useful for advancement like stdnts nd staff',
  `title` varchar(255) NOT NULL COMMENT 'items',
  `description` text NOT NULL COMMENT 'little notes',
  `amount` double(10,2) NOT NULL,
  `total_amount` double(10,2) NOT NULL,
  `credit` double(10,2) NOT NULL,
  `date_added` datetime NOT NULL,
  `due_date` datetime NOT NULL,
  `expire_date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COMMENT='This table keeps all invoices generated by students';

INSERT INTO invoices VALUES("1","00212634","2","3","School name goes here. <br> ","100","0","","0","5","0","Hostel Fee Payment","","12400.00","12400.00","0.00","2020-05-30 13:11:07","2020-05-30 13:11:07","0000-00-00 00:00:00");
INSERT INTO invoices VALUES("2","00369364","2","3","School name goes here. <br> ","100","0","","0","5","0","Hostel Fee Payment","","12400.00","12400.00","0.00","2020-05-30 15:03:11","2020-05-30 15:03:11","0000-00-00 00:00:00");
INSERT INTO invoices VALUES("3","00454627","2","14","School name goes here. <br> ","100","0","","0","5","0","Hostel Fee Payment","","12400.00","12400.00","0.00","2020-06-08 11:19:08","2020-06-08 11:19:08","0000-00-00 00:00:00");



DROP TABLE ip_filter;

CREATE TABLE `ip_filter` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ips` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `status` int(5) NOT NULL COMMENT '0 - published, 1- unpublished, 2 - trashed, 3 - archived, 4- deleted from trash',
  `activate` int(5) NOT NULL COMMENT '0- for blocked , 1- active',
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `date_trashed` datetime NOT NULL,
  `added_by` varchar(255) NOT NULL,
  `modified_by` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=latin1 COMMENT='This table keeps record of all ips to be connected in d sys';

INSERT INTO ip_filter VALUES("1","::1","Ghost System","The system is for super administrator","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("5","192168431","","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("6","1921680203","","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("7","1921680202","","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("8","1921680204","","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("9","","1921680205","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("10","","1921680206","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("11","","1921680207","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("12","","1921680208","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("13","","1921680209","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("14","","1921680210","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("15","","1921680211","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("16","","1921680212","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("17","","1921680213","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("18","","1921680214","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("19","","1921680215","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("20","","1921680216","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("21","","1921680217","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("22","","1921680218","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("23","","1921680219","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("24","","1921680220","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("25","","1921680221","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("26","","1921680222","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("27","","1921680223","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("28","","1921680230","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("29","","1921680224","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("30","","1921680225","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("31","","1921680226","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("32","","1921680227","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("33","","1921680228","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("34","","1921680229","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("35","","1921680231","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("36","","1921680232","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("37","","1921680233","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("38","1922348043t","Lawal systemt","                                this is part of ust","1","0","2015-06-02 12:36:06","2015-06-02 15:24:27","2015-06-02 15:33:05","ghost","ghost");



DROP TABLE lga;

CREATE TABLE `lga` (
  `id` int(11) NOT NULL,
  `state_id` int(10) NOT NULL,
  `title` text NOT NULL,
  `description` text NOT NULL,
  `status` int(5) NOT NULL COMMENT '0 - published, 1- unpublished, 2 - trashed, 3 - archived, 4- deleted from trash',
  `date_trashed` int(5) NOT NULL COMMENT '1 - cleared from trash , 0 - not cleared from trash',
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `added_by` varchar(255) NOT NULL,
  `modified_by` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Local governments in Nigeria.';

INSERT INTO lga VALUES("1","1","Aba North","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("2","1","Aba South","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("3","1","Arochukwu","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("4","1","Bende","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("5","1","Ikwuano","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("6","1","Isiala Ngwa North","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("7","1","Isiala Ngwa South","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("8","1","Isuikwuato","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("9","1","Obi Ngwa","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("10","1","Ohafia","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("11","1","Osisioma","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("12","1","Ugwunagbo","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("13","1","Ukwa East","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("14","1","Ukwa West","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("15","1","Umuahia North","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("16","1","Umuahia South","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("17","1","Umu Nneochi","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("18","2","Demsa","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("19","2","Fufure","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("20","2","Ganye","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("21","2","Gayuk","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("22","2","Gombi","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("23","2","Grie","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("24","2","Hong","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("25","2","Jada","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("26","2","Larmurde","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("27","2","Madagali","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("28","2","Maiha","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("29","2","Mayo Belwa","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("30","2","Michika","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("31","2","Mubi North","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("32","2","Mubi South","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("33","2","Numan","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("34","2","Shelleng","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("35","2","Song","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("36","2","Toungo","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("37","2","Yola North","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("38","2","Yola South","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("39","3","Abak","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("40","3","Eastern Obolo","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("41","3","Eket","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("42","3","Esit Eket","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("43","3","Essien Udim","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("44","3","Etim Ekpo","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("45","3","Etinan","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("46","3","Ibeno","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("47","3","Ibesikpo Asutan","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("48","3","Ibiono-Ibom","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("49","3","Ika","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("50","3","Ikono","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("51","3","Ikot Abasi","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("52","3","Ikot Ekpene","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("53","3","Ini","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("54","3","Itu","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("55","3","Mbo","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("56","3","Mkpat-Enin","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("57","3","Nsit-Atai","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("58","3","Nsit-Ibom","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("59","3","Nsit-Ubium","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("60","3","Obot Akara","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("61","3","Okobo","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("62","3","Onna","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("63","3","Oron","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("64","3","Oruk Anam","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("65","3","Udung-Uko","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("66","3","Ukanafun","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("67","3","Uruan","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("68","3","Urue-Offong/Oruko","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("69","3","Uyo","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("70","4","Aguata","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("71","4","Anambra East","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("72","4","Anambra West","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("73","4","Anaocha","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("74","4","Awka North","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("75","4","Awka South","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("76","4","Ayamelum","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("77","4","Dunukofia","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("78","4","Ekwusigo","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("79","4","Idemili North","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("80","4","Idemili South","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("81","4","Ihiala","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("82","4","Njikoka","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("83","4","Nnewi North","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("84","4","Nnewi South","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("85","4","Ogbaru","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("86","4","Onitsha North","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("87","4","Onitsha South","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("88","4","Orumba North","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("89","4","Orumba South","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("90","4","Oyi","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("91","5","Alkaleri","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("92","5","Bauchi","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("93","5","Bogoro","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("94","5","Damban","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("95","5","Darazo","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("96","5","Dass","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("97","5","Gamawa","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("98","5","Ganjuwa","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("99","5","Giade","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("100","5","Itas/Gadau","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("101","5","Jama\'are","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("102","5","Katagum","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("103","5","Kirfi","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("104","5","Misau","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("105","5","Ningi","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("106","5","Shira","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("107","5","Tafawa Balewa","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("108","5","Toro","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("109","5","Warji","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("110","5","Zaki","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("111","6","Brass","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("112","6","Ekeremor","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("113","6","Kolokuma/Opokuma","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("114","6","Nembe","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("115","6","Ogbia","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("116","6","Sagbama","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("117","6","Southern Ijaw","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("118","6","Yenagoa","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("119","7","Agatu","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("120","7","Apa","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("121","7","Ado","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("122","7","Buruku","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("123","7","Gboko","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("124","7","Guma","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("125","7","Gwer East","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("126","7","Gwer West","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("127","7","Katsina-Ala","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("128","7","Konshisha","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("129","7","Kwande","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("130","7","Logo","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("131","7","Makurdi","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("132","7","Obi","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("133","7","Ogbadibo","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("134","7","Ohimini","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("135","7","Oju","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("136","7","Okpokwu","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("137","7","Oturkpo","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("138","7","Tarka","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("139","7","Ukum","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("140","7","Ushongo","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("141","7","Vandeikya","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("142","8","Abadam","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("143","8","Askira/Uba","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("144","8","Bama","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("145","8","Bayo","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("146","8","Biu","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("147","8","Chibok","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("148","8","Damboa","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("149","8","Dikwa","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("150","8","Gubio","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("151","8","Guzamala","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("152","8","Gwoza","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("153","8","Hawul","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("154","8","Jere","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("155","8","Kaga","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("156","8","Kala/Balge","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("157","8","Konduga","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("158","8","Kukawa","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("159","8","Kwaya Kusar","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("160","8","Mafa","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("161","8","Magumeri","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("162","8","Maiduguri","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("163","8","Marte","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("164","8","Mobbar","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("165","8","Monguno","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("166","8","Ngala","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("167","8","Nganzai","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("168","8","Shani","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("169","9","Abi","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("170","9","Akamkpa","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("171","9","Akpabuyo","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("172","9","Bakassi","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("173","9","Bekwarra","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("174","9","Biase","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("175","9","Boki","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("176","9","Calabar Municipal","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("177","9","Calabar South","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("178","9","Etung","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("179","9","Ikom","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("180","9","Obanliku","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("181","9","Obubra","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("182","9","Obudu","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("183","9","Odukpani","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("184","9","Ogoja","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("185","9","Yakuur","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("186","9","Yala","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("187","10","Aniocha North","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("188","10","Aniocha South","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("189","10","Bomadi","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("190","10","Burutu","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("191","10","Ethiope East","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("192","10","Ethiope West","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("193","10","Ika North East","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("194","10","Ika South","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("195","10","Isoko North","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("196","10","Isoko South","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("197","10","Ndokwa East","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("198","10","Ndokwa West","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("199","10","Okpe","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("200","10","Oshimili North","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("201","10","Oshimili South","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("202","10","Patani","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("203","10","Sapele, Delta","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("204","10","Udu","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("205","10","Ughelli North","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("206","10","Ughelli South","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("207","10","Ukwuani","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("208","10","Uvwie","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("209","10","Warri North","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("210","10","Warri South","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("211","10","Warri South West","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("212","11","Abakaliki","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("213","11","Afikpo North","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("214","11","Afikpo South","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("215","11","Ebonyi","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("216","11","Ezza North","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("217","11","Ezza South","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("218","11","Ikwo","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("219","11","Ishielu","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("220","11","Ivo","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("221","11","Izzi","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("222","11","Ohaozara","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("223","11","Ohaukwu","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("224","11","Onicha","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("225","12","Akoko-Edo","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("226","12","Egor","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("227","12","Esan Central","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("228","12","Esan North-East","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("229","12","Esan South-East","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("230","12","Esan West","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("231","12","Etsako Central","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("232","12","Etsako East","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("233","12","Etsako West","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("234","12","Igueben","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("235","12","Ikpoba Okha","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("236","12","Orhionmwon","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("237","12","Oredo","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("238","12","Ovia North-East","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("239","12","Ovia South-West","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("240","12","Owan East","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("241","12","Owan West","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("242","12","Uhunmwonde","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("243","13","Ado Ekiti","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("244","13","Efon","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("245","13","Ekiti East","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("246","13","Ekiti South-West","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("247","13","Ekiti West","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("248","13","Emure","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("249","13","Gbonyin","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("250","13","Ido Osi","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("251","13","Ijero","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("252","13","Ikere","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("253","13","Ikole","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("254","13","Ilejemeje","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("255","13","Irepodun/Ifelodun","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("256","13","Ise/Orun","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("257","13","Moba","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("258","13","Oye","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("259","14","Aninri","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("260","14","Awgu","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("261","14","Enugu East","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("262","14","Enugu North","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("263","14","Enugu South","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("264","14","Ezeagu","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("265","14","Igbo Etiti","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("266","14","Igbo Eze North","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("267","14","Igbo Eze South","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("268","14","Isi Uzo","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("269","14","Nkanu East","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("270","14","Nkanu West","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("271","14","Nsukka","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("272","14","Oji River","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("273","14","Udenu","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("274","14","Udi","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("275","14","Uzo Uwani","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("276","15","Abaji","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("277","15","Bwari","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("278","15","Gwagwalada","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("279","15","Kuje","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("280","15","Kwali","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("281","15","Municipal Area Council","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("282","16","Akko","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("283","16","Balanga","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("284","16","Billiri","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("285","16","Dukku","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("286","16","Funakaye","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("287","16","Gombe","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("288","16","Kaltungo","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("289","16","Kwami","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("290","16","Nafada","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("291","16","Shongom","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("292","16","Yamaltu/Deba","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("293","17","Aboh Mbaise","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("294","17","Ahiazu Mbaise","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("295","17","Ehime Mbano","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("296","17","Ezinihitte","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("297","17","Ideato North","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("298","17","Ideato South","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("299","17","Ihitte/Uboma","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("300","17","Ikeduru","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("301","17","Isiala Mbano","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("302","17","Isu","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("303","17","Mbaitoli","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("304","17","Ngor Okpala","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("305","17","Njaba","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("306","17","Nkwerre","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("307","17","Nwangele","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("308","17","Obowo","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("309","17","Oguta","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("310","17","Ohaji/Egbema","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("311","17","Okigwe","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("312","17","Orlu","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("313","17","Orsu","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("314","17","Oru East","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("315","17","Oru West","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("316","17","Owerri Municipal","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("317","17","Owerri North","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("318","17","Owerri West","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("319","17","Unuimo","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("320","18","Auyo","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("321","18","Babura","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("322","18","Biriniwa","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("323","18","Birnin Kudu","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("324","18","Buji","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("325","18","Dutse","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("326","18","Gagarawa","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("327","18","Garki","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("328","18","Gumel","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("329","18","Guri","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("330","18","Gwaram","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("331","18","Gwiwa","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("332","18","Hadejia","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("333","18","Jahun","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("334","18","Kafin Hausa","","0","0","0000-00-00 00:00:00","0000-00-00 00