DROP TABLE assets;

CREATE TABLE `assets` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `action` varchar(255) NOT NULL COMMENT 'last action done',
  `done` int(5) NOT NULL COMMENT '0 not done, 1 done',
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE backups;

CREATE TABLE `backups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `file` varchar(255) NOT NULL,
  `status` int(5) NOT NULL COMMENT '0 - published, 1- unpublished, 2 - trashed, 3 - archived, 4- deleted from trash',
  `date_added` datetime NOT NULL,
  `date_trashed` datetime NOT NULL,
  `added_by` varchar(255) NOT NULL,
  `modified_by` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='Keep up to date file.sql backups';




DROP TABLE book_of_life;

CREATE TABLE `book_of_life` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `published` int(5) NOT NULL COMMENT '1 - published 0 - not published',
  `trashed` int(5) NOT NULL COMMENT '1- deleted to trash, 0 - not deleted to trash',
  `trash_delete` int(5) NOT NULL COMMENT '1 - yes , 0 - no..',
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `added_by` varchar(255) NOT NULL,
  `modified_by` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='This is a concept that gives all albums to a particular set u belong ';




DROP TABLE controls;

CREATE TABLE `controls` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL COMMENT 'different items to manage',
  `controls_value` varchar(255) NOT NULL COMMENT 'should contain dynamic strings with underscores',
  `description` text NOT NULL COMMENT 'briefly describing what the items are meant for',
  `status` int(5) NOT NULL COMMENT '0 - published, 1- unpublished, 2 - trashed, 3 - archived, 4- deleted from trash',
  `active` int(5) NOT NULL COMMENT '0 - inactive, 1 - active',
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `date_trashed` datetime NOT NULL,
  `added_by` varchar(255) NOT NULL,
  `modified_by` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1 COMMENT='This table keeps record whether all application modules are on or off';

INSERT INTO controls VALUES("1","application","","","1","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO controls VALUES("2","school_registration","","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO controls VALUES("3","school_fee_payment","","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO controls VALUES("4","admission_manager","","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO controls VALUES("5","Testingt","testing_controlst","                                descriptiont","1","1","2015-06-08 13:28:24","2015-06-09 06:02:03","2015-06-09 06:02:20","","ghost");
INSERT INTO controls VALUES("6","testing FACtt","testing_controlst","                                ffdsfs                                                                                                ","1","1","2015-06-08 13:29:48","2015-06-08 13:30:35","2015-06-08 13:30:03","ghost","ghost");



DROP TABLE courses;

CREATE TABLE `courses` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `department_id` int(11) NOT NULL,
  `description` text NOT NULL,
  `status` int(5) NOT NULL COMMENT '0 - published, 1- unpublished, 2 - trashed, 3 - archived, 4- deleted from trash',
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `date_trashed` datetime NOT NULL,
  `added_by` varchar(255) NOT NULL,
  `modified_by` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COMMENT='this table stores all courses related to departments';

INSERT INTO courses VALUES("1","Comp","CSC","20","                                                          dsgdfddggg                              ","0","2015-06-01 10:14:07","2015-06-01 10:56:00","2015-06-01 10:49:51","ghost","ghost");



DROP TABLE departments;

CREATE TABLE `departments` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `faculty_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `code` varchar(100) NOT NULL,
  `description` text NOT NULL,
  `status` int(5) NOT NULL COMMENT '0 - published, 1- unpublished, 2 - trashed, 3 - archived, 4- deleted from trash',
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `date_trashed` datetime NOT NULL,
  `added_by` varchar(255) NOT NULL,
  `modified_by` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=latin1 COMMENT='This table stores all the departments in the school and link';

INSERT INTO departments VALUES("1","1","MATHEMATICS","MTH","","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO departments VALUES("2","1","COMPUTER SCIENCE","CSC","","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO departments VALUES("3","1","GEOGRAPHY","GEO","","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO departments VALUES("4","1","CHEMISTRY ","CHM","","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO departments VALUES("5","1","PHYSICS","PHY","","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO departments VALUES("6","1","BIOLOGY","BIO","","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO departments VALUES("7","1","MICROBIOLOGY","MCB","","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO departments VALUES("8","1","BIOCHEMISTRY","BCH","","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO departments VALUES("9","2","FOOD SCIENCE","FST","","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO departments VALUES("10","2","GEOLOGY","GLG","","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO departments VALUES("11","3","AGRICULTURAL ECONOMICS","AGR","","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO departments VALUES("12","3","ANIMAL PRODUCTION","AGR","","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO departments VALUES("13","4","BUSINESS ADMINISTRATION","BUS","","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO departments VALUES("14","4","PUBLIC ADMINISTRATION","PAD","","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO departments VALUES("15","4","ACCOUNTING","ACC","","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO departments VALUES("16","4","POLITICAL SCIENCE","POL","","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO departments VALUES("17","4","SOCIOLOGY","SOC","","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO departments VALUES("18","4","ECONOMICS","ECO","","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO departments VALUES("19","5","ENGLISH","ENG","","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO departments VALUES("20","5","ARABIC","ARB","","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO departments VALUES("21","5","FRENCH","FRC","","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO departments VALUES("22","5","MASS COMMUNICATION","MCM","","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO departments VALUES("23","6","COUNSELING PSYCHOLOGY ","COP","","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO departments VALUES("24","6","HISTORY","HIS","","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO departments VALUES("25","6","SPORT AND HEALTH EDUCATION","SHE","","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO departments VALUES("26","6","ADULT EDUCATION AND CONTINUE STUDY","AEC","","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO departments VALUES("27","6","SCIENCE EDUCATION","SED","","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO departments VALUES("28","0","Comp","CSC","Computer Science : CSC. ","1","2015-05-27 21:27:04","0000-00-00 00:00:00","2015-05-28 18:32:35","ghost","");
INSERT INTO departments VALUES("29","3","JD FACt","FACt","                           gywusit","2","2015-05-28 11:31:16","2015-05-28 13:12:06","2015-06-01 10:22:22","ghost","ghost");



DROP TABLE events;

CREATE TABLE `events` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `image` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `archive` int(11) NOT NULL,
  `status` int(5) NOT NULL COMMENT '0 - published, 1- unpublished, 2 - trashed, 3 - archived, 4- deleted from trash',
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `date_trashed` datetime NOT NULL,
  `added_by` varchar(255) NOT NULL,
  `modified_by` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO events VALUES("1","Commissioning of the school portaltt","2015-06-12-203903Snapshot_20141022_(2).jpg","                                                                                       more details to follow soon..tt","0","1","2014-09-06 17:15:17","2015-06-12 20:40:45","2015-06-13 11:53:22","2014-04-02-0400-CBT","ghost");



DROP TABLE faculties;

CREATE TABLE `faculties` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'primary key of the table',
  `title` varchar(255) NOT NULL,
  `code` varchar(100) NOT NULL,
  `description` text NOT NULL,
  `status` int(5) NOT NULL COMMENT '0 - published, 1- unpublished, 2 - trashed, 3 - archived , 4- deleted from trash',
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `date_trashed` datetime NOT NULL,
  `date_archived` datetime NOT NULL,
  `added_by` varchar(255) NOT NULL,
  `modified_by` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1 COMMENT='this table keeps record of all faculties in the school';

INSERT INTO faculties VALUES("1","FACULTY OF NATURAL SCIENCE","FNS","","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","ghost","");
INSERT INTO faculties VALUES("2","FACULTY OF APPLIED AND TECHNOLOGY","FAT","","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","ghost","");
INSERT INTO faculties VALUES("3","FACULTY OF AGRICULTURE","FAG","","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","ghost","");
INSERT INTO faculties VALUES("4","FACULTY OF MANAGEMENT AND SOCIAL SCIENCE","FMS","","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","ghost","");
INSERT INTO faculties VALUES("5","FACULTY OF LANGUAGES AND COMMUNICATION","FLC","","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","ghost","");
INSERT INTO faculties VALUES("6","FACULTY OF EDUCATION AND ARTS","FEA","","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","ghost","");
INSERT INTO faculties VALUES("7","JD FAC","FNS","All i have                                 ","1","2015-05-27 13:06:38","0000-00-00 00:00:00","2015-06-18 11:22:36","0000-00-00 00:00:00","ghost","");
INSERT INTO faculties VALUES("8","testing FACt","FACt","t  hdfsiukflk                              ","1","2015-05-27 14:08:17","2015-05-27 15:10:19","2015-06-18 11:46:28","0000-00-00 00:00:00","ghost","ghost");



DROP TABLE generate_code;

CREATE TABLE `generate_code` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COMMENT='this table generates security code for all backend users';

INSERT INTO generate_code VALUES("1","119");



DROP TABLE hostel_categories;

CREATE TABLE `hostel_categories` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `hostel_site` int(11) NOT NULL COMMENT 'logical foreign key from hostel_sites',
  `published` int(5) NOT NULL COMMENT '1 - published 0 - not to published',
  `trashed` int(5) NOT NULL COMMENT '1- deleted to trash, 0 - not deleted to trash',
  `trash_delete` int(5) NOT NULL COMMENT '1 - cleared from trash , 0 - not cleared from trash',
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `added_by` varchar(255) NOT NULL,
  `modified_by` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1 COMMENT='table for different hostel categories';

INSERT INTO hostel_categories VALUES("1","KOBO MALE HOSTEL","the male hostel in kobo campus","1","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","ghost","");
INSERT INTO hostel_categories VALUES("2","KOBO FEMALE HOSTEL","The famel hostel in Kobo Campus","1","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","ghost","");
INSERT INTO hostel_categories VALUES("3","HOSTEL A (FEMALE HOSTEL P-SITE)","Hostel A is female hostel in psite ","2","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","ghost","");
INSERT INTO hostel_categories VALUES("4","HOSTEL B (MALE HOSTEL)","The male hostel in psite","2","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","ghost","");
INSERT INTO hostel_categories VALUES("5","HOSTEL C (FEMALE HOSTEL)","The Female hostel in Psite","2","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","ghost","");
INSERT INTO hostel_categories VALUES("6","OFF CAMPUS","those staying in off k","3","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","ghost","");



DROP TABLE hostel_sites;

CREATE TABLE `hostel_sites` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `published` int(5) NOT NULL COMMENT '1 - published 0 - not to published',
  `trashed` int(5) NOT NULL COMMENT '1- deleted to trash, 0 - not deleted to trash',
  `trash_delete` int(5) NOT NULL COMMENT '1 - cleared from trash , 0 - not cleared from trash',
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `added_by` varchar(255) NOT NULL,
  `modified_by` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COMMENT='This table stores all hostel/residents cartegories';

INSERT INTO hostel_sites VALUES("1","KOBO SITE","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","ghost","");
INSERT INTO hostel_sites VALUES("2","PERMANENT SITE","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","ghost","");
INSERT INTO hostel_sites VALUES("3","OFF CAMPUS","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","ghost","");



DROP TABLE ip_filter;

CREATE TABLE `ip_filter` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ips` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `status` int(5) NOT NULL COMMENT '0 - published, 1- unpublished, 2 - trashed, 3 - archived, 4- deleted from trash',
  `activate` int(5) NOT NULL COMMENT '0- for blocked , 1- active',
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `date_trashed` datetime NOT NULL,
  `added_by` varchar(255) NOT NULL,
  `modified_by` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=latin1 COMMENT='This table keeps record of all ips to be connected in d sys';

INSERT INTO ip_filter VALUES("1","::1","Ghost System","The system is for super administrator","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("5","192168431","","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("6","1921680203","","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("7","1921680202","","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("8","1921680204","","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("9","","1921680205","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("10","","1921680206","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("11","","1921680207","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("12","","1921680208","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("13","","1921680209","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("14","","1921680210","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("15","","1921680211","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("16","","1921680212","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("17","","1921680213","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("18","","1921680214","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("19","","1921680215","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("20","","1921680216","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("21","","1921680217","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("22","","1921680218","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("23","","1921680219","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("24","","1921680220","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("25","","1921680221","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("26","","1921680222","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("27","","1921680223","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("28","","1921680230","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("29","","1921680224","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("30","","1921680225","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("31","","1921680226","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("32","","1921680227","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("33","","1921680228","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("34","","1921680229","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("35","","1921680231","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("36","","1921680232","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("37","","1921680233","","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ip_filter VALUES("38","1922348043t","Lawal systemt","                                this is part of ust","1","0","2015-06-02 12:36:06","2015-06-02 15:24:27","2015-06-02 15:33:05","ghost","ghost");



DROP TABLE lga;

CREATE TABLE `lga` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `state_id` int(10) NOT NULL,
  `title` text NOT NULL,
  `description` text NOT NULL,
  `published` int(5) NOT NULL COMMENT '1 - published 0 - not to published',
  `trashed` int(5) NOT NULL COMMENT '1- deleted to trash, 0 - not deleted to trash',
  `trash_delete` int(5) NOT NULL COMMENT '1 - cleared from trash , 0 - not cleared from trash',
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `added_by` varchar(255) NOT NULL,
  `modified_by` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `state_id` (`state_id`)
) ENGINE=InnoDB AUTO_INCREMENT=775 DEFAULT CHARSET=utf32 COMMENT='Local governments in Nigeria.';

INSERT INTO lga VALUES("1","1","Aba North","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("2","1","Aba South","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("3","1","Arochukwu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("4","1","Bende","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("5","1","Ikwuano","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("6","1","Isiala Ngwa North","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("7","1","Isiala Ngwa South","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("8","1","Isuikwuato","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("9","1","Obi Ngwa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("10","1","Ohafia","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("11","1","Osisioma","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("12","1","Ugwunagbo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("13","1","Ukwa East","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("14","1","Ukwa West","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("15","1","Umuahia North","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("16","1","Umuahia South","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("17","1","Umu Nneochi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("18","2","Demsa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("19","2","Fufure","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("20","2","Ganye","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("21","2","Gayuk","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("22","2","Gombi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("23","2","Grie","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("24","2","Hong","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("25","2","Jada","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("26","2","Larmurde","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("27","2","Madagali","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("28","2","Maiha","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("29","2","Mayo Belwa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("30","2","Michika","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("31","2","Mubi North","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("32","2","Mubi South","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("33","2","Numan","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("34","2","Shelleng","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("35","2","Song","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("36","2","Toungo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("37","2","Yola North","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("38","2","Yola South","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("39","3","Abak","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("40","3","Eastern Obolo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("41","3","Eket","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("42","3","Esit Eket","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("43","3","Essien Udim","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("44","3","Etim Ekpo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("45","3","Etinan","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("46","3","Ibeno","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("47","3","Ibesikpo Asutan","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("48","3","Ibiono-Ibom","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("49","3","Ika","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("50","3","Ikono","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("51","3","Ikot Abasi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("52","3","Ikot Ekpene","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("53","3","Ini","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("54","3","Itu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("55","3","Mbo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("56","3","Mkpat-Enin","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("57","3","Nsit-Atai","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("58","3","Nsit-Ibom","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("59","3","Nsit-Ubium","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("60","3","Obot Akara","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("61","3","Okobo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("62","3","Onna","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("63","3","Oron","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("64","3","Oruk Anam","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("65","3","Udung-Uko","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("66","3","Ukanafun","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("67","3","Uruan","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("68","3","Urue-Offong/Oruko","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("69","3","Uyo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("70","4","Aguata","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("71","4","Anambra East","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("72","4","Anambra West","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("73","4","Anaocha","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("74","4","Awka North","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("75","4","Awka South","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("76","4","Ayamelum","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("77","4","Dunukofia","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("78","4","Ekwusigo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("79","4","Idemili North","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("80","4","Idemili South","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("81","4","Ihiala","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("82","4","Njikoka","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("83","4","Nnewi North","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("84","4","Nnewi South","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("85","4","Ogbaru","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("86","4","Onitsha North","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("87","4","Onitsha South","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("88","4","Orumba North","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("89","4","Orumba South","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("90","4","Oyi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("91","5","Alkaleri","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("92","5","Bauchi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("93","5","Bogoro","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("94","5","Damban","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("95","5","Darazo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("96","5","Dass","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("97","5","Gamawa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("98","5","Ganjuwa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("99","5","Giade","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("100","5","Itas/Gadau","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("101","5","Jama\'are","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("102","5","Katagum","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("103","5","Kirfi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("104","5","Misau","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("105","5","Ningi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("106","5","Shira","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("107","5","Tafawa Balewa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("108","5","Toro","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("109","5","Warji","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("110","5","Zaki","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("111","6","Brass","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("112","6","Ekeremor","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("113","6","Kolokuma/Opokuma","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("114","6","Nembe","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("115","6","Ogbia","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("116","6","Sagbama","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("117","6","Southern Ijaw","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("118","6","Yenagoa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("119","7","Agatu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("120","7","Apa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("121","7","Ado","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("122","7","Buruku","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("123","7","Gboko","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("124","7","Guma","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("125","7","Gwer East","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("126","7","Gwer West","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("127","7","Katsina-Ala","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("128","7","Konshisha","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("129","7","Kwande","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("130","7","Logo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("131","7","Makurdi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("132","7","Obi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("133","7","Ogbadibo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("134","7","Ohimini","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("135","7","Oju","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("136","7","Okpokwu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("137","7","Oturkpo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("138","7","Tarka","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("139","7","Ukum","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("140","7","Ushongo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("141","7","Vandeikya","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("142","8","Abadam","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("143","8","Askira/Uba","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("144","8","Bama","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("145","8","Bayo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("146","8","Biu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("147","8","Chibok","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("148","8","Damboa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("149","8","Dikwa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("150","8","Gubio","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("151","8","Guzamala","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("152","8","Gwoza","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("153","8","Hawul","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("154","8","Jere","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("155","8","Kaga","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("156","8","Kala/Balge","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("157","8","Konduga","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("158","8","Kukawa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("159","8","Kwaya Kusar","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("160","8","Mafa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("161","8","Magumeri","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("162","8","Maiduguri","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("163","8","Marte","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("164","8","Mobbar","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("165","8","Monguno","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("166","8","Ngala","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("167","8","Nganzai","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("168","8","Shani","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("169","9","Abi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("170","9","Akamkpa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("171","9","Akpabuyo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("172","9","Bakassi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("173","9","Bekwarra","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("174","9","Biase","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("175","9","Boki","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("176","9","Calabar Municipal","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("177","9","Calabar South","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("178","9","Etung","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("179","9","Ikom","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("180","9","Obanliku","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("181","9","Obubra","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("182","9","Obudu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("183","9","Odukpani","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("184","9","Ogoja","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("185","9","Yakuur","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("186","9","Yala","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("187","10","Aniocha North","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("188","10","Aniocha South","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("189","10","Bomadi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("190","10","Burutu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("191","10","Ethiope East","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("192","10","Ethiope West","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("193","10","Ika North East","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("194","10","Ika South","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("195","10","Isoko North","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("196","10","Isoko South","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("197","10","Ndokwa East","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("198","10","Ndokwa West","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("199","10","Okpe","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("200","10","Oshimili North","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("201","10","Oshimili South","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("202","10","Patani","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("203","10","Sapele, Delta","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("204","10","Udu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("205","10","Ughelli North","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("206","10","Ughelli South","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("207","10","Ukwuani","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("208","10","Uvwie","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("209","10","Warri North","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("210","10","Warri South","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("211","10","Warri South West","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("212","11","Abakaliki","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("213","11","Afikpo North","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("214","11","Afikpo South","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("215","11","Ebonyi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("216","11","Ezza North","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("217","11","Ezza South","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("218","11","Ikwo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("219","11","Ishielu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("220","11","Ivo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("221","11","Izzi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("222","11","Ohaozara","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("223","11","Ohaukwu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("224","11","Onicha","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("225","12","Akoko-Edo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("226","12","Egor","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("227","12","Esan Central","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("228","12","Esan North-East","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("229","12","Esan South-East","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("230","12","Esan West","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("231","12","Etsako Central","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("232","12","Etsako East","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("233","12","Etsako West","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("234","12","Igueben","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("235","12","Ikpoba Okha","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("236","12","Orhionmwon","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("237","12","Oredo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("238","12","Ovia North-East","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("239","12","Ovia South-West","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("240","12","Owan East","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("241","12","Owan West","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("242","12","Uhunmwonde","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("243","13","Ado Ekiti","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("244","13","Efon","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("245","13","Ekiti East","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("246","13","Ekiti South-West","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("247","13","Ekiti West","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("248","13","Emure","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("249","13","Gbonyin","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("250","13","Ido Osi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("251","13","Ijero","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("252","13","Ikere","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("253","13","Ikole","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("254","13","Ilejemeje","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("255","13","Irepodun/Ifelodun","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("256","13","Ise/Orun","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("257","13","Moba","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("258","13","Oye","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("259","14","Aninri","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("260","14","Awgu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("261","14","Enugu East","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("262","14","Enugu North","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("263","14","Enugu South","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("264","14","Ezeagu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("265","14","Igbo Etiti","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("266","14","Igbo Eze North","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("267","14","Igbo Eze South","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("268","14","Isi Uzo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("269","14","Nkanu East","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("270","14","Nkanu West","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("271","14","Nsukka","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("272","14","Oji River","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("273","14","Udenu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("274","14","Udi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("275","14","Uzo Uwani","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("276","15","Abaji","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("277","15","Bwari","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("278","15","Gwagwalada","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("279","15","Kuje","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("280","15","Kwali","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("281","15","Municipal Area Council","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("282","16","Akko","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("283","16","Balanga","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("284","16","Billiri","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("285","16","Dukku","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("286","16","Funakaye","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("287","16","Gombe","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("288","16","Kaltungo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("289","16","Kwami","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("290","16","Nafada","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("291","16","Shongom","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("292","16","Yamaltu/Deba","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("293","17","Aboh Mbaise","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("294","17","Ahiazu Mbaise","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("295","17","Ehime Mbano","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("296","17","Ezinihitte","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("297","17","Ideato North","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("298","17","Ideato South","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("299","17","Ihitte/Uboma","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("300","17","Ikeduru","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("301","17","Isiala Mbano","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("302","17","Isu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("303","17","Mbaitoli","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("304","17","Ngor Okpala","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("305","17","Njaba","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("306","17","Nkwerre","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("307","17","Nwangele","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("308","17","Obowo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("309","17","Oguta","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("310","17","Ohaji/Egbema","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("311","17","Okigwe","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("312","17","Orlu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("313","17","Orsu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("314","17","Oru East","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("315","17","Oru West","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("316","17","Owerri Municipal","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("317","17","Owerri North","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("318","17","Owerri West","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("319","17","Unuimo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("320","18","Auyo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("321","18","Babura","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("322","18","Biriniwa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("323","18","Birnin Kudu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("324","18","Buji","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("325","18","Dutse","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("326","18","Gagarawa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("327","18","Garki","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("328","18","Gumel","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("329","18","Guri","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("330","18","Gwaram","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("331","18","Gwiwa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("332","18","Hadejia","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("333","18","Jahun","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("334","18","Kafin Hausa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("335","18","Kazaure","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("336","18","Kiri Kasama","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("337","18","Kiyawa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("338","18","Kaugama","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("339","18","Maigatari","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("340","18","Malam Madori","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("341","18","Miga","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("342","18","Ringim","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("343","18","Roni","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("344","18","Sule Tankarkar","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("345","18","Taura","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("346","18","Yankwashi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("347","19","Birnin Gwari","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("348","19","Chikun","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("349","19","Giwa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("350","19","Igabi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("351","19","Ikara","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("352","19","Jaba","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("353","19","Jema\'a","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("354","19","Kachia","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("355","19","Kaduna North","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("356","19","Kaduna South","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("357","19","Kagarko","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("358","19","Kajuru","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("359","19","Kaura","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("360","19","Kauru","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("361","19","Kubau","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("362","19","Kudan","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("363","19","Lere","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("364","19","Makarfi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("365","19","Sabon Gari","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("366","19","Sanga","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("367","19","Soba","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("368","19","Zangon Kataf","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("369","19","Zaria","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("370","20","Ajingi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("371","20","Albasu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("372","20","Bagwai","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("373","20","Bebeji","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("374","20","Bichi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("375","20","Bunkure","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("376","20","Dala","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("377","20","Dambatta","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("378","20","Dawakin Kudu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("379","20","Dawakin Tofa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("380","20","Doguwa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("381","20","Fagge","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("382","20","Gabasawa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("383","20","Garko","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("384","20","Garun Mallam","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("385","20","Gaya","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("386","20","Gezawa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("387","20","Gwale","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("388","20","Gwarzo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("389","20","Kabo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("390","20","Kano Municipal","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("391","20","Karaye","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("392","20","Kibiya","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("393","20","Kiru","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("394","20","Kumbotso","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("395","20","Kunchi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("396","20","Kura","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("397","20","Madobi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("398","20","Makoda","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("399","20","Minjibir","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("400","20","Nasarawa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("401","20","Rano","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("402","20","Rimin Gado","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("403","20","Rogo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("404","20","Shanono","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("405","20","Sumaila","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("406","20","Takai","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("407","20","Tarauni","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("408","20","Tofa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("409","20","Tsanyawa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("410","20","Tudun Wada","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("411","20","Ungogo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("412","20","Warawa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("413","20","Wudil","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("414","21","Bakori","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("415","21","Batagarawa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("416","21","Batsari","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("417","21","Baure","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("418","21","Bindawa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("419","21","Charanchi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("420","21","Dandume","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("421","21","Danja","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("422","21","Dan Musa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("423","21","Daura","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("424","21","Dutsi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("425","21","Dutsin Ma","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("426","21","Faskari","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("427","21","Funtua","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("428","21","Ingawa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("429","21","Jibia","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("430","21","Kafur","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("431","21","Kaita","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("432","21","Kankara","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("433","21","Kankia","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("434","21","Katsina","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("435","21","Kurfi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("436","21","Kusada","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("437","21","Mai\'Adua","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("438","21","Malumfashi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("439","21","Mani","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("440","21","Mashi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("441","21","Matazu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("442","21","Musawa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("443","21","Rimi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("444","21","Sabuwa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("445","21","Safana","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("446","21","Sandamu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("447","21","Zango","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("448","22","Aleiro","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("449","22","Arewa Dandi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("450","22","Argungu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("451","22","Augie","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("452","22","Bagudo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("453","22","Birnin Kebbi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("454","22","Bunza","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("455","22","Dandi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("456","22","Fakai","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("457","22","Gwandu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("458","22","Jega","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("459","22","Kalgo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("460","22","Koko/Besse","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("461","22","Maiyama","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("462","22","Ngaski","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("463","22","Sakaba","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("464","22","Shanga","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("465","22","Suru","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("466","22","Wasagu/Danko","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("467","22","Yauri","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("468","22","Zuru","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("469","23","Adavi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("470","23","Ajaokuta","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("471","23","Ankpa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("472","23","Bassa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("473","23","Dekina","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("474","23","Ibaji","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("475","23","Idah","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("476","23","Igalamela Odolu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("477","23","Ijumu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("478","23","Kabba/Bunu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("479","23","Kogi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("480","23","Lokoja","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("481","23","Mopa Muro","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("482","23","Ofu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("483","23","Ogori/Magongo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("484","23","Okehi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("485","23","Okene","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("486","23","Olamaboro","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("487","23","Omala","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("488","23","Yagba East","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("489","23","Yagba West","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("490","24","Asa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("491","24","Baruten","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("492","24","Edu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("493","24","Ekiti, Kwara State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("494","24","Ifelodun","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("495","24","Ilorin East","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("496","24","Ilorin South","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("497","24","Ilorin West","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("498","24","Irepodun","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("499","24","Isin","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("500","24","Kaiama","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("501","24","Moro","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("502","24","Offa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("503","24","Oke Ero","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("504","24","Oyun","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("505","24","Pategi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("506","25","Agege","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("507","25","Ajeromi-Ifelodun","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("508","25","Alimosho","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("509","25","Amuwo-Odofin","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("510","25","Apapa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("511","25","Badagry","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("512","25","Epe","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("513","25","Eti Osa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("514","25","Ibeju-Lekki","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("515","25","Ifako-Ijaiye","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("516","25","Ikeja","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("517","25","Ikorodu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("518","25","Kosofe","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("519","25","Lagos Island","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("520","25","Lagos Mainland","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("521","25","Mushin","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("522","25","Ojo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("523","25","Oshodi-Isolo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("524","25","Shomolu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("525","25","Surulere, Lagos State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("526","26","Akwanga","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("527","26","Awe","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("528","26","Doma","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("529","26","Karu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("530","26","Keana","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("531","26","Keffi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("532","26","Kokona","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("533","26","Lafia","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("534","26","Nasarawa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("535","26","Nasarawa Egon","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("536","26","Obi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("537","26","Toto","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("538","26","Wamba","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("539","27","Agaie","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("540","27","Agwara","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("541","27","Bida","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("542","27","Borgu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("543","27","Bosso","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("544","27","Chanchaga","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("545","27","Edati","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("546","27","Gbako","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("547","27","Gurara","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("548","27","Katcha","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("549","27","Kontagora","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("550","27","Lapai","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("551","27","Lavun","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("552","27","Magama","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("553","27","Mariga","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("554","27","Mashegu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("555","27","Mokwa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("556","27","Moya","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("557","27","Paikoro","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("558","27","Rafi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("559","27","Rijau","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("560","27","Shiroro","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("561","27","Suleja","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("562","27","Tafa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("563","27","Wushishi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("564","28","Abeokuta North","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("565","28","Abeokuta South","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("566","28","Ado-Odo/Ota","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("567","28","Egbado North","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("568","28","Egbado South","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("569","28","Ewekoro","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("570","28","Ifo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("571","28","Ijebu East","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("572","28","Ijebu North","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("573","28","Ijebu North East","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("574","28","Ijebu Ode","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("575","28","Ikenne","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("576","28","Imeko Afon","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("577","28","Ipokia","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("578","28","Obafemi Owode","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("579","28","Odeda","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("580","28","Odogbolu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("581","28","Ogun Waterside","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("582","28","Remo North","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("583","28","Shagamu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("584","29","Akoko North-East","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("585","29","Akoko North-West","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("586","29","Akoko South-West","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("587","29","Akoko South-East","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("588","29","Akure North","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("589","29","Akure South","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("590","29","Ese Odo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("591","29","Idanre","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("592","29","Ifedore","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("593","29","Ilaje","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("594","29","Ile Oluji/Okeigbo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("595","29","Irele","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("596","29","Odigbo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("597","29","Okitipupa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("598","29","Ondo East","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("599","29","Ondo West","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("600","29","Ose","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("601","29","Owo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("602","30","Atakunmosa East","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("603","30","Atakunmosa West","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("604","30","Aiyedaade","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("605","30","Aiyedire","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("606","30","Boluwaduro","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("607","30","Boripe","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("608","30","Ede North","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("609","30","Ede South","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("610","30","Ife Central","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("611","30","Ife East","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("612","30","Ife North","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("613","30","Ife South","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("614","30","Egbedore","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("615","30","Ejigbo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("616","30","Ifedayo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("617","30","Ifelodun","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("618","30","Ila","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("619","30","Ilesa East","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("620","30","Ilesa West","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("621","30","Irepodun","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("622","30","Irewole","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("623","30","Isokan","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("624","30","Iwo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("625","30","Obokun","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("626","30","Odo Otin","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("627","30","Ola Oluwa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("628","30","Olorunda","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("629","30","Oriade","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("630","30","Orolu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("631","30","Osogbo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("632","31","Afijio","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("633","31","Akinyele","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("634","31","Atiba","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("635","31","Atisbo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("636","31","Egbeda","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("637","31","Ibadan North","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("638","31","Ibadan North-East","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("639","31","Ibadan North-West","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("640","31","Ibadan South-East","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("641","31","Ibadan South-West","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("642","31","Ibarapa Central","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("643","31","Ibarapa East","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("644","31","Ibarapa North","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("645","31","Ido","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("646","31","Irepo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("647","31","Iseyin","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("648","31","Itesiwaju","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("649","31","Iwajowa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("650","31","Kajola","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("651","31","Lagelu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("652","31","Ogbomosho North","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("653","31","Ogbomosho South","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("654","31","Ogo Oluwa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("655","31","Olorunsogo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("656","31","Oluyole","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("657","31","Ona Ara","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("658","31","Orelope","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("659","31","Ori Ire","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("660","31","Oyo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("661","31","Oyo East","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("662","31","Saki East","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("663","31","Saki West","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("664","31","Surulere, Oyo State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("665","32","Bokkos","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("666","32","Barkin Ladi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("667","32","Bassa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("668","32","Jos East","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("669","32","Jos North","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("670","32","Jos South","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("671","32","Kanam","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("672","32","Kanke","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("673","32","Langtang South","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("674","32","Langtang North","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("675","32","Mangu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("676","32","Mikang","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("677","32","Pankshin","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("678","32","Qua\'an Pan","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("679","32","Riyom","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("680","32","Shendam","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("681","32","Wase","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("682","33","Abua/Odual","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("683","33","Ahoada East","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("684","33","Ahoada West","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("685","33","Akuku-Toru","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("686","33","Andoni","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("687","33","Asari-Toru","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("688","33","Bonny","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("689","33","Degema","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("690","33","Eleme","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("691","33","Emuoha","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("692","33","Etche","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("693","33","Gokana","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("694","33","Ikwerre","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("695","33","Khana","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("696","33","Obio/Akpor","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("697","33","Ogba/Egbema/Ndoni","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("698","33","Ogu/Bolo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("699","33","Okrika","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("700","33","Omuma","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("701","33","Opobo/Nkoro","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("702","33","Oyigbo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("703","33","Port Harcourt","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("704","33","Tai","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("705","34","Binji","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("706","34","Bodinga","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("707","34","Dange Shuni","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("708","34","Gada","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("709","34","Goronyo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("710","34","Gudu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("711","34","Gwadabawa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("712","34","Illela","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("713","34","Isa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("714","34","Kebbe","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("715","34","Kware","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("716","34","Rabah","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("717","34","Sabon Birni","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("718","34","Shagari","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("719","34","Silame","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("720","34","Sokoto North","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("721","34","Sokoto South","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("722","34","Tambuwal","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("723","34","Tangaza","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("724","34","Tureta","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("725","34","Wamako","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("726","34","Wurno","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("727","34","Yabo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("728","35","Ardo Kola","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("729","35","Bali","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("730","35","Donga","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("731","35","Gashaka","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("732","35","Gassol","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("733","35","Ibi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("734","35","Jalingo","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("735","35","Karim Lamido","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("736","35","Kumi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("737","35","Lau","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("738","35","Sardauna","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("739","35","Takum","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("740","35","Ussa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("741","35","Wukari","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("742","35","Yorro","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("743","35","Zing","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("744","36","Bade","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("745","36","Bursari","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("746","36","Damaturu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("747","36","Fika","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("748","36","Fune","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("749","36","Geidam","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("750","36","Gujba","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("751","36","Gulani","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("752","36","Jakusko","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("753","36","Karasuwa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("754","36","Machina","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("755","36","Nangere","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("756","36","Nguru","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("757","36","Potiskum","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("758","36","Tarmuwa","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("759","36","Yunusari","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("760","36","Yusufari","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("761","37","Anka","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("762","37","Bakura","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("763","37","Birnin Magaji/Kiyaw","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("764","37","Bukkuyum","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("765","37","Bungudu","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("766","37","Gummi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("767","37","Gusau","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("768","37","Kaura Namoda","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("769","37","Maradun","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("770","37","Maru","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("771","37","Shinkafi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("772","37","Talata Mafara","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("773","37","Chafe","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO lga VALUES("774","37","Zurmi","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");



DROP TABLE news;

CREATE TABLE `news` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'primary key of the table',
  `title` varchar(255) NOT NULL,
  `image` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `archive` int(5) NOT NULL COMMENT 'on archive',
  `status` int(5) NOT NULL COMMENT '0 - published, 1- unpublished, 2 - trashed, 3 - archived, 4- deleted from trash',
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `date_trashed` datetime NOT NULL,
  `added_by` varchar(255) NOT NULL,
  `modified_by` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

INSERT INTO news VALUES("1"," 2014/2015 academic session online sales of forms .. ","logo.png","","0","1","2014-09-06 16:59:34","2014-09-06 17:44:05","0000-00-00 00:00:00","2014-04-02-0400-CBT","");
INSERT INTO news VALUES("2","NOTICE! NOTICE!! NOTICE!!!","post2.jpg","Interested Applicants within Minna Metropolis can apply via the school (School of Midwifery) ICT Center.<br><br>OR Contact the following no.s <br><br>08039678713, 07036829290<br> ","0","0","2014-09-14 21:52:21","2014-09-14 21:53:45","0000-00-00 00:00:00","2014-04-02-0400-CBT","");
INSERT INTO news VALUES("3","entrance examination is on 29th of November, 2014","Snapshot_20141022_(2).jpg"," at the school examination hall. please come along with evidence of your online form payment receipt and your transactional ID  ","0","0","2014-11-25 16:16:48","2015-06-11 08:01:14","0000-00-00 00:00:00","2014-04-02-0400-CBT","");
INSERT INTO news VALUES("4","Mist","Snapshot_20141022_(2).jpg","                              erwerterd                                                                                          ","0","1","2015-06-11 07:59:34","2015-06-11 08:33:39","2015-06-11 08:36:45","ghost","ghost");
INSERT INTO news VALUES("5","Comp","2015-06-11-081151Snapshot_20141022_(2).jpg","                              sfref                                                                                          ","0","0","2015-06-11 08:11:51","2015-06-11 08:32:54","0000-00-00 00:00:00","ghost","ghost");
INSERT INTO news VALUES("6","testing FACttt","2015-06-11-082536picture001.jpg","                              weerwrtttt","0","2","2015-06-11 08:16:45","2015-06-11 08:25:36","2015-06-11 08:40:56","ghost","");



DROP TABLE pictures;

CREATE TABLE `pictures` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `image` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `archive` int(11) NOT NULL,
  `carts` varchar(255) NOT NULL,
  `status` int(5) NOT NULL,
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `date_trashed` datetime NOT NULL,
  `added_by` varchar(255) NOT NULL,
  `modified_by` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1 COMMENT='keeps all pictures';

INSERT INTO pictures VALUES("2","kjhfuifpwl","pkpd-761m-951-r.jpg","ufskyfwsowifuiyefow ","0","","1","2015-02-27 13:14:26","0000-00-00 00:00:00","2015-06-13 12:41:22","ghost","");
INSERT INTO pictures VALUES("3","khuorp;/","pkpd-761m-951-r.jpg"," ","0","","0","2015-03-02 19:26:25","0000-00-00 00:00:00","0000-00-00 00:00:00","ghost","");
INSERT INTO pictures VALUES("4","testing FACttt","Snapshot_2014303.jpg","                                     fdfgdfdt5t","0","","1","2015-06-13 11:54:49","2015-06-13 12:36:32","2015-06-13 12:38:10","ghost","");



DROP TABLE roles;

CREATE TABLE `roles` (
  `role_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `role_title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `published` int(5) NOT NULL COMMENT '1 - published 0 - not published',
  `trashed` int(5) NOT NULL COMMENT '1 = delete to trash 0 not in trash',
  `trash_delete` int(5) NOT NULL COMMENT '1 cleared from trash 0  ot cleared from trash',
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `date_trashed` datetime NOT NULL,
  `added_by` varchar(255) NOT NULL,
  `modified_by` varchar(255) NOT NULL,
  PRIMARY KEY (`role_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COMMENT='stores information about different categories of users or candidates';

INSERT INTO roles VALUES("1","System User","users that manage the solution","1","0","0","2014-03-13 09:23:00","0000-00-00 00:00:00","0000-00-00 00:00:00","0","");
INSERT INTO roles VALUES("2","Candidates","Users that come to sign up in the system  ","1","0","0","2014-03-13 00:00:00","2014-05-15 13:43:51","0000-00-00 00:00:00","0","");
INSERT INTO roles VALUES("3","Mist","						  						  The Mis guyst ","1","0","0","2015-05-25 19:16:26","2015-05-26 10:18:16","2015-05-26 08:53:08","ghost","ghost");



DROP TABLE school_fee_payment;

CREATE TABLE `school_fee_payment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `card_pin` varchar(255) NOT NULL,
  `card_serialno` varchar(255) NOT NULL,
  `payment_year` year(4) NOT NULL,
  `session` varchar(20) NOT NULL,
  `payment_status` int(11) NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO school_fee_payment VALUES("1","3","14541092559","22859513621613","2015","2015/1","1","2015-03-23 00:00:00");



DROP TABLE staff_log;

CREATE TABLE `staff_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stduent_id` int(11) NOT NULL,
  `log_action` varchar(300) NOT NULL,
  `log_date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='keeps tracking activities of staff';




DROP TABLE staff_ranks;

CREATE TABLE `staff_ranks` (
  `rank_id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `published` int(5) NOT NULL COMMENT '1 - published 0 - not to published',
  `trashed` int(5) NOT NULL COMMENT '1- deleted to trash, 0 - not deleted to trash',
  `trash_delete` int(5) NOT NULL COMMENT '1 - cleared from trash , 0 - not cleared from trash',
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `added_by` varchar(255) NOT NULL,
  `modified_by` varchar(255) NOT NULL,
  PRIMARY KEY (`rank_id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 COMMENT='This keeps all ranks attached to staff in the institution';

INSERT INTO staff_ranks VALUES("1","Directorer","directs","0","0","0","0000-00-00 00:00:00","2013-09-03 12:24:45","asuleimanlapai@yahoo.com","");
INSERT INTO staff_ranks VALUES("2","commisioner","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO staff_ranks VALUES("4","pA ","persona asddffff ","0","0","0","2013-08-03 17:30:10","0000-00-00 00:00:00","asuleimanlapai@yahoo.com","");
INSERT INTO staff_ranks VALUES("5","commisner","trelhyld ","0","0","0","2013-08-11 14:34:42","0000-00-00 00:00:00","asuleimanlapai@yahoo.com","");



DROP TABLE state;

CREATE TABLE `state` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` text NOT NULL,
  `description` text NOT NULL,
  `published` int(5) NOT NULL COMMENT '1 - published 0 - not to published',
  `trashed` int(5) NOT NULL COMMENT '1- deleted to trash, 0 - not deleted to trash',
  `trash_delete` int(5) NOT NULL COMMENT '1 - cleared from trash , 0 - not cleared from trash',
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `added_by` varchar(255) NOT NULL,
  `modified_by` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf32 COMMENT='States in Nigeria.';

INSERT INTO state VALUES("1","Abia State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO state VALUES("2","Adamawa State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO state VALUES("3","Akwa Ibom State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO state VALUES("4","Anambra State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO state VALUES("5","Bauchi State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO state VALUES("6","Bayelsa State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO state VALUES("7","Benue State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO state VALUES("8","Borno State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO state VALUES("9","Cross River State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO state VALUES("10","Delta State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO state VALUES("11","Ebonyi State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO state VALUES("12","Edo State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO state VALUES("13","Ekiti State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO state VALUES("14","Enugu State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO state VALUES("15","FCT","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO state VALUES("16","Gombe State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO state VALUES("17","Imo State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO state VALUES("18","Jigawa State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO state VALUES("19","Kaduna State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO state VALUES("20","Kano State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO state VALUES("21","Katsina State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO state VALUES("22","Kebbi State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO state VALUES("23","Kogi State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO state VALUES("24","Kwara State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO state VALUES("25","Lagos State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO state VALUES("26","Nasarawa State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO state VALUES("27","Niger State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO state VALUES("28","Ogun State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO state VALUES("29","Ondo State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO state VALUES("30","Osun State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO state VALUES("31","Oyo State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO state VALUES("32","Plateau State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO state VALUES("33","Rivers State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO state VALUES("34","Sokoto State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO state VALUES("35","Taraba State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO state VALUES("36","Yobe State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO state VALUES("37","Zamfara State","","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");



DROP TABLE student_log;

CREATE TABLE `student_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stduent_id` int(11) NOT NULL,
  `log_action` varchar(300) NOT NULL,
  `log_date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='keeps tracking the activities of student';




DROP TABLE students;

CREATE TABLE `students` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` int(11) NOT NULL COMMENT 'user group id from user_groups',
  `role_id` int(11) NOT NULL,
  `type_id` int(11) NOT NULL COMMENT 'This tells whether UG or PG 1- UG, 2 - PG',
  `cart_id` int(11) NOT NULL COMMENT 'this tells whether a student is full time or part time',
  `course_id` int(11) NOT NULL,
  `department_id` int(11) NOT NULL,
  `faculty_id` int(11) NOT NULL,
  `state_id` int(11) NOT NULL,
  `lga_id` int(11) NOT NULL,
  `hostel_id` int(11) NOT NULL,
  `first_name` varchar(255) NOT NULL,
  `other_names` varchar(255) NOT NULL,
  `gender` varchar(255) NOT NULL,
  `number` varchar(255) NOT NULL,
  `username` varchar(100) NOT NULL,
  `password` char(100) NOT NULL,
  `email` varchar(255) NOT NULL,
  `birthdate` varchar(255) NOT NULL,
  `phone_number` varchar(255) NOT NULL,
  `security_id` varchar(255) NOT NULL,
  `address` text NOT NULL,
  `image` varchar(255) NOT NULL,
  `mode_of_entry` int(11) NOT NULL COMMENT '1- starter, 2- Direct Entry (DE), 3 - Transfer ',
  `user_status` int(5) NOT NULL COMMENT '0 for blocked, 1 fior active',
  `online_status` int(5) NOT NULL COMMENT '0 for offline and 1 for online',
  `ontoken` int(20) NOT NULL,
  `last_login_ip` varchar(255) NOT NULL,
  `last_login` datetime NOT NULL,
  `last_logout` datetime NOT NULL,
  `town` varchar(255) NOT NULL,
  `level` varchar(25) NOT NULL,
  `published` int(5) NOT NULL COMMENT '1 - published 0 - not to published',
  `trashed` int(5) NOT NULL COMMENT '1- deleted to trash, 0 - not deleted to trash',
  `trash_delete` int(5) NOT NULL COMMENT '1 - cleared from trash , 0 - not cleared from trash',
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `added_by` varchar(255) NOT NULL,
  `modified_by` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `number` (`number`),
  UNIQUE KEY `username` (`username`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='this table holds information about students and activities';




DROP TABLE subjects;

CREATE TABLE `subjects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `department_id` int(11) NOT NULL,
  `course_id` int(11) NOT NULL,
  `title` varchar(100) NOT NULL,
  `code` varchar(30) NOT NULL,
  `unit` varchar(30) NOT NULL,
  `description` text NOT NULL,
  `level` varchar(20) NOT NULL,
  `semester` int(11) NOT NULL COMMENT 'keeps record of semester 1st or 2nd',
  `status` int(5) NOT NULL COMMENT '0 - published, 1- unpublished, 2 - trashed, 3 - archived, 4- deleted from trash',
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `date_trashed` datetime NOT NULL,
  `added_by` varchar(255) NOT NULL,
  `modified_by` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=latin1;

INSERT INTO subjects VALUES("1","1","2","Communication in English","GNS102","2","General Course                      ","100","1","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO subjects VALUES("2","1","2","Professional Ethics","CHE211","1","Professional Ethics","100","1","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO subjects VALUES("3","1","2","Anatomy and  Physiology","CHE212","4","Anatomy and  Physiology","100","1","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO subjects VALUES("4","1","2","Information Education and Communication","CHE213","3","Information Education and Communication","100","1","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO subjects VALUES("5","1","2","Introduction to Medical Sociology","GNS213","3","Introduction to Medical Sociology","100","1","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO subjects VALUES("6","1","2","Human Nutrition","CHE214","1","Human Nutrition","100","1","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO subjects VALUES("7","1","2","Introduction to Environmental Health","EHT111","2","Introduction to Environmental Health","100","1","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO subjects VALUES("8","1","2","Introduction to Primary Health Care","CHE215","2","Introduction to Primary Healthcare","100","1","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO subjects VALUES("9","1","2","General and Physical Chemistry","BCH111","1","General and Physical Chemistry","100","1","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO subjects VALUES("10","1","2","Citizenship","  GNS111","1","Citizenship","100","1","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO subjects VALUES("11","1","2","Introduction to Psycology","  GNS411","3","Introduction to Psycology","100","2","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO subjects VALUES("12","1","2","Use of Standing Orders","CHE221","3","Use of Standing Orders","100","2","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO subjects VALUES("13","1","2","Supervised Clinical Experience (SCE) I","CHE222","4","Supervised Clinical Experience (SCE) I","100","2","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO subjects VALUES("14","1","2","Clinical Skills I","  CHE223","4","Clinical Skills I","100","2","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO subjects VALUES("15","1","2","Reproductive Health","CHE224","4","Reproductive Health","100","2","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO subjects VALUES("16","1","2","Immunity and Immunization ","CHE225","2","Immunity and Immunization ","100","2","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO subjects VALUES("17","1","2","Geography","FOT111","1","Geography","100","2","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO subjects VALUES("18","13","1","testing FACtt","CSC101t","3t","                                dasdst","400","2","2","2015-06-01 12:54:01","2015-06-01 13:17:16","2015-06-09 14:25:51","ghost","ghost");



DROP TABLE system;

CREATE TABLE `system` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `last_backup_date` date NOT NULL,
  `description` text NOT NULL,
  `message` text NOT NULL COMMENT 'This holds a shot message that appeas on the notification bar when users login',
  `webapp_status` int(2) NOT NULL COMMENT 'This determines if the web app is active (1) of disabled(0) ',
  `mobileapp_status` int(2) NOT NULL COMMENT 'This determines if the mobile app is active (1) of disabled(0) ',
  `published` int(5) NOT NULL COMMENT '1 - published 0 - not to published',
  `trashed` int(5) NOT NULL COMMENT '1- deleted to trash, 0 - not deleted to trash',
  `trash_delete` int(5) NOT NULL COMMENT '1 - cleared from trash , 0 - not cleared from trash',
  `added_by` varchar(255) NOT NULL,
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `modified_by` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE ug_students_subjects;

CREATE TABLE `ug_students_subjects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `department_id` int(11) NOT NULL,
  `course_id` int(11) NOT NULL,
  `subject_id` int(11) NOT NULL,
  `subject_unit` varchar(255) NOT NULL,
  `year` year(4) NOT NULL,
  `published` int(5) NOT NULL COMMENT '1 - published 0 - not to published',
  `trashed` int(5) NOT NULL COMMENT '1- deleted to trash, 0 - not deleted to trash',
  `trash_delete` int(5) NOT NULL COMMENT '1 - cleared from trash , 0 - not cleared from trash',
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `added_by` varchar(255) NOT NULL,
  `modified_by` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=latin1 COMMENT='under graduate student registered courses';

INSERT INTO ug_students_subjects VALUES("1","3","1","2","1","2","2015","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ug_students_subjects VALUES("2","3","1","2","2","1","2015","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ug_students_subjects VALUES("3","3","1","2","3","4","2015","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ug_students_subjects VALUES("4","3","1","2","4","3","2015","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ug_students_subjects VALUES("5","3","1","2","5","3","2015","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ug_students_subjects VALUES("6","3","1","2","6","1","2015","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ug_students_subjects VALUES("7","3","1","2","7","2","2015","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ug_students_subjects VALUES("8","3","1","2","8","2","2015","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ug_students_subjects VALUES("9","3","1","2","9","1","2015","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ug_students_subjects VALUES("10","3","1","2","10","1","2015","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ug_students_subjects VALUES("11","3","1","2","11","3","2015","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ug_students_subjects VALUES("12","3","1","2","12","3","2015","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ug_students_subjects VALUES("13","3","1","2","13","4","2015","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ug_students_subjects VALUES("14","3","1","2","14","4","2015","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ug_students_subjects VALUES("15","3","1","2","15","4","2015","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ug_students_subjects VALUES("16","3","1","2","16","2","2015","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO ug_students_subjects VALUES("17","3","1","2","17","1","2015","0","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","","");



DROP TABLE user_groups;

CREATE TABLE `user_groups` (
  `user_group_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `header_menu` varchar(255) NOT NULL,
  `toolbar_menu` varchar(255) NOT NULL,
  `home_menu` varchar(255) NOT NULL,
  `published` int(5) NOT NULL COMMENT '1 - published 0 - not to published',
  `trashed` int(5) NOT NULL COMMENT '1- deleted to trash, 0 - not deleted to trash',
  `trash_delete` int(5) NOT NULL COMMENT '1 - cleared from trash , 0 - not cleared from trash',
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `date_trashed` datetime NOT NULL,
  `added_by` varchar(255) NOT NULL,
  `modified_by` varchar(255) NOT NULL,
  PRIMARY KEY (`user_group_id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

INSERT INTO user_groups VALUES("1","_superadministrators","This role is a special one that gives total access to control panel, in header menu u have access to users manager, posts and candidates manager, region state/lga, reports<br> ","1,2,3,4,5,6,","","1,2,3,4,5,","0","0","0","2014-02-10 22:34:20","2014-08-19 00:30:35","0000-00-00 00:00:00","","");
INSERT INTO user_groups VALUES("2","_administrators","this role give access to only some parts of the control panel like user manager , posts manager,candidates manager, region manager like adding state, lga s<br> ","1,2,3,4,","","1,2,3,4,5,","0","0","0","2014-02-10 22:35:05","2014-05-16 22:44:10","0000-00-00 00:00:00","","");
INSERT INTO user_groups VALUES("3","_basicadministrators","give access to lowest part of the backend like adding  only users (capturing)\n ","1,","","2,4,5,","0","0","0","2014-02-10 22:36:04","2014-05-16 22:47:32","0000-00-00 00:00:00","","");
INSERT INTO user_groups VALUES("4","_users","This role gives access to front end fully and lil parts of the back en, not even any changes to the backend   ","","","","0","0","0","0000-00-00 00:00:00","2014-05-16 22:51:42","0000-00-00 00:00:00","","");
INSERT INTO user_groups VALUES("5","_userst","                                  this roles is fro testingt","1,2,3,5,t","1,2,3,4,5,5,t","1,2,3,4,4,5,t","0","0","0","2015-05-26 12:59:01","2015-05-26 13:18:51","2015-05-27 08:28:38","ghost","ghost");



DROP TABLE user_log;

CREATE TABLE `user_log` (
  `log_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `log_action` varchar(300) NOT NULL,
  `log_date` datetime NOT NULL,
  PRIMARY KEY (`log_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1017 DEFAULT CHARSET=latin1;

INSERT INTO user_log VALUES("1","1","view_system_log","2015-06-02 15:35:39");
INSERT INTO user_log VALUES("2","1","view_faculties","2015-06-02 15:46:27");
INSERT INTO user_log VALUES("3","1","view_ip_filter","2015-06-02 15:46:53");
INSERT INTO user_log VALUES("4","1","view_system_log","2015-06-02 15:46:55");
INSERT INTO user_log VALUES("5","1","view_system_log","2015-06-02 15:48:56");
INSERT INTO user_log VALUES("6","0","view_control_box","2015-06-06 15:50:44");
INSERT INTO user_log VALUES("7","1","","2015-06-06 15:51:21");
INSERT INTO user_log VALUES("8","1","view_control_box","2015-06-06 15:51:31");
INSERT INTO user_log VALUES("9","1","view_control_box","2015-06-06 16:10:57");
INSERT INTO user_log VALUES("10","1","view_control_boxs","2015-06-06 16:11:07");
INSERT INTO user_log VALUES("11","1","view_control_boxs","2015-06-06 16:15:12");
INSERT INTO user_log VALUES("12","1","view_control_boxs","2015-06-06 16:32:36");
INSERT INTO user_log VALUES("13","0","add_ips","2015-06-08 09:14:12");
INSERT INTO user_log VALUES("14","1","","2015-06-08 09:14:30");
INSERT INTO user_log VALUES("15","1","view_control_boxs","2015-06-08 09:14:38");
INSERT INTO user_log VALUES("16","1","view_ip_filter","2015-06-08 09:14:44");
INSERT INTO user_log VALUES("17","1","view_ip_filter","2015-06-08 09:15:03");
INSERT INTO user_log VALUES("18","1","view_faculties","2015-06-08 09:15:21");
INSERT INTO user_log VALUES("19","1","view_control_boxs","2015-06-08 09:15:53");
INSERT INTO user_log VALUES("20","1","view_news","2015-06-08 09:28:20");
INSERT INTO user_log VALUES("21","1","view_events","2015-06-08 09:29:45");
INSERT INTO user_log VALUES("22","1","view_pictures","2015-06-08 09:29:51");
INSERT INTO user_log VALUES("23","1","view_videos","2015-06-08 09:30:01");
INSERT INTO user_log VALUES("24","0","view_control_boxs","2015-06-08 12:05:37");
INSERT INTO user_log VALUES("25","1","","2015-06-08 12:08:56");
INSERT INTO user_log VALUES("26","1","view_control_boxs","2015-06-08 12:09:09");
INSERT INTO user_log VALUES("27","1","view_control_boxs","2015-06-08 12:16:12");
INSERT INTO user_log VALUES("28","1","view_control_boxs","2015-06-08 12:20:30");
INSERT INTO user_log VALUES("29","1","add_control_boxs","2015-06-08 12:20:36");
INSERT INTO user_log VALUES("30","1","view_control_boxs","2015-06-08 12:20:50");
INSERT INTO user_log VALUES("31","1","delete_control_boxs","2015-06-08 12:20:56");
INSERT INTO user_log VALUES("32","1","view_control_boxs","2015-06-08 12:21:02");
INSERT INTO user_log VALUES("33","1","view_control_boxs","2015-06-08 12:34:04");
INSERT INTO user_log VALUES("34","1","view_ip_filter","2015-06-08 12:38:34");
INSERT INTO user_log VALUES("35","1","view_ip_filter","2015-06-08 12:45:45");
INSERT INTO user_log VALUES("36","1","control_box","2015-06-08 12:46:25");
INSERT INTO user_log VALUES("37","1","view_ip_filter","2015-06-08 12:47:00");
INSERT INTO user_log VALUES("38","1","view_control_boxs","2015-06-08 12:47:06");
INSERT INTO user_log VALUES("39","1","view_control_boxs","2015-06-08 12:48:21");
INSERT INTO user_log VALUES("40","1","add_control_boxs","2015-06-08 13:04:54");
INSERT INTO user_log VALUES("41","1","add_control_boxs","2015-06-08 13:05:42");
INSERT INTO user_log VALUES("42","1","add_control_boxs","2015-06-08 13:06:26");
INSERT INTO user_log VALUES("43","0","save_control_boxs","2015-06-08 13:28:24");
INSERT INTO user_log VALUES("44","0","view_control_boxs","2015-06-08 13:28:26");
INSERT INTO user_log VALUES("45","1","","2015-06-08 13:28:40");
INSERT INTO user_log VALUES("46","1","view_control_boxs","2015-06-08 13:28:55");
INSERT INTO user_log VALUES("47","1","add_control_boxs","2015-06-08 13:29:35");
INSERT INTO user_log VALUES("48","1","save_control_boxs","2015-06-08 13:29:48");
INSERT INTO user_log VALUES("49","1","view_control_boxs","2015-06-08 13:29:50");
INSERT INTO user_log VALUES("50","1","delete_control_boxs","2015-06-08 13:30:03");
INSERT INTO user_log VALUES("51","1","view_control_boxs","2015-06-08 13:30:05");
INSERT INTO user_log VALUES("52","1","edit_control_boxs","2015-06-08 13:30:11");
INSERT INTO user_log VALUES("53","1","update_control_boxs","2015-06-08 13:30:35");
INSERT INTO user_log VALUES("54","1","view_control_boxs","2015-06-08 13:30:37");
INSERT INTO user_log VALUES("55","1","trashed_control_boxs","2015-06-08 13:30:55");
INSERT INTO user_log VALUES("56","1","view_control_boxs","2015-06-08 13:31:06");
INSERT INTO user_log VALUES("57","1","delete_control_boxs","2015-06-08 13:31:27");
INSERT INTO user_log VALUES("58","1","view_control_boxs","2015-06-08 13:31:29");
INSERT INTO user_log VALUES("59","0","view_control_boxs","2015-06-09 05:50:46");
INSERT INTO user_log VALUES("60","1","","2015-06-09 05:52:01");
INSERT INTO user_log VALUES("61","1","view_control_boxs","2015-06-09 05:52:30");
INSERT INTO user_log VALUES("62","1","view_control_boxs","2015-06-09 06:01:26");
INSERT INTO user_log VALUES("63","1","edit_control_boxs","2015-06-09 06:01:40");
INSERT INTO user_log VALUES("64","1","update_control_boxs","2015-06-09 06:02:03");
INSERT INTO user_log VALUES("65","1","view_control_boxs","2015-06-09 06:02:05");
INSERT INTO user_log VALUES("66","1","delete_control_boxs","2015-06-09 06:02:20");
INSERT INTO user_log VALUES("67","1","view_control_boxs","2015-06-09 06:02:23");
INSERT INTO user_log VALUES("68","1","trashed_control_boxs","2015-06-09 06:02:32");
INSERT INTO user_log VALUES("69","1","trashed_control_boxs","2015-06-09 06:02:47");
INSERT INTO user_log VALUES("70","1","restore_control_boxs","2015-06-09 06:03:03");
INSERT INTO user_log VALUES("71","1","trashed_control_boxs","2015-06-09 06:03:05");
INSERT INTO user_log VALUES("72","1","view_control_boxs","2015-06-09 06:03:13");
INSERT INTO user_log VALUES("73","1","view_control_boxs","2015-06-09 06:45:20");
INSERT INTO user_log VALUES("74","0","add_control_boxs","2015-06-09 07:40:28");
INSERT INTO user_log VALUES("75","1","","2015-06-09 07:40:46");
INSERT INTO user_log VALUES("76","1","view_control_boxs","2015-06-09 07:40:55");
INSERT INTO user_log VALUES("77","0","view_control_boxs","2015-06-09 11:49:09");
INSERT INTO user_log VALUES("78","1","","2015-06-09 11:49:43");
INSERT INTO user_log VALUES("79","1","","2015-06-09 11:58:42");
INSERT INTO user_log VALUES("80","1","view_control_boxs","2015-06-09 12:28:28");
INSERT INTO user_log VALUES("81","1","view_ip_filter","2015-06-09 12:30:46");
INSERT INTO user_log VALUES("82","1","view_profile","2015-06-09 12:32:26");
INSERT INTO user_log VALUES("83","1","","2015-06-09 12:32:36");
INSERT INTO user_log VALUES("84","1","view_profile","2015-06-09 12:32:42");
INSERT INTO user_log VALUES("85","1","view_profile","2015-06-09 12:36:11");
INSERT INTO user_log VALUES("86","1","view_system_log","2015-06-09 12:36:29");
INSERT INTO user_log VALUES("87","1","view_news","2015-06-09 12:36:47");
INSERT INTO user_log VALUES("88","1","view_pictures","2015-06-09 12:37:02");
INSERT INTO user_log VALUES("89","1","delete_pictures","2015-06-09 12:37:17");
INSERT INTO user_log VALUES("90","1","view_pictures","2015-06-09 12:37:19");
INSERT INTO user_log VALUES("91","1","view_profile","2015-06-09 12:37:47");
INSERT INTO user_log VALUES("92","1","view_profile","2015-06-09 12:39:36");
INSERT INTO user_log VALUES("93","1","view_profile","2015-06-09 12:40:31");
INSERT INTO user_log VALUES("94","1","view_profile","2015-06-09 12:42:49");
INSERT INTO user_log VALUES("95","1","view_profile","2015-06-09 12:43:19");
INSERT INTO user_log VALUES("96","1","view_profile","2015-06-09 12:43:58");
INSERT INTO user_log VALUES("97","1","view_profile","2015-06-09 12:44:45");
INSERT INTO user_log VALUES("98","1","view_profile","2015-06-09 12:45:22");
INSERT INTO user_log VALUES("99","1","view_profile","2015-06-09 12:46:56");
INSERT INTO user_log VALUES("100","1","view_profile","2015-06-09 12:56:39");
INSERT INTO user_log VALUES("101","1","view_profile","2015-06-09 12:57:15");
INSERT INTO user_log VALUES("102","0","view_profile","2015-06-09 12:59:10");
INSERT INTO user_log VALUES("103","1","","2015-06-09 12:59:25");
INSERT INTO user_log VALUES("104","1","","2015-06-09 13:02:23");
INSERT INTO user_log VALUES("105","1","","2015-06-09 13:03:16");
INSERT INTO user_log VALUES("106","1","","2015-06-09 13:07:42");
INSERT INTO user_log VALUES("107","1","","2015-06-09 13:08:57");
INSERT INTO user_log VALUES("108","1","","2015-06-09 13:09:14");
INSERT INTO user_log VALUES("109","1","","2015-06-09 13:09:29");
INSERT INTO user_log VALUES("110","1","","2015-06-09 13:09:47");
INSERT INTO user_log VALUES("111","1","view_news","2015-06-09 13:10:12");
INSERT INTO user_log VALUES("112","1","view_news","2015-06-09 13:10:53");
INSERT INTO user_log VALUES("113","1","view_news","2015-06-09 13:14:44");
INSERT INTO user_log VALUES("114","1","view_events","2015-06-09 13:14:57");
INSERT INTO user_log VALUES("115","1","view_news","2015-06-09 13:15:07");
INSERT INTO user_log VALUES("116","1","add_news","2015-06-09 13:15:12");
INSERT INTO user_log VALUES("117","1","add_news","2015-06-09 13:15:42");
INSERT INTO user_log VALUES("118","1","add_news","2015-06-09 13:16:27");
INSERT INTO user_log VALUES("119","1","add_news","2015-06-09 13:16:53");
INSERT INTO user_log VALUES("120","1","view_news","2015-06-09 13:17:28");
INSERT INTO user_log VALUES("121","1","edit_news","2015-06-09 13:17:44");
INSERT INTO user_log VALUES("122","1","view_news","2015-06-09 13:17:51");
INSERT INTO user_log VALUES("123","1","view_events","2015-06-09 13:17:57");
INSERT INTO user_log VALUES("124","1","view_events","2015-06-09 13:18:32");
INSERT INTO user_log VALUES("125","1","view_events","2015-06-09 13:19:18");
INSERT INTO user_log VALUES("126","1","view_events","2015-06-09 13:21:11");
INSERT INTO user_log VALUES("127","1","view_news","2015-06-09 13:21:34");
INSERT INTO user_log VALUES("128","1","view_news","2015-06-09 13:22:33");
INSERT INTO user_log VALUES("129","1","add_news","2015-06-09 13:22:38");
INSERT INTO user_log VALUES("130","1","view_news","2015-06-09 13:23:24");
INSERT INTO user_log VALUES("131","1","view_news","2015-06-09 13:23:47");
INSERT INTO user_log VALUES("132","1","add_news","2015-06-09 13:23:53");
INSERT INTO user_log VALUES("133","1","view_news","2015-06-09 13:24:01");
INSERT INTO user_log VALUES("134","1","view_news","2015-06-09 13:24:15");
INSERT INTO user_log VALUES("135","1","add_news","2015-06-09 13:24:20");
INSERT INTO user_log VALUES("136","1","view_news","2015-06-09 13:24:24");
INSERT INTO user_log VALUES("137","1","view_events","2015-06-09 13:24:28");
INSERT INTO user_log VALUES("138","1","add_events","2015-06-09 13:24:37");
INSERT INTO user_log VALUES("139","1","add_events","2015-06-09 13:24:59");
INSERT INTO user_log VALUES("140","1","view_news","2015-06-09 13:25:07");
INSERT INTO user_log VALUES("141","1","","2015-06-09 13:25:28");
INSERT INTO user_log VALUES("142","1","","2015-06-09 13:26:08");
INSERT INTO user_log VALUES("143","1","","2015-06-09 13:26:43");
INSERT INTO user_log VALUES("144","1","","2015-06-09 13:27:16");
INSERT INTO user_log VALUES("145","1","","2015-06-09 13:28:33");
INSERT INTO user_log VALUES("146","1","","2015-06-09 13:29:12");
INSERT INTO user_log VALUES("147","1","","2015-06-09 13:29:31");
INSERT INTO user_log VALUES("148","1","","2015-06-09 13:30:01");
INSERT INTO user_log VALUES("149","1","","2015-06-09 13:30:21");
INSERT INTO user_log VALUES("150","1","","2015-06-09 13:31:01");
INSERT INTO user_log VALUES("151","1","","2015-06-09 13:31:27");
INSERT INTO user_log VALUES("152","1","","2015-06-09 13:31:52");
INSERT INTO user_log VALUES("153","1","","2015-06-09 13:32:47");
INSERT INTO user_log VALUES("154","1","","2015-06-09 13:34:07");
INSERT INTO user_log VALUES("155","1","","2015-06-09 13:35:06");
INSERT INTO user_log VALUES("156","1","","2015-06-09 13:35:36");
INSERT INTO user_log VALUES("157","1","view_user_groups","2015-06-09 13:35:42");
INSERT INTO user_log VALUES("158","1","","2015-06-09 13:35:52");
INSERT INTO user_log VALUES("159","1","","2015-06-09 13:38:17");
INSERT INTO user_log VALUES("160","1","view_global_settings","2015-06-09 13:38:44");
INSERT INTO user_log VALUES("161","1","","2015-06-09 13:38:58");
INSERT INTO user_log VALUES("162","1","view_users","2015-06-09 13:39:13");
INSERT INTO user_log VALUES("163","1","add_users","2015-06-09 13:39:21");
INSERT INTO user_log VALUES("164","1","view_roles","2015-06-09 13:41:08");
INSERT INTO user_log VALUES("165","1","add_roles","2015-06-09 13:41:20");
INSERT INTO user_log VALUES("166","1","view_roles","2015-06-09 13:41:43");
INSERT INTO user_log VALUES("167","1","view_user_groups","2015-06-09 13:41:54");
INSERT INTO user_log VALUES("168","1","add_user_groups","2015-06-09 13:42:07");
INSERT INTO user_log VALUES("169","1","view_news","2015-06-09 13:42:36");
INSERT INTO user_log VALUES("170","1","add_news","2015-06-09 13:42:46");
INSERT INTO user_log VALUES("171","1","view_events","2015-06-09 13:43:00");
INSERT INTO user_log VALUES("172","1","add_events","2015-06-09 13:43:17");
INSERT INTO user_log VALUES("173","1","view_videos","2015-06-09 13:43:37");
INSERT INTO user_log VALUES("174","1","add_videos","2015-06-09 13:43:54");
INSERT INTO user_log VALUES("175","1","view_faculties","2015-06-09 13:44:11");
INSERT INTO user_log VALUES("176","1","add_faculties","2015-06-09 13:44:23");
INSERT INTO user_log VALUES("177","1","view_departments","2015-06-09 13:44:40");
INSERT INTO user_log VALUES("178","1","view_courses","2015-06-09 13:45:15");
INSERT INTO user_log VALUES("179","1","add_courses","2015-06-09 13:45:21");
INSERT INTO user_log VALUES("180","1","view_subjects","2015-06-09 13:46:20");
INSERT INTO user_log VALUES("181","1","add_subjects","2015-06-09 13:46:33");
INSERT INTO user_log VALUES("182","1","view_subjects","2015-06-09 13:47:07");
INSERT INTO user_log VALUES("183","1","trashed_subjects","2015-06-09 13:47:18");
INSERT INTO user_log VALUES("184","1","view_subjects","2015-06-09 13:47:26");
INSERT INTO user_log VALUES("185","1","view_system_backup","2015-06-09 13:47:40");
INSERT INTO user_log VALUES("186","1","view_system_log","2015-06-09 13:47:45");
INSERT INTO user_log VALUES("187","1","view_system_log","2015-06-09 13:47:56");
INSERT INTO user_log VALUES("188","1","view_ip_filter","2015-06-09 13:47:59");
INSERT INTO user_log VALUES("189","1","add_ips","2015-06-09 13:48:16");
INSERT INTO user_log VALUES("190","1","view_control_boxs","2015-06-09 13:48:39");
INSERT INTO user_log VALUES("191","1","view_control_boxs","2015-06-09 13:56:06");
INSERT INTO user_log VALUES("192","1","view_courses","2015-06-09 14:24:50");
INSERT INTO user_log VALUES("193","1","view_departments","2015-06-09 14:25:10");
INSERT INTO user_log VALUES("194","1","view_subjects","2015-06-09 14:25:23");
INSERT INTO user_log VALUES("195","1","delete_subjects","2015-06-09 14:25:51");
INSERT INTO user_log VALUES("196","1","view_subjects","2015-06-09 14:25:53");
INSERT INTO user_log VALUES("197","1","trashed_subjects","2015-06-09 14:26:07");
INSERT INTO user_log VALUES("198","1","view_subjects","2015-06-09 14:26:14");
INSERT INTO user_log VALUES("199","1","view_faculties","2015-06-09 14:26:25");
INSERT INTO user_log VALUES("200","0","view_news","2015-06-10 07:13:13");
INSERT INTO user_log VALUES("201","1","","2015-06-10 07:13:28");
INSERT INTO user_log VALUES("202","1","view_news","2015-06-10 07:13:43");
INSERT INTO user_log VALUES("203","1","add_news","2015-06-10 08:00:43");
INSERT INTO user_log VALUES("204","1","view_news","2015-06-10 08:03:53");
INSERT INTO user_log VALUES("205","1","add_news","2015-06-10 08:04:04");
INSERT INTO user_log VALUES("206","1","view_system_log","2015-06-10 08:05:59");
INSERT INTO user_log VALUES("207","1","view_news","2015-06-10 08:07:32");
INSERT INTO user_log VALUES("208","1","add_news","2015-06-10 08:07:53");
INSERT INTO user_log VALUES("209","0","add_news","2015-06-10 16:29:22");
INSERT INTO user_log VALUES("210","1","","2015-06-10 16:29:36");
INSERT INTO user_log VALUES("211","1","view_news","2015-06-10 16:29:45");
INSERT INTO user_log VALUES("212","1","view_news","2015-06-10 16:31:41");
INSERT INTO user_log VALUES("213","1","add_news","2015-06-10 16:31:46");
INSERT INTO user_log VALUES("214","1","view_news","2015-06-10 16:32:13");
INSERT INTO user_log VALUES("215","1","view_news","2015-06-10 16:37:56");
INSERT INTO user_log VALUES("216","1","view_events","2015-06-10 16:38:10");
INSERT INTO user_log VALUES("217","1","view_news","2015-06-10 16:38:16");
INSERT INTO user_log VALUES("218","1","view_news","2015-06-10 17:04:01");
INSERT INTO user_log VALUES("219","1","view_events","2015-06-10 17:08:21");
INSERT INTO user_log VALUES("220","1","view_news","2015-06-10 17:08:28");
INSERT INTO user_log VALUES("221","1","view_news","2015-06-10 17:08:38");
INSERT INTO user_log VALUES("222","1","view_news","2015-06-10 17:10:56");
INSERT INTO user_log VALUES("223","1","trashed_news","2015-06-10 17:16:02");
INSERT INTO user_log VALUES("224","1","view_news","2015-06-10 17:16:11");
INSERT INTO user_log VALUES("225","1","trashed_news","2015-06-10 17:16:17");
INSERT INTO user_log VALUES("226","1","trashed_news","2015-06-10 17:17:38");
INSERT INTO user_log VALUES("227","1","view_news","2015-06-10 17:27:40");
INSERT INTO user_log VALUES("228","1","add_news","2015-06-10 17:27:47");
INSERT INTO user_log VALUES("229","0","add_news","2015-06-10 17:33:17");
INSERT INTO user_log VALUES("230","1","","2015-06-10 17:33:31");
INSERT INTO user_log VALUES("231","1","add_news","2015-06-10 17:33:38");
INSERT INTO user_log VALUES("232","1","add_news","2015-06-10 17:34:07");
INSERT INTO user_log VALUES("233","1","add_news","2015-06-10 17:34:59");
INSERT INTO user_log VALUES("234","1","view_news","2015-06-10 17:35:15");
INSERT INTO user_log VALUES("235","1","add_news","2015-06-10 17:35:32");
INSERT INTO user_log VALUES("236","1","view_news","2015-06-10 17:35:49");
INSERT INTO user_log VALUES("237","0","add_news","2015-06-11 07:52:50");
INSERT INTO user_log VALUES("238","1","","2015-06-11 07:53:05");
INSERT INTO user_log VALUES("239","1","add_news","2015-06-11 07:53:37");
INSERT INTO user_log VALUES("240","1","add_news","2015-06-11 07:54:13");
INSERT INTO user_log VALUES("241","1","add_news","2015-06-11 07:54:45");
INSERT INTO user_log VALUES("242","1","view_news","2015-06-11 07:55:59");
INSERT INTO user_log VALUES("243","1","add_news","2015-06-11 07:58:13");
INSERT INTO user_log VALUES("244","1","save_news","2015-06-11 07:59:34");
INSERT INTO user_log VALUES("245","1","view_news","2015-06-11 07:59:36");
INSERT INTO user_log VALUES("246","1","edit_news","2015-06-11 08:01:03");
INSERT INTO user_log VALUES("247","1","update_news","2015-06-11 08:01:14");
INSERT INTO user_log VALUES("248","1","view_news","2015-06-11 08:01:16");
INSERT INTO user_log VALUES("249","1","view_news","2015-06-11 08:11:21");
INSERT INTO user_log VALUES("250","1","add_news","2015-06-11 08:11:31");
INSERT INTO user_log VALUES("251","1","save_news","2015-06-11 08:11:51");
INSERT INTO user_log VALUES("252","1","view_news","2015-06-11 08:11:53");
INSERT INTO user_log VALUES("253","1","view_news","2015-06-11 08:14:17");
INSERT INTO user_log VALUES("254","1","add_news","2015-06-11 08:15:56");
INSERT INTO user_log VALUES("255","1","save_news","2015-06-11 08:16:12");
INSERT INTO user_log VALUES("256","1","add_news","2015-06-11 08:16:14");
INSERT INTO user_log VALUES("257","1","save_news","2015-06-11 08:16:45");
INSERT INTO user_log VALUES("258","1","view_news","2015-06-11 08:16:47");
INSERT INTO user_log VALUES("259","1","view_news","2015-06-11 08:17:39");
INSERT INTO user_log VALUES("260","1","view_news","2015-06-11 08:18:27");
INSERT INTO user_log VALUES("261","1","view_news","2015-06-11 08:24:17");
INSERT INTO user_log VALUES("262","1","edit_news","2015-06-11 08:24:27");
INSERT INTO user_log VALUES("263","1","edit_news","2015-06-11 08:25:16");
INSERT INTO user_log VALUES("264","1","update_news","2015-06-11 08:25:36");
INSERT INTO user_log VALUES("265","1","view_news","2015-06-11 08:25:38");
INSERT INTO user_log VALUES("266","1","edit_news","2015-06-11 08:28:02");
INSERT INTO user_log VALUES("267","1","edit_news","2015-06-11 08:29:12");
INSERT INTO user_log VALUES("268","1","update_news","2015-06-11 08:29:24");
INSERT INTO user_log VALUES("269","1","view_news","2015-06-11 08:29:26");
INSERT INTO user_log VALUES("270","1","edit_news","2015-06-11 08:32:40");
INSERT INTO user_log VALUES("271","1","update_news","2015-06-11 08:32:54");
INSERT INTO user_log VALUES("272","1","view_news","2015-06-11 08:32:56");
INSERT INTO user_log VALUES("273","1","edit_news","2015-06-11 08:33:24");
INSERT INTO user_log VALUES("274","1","update_news","2015-06-11 08:33:40");
INSERT INTO user_log VALUES("275","1","view_news","2015-06-11 08:33:42");
INSERT INTO user_log VALUES("276","1","trashed_news","2015-06-11 08:33:59");
INSERT INTO user_log VALUES("277","1","view_news","2015-06-11 08:34:10");
INSERT INTO user_log VALUES("278","1","delete_news","2015-06-11 08:36:46");
INSERT INTO user_log VALUES("279","1","view_news","2015-06-11 08:36:48");
INSERT INTO user_log VALUES("280","1","publish_news","2015-06-11 08:37:12");
INSERT INTO user_log VALUES("281","1","view_news","2015-06-11 08:37:14");
INSERT INTO user_log VALUES("282","1","unpublish_news","2015-06-11 08:37:23");
INSERT INTO user_log VALUES("283","1","view_news","2015-06-11 08:37:25");
INSERT INTO user_log VALUES("284","1","trashed_news","2015-06-11 08:37:33");
INSERT INTO user_log VALUES("285","1","trashed_news","2015-06-11 08:39:21");
INSERT INTO user_log VALUES("286","1","trashed_news","2015-06-11 08:39:36");
INSERT INTO user_log VALUES("287","1","trashed_news","2015-06-11 08:39:58");
INSERT INTO user_log VALUES("288","1","restore_news","2015-06-11 08:40:09");
INSERT INTO user_log VALUES("289","1","trashed_news","2015-06-11 08:40:11");
INSERT INTO user_log VALUES("290","1","view_news","2015-06-11 08:40:17");
INSERT INTO user_log VALUES("291","1","publish_news","2015-06-11 08:40:26");
INSERT INTO user_log VALUES("292","1","view_news","2015-06-11 08:40:28");
INSERT INTO user_log VALUES("293","1","publish_news","2015-06-11 08:40:37");
INSERT INTO user_log VALUES("294","1","view_news","2015-06-11 08:40:39");
INSERT INTO user_log VALUES("295","1","delete_news","2015-06-11 08:40:56");
INSERT INTO user_log VALUES("296","1","view_news","2015-06-11 08:40:59");
INSERT INTO user_log VALUES("297","1","view_events","2015-06-11 08:41:13");
INSERT INTO user_log VALUES("298","1","view_news","2015-06-11 08:49:57");
INSERT INTO user_log VALUES("299","0","trashed_news","2015-06-11 08:55:45");
INSERT INTO user_log VALUES("300","1","","2015-06-12 19:31:54");
INSERT INTO user_log VALUES("301","1","view_news","2015-06-12 19:35:02");
INSERT INTO user_log VALUES("302","1","view_events","2015-06-12 19:35:11");
INSERT INTO user_log VALUES("303","1","view_events","2015-06-12 19:44:30");
INSERT INTO user_log VALUES("304","1","view_events","2015-06-12 19:45:14");
INSERT INTO user_log VALUES("305","1","view_events","2015-06-12 19:47:47");
INSERT INTO user_log VALUES("306","1","view_events","2015-06-12 19:48:04");
INSERT INTO user_log VALUES("307","1","add_events","2015-06-12 19:48:36");
INSERT INTO user_log VALUES("308","1","view_news","2015-06-12 19:48:43");
INSERT INTO user_log VALUES("309","1","view_events","2015-06-12 19:56:18");
INSERT INTO user_log VALUES("310","1","view_events","2015-06-12 20:06:56");
INSERT INTO user_log VALUES("311","1","view_events","2015-06-12 20:07:32");
INSERT INTO user_log VALUES("312","1","add_events","2015-06-12 20:08:25");
INSERT INTO user_log VALUES("313","1","add_events","2015-06-12 20:30:47");
INSERT INTO user_log VALUES("314","1","view_events","2015-06-12 20:30:57");
INSERT INTO user_log VALUES("315","1","edit_events","2015-06-12 20:31:05");
INSERT INTO user_log VALUES("316","1","update_events","2015-06-12 20:31:24");
INSERT INTO user_log VALUES("317","1","view_events","2015-06-12 20:31:26");
INSERT INTO user_log VALUES("318","0","add_events","2015-06-12 20:32:02");
INSERT INTO user_log VALUES("319","1","","2015-06-12 20:32:15");
INSERT INTO user_log VALUES("320","1","view_events","2015-06-12 20:33:36");
INSERT INTO user_log VALUES("321","1","edit_events","2015-06-12 20:33:46");
INSERT INTO user_log VALUES("322","1","update_events","2015-06-12 20:34:04");
INSERT INTO user_log VALUES("323","1","view_events","2015-06-12 20:34:06");
INSERT INTO user_log VALUES("324","1","publish_events","2015-06-12 20:34:15");
INSERT INTO user_log VALUES("325","1","view_news","2015-06-12 20:34:17");
INSERT INTO user_log VALUES("326","1","view_events","2015-06-12 20:34:44");
INSERT INTO user_log VALUES("327","1","unpublish_events","2015-06-12 20:34:53");
INSERT INTO user_log VALUES("328","1","view_events","2015-06-12 20:34:55");
INSERT INTO user_log VALUES("329","1","view_events","2015-06-12 20:36:59");
INSERT INTO user_log VALUES("330","1","edit_events","2015-06-12 20:38:31");
INSERT INTO user_log VALUES("331","1","update_events","2015-06-12 20:39:03");
INSERT INTO user_log VALUES("332","1","view_events","2015-06-12 20:39:05");
INSERT INTO user_log VALUES("333","1","view_events","2015-06-12 20:40:10");
INSERT INTO user_log VALUES("334","1","edit_events","2015-06-12 20:40:31");
INSERT INTO user_log VALUES("335","1","update_events","2015-06-12 20:40:45");
INSERT INTO user_log VALUES("336","1","view_events","2015-06-12 20:40:47");
INSERT INTO user_log VALUES("337","1","unpublish_events","2015-06-12 20:41:03");
INSERT INTO user_log VALUES("338","1","view_events","2015-06-12 20:41:05");
INSERT INTO user_log VALUES("339","1","delete_events","2015-06-12 20:41:17");
INSERT INTO user_log VALUES("340","1","view_events","2015-06-12 20:41:20");
INSERT INTO user_log VALUES("341","1","trashed_events","2015-06-12 20:41:26");
INSERT INTO user_log VALUES("342","1","trashed_events","2015-06-12 20:41:50");
INSERT INTO user_log VALUES("343","1","trashed_events","2015-06-12 20:42:15");
INSERT INTO user_log VALUES("344","1","restore_events","2015-06-12 20:42:46");
INSERT INTO user_log VALUES("345","1","trashed_events","2015-06-12 20:42:48");
INSERT INTO user_log VALUES("346","1","view_events","2015-06-12 20:42:53");
INSERT INTO user_log VALUES("347","1","delete_events","2015-06-12 20:43:01");
INSERT INTO user_log VALUES("348","1","view_events","2015-06-12 20:43:03");
INSERT INTO user_log VALUES("349","1","trashed_events","2015-06-12 20:43:08");
INSERT INTO user_log VALUES("350","1","trashed_events","2015-06-12 20:43:17");
INSERT INTO user_log VALUES("351","1","trashed_events","2015-06-12 20:43:44");
INSERT INTO user_log VALUES("352","1","trashed_events","2015-06-12 20:44:16");
INSERT INTO user_log VALUES("353","1","trashed_events","2015-06-12 20:44:25");
INSERT INTO user_log VALUES("354","1","view_events","2015-06-12 20:44:31");
INSERT INTO user_log VALUES("355","1","publish_events","2015-06-12 20:44:54");
INSERT INTO user_log VALUES("356","1","view_events","2015-06-12 20:44:56");
INSERT INTO user_log VALUES("357","1","unpublish_events","2015-06-12 20:45:08");
INSERT INTO user_log VALUES("358","1","view_events","2015-06-12 20:45:10");
INSERT INTO user_log VALUES("359","1","publish_events","2015-06-12 20:45:21");
INSERT INTO user_log VALUES("360","1","view_events","2015-06-12 20:45:23");
INSERT INTO user_log VALUES("361","1","view_pictures","2015-06-12 20:45:54");
INSERT INTO user_log VALUES("362","0","view_pictures","2015-06-12 21:43:03");
INSERT INTO user_log VALUES("363","1","","2015-06-12 21:43:34");
INSERT INTO user_log VALUES("364","1","","2015-06-12 21:43:36");
INSERT INTO user_log VALUES("365","0","add_events","2015-06-12 22:15:56");
INSERT INTO user_log VALUES("366","1","","2015-06-12 22:16:13");
INSERT INTO user_log VALUES("367","0","","2015-06-12 22:16:16");
INSERT INTO user_log VALUES("368","1","","2015-06-12 22:17:02");
INSERT INTO user_log VALUES("369","1","","2015-06-12 22:17:04");
INSERT INTO user_log VALUES("370","1","","2015-06-12 22:17:06");
INSERT INTO user_log VALUES("371","1","","2015-06-12 22:17:09");
INSERT INTO user_log VALUES("372","1","","2015-06-12 22:17:11");
INSERT INTO user_log VALUES("373","1","","2015-06-12 22:17:13");
INSERT INTO user_log VALUES("374","1","","2015-06-12 22:17:15");
INSERT INTO user_log VALUES("375","1","","2015-06-12 22:17:18");
INSERT INTO user_log VALUES("376","1","","2015-06-12 22:17:20");
INSERT INTO user_log VALUES("377","1","","2015-06-12 22:17:22");
INSERT INTO user_log VALUES("378","1","","2015-06-12 22:17:24");
INSERT INTO user_log VALUES("379","1","","2015-06-12 22:17:26");
INSERT INTO user_log VALUES("380","1","","2015-06-12 22:17:28");
INSERT INTO user_log VALUES("381","1","","2015-06-12 22:17:31");
INSERT INTO user_log VALUES("382","1","","2015-06-12 22:17:33");
INSERT INTO user_log VALUES("383","0","","2015-06-12 22:18:25");
INSERT INTO user_log VALUES("384","1","","2015-06-12 22:18:50");
INSERT INTO user_log VALUES("385","1","add_events","2015-06-12 22:19:00");
INSERT INTO user_log VALUES("386","1","view_pictures","2015-06-12 22:19:07");
INSERT INTO user_log VALUES("387","0","view_videos","2015-06-12 22:19:49");
INSERT INTO user_log VALUES("388","1","","2015-06-12 22:21:41");
INSERT INTO user_log VALUES("389","1","add_news","2015-06-12 22:21:47");
INSERT INTO user_log VALUES("390","1","view_departments","2015-06-12 22:21:56");
INSERT INTO user_log VALUES("391","1","view_events","2015-06-12 22:22:03");
INSERT INTO user_log VALUES("392","0","edit_events","2015-06-12 22:22:17");
INSERT INTO user_log VALUES("393","1","","2015-06-12 22:27:57");
INSERT INTO user_log VALUES("394","1","view_system_log","2015-06-12 22:28:04");
INSERT INTO user_log VALUES("395","1","view_pictures","2015-06-12 22:28:12");
INSERT INTO user_log VALUES("396","0","view_pictures","2015-06-12 22:28:41");
INSERT INTO user_log VALUES("397","1","","2015-06-12 22:29:37");
INSERT INTO user_log VALUES("398","0","add_events","2015-06-12 22:29:59");
INSERT INTO user_log VALUES("399","1","","2015-06-12 22:33:44");
INSERT INTO user_log VALUES("400","1","add_events","2015-06-12 22:33:50");
INSERT INTO user_log VALUES("401","1","view_events","2015-06-12 22:33:55");
INSERT INTO user_log VALUES("402","1","view_students","2015-06-12 22:34:01");
INSERT INTO user_log VALUES("403","1","view_news","2015-06-12 22:34:04");
INSERT INTO user_log VALUES("404","1","view_users","2015-06-12 22:34:10");
INSERT INTO user_log VALUES("405","1","view_videos","2015-06-12 22:34:19");
INSERT INTO user_log VALUES("406","1","add_videos","2015-06-12 22:34:24");
INSERT INTO user_log VALUES("407","1","view_departments","2015-06-12 22:34:32");
INSERT INTO user_log VALUES("408","1","add_departments","2015-06-12 22:34:38");
INSERT INTO user_log VALUES("409","0","view_departments","2015-06-12 22:34:54");
INSERT INTO user_log VALUES("410","1","","2015-06-12 22:35:58");
INSERT INTO user_log VALUES("411","1","view_departments","2015-06-12 22:36:00");
INSERT INTO user_log VALUES("412","1","view_departments","2015-06-12 22:36:02");
INSERT INTO user_log VALUES("413","1","view_departments","2015-06-12 22:36:04");
INSERT INTO user_log VALUES("414","1","view_departments","2015-06-12 22:36:06");
INSERT INTO user_log VALUES("415","1","view_departments","2015-06-12 22:36:08");
INSERT INTO user_log VALUES("416","1","view_departments","2015-06-12 22:36:11");
INSERT INTO user_log VALUES("417","1","view_departments","2015-06-12 22:36:13");
INSERT INTO user_log VALUES("418","1","view_departments","2015-06-12 22:36:15");
INSERT INTO user_log VALUES("419","1","view_departments","2015-06-12 22:36:17");
INSERT INTO user_log VALUES("420","1","view_departments","2015-06-12 22:36:20");
INSERT INTO user_log VALUES("421","1","view_departments","2015-06-12 22:36:22");
INSERT INTO user_log VALUES("422","1","view_departments","2015-06-12 22:36:24");
INSERT INTO user_log VALUES("423","1","view_departments","2015-06-12 22:36:26");
INSERT INTO user_log VALUES("424","1","view_departments","2015-06-12 22:36:28");
INSERT INTO user_log VALUES("425","1","view_departments","2015-06-12 22:36:31");
INSERT INTO user_log VALUES("426","0","add_departments","2015-06-12 22:37:03");
INSERT INTO user_log VALUES("427","1","","2015-06-12 22:37:29");
INSERT INTO user_log VALUES("428","0","view_subjects","2015-06-12 22:37:40");
INSERT INTO user_log VALUES("429","1","","2015-06-12 22:39:12");
INSERT INTO user_log VALUES("430","1","add_events","2015-06-12 22:39:17");
INSERT INTO user_log VALUES("431","1","view_events","2015-06-12 22:39:24");
INSERT INTO user_log VALUES("432","1","edit_events","2015-06-12 22:39:34");
INSERT INTO user_log VALUES("433","1","view_events","2015-06-12 22:39:41");
INSERT INTO user_log VALUES("434","1","add_events","2015-06-12 22:39:49");
INSERT INTO user_log VALUES("435","0","view_events","2015-06-12 22:40:24");
INSERT INTO user_log VALUES("436","1","","2015-06-12 22:43:58");
INSERT INTO user_log VALUES("437","1","add_events","2015-06-12 22:44:03");
INSERT INTO user_log VALUES("438","0","view_subjects","2015-06-12 22:44:14");
INSERT INTO user_log VALUES("439","1","","2015-06-12 22:44:36");
INSERT INTO user_log VALUES("440","1","view_courses","2015-06-12 22:44:43");
INSERT INTO user_log VALUES("441","1","add_courses","2015-06-12 22:44:48");
INSERT INTO user_log VALUES("442","0","view_roles","2015-06-12 22:45:06");
INSERT INTO user_log VALUES("443","1","","2015-06-12 22:46:45");
INSERT INTO user_log VALUES("444","1","view_roles","2015-06-12 22:46:48");
INSERT INTO user_log VALUES("445","1","view_roles","2015-06-12 22:46:50");
INSERT INTO user_log VALUES("446","1","view_roles","2015-06-12 22:46:52");
INSERT INTO user_log VALUES("447","1","view_roles","2015-06-12 22:46:54");
INSERT INTO user_log VALUES("448","1","view_roles","2015-06-12 22:46:56");
INSERT INTO user_log VALUES("449","1","view_roles","2015-06-12 22:46:59");
INSERT INTO user_log VALUES("450","1","view_roles","2015-06-12 22:47:01");
INSERT INTO user_log VALUES("451","1","view_roles","2015-06-12 22:47:03");
INSERT INTO user_log VALUES("452","1","view_roles","2015-06-12 22:47:05");
INSERT INTO user_log VALUES("453","1","view_roles","2015-06-12 22:47:07");
INSERT INTO user_log VALUES("454","1","view_roles","2015-06-12 22:47:09");
INSERT INTO user_log VALUES("455","0","add_roles","2015-06-12 22:50:19");
INSERT INTO user_log VALUES("456","1","","2015-06-12 22:50:45");
INSERT INTO user_log VALUES("457","1","add_roles","2015-06-12 22:50:47");
INSERT INTO user_log VALUES("458","1","add_roles","2015-06-12 22:50:49");
INSERT INTO user_log VALUES("459","1","add_roles","2015-06-12 22:50:52");
INSERT INTO user_log VALUES("460","1","add_roles","2015-06-12 22:50:54");
INSERT INTO user_log VALUES("461","1","add_roles","2015-06-12 22:50:56");
INSERT INTO user_log VALUES("462","1","add_roles","2015-06-12 22:50:58");
INSERT INTO user_log VALUES("463","1","add_roles","2015-06-12 22:51:00");
INSERT INTO user_log VALUES("464","0","view_roles","2015-06-12 22:52:23");
INSERT INTO user_log VALUES("465","1","","2015-06-12 22:52:47");
INSERT INTO user_log VALUES("466","1","add_events","2015-06-12 22:53:26");
INSERT INTO user_log VALUES("467","1","","2015-06-12 22:53:48");
INSERT INTO user_log VALUES("468","1","add_events","2015-06-12 22:53:51");
INSERT INTO user_log VALUES("469","1","add_events","2015-06-12 22:53:53");
INSERT INTO user_log VALUES("470","1","add_events","2015-06-12 22:53:55");
INSERT INTO user_log VALUES("471","1","add_events","2015-06-12 22:53:57");
INSERT INTO user_log VALUES("472","1","add_events","2015-06-12 22:53:59");
INSERT INTO user_log VALUES("473","1","add_events","2015-06-12 22:54:01");
INSERT INTO user_log VALUES("474","1","add_events","2015-06-12 22:54:04");
INSERT INTO user_log VALUES("475","1","add_events","2015-06-12 22:54:06");
INSERT INTO user_log VALUES("476","1","add_events","2015-06-12 22:54:08");
INSERT INTO user_log VALUES("477","1","add_events","2015-06-12 22:54:10");
INSERT INTO user_log VALUES("478","1","add_events","2015-06-12 22:54:12");
INSERT INTO user_log VALUES("479","1","add_events","2015-06-12 22:54:14");
INSERT INTO user_log VALUES("480","1","add_events","2015-06-12 22:54:17");
INSERT INTO user_log VALUES("481","1","add_events","2015-06-12 22:54:19");
INSERT INTO user_log VALUES("482","1","add_events","2015-06-12 22:54:21");
INSERT INTO user_log VALUES("483","1","add_events","2015-06-12 22:54:23");
INSERT INTO user_log VALUES("484","1","add_events","2015-06-12 22:54:25");
INSERT INTO user_log VALUES("485","1","add_events","2015-06-12 22:54:27");
INSERT INTO user_log VALUES("486","1","add_events","2015-06-12 22:54:29");
INSERT INTO user_log VALUES("487","1","add_events","2015-06-12 22:54:32");
INSERT INTO user_log VALUES("488","1","add_events","2015-06-12 22:54:41");
INSERT INTO user_log VALUES("489","1","add_events","2015-06-12 22:54:44");
INSERT INTO user_log VALUES("490","1","add_events","2015-06-12 22:54:46");
INSERT INTO user_log VALUES("491","1","add_events","2015-06-12 22:54:48");
INSERT INTO user_log VALUES("492","0","add_events","2015-06-12 23:03:50");
INSERT INTO user_log VALUES("493","1","","2015-06-12 23:04:31");
INSERT INTO user_log VALUES("494","1","","2015-06-12 23:04:34");
INSERT INTO user_log VALUES("495","1","add_events","2015-06-12 23:04:40");
INSERT INTO user_log VALUES("496","1","view_faculties","2015-06-12 23:04:45");
INSERT INTO user_log VALUES("497","1","add_faculties","2015-06-12 23:04:50");
INSERT INTO user_log VALUES("498","1","view_faculties","2015-06-12 23:04:56");
INSERT INTO user_log VALUES("499","1","add_faculties","2015-06-12 23:05:06");
INSERT INTO user_log VALUES("500","1","view_faculties","2015-06-12 23:05:11");
INSERT INTO user_log VALUES("501","0","add_faculties","2015-06-12 23:05:33");
INSERT INTO user_log VALUES("502","1","","2015-06-12 23:06:29");
INSERT INTO user_log VALUES("503","0","add_events","2015-06-12 23:07:18");
INSERT INTO user_log VALUES("504","1","","2015-06-12 23:07:36");
INSERT INTO user_log VALUES("505","0","add_events","2015-06-12 23:20:30");
INSERT INTO user_log VALUES("506","1","","2015-06-12 23:20:33");
INSERT INTO user_log VALUES("507","1","","2015-06-12 23:20:35");
INSERT INTO user_log VALUES("508","1","view_users","2015-06-12 23:20:42");
INSERT INTO user_log VALUES("509","1","add_users","2015-06-12 23:20:47");
INSERT INTO user_log VALUES("510","0","view_users","2015-06-12 23:21:41");
INSERT INTO user_log VALUES("511","1","","2015-06-12 23:21:43");
INSERT INTO user_log VALUES("512","1","add_events","2015-06-12 23:21:52");
INSERT INTO user_log VALUES("513","1","view_events","2015-06-12 23:21:57");
INSERT INTO user_log VALUES("514","1","add_events","2015-06-12 23:22:06");
INSERT INTO user_log VALUES("515","1","view_users","2015-06-12 23:22:08");
INSERT INTO user_log VALUES("516","0","view_users","2015-06-13 06:43:17");
INSERT INTO user_log VALUES("517","1","","2015-06-13 06:43:32");
INSERT INTO user_log VALUES("518","1","view_pictures","2015-06-13 06:44:40");
INSERT INTO user_log VALUES("519","1","view_pictures","2015-06-13 06:46:11");
INSERT INTO user_log VALUES("520","1","view_pictures","2015-06-13 06:49:58");
INSERT INTO user_log VALUES("521","1","view_pictures","2015-06-13 06:50:37");
INSERT INTO user_log VALUES("522","1","view_pictures","2015-06-13 07:09:11");
INSERT INTO user_log VALUES("523","1","add_pictures","2015-06-13 07:09:21");
INSERT INTO user_log VALUES("524","1","add_pictures","2015-06-13 07:10:48");
INSERT INTO user_log VALUES("525","1","add_pictures","2015-06-13 07:11:39");
INSERT INTO user_log VALUES("526","0","view_pictures","2015-06-13 09:45:12");
INSERT INTO user_log VALUES("527","1","","2015-06-13 09:47:43");
INSERT INTO user_log VALUES("528","1","view_pictures","2015-06-13 09:48:53");
INSERT INTO user_log VALUES("529","0","view_pictures","2015-06-13 11:27:33");
INSERT INTO user_log VALUES("530","1","","2015-06-13 11:28:04");
INSERT INTO user_log VALUES("531","1","view_pictures","2015-06-13 11:28:14");
INSERT INTO user_log VALUES("532","1","view_pictures","2015-06-13 11:29:17");
INSERT INTO user_log VALUES("533","1","view_pictures","2015-06-13 11:32:31");
INSERT INTO user_log VALUES("534","1","view_pictures","2015-06-13 11:33:02");
INSERT INTO user_log VALUES("535","1","view_pictures","2015-06-13 11:33:46");
INSERT INTO user_log VALUES("536","1","add_pictures","2015-06-13 11:38:26");
INSERT INTO user_log VALUES("537","1","add_pictures","2015-06-13 11:39:19");
INSERT INTO user_log VALUES("538","1","view_pictures","2015-06-13 11:45:15");
INSERT INTO user_log VALUES("539","1","view_events","2015-06-13 11:52:14");
INSERT INTO user_log VALUES("540","1","trashed_events","2015-06-13 11:52:21");
INSERT INTO user_log VALUES("541","1","view_events","2015-06-13 11:52:26");
INSERT INTO user_log VALUES("542","1","trashed_events","2015-06-13 11:52:32");
INSERT INTO user_log VALUES("543","1","trashed_events","2015-06-13 11:53:09");
INSERT INTO user_log VALUES("544","1","view_events","2015-06-13 11:53:13");
INSERT INTO user_log VALUES("545","1","delete_events","2015-06-13 11:53:22");
INSERT INTO user_log VALUES("546","1","view_events","2015-06-13 11:53:25");
INSERT INTO user_log VALUES("547","1","trashed_events","2015-06-13 11:53:29");
INSERT INTO user_log VALUES("548","1","trashed_events","2015-06-13 11:53:44");
INSERT INTO user_log VALUES("549","1","view_events","2015-06-13 11:53:50");
INSERT INTO user_log VALUES("550","1","view_pictures","2015-06-13 11:53:57");
INSERT INTO user_log VALUES("551","1","add_pictures","2015-06-13 11:54:17");
INSERT INTO user_log VALUES("552","1","save_pictures","2015-06-13 11:54:49");
INSERT INTO user_log VALUES("553","1","view_pictures","2015-06-13 11:54:51");
INSERT INTO user_log VALUES("554","1","view_pictures","2015-06-13 12:09:22");
INSERT INTO user_log VALUES("555","1","edit_pictures","2015-06-13 12:09:34");
INSERT INTO user_log VALUES("556","1","edit_pictures","2015-06-13 12:10:13");
INSERT INTO user_log VALUES("557","0","view_pictures","2015-06-13 12:31:08");
INSERT INTO user_log VALUES("558","0","edit_pictures","2015-06-13 12:33:25");
INSERT INTO user_log VALUES("559","0","update_pictures","2015-06-13 12:36:32");
INSERT INTO user_log VALUES("560","0","view_pictures","2015-06-13 12:36:34");
INSERT INTO user_log VALUES("561","0","unpublish_pictures","2015-06-13 12:37:45");
INSERT INTO user_log VALUES("562","0","view_pictures","2015-06-13 12:37:47");
INSERT INTO user_log VALUES("563","0","publish_pictures","2015-06-13 12:37:56");
INSERT INTO user_log VALUES("564","0","view_pictures","2015-06-13 12:37:58");
INSERT INTO user_log VALUES("565","0","delete_pictures","2015-06-13 12:38:10");
INSERT INTO user_log VALUES("566","0","view_pictures","2015-06-13 12:38:12");
INSERT INTO user_log VALUES("567","0","trashed_pictures","2015-06-13 12:38:18");
INSERT INTO user_log VALUES("568","0","trashed_pictures","2015-06-13 12:40:03");
INSERT INTO user_log VALUES("569","0","trashed_pictures","2015-06-13 12:40:13");
INSERT INTO user_log VALUES("570","0","trashed_pictures","2015-06-13 12:40:54");
INSERT INTO user_log VALUES("571","0","trashed_pictures","2015-06-13 12:41:04");
INSERT INTO user_log VALUES("572","0","view_pictures","2015-06-13 12:41:09");
INSERT INTO user_log VALUES("573","0","delete_pictures","2015-06-13 12:41:22");
INSERT INTO user_log VALUES("574","0","view_pictures","2015-06-13 12:41:24");
INSERT INTO user_log VALUES("575","0","trashed_pictures","2015-06-13 12:41:31");
INSERT INTO user_log VALUES("576","0","restore_pictures","2015-06-13 12:41:44");
INSERT INTO user_log VALUES("577","0","trashed_pictures","2015-06-13 12:41:46");
INSERT INTO user_log VALUES("578","0","view_pictures","2015-06-13 12:41:53");
INSERT INTO user_log VALUES("579","0","publish_pictures","2015-06-13 12:42:16");
INSERT INTO user_log VALUES("580","0","view_pictures","2015-06-13 12:42:18");
INSERT INTO user_log VALUES("581","0","publish_pictures","2015-06-13 12:42:20");
INSERT INTO user_log VALUES("582","0","view_pictures","2015-06-13 12:42:22");
INSERT INTO user_log VALUES("583","0","add_pictures","2015-06-13 12:42:44");
INSERT INTO user_log VALUES("584","0","","2015-06-13 12:42:50");
INSERT INTO user_log VALUES("585","1","","2015-06-13 12:44:05");
INSERT INTO user_log VALUES("586","1","view_pictures","2015-06-13 12:44:13");
INSERT INTO user_log VALUES("587","1","unpublish_pictures","2015-06-13 12:44:28");
INSERT INTO user_log VALUES("588","1","view_pictures","2015-06-13 12:44:30");
INSERT INTO user_log VALUES("589","1","view_pictures","2015-06-13 12:45:49");
INSERT INTO user_log VALUES("590","0","view_pictures","2015-06-13 13:48:50");
INSERT INTO user_log VALUES("591","1","","2015-06-13 13:49:08");
INSERT INTO user_log VALUES("592","1","view_videos","2015-06-13 13:53:18");
INSERT INTO user_log VALUES("593","1","view_videos","2015-06-13 13:58:13");
INSERT INTO user_log VALUES("594","1","view_videos","2015-06-13 13:58:31");
INSERT INTO user_log VALUES("595","1","view_videos","2015-06-13 13:59:15");
INSERT INTO user_log VALUES("596","1","add_videos","2015-06-13 13:59:23");
INSERT INTO user_log VALUES("597","1","","2015-06-13 14:01:52");
INSERT INTO user_log VALUES("598","1","view_videos","2015-06-13 14:02:01");
INSERT INTO user_log VALUES("599","1","add_videos","2015-06-13 14:02:07");
INSERT INTO user_log VALUES("600","1","view_videos","2015-06-13 14:12:19");
INSERT INTO user_log VALUES("601","1","view_videos","2015-06-13 14:14:58");
INSERT INTO user_log VALUES("602","1","add_videos","2015-06-13 14:30:05");
INSERT INTO user_log VALUES("603","1","add_videos","2015-06-13 14:37:43");
INSERT INTO user_log VALUES("604","1","add_videos","2015-06-13 14:38:22");
INSERT INTO user_log VALUES("605","1","add_videos","2015-06-13 14:39:01");
INSERT INTO user_log VALUES("606","1","view_videos","2015-06-13 14:39:33");
INSERT INTO user_log VALUES("607","1","add_videos","2015-06-13 14:39:52");
INSERT INTO user_log VALUES("608","1","add_videos","2015-06-13 14:55:23");
INSERT INTO user_log VALUES("609","1","save_videos","2015-06-13 14:56:20");
INSERT INTO user_log VALUES("610","1","view_videos","2015-06-13 14:56:22");
INSERT INTO user_log VALUES("611","1","edit_videos","2015-06-13 14:56:42");
INSERT INTO user_log VALUES("612","1","update_videos","2015-06-13 14:57:09");
INSERT INTO user_log VALUES("613","1","view_videos","2015-06-13 14:57:11");
INSERT INTO user_log VALUES("614","1","view_videos","2015-06-13 14:58:14");
INSERT INTO user_log VALUES("615","1","publish_videos","2015-06-13 14:58:26");
INSERT INTO user_log VALUES("616","1","view_videos","2015-06-13 14:58:28");
INSERT INTO user_log VALUES("617","1","unpublish_videos","2015-06-13 14:59:30");
INSERT INTO user_log VALUES("618","1","view_videos","2015-06-13 14:59:33");
INSERT INTO user_log VALUES("619","1","publish_videos","2015-06-13 14:59:42");
INSERT INTO user_log VALUES("620","1","view_videos","2015-06-13 14:59:44");
INSERT INTO user_log VALUES("621","1","delete_videos","2015-06-13 14:59:59");
INSERT INTO user_log VALUES("622","1","view_videos","2015-06-13 15:00:01");
INSERT INTO user_log VALUES("623","1","trashed_videos","2015-06-13 15:00:07");
INSERT INTO user_log VALUES("624","1","trashed_videos","2015-06-13 15:00:50");
INSERT INTO user_log VALUES("625","1","trashed_videos","2015-06-13 15:01:04");
INSERT INTO user_log VALUES("626","1","view_videos","2015-06-13 15:01:10");
INSERT INTO user_log VALUES("627","1","delete_videos","2015-06-13 15:01:19");
INSERT INTO user_log VALUES("628","1","view_videos","2015-06-13 15:01:21");
INSERT INTO user_log VALUES("629","1","trashed_videos","2015-06-13 15:01:29");
INSERT INTO user_log VALUES("630","1","restore_videos","2015-06-13 15:01:39");
INSERT INTO user_log VALUES("631","1","trashed_videos","2015-06-13 15:01:41");
INSERT INTO user_log VALUES("632","1","view_videos","2015-06-13 15:01:46");
INSERT INTO user_log VALUES("633","0","publish_videos","2015-06-13 15:01:57");
INSERT INTO user_log VALUES("634","0","view_videos","2015-06-13 15:01:59");
INSERT INTO user_log VALUES("635","0","","2015-06-13 15:02:17");
INSERT INTO user_log VALUES("636","1","","2015-06-13 22:09:52");
INSERT INTO user_log VALUES("637","0","","2015-06-14 11:23:47");
INSERT INTO user_log VALUES("638","1","","2015-06-14 11:25:15");
INSERT INTO user_log VALUES("639","1","view_system_backup","2015-06-14 11:25:49");
INSERT INTO user_log VALUES("640","1","view_system_backup","2015-06-14 11:25:59");
INSERT INTO user_log VALUES("641","1","view_system_backup","2015-06-14 11:45:13");
INSERT INTO user_log VALUES("642","1","view_system_backup","2015-06-14 11:49:43");
INSERT INTO user_log VALUES("643","1","view_system_backup","2015-06-14 11:52:31");
INSERT INTO user_log VALUES("644","0","","2015-06-14 12:54:43");
INSERT INTO user_log VALUES("645","1","","2015-06-14 12:55:01");
INSERT INTO user_log VALUES("646","0","","2015-06-14 16:30:42");
INSERT INTO user_log VALUES("647","1","","2015-06-14 16:31:00");
INSERT INTO user_log VALUES("648","1","","2015-06-14 16:31:02");
INSERT INTO user_log VALUES("649","1","view_system_backup","2015-06-14 16:31:18");
INSERT INTO user_log VALUES("650","1","view_system_backup","2015-06-14 16:32:26");
INSERT INTO user_log VALUES("651","1","view_system_backup","2015-06-14 16:33:34");
INSERT INTO user_log VALUES("652","1","view_system_backup","2015-06-14 16:33:59");
INSERT INTO user_log VALUES("653","1","view_system_backup","2015-06-14 16:46:10");
INSERT INTO user_log VALUES("654","1","view_system_backup","2015-06-14 16:46:12");
INSERT INTO user_log VALUES("655","1","add_backup","2015-06-14 16:46:19");
INSERT INTO user_log VALUES("656","1","add_backup","2015-06-14 16:49:31");
INSERT INTO user_log VALUES("657","1","add_backup","2015-06-14 16:51:02");
INSERT INTO user_log VALUES("658","1","view_system_backup","2015-06-14 16:51:12");
INSERT INTO user_log VALUES("659","1","add_backup","2015-06-14 16:51:18");
INSERT INTO user_log VALUES("660","1","view_system_backup","2015-06-14 16:52:07");
INSERT INTO user_log VALUES("661","1","view_system_backup","2015-06-14 16:57:23");
INSERT INTO user_log VALUES("662","1","add_system_backup","2015-06-14 16:57:30");
INSERT INTO user_log VALUES("663","0","","2015-06-15 11:30:50");
INSERT INTO user_log VALUES("664","1","","2015-06-15 11:31:26");
INSERT INTO user_log VALUES("665","1","","2015-06-15 11:34:06");
INSERT INTO user_log VALUES("666","1","jrjfr","2015-06-15 11:34:28");
INSERT INTO user_log VALUES("667","1","jrjfr","2015-06-15 11:34:59");
INSERT INTO user_log VALUES("668","1","jrjfr","2015-06-15 11:35:04");
INSERT INTO user_log VALUES("669","1","jrjfr","2015-06-15 11:38:51");
INSERT INTO user_log VALUES("670","1","jrjfr","2015-06-15 11:39:30");
INSERT INTO user_log VALUES("671","1","jrjfr","2015-06-15 11:39:56");
INSERT INTO user_log VALUES("672","1","jrjfr","2015-06-15 11:40:20");
INSERT INTO user_log VALUES("673","1","jrjfr","2015-06-15 11:40:42");
INSERT INTO user_log VALUES("674","1","jrjfr","2015-06-15 11:41:18");
INSERT INTO user_log VALUES("675","1","jrjfr","2015-06-15 11:42:15");
INSERT INTO user_log VALUES("676","1","jrjfr","2015-06-15 11:43:40");
INSERT INTO user_log VALUES("677","1","jrjfr","2015-06-15 11:44:13");
INSERT INTO user_log VALUES("678","1","jrjfr","2015-06-15 11:44:33");
INSERT INTO user_log VALUES("679","1","jrjfr","2015-06-15 11:46:39");
INSERT INTO user_log VALUES("680","1","","2015-06-15 11:47:06");
INSERT INTO user_log VALUES("681","1","","2015-06-15 11:50:37");
INSERT INTO user_log VALUES("682","1","","2015-06-15 11:51:18");
INSERT INTO user_log VALUES("683","1","","2015-06-15 11:51:40");
INSERT INTO user_log VALUES("684","1","","2015-06-15 11:52:16");
INSERT INTO user_log VALUES("685","1","","2015-06-15 11:53:07");
INSERT INTO user_log VALUES("686","1","","2015-06-15 11:53:33");
INSERT INTO user_log VALUES("687","1","view_users","2015-06-15 11:54:02");
INSERT INTO user_log VALUES("688","1","jhbjfd","2015-06-15 11:54:20");
INSERT INTO user_log VALUES("689","1","jhbjfd","2015-06-15 11:54:51");
INSERT INTO user_log VALUES("690","1","jhbjfd","2015-06-15 11:55:21");
INSERT INTO user_log VALUES("691","1","jhbjfd","2015-06-15 11:55:39");
INSERT INTO user_log VALUES("692","1","jhbjfd","2015-06-15 11:56:17");
INSERT INTO user_log VALUES("693","1","view_system_log","2015-06-15 12:11:35");
INSERT INTO user_log VALUES("694","1","view_ip_filter","2015-06-15 12:11:41");
INSERT INTO user_log VALUES("695","0","view_ip_filter","2015-06-15 12:44:25");
INSERT INTO user_log VALUES("696","1","","2015-06-15 12:48:28");
INSERT INTO user_log VALUES("697","1","","2015-06-15 12:55:18");
INSERT INTO user_log VALUES("698","1","","2015-06-15 13:38:31");
INSERT INTO user_log VALUES("699","1","","2015-06-15 13:39:26");
INSERT INTO user_log VALUES("700","1","add_events","2015-06-15 13:39:33");
INSERT INTO user_log VALUES("701","1","view_departments","2015-06-15 13:39:46");
INSERT INTO user_log VALUES("702","1","view_departments","2015-06-15 13:42:58");
INSERT INTO user_log VALUES("703","1","view_faculties","2015-06-15 13:43:44");
INSERT INTO user_log VALUES("704","1","","2015-06-15 13:44:00");
INSERT INTO user_log VALUES("705","1","","2015-06-15 13:47:59");
INSERT INTO user_log VALUES("706","1","","2015-06-15 14:00:56");
INSERT INTO user_log VALUES("707","1","","2015-06-15 18:21:47");
INSERT INTO user_log VALUES("708","1","","2015-06-15 18:21:49");
INSERT INTO user_log VALUES("709","1","","2015-06-15 18:22:29");
INSERT INTO user_log VALUES("710","1","","2015-06-15 18:30:04");
INSERT INTO user_log VALUES("711","1","","2015-06-15 18:30:06");
INSERT INTO user_log VALUES("712","1","","2015-06-15 18:38:26");
INSERT INTO user_log VALUES("713","1","","2015-06-15 18:39:32");
INSERT INTO user_log VALUES("714","1","","2015-06-15 18:39:34");
INSERT INTO user_log VALUES("715","1","","2015-06-15 18:44:31");
INSERT INTO user_log VALUES("716","1","","2015-06-15 18:44:56");
INSERT INTO user_log VALUES("717","1","","2015-06-15 18:45:08");
INSERT INTO user_log VALUES("718","1","","2015-06-15 18:46:22");
INSERT INTO user_log VALUES("719","1","","2015-06-15 18:46:37");
INSERT INTO user_log VALUES("720","1","","2015-06-15 18:46:43");
INSERT INTO user_log VALUES("721","1","","2015-06-15 18:47:13");
INSERT INTO user_log VALUES("722","1","","2015-06-15 18:47:18");
INSERT INTO user_log VALUES("723","1","","2015-06-15 18:48:06");
INSERT INTO user_log VALUES("724","1","","2015-06-15 18:49:52");
INSERT INTO user_log VALUES("725","1","","2015-06-15 18:50:28");
INSERT INTO user_log VALUES("726","1","","2015-06-15 18:50:48");
INSERT INTO user_log VALUES("727","1","","2015-06-15 18:52:15");
INSERT INTO user_log VALUES("728","1","","2015-06-15 18:52:44");
INSERT INTO user_log VALUES("729","1","","2015-06-15 18:53:42");
INSERT INTO user_log VALUES("730","1","","2015-06-15 18:54:26");
INSERT INTO user_log VALUES("731","1","","2015-06-15 18:56:18");
INSERT INTO user_log VALUES("732","1","","2015-06-15 18:56:47");
INSERT INTO user_log VALUES("733","1","","2015-06-15 18:57:09");
INSERT INTO user_log VALUES("734","1","","2015-06-15 18:57:36");
INSERT INTO user_log VALUES("735","1","","2015-06-15 18:59:42");
INSERT INTO user_log VALUES("736","1","","2015-06-15 19:00:02");
INSERT INTO user_log VALUES("737","1","","2015-06-15 19:01:35");
INSERT INTO user_log VALUES("738","1","","2015-06-15 19:02:39");
INSERT INTO user_log VALUES("739","1","","2015-06-15 19:22:48");
INSERT INTO user_log VALUES("740","1","","2015-06-15 19:32:31");
INSERT INTO user_log VALUES("741","1","","2015-06-15 19:33:42");
INSERT INTO user_log VALUES("742","1","","2015-06-15 19:34:37");
INSERT INTO user_log VALUES("743","1","","2015-06-15 19:34:52");
INSERT INTO user_log VALUES("744","1","add_users","2015-06-15 19:44:10");
INSERT INTO user_log VALUES("745","0","","2015-06-15 19:44:33");
INSERT INTO user_log VALUES("746","0","","2015-06-15 19:45:04");
INSERT INTO user_log VALUES("747","1","add_users","2015-06-15 19:46:01");
INSERT INTO user_log VALUES("748","1","","2015-06-15 19:47:44");
INSERT INTO user_log VALUES("749","0","","2015-06-15 19:48:06");
INSERT INTO user_log VALUES("750","0","","2015-06-16 06:25:26");
INSERT INTO user_log VALUES("751","1","","2015-06-16 06:50:19");
INSERT INTO user_log VALUES("752","1","","2015-06-16 06:56:50");
INSERT INTO user_log VALUES("753","1","","2015-06-16 06:59:06");
INSERT INTO user_log VALUES("754","1","","2015-06-16 07:01:19");
INSERT INTO user_log VALUES("755","1","","2015-06-16 07:01:50");
INSERT INTO user_log VALUES("756","1","","2015-06-16 07:02:32");
INSERT INTO user_log VALUES("757","1","","2015-06-16 07:42:32");
INSERT INTO user_log VALUES("758","1","view_system_backup","2015-06-16 07:54:09");
INSERT INTO user_log VALUES("759","1","add_system_backup","2015-06-16 07:54:16");
INSERT INTO user_log VALUES("760","1","","2015-06-16 07:58:40");
INSERT INTO user_log VALUES("761","1","","2015-06-16 07:59:06");
INSERT INTO user_log VALUES("762","1","","2015-06-16 08:08:11");
INSERT INTO user_log VALUES("763","1","","2015-06-16 08:18:03");
INSERT INTO user_log VALUES("764","1","","2015-06-16 08:20:31");
INSERT INTO user_log VALUES("765","1","view_system_log","2015-06-16 08:23:12");
INSERT INTO user_log VALUES("766","1","","2015-06-16 12:00:35");
INSERT INTO user_log VALUES("767","1","","2015-06-16 12:02:42");
INSERT INTO user_log VALUES("768","1","","2015-06-16 12:03:07");
INSERT INTO user_log VALUES("769","1","view_system_backup","2015-06-16 12:03:14");
INSERT INTO user_log VALUES("770","1","view_departments","2015-06-16 12:03:43");
INSERT INTO user_log VALUES("771","1","add_departments","2015-06-16 12:03:50");
INSERT INTO user_log VALUES("772","0","view_departments","2015-06-16 12:04:29");
INSERT INTO user_log VALUES("773","1","","2015-06-16 12:07:15");
INSERT INTO user_log VALUES("774","1","add_events","2015-06-16 12:07:42");
INSERT INTO user_log VALUES("775","1","view_ip_filter","2015-06-16 12:07:55");
INSERT INTO user_log VALUES("776","1","add_ips","2015-06-16 12:07:59");
INSERT INTO user_log VALUES("777","0","view_ip_filter","2015-06-16 12:08:35");
INSERT INTO user_log VALUES("778","0","view_ip_filter","2015-06-16 12:08:56");
INSERT INTO user_log VALUES("779","0","view_news","2015-06-16 12:09:06");
INSERT INTO user_log VALUES("780","1","","2015-06-16 12:19:41");
INSERT INTO user_log VALUES("781","1","add_news","2015-06-16 12:19:49");
INSERT INTO user_log VALUES("782","1","view_faculties","2015-06-16 12:20:41");
INSERT INTO user_log VALUES("783","1","add_faculties","2015-06-16 12:20:51");
INSERT INTO user_log VALUES("784","0","view_faculties","2015-06-16 12:23:11");
INSERT INTO user_log VALUES("785","1","","2015-06-16 12:26:01");
INSERT INTO user_log VALUES("786","1","add_events","2015-06-16 12:26:27");
INSERT INTO user_log VALUES("787","1","view_system_log","2015-06-16 12:26:33");
INSERT INTO user_log VALUES("788","0","view_faculties","2015-06-16 12:27:15");
INSERT INTO user_log VALUES("789","1","","2015-06-16 12:27:32");
INSERT INTO user_log VALUES("790","1","add_events","2015-06-16 12:28:12");
INSERT INTO user_log VALUES("791","1","view_courses","2015-06-16 12:28:19");
INSERT INTO user_log VALUES("792","0","add_courses","2015-06-16 12:30:15");
INSERT INTO user_log VALUES("793","1","","2015-06-16 12:34:20");
INSERT INTO user_log VALUES("794","1","view_faculties","2015-06-16 12:34:30");
INSERT INTO user_log VALUES("795","1","add_faculties","2015-06-16 12:36:16");
INSERT INTO user_log VALUES("796","1","view_faculties","2015-06-16 12:36:21");
INSERT INTO user_log VALUES("797","1","view_faculties","2015-06-16 12:37:54");
INSERT INTO user_log VALUES("798","1","view_faculties","2015-06-16 12:51:56");
INSERT INTO user_log VALUES("799","1","","2015-06-16 12:51:58");
INSERT INTO user_log VALUES("800","1","","2015-06-16 12:52:01");
INSERT INTO user_log VALUES("801","1","","2015-06-16 12:52:03");
INSERT INTO user_log VALUES("802","1","","2015-06-16 12:52:05");
INSERT INTO user_log VALUES("803","1","","2015-06-16 12:52:07");
INSERT INTO user_log VALUES("804","1","","2015-06-16 12:52:09");
INSERT INTO user_log VALUES("805","1","","2015-06-16 12:52:11");
INSERT INTO user_log VALUES("806","1","","2015-06-16 12:52:13");
INSERT INTO user_log VALUES("807","1","","2015-06-16 12:52:15");
INSERT INTO user_log VALUES("808","1","","2015-06-16 12:52:18");
INSERT INTO user_log VALUES("809","1","","2015-06-16 12:52:20");
INSERT INTO user_log VALUES("810","1","view_news","2015-06-16 12:52:26");
INSERT INTO user_log VALUES("811","0","view_news","2015-06-16 12:53:03");
INSERT INTO user_log VALUES("812","1","","2015-06-16 12:53:21");
INSERT INTO user_log VALUES("813","0","view_system_backup","2015-06-16 12:54:20");
INSERT INTO user_log VALUES("814","1","","2015-06-16 13:02:11");
INSERT INTO user_log VALUES("815","1","view_system_backup","2015-06-16 13:02:13");
INSERT INTO user_log VALUES("816","1","","2015-06-16 13:02:15");
INSERT INTO user_log VALUES("817","1","","2015-06-16 13:02:17");
INSERT INTO user_log VALUES("818","1","","2015-06-16 13:02:19");
INSERT INTO user_log VALUES("819","1","","2015-06-16 13:02:21");
INSERT INTO user_log VALUES("820","1","","2015-06-16 13:02:23");
INSERT INTO user_log VALUES("821","1","","2015-06-16 13:02:26");
INSERT INTO user_log VALUES("822","1","","2015-06-16 13:02:28");
INSERT INTO user_log VALUES("823","1","","2015-06-16 13:02:30");
INSERT INTO user_log VALUES("824","1","","2015-06-16 13:02:32");
INSERT INTO user_log VALUES("825","1","","2015-06-16 13:02:34");
INSERT INTO user_log VALUES("826","1","","2015-06-16 13:02:36");
INSERT INTO user_log VALUES("827","1","","2015-06-16 13:02:38");
INSERT INTO user_log VALUES("828","1","","2015-06-16 13:02:41");
INSERT INTO user_log VALUES("829","1","","2015-06-16 13:02:43");
INSERT INTO user_log VALUES("830","1","","2015-06-16 13:02:45");
INSERT INTO user_log VALUES("831","1","","2015-06-16 13:02:47");
INSERT INTO user_log VALUES("832","1","","2015-06-16 13:02:49");
INSERT INTO user_log VALUES("833","1","","2015-06-16 13:02:51");
INSERT INTO user_log VALUES("834","1","","2015-06-16 13:02:54");
INSERT INTO user_log VALUES("835","1","","2015-06-16 13:07:23");
INSERT INTO user_log VALUES("836","1","view_users","2015-06-16 13:07:33");
INSERT INTO user_log VALUES("837","1","add_users","2015-06-16 13:07:38");
INSERT INTO user_log VALUES("838","0","view_users","2015-06-16 13:08:12");
INSERT INTO user_log VALUES("839","1","","2015-06-16 13:08:30");
INSERT INTO user_log VALUES("840","1","view_users","2015-06-16 13:08:32");
INSERT INTO user_log VALUES("841","0","view_departments","2015-06-16 13:08:45");
INSERT INTO user_log VALUES("842","1","","2015-06-16 13:09:06");
INSERT INTO user_log VALUES("843","1","view_departments","2015-06-16 13:09:08");
INSERT INTO user_log VALUES("844","0","add_departments","2015-06-16 13:10:47");
INSERT INTO user_log VALUES("845","1","","2015-06-16 13:11:06");
INSERT INTO user_log VALUES("846","1","add_departments","2015-06-16 13:11:08");
INSERT INTO user_log VALUES("847","0","view_system_log","2015-06-16 13:12:21");
INSERT INTO user_log VALUES("848","1","","2015-06-16 13:14:30");
INSERT INTO user_log VALUES("849","1","view_system_log","2015-06-16 13:14:32");
INSERT INTO user_log VALUES("850","1","","2015-06-16 13:19:42");
INSERT INTO user_log VALUES("851","1","view_users","2015-06-16 13:19:49");
INSERT INTO user_log VALUES("852","1","view_users","2015-06-16 13:19:53");
INSERT INTO user_log VALUES("853","1","edit_user","2015-06-16 13:20:36");
INSERT INTO user_log VALUES("854","1","view_profile","2015-06-16 13:21:04");
INSERT INTO user_log VALUES("855","1","","2015-06-16 13:22:24");
INSERT INTO user_log VALUES("856","1","","2015-06-16 13:22:40");
INSERT INTO user_log VALUES("857","1","","2015-06-16 13:33:23");
INSERT INTO user_log VALUES("858","1","","2015-06-16 14:12:25");
INSERT INTO user_log VALUES("859","1","view_system_backup","2015-06-16 14:34:28");
INSERT INTO user_log VALUES("860","1","view_users","2015-06-16 14:34:35");
INSERT INTO user_log VALUES("861","1","","2015-06-16 14:45:05");
INSERT INTO user_log VALUES("862","1","","2015-06-16 16:20:22");
INSERT INTO user_log VALUES("863","1","","2015-06-16 16:31:19");
INSERT INTO user_log VALUES("864","1","","2015-06-16 21:19:31");
INSERT INTO user_log VALUES("865","1","","2015-06-16 21:23:41");
INSERT INTO user_log VALUES("866","1","","2015-06-17 01:16:38");
INSERT INTO user_log VALUES("867","1","","2015-06-17 02:03:18");
INSERT INTO user_log VALUES("868","1","view_system_backup","2015-06-17 02:03:41");
INSERT INTO user_log VALUES("869","1","add_system_backup","2015-06-17 02:03:54");
INSERT INTO user_log VALUES("870","1","view_reports","2015-06-17 02:10:28");
INSERT INTO user_log VALUES("871","1","view_reports","2015-06-17 02:10:47");
INSERT INTO user_log VALUES("872","1","view_reports","2015-06-17 02:11:27");
INSERT INTO user_log VALUES("873","1","view_system_backup","2015-06-17 02:11:39");
INSERT INTO user_log VALUES("874","1","view_reports","2015-06-17 02:11:45");
INSERT INTO user_log VALUES("875","1","view_news","2015-06-17 02:11:54");
INSERT INTO user_log VALUES("876","1","view_reports","2015-06-17 02:12:02");
INSERT INTO user_log VALUES("877","1","","2015-06-17 07:13:39");
INSERT INTO user_log VALUES("878","1","view_reports","2015-06-17 07:13:46");
INSERT INTO user_log VALUES("879","1","","2015-06-17 09:27:37");
INSERT INTO user_log VALUES("880","1","view_reports","2015-06-17 09:27:48");
INSERT INTO user_log VALUES("881","1","","2015-06-17 09:28:27");
INSERT INTO user_log VALUES("882","1","","2015-06-17 09:28:34");
INSERT INTO user_log VALUES("883","1","","2015-06-17 12:14:24");
INSERT INTO user_log VALUES("884","1","view_subjects","2015-06-17 12:15:56");
INSERT INTO user_log VALUES("885","1","view_system_log","2015-06-17 12:17:12");
INSERT INTO user_log VALUES("886","1","view_control_boxs","2015-06-17 12:17:33");
INSERT INTO user_log VALUES("887","1","view_reports","2015-06-17 12:17:43");
INSERT INTO user_log VALUES("888","1","view_ip_filter","2015-06-17 12:18:46");
INSERT INTO user_log VALUES("889","1","view_faculties","2015-06-17 12:20:09");
INSERT INTO user_log VALUES("890","1","view_departments","2015-06-17 12:20:32");
INSERT INTO user_log VALUES("891","1","view_courses","2015-06-17 12:20:44");
INSERT INTO user_log VALUES("892","1","view_subjects","2015-06-17 12:20:58");
INSERT INTO user_log VALUES("893","1","view_faculties","2015-06-17 12:21:08");
INSERT INTO user_log VALUES("894","1","view_user_groups","2015-06-17 12:21:37");
INSERT INTO user_log VALUES("895","1","","2015-06-17 12:21:51");
INSERT INTO user_log VALUES("896","1","view_courses","2015-06-17 12:22:23");
INSERT INTO user_log VALUES("897","1","view_departments","2015-06-17 12:22:33");
INSERT INTO user_log VALUES("898","1","view_faculties","2015-06-17 12:22:39");
INSERT INTO user_log VALUES("899","1","view_faculties","2015-06-17 12:22:41");
INSERT INTO user_log VALUES("900","1","","2015-06-17 13:41:08");
INSERT INTO user_log VALUES("901","1","view_news","2015-06-17 13:42:19");
INSERT INTO user_log VALUES("902","1","","2015-06-18 11:16:24");
INSERT INTO user_log VALUES("903","1","view_ip_filter","2015-06-18 11:16:43");
INSERT INTO user_log VALUES("904","1","view_users","2015-06-18 11:17:22");
INSERT INTO user_log VALUES("905","1","add_users","2015-06-18 11:18:42");
INSERT INTO user_log VALUES("906","1","view_users","2015-06-18 11:19:02");
INSERT INTO user_log VALUES("907","1","view_faculties","2015-06-18 11:19:25");
INSERT INTO user_log VALUES("908","1","view_faculties","2015-06-18 11:20:14");
INSERT INTO user_log VALUES("909","1","unpublish_faculties","2015-06-18 11:21:33");
INSERT INTO user_log VALUES("910","1","view_faculties","2015-06-18 11:21:35");
INSERT INTO user_log VALUES("911","1","publish_faculties","2015-06-18 11:21:56");
INSERT INTO user_log VALUES("912","1","view_faculties","2015-06-18 11:21:59");
INSERT INTO user_log VALUES("913","1","delete_faculties","2015-06-18 11:22:36");
INSERT INTO user_log VALUES("914","1","view_faculties","2015-06-18 11:22:38");
INSERT INTO user_log VALUES("915","1","trashed_faculties","2015-06-18 11:22:47");
INSERT INTO user_log VALUES("916","1","trashed_faculties","2015-06-18 11:24:20");
INSERT INTO user_log VALUES("917","1","trashed_faculties","2015-06-18 11:28:36");
INSERT INTO user_log VALUES("918","1","view_faculties","2015-06-18 11:46:15");
INSERT INTO user_log VALUES("919","1","delete_faculties","2015-06-18 11:46:28");
INSERT INTO user_log VALUES("920","1","view_faculties","2015-06-18 11:46:31");
INSERT INTO user_log VALUES("921","1","trashed_faculties","2015-06-18 11:46:39");
INSERT INTO user_log VALUES("922","1","trashed_faculties","2015-06-18 11:47:03");
INSERT INTO user_log VALUES("923","1","","2015-06-18 22:40:31");
INSERT INTO user_log VALUES("924","1","","2015-06-19 11:45:23");
INSERT INTO user_log VALUES("925","1","view_users","2015-06-19 11:45:51");
INSERT INTO user_log VALUES("926","1","view_news","2015-06-19 11:46:53");
INSERT INTO user_log VALUES("927","1","view_videos","2015-06-19 11:48:16");
INSERT INTO user_log VALUES("928","1","add_videos","2015-06-19 11:48:24");
INSERT INTO user_log VALUES("929","1","view_faculties","2015-06-19 11:48:45");
INSERT INTO user_log VALUES("930","1","view_system_backup","2015-06-19 11:49:38");
INSERT INTO user_log VALUES("931","1","view_ip_filter","2015-06-19 11:49:50");
INSERT INTO user_log VALUES("932","1","view_system_log","2015-06-19 11:50:09");
INSERT INTO user_log VALUES("933","1","view_reports","2015-06-19 11:50:31");
INSERT INTO user_log VALUES("934","1","","2015-06-19 11:51:20");
INSERT INTO user_log VALUES("935","1","add_news","2015-06-19 11:51:28");
INSERT INTO user_log VALUES("936","1","","2015-06-23 22:36:47");
INSERT INTO user_log VALUES("937","1","","2015-06-25 04:58:19");
INSERT INTO user_log VALUES("938","1","","2015-06-25 05:00:40");
INSERT INTO user_log VALUES("939","1","","2015-06-25 05:01:28");
INSERT INTO user_log VALUES("940","1","add_events","2015-06-25 05:02:49");
INSERT INTO user_log VALUES("941","1","add_events","2015-06-25 05:05:29");
INSERT INTO user_log VALUES("942","1","add_events","2015-06-25 05:06:03");
INSERT INTO user_log VALUES("943","1","add_events","2015-06-25 05:06:25");
INSERT INTO user_log VALUES("944","1","add_events","2015-06-25 05:07:23");
INSERT INTO user_log VALUES("945","1","add_events","2015-06-25 05:08:05");
INSERT INTO user_log VALUES("946","1","add_events","2015-06-25 05:08:35");
INSERT INTO user_log VALUES("947","1","add_events","2015-06-25 05:08:59");
INSERT INTO user_log VALUES("948","1","view_faculties","2015-06-25 05:09:47");
INSERT INTO user_log VALUES("949","1","add_faculties","2015-06-25 05:09:52");
INSERT INTO user_log VALUES("950","1","view_pictures","2015-06-25 05:10:03");
INSERT INTO user_log VALUES("951","1","add_pictures","2015-06-25 05:10:08");
INSERT INTO user_log VALUES("952","1","view_pictures","2015-06-25 05:10:42");
INSERT INTO user_log VALUES("953","1","view_system_backup","2015-06-25 05:11:47");
INSERT INTO user_log VALUES("954","1","view_system_backup","2015-06-25 13:30:53");
INSERT INTO user_log VALUES("955","1","","2015-06-25 14:39:33");
INSERT INTO user_log VALUES("956","1","view_system_backup","2015-06-25 14:39:41");
INSERT INTO user_log VALUES("957","1","add_system_backup","2015-06-25 14:39:47");
INSERT INTO user_log VALUES("958","1","view_system_backup","2015-06-25 14:41:13");
INSERT INTO user_log VALUES("959","1","add_system_backup","2015-06-25 14:41:19");
INSERT INTO user_log VALUES("960","1","add_system_backup","2015-06-25 14:42:04");
INSERT INTO user_log VALUES("961","1","view_system_backup","2015-06-25 14:42:08");
INSERT INTO user_log VALUES("962","1","add_system_backup","2015-06-25 14:42:14");
INSERT INTO user_log VALUES("963","1","view_system_backup","2015-06-25 14:43:52");
INSERT INTO user_log VALUES("964","1","add_system_backup","2015-06-25 14:43:57");
INSERT INTO user_log VALUES("965","1","view_system_backup","2015-06-25 14:48:30");
INSERT INTO user_log VALUES("966","1","add_system_backup","2015-06-25 14:48:37");
INSERT INTO user_log VALUES("967","1","view_system_backup","2015-06-25 14:52:49");
INSERT INTO user_log VALUES("968","1","add_system_backup","2015-06-25 14:52:55");
INSERT INTO user_log VALUES("969","1","view_system_backup","2015-06-25 14:53:26");
INSERT INTO user_log VALUES("970","1","add_system_backup","2015-06-25 14:53:31");
INSERT INTO user_log VALUES("971","1","view_system_log","2015-06-25 14:55:56");
INSERT INTO user_log VALUES("972","1","view_control_boxs","2015-06-25 14:56:04");
INSERT INTO user_log VALUES("973","1","add_control_boxs","2015-06-25 14:56:08");
INSERT INTO user_log VALUES("974","1","view_news","2015-06-25 14:56:18");
INSERT INTO user_log VALUES("975","1","add_news","2015-06-25 14:56:22");
INSERT INTO user_log VALUES("976","1","view_system_backup","2015-06-25 14:59:24");
INSERT INTO user_log VALUES("977","1","add_system_backup","2015-06-25 14:59:31");
INSERT INTO user_log VALUES("978","1","view_system_backup","2015-06-25 15:00:57");
INSERT INTO user_log VALUES("979","1","add_system_backup","2015-06-25 15:01:03");
INSERT INTO user_log VALUES("980","1","view_system_backup","2015-06-25 15:04:39");
INSERT INTO user_log VALUES("981","1","add_system_backup","2015-06-25 15:04:45");
INSERT INTO user_log VALUES("982","1","view_system_backup","2015-06-25 15:06:49");
INSERT INTO user_log VALUES("983","1","add_system_backup","2015-06-25 15:06:54");
INSERT INTO user_log VALUES("984","1","view_system_backup","2015-06-25 15:07:25");
INSERT INTO user_log VALUES("985","1","add_system_backup","2015-06-25 15:07:30");
INSERT INTO user_log VALUES("986","1","add_system_backup","2015-06-25 15:08:54");
INSERT INTO user_log VALUES("987","1","add_system_backup","2015-06-25 15:16:11");
INSERT INTO user_log VALUES("988","1","view_system_backup","2015-06-25 15:16:14");
INSERT INTO user_log VALUES("989","1","add_system_backup","2015-06-25 15:17:13");
INSERT INTO user_log VALUES("990","1","add_system_backup","2015-06-25 15:17:17");
INSERT INTO user_log VALUES("991","1","add_system_backup","2015-06-25 15:17:20");
INSERT INTO user_log VALUES("992","1","add_system_backup","2015-06-25 15:17:23");
INSERT INTO user_log VALUES("993","1","add_system_backup","2015-06-25 15:17:26");
INSERT INTO user_log VALUES("994","1","add_system_backup","2015-06-25 15:17:30");
INSERT INTO user_log VALUES("995","1","add_system_backup","2015-06-25 15:17:33");
INSERT INTO user_log VALUES("996","1","view_system_backup","2015-06-25 15:18:22");
INSERT INTO user_log VALUES("997","1","add_system_backup","2015-06-25 15:18:28");
INSERT INTO user_log VALUES("998","1","add_system_backup","2015-06-25 15:18:31");
INSERT INTO user_log VALUES("999","1","add_system_backup","2015-06-25 15:18:35");
INSERT INTO user_log VALUES("1000","1","add_system_backup","2015-06-25 15:18:38");
INSERT INTO user_log VALUES("1001","1","add_system_backup","2015-06-25 15:18:41");
INSERT INTO user_log VALUES("1002","1","view_system_backup","2015-06-25 15:19:17");
INSERT INTO user_log VALUES("1003","1","add_system_backup","2015-06-25 15:19:24");
INSERT INTO user_log VALUES("1004","1","view_system_backup","2015-06-25 15:19:26");
INSERT INTO user_log VALUES("1005","1","view_system_backup","2015-06-25 16:32:22");
INSERT INTO user_log VALUES("1006","1","view_system_log","2015-06-25 16:32:35");
INSERT INTO user_log VALUES("1007","1","view_ip_filter","2015-06-25 16:32:43");
INSERT INTO user_log VALUES("1008","1","view_system_backup","2015-06-25 16:32:48");
INSERT INTO user_log VALUES("1009","1","view_system_backup","2015-06-25 16:33:43");
INSERT INTO user_log VALUES("1010","1","view_system_backup","2015-06-25 16:34:13");
INSERT INTO user_log VALUES("1011","1","view_system_backup","2015-06-25 16:35:13");
INSERT INTO user_log VALUES("1012","1","view_system_backup","2015-06-25 16:36:31");
INSERT INTO user_log VALUES("1013","1","view_system_backup","2015-06-25 16:38:19");
INSERT INTO user_log VALUES("1014","1","view_system_backup","2015-06-25 16:40:31");
INSERT INTO user_log VALUES("1015","1","view_system_backup","2015-06-25 16:41:51");
INSERT INTO user_log VALUES("1016","1","view_system_backup","2015-06-25 16:42:34");



DROP TABLE users;

CREATE TABLE `users` (
  `user_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` int(11) NOT NULL COMMENT 'user group id from user_groups',
  `role_id` int(11) NOT NULL,
  `first_name` varchar(255) NOT NULL,
  `other_names` varchar(255) NOT NULL,
  `gender` varchar(255) NOT NULL,
  `username` varchar(100) NOT NULL,
  `password` char(100) NOT NULL,
  `email` varchar(255) NOT NULL,
  `birthdate` varchar(255) NOT NULL,
  `phone_number` varchar(255) NOT NULL,
  `security_id` varchar(255) NOT NULL,
  `address` text NOT NULL,
  `image` varchar(255) NOT NULL,
  `user_status` int(5) NOT NULL COMMENT '0 for blocked, 1 fior active',
  `online_status` int(5) NOT NULL COMMENT '0 for offline and 1 for online',
  `ontoken` int(20) NOT NULL,
  `last_login_ip` varchar(255) NOT NULL,
  `last_login` datetime NOT NULL,
  `last_logout` datetime NOT NULL,
  `state_id` int(11) NOT NULL,
  `lga_id` int(11) NOT NULL,
  `town` varchar(255) NOT NULL,
  `published` int(5) NOT NULL COMMENT '1 - published 0 - not to published',
  `trashed` int(5) NOT NULL COMMENT '1- deleted to trash, 0 - not deleted to trash',
  `trash_delete` int(5) NOT NULL COMMENT '1 - cleared from trash , 0 - not cleared from trash',
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `date_trashed` datetime NOT NULL,
  `added_by` varchar(255) NOT NULL,
  `modified_by` varchar(255) NOT NULL,
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `username` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 COMMENT='this table holds information about users and activities';

INSERT INTO users VALUES("1","1","1","Abdulkadir","Suleiman","M","aslapai","f583a3e5ac9327834c70d36888b5e364","","","","ghost","","","1","1","0","::1","2015-06-25 14:39:31","2015-06-25 13:36:40","0","0","","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","","");
INSERT INTO users VALUES("5","3","0","Abdul","Olawalet","M","admint","d41d8cd98f00b204e9800998ecf8427e","asuleimanlapai@gmail.comt","2015-05-12","080763060889","2015-05-24-0119-SOM","                  		 lapait","B_JtV13WsAAhW8F.jpg","1","0","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","0","0","","1","0","0","2015-05-24 17:19:34","2015-05-24 23:00:48","2015-05-26 08:46:09","ghost","ghost");



DROP TABLE videos;

CREATE TABLE `videos` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `image` varchar(255) NOT NULL,
  `video` text NOT NULL,
  `youtube_link` text NOT NULL,
  `description` text NOT NULL,
  `status` int(5) NOT NULL COMMENT '0 - published, 1- unpublished, 2 - trashed, 3 - archived, 4- deleted from trash',
  `archive` int(11) NOT NULL,
  `date_added` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `date_trashed` datetime NOT NULL,
  `added_by` varchar(255) NOT NULL,
  `modified_by` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO videos VALUES("2","Carrying Out some special duties like fixing fibres","532F58BB.JPEG","","http://youtu.be/HNrGhkT90iE","mnjfsf,kjfvdsfndfkgkjsikr ","0","0","2015-02-24 08:23:47","0000-00-00 00:00:00","0000-00-00 00:00:00","ghost","");
INSERT INTO videos VALUES("3","Commissioning of the school portaltgt","Snapshot_20141022.jpg","","http://youtube.comt","                              &nbsp;m&nbsp; m mm mt","0","0","2015-06-13 14:56:20","2015-06-13 14:57:08","2015-06-13 15:01:19","ghost","ghost");



