<?php 
##################################################################
#  This is the basic that can be called  within the web application
#  Include this after the configuration file on every page
#  File name: functions.php
##################################################################

//Call the configuration file
include('../nce/includes/configuration.php');



//function get notifications error, info, info success

//instantiating Config Class
function dbc()
{
	$config = new Config();
	return $config->connect();
}
//cleaning user input and output
function clean_data($data) {
  $data = trim($data);
  $data = stripslashes($data);
  $data = strip_tags($data);
  $data = htmlspecialchars($data);
  return $data;
}

//sanitizing user input before inserting
function db_escape($dt){
	return  var_export( dbc()->real_escape_string($dt),True);

}


//Functions to fetch user's Full name
	function get_applicant_fullname($user_id)
	{
		$result = mysqli_query(dbc(),"SELECT * FROM applicants_nce WHERE id = '$user_id'"); 
		$row = mysqli_fetch_assoc($result);
		$first_name = $row['first_name'];
		$other_names = $row['other_names'];
		
		$user_fullname = $first_name . " " . $other_names;

	return $user_fullname;
	}
	

	
	
//Function to fetch email
	function get_applicant_email2($user_id)
	{
		$result = mysqli_query(dbc(),"SELECT email FROM applicants_nce WHERE id = '$user_id'"); 
		$row = mysqli_fetch_assoc($result);
		$email = $row['email'];

	return $email;
	}
	
	
	
	//Function to fetch phone number
	function get_applicant_phone_no($user_id)
	{
		$result = mysqli_query(dbc(),"SELECT phone_no FROM applicants_nce WHERE id = '$user_id'"); 
		$row = mysqli_fetch_assoc($result);
		$ph = $row['phone_number'];

	return $ph;
	}
	
	
	
	//function dat get user address 
	function get_applicant_address($user_id)
	{
		$q = "SELECT address FROM applicants_nce WHERE id = '$user_id'";
		$r = mysqli_query(dbc(),$q);
		$row = mysqli_fetch_assoc($r);
		
		return $row['address'];
		
		
	}
	
	
	
	
	//function dat get user image by id 
	function get_applicant_image2($user_id)
	{
	$q = "SELECT image FROM applicants_nce WHERE id = '$user_id'";
	$r = mysqli_query(dbc(),$q);
	$row = mysqli_fetch_assoc($r);
	
	return $row['image'];
	
	
	}
	
	
	//function dat get user application number 
	function get_applicant_application_number($user_id)
	{
	$q = "SELECT application_number FROM applicants_nce WHERE id = '$user_id'";
	$r = mysqli_query(dbc(),$q);
	$row = mysqli_fetch_assoc($r);
	
	return $row['application_number'];
	
	
	}
	
	
	
	
	
	//Function to fetch role name
	function get_role_title($role_id)
	{
		$result = mysqli_query(dbc(),"SELECT * FROM roles WHERE id = '$role_id'"); 
		$row = mysqli_fetch_assoc($result);
		$role_title = $row['role_title'];
		
	return $role_title;
	}

	//Functions to fetch user's first name
	function get_applicant_first_name($user_id)
	{
		$result = mysqli_query(dbc(),"SELECT first_name FROM applicants_nce WHERE id = '$user_id'"); 
		$row = mysqli_fetch_assoc($result);
		$first_name = $row['first_name'];
	

	return $first_name;
	}
	
	//Functions to fetch user's other names
	function get_applicant_other_names($user_id)
	{
		$result = mysqli_query(dbc(),"SELECT other_names FROM applicants_nce WHERE id = '$user_id'"); 
		$row = mysqli_fetch_assoc($result);
		$on = $row['other_names'];
	

	return $on;
	}
	
	//Functions to fetch user's marital status
	function get_applicant_ms($user_id)
	{
		$result = mysqli_query(dbc(),"SELECT marital_status FROM applicants_nce WHERE id = '$user_id'"); 
		$row = mysqli_fetch_assoc($result);
		$ms = $row['marital_status'];
	

	return $ms;
	}
	
	
		//Functions to fetch user's gender
	function get_applicant_gender($user_id)
	{
		$result = mysqli_query(dbc(),"SELECT gender FROM applicants_nce WHERE id = '$user_id'"); 
		$row = mysqli_fetch_assoc($result);
		$gd = $row['gender'];
	

	return $gd;
	}
	
	
	
		//Functions to fetch user's religion
	function get_applicant_religion($user_id)
	{
		$result = mysqli_query(dbc(),"SELECT religion FROM applicants_nce WHERE id = '$user_id'"); 
		$row = mysqli_fetch_assoc($result);
		$religion = $row['religion'];
	

	return $religion;
	}
	
	
	
		//Functions to fetch user's place of birth
	function get_applicant_pob($user_id)
	{
		$result = mysqli_query(dbc(),"SELECT place_of_birth FROM applicants_nce WHERE id = '$user_id'"); 
		$row = mysqli_fetch_assoc($result);
		$v = $row['place_of_birth'];
	

	return $v;
	}
	
	
	
	//function fetch user day
	function get_applicant_day($id)
	{
		$result = mysqli_query(dbc(),"SELECT day FROM applicants_nce WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$day = $row['day'];
		
		return $day;
	}
	
	
	
	
	//function fetch user month
	function get_applicant_month($id)
	{
		$result = mysqli_query(dbc(),"SELECT month FROM applicants_nce WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$month = $row['month'];
		
		return $month;
	}
	
	
	
	//function fetch user year
	function get_applicant_year($id)
	{
		$result = mysqli_query(dbc(),"SELECT year FROM applicants_nce WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$year = $row['year'];
		
		return $year;
	}
	
	
	//function fetch user nationality
	function get_applicant_nationality($id)
	{
		$result = mysqli_query(dbc(),"SELECT nationality FROM applicants_nce WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$n = $row['nationality'];
		
		return $n;
	}
	
	
	
	//function fetch user country
	function get_applicant_country_id($id)
	{
		$result = mysqli_query(dbc(),"SELECT country_id FROM applicants_nce WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$country_id = $row['country_id'];
		
		return $country_id;
	}
	
	
	//function fetch user state id
	function get_applicant_state_id($id)
	{
		$result = mysqli_query(dbc(),"SELECT state_id FROM applicants_nce WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$sid = $row['state_id'];
		
		return $sid;
	}
	
	//function fetch user lga id
	function get_applicant_lga_id($id)
	{
		$result = mysqli_query(dbc(),"SELECT lga_id FROM applicants_nce WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$lid = $row['lga_id'];
		
		return $lid;
	}
	
	
	
	
	//function get user permanent address
	
	function get_applicant_permanent_address($id)
	{
		$result = mysqli_query(dbc(),"SELECT permanent_address FROM applicants_nce WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$v = $row['permanent_address'];
		
		
		return $v;
	}
	
	
	
	
	//function get user guardian_name
	function get_applicant_guardian_name($id)
	{
		$result = mysqli_query(dbc(),"SELECT guardian_name FROM applicants_nce WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$v = $row['guardian_name'];
		
		
		return $v;
	}
	
	
	
	
	//function get user guardian_relationship
	function get_applicant_guardian_relationship($id)
	{
		$result = mysqli_query(dbc(),"SELECT guardian_relationship FROM applicants_nce WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$v = $row['guardian_relationship'];
		
		
		return $v;
	}


		//function get guardian_tel
	function get_applicant_guardian_tel($id)
	{
		$result = mysqli_query(dbc(),"SELECT guardian_tel FROM applicants_nce WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$v = $row['guardian_tel'];
		
		
		return $v;
	}
	
	
	
	//function get guardian_address
	function get_applicant_guardian_address($id)
	{
		$result = mysqli_query(dbc(),"SELECT guardian_address FROM applicants_nce WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$v = $row['guardian_address'];
		
		
		return $v;
	}
	
	
	
	//function get user sponsorhip type
	function get_applicant_sponsorship_type($id)
	{
		$result = mysqli_query(dbc(),"SELECT sponsorship_type FROM applicants_nce WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$v = $row['sponsorship_type'];
		
		
		return $v;
	}
	

	//function get user sponsorhip type
	function get_applicant_sponsorhip_name($id)
	{
		$result = mysqli_query(dbc(),"SELECT sponsorship_name FROM applicants_nce WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$v = $row['sponsorship_name'];
		
		
		return $v;
	}
	
	
	//function get user sponsorhip address
	function get_applicant_sponsorship_address($id)
	{
		$result = mysqli_query(dbc(),"SELECT sponsorship_address FROM applicants_nce WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$v = $row['sponsorship_address'];
		
		
		return $v;
	}
	


//function fetch user programme type
	function get_applicant_programme_type($id)
	{
		$result = mysqli_query(dbc(),"SELECT programme_type_applied_for FROM applicants_nce WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$v = $row['programme_type_applied_for'];
		
		
		return $v;
	}

	//function fetch user programme type applied for 
	function get_applicant_programme_type_applied_for($id)
	{
		$result = mysqli_query(dbc(),"SELECT programme_type_applied_for FROM applicants_nce WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$v = $row['programme_type_applied_for'];
		
		
		return $v;
	}


//function fetch user programme type applied for 
	function get_applicant_school_applied_for($id)
	{
		$result = mysqli_query(dbc(),"SELECT school_applied_for FROM applicants_nce WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$v = $row['school_applied_for'];
		
		
		return $v;
	}



//function fetch user programme_applied_for
	function get_applicant_programme_applied_for($id)
	{
		$result = mysqli_query(dbc(),"SELECT programme_applied_for FROM applicants_nce WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$v = $row['programme_applied_for'];
		
		
		return $v;
	}
	
	
	
	//function fetch applicant programme type
	function get_applicant_programme_type_admitted_to($id)
	{
		$result = mysqli_query(dbc(),"SELECT type_id FROM applicants_nce WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$v = $row['type_id'];
		
		
		return $v;
	}



//function fetch applicant department admitted into
	function get_applicant_department_admitted_to($id)
	{
		$result = mysqli_query(dbc(),"SELECT department_id FROM applicants_nce WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$v = $row['department_id'];
		
		
		return $v;
	}
	
	
	
	//function fetch applicant school admitted into
	function get_applicant_school_admitted_to($id)
	{
		$result = mysqli_query(dbc(),"SELECT school_id FROM applicants_nce WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$v = $row['school_id'];
		
		
		return $v;
	}

//function fetch applicant programme admitted into
	function get_applicant_programme_admitted_to($id)
	{
		$result = mysqli_query(dbc(),"SELECT programme_id FROM applicants_nce WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$v = $row['programme_id'];
		
		
		return $v;
	}
	
	
	//function fetch applicant programme admission serial no
	function get_applicant_programme_admission_no($id)
	{
		$result = mysqli_query(dbc(),"SELECT admission_serial_no FROM applicants_nce WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$v = $row['admission_serial_no'];
		
		
		return $v;
	}



//function fetch user department applied for
	function get_applicant_department_applied_for($id)
	{
		$result = mysqli_query(dbc(),"SELECT department_applied_for FROM applicants_nce WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$v = $row['department_applied_for'];
		
		
		return $v;
	}


	
	//function fetch user entry_year
	function get_applicant_entry_year($id)
	{
		$result = mysqli_query(dbc(),"SELECT entry_year FROM applicants_nce WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$v = $row['entry_year'];
		
		
		return $v;
	}
	
	
	
	//function fetch user health status
	function get_applicant_h_status($id)
	{
		$result = mysqli_query(dbc(),"SELECT H_status FROM applicants_nce WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$v = $row['H_status'];
		
		return $v;
	}
	
	
	
	//function fetch user disability
	function get_applicant_disability($id)
	{
		$result = mysqli_query(dbc(),"SELECT disability FROM applicants_nce WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$v = $row['disability'];
		
		return $v;
	}
	
	//function fetch user blood group
	function get_applicant_bg($id)
	{
		$result = mysqli_query(dbc(),"SELECT blood_type FROM applicants_nce WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$v = $row['blood_type'];
		
		
		return $v;
	}
	
	
	
	
	
	//function fetch user medication
	function get_applicant_medication($id)
	{
		$result = mysqli_query(dbc(),"SELECT medi FROM applicants_nce WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$v = $row['medi'];
		
		return $v;
	}
	
	


	
	
	
	
	//function fetch user credential
	function get_applicant_credential($id)
	{
		$result = mysqli_query(dbc(),"SELECT pdf_file FROM applicants_nce WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$v = $row['pdf_file'];
		
		return $v;
	}
	
	
	
	
	
	
//function select marital status 
function select_applicant_marital_status($st)
{
		
		if ($st == 'single')
		{
			$output = '<option value="0" > -- Please Select --</option>';
			$output .= '<option value="single" selected > Single</option>';
			$output .= '<option value="married" > Married</option>';
			$output .= '<option value="divorced" >Divorced</option>';
			$output .= '<option value="widowed" >Widowed</option>';
		
			
		}
		else if ($st == 'married')
		{
			$output = '<option value="0" > -- Please Select --</option>';
			$output .= '<option value="single"  > Single</option>';
			$output .= '<option value="married" selected> Married</option>';
			$output .= '<option value="divorced" >Divorced</option>';
			$output .= '<option value="widowed" >Widowed</option>';
		
			
		}
		else if ($st == 'divorced')
		{
			$output = '<option value="0" > -- Please Select --</option>';
			$output .= '<option value="single"  > Single</option>';
			$output .= '<option value="married" > Married</option>';
			$output .= '<option value="divorced" selected >Divorced</option>';
			$output .= '<option value="widowed" >Widowed</option>';
		
			
		}
		else if ($st == 'widowed')
		{
			$output = '<option value="0" > -- Please Select --</option>';
			$output .= '<option value="single"  > Single</option>';
			$output .= '<option value="married" > Married</option>';
			$output .= '<option value="divorced"  >Divorced</option>';
			$output .= '<option value="widowed" selected >Widowed</option>';
		
			
		}
		else
		{
		
			$output = '<option value="0" selected> -- Please Select --</option>';
			$output .= '<option value="single"  > Single</option>';
			$output .= '<option value="married" > Married</option>';
			$output .= '<option value="divorced" >Divorced</option>';
			$output .= '<option value="widowed" >Widowed</option>';
		
		}

	return $output;

}
//end of select marrital status



//function select gender
function select_applicant_gender($gd)
{
		
		if ($gd == 'M')
		{
			$output = '<option value="0" > -- Please Select --</option>';
			$output .= '<option value="M" selected > Male</option>';
			$output .= '<option value="F" > Female</option>';
		
			
		}
		else if ($gd == 'F')
		{
			$output = '<option value="0" > -- Please Select --</option>';
			$output .= '<option value="M"> Male</option>';
			$output .= '<option value="F" selected > Female</option>';
		
			
		}
		else
		{
		
			$output = '<option value="0"  selected  > -- Please Select --</option>';
			$output .= '<option value="M"> Male</option>';
			$output .= '<option value="F"> Female</option>';
		}

	return $output;

}
//end of select gender








//function select religion
function select_applicant_religion($r)
{
		
		if ($r == '1')
		{
			$output = '<option value="0" > -- Please Select --</option>';
			$output .= '<option value="1" selected > Islam</option>';
			$output .= '<option value="2" > Christianity</option>';
			$output .= '<option value="3" > Traditional</option>';
			$output .= '<option value="4" > Others</option>';
		
			
		}
		else if ($r == '2')
		{
			$output = '<option value="0" > -- Please Select --</option>';
			$output .= '<option value="1"  > Islam</option>';
			$output .= '<option value="2" selected > Christianity</option>';
			$output .= '<option value="3" > Traditional</option>';
			$output .= '<option value="4" > Others</option>';
		
			
		}
		else if ($r == '3')
		{
			$output = '<option value="0" > -- Please Select --</option>';
			$output .= '<option value="1"  > Islam</option>';
			$output .= '<option value="2" > Christianity</option>';
			$output .= '<option value="3" selected  > Traditional</option>';
			$output .= '<option value="4" > Others</option>';
		
			
		}
		else if ($r == '4')
		{
			$output = '<option value="0"> -- Please Select --</option>';
			$output .= '<option value="1"> Islam</option>';
			$output .= '<option value="2" > Christianity</option>';
			$output .= '<option value="3" > Traditional</option>';
			$output .= '<option value="4"  selected > Others</option>';
		
			
		}
		else
		{
		
			$output = '<option value="0"  selected> -- Please Select --</option>';
			$output .= '<option value="1"> Islam</option>';
			$output .= '<option value="2" > Christianity</option>';
			$output .= '<option value="3" > Traditional</option>';
			$output .= '<option value="4"  > Others</option>';
		}

	return $output;

}
//end of select religion


//function show religion
function show_applicant_religion($r)
{
		
		if ($r == '1')
		{
			
			$output .= 'Islam';
			
		}
		else if ($r == '2')
		{
			
			$output .= 'Christianity';
			
			
		}
		else if ($r == '3')
		{
			
			$output .= 'Traditional';
				
		}
		else if ($r == '4')
		{
			
			$output .= 'Others';
		
			
		}
		else
		{
		
			
			$output .= 'NIL';
		}

	return $output;

}
//end of show religion











//function select nationality
function select_applicant_nationality($n)
{
		
		if ($n == 'Nigerian')
		{
			$output = '<option value="0" > -- Please Select --</option>';
			$output .= '<option value="Nigerian" selected > Nigerian</option>';
			$output .= '<option value="Others" > NON Nigerian</option>';
		
			
		}
		else if ($n == 'Others')
		{
			$output = '<option value="0" > -- Please Select --</option>';
			$output .= '<option value="Nigerian" > Nigerian</option>';
			$output .= '<option value="Others"  selected>  NON Nigerian</option>';
		
			
		}
		else
		{
		
			$output = '<option value="0"  selected > -- Please Select --</option>';
			$output .= '<option value="Nigerian"> Nigerian</option>';
			$output .= '<option value="Others" > Others</option>';
		}

	return $output;

}

function show_applicant_nationality($n)
{
		
		if ($n == 'Nigerian')
		{
			$output = 'Nigerian';
		
		
			
		}
		else if ($n == 'Others')
		{
			$output = 'NON Nigerian';
		
			
		}
		else
		{
		
			$output = 'NIL';
		}

	return $output;

}



//function select sponsorship type
function select_applicant_sponsorship_type($r)
{
		
		if ($r == '1')
		{
			$output = '<option value="0" > -- Please Select --</option>';
			$output .= '<option value="1" selected > Private</option>';
			$output .= '<option value="2" > Self</option>';
			$output .= '<option value="3" > Governmental</option>';
			$output .= '<option value="4" > Others</option>';
			$output .= '<option value="5" > Nil</option>';
		
			
		}
		else if ($r == '2')
		{
			$output = '<option value="0" > -- Please Select --</option>';
			$output .= '<option value="1" > Private</option>';
			$output .= '<option value="2" selected  > Self</option>';
			$output .= '<option value="3" > Governmental</option>';
			$output .= '<option value="4" > Others</option>';
			$output .= '<option value="5" > Nil</option>';
		
		
			
		}
		else if ($r == '3')
		{
			$output = '<option value="0" > -- Please Select --</option>';
			$output .= '<option value="1" > Private</option>';
			$output .= '<option value="2"  > Self</option>';
			$output .= '<option value="3" selected  > Governmental</option>';
			$output .= '<option value="4" > Others</option>';
			$output .= '<option value="5" > Nil</option>';
		
			
		}
		else if ($r == '4')
		{
			$output = '<option value="0" > -- Please Select --</option>';
			$output .= '<option value="1" > Private</option>';
			$output .= '<option value="2" > Self</option>';
			$output .= '<option value="3" > Governmental</option>';
			$output .= '<option value="4" selected > Others</option>';
			$output .= '<option value="5" > Nil</option>';
		
		
			
		}
		else if ($r == '5')
		{
			$output = '<option value="0"  > -- Please Select --</option>';
			$output .= '<option value="1" > Private</option>';
			$output .= '<option value="2" > Self</option>';
			$output .= '<option value="3" > Governmental</option>';
			$output .= '<option value="4" > Others</option>';
			$output .= '<option value="5" selected > Nil</option>';
		
		
			
		}
		else
		{
		
			$output = '<option value="0" selected  > -- Please Select --</option>';
			$output .= '<option value="1"  > Private</option>';
			$output .= '<option value="2" > Governmental</option>';
			$output .= '<option value="3"> Others</option>';
			$output .= '<option value="4"  > Nil</option>';
		}

	return $output;

}
//end of select sponsorship type

//function show sponsorship type
function show_applicant_sponsorship_type($r)
{
		
		if ($r == '1')
		{
		
			$output = 'Private';
			
		
			
		}
		else if ($r == '2')
		{
			
			$output = 'Self';
		
			
		}
		else if ($r == '3')
		{
			$output = 'Governmental';
		
		
			
		}
		else if ($r == '4')
		{
			$output = 'Others';
		
			
		}
		else if ($r == '5')
		{
			$output = 'Nil';
		
		
			
		}
		else
		{
		
			$output = 'Nil';
		}

	return $output;

}
//end of show sponsorship type
	


//function select programme_type
function select_applicant_programme_type($pt)
{
		
		if ($pt == '1')
		{
			$output = '<option value="0" > -- Please Select --</option>';
			$output .= '<option value="1" selected > Advanced Diploma</option>';
			$output .= '<option value="2" > Diploma </option>';
			$output .= '<option value="3" > Certificate </option>';
			
		
			
		}
		else if ($pt == '2')
		{
			$output = '<option value="0" > -- Please Select --</option>';
			$output .= '<option value="1"> Advanced Diploma</option>';
			$output .= '<option value="2" selected > Diploma </option>';
			$output .= '<option value="3" > Certificate </option>';
			
		
			
		}
		else if ($pt == '3')
		{
			$output = '<option value="0" > -- Please Select --</option>';
			$output .= '<option value="1"> Advanced Diploma</option>';
			$output .= '<option value="2"> Diploma </option>';
			$output .= '<option value="3" selected  > Certificate </option>';
			
		
			
		}
		else
		{
		
			$output = '<option value="0"  selected > -- Please Select --</option>';
			$output .= '<option value="1"> Advanced Diploma</option>';
			$output .= '<option value="2" > Diploma </option>';
			$output .= '<option value="3" > Certificate </option>';
		
		}

	return $output;

}
//end of select programme_type


//function show programme_type
function show_applicant_programme_type($pt)
{
		
		if ($pt == '1')
		{
			$output = 'PRE-NCE';
			
		}
		else if ($pt == '2')
		{
			$output = 'NCE';
		
		}
		else if ($pt == '3')
		{
			$output = 'DEGREE';
		
		}
		else
		{
		
			$output = 'NIL';
		
		}

	return $output;

}
//end of show programme_type



//function select study_mode
function select_applicant_study_mode($sm)
{
		
		if ($sm == '1')
		{
			$output = 	'<option value="1" selected >Full-Time</option>';
			$output .= '<option value="2"  >Part-Time</option>';
			$output .= '<option value="3"  >Others</option>';
			
		
			
		}
		else if ($sm == '2')
		{
			$output = 	'<option value="1" >Full-Time</option>';
			$output .= '<option value="2"  selected >Part-Time</option>';
			$output .= '<option value="3"  >Others</option>';
			
		
			
		}
		else if ($sm == '3')
		{
		
			$output = 	'<option value="1" >Full-Time</option>';
			$output .= '<option value="2" >Part-Time</option>';
			$output .= '<option value="3" selected >Others</option>';
		
		}
		
		else 
		{
		
			$output = 	'<option value="1"  selected >Full-Time</option>';
			$output .= '<option value="2" >Part-Time</option>';
			$output .= '<option value="3" >Others</option>';
		
		}

	return $output;

}
//end of select study_mode





//function select H status
function select_applicant_h_status($n)
{
		
		if ($n == 'Normal')
		{
			$output = '<option value="0"> -- Please Select --</option>';
			$output .= '<option value="Normal" selected >Normal</option>';
			$output .= '<option value="Handicapped" >Handicapped</option>';
			$output .= '<option value="Others" >Others</option>';
			
			
		}
		else if ($n == 'Handicapped')
		{
			$output = '<option value="0"> -- Please Select --</option>';
			$output .= '<option value="Normal" >Normal</option>';
			$output .= '<option value="Handicapped" selected >Handicapped</option>';
			$output .= '<option value="Others" >Others</option>';
			
			
		}
		else if ($n == 'Others')
		{
			$output = '<option value="0"> -- Please Select --</option>';
			$output .= '<option value="Normal" >Normal</option>';
			$output .= '<option value="Handicapped" >Handicapped</option>';
			$output .= '<option value="Others" selected >Others</option>';
			
			
		}
		else 
		{
			$output = '<option value="0" selected > -- Please Select --</option>';
			$output .= '<option value="Normal" >Normal</option>';
			$output .= '<option value="Handicapped" >Handicapped</option>';
			$output .= '<option value="Others" >Others</option>';
			
			
		}

	return $output;

}



//function show H status
function show_applicant_h_status($n)
{
		
		if ($n == 'Normal')
		{
			$output = 'Normal';
			
			
		}
		else if ($n == 'Handicapped')
		{
			$output = 'Handicapped';
			
			
		}
		else if ($n == 'Others')
		{
			$output = 'Others';
			
			
		}
		else 
		{
			$output = 'NIL';
			
			
		}

	return $output;

}
//show applicant h status

//function select disability
function select_applicant_disability($n)
{
		
		if ($n == 'Blind')
		{
			$output = '<option value="0"> -- Please Select --</option>';
			$output .= '<option value="Blind" selected> Blind</option>';
			$output .= '<option value="Deaf">  Deaf</option>';
			$output .= '<option value="Dumb">  Dumb</option>';
			$output .= '<option value="Handicapped">  Handicapped</option>';
			$output .= '<option value="None"> None</option>';
			$output .= '<option value="Others"> Others</option>';
			
		}
		else if ($n == 'Deaf' )
		{
		
			$output = '<option value="0"> -- Please Select --</option>';
			$output .= '<option value="Blind"> Blind</option>';
			$output .= '<option value="Deaf"  selected>  Deaf</option>';
			$output .= '<option value="Dumb">  Dumb</option>';
			$output .= '<option value="Handicapped">  Handicapped</option>';
			$output .= '<option value="None"> None</option>';
			$output .= '<option value="Others"> Others</option>';
			
		}
		else if ($n == 'Dumb' )
		{
		
			$output = '<option value="0"> -- Please Select --</option>';
			$output .= '<option value="Blind"> Blind</option>';
			$output .= '<option value="Deaf"  >  Deaf</option>';
			$output .= '<option value="Dumb" selected>  Dumb</option>';
			$output .= '<option value="Handicapped">  Handicapped</option>';
			$output .= '<option value="None"> None</option>';
			$output .= '<option value="Others"> Others</option>';
			
		}
		else if ($n == 'Handicapped' )
		{
		
			$output = '<option value="0"> -- Please Select --</option>';
			$output .= '<option value="Blind"> Blind</option>';
			$output .= '<option value="Deaf"  >  Deaf</option>';
			$output .= '<option value="Dumb" >  Dumb</option>';
			$output .= '<option value="Handicapped" selected>  Handicapped</option>';
			$output .= '<option value="None"> None</option>';
			$output .= '<option value="Others"> Others</option>';
			
		}
		else if ($n == 'None' )
		{
		
			$output = '<option value="0"> -- Please Select --</option>';
			$output .= '<option value="Blind"> Blind</option>';
			$output .= '<option value="Deaf"  >  Deaf</option>';
			$output .= '<option value="Dumb" >  Dumb</option>';
			$output .= '<option value="Handicapped">  Handicapped</option>';
			$output .= '<option value="None"  selected> None</option>';
			$output .= '<option value="Others"> Others</option>';
			
		}
		else if ($n == 'Others' )
		{
		
			$output = '<option value="0"> -- Please Select --</option>';
			$output .= '<option value="Blind"> Blind</option>';
			$output .= '<option value="Deaf"  >  Deaf</option>';
			$output .= '<option value="Dumb" >  Dumb</option>';
			$output .= '<option value="Handicapped">  Handicapped</option>';
			$output .= '<option value="None" > None</option>';
			$output .= '<option value="Others"  selected> Others</option>';
			
		}
		else
		{
			$output = '<option value="0"  selected> -- Please Select --</option>';
			$output .= '<option value="Blind"> Blind</option>';
			$output .= '<option value="Deaf"  >  Deaf</option>';
			$output .= '<option value="Dumb" >  Dumb</option>';
			$output .= '<option value="Handicapped">  Handicapped</option>';
			$output .= '<option value="None" > None</option>';
			$output .= '<option value="Others" > Others</option>';
		}

	return $output;

}


//function select bg
function select_applicant_bg($n)
{
		
		if ($n == 'AB')
		{
			$output = '<option value="0"> -- Please Select --</option>';
			$output .= '<option value="AB" selected> AB</option>';
			$output .= '<option value="O">  O </option>';
			$output .= '<option value="A+"> A+</option>';
			$output .= '<option value="B+"> B+</option>';
			
			
		}
		else if ($n == 'O' )
		{
		
			$output = '<option value="0"> -- Please Select --</option>';
			$output .= '<option value="AB" > AB</option>';
			$output .= '<option value="O" selected>  O </option>';
			$output .= '<option value="A+"> A+</option>';
			$output .= '<option value="B+"> B+</option>';
			
		}
		else if ($n == 'A+' )
		{
		
			$output = '<option value="0"> -- Please Select --</option>';
			$output .= '<option value="AB" > AB</option>';
			$output .= '<option value="O" >  O </option>';
			$output .= '<option value="A+" selected> A+</option>';
			$output .= '<option value="B+"> B+</option>';
			
		}
		else if ($n == 'B+' )
		{
		
			$output = '<option value="0"> -- Please Select --</option>';
			$output .= '<option value="AB" > AB</option>';
			$output .= '<option value="O" >  O </option>';
			$output .= '<option value="A+" > A+</option>';
			$output .= '<option value="B+" selected> B+</option>';
			
		}
		else
		{
			$output = '<option value="0"  selected> -- Please Select --</option>';
			$output .= '<option value="AB" > AB</option>';
			$output .= '<option value="O" >  O </option>';
			$output .= '<option value="A+" > A+</option>';
			$output .= '<option value="B+"> B+</option>';
		}

	return $output;

}
//end of blood group selection


//function select exam _type 
function select_applicant_exam_type($st)
{
		
		
		if ($st == 'GRADE II TEACHERS CERT.')
		{
			$output = '<option value="0" > -- Please Select --</option>';
			$output .= '<option  selected > GRADE II TEACHERS CERT.</option>';
			$output .= '<option > NABTEB</option>';
			$output .= '<option  >NECO</option>';
			$output .= '<option  >WAEC</option>';
		
			
		}
		else if ($st == 'NABTEB')
		{
			$output = '<option value="0" > -- Please Select --</option>';
			$output .= '<option > GRADE II TEACHERS CERT.</option>';
			$output .= '<option  selected  > NABTEB</option>';
			$output .= '<option  >NECO</option>';
			$output .= '<option  >WAEC</option>';
		
			
		}
		else if ($st == 'NECO')
		{
			$output = '<option value="0" > -- Please Select --</option>';
			$output .= '<option > GRADE II TEACHERS CERT.</option>';
			$output .= '<option > NABTEB</option>';
			$output .= '<option selected >NECO</option>';
			$output .= '<option  >WAEC</option>';
		
			
		}
		else if ($st == 'WAEC')
		{
			$output = '<option value="0" > -- Please Select --</option>';
			$output .= '<option > GRADE II TEACHERS CERT.</option>';
			$output .= '<option > NABTEB</option>';
			$output .= '<option>NECO</option>';
			$output .= '<option  selected>WAEC</option>';
		
			
		}
		else
		{
		
			$output = '<option value="0" selected > -- Please Select --</option>';
			$output .= '<option > GRADE II TEACHERS CERT.</option>';
			$output .= '<option > NABTEB</option>';
			$output .= '<option>NECO</option>';
			$output .= '<option  >WAEC</option>';
		
		}

	return $output;

}
//end of select exam type



//function select subjects
function select_applicant_subjects($c)
{
	$r = mysqli_query(dbc(),"SELECT id, title  FROM o_level_subjects  ORDER BY title ");
	if(mysqli_num_rows($r) > 0 )
	{
		while($row = mysql_fetch_array($r, MYSQLI_ASSOC))
		{
			if($c == $row['id'])
			{
				$output = "<option value=\"$row[id]\" selected>";
				$output .=  $row['title'];
				$output .="</option>";
				
			}
			else
			{
				$output = "<option value=\"$row[id]\" >";
				$output .= $row['title'];
				$output .="</option>";
				
			}
			 
			
			echo $output;
		}
	}
	else
	{
		
			$output = "<option>";
			$output .="Not added yet";
			$output .="</option>"; 
			
			echo $output;
	}
}
//end of select subjects


//function select exam month
function select_applicant_exam_month($hiq)
{
		
		if ($hiq == '1')
		{
			$output = 	'<option value="0"> -- Please Select-- </option>';
			$output .=  "<option value='1'  selected  >JUN/JUL</option>";
			$output .= '<option value="2"  >OCT/NOV</option>';
			$output .= '<option value="3"  >NOV/DEC</option>';
			$output .= '<option value="4"  >JUNE</option>';
			$output .= '<option value="5"  >JULY</option>';
			$output .= '<option value="6"  >OCTOBER</option>';
			$output .= '<option value="7"  >NOVEMBER</option>';
			$output .= '<option value="8"  >DECEMBER</option>';
		
			
		}
		else if ($hiq == '2')
		{
			$output = 	'<option value="0"> -- Please Select-- </option>';
			$output .=  "<option value='1' >JUN/JUL</option>";
			$output .= '<option value="2"  selected  >OCT/NOV</option>';
			$output .= '<option value="3"  >NOV/DEC</option>';
			$output .= '<option value="4"  >JUNE</option>';
			$output .= '<option value="5"  >JULY</option>';
			$output .= '<option value="6"  >OCTOBER</option>';
			$output .= '<option value="7"  >NOVEMBER</option>';
			$output .= '<option value="8"  >DECEMBER</option>';
			
		}
		else if ($hiq == '3')
		{
			$output = 	'<option value="0"> -- Please Select-- </option>';
			$output .=  "<option value='1' >JUN/JUL</option>";
			$output .= '<option value="2"  >OCT/NOV</option>';
			$output .= '<option value="3"  selected  >NOV/DEC</option>';
			$output .= '<option value="4"  >JUNE</option>';
			$output .= '<option value="5"  >JULY</option>';
			$output .= '<option value="6"  >OCTOBER</option>';
			$output .= '<option value="7"  >NOVEMBER</option>';
			$output .= '<option value="8"  >DECEMBER</option>';
			
		}
		else if ($hiq == '4')
		{
			$output = 	'<option value="0"> -- Please Select-- </option>';
			$output .=  "<option value='1' >JUN/JUL</option>";
			$output .= '<option value="2"  >OCT/NOV</option>';
			$output .= '<option value="3"  >NOV/DEC</option>';
			$output .= '<option value="4" selected >JUNE</option>';
			$output .= '<option value="5"  >JULY</option>';
			$output .= '<option value="6"  >OCTOBER</option>';
			$output .= '<option value="7"  >NOVEMBER</option>';
			$output .= '<option value="8"  >DECEMBER</option>';
			
		}
		else if ($hiq == '5')
		{
			$output = 	'<option value="0"> -- Please Select-- </option>';
			$output .=  "<option value='1' >JUN/JUL</option>";
			$output .= '<option value="2"  >OCT/NOV</option>';
			$output .= '<option value="3"  >NOV/DEC</option>';
			$output .= '<option value="4"  >JUNE</option>';
			$output .= '<option value="5" selected >JULY</option>';
			$output .= '<option value="6"  >OCTOBER</option>';
			$output .= '<option value="7"  >NOVEMBER</option>';
			$output .= '<option value="8"  >DECEMBER</option>';
			
		}
		else if ($hiq == '6')
		{
			$output = 	'<option value="0"> -- Please Select-- </option>';
			$output .=  "<option value='1' >JUN/JUL</option>";
			$output .= '<option value="2"  >OCT/NOV</option>';
			$output .= '<option value="3"  >NOV/DEC</option>';
			$output .= '<option value="4"  >JUNE</option>';
			$output .= '<option value="5"  >JULY</option>';
			$output .= '<option value="6" selected >OCTOBER</option>';
			$output .= '<option value="7"  >NOVEMBER</option>';
			$output .= '<option value="8"  >DECEMBER</option>';
			
		}
		else if ($hiq == '7')
		{
		    $output = 	'<option value="0"> -- Please Select-- </option>';
			$output .=  "<option value='1' >JUN/JUL</option>";
			$output .= '<option value="2"  >OCT/NOV</option>';
			$output .= '<option value="3"  >NOV/DEC</option>';
			$output .= '<option value="4"  >JUNE</option>';
			$output .= '<option value="5" >JULY</option>';
			$output .= '<option value="6"  >OCTOBER</option>';
			$output .= '<option value="7"  selected >NOVEMBER</option>';
			$output .= '<option value="8"  >DECEMBER</option>';
			
		}
		else if ($hiq == '8')
		{
			 $output = 	'<option value="0"> -- Please Select-- </option>';
			$output .=  "<option value='1' >JUN/JUL</option>";
			$output .= '<option value="2"  >OCT/NOV</option>';
			$output .= '<option value="3"  >NOV/DEC</option>';
			$output .= '<option value="4"  >JUNE</option>';
			$output .= '<option value="5" >JULY</option>';
			$output .= '<option value="6"  >OCTOBER</option>';
			$output .= '<option value="7" >NOVEMBER</option>';
			$output .= '<option value="8"  selected  >DECEMBER</option>';
			
		}
		else
		{
			$output = 	'<option value="0"  selected > -- Please Select-- </option>';
			$output .=  "<option value='1' >JUN/JUL</option>";
			$output .= '<option value="2"  >OCT/NOV</option>';
			$output .= '<option value="3"  >NOV/DEC</option>';
			$output .= '<option value="4"  >JUNE</option>';
			$output .= '<option value="5" >JULY</option>';
			$output .= '<option value="6"  >OCTOBER</option>';
			$output .= '<option value="7" >NOVEMBER</option>';
			$output .= '<option value="8"  >DECEMBER</option>';
		
			
		}
	return $output;

}
//end of select exam month



//function select highest qualification
function select_applicant_subject_grade($hiq)
{
		
		if ($hiq == '1')
		{
			$output = 	'<option value="0"> -- Please Select-- </option>';
			$output .=  "<option value='1'  selected  >A1</option>";
			$output .= '<option value="2"  >B2</option>';
			$output .= '<option value="3"  >B3</option>';
			$output .= '<option value="4"  >C4</option>';
			$output .= '<option value="5"  >C5</option>';
			$output .= '<option value="6"  >C6</option>';
			$output .= '<option value="7"  >D7</option>';
			$output .= '<option value="8"  >E8</option>';
			$output .= '<option value="9" >F9</option>';
			$output .= '<option value="10" >AR</option>';
	
			
			

		
			
		}
		else if ($hiq == '2')
		{
			$output = 	'<option value="0"> -- Please Select-- </option>';
			$output .=  "<option value='1' >A1</option>";
			$output .= '<option value="2"   selected  >B2</option>';
			$output .= '<option value="3"  >B3</option>';
			$output .= '<option value="4"  >C4</option>';
			$output .= '<option value="5"  >C5</option>';
			$output .= '<option value="6"  >C6</option>';
			$output .= '<option value="7"  >D7</option>';
			$output .= '<option value="8"  >E8</option>';
			$output .= '<option value="9"  >F9</option>';
			$output .= '<option value="10" >AR</option>';
			
		}
		else if ($hiq == '3')
		{
			$output = 	'<option value="0"> -- Please Select-- </option>';
			$output .=  "<option value='1' >A1</option>";
			$output .= '<option value="2"  >B2</option>';
			$output .= '<option value="3" selected >B3</option>';
			$output .= '<option value="4"  >C4</option>';
			$output .= '<option value="5"  >C5</option>';
			$output .= '<option value="6"  >C6</option>';
			$output .= '<option value="7"  >D7</option>';
			$output .= '<option value="8"  >E8</option>';
			$output .= '<option value="9"  >F9</option>';
			$output .= '<option value="10" >AR</option>';
			
		}
		else if ($hiq == '4')
		{
			$output = 	'<option value="0"> -- Please Select-- </option>';
			$output .=  "<option value='1' >A1</option>";
			$output .= '<option value="2"  >B2</option>';
			$output .= '<option value="3"  >B3</option>';
			$output .= '<option value="4" selected >C4</option>';
			$output .= '<option value="5"  >C5</option>';
			$output .= '<option value="6"  >C6</option>';
			$output .= '<option value="7"  >D7</option>';
			$output .= '<option value="8"  >E8</option>';
			$output .= '<option value="9"  >F9</option>';
			$output .= '<option value="10" >AR</option>';
			
		}
		else if ($hiq == '5')
		{
			$output = 	'<option value="0"> -- Please Select-- </option>';
			$output .=  "<option value='1'>A1</option>";
			$output .= '<option value="2" >B2</option>';
			$output .= '<option value="3" >B3</option>';
			$output .= '<option value="4" >C4</option>';
			$output .= '<option value="5"  selected >C5</option>';
			$output .= '<option value="6"  >C6</option>';
			$output .= '<option value="7"  >D7</option>';
			$output .= '<option value="8"  >E8</option>';
			$output .= '<option value="9"  >F9</option>';
			$output .= '<option value="10" >AR</option>';
			
		}
		else if ($hiq == '6')
		{
			$output = 	'<option value="0"> -- Please Select-- </option>';
			$output .=  "<option value='1'>A1</option>";
			$output .= '<option value="2" >B2</option>';
			$output .= '<option value="3" >B3</option>';
			$output .= '<option value="4" >C4</option>';
			$output .= '<option value="5" >C5</option>';
			$output .= '<option value="6" selected >C6</option>';
			$output .= '<option value="7"  >D7</option>';
			$output .= '<option value="8"  >E8</option>';
			$output .= '<option value="9"  >F9</option>';
			$output .= '<option value="10" >AR</option>';
			
		}
		else if ($hiq == '7')
		{
			$output = 	'<option value="0"> -- Please Select-- </option>';
			$output .=  "<option value='1'>A1</option>";
			$output .= '<option value="2" >B2</option>';
			$output .= '<option value="3" >B3</option>';
			$output .= '<option value="4" >C4</option>';
			$output .= '<option value="5" >C5</option>';
			$output .= '<option value="6" >C6</option>';
			$output .= '<option value="7"  selected  >D7</option>';
			$output .= '<option value="8"  >E8</option>';
			$output .= '<option value="9"  >F9</option>';
			$output .= '<option value="10" >AR</option>';
			
		}
		else if ($hiq == '8')
		{
			$output = 	'<option value="0"> -- Please Select-- </option>';
			$output .=  "<option value='1'>A1</option>";
			$output .= '<option value="2" >B2</option>';
			$output .= '<option value="3" >B3</option>';
			$output .= '<option value="4" >C4</option>';
			$output .= '<option value="5" >C5</option>';
			$output .= '<option value="6" >C6</option>';
			$output .= '<option value="7" >D7</option>';
			$output .= '<option value="8" selected  >E8</option>';
			$output .= '<option value="9"  >F9</option>';
			$output .= '<option value="10" >AR</option>';
			
		}
		else if ($hiq == '9')
		{
			$output = 	'<option value="0"> -- Please Select-- </option>';
			$output .=  "<option value='1'>A1</option>";
			$output .= '<option value="2" >B2</option>';
			$output .= '<option value="3" >B3</option>';
			$output .= '<option value="4" >C4</option>';
			$output .= '<option value="5" >C5</option>';
			$output .= '<option value="6" >C6</option>';
			$output .= '<option value="7" >D7</option>';
			$output .= '<option value="8" >E8</option>';
			$output .= '<option value="9"  selected  >F9</option>';
			$output .= '<option value="10" >AR</option>';
			
		}
		else if ($hiq == '10')
		{
			$output = 	'<option value="0"> -- Please Select-- </option>';
			$output .=  "<option value='1'>A1</option>";
			$output .= '<option value="2" >B2</option>';
			$output .= '<option value="3" >B3</option>';
			$output .= '<option value="4" >C4</option>';
			$output .= '<option value="5" >C5</option>';
			$output .= '<option value="6" >C6</option>';
			$output .= '<option value="7" >D7</option>';
			$output .= '<option value="8" >E8</option>';
			$output .= '<option value="9"  >F9</option>';
			$output .= '<option value="10"  selected >AR</option>';
			
		}
		else
		{
			$output = '<option value="0"  selected  > -- Please Select-- </option>';
			$output .=  "<option value='1'>A1</option>";
			$output .= '<option value="2" >B2</option>';
			$output .= '<option value="3" >B3</option>';
			$output .= '<option value="4" >C4</option>';
			$output .= '<option value="5" >C5</option>';
			$output .= '<option value="6" >C6</option>';
			$output .= '<option value="7" >D7</option>';
			$output .= '<option value="8" >E8</option>';
			$output .= '<option value="9" >F9</option>';
			$output .= '<option value="10" >AR</option>';
		
			
		}
	return $output;

}
//end of select highest


	
	
	
	//function that check and show is payment status is paid or not
	function payment_status($status)
	{
		$st = $status;
		
		if($st == 1)
		{
			return '<h4 class="label label-success">PAID</h4>';
		}
		else
		{
			return '<h4 class="label label-danger">UNPAID</h4>';
		}
	}

	
	
	




//function select country
function select_applicant_country($c)
{
	$r = mysqli_query(dbc(),"SELECT id, country_name  FROM countries  ORDER BY country_name ");
	if(mysqli_num_rows($r) > 0 )
	{
		while($row = mysql_fetch_array($r, MYSQLI_ASSOC))
		{
			if($c == $row['id'])
			{
				$output = "<option value=\"$row[id]\" selected>";
				$output .=  $row['country_name'];
				$output .="</option>";
				
			}
			else
			{
				$output = "<option value=\"$row[id]\" >";
				$output .= $row['country_name'];
				$output .="</option>";
				
			}
			 
			
			echo $output;
		}
	}
	else
	{
		
			$output = "<option>";
			$output .="Not added yet";
			$output .="</option>"; 
			
			echo $output;
	}
}
//end of select country_name




//function show country title
function show_applicant_country($c)
{
	$r = mysqli_query(dbc(),"SELECT  country_name  FROM countries WHERE id = '$c'");
	$row = mysqli_fetch_assoc($r);
		
    return $row['country_name'];
		
}
//end of show country_name






//function select state 
function select_applicant_state( $state)
{
	$r = mysqli_query(dbc(),"SELECT id, title  FROM state  ORDER BY title ");
	if(mysqli_num_rows($r) > 0 )
	{
		while($row = mysql_fetch_array($r, MYSQLI_ASSOC))
		{
			if($state == $row['id'])
			{
				$output = "<option value=\"$row[id]\" selected>";
				$output .=  $row['title'];
				$output .="</option>";
				
			}
			else
			{
				$output = "<option value=\"$row[id]\" >";
				$output .= $row['title'];
				$output .="</option>";
				
			}
			 
			
			echo $output;
		}
	}
	else
	{
		
			$output = "<option>";
			$output .="Not added yet";
			$output .="</option>"; 
			
			echo $output;
	}
}
//end of select state


//function show state
function show_applicant_state($c)
{
	$r = mysqli_query(dbc(),"SELECT  title  FROM state WHERE id = '$c'");
	$row = mysqli_fetch_assoc($r);
		
    return $row['title'];
		
}
//end of show state



function select_applicant_lga( $lga)
{
	$r = mysqli_query(dbc(),"SELECT id, title  FROM lga  ORDER BY title ");
	if(mysqli_num_rows($r) > 0 )
	{
		while($row = mysql_fetch_array($r, MYSQLI_ASSOC))
		{
			if($lga == $row['id'])
			{
				$output = "<option value=\"$row[id]\" selected>";
				$output .=  $row['title'];
				$output .="</option>";
				
			}
			else
			{
				$output = "<option value=\"$row[id]\" >";
				$output .= $row['title'];
				$output .="</option>";
				
			}
			 
			
			echo $output;
		}
	}
	else
	{
		
			$output = "<option>";
			$output .="Not added yet";
			$output .="</option>"; 
			
			echo $output;
	}
}
//end of select lga



//function show lga
function show_applicant_lga($c)
{
	$r = mysqli_query(dbc(),"SELECT  title  FROM lga WHERE id = '$c'");
	$row = mysqli_fetch_assoc($r);
		
    return $row['title'];
		
}
//end of show state





//select department
function select_applicant_department($department)
{
	$r = mysqli_query(dbc(),"SELECT id, title  FROM departments  ORDER BY title");
	if(mysqli_num_rows($r) > 0 )
	{
		while($row = mysql_fetch_array($r, MYSQLI_ASSOC))
		{
			if($department == $row['id'])
			{
				$output = "<option value=\"$row[id]\" selected>";
				$output .=  $row['title'];
				$output .="</option>";
				
			}
			else
			{
				$output = "<option value=\"$row[id]\" >";
				$output .= $row['title'];
				$output .="</option>";
				
			}
			 
			
			echo $output;
		}
	}
	else
	{
		
			$output = "<option>";
			$output .="Not added yet";
			$output .="</option>"; 
			
			echo $output;
	}
}
//end of select department




//select programme
function select_applicant_programme($p)
{
	$r = mysqli_query(dbc(),"SELECT id, title  FROM programmes  ORDER BY title");
	if(mysqli_num_rows($r) > 0 )
	{
		while($row = mysql_fetch_array($r, MYSQLI_ASSOC))
		{
			if($p == $row['id'])
			{
				$output = "<option value=\"$row[id]\" selected>";
				$output .=  $row['title'];
				$output .="</option>";
				
			}
			else
			{
				$output = "<option value=\"$row[id]\" >";
				$output .= $row['title'];
				$output .="</option>";
				
			}
			 
			
			echo $output;
		}
	}
	else
	{
		
			$output = "<option>";
			$output .="Not added yet";
			$output .="</option>"; 
			
			echo $output;
	}
}
//end of select programmes




//function calendar yer
function year($y)
{
	$y = $y;
	$years = range(1950, 2015);
	
	foreach ($years as $value) 
	{
		if($y == $value)
		{
	   		echo "<option value=\"$value\" selected>$value</option>\n";
		}
		else
		{
			echo "<option value=\"$value\">$value</option>\n";
		}
	}
	
	
}//end of year



//function calendar months
function month($m)
{
	$m = $m;
	$months = range(1, 12);
	
	foreach ($months as $value) 
	{
		if($m == $value)
		{
	   		echo "<option value=\"$value\" selected>$value</option>\n";
		}
		else
		{
			echo "<option value=\"$value\">$value</option>\n";
		}
	}
	
	
}




//function calendardays
function day($d)
{
	$d = $d;
	$days = range(1, 31);
	
	foreach ($days as $value) 
	{
		if($d == $value)
		{
	   		echo "<option value=\"$value\" selected>$value</option>\n";
		}
		else
		{
			echo "<option value=\"$value\">$value</option>\n";
		}
	}
	
	
}


//get programme name
function get_applicant_programme_title($id)
{
	$result = mysqli_query(dbc(),"SELECT title FROM programmes WHERE id = '$id'"); 
		$row = mysqli_fetch_assoc($result);
		$title = $row['title'];

	return $title;
}
//

//get department name
function get_applicant_department_title($id)
{
	$result = mysqli_query(dbc(),"SELECT title FROM departments WHERE id = '$id'"); 
	$row = mysqli_fetch_assoc($result);
	$title = $row['title'];

	return $title;
}




//get school name
function get_applicant_school_title($id)
{
	$result = mysqli_query(dbc(),"SELECT title FROM schools WHERE id = '$id'"); 
	$row = mysqli_fetch_assoc($result);
	$title = $row['title'];

	return $title;
}




//function that gets  department base on user id
function  get_applicant_department_id($user_id)
{	
	$result = mysqli_query(dbc(),"SELECT department_id FROM applicants_nce WHERE id = '$user_id'"); 
		$row = mysqli_fetch_assoc($result);
		$department_id = $row['department_id'];

	return $department_id;
	
}


//function that gets programme_id base on user id
function  get_applicant_programme_id($user_id)
{	
	$result = mysqli_query(dbc(),"SELECT programme_id FROM applicants_nce WHERE id = '$user_id'"); 
		$row = mysqli_fetch_assoc($result);
		$programme_id = $row['programme_id'];

	return $programme_id;
	
}


//function that gets  applicant admitted criteria base on user id
function  get_applicant_admitted_condition($user_id)
{	
	$result = mysqli_query(dbc(),"SELECT admission_criteria FROM applicants_nce WHERE id = '$user_id'"); 
		$row = mysqli_fetch_assoc($result);
		$v = $row['admission_criteria'];

	return $v;
	
}



//function that gets programme duration
function  get_programme_duration($id)
{	
	$result = mysqli_query(dbc(),"SELECT duration FROM programmes WHERE id = '$id'"); 
		$row = mysqli_fetch_assoc($result);
		$v = $row['duration'];

	return $v;
	
}



//function that gets programme max duration
function  get_max_programme_duration($id)
{	
	$result = mysqli_query(dbc(),"SELECT maximum_duration FROM programmes WHERE id = '$id'"); 
		$row = mysqli_fetch_assoc($result);
		$v = $row['maximum_duration'];

	return $v;
	
}

//function that gets department id by user id
function  get_dept_id($user_id)
{	
	$result = mysqli_query(dbc(),"SELECT department_id FROM applicants_nce WHERE id = '$user_id'"); 
		$row = mysqli_fetch_assoc($result);
		$course_id = $row['department_id'];

	return $course_id;
	
}

	
	

	
	
	
	//function to check if application or form sales is on // application is on 1
	function get_application_status()
	{
		$result = mysqli_query(dbc(),"SELECT * FROM control WHERE id = 1");
		$row = mysqli_fetch_assoc($result);
		$status = $row['status'];
		
		if($status == 1)
		{
			return true;
		}
		else
		{
			return false;
		}
		
		
	}
	





?>