<?php

//session_start();

require_once('configuration.php');


ob_start();

//function that clean all passed items from interface




//function get notifications error, info, info success

//instantiating Config Class
function dbc()
{
	$config = new Config();
	return $config->connect();
}
//cleaning user input and output
function clean_data($data) {
  $data = trim($data);
  $data = stripslashes($data);
  $data = strip_tags($data);
  $data = htmlspecialchars($data);
  return $data;
}

//sanitizing user input before inserting
function db_escape($dt){
	return  var_export( dbc()->real_escape_string($dt),True);

}





//function get user id brings user id
function get_user_id()
{
	//collect the id using cookie
	$user_id = $_COOKIE['list'];
	return $user_id;
}

//collect the user id from the fucntion



//function that filters the browser
function filter_browser($browser, $platform)
{

  $browser = $browser;
  $platform =$platform;


 //reject user if not firefox
  if($browser != 'Mozilla' )
  {
	  header('location:autorize_message/'); // show authorize message
  }

  if($platform != 'Windows!')
  {
	   header('location:autorize_message/'); // show authorize message

  }



} // end of browser / platform filter



//function that set asset action to switch it to last action
function set_asset($user_id , $act)
{
	$q = "SELECT * FROM assets WHERE user_id = '$user_id'";
	$r = mysqli_query(dbc(),$q);

	if(mysqli_num_rows($r)>0)
	{
		$query = "UPDATE assets SET action = '$act', date_added = NOW()";
		mysqli_query(dbc(),$query);
	}
	else
	{

		$query = "INSERT INTO assets (id, user_id, action, date_added)
				VALUES (NULL, '$user_id', '$act', NOW())";
		mysqli_query(dbc(),$query);
	}
}


//check if he has last action stored, get it
function get_asset_action($user_id)
{
	$q = "SELECT * FROM assets WHERE user_id = '$user_id'";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_array($r, MYSQLI_ASSOC);
	$at = $row['action'];



		return $at;



}





//function check if he jst assesed the site, if he did redirect the user base on timeout
function redirect_asset($user_id)
{


		 $at = get_asset_action($user_id); // get the last action and den delete

		 $query = "DELETE FROM assets  WHERE user_id = '$user_id'";
		 mysqli_query(dbc(),$query);


			if( $at != '') //if $at not empty then redirect
			{
				header("Location:gateway.php?act=$at");


			}



}


//function that return whether super administartor or not
function is_administrator($user_id)
{
	$q = "SELECT group_id FROM users WHERE user_id = '$user_id'";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_array($r, MYSQLI_ASSOC);
	 $group_id = $row['group_id'];

	if($group_id == 1 || $group_id == 2)
	{return true;}
	else
	{return false;}
}



//function that return whether super administartor or not
function is_admin($user_id)
{
	$q = "SELECT group_id FROM staff WHERE id = '$user_id'";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_array($r, MYSQLI_ASSOC);
   $group_id = $row['group_id'];

	if($group_id == 2)
	{return true;}
	else
	{return false;}
}







//get staff first name, last name
function get_staff_name($user_id)
{
	$query = "SELECT  first_name   AS name FROM staff WHERE id ='$user_id'";
	$result = mysqli_query(dbc(),$query);
	$row = mysqli_fetch_assoc($result);

	return $row['name'];

}


//get staff first name, last name
function get_staff_cno($user_id)
{
	$query = "SELECT  number FROM staff WHERE id ='$user_id'";
	$result = mysqli_query(dbc(),$query);
	$row = mysqli_fetch_assoc($result);

	return $row['number'];

}
//function get last login detail
function get_user_last_loggedout($user_id)
{
	$q = "SELECT DATE_FORMAT(last_logout, '%b %e, %Y  %l:%i:%p') as last_logout FROM staff WHERE id = '$user_id'";
	$r = mysqli_query(dbc(),$q);
	$row = mysqli_fetch_assoc($r);

	return $row['last_logout'];
}



//function dat get staffgroup by id type
function get_staff_groupid($user_id)
{
	$q = "SELECT group_id FROM staff WHERE id = '$user_id' ";
	$r = mysqli_query(dbc(),$q);
	$row = mysqli_fetch_assoc($r);

	return $row['group_id'];


}


//function dat get staff group by title type
function get_staff_group_title($user_id)
{
	$q = "SELECT s.group_id, sg.id sg_id, sg.title as group_title FROM staff s, staff_groups sg
		  WHERE s.group_id = sg.id AND s.id = '$user_id' ";
	$r = mysqli_query(dbc(),$q);
	$row = mysqli_fetch_assoc($r);

	return $row['group_title'];


}


//function dat get staff group menu privileges based on logged in user
function get_user_group_header_menu_privileges($user_id)
{
	$q = "SELECT s.group_id, sg.id as sg_id, sg.header_menu FROM staff s, staff_groups sg
		  WHERE s.group_id = sg.id AND s.id = '$user_id' ";
	$r = mysqli_query(dbc(),$q);
	$row = mysqli_fetch_assoc($r);

	return $row['header_menu'];


}



//function dat get usergroup menu privileges based on logged in user
function get_user_group_toolbar_menu_privileges($user_id)
{
	$q = "SELECT u.group_id, ug.user_group_id, ug.toolbar_menu FROM users u, user_groups ug
		  WHERE u.group_id = ug.user_group_id AND u.user_id = '$user_id' ";
	$r = mysqli_query(dbc(),$q);
	$row = mysqli_fetch_assoc($r);

	return $row['toolbar_menu'];


}




//function dat get usergroup home menu privileges based on logged in user
function get_user_group_home_menu_privileges($user_id)
{
	$q = "SELECT u.group_id, ug.user_group_id, ug.home_menu FROM users u, user_groups ug
		  WHERE u.group_id = ug.user_group_id AND u.user_id = '$user_id' ";
	$r = mysqli_query(dbc(),$q);
	$row = mysqli_fetch_assoc($r);

	return $row['home_menu'];


}




//function dat get staff group home menu privileges based on logged in user
function get_staff_group_landing_menu_privileges($user_id)
{
	$q = "SELECT s.group_id, sg.id as sg_id, sg.landing_menu FROM staff s, staff_groups sg
		  WHERE s.group_id = sg.id AND s.id = '$user_id' ";
	$r = mysqli_query(dbc(),$q);
	$row = mysqli_fetch_assoc($r);

	return $row['landing_menu'];


}



//function get user ip
function get_user_ip($user_id)
{
	$q = "SELECT last_login_ip FROM staff WHERE id = '$user_id' ";
	$r = mysqli_query(dbc(),$q);
	$row = mysqli_fetch_assoc($r);

	return $row['last_login_ip'];


}

//function dat get staff security id  by id
function get_security_id($user_id)
{
	$q = "SELECT security_id FROM staff WHERE id = '$user_id' ";
	$r = mysqli_query(dbc(),$q);
	$row = mysqli_fetch_assoc($r);

	return $row['security_id'];


}


//function dat get control value
function get_control_status($control_value)
{
	$q = "SELECT active FROM controls WHERE id = 5";
	$r = mysqli_query(dbc(),$q);
	$row = mysqli_fetch_assoc($r);

	return $row['active'];


}
//end of control value



//get department for staff
function get_user_department($user_id)
{
	$query = "SELECT  department_id   FROM staff WHERE id ='$user_id'";
	$result = mysqli_query(dbc(),$query);
	$row = mysqli_fetch_assoc($result);

	$v =  $row['department_id'];

	return $v;

}

//get department for staff using school id supplied
function get_department_using_school_id($id)
{
	$query = "SELECT  id   FROM departments WHERE school_id ='$id'";
	$result = mysqli_query(dbc(),$query);
	$row = mysqli_fetch_assoc($result);

	$v =  $row['id'];

	return $v;

}


//get department for staff using programme id supplied
function get_department_using_programme_id($id)
{
	$query = "SELECT  department_id   FROM programmes WHERE id ='$id'";
	$result = mysqli_query(dbc(),$query);
	$row = mysqli_fetch_assoc($result);

	$v =  $row['department_id'];

	return $v;

}


//get department comb using programme id
function get_department_comb_using_programme_id($id)
{
	$query = "SELECT  department_comb   FROM programmes WHERE id ='$id'";
	$result = mysqli_query(dbc(),$query);
	$row = mysqli_fetch_assoc($result);

	$v =  $row['department_comb'];

	return $v;

}

//function that generates security code
function generate_security_code()
{
	$result = mysqli_query(dbc(),"SELECT * FROM generate_code");
	while($row = mysqli_fetch_array($result))
	{
		$g_code = $row['code'];
	}

	//add 1 to $g_code and tek to d db
	$g_coded = $g_code + 1;

	mysqli_query(dbc(),"UPDATE generate_code  SET code = '$g_coded'");

	$add_zeros = '0'.$g_coded;
	$security_id = date("Y-m-d-$add_zeros").'-COE';

	return $security_id;
}



//function audit trail and tracks what user does on the system
function set_user_log($user, $action)
{
	$query = "INSERT INTO staff_log(log_id, staff_id, log_action, log_date)
				VALUES (NULL, '$user', '$action', NOW())";
	mysqli_query(dbc(),$query);

}



//function view staff log
function view_staff_log()
{

	//query the database
	$query = "SELECT s.id as sid, s.security_id, CONCAT_WS(' ', s.first_name, s.other_names) as name, sl.log_id, sl.staff_id, sl.log_action,
			 DATE_FORMAT(sl.log_date, '%b %e, %Y  %l:%i:%p')as log_date

			 FROM staff s, staff_log sl

			 WHERE s.id = sl.staff_id


			 ORDER BY log_date";
   $result = mysqli_query(dbc(),$query);










	if(mysqli_num_rows($result) > 0)
	{//show table


		$output =
		'<table id="example" class="user display table-bordered table-hover table-striped" cellspacing="0" width="100%" style="font-size:12px;">
		  <thead>

					  <th>Name</th>
					  <th>Security ID</th>
					  <th>Action</th>
					  <th>Date</th>



		  </thead>

		  <tfoot>

					  <th>Name</th>
					  <th>Security ID</th>
					  <th>Action</th>
					  <th>Date</th>



		  </tfoot>

		  <tbody>';


		while($row = mysqli_fetch_array($result, MYSQLI_ASSOC))
		{
			$output .= "<tr>";
			$output .= "<td>".$row['name']."</td>"; //group belong to admin or user
			$output .= "<td>".$row['security_id']."</td>";
			$output .= "<td>".$row['log_action']."</td>";
			$output .= "<td>".$row['log_date']."</td>";
			$output .= "</tr>";

		}
	}
	else
	{//show the msg

		  $output =
				 '<div class="alert alert-danger alert-dismissable">
				  <button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
				  <img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				 </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;






}//end of view user log






/* documentation for header menu **
** 0 - default that gives access to profile, track log, php version
** 1 - gives access to user manager, role, user group
** 2 - gives access to news manger, events
** 3 - gives access to picture manager, video or any content manager
** 4 - gives access to state manager, lga
** 5 - gives access to departments and schools
** 6 - givess access to reports
*/





//function that gets header menu privileges
function header_menu($privileges)
{
	$list .= '<li class="dropdown"><a class="dropdown-toggle" data-toggle="dropdown" href="#"><img src="images/admin_small.png" />Extras<b class="caret"></b></a>
						<ul class="dropdown-menu">
							<li><a href="landing.php?act=landing"><img src="images/admin_small.png" />Home</a></li>

							<!-- <li><a href="gateway.php?act=view_profile"><img src="images/profile_small.png" />My Profile</a></li> -->
							<!-- <li><a href="gateway.php?act=#"><img src="images/mass_messaging_small.png" />Message</a></li> -->
						</ul>
					</li>';

	if(is_admin(get_user_id())) //check if super admin
	{

	$privilege[1] = '<li class="dropdown"><a class="dropdown-toggle" data-toggle="dropdown" href="#"><img src="images/users_icon.png" /> Staff <b class="caret"></b></a>
						<ul class="dropdown-menu">
							<li><a href="gateway.php?act=view_staffs"><img src="images/user_manager_small.png">Staff Manager</a></li>
							<!-- <li><a href="gateway.php?act=view_roles"><img src="images/user_roles_small.png">Roles</a></li>
							<li><a href="gateway.php?act=view_user_groups"><img src="images/user_access_level_small.png">Access Level(User Groups)</a></li -->
						 </ul>
					</li>';
	}//if super admin


	$privilege[2] = '<li class="dropdown"><a class="dropdown-toggle" data-toggle="dropdown" href="#"><img src="images/news_events_small.png"> CV<b class="caret"></b></a>
						<ul class="dropdown-menu">
							<li><a href="#"><img src="images/news_small.png">CV Manager</a></li>

						</ul>
					</li>';

	$privilege[3] = '<li class="dropdown"><a class="dropdown-toggle" data-toggle="dropdown" href="#"><img src="images/courses-small.png">
						Course<b class="caret"></b></a>
						<ul class="dropdown-menu">

							<li><a href="gateway.php?act=view_departments_list"><img src="images/courses-small.png"> &nbsp;Assessments</a></li>

							<li><a href="#"><img src="images/students-support-small.png">&nbsp;Students Support</a></li>

						</ul>
					</li>';




	/*$privilege[4] = '<li class="dropdown"><a class="dropdown-toggle" data-toggle="dropdown" href="#"><img src="images/report-1.png">&nbsp;Reports<b class="caret"></b></a>
						<ul class="dropdown-menu">
							<li><a href="gateway.php?act=view_reports"><img src="images/report-small.png">  Report Manager</a></li>
						</ul>
					</li>';*/


	//explode the privileges
	$allowed_privileges = explode(',',$privileges);

	for($i=0; $i<sizeof($allowed_privileges)-1; $i++)
	{
		$list .= $privilege[$allowed_privileges[$i]];

	}

	$list .= "";

	//return $privileged_list;
	return $list;


}

//end of function header_menu


//function that displays landing menu goes here
function landing_menu($privileges)
{
	//check if admin and echo this
	if(is_admin(get_user_id()))
	{
	$list .= '<div class="well btn-default col-lg-2 text-center"><a  href="gateway.php?act=view_staffs"><img src="images/profile.png" data-toggle="tooltip" title="My Profile" />
	<h6>Staff Manager</h6></a></div>';

	}

	// $privilege[1] = '<div class="well btn-default col-lg-2 text-center"><a  href="#"><img src="images/courses.png" data-toggle="tooltip" title="Course Manager" />
			//		<h6>Course Manager</h6></a></div>';

	$privilege[1] = '';

    $privilege[2] = '<div class="well btn-default col-lg-2 text-center"><a  href="gateway.php?act=view_schools_list"><img src="images/list_todo.png" data-toggle="tooltip" title="Result Management" />
					<h6>Result Management System</h6></a></div>';


					// &nbsp&nbsp <div class="btn-group">
				 // <button type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown"><i class="glyphicon glyphicon-search"></i>
					//  View <span class="caret"></span>
				 // </button>


    if(is_admin(get_user_id()))
	{

	$privilege[3] = '<div class="well btn-default col-lg-2 text-center"><a  href="#"><img src="images/report.png"
					data-toggle="tooltip" title="View Reports" />	</a>

							<h6 class="dropdown-toggle" data-toggle="dropdown">Reports  <span class="caret"></span></h6>
							<ul class="dropdown-menu">
 							 <li><a target="_blank" href="gateway.php?act=view_top_level_summary&ses='. $session.'&sem=1&sid='.$sid.'&pid='.$pid.'&level=III" > Top List Summary </a></li>
							 <li class="divider"></li>
 								<li><a target="_blank" href="gateway.php?act=view_schools_list_cummulative_summary&ses='. $session.'&sem=1&sid='.$sid.'&pid='.$pid.'&level=III" > Cummulative / Graduation List Summary </a></li>
								<li class="divider"></li>

 						 </ul>







					 </div>



					</div>';
					
					
	}

	if(is_admin(get_user_id()))
	{
		$privilege[4] = '<div class="well btn-default col-lg-2 text-center"><a  href="gateway.php?act=view_schools_list_cr"><img src="images/compute_result.png" data-toggle="tooltip" title="Compute Results / Print outs" />
					<h6>Compute Results / Print Outs</h6></a>
					</div>';

	}

		// $privilege[4] = '<div class="well btn-default col-lg-2 text-center"><a  href="#"><img src="images/hostel.png" data-toggle="tooltip" title="Hostel Admin" />
		// <h6>Hostel Admin</h6></a>
		// </div>';

	// $privilege[6] = '<div class="well btn-default col-lg-2 text-center"><a  href="gateway.php?act=view_system_info"><img src="images/dashboard.png" data-toggle="tooltip" title="Dashboard" />
	// 				<h6>Dashboard</h6></a>
	// 				</div>';


	/*$privilege[7] = '<div class="well btn-default col-lg-2 text-center"><a  href="gateway.php?act=view_system_info"><img src="images/paperless.png" data-toggle="tooltip" title="eOFFICE" />
					<h6>eOFFICE</h6></a>
					</div>';*/

	$privilege[5] = '<div class="well btn-default col-lg-2 text-center"><a  href="#"><img src="images/how_to_use.png" data-toggle="tooltip"
					title="Help Me" /><h6>How to use?</h6></a></div>';

					//gateway.php?act=view_how_to_use

	// $privilege[9] = '<div class="well btn-default col-lg-2 text-center"><a  href="gateway.php?act=view_how_to_use"><img src="images/support.png" data-toggle="tooltip"
	// 				title="Help Me" /><h6>Support</h6></a></div>';





	//explode the privileges
	$allowed_privileges = explode(',',$privileges);

	for($i=0; $i<sizeof($allowed_privileges)-1; $i++)
	{
		$list .= $privilege[$allowed_privileges[$i]];

	}

	$list .= "";

	//return $privileged_list;
	return $list;


}
//end of function landing menu

//function that shows the courses lecturers take
function course_menu($user_id, $semester)
{
	//here user id is for


	//query the database
	$q = "SELECT s.id as st_id, CONCAT_WS(' ', s.first_name, s.other_names) as name,
		  DATE_FORMAT(s.date_added, '%b %e, %Y  %l:%i:%p') as date_added,

		 c.id as c_id, c.title, c.code, c.semester,

		 sc.id, sc.staff_id, sc.course_id



		 FROM staff s, courses c, staff_courses sc
		 WHERE s.id = sc.staff_id

		 AND sc.course_id = c.id
		 AND c.semester = '$semester'
		 AND sc.staff_id = '$user_id'
		 AND (sc.status = 0 OR sc.status = 1)



		 ORDER BY c.semester, c.title";
	$r = mysqli_query(dbc(),$q);



	//in the table below result_table stands for resullt fetch throug seraching table(ajax)
	$output = '';

	if(mysqli_num_rows($r) > 0)
	{//show table




		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{


			$output .= '<a class="btn btn-success" href="#" style="margin:5px;">'.$row['title'].' ('.$row['code'].') - '.'<span class="badge">'.get_total_students_per_course($row['c_id'], $current_session = '1').'</span>'.'</a>';



		}
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}




	return $output;




}//end of course menu

//function that get total number of students thatregistered for particular course
function get_total_students_per_course($programme_id, $course_id,$current_session)
{
	$q = "SELECT COUNT(DISTINCT(student_id))
		 FROM students_courses_nce
		 WHERE course_id = '$course_id'
		 AND session_id  = '$current_session'
		 AND programme_id = '$programme_id'";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_array($r, MYSQLI_NUM);

	return number_format($row[0]);
}


//function that get total number of students thatregistered for particular course for prence
//function that get total number of students thatregistered for particular course
function get_total_students_per_course_prence($programme_id, $course_id,$current_session)
{
	$q = "SELECT COUNT(DISTINCT(student_id))
		 FROM students_courses_prence
		 WHERE course_id = '$course_id'
		 AND session_id  = '$current_session'
		 AND programme_id = '$programme_id'";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_array($r, MYSQLI_NUM);

	return number_format($row[0]);
}


//function that get total number of students thatregistered for particular course for summer
function get_total_students_per_course_summer($programme_id, $course_id,$current_session)
{
	$q = "SELECT COUNT(DISTINCT(student_id))
		 FROM summer_students_courses_nce
		 WHERE course_id = '$course_id'
		 AND session_id  = '$current_session'
		 AND programme_id = '$programme_id'";
	$r = mysqli_query(dbc(),$q);

	$row = @mysqli_fetch_array($r, MYSQLI_NUM);

	return number_format($row[0]);
}//for summer



//get courses registered  by  students in comma separated values for summer
function get_student_registered_courses_summer($user_id, $level, $session, $semester)
{


		  	  $q ="SELECT  GROUP_CONCAT(c.`code` SEPARATOR ', ')  AS comma_separated_courses

    			   FROM `summer_students_courses_nce` sr, courses c

                   WHERE sr.course_id = c.id AND  sr.student_id = $user_id AND

    sr.`session_id` = $session  ORDER BY sr.id ASC"; //AND sr.`semester` = $semester  AND sr.`level` = $level GROUP_CONCAT(c.`code` ORDER BY code SEPARATOR ', ')
		// ORDER BY code


	$r = mysqli_query(dbc(),$q);


	$output = '';

	if(mysqli_num_rows($r) > 0 )
	{
		$row = mysqli_fetch_array($r, MYSQLI_ASSOC);

		$output = $row['comma_separated_courses'];

	}//end of if there is value
	else
	{
		$output = '0';
	}


	return $output;


}//end of function that get OC for particular students for summer


//get courses registered  by  students in comma separated values for summer
function get_student_cascore_courses_summer($user_id, $level, $session, $semester)
{


		$q ="SELECT  GROUP_CONCAT(FORMAT(sr.`ca_score`,0) SEPARATOR ', ')  AS comma_separated_scores

    FROM `summer_students_courses_nce` sr, courses c

  	WHERE sr.course_id = c.id AND  sr.student_id = $user_id AND

    sr.`session_id` = $session  ORDER BY sr.id ASC"; //AND sr.`semester` = $semester  AND sr.`level` = $level


	$r = mysqli_query(dbc(),$q);


	$output = '';

	if(mysqli_num_rows($r) > 0 )
	{
		$row = mysqli_fetch_array($r, MYSQLI_ASSOC);

		$output = $row['comma_separated_scores'];

	}//end of if there is value
	else
	{
		$output = '0';
	}


	return $output;


}//end of function that get OC for particular students for summer ca score


//get courses registered  by  students in comma separated values for  exam summer
function get_student_examscore_courses_summer($user_id, $level, $session, $semester)
{


		  	  $q ="SELECT  GROUP_CONCAT(FORMAT(sr.`exam_score`,0) SEPARATOR ', ')  AS comma_separated_scores

    			   FROM `summer_students_courses_nce` sr, courses c

                   WHERE sr.course_id = c.id AND  sr.student_id = $user_id AND

    sr.`session_id` = $session  ORDER BY sr.id ASC"; //AND sr.`semester` = $semester  AND sr.`level` = $level


	$r = mysqli_query(dbc(),$q);


	$output = '';

	if(mysqli_num_rows($r) > 0 )
	{
		$row = mysqli_fetch_array($r, MYSQLI_ASSOC);

		$output = $row['comma_separated_scores'];

	}//end of if there is value
	else
	{
		$output = '0';
	}


	return $output;


}//end of function that get OC for particular students for summer exam score



//function home menu goes here

/* home menu documentation
** 0 is for checking ur profile
** 1 is for add news
** 2 is is user manager
** 3 is for adding event
** 4 is checking system information
** 5 -  global settings like checking the configuration
** 6 -  adding video to youtube and
**/

function home_menu($privileges)
{
	$list .= '<span class="home_menu_icons"><a  href="gateway.php?act=view_profile&u='.get_user_id().'"><img src="images/profile.png" data-toggle="tooltip" title="View Profile" />
	&nbsp;&nbsp;Profile</a></span>';

	$privilege[1] = '<span class="home_menu_icons"><a href="gateway.php?act=add_news"><img src="images/add_news.png" data-toggle="tooltip" title="Add News" />
	Add News	</a>

			  </span>';

	$privilege[2] = '<span class="home_menu_icons"><a  href="gateway.php?act=view_users"><img src="images/user_manager.png" data-toggle="tooltip" title="User Manager" />
					User Manager</a></span>';




	$privilege[3] = '<span class="home_menu_icons"><a  href="gateway.php?act=add_events"><img src="images/add_events.png"
					data-toggle="tooltip" title="Add Events" />Add Events</a></span>';


	$privilege[4] = '<span class="home_menu_icons"><a  href="gateway.php?act=view_system_info"><img src="images/system_info.png" data-toggle="tooltip" title="System Infor" />
					System Info</a>
					</span>';

	$privilege[5] = '<span class="home_menu_icons"><a  href="gateway.php?act=view_global_settings"><img src="images/global_settings.png" data-toggle="tooltip"
					title="Global Setting" />Global Settings</a></span>';


	$privilege[6] = '<span class="home_menu_icons"><a  href="gateway.php?act=add_pictures"><img src="images/gallery.png" data-toggle="tooltip"
					title="Add Picture / Video Details" />Add Pics / Video</a></span>';





	//explode the privileges
	$allowed_privileges = explode(',',$privileges);

	for($i=0; $i<sizeof($allowed_privileges)-1; $i++)
	{
		$list .= $privilege[$allowed_privileges[$i]];

	}

	$list .= "";

	//return $privileged_list;
	return $list;


}
//end of function home menu


//function activity trail
function activity_menu()
{


}


//function tab menu
function tab_menu()
{

}



//function that checks if user status is blocked or unblocked 0- blocked 1 means unblocked
//by passing the blocked status

function user_status_img($status)
{
	$st = $status;

	if($st == 1)
	{
		return '<img src="images/active.png" data-toggle="tooltip" title="Active"/>';
	}
	else
	{
		return '<img src="images/blocked.png" data-toggle="tooltip" title="Blocked" />';
	}
}


//function that shows users publish status image
function users_publish_status_image($status)
{

	$st = $status;

	if($st == 0)
	{
		$output =  '<input type="submit" name="act" class="publish-icon-small" value="unpublish_users" id="publish_u"
				data-toggle="tooltip" data-placement="right" title="Published: Click to unpublish item">';
	}
	else
	{
		$output =  '<input type="submit" name="act" class="unpublish-icon-small" value="publish_users" id="unpublish_u"
					data-toggle="tooltip" data-placement="right" title="Unpublished: Click to publish item">';
	}

	return $output;


}//end of function dat shows publish users image




//function view users
//function that get users informatn
function view_users()
{

	$user_id = get_user_id();

	//query the database
	$q = "SELECT u.user_id, u.group_id, CONCAT_WS(' ', u.first_name, u.other_names) as name, u.phone_number,u.username,
		  DATE_FORMAT(u.date_added, '%b %e, %Y  %l:%i:%p') as date_added,  u.online_status, u.user_status, u.email, u.status,
		  u.last_login, u.last_login_ip,
		  DATE_FORMAT(u.last_logout, '%b %e, %Y  %l:%i:%p') as last_logout,

		 ug.user_group_id, ug.title as group_title


		 FROM users u, user_groups ug
		 WHERE u.group_id = ug.user_group_id

		 AND u.user_id != '$user_id'
		 AND (u.status = 0 OR u.status = 1)



		 ORDER BY date_added DESC";
	$r = mysqli_query(dbc(),$q);



	//in the table below result_table stands for resullt fetch throug seraching table(ajax)


	if(mysqli_num_rows($r) > 0)
	{//show table

	$output ='<table id="example" class="user display table-bordered table-hover table-striped responsive" width="100%"  cellspacing="0" style="font-size:12px;">
				<thead>




						<th  > <input type="checkbox" id="selecctall"  value="" data-toggle="tooltip" title="Check All"></th>


						<th>Name</th>
						<th> Status </th>
						<th>Username</th>
						<th>Active</th>
						<th>User group</th>
						<th>Email</th>
						<th>Last Login Ip</th>
						<th>Last Visit Date</th>
						<th>Registration Date</th>

				</thead>



				<tfoot>
				   		<th > </th>
			  			<th>Name</th>
						<th> Status </th>
						<th>Username</th>
						<th>Active</th>
						<th>User group</th>
						<th>Email</th>
						<th>Last Login Ip</th>
						<th>Last Visit Date</th>
						<th>Registration Date</th>
				</tfoot>

				<tbody>';



		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			$output .= "<tr>";
			$output .="<td>&nbsp;&nbsp;&nbsp;<input type='checkbox' value='".$row['user_id']."' name='user[]' id='user' class='checkbox1'/></td>" ;
			$output .= "<td> <a href=''>".$row['name']."</a></td>"; //nam eof the user
			$output .= "<td>".users_publish_status_image($row['status'])."</td>";
			$output .= "<td>".$row['username']."</td>";
			$output .= "<td>". user_status_img($row['user_status'])."</td>";
			$output .= "<td>".$row['group_title']."</td>";
			$output .= "<td>".$row['email']."</td>";
			$output .= "<td>".$row['last_login_ip']."</td>";
			$output .= "<td>".$row['last_logout']."</td>";
			$output .= "<td>".$row['date_added']."</td>";
			$output .= "</tr>";



		}
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;




}//end of view users




//function that get trashed  users informatn
function view_trashed_users()
{

	//query the database
	$q = "SELECT u.user_id, u.group_id, CONCAT_WS(' ', u.first_name, u.other_names) as name, u.phone_number,u.username,
		  DATE_FORMAT(u.date_added, '%b %e, %Y  %l:%i:%p') as date_added,  DATE_FORMAT(u.date_modified, '%b %e, %Y  %l:%i:%p') as date_modified,  u.online_status, u.user_status, u.email,
		  u.last_login, u.last_login_ip,
		  DATE_FORMAT(u.date_trashed, '%b %e, %Y  %l:%i:%p') as date_trashed,

		 ug.user_group_id, ug.title as group_title


		 FROM users u, user_groups ug
		 WHERE u.group_id = ug.user_group_id

		 AND u.user_id != '$user_id'
		 AND u.status = 2

		 ORDER BY date_added DESC";
	$r = mysqli_query(dbc(),$q);






	if(mysqli_num_rows($r) > 0)
	{//show table

	$output ='<table id="example" class="user display table-bordered table-hover table-striped responsive" width="100%"  cellspacing="0" style="font-size:12px;">
				<thead>




						<th  > <input type="checkbox" id="selecctall"  value=""></th>


						<th>Name</th>
						<th>Username</th>
						<th>User group</th>
						<th>Email</th>
						<th>Registration Date</th>
						<th> Last Modified</th>
						<th>Deleted </th>
						<th>

				</thead>



				<tfoot>
				   		<th > </th>
			  			<th>Name</th>
						<th>Username</th>
						<th>User group</th>
						<th>Email</th>
						<th>Registration Date</th>
						<th> Last Modified</th>
						<th>Deleted </th>
						<th></th>
				</tfoot>

				<tbody>';



		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			$output .= "<tr>";
			$output .="<td>&nbsp;&nbsp;&nbsp;<input type='checkbox' value='".$row['user_id']."' name='user[]' id='user' class='checkbox1'/></td>" ;
			$output .= "<td> <a href=''>".$row['name']."</a></td>"; //nam eof the user
			$output .= "<td>".$row['username']."</td>";
			$output .= "<td>".$row['group_title']."</td>";
			$output .= "<td>".$row['email']."</td>";
			$output .= "<td>".$row['date_added']."</td>";
			$output .= "<td>".$row['date_modified']."</td>";
			$output .= "<td>".$row['date_trashed']."</td>";
			$output .= '<td><a class="btn btn-success btn-sm pull-right restore" id="'.$row['user_id'].'" > Restore</a>
						 <span id="loading"></span></td>';
			$output .= "</tr>";



		}
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}

	$output .=
	'</tbody>
    </table>';


	return $output;




}//end of view users


////fucntion that returns searched users
//function view_search_users($search_item)
//{
//	//get user
//	$user_id = get_user_id();
//
//
//
//	//collect the page number, sorting details and dis[lay per page
//	//no of display per page
//	$display_per_page = 10;
//
//
//	//collect the page variable from url
//	 //determin how many pages there are
//	if (isset($_GET['page']) && is_numeric($_GET['page']))
//	{//already determinwd
//		$pages = $_GET['page'];
//
//	}
//	else
//	{//needs to be determine
//
//
//		//get total projects base user role, mda
//		$q = "SELECT COUNT(user_id)
//
//			  FROM  users
//			  WHERE user_id != '$user_id'";
//		$r = @mysqli_query(dbc(),$q);
//
//		$row = @mysqli_fetch_array($r, MYSQLI_NUM);
//		//records holds the result of the sql
//		$records = $row[0];
//
//
//
//		///calculate the no of pages
//		if($records > $pages)
//		{
//			$pages = ceil($records/$display_per_page);
//		}
//		else
//		{
//			$pages = 1;
//		}
//
//
//
//
//	}//end of pages if
//
//
//
//
//
//	//get the start of the query
//	//determin in the db where to start reurning result
//	if(isset($_GET['start']) && is_numeric($_GET['start']))
//	{
//		$start = $_GET['start'];
//	}
//	else
//	{
//		$start = 0;
//	}
//
//
//	//determine the sorting
//	$sort = (isset($_GET['sort'])?$_GET['sort']: 'date_added DESC');
//
//	//swith the order
//	switch($sort)
//	{
//		case 'name':
//		$order_by = 'name ASC';
//
//		break;
//
//		case 'role_title':
//		$order_by = 'role_title ASC';
//
//		break;
//
//		case 'user_status':
//		$order_by = 'user_status ASC';
//
//		break;
//
//
//		case 'group_title':
//		$order_by = 'group_title ASC';
//
//		break;
//
//
//		case 'email':
//		$order_by = 'email ASC';
//
//		break;
//
//		case 'last_logout':
//		$order_by = 'last_logout ASC';
//
//		break;
//
//
//		case 'date_added':
//		$order_by = 'date_added ASC';
//
//		break;
//
//
//		default:
//		$order_by = 'date_added DESC';
//
//		break;
//
//
//	}
//
//
//	//in the table below result_table stands for resullt fetch throug seraching table(ajax)
//
//	echo
//	'<table id="background-image" class="user tablesorter table-responsive" cellspacing="0">
//	  <thead>
//			 <th class="header" > <input type="checkbox" id="selecctall"  value=""> &nbsp;Check All</th>
//				  <th class="header" ><a href="gateway.php?act=view_users&sort=name">Name</a></th>
//				  <th class="header" ><a href="gateway.php?act=view_users&sort=role_title">Role</a></th>
//				  <th class="header" ><a href="gateway.php?act=view_users&sort=user_status">Status</a></th>
//				  <th class="header" ><a href="gateway.php?act=view_users&sort=group_title">User group</a></th>
//				  <th class="header" ><a href="gateway.php?act=view_users&sort=email">Email</a></th>
//				  <th class="header" ><a href="gateway.php?act=view_users&sort=security_id">Security ID</a></th>
//				  <th class="header" ><a href="gateway.php?act=view_users&sort=last_logout">Last Visit Date</a></th>
//				  <th class="header" ><a href="gateway.php?act=view_users&sort=date_added">Registration Date</a></th>
//
//	  </thead>
//
//	  <tbody>';
//
//
//
//
//
//
//	//query the database
//	$q = "SELECT u.user_id, u.group_id, u.role_id, CONCAT_WS(' ', u.first_name, u.other_names) as name, u.phone_number,
//		  DATE_FORMAT(u.date_added, '%b %e, %Y  %l:%i:%p') as date_added,  u.online_status, u.user_status, u.email, u.security_id,
//		  DATE_FORMAT(u.last_logout, '%b %e, %Y  %l:%i:%p') as last_logout,
//
//		 ug.user_group_id, ug.title as group_title,
//		 r.role_id, r.role_title
//
//		 FROM users u, user_groups ug, roles r
//
//		 WHERE u.group_id = ug.user_group_id
//		 AND u.role_id = r.role_id
//
//		 AND u.user_id != '$user_id'
//
//		 AND (u.first_name LIKE '%$search_item%'
//		 OR   u.other_names LIKE '%$search_item%'
//		 OR   u.phone_number LIKE '%$search_item%'
//		 OR   u.date_added LIKE '%$search_item%'
//		 OR   u.online_status LIKE '%$search_item%'
//		 OR   u.user_status LIKE '%$search_item%'
//		 OR   u.security_id LIKE '%$search_item%'
//		 OR   u.email LIKE '%$search_item%'
//		 OR   u.last_logout LIKE '%$search_item%'
//		 OR   r.role_title LIKE '%$search_item%'
//		 OR   ug.title LIKE '%$search_item%')
//
//		 ORDER BY $order_by
//
//		 LIMIT $start, $display_per_page";
//	$r = mysqli_query(dbc(),$q);
//
//	if(mysqli_num_rows($r) > 0)
//	{//show table
//
//		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
//		{
//			$output = "<tr>";
//			$output .="<td><input type='checkbox' value='".$row['user_id']."' name='user[]' id='user' class='checkbox1'/></td>" ;
//			$output .= "<td> <a href=''>".$row['name']."</a></td>"; //nam eof the user
//
//			$output .= "<td>".$row['role_title']."</td>"; //group belong to admin or user
//			$output .= "<td>".$row['user_status']."</td>";
//
//			$output .= "<td>".$row['group_title']."</td>";
//			$output .= "<td>".$row['email']."</td>";
//			$output .= "<td>".$row['security_id']."</td>";
//			$output .= "<td>".$row['last_logout']."</td>";
//			$output .= "<td>".$row['date_added']."</td>";
//			$output .= "</tr>";
//
//			echo $output;
//
//		}
//	}
//
//
//	//end table view
//	echo
//	'</tbody>
//    </table>';
//
//
//	//check if pages is greater than 1
//	if($pages > 1)
//	{
//		echo '<p>';
//
//		//determine the current page
//		$current_page = ($start/$display_per_page)+1;
//
//		//if its not a current page display a previous link
//		if($current_page != 1)
//		{
//			echo '<a href="gateway.php?act=view_search_users&search_user='.$search_item.'&sort='.$sort.'&start='.($start - $display_per_page).'&page='.$pages.'" class="nav_button">Previous</a>';
//		}
//
//
//		//make all the numbered pages
//		for($i = 1; $i <= $pages; $i++)
//		{
//			if($i != $current_page)
//			{
//				echo
//				'<a href="gateway.php?act=view_search_users&search_user='.$search_item.'&sort='.$sort.'&start='.(($display_per_page * ($i - 1)))  .'&page='.$pages.'" >' . $i . '</a> ';
//			}
//			else
//			{
//				echo  $i . ' ';
//			}
//		}//end of forloop
//
//
//		//if itsnt d last page get the necxt link
//		if($current_page != $pages)
//		{
//			echo '<a href="gateway.php?act=view_search_users&search_user='.$search_item.'&sort='.$sort.'&start='.($start + $display_per_page).'&page='.$pages.'" class="nav_button">Next</a>';
//
//		}
//	}
//
//
//
//
//
//	echo '</p>';
//
//
//
//
//
//
//
//}//end of view search users




//function that shows roles publish status image
function roles_publish_status_image($status)
{

	$st = $status;

	if($st == 0)
	{
		$output =  '<input type="submit" name="act" class="publish-icon-small" value="unpublish_roles" id="publish_rol"
				data-toggle="tooltip" data-placement="right" title="Published: Click to unpublish item">';
	}
	else
	{
		$output =  '<input type="submit" name="act" class="unpublish-icon-small" value="publish_roles" id="unpublish_rol"
					data-toggle="tooltip" data-placement="right" title="Unpublished: Click to publish item">';
	}

	return $output;


}//end of function dat shows publish roles image

//function view roles
//function that get users roles
function view_roles()
{


	//query the database
	$q = "SELECT `role_id`, `role_title`, `description`,  DATE_FORMAT(date_added, '%b %e, %Y  %l:%i:%p') as date_added, status,
		  DATE_FORMAT(date_modified, '%b %e, %Y  %l:%i:%p') as `date_modified`,
		  `added_by`, `modified_by`  FROM `roles`
		  WHERE status = 0 OR status = 1
		  ORDER BY date_added DESC";
	$r = mysqli_query(dbc(),$q);





	if(mysqli_num_rows($r) > 0)
	{//show table


	$output =
	'<table id="example" class="user display table-bordered table-hover table-striped" cellspacing="0" width="100%" style="font-size:12px;">
	  <thead>
			 	  <th > <input type="checkbox" id="selecctall"  value=""> </th>
				  <th >Role</th>
				  <th >Status</th>
				  <th >Description</th>
				  <th >Date Added</th>
				  <th >Date Modified</th>
				  <th >Added by</th>
				  <th >Modified  by</th>




	  </thead>





	  <tbody>';





		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			$output .= "<tr>";
			$output .="<td>&nbsp;&nbsp;<input type='checkbox' value='".$row['role_id']."' name='role[]' id='role' class='checkbox1'/></td>" ;


			$output .= "<td>".$row['role_title']."</td>";
			$output .= "<td>".roles_publish_status_image($row['status'])."</td>";
			$output .= "<td>".$row['description']."</td>";

			$output .= "<td>".$row['date_added']."</td>";
			$output .= "<td>".$row['date_modified']."</td>";
			$output .= "<td>".$row['added_by']."</td>";
			$output .= "<td>".$row['modified_by']."</td>";
			$output .= "</tr>";

		}
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;





}//end of view roles


//function that get view trashed roles
function view_trashed_roles()
{


	//query the database
	$q = "SELECT `role_id`, `role_title`, `description`,  DATE_FORMAT(date_added, '%b %e, %Y  %l:%i:%p') as date_added, status,
		  DATE_FORMAT(date_modified, '%b %e, %Y  %l:%i:%p') as `date_modified`,
		  DATE_FORMAT(date_trashed, '%b %e, %Y  %l:%i:%p') as `date_trashed`, `added_by`, `modified_by`  FROM `roles`
		  WHERE status = 2
		  ORDER BY date_added DESC";
	$r = mysqli_query(dbc(),$q);





	if(mysqli_num_rows($r) > 0)
	{//show table


	$output =
	'<table id="example" class="user display table-bordered table-hover table-striped" cellspacing="0" width="100%" style="font-size:12px;">
	  <thead>
			 	  <th> <input type="checkbox" id="selecctall"  value=""> </th>
				  <th>Role</th>
				  <th>Description</th>
				  <th>Date Added</th>
				  <th>Date Modified</th>
				  <th>Added by</th>
				  <th>Modified  by</th>
				  <th>Deleted</th>
				  <th></th>



	  </thead>





	  <tbody>';





		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			$output .= "<tr>";
			$output .="<td>&nbsp;&nbsp;<input type='checkbox' value='".$row['role_id']."' name='role[]' id='role' class='checkbox1'/></td>" ;


			$output .= "<td>".$row['role_title']."</td>"; //group belong to admin or user
			$output .= "<td>".$row['description']."</td>";

			$output .= "<td>".$row['date_added']."</td>";
			$output .= "<td>".$row['date_modified']."</td>";
			$output .= "<td>".$row['added_by']."</td>";
			$output .= "<td>".$row['modified_by']."</td>";
			$output .= "<td>".$row['date_trashed']."</td>";
			$output .= '<td><a class="btn btn-success btn-sm pull-right restore_role" id="'.$row['role_id'].'" > Restore</a>
						 <span id="loading"></span></td>';
			$output .= "</tr>";

		}
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';



	return $output;



}//end of view trashed roles



//function that shows user_groups publish status image
function user_groups_publish_status_image($status)
{

	$st = $status;

	if($st == 0)
	{
		$output =  '<input type="submit" name="act" class="publish-icon-small" value="unpublish_user_groups" id="publish_ug"
				data-toggle="tooltip" data-placement="right" title="Published: Click to unpublish item">';
	}
	else
	{
		$output =  '<input type="submit" name="act" class="unpublish-icon-small" value="publish_user_groups" id="unpublish_ug"
					data-toggle="tooltip" data-placement="right" title="Unpublished: Click to publish item">';
	}

	return $output;


}//end of function dat shows publish user_groups image


//user groups
function view_user_groups()
{
	//query the database
	$q = "SELECT `user_group_id`, `title`, `description`, `header_menu`, `toolbar_menu`, `home_menu`,
		  DATE_FORMAT(date_added, '%b %e, %Y  %l:%i:%p') as date_added,
		  DATE_FORMAT(date_modified, '%b %e, %Y  %l:%i:%p') as `date_modified`, `added_by` , modified_by, status
		  FROM `user_groups`
		  WHERE status = 0 OR status = 1
		  ORDER BY date_added DESC";
	$r = mysqli_query(dbc(),$q);



	if(mysqli_num_rows($r) > 0)
	{//show table



		$output =
		'<table id="example" class="user display table-bordered table-hover table-striped" cellspacing="0" width="100%" style="font-size:12px;">
		  <thead>
				 	  <th> <input type="checkbox" id="selecctall"  value=""></th>
					  <th>Title</th>
					  <th>Status</th>
					  <th>Description</th>
					  <th>Header Menu Privs.</th>
					  <th>Toolbar Menu Privs.</th>
					  <th>Home Menu Privs.</th>
					  <th>Date</a></th>
					  <th>Date Modified</th>
					  <th>Added by</th>
					  <th>Modified  by</th>


		  </thead>

		  <tbody>';


		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			$output .= "<tr>";
			$output .="<td>&nbsp;&nbsp;<input type='checkbox' value='".$row['user_group_id']."' name='user_group[]' id='user_group' class='checkbox1'/></td>" ;
			$output .= "<td>".$row['title']."</td>"; //group belong to admin
			$output .= "<td>".user_groups_publish_status_image($row['status'])."</td>";
			$output .= "<td>".$row['description']."</td>";
			$output .= "<td>".$row['header_menu']."</td>";
			$output .= "<td>".$row['toolbar_menu']."</td>";
			$output .= "<td>".$row['home_menu']."</td>";
			$output .= "<td>".$row['date_added']."</td>";
			$output .= "<td>".$row['date_modified']."</td>";
			$output .= "<td>".$row['added_by']."</td>";
			$output .= "<td>".$row['modified_by']."</td>";
			$output .= "</tr>";
		}
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;





}//end of view user groups



//user trashed  groups
function view_trashed_user_groups()
{
	//query the database
	$q = "SELECT `user_group_id`, `title`, `description`, `header_menu`, `toolbar_menu`, `home_menu`,
		  DATE_FORMAT(date_added, '%b %e, %Y  %l:%i:%p') as date_added,
		  DATE_FORMAT(date_modified, '%b %e, %Y  %l:%i:%p') as `date_modified`,
		  DATE_FORMAT(date_trashed, '%b %e, %Y  %l:%i:%p') as `date_trashed`, `added_by` , modified_by , status
		  FROM `user_groups`
		  WHERE status = 2
		  ORDER BY date_added DESC";
	$r = mysqli_query(dbc(),$q);



	if(mysqli_num_rows($r) > 0)
	{//show table



		$output =
		'<table id="example" class="user display table-bordered table-hover table-striped" cellspacing="0" width="100%" style="font-size:12px;">
		  <thead>
				 	  <th> <input type="checkbox" id="selecctall"  value=""></th>
					  <th>Title</th>
					  <th>Description</th>
					  <th>Header Menu Privs.</th>
					  <th>Toolbar Menu Privs.</th>
					  <th>Home Menu Privs.</th>
					  <th>Date</a></th>
					  <th>Date Modified</th>
					  <th>Added by</th>
					  <th>Modified  by</th>
					  <th>Deleted</th>
					  <th></th>


		  </thead>

		  <tbody>';


		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			$output .= "<tr>";
			$output .="<td>&nbsp;&nbsp;<input type='checkbox' value='".$row['user_group_id']."' name='user_group[]' id='user_group' class='checkbox1'/></td>" ;
			$output .= "<td>".$row['title']."</td>"; //group belong to admin or user
			$output .= "<td>".$row['description']."</td>";
			$output .= "<td>".$row['header_menu']."</td>";
			$output .= "<td>".$row['toolbar_menu']."</td>";
			$output .= "<td>".$row['home_menu']."</td>";
			$output .= "<td>".$row['date_added']."</td>";
			$output .= "<td>".$row['date_modified']."</td>";
			$output .= "<td>".$row['added_by']."</td>";
			$output .= "<td>".$row['modified_by']."</td>";
			$output .= "<td>".$row['date_trashed']."</td>";
			$output .= '<td><a class="btn btn-success btn-sm pull-right restore_user_group" id="'.$row['user_group_id'].'" > Restore</a>
						 <span id="loading"></span></td>';
			$output .= "</tr>";
		}
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;





}//end of view trashed user groups


//function select options
function select_status($status)
{

			if($status == '0')
			{
				$output = '<option value="0" selected>Published</option>';
				$output .= '<option value="1" > Unpublished</option>';
				$output .= '<option value="2" > Trashed</option>';
				$output .= '<option value="3" > Archived</option>';
			}
			else if ($status == '1')
			{
				$output = '<option value="0">Published</option>';
				$output .= '<option value="1"  selected > Unpublished</option>';
				$output .= '<option value="2" > Trashed</option>';
				$output .= '<option value="3" > Archived</option>';
			}
			else if ($status == '2')
			{
				$output = '<option value="0">Published</option>';
				$output .= '<option value="1" > Unpublished</option>';
				$output .= '<option value="2"   selected > Trashed</option>';
				$output .= '<option value="3" > Archived</option>';
			}
			else if ($status == '3')
			{
				$output = '<option value="0">Published</option>';
				$output .= '<option value="1"> Unpublished</option>';
				$output .= '<option value="2"> Trashed</option>';
				$output .= '<option value="3" selected> Archived</option>';
			}
			else
			{
				$output = '<option value="0">Published</option>';
				$output .= '<option value="1"> Unpublished</option>';
				$output .= '<option value="2"> Trashed</option>';
				$output .= '<option value="3"> Archived</option>';

			}



			return $output;

} // select statsu


//function select role
function select_role($role)
{
	$r = mysqli_query(dbc(),"SELECT role_id, role_title FROM roles  ORDER BY role_title");
	if(mysqli_num_rows($r) > 0 )
	{
		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			if($role == $row['role_id'])
			{
				$output = "<option value=\"$row[role_id]\" selected>";
				$output .=$row['role_title'];
				$output .="</option>";

			}
			else
			{
				$output = "<option value=\"$row[role_id]\">";
				$output .=$row['role_title'];
				$output .="</option>";
			}


			echo $output;
		}
	}
	else
	{

			$output = "<option>";
			$output .="No role added yet";
			$output .="</option>";

			echo $output;
	}
}
//select role



//function select group and auto select if it has a value
function select_group($group)
{
	// $r = mysqli_query(dbc(),"SELECT user_group_id, title FROM user_groups  ORDER BY title");
	// if(mysqli_num_rows($r) > 0 )
	// {
	// 	while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
	// 	{
	// 		if($group == $row['user_group_id'])
	// 		{
	// 			$output = "<option value=\"$row[user_group_id]\" selected>";
	// 			$output .=$row['title'];
	// 			$output .="</option>";

	// 		}
	// 		else
	// 		{
	// 			$output = "<option value=\"$row[user_group_id]\">";
	// 			$output .=$row['title'];
	// 			$output .="</option>";
	// 		}

	// 		echo $output;
	// 	}
	// }
	// else
	// {

	// 		$output = "<option>";
	// 		$output .="No Groups added yet";
	// 		$output .="</option>";

	// 		echo $output;
	// }
	//



			if($group == '0')
			{
				$output = '<option value="0" selected>None</option>';
				$output .= '<option value="1" > Admin</option>';
				$output .= '<option value="2" > Super Admin</option>';
			}
			else if ($group == '1')
			{
				$output = '<option value="0">None</option>';
				$output .= '<option value="1"  selected > Admin</option>';
				$output .= '<option value="2" > Super Admin</option>';
			}
			else if ($group == '2')
			{
				$output = '<option value="0">None</option>';
				$output .= '<option value="1" > Admin`</option>';
				$output .= '<option value="2"   selected > Super Admin</option>';
			}
			else
			{
				$output = '<option value="0">None</option>';
				$output .= '<option value="1" > Admin`</option>';
				$output .= '<option value="2"   selected > Super Admin</option>';
			}

			echo $output;



}




//function view events

//function view faculties
function view_faculties()
{


	//query the database
	$q = "SELECT id, title, description, code, status,
		 DATE_FORMAT(date_added, '%M %d, %Y %l:%i:%p') as date_added,
		 DATE_FORMAT(date_modified, '%M %d, %Y %l:%i:%p') as date_modified, added_by, modified_by
		 FROM  faculties
		 WHERE status = 0 OR status = 1
		 ORDER BY date_added DESC, date_modified DESC";
	$r = mysqli_query(dbc(),$q);

	if(mysqli_num_rows($r) > 0)
	{//show table



		  $output =
		  '<table id="example" class="user display table-bordered table-hover table-striped" cellspacing="0" width="100%" style="font-size:12px;">
			<thead>
						<th> <input type="checkbox" id="selecctall"  value=""> </th>
						<th>Title</th>
						<th>Code</th>
						<th>Status</th>
						<th>Description</th>
						<th>Date Added</th>
						<th>Date Mod.</th>
						<th>Added By</th>
						<th>Modified By</th>


			</thead>
			<tfoot>
						<th> <input type="checkbox" id="selecctall"  value=""></th>
						<th>Title</th>
						<th>Code</th>
						<th>Status</th>
						<th>Description</th>
						<th>Date Added</th>
						<th>Date Mod.</th>
						<th>Added By</th>
						<th>Modified By</th>

			</tfoot>

			<tbody>';

		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			$output .= "<tr>";
			$output .="<td>&nbsp;&nbsp;<input type='checkbox' value='".$row['id']."' name='faculty[]' id='faculty' class='checkbox1'/></td>" ;
			$output .= "<td> <a href=''>".$row['title']."</a></td>";
			$output .= "<td>".$row['code']."</td>";
			$output .= "<td>".faculty_publish_status_image($row['status'])."</td>";
			$output .= "<td>".$row['description']."</td>";
			$output .= "<td>".$row['date_added']."</td>";
			$output .= "<td>".$row['date_modified']."</td>";
			$output .= "<td>".$row['added_by']."</td>";
			$output .= "<td>".$row['modified_by']."</td>";
			$output .= "</tr>";


		}
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;




}//end of view faculties


//function view trashed faculties
function view_trashed_faculties()
{


	//query the database
	$q = "SELECT id, title, description, code, status,
		 DATE_FORMAT(date_added, '%M %d, %Y %l:%i:%p') as date_added, DATE_FORMAT(date_trashed, '%M %d, %Y %l:%i:%p') as date_trashed,
		 DATE_FORMAT(date_modified, '%M %d, %Y %l:%i:%p') as date_modified, added_by, modified_by
		 FROM  faculties
		 WHERE status = 2
		 ORDER BY date_added DESC, date_modified DESC";
	$r = mysqli_query(dbc(),$q);

	if(mysqli_num_rows($r) > 0)
	{//show table



		  $output =
		  '<table id="example" class="user display table-bordered table-hover table-striped" cellspacing="0" width="100%" style="font-size:12px;">
			<thead>
						<th> <input type="checkbox" id="selecctall"  value=""> </th>
						<th>Title</th>
						<th>Code</th>
						<th>Description</th>
						<th>Date Added</th>
						<th>Date Mod.</th>
						<th>Added By</th>
						<th>Modified By</th>
						<th>Deleted</th>
						<th></th>


			</thead>
			<tfoot>
						<th> <input type="checkbox" id="selecctall"  value=""></th>
						<th>Title</th>
						<th>Code</th>
						<th>Description</th>
						<th>Date Added</th>
						<th>Date Mod.</th>
						<th>Added By</th>
						<th>Modified By</th>
						<th>Deleted</th>
						<th></th>

			</tfoot>

			<tbody>';

		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			$output .= "<tr>";
			$output .="<td>&nbsp;&nbsp;<input type='checkbox' value='".$row['id']."' name='faculty[]' id='faculty' class='checkbox1'/></td>" ;
			$output .= "<td> <a href=''>".$row['title']."</a></td>";
			$output .= "<td>".$row['code']."</td>";
			$output .= "<td>".$row['description']."</td>";
			$output .= "<td>".$row['date_added']."</td>";
			$output .= "<td>".$row['date_modified']."</td>";
			$output .= "<td>".$row['added_by']."</td>";
			$output .= "<td>".$row['modified_by']."</td>";
			$output .= "<td>".$row['date_trashed']."</td>";
			$output .= '<td><a class="btn btn-success btn-sm pull-right restore_faculty" id="'.$row['id'].'" > Restore</a>
						 <span id="loading"></span></td>';
			$output .= "</tr>";


		}
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;




}//end of view trashed faculties


//function that shows faculty publish status image
function faculty_publish_status_image($status)
{

	$st = $status;

	if($st == 0)
	{
		$output =  '<input type="submit" name="act" class="publish-icon-small" value="unpublish_faculties" id="publish_fac"
				data-toggle="tooltip" data-placement="right" title="Published: Click to unpublish item">';
	}
	else
	{
		$output =  '<input type="submit" name="act" class="unpublish-icon-small" value="publish_faculties" id="unpublish_fac"
					data-toggle="tooltip" data-placement="right" title="Unpublished: Click to publish item">';
	}

	return $output;


}//end of function dat shows publish image



//function view departments
function view_departments()
{


	//query the database
	$q = "SELECT id, title, description, code, 	faculty_id,	  status,
		 DATE_FORMAT(date_added, '%M %d, %Y %l:%i:%p') as date_added,
		 DATE_FORMAT(date_modified, '%M %d, %Y %l:%i:%p') as date_modified, added_by, modified_by
		 FROM  departments
		 WHERE status = 0 OR status = 1
		 ORDER BY date_added DESC, date_modified DESC";
	$r = mysqli_query(dbc(),$q);

	if(mysqli_num_rows($r) > 0)
	{//show table



		  $output =
		  '<table id="example" class="user display table-bordered table-hover table-striped" cellspacing="0" width="100%" style="font-size:12px;">
			<thead>
						<th> <input type="checkbox" id="selecctall"  value=""> </th>
						<th>Title</th>
						<th>Code</th>
						<th>Status</th>
						<th>Description</th>
						<th>Faculty</th>
						<th>Date Added</th>
						<th>Date Mod.</th>
						<th>Added By</th>
						<th>Modified By</th>


			</thead>
			<tfoot>
						<th> <input type="checkbox" id="selecctall"  value=""></th>
						<th>Title</th>
						<th>Code</th>
						<th>Status</th>
						<th>Description</th>
						<th>Faculty</th>
						<th>Date Added</th>
						<th>Date Mod.</th>
						<th>Added By</th>
						<th>Modified By</th>

			</tfoot>

			<tbody>';

		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			$output .= "<tr>";
			$output .="<td><input type='checkbox' value='".$row['id']."' name='department[]' id='department' class='checkbox1'/></td>" ;
			$output .= "<td> <a href=''>".$row['title']."</a></td>";
			$output .= "<td>".$row['code']."</td>";
			$output .= "<td>".department_publish_status_image($row['status'])."</td>";
			$output .= "<td>".$row['description']."</td>";
			$output .= "<td>".get_faculty_title($row['faculty_id'])."</td>";
			$output .= "<td>".$row['date_added']."</td>";
			$output .= "<td>".$row['date_modified']."</td>";
			$output .= "<td>".$row['added_by']."</td>";
			$output .= "<td>".$row['modified_by']."</td>";

			$output .= "</tr>";


		}
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;




}//end of view departments

//function view  trashed departments
function view_trashed_departments()
{


	//query the database
	$q = "SELECT id, title, description, code, 	faculty_id,	  status,
		 DATE_FORMAT(date_added, '%M %d, %Y %l:%i:%p') as date_added, DATE_FORMAT(date_trashed, '%M %d, %Y %l:%i:%p') as date_trashed,
		 DATE_FORMAT(date_modified, '%M %d, %Y %l:%i:%p') as date_modified, added_by, modified_by
		 FROM  departments
		 WHERE status = 2
		 ORDER BY date_added DESC, date_modified DESC";
	$r = mysqli_query(dbc(),$q);

	if(mysqli_num_rows($r) > 0)
	{//show table



		  $output =
		  '<table id="example" class="user display table-bordered table-hover table-striped" cellspacing="0" width="100%" style="font-size:12px;">
			<thead>
						<th> <input type="checkbox" id="selecctall"  value=""> </th>
						<th>Title</th>
						<th>Code</th>
						<th>Status</th>
						<th>Description</th>
						<th>Faculty</th>
						<th>Date Added</th>
						<th>Date Mod.</th>
						<th>Added By</th>
						<th>Modified By</th>
						<th> Deleted </th>
						<th></th>


			</thead>
			<tfoot>
						<th> <input type="checkbox" id="selecctall"  value=""></th>
						<th>Title</th>
						<th>Code</th>
						<th>Status</th>
						<th>Description</th>
						<th>Faculty</th>
						<th>Date Added</th>
						<th>Date Mod.</th>
						<th>Added By</th>
						<th>Modified By</th>
						<th> Deleted </th>
						<th></th>


			</tfoot>

			<tbody>';

		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			$output .= "<tr>";
			$output .="<td>&nbsp;&nbsp;<input type='checkbox' value='".$row['id']."' name='department[]' id='department' class='checkbox1'/></td>" ;
			$output .= "<td> <a href=''>".$row['title']."</a></td>";
			$output .= "<td>".$row['code']."</td>";
			$output .= "<td>".department_publish_status_image($row['status'])."</td>";
			$output .= "<td>".$row['description']."</td>";
			$output .= "<td>".get_faculty_title($row['faculty_id'])."</td>";
			$output .= "<td>".$row['date_added']."</td>";
			$output .= "<td>".$row['date_modified']."</td>";
			$output .= "<td>".$row['added_by']."</td>";
			$output .= "<td>".$row['modified_by']."</td>";
			$output .= "<td>".$row['date_trashed']."</td>";
			$output .= '<td><a class="btn btn-success btn-sm pull-right restore_department" id="'.$row['id'].'" > Restore</a>
						 <span id="loading"></span></td>';
			$output .= "</tr>";


		}
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;




}//end of view trashed departments


//function that shows department publish status image
function department_publish_status_image($status)
{

	$st = $status;

	if($st == 0)
	{
		$output =  '<input type="submit" name="act" class="publish-icon-small" value="unpublish_departments" id="publish_dp"
				data-toggle="tooltip" data-placement="right" title="Published: Click to unpublish item">';
	}
	else
	{
		$output =  '<input type="submit" name="act" class="unpublish-icon-small" value="publish_departments" id="unpublish_dp"
					data-toggle="tooltip" data-placement="right" title="Unpublished: Click to publish item">';
	}

	return $output;


}//end of function dat shows publish image  for departments


//function view courses baes on sessiona nd semster per staff
function view_courses($session_id, $id, $semester)
{


	//here user id is for


	//query the database
	$q = "SELECT s.id as st_id,
		  DATE_FORMAT(s.date_added, '%b %e, %Y  %l:%i:%p') as date_added,

		 c.id as c_id, c.title, c.code, c.semester,

		 sc.id, sc.staff_id, sc.course_id



		 FROM staff s, courses c, staff_courses sc
		 WHERE s.id = sc.staff_id

		 AND sc.course_id = c.id
		 AND sc.staff_id = '$user_id'
		 AND sc.session_id = '$session_id'
		 AND c.semester = '$semester'
		 AND c.status = '0'
		 AND (sc.status = '0')



		 ORDER BY c.semester, c.title";
	$r = mysqli_query(dbc(),$q);



	//in the table below result_table stands for resullt fetch throug seraching table(ajax)
	$output = '';

	if(mysqli_num_rows($r) > 0)
	{//show table




		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{


			$output .= '<a class="btn btn-success" href="gateway.php?act=view_course_assessments_students_list&cid='.md5($row['c_id']).'" style="margin:5px;">'.$row['title'].' ('.$row['code'].') - '.'<span class="badge">'.get_total_students_per_course($row['c_id'], $current_session='1').'</span>'.'</a>';



		}
	}
	else
	{//show the msg

			//$output =
//				   '<div class="alert alert-danger alert-dismissable">
//					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
//					<img src="images/info.png" />&nbsp;&nbsp; No course.
//				   </div>';



			$output =
				   '<div class="help-block">  No course(s) assigned </div>';


	}




	return $output;






}//end of view courses




//show major staus 0 - single major, 1- doube major
function show_major_status($id)
{
	if($id == 0)
	{
		$output = 'SM';
	}
	else
	{
		$output = 'DM';
	}

	return $output;

}



//function view prence courses by programme id
//
/*

here view courses programme is
having the parameters $session to hold particular session
$sid is for school id to differentiate the general studies and education courses
$id for department id passed from the user
$mid for department id of the user himself
and $semester for a specific semster
and $level for a specific level
and $pid  for progrramme id



this is for nce
*/

function view_courses_by_programme_prence($session,$sid, $id,  $pid, $semester, $level)
{

	if($sid == 8)// based on general studies courses
	{

		//here there is a trick
		//department id is 8 for general studies courses
		//school id 2  since original they belong to school of education
		//but we are using virtual school id 8 to track them
		//


		$q = "SELECT id,title,code, unit, major_status
			  FROM courses WHERE status = 0  AND semester = '$semester' AND level = '$level' AND type_id = 1
			  AND  department_id = 9

			 ORDER BY  title";

	}
	else if($sid == 9)//based on education courses
	{

		//fetch based on education courses

		$q = "SELECT id,title,code, unit, major_status
			  FROM courses WHERE status = 0  AND semester = '$semester' AND level = '$level' AND type_id = 1
			  AND  department_id = 64

			 ORDER BY  title";

	}
	else
	{

		//fetch courses based on department associated to
		 //query the database
		$q = "SELECT id,title,code, unit, major_status
			  FROM courses WHERE status = 0  AND semester = '$semester' AND level = '$level' AND type_id = 1
			  AND  department_id IN ($id)

			 ORDER BY  title";

	}





	$r = mysqli_query(dbc(),$q);



	//in the table below result_table stands for resullt fetch throug seraching table(ajax)
	$output = '';

	if($r > 0)
	{//show table




		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{

			if(is_admin(get_user_id()))
			{
				$output .= '<a class="btn btn-success" href="gateway.php?act=view_course_assessments_students_list_prence&cid='.md5($row['id']).'&pid='.$pid.'&ses='.$session.'&sem='.$semester.'" style="margin:5px;">'.$row['title'].' ('.$row['code'].') - '.'<span class="badge">'.get_total_students_per_course_prence($pid,$row['id'], $session).'</span> --<span>'.show_major_status($row['major_status']).'</span>'.'</a>';


			}//end of if admin
			else
			{

						//check if the course has upload, make it not to appear
						If(check_if_course_has_upload($row['id'],$session,$semester)) // $row id is course id if tru dont show a course
						{
							$output .= '<a class="btn btn-success" href="#" title="Course Taken" style="margin:5px;">'.$row['title'].' ('.$row['code'].') - '.'<span class="badge">'.get_total_students_per_course_prence($pid,$row['id'], $session).'</span> --<span>'.show_major_status($row['major_status']).'</span>'.'</a>';

						}
						else
						{
							$output .= '<a class="btn btn-success" href="gateway.php?act=view_course_assessments_students_list_prence&cid='.md5($row['id']).'&pid='.$pid.'&ses='.$session.'&sem='.$semester.'" style="margin:5px;">'.$row['title'].' ('.$row['code'].') - '.'<span class="badge">'.get_total_students_per_course_prence($pid,$row['id'], $session).'</span> --<span>'.show_major_status($row['major_status']).'</span>'.'</a>';


						}//end of else of of has uplaoded

			}//end of else if admin






		}//end of while
	}
	else
	{//show the msg




			$output =
				   '<div class="help-block">  No course(s) assigned for this programme.. </div>';


	}




	return $output;






}//end of view pre nce courses by programme id



//function view courses by programme id nce
//
/*

here view courses programme is
having the parameters $session to hold particular session
$sid is for school id to differentiate the general studies and education courses
$id for department id passed from the user
$mid for department id of the user himself
and $semester for a specific semster
and $level for a specific level
and $pid  for progrramme id



this is for nce
*/

function view_courses_by_programme($session,$sid, $id,  $pid, $semester, $level)
{

	//get current session
	//$current_session = 5; //
	$current_session = get_current_session(1);

	//get user id
	$uid = get_user_id();

	if($sid == 8)// based on general studies courses
	{

		//here there is a trick
		//department id is 8 for general studies courses
		//school id 2  since original they belong to school of education
		//but we are using virtual school id 8 to track them
		//


		$q = "SELECT id,title,code, unit, major_status
			  FROM courses WHERE status = 0  AND semester = '$semester' AND level = '$level' AND type_id = 2
			  AND  department_id = 9

			 ORDER BY  title";

	}
	else if($sid == 9)//based on education courses
	{

		//fetch based on education courses

		$q = "SELECT id,title,code, unit, major_status
			  FROM courses WHERE status = 0  AND semester = '$semester' AND level = '$level' AND type_id = 2
			  AND  department_id = 64

			 ORDER BY  title";

	}
	else
	{

		//check for the spceciality if its Technical education assign the IDs to be other courses too becasue the sudents picked various AUT MET WW & others
		if ($id == 67)
		{
		//then set ID
		$id = '24,25,26,27,28,67';
		}

		//fetch courses based on department associated to
		 //query the database
		$q = "SELECT id,title,code, unit, major_status
			  FROM courses WHERE status = 0  AND semester = '$semester' AND level = '$level' AND type_id = 2
			  AND  department_id IN ($id)

			 ORDER BY  title";

	}





	$r = mysqli_query(dbc(),$q);



	//in the table below result_table stands for resullt fetch throug seraching table(ajax)
	$output = '';

	if($r > 0)
	{//show table




		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{






			
			//check if is admin and
			///check if he is an admin
			if(!is_admin($uid))
			{

					//if(($session != $current_session ) || (check_if_course_has_upload_per_user($row['id'],$session,$semester,$pid)))
					if($session != $current_session )
					{


						 ///then check if the course is taken


						 // if taken check if its the person that upload the couse with an if else tell the person its taken

								$output .= '<a data-toggle="tooltip" title="Session Not Active" class="btn btn-success" href="#'.$semester.'" style="margin:5px;">'.$row['title'].' ('.$row['code'].') - '.'<span class="badge">'.get_total_students_per_course($pid,$row['id'], $session).'</span> --<span>'.show_major_status($row['major_status']).'</span>'.'</a>';

					}
					else
					{

						////chec if its admin that did the upload allow the access and else not admin that did the upload block as usual

				// 		if(check_if_admin_staff_entered_score($uid, $row['id'], $session, $semester, $pid))
				// 		{
							if(check_if_course_has_upload_per_user($row['id'],$session,$semester,$pid))
							{//check if the course has been taken


											//get the uploader user id of the course uploaded if uploaded
											$uploader_uid = get_staff_userid_by_course($row['id'],$session,$semester,$pid);

											if($uploader_uid == $uid)
											{//if it is the same for the person
												$output .= '<a class="btn btn-success" href="gateway.php?act=view_course_assessments_students_list&cid='.md5($row['id']).'&pid='.$pid.'&ses='.$session.'&sem='.$semester.'" style="margin:5px;">'.$row['title'].' ('.$row['code'].') - '.'<span class="badge">'.get_total_students_per_course($pid,$row['id'], $session).'</span> --<span>'.show_major_status($row['major_status']).'</span>'.'</a>';


											}
											else
											{
								               $output .= '<a data-toggle="tooltip" title="Course Taken 1 exp" class="btn btn-success" href="#'.$semester.'" style="margin:5px;">'.$row['title'].' ('.$row['code'].') - '.'<span class="badge">'.get_total_students_per_course($pid,$row['id'], $session).'</span> --<span>'.show_major_status($row['major_status']).'</span>'.'</a>';


											}

							}
							else
							{//if the course has not been taken
								$output .= '<a class="btn btn-success" href="gateway.php?act=view_course_assessments_students_list&cid='.md5($row['id']).'&pid='.$pid.'&ses='.$session.'&sem='.$semester.'" style="margin:5px;">'.$row['title'].' ('.$row['code'].') - '.'<span class="badge">'.get_total_students_per_course($pid,$row['id'], $session).'</span> --<span>'.show_major_status($row['major_status']).'</span>'.'</a>';
							
							
							}



						//}//if its not
						//else
						//{
						    
				// 			 	//$output .= '<a class="btn btn-success" href="gateway.php?act=view_course_assessments_students_list&cid='.md5($row['id']).'&pid='.$pid.'&ses='.$session.'&sem='.$semester.'" style="margin:5px;">'.$row['title'].' ('.$row['code'].') - '.'<span class="badge">'.get_total_students_per_course($pid,$row['id'], $session).'</span> --<span>'.show_major_status($row['major_status']).'</span>'.'</a>';
				// 				if(check_if_course_has_upload_per_user($row['id'],$session,$semester,$pid))
				// 				{//check if the course has been taken


				// 								//get the uploader user id of the course uploaded if uploaded
				// 								$uploader_uid = get_staff_userid_by_course($row['id'],$session,$semester,$pid);

				// 								if($uploader_uid == $uid)
				// 								{//if it is the same for the person
				// 									$output .= '<a class="btn btn-success" href="gateway.php?act=view_course_assessments_students_list&cid='.md5($row['id']).'&pid='.$pid.'&ses='.$session.'&sem='.$semester.'" style="margin:5px;">'.$row['title'].' ('.$row['code'].') - '.'<span class="badge">'.get_total_students_per_course($pid,$row['id'], $session).'</span> --<span>'.show_major_status($row['major_status']).'</span>'.'</a>';


				// 								}
				// 								else
				// 								{
				// 									$output .= '<a data-toggle="tooltip" title="Course Taken 2 exp" class="btn btn-success" href="#'.$semester.'" style="margin:5px;">'.$row['title'].' ('.$row['code'].') - '.'<span class="badge">'.get_total_students_per_course($pid,$row['id'], $session).'</span> --<span>'.show_major_status($row['major_status']).'</span>'.'</a>';


				// 								}

				// 				}
				// 				else
				// 				{//if the course has not been taken
				// 					$output .= '<a class="btn btn-success" href="gateway.php?act=view_course_assessments_students_list&cid='.md5($row['id']).'&pid='.$pid.'&ses='.$session.'&sem='.$semester.'" style="margin:5px;">'.$row['title'].' ('.$row['code'].') - '.'<span class="badge">'.get_total_students_per_course($pid,$row['id'], $session).'</span> --<span>'.show_major_status($row['major_status']).'</span>'.'</a>';


				// 				}


				// 		}

								// commented because of the new experience of new courses uploaded by admin before lecturers
								// if(check_if_course_has_upload_per_user($row['id'],$session,$semester,$pid))
								// {//check if the course has been taken
								//
								//
								// 				//get the uploader user id of the course uploaded if uploaded
								// 				$uploader_uid = get_staff_userid_by_course($row['id'],$session,$semester,$pid);
								//
								// 				if($uploader_uid == $uid)
								// 				{//if it is the same for the person
								// 					$output .= '<a class="btn btn-success" href="gateway.php?act=view_course_assessments_students_list&cid='.md5($row['id']).'&pid='.$pid.'&ses='.$session.'&sem='.$semester.'" style="margin:5px;">'.$row['title'].' ('.$row['code'].') - '.'<span class="badge">'.get_total_students_per_course($pid,$row['id'], $session).'</span> --<span>'.show_major_status($row['major_status']).'</span>'.'</a>';
								//
								//
								// 				}
								// 				else
								// 				{
								// 					$output .= '<a data-toggle="tooltip" title="Course Taken" class="btn btn-success" href="#'.$semester.'" style="margin:5px;">'.$row['title'].' ('.$row['code'].') - '.'<span class="badge">'.get_total_students_per_course($pid,$row['id'], $session).'</span> --<span>'.show_major_status($row['major_status']).'</span>'.'</a>';
								//
								//
								// 				}
								//
								// }
								// else
								// {//if the course has not been taken
								// 	$output .= '<a class="btn btn-success" href="gateway.php?act=view_course_assessments_students_list&cid='.md5($row['id']).'&pid='.$pid.'&ses='.$session.'&sem='.$semester.'" style="margin:5px;">'.$row['title'].' ('.$row['code'].') - '.'<span class="badge">'.get_total_students_per_course($pid,$row['id'], $session).'</span> --<span>'.show_major_status($row['major_status']).'</span>'.'</a>';
								//
								//
								// }




					}//else not current session


			}
			else
			{



				$output .= '<a class="btn btn-success" href="gateway.php?act=view_course_assessments_students_list&cid='.md5($row['id']).'&pid='.$pid.'&ses='.$session.'&sem='.$semester.'" style="margin:5px;">'.$row['title'].' ('.$row['code'].') - '.'<span class="badge">'.get_total_students_per_course($pid,$row['id'], $session).'</span> --<span>'.show_major_status($row['major_status']).'</span>'.'</a>';

				//$output .= '<a data-toggle="tooltip" title="Course Taken OR Session Not Active" class="btn btn-success" href="#'.$semester.'" style="margin:5px;">'.$row['title'].' ('.$row['code'].') - '.'<span class="badge">'.get_total_students_per_course($pid,$row['id'], $session).'</span> --<span>'.show_major_status($row['major_status']).'</span>'.'</a>';
			}




		}//end of while
	}
	else
	{//show the msg


			$output = '<div class="help-block">  No course(s) assigned for this programme.. </div>';

	}




	return $output;




}//end of view courses by programme id



//for SUMMER
function view_courses_by_programme_summer($session,$sid, $id,  $pid, $semester, $level)
{

	//get current session
	//$current_session = 6;// get_current_session(1);
	$current_session = 6; //get_current_session(1);

	$uid = get_user_id();


	if($sid == 8)// based on general studies courses
	{

		//here there is a trick
		//department id is 8 for general studies courses
		//school id 2  since original they belong to school of education
		//but we are using virtual school id 8 to track them
		//


		$q = "SELECT id,title,code, unit, major_status
			  FROM courses WHERE status = 0  AND semester = '$semester'  AND type_id = 2
			  AND  department_id = 9

			 ORDER BY  code,title"; //AND level = '$level'

	}
	else if($sid == 9)//based on education courses
	{

		//fetch based on education courses

		$q = "SELECT id,title,code, unit, major_status
			  FROM courses WHERE status = 0  AND semester = '$semester'  AND type_id = 2
			  AND  department_id = 64

			 ORDER BY  code,title"; //AND level = '$level'

	}
	else
	{

        	//check for the spceciality if its Technical education assign the IDs to be other courses too becasue the sudents picked various AUT MET WW & others
		if ($id == 67)
		{
			//then set ID
			$id = '24,25,26,27,28,67';
		}

		//fetch courses based on department associated to
		 //query the database
		$q = "SELECT id,title,code, unit, major_status
			  FROM courses WHERE status = 0  AND semester = '$semester' AND type_id = 2
			  AND  department_id IN ($id)

			 ORDER BY  code,title";

	}
	//AND level = '$level'

	$r = mysqli_query(dbc(),$q);



	//in the table below result_table stands for resullt fetch throug seraching table(ajax)
	$output = '';

	if($r > 0)
	{//show table


		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{


			//check if is admin and
			///check if he is an admin
			if(!is_admin($uid))
			{

					//if(($session != $current_session ) || (check_if_course_has_upload_per_user($row['id'],$session,$semester,$pid)))
					if($session != $current_session )
					{


						 ///then check if the course is taken


						 // if taken check if its the person that upload the couse with an if else tell the person its taken

								$output .= '<a data-toggle="tooltip" title="Session Not Active" class="btn btn-success" href="#'.$semester.'" style="margin:5px;">'.$row['title'].' ('.$row['code'].') - '.'<span class="badge">'.get_total_students_per_course($pid,$row['id'], $session).'</span> --<span>'.show_major_status($row['major_status']).'</span>'.'</a>';

					}
					else
					{

								if(check_if_course_has_upload_per_user($row['id'],$session,$semester,$pid))
								{//check if the course has been taken


												//get the uploader user id of the course uploaded if uploaded
												$uploader_uid = get_staff_userid_by_course($row['id'],$session,$semester,$pid);

												if($uploader_uid == $uid)
												{//if it is the same for the person
													$output .= '<a class="btn btn-success" href="gateway.php?act=view_course_assessments_students_list_summer&cid='.md5($row['id']).'&pid='.$pid.'&ses='.$session.'&sem='.$semester.'" style="margin:5px;">'.$row['title'].' ('.$row['code'].') - '.'<span class="badge">'.get_total_students_per_course_summer($pid,$row['id'], $session).'</span> --<span>'.show_major_status($row['major_status']).'</span>'.'</a>';


												}
												else
												{
													$output .= '<a data-toggle="tooltip" title="Course Taken" class="btn btn-success" href="#'.$semester.'" style="margin:5px;">'.$row['title'].' ('.$row['code'].') - '.'<span class="badge">'.get_total_students_per_course_summer($pid,$row['id'], $session).'</span> --<span>'.show_major_status($row['major_status']).'</span>'.'</a>';


												}

								}
								else
								{//if the course has not been taken
									$output .= '<a class="btn btn-success" href="gateway.php?act=view_course_assessments_students_list_summer&cid='.md5($row['id']).'&pid='.$pid.'&ses='.$session.'&sem='.$semester.'" style="margin:5px;">'.$row['title'].' ('.$row['code'].') - '.'<span class="badge">'.get_total_students_per_course_summer($pid,$row['id'], $session).'</span> --<span>'.show_major_status($row['major_status']).'</span>'.'</a>';


								}




					}//else not current session


			}
			else
			{



				$output .= '<a class="btn btn-success" href="gateway.php?act=view_course_assessments_students_list_summer&cid='.md5($row['id']).'&pid='.$pid.'&ses='.$session.'&sem='.$semester.'" style="margin:5px;">'.$row['title'].' ('.$row['code'].') - '.'<span class="badge">'.get_total_students_per_course_summer($pid,$row['id'], $session).'</span> --<span>'.show_major_status($row['major_status']).'</span>'.'</a>';

				//$output .= '<a data-toggle="tooltip" title="Course Taken OR Session Not Active" class="btn btn-success" href="#'.$semester.'" style="margin:5px;">'.$row['title'].' ('.$row['code'].') - '.'<span class="badge">'.get_total_students_per_course($pid,$row['id'], $session).'</span> --<span>'.show_major_status($row['major_status']).'</span>'.'</a>';
			}

			// if($session == $current_session)
			// {
			//
			//
			// 	if(is_admin(get_user_id()))
			// 	{
			// 			$output .= '<a class="btn btn-success" href="gateway.php?act=view_course_assessments_students_list_summer&cid='.md5($row['id']).'&pid='.$pid.'&ses='.$session.'&sem='.$semester.'" style="margin:5px;">'.$row['title'].' ('.$row['code'].') - '.'<span class="badge">'.get_total_students_per_course_summer($pid,$row['id'], $session).'</span> --<span>'.show_major_status($row['major_status']).'</span>'.'</a>';
			//
			// 	}
			// 	else
			// 	{
			// 					If(check_if_course_has_upload($row['id'],$session,$semester)) // $row id is course id if tru dont show a course
			// 					{
			// 						$output .= '<a data-toggle="tooltip" title="Course Taken" class="btn btn-success" href="#'.$semester.'" style="margin:5px;">'.$row['title'].' ('.$row['code'].') - '.'<span class="badge">'.get_total_students_per_course_summer($pid,$row['id'], $session).'</span> --<span>'.show_major_status($row['major_status']).'</span>'.'</a>';
			//
			// 					}//end if couse score is uplaoded
			// 					else
			// 					{
			// 						$output .= '<a class="btn btn-success" href="gateway.php?act=view_course_assessments_students_list_summer&cid='.md5($row['id']).'&pid='.$pid.'&ses='.$session.'&sem='.$semester.'" style="margin:5px;">'.$row['title'].' ('.$row['code'].') - '.'<span class="badge">'.get_total_students_per_course_summer($pid,$row['id'], $session).'</span> --<span>'.show_major_status($row['major_status']).'</span>'.'</a>';
			//
			// 					}//end of if else of score uploade
			//
			// 	}//end of else of admin
			//
			//
			//
			//
			//
			// }
			// else
			// {
			// 	$output .= '<a data-toggle="tooltip" title="Session Not Active" class="btn btn-success" href="#'.$semester.'" style="margin:5px;">'.$row['title'].' ('.$row['code'].') - '.'<span class="badge">'.get_total_students_per_course_summer($pid,$row['id'], $session).'</span> --<span>'.show_major_status($row['major_status']).'</span>'.'</a>';
			// }//end of if current session or not

		}//end of while
	}
	else
	{//show the msg


			$output =
				   '<div class="help-block">  No course(s) assigned for this programme.. </div>';
	}

	return $output;


}//end of view courses by programme id for SUMMER





//function that get student list in a particular courses
function view_student_list_per_course_prence($programme_id,$course_id,$session)
{
	//show list of students who are still in school
	//dont show the dropped course bu the students

	$q = "SELECT s.id, CONCAT_WS(' ', s.first_name, s.other_names) as name,s.gender, s.number, s.level, s.validity_status, s.department_id, s.programme_id, s.school_id,
		sc.id as sc_id, sc.student_id, sc.course_id,sc.programme_id, sc.ca_score, sc.exam_score, (sc.ca_score + sc.exam_score) as total_score,  sc.grade, sc.add_drop_status


		 FROM students_prence s, students_courses_prence sc
		 WHERE s.validity_status = '0'

		 AND s.id = sc.student_id
		 AND sc.add_drop_status != '2'
		 AND md5(sc.course_id) = '$course_id'
		 AND sc.programme_id = '$programme_id'
		 AND sc.session_id = '$session'


		 ORDER BY s.number ASC, s.level DESC";


	$r = mysqli_query(dbc(),$q);



	//in the table below result_table stands for resullt fetch throug seraching table(ajax)


	if(mysqli_num_rows($r) > 0)
	{//show table




	$output ='<table id="example" class="user display table-bordered table-hover table-striped responsive" width="100%"  cellspacing="0" style="font-size:12px;">
				<thead>




						<!--<th  > <input type="checkbox" id="selecctall"  value="" data-toggle="tooltip" title="Check All"></th>-->

						<th>Matric No. </th>
						<th>Name</th>
						<th>Gender</th>

						<th>Level</th>
						<th> C. A Score (40) </th>
						<th> Exam Score (60) </th>
						<th> Total Score (100) / Grades </th>


				</thead>



				<tfoot>
				   		<th>Matric No. </th>
						<th>Name</th>
						<th>Gender</th>

						<th>Level</th>
						<th> C. A Score (40) </th>
						<th> Exam Score (60) </th>
						<th> Total Score (100) / Grades </th>
				</tfoot>

				<tbody>';



		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			$output .= "<tr>";
			//$output .="<td>&nbsp;&nbsp;&nbsp;<input type='checkbox' value='".$row['student_id']."' name='student[]' id='user' class='checkbox1'/></td>" ;

			$output .= "<td>".$row['number']."</td>";
			$output .= "<td>".strtoupper($row['name'])."</td>"; //nam eof the user
			$output .= "<td>".shorten_gender($row['gender'])."</td>";


			$output .= "<td>".$row['level']."</td>";
			// $output .= "<td>".get_school_title($row['faculty_id'])."</td>";
			// $output .= "<td>".get_department_title($row['department_id'])."</td>";
			$output .= '<td  id="'.$row['sc_id'].'" >'.$row['ca_score'].'</td>';
			$output .= '<td   id="'.$row['sc_id'].'" >'.$row['exam_score'].'</td>';
			$output .= '<td id="'.$row['total_score'].'"  class="get-score '.get_grade_color(get_student_grade_by_score($row['total_score'])).'">'.$row['total_score'].' / '.get_student_grade_by_score($row['total_score']).'</td>'; //get grade and pass it to color for status


			$output .= "</tr>";



		}
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;




}//end of prence student list that take courses


//view courses not by programme
function view_courses_by_export($session,$sid, $id,  $pid, $semester, $level)
{

	//get current session
	//$current_session = 5; // get_current_session(1);
	$current_session = get_current_session(1);


	if($sid == 8)// based on general studies courses
	{

		//here there is a trick
		//department id is 8 for general studies courses
		//school id 2  since original they belong to school of education
		//but we are using virtual school id 8 to track them
		//


		$q = "SELECT id,title,code, unit, major_status
			  FROM courses WHERE status = 0  AND semester = '$semester' AND level = '$level' AND type_id = 2
			  AND  department_id = 9

			 ORDER BY  title";

	}
	else if($sid == 9)//based on education courses
	{

		//fetch based on education courses



		$q = "SELECT id,title,code, unit, major_status
			  FROM courses WHERE status = 0  AND semester = '$semester' AND level = '$level' AND type_id = 2
			  AND  department_id = 64

			 ORDER BY  title";



	}
	else
	{

		//fetch courses based on department associated to
		 //query the database
		$q = "SELECT id,title,code, unit, major_status
			  FROM courses WHERE status = 0  AND semester = '$semester' AND level = '$level' AND type_id = 2
			  AND  department_id IN ($id)

			 ORDER BY  title";

	}





	$r = mysqli_query(dbc(),$q);



	//in the table below result_table stands for resullt fetch throug seraching table(ajax)
	$output = '';

	if($r > 0)
	{//show table



		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{

// 			if($session == $current_session)
// 			{
				$output .= '<a class="btn btn-success" href="gateway.php?act=view_course_assessments_students_list_gen_exp&cid='.md5($row['id']).'&did='.$id.'&ses='.$session.'&sem='.$semester.'" style="margin:5px;">'.$row['title'].' ('.$row['code'].') '.'</a>';
// 			}
// 			else
// 			{
// 				$output .= '<a data-toggle="tooltip" title="Session Not Active" class="btn btn-success" href="#'.$semester.'" style="margin:5px;">'.$row['title'].' ('.$row['code'].') - '.'</a>';
// 			}


		}
	}
	else
	{//show the msg




			$output = '<div class="help-block">  No course(s) assigned for this programme.. </div>';


	}




	return $output;






}//end of view courses without programme id


//function that get student list in a particular courses
function view_student_list_per_course($programme_id,$course_id,$session)
{
	//show list of students who are still in school
	//dont show the dropped course bu the students

	$q = "SELECT s.id, CONCAT_WS(' ', s.first_name, s.other_names) as name,s.gender, s.number, s.level, s.validity_status, s.department_id, s.programme_id, s.school_id,
		sc.id as sc_id, sc.student_id, sc.course_id,sc.programme_id, sc.ca_score, sc.exam_score, (sc.ca_score + sc.exam_score) as total_score,  sc.grade, sc.add_drop_status


		 FROM students_nce s, students_courses_nce sc
		 WHERE s.validity_status = '0'

		 AND s.id = sc.student_id
		 AND sc.add_drop_status != '2'
		 AND md5(sc.course_id) = '$course_id'
		 AND sc.programme_id = '$programme_id'
		 AND sc.session_id = '$session'


		 ORDER BY s.number ASC, s.level DESC";


	$r = mysqli_query(dbc(),$q);



	//in the table below result_table stands for resullt fetch throug seraching table(ajax)


	if(mysqli_num_rows($r) > 0)
	{//show table




	$output ='<table id="example" class="user display table-bordered table-hover table-striped responsive" width="100%"  cellspacing="0" style="font-size:12px;">
				<thead>




						<!--<th  > <input type="checkbox" id="selecctall"  value="" data-toggle="tooltip" title="Check All"></th>-->

						<th>Matric No. </th>
						<th>Name</th>
						<th>Gender</th>

						<th>Level</th>
						<th> C. A Score (40) </th>
						<th> Exam Score (60) </th>
						<th> Total Score (100) / Grades </th>


				</thead>



				<tfoot>
				   		<th>Matric No. </th>
						<th>Name</th>
						<th>Gender</th>

						<th>Level</th>
						<th> C. A Score (40) </th>
						<th> Exam Score (60) </th>
						<th> Total Score (100) / Grades </th>
				</tfoot>

				<tbody>';



		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			$output .= "<tr>";
			//$output .="<td>&nbsp;&nbsp;&nbsp;<input type='checkbox' value='".$row['student_id']."' name='student[]' id='user' class='checkbox1'/></td>" ;

			$output .= "<td>".$row['number']."</td>";
			$output .= "<td>".strtoupper($row['name'])."</td>"; //nam eof the user
			$output .= "<td>".shorten_gender($row['gender'])."</td>";


			$output .= "<td>".$row['level']."</td>";
			// $output .= "<td>".get_school_title($row['faculty_id'])."</td>";
			// $output .= "<td>".get_department_title($row['department_id'])."</td>";
			$output .= '<td  id="'.$row['sc_id'].'" >'.$row['ca_score'].'</td>';
			$output .= '<td   id="'.$row['sc_id'].'" >'.$row['exam_score'].'</td>';
			$output .= '<td id="'.$row['total_score'].'"  class="get-score '.get_grade_color(get_student_grade_by_score($row['total_score'])).'">'.$row['total_score'].' / '.get_student_grade_by_score($row['total_score']).'</td>'; //get grade and pass it to color for status


			$output .= "</tr>";



		}
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;




}//end of student list that take courses


//function that get student list in a particular courses for summer
function view_student_list_per_course_summer($programme_id,$course_id,$session)
{
	//show list of students who are still in school
	//dont show the dropped course bu the students

	$q = "SELECT s.id, CONCAT_WS(' ', s.first_name, s.other_names) as name,s.gender, s.number, s.level, s.validity_status, s.department_id, s.programme_id, s.school_id,
		sc.id as sc_id, sc.student_id, sc.course_id,sc.programme_id, sc.ca_score, sc.exam_score, (sc.ca_score + sc.exam_score) as total_score,  sc.grade, sc.add_drop_status


		 FROM summer_students s, summer_students_courses_nce sc
		 WHERE s.validity_status = '0'

		 AND s.id = sc.student_id
		 AND sc.add_drop_status != '2'
		 AND md5(sc.course_id) = '$course_id'
		 AND sc.programme_id = '$programme_id'
		 AND sc.session_id = '$session'


		 ORDER BY s.number ASC";


	$r = mysqli_query(dbc(),$q);



	//in the table below result_table stands for resullt fetch throug seraching table(ajax)


	if(mysqli_num_rows($r) > 0)
	{//show table




	$output ='<table id="example" class="user display table-bordered table-hover table-striped responsive" width="100%"  cellspacing="0" style="font-size:12px;">
				<thead>

						<!--<th  > <input type="checkbox" id="selecctall"  value="" data-toggle="tooltip" title="Check All"></th>-->

						<th>Matric No. </th>
						<th>Name</th>
						<th>Gender</th>

						<th>Level</th>
						<th> C. A Score (40) </th>
						<th> Exam Score (60) </th>
						<th> Total Score (100) / Grades </th>


				</thead>



				<tfoot>
				   		<th>Matric No. </th>
						<th>Name</th>
						<th>Gender</th>

						<th>Level</th>
						<th> C. A Score (40) </th>
						<th> Exam Score (60) </th>
						<th> Total Score (100) / Grades </th>
				</tfoot>

				<tbody>';



		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			$output .= "<tr>";
			//$output .="<td>&nbsp;&nbsp;&nbsp;<input type='checkbox' value='".$row['student_id']."' name='student[]' id='user' class='checkbox1'/></td>" ;

			$output .= "<td>".$row['number']."</td>";
			$output .= "<td>".strtoupper($row['name'])."</td>"; //nam eof the user
			$output .= "<td>".shorten_gender($row['gender'])."</td>";


			$output .= "<td>".$row['level']."</td>";
			// $output .= "<td>".get_school_title($row['faculty_id'])."</td>";
			// $output .= "<td>".get_department_title($row['department_id'])."</td>";
			$output .= '<td  id="'.$row['sc_id'].'" >'.$row['ca_score'].'</td>';
			$output .= '<td   id="'.$row['sc_id'].'" >'.$row['exam_score'].'</td>';
			$output .= '<td id="'.$row['total_score'].'"  class="get-score '.get_grade_color(get_student_grade_by_score($row['total_score'])).'">'.$row['total_score'].' / '.get_student_grade_by_score($row['total_score']).'</td>'; //get grade and pass it to color for status


			$output .= "</tr>";



		}
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;




}//end of student list that take courses for summer


//function that get student list in a particular courses and not by programme
function view_student_list_per_course_by_exp($dept_id,$course_id,$session)
{
	//show list of students who are still in school
	//dont show the dropped course bu the students
//

	$q = "SELECT s.id, CONCAT_WS(' ', s.first_name, s.other_names) as name,s.gender, s.number, s.level, s.validity_status, s.department_id, s.programme_id, s.school_id,
		sc.id as sc_id, sc.student_id, sc.course_id,sc.programme_id, sc.ca_score, sc.exam_score, (sc.ca_score + sc.exam_score) as total_score,  sc.grade, sc.add_drop_status


		 FROM students_nce s, students_courses_nce sc
		 WHERE s.validity_status = '0'

		 AND s.id = sc.student_id
		 AND sc.add_drop_status != '2'
		 	AND md5(sc.course_id) = '$course_id'
 		 AND sc.course_department_id = '$dept_id'
 		 AND sc.session_id = '$session'


		 ORDER BY s.number ASC, s.level DESC";


	$r = mysqli_query(dbc(),$q);



	//in the table below result_table stands for resullt fetch throug seraching table(ajax)


	if(mysqli_num_rows($r) > 0)
	{//show table




	$output ='<table id="example" class="user display table-bordered table-hover table-striped responsive" width="100%"  cellspacing="0" style="font-size:12px;">
				<thead>




						<!--<th  > <input type="checkbox" id="selecctall"  value="" data-toggle="tooltip" title="Check All"></th>-->

						<th>Matric No. </th>
						<th>Name</th>
						<th>Gender</th>

						<th>Level</th>
						<th> C. A Score (40) </th>
						<th> Exam Score (60) </th>
						<th> Total Score (100) / Grades </th>


				</thead>



				<tfoot>
				   		<th>Matric No. </th>
						<th>Name</th>
						<th>Gender</th>

						<th>Level</th>
						<th> C. A Score (40) </th>
						<th> Exam Score (60) </th>
						<th> Total Score (100) / Grades </th>
				</tfoot>

				<tbody>';



		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			$output .= "<tr>";
			//$output .="<td>&nbsp;&nbsp;&nbsp;<input type='checkbox' value='".$row['student_id']."' name='student[]' id='user' class='checkbox1'/></td>" ;

			$output .= "<td>".$row['number']."</td>";
			$output .= "<td>".strtoupper($row['name'])."</td>"; //nam eof the user
			$output .= "<td>".shorten_gender($row['gender'])."</td>";


			$output .= "<td>".$row['level']."</td>";
			// $output .= "<td>".get_school_title($row['faculty_id'])."</td>";
			// $output .= "<td>".get_department_title($row['department_id'])."</td>";
			$output .= '<td  id="'.$row['sc_id'].'" >'.$row['ca_score'].'</td>';
			$output .= '<td   id="'.$row['sc_id'].'" >'.$row['exam_score'].'</td>';
			$output .= '<td id="'.$row['total_score'].'"  class="get-score '.get_grade_color(get_student_grade_by_score($row['total_score'])).'">'.$row['total_score'].' / '.get_student_grade_by_score($row['total_score']).'</td>'; //get grade and pass it to color for status


			$output .= "</tr>";



		}
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;




}//end of student list that take courses per gen export


//function that get student list in a particular courses and a scores sheet
function view_enter_score_student_list_per_course($programme_id,$course_id,$session)
{
	//show list of students who are still in school
	//dont show the dropped course bu the students


	// $q = "SELECT s.id, CONCAT_WS(' ', s.first_name, s.other_names) as name, s.number, s.level, s.validity_status, s.department_id, s.programme_id, s.school_id,
	// 	sc.id as sc_id, sc.student_id, sc.course_id, sc.ca_score, sc.exam_score, (sc.ca_score + sc.exam_score) as total_score,  sc.grade, sc.add_drop_status


	// 	 FROM students_nce s, students_courses_nce sc
	// 	 WHERE s.validity_status = '0'

	// 	 AND s.id = sc.student_id
	// 	 AND sc.add_drop_status != '2'
	// 	 AND md5(sc.course_id) = '$course_id'

	// 	 ORDER BY s.number ASC, s.level DESC";



	$q = "SELECT s.id, CONCAT_WS(' ', s.first_name, s.other_names) as name,s.gender, s.number, s.level, s.validity_status, s.department_id, s.programme_id, s.school_id,
		sc.id as sc_id, sc.student_id, sc.course_id,sc.programme_id, sc.ca_score, sc.exam_score, (sc.ca_score + sc.exam_score) as total_score,  sc.grade, sc.add_drop_status


		 FROM students_nce s, students_courses_nce sc
		 WHERE s.validity_status = '0'

		 AND s.id = sc.student_id
		 AND sc.add_drop_status != '2'
		 AND md5(sc.course_id) = '$course_id'
		 AND sc.programme_id = '$programme_id'
		 AND sc.session_id = '$session'


		 ORDER BY s.number ASC, s.level DESC";
	$r = mysqli_query(dbc(),$q);



	//in the table below result_table stands for resullt fetch throug seraching table(ajax)


	if(mysqli_num_rows($r) > 0)
	{//show table

	$output ='<table id="example" class="table display table-bordered table-hover table-striped responsive" width="100%"  cellspacing="0" style="font-size:12px;">
				<thead>

						<!--<th  > <input type="checkbox" id="selecctall"  value="" data-toggle="tooltip" title="Check All"></th>-->

						<th  tabindex="0">Name</th>
						<th  tabindex="0">Gender</th>
						<th  tabindex="0">Level</th>
						<th tabindex="0"> Matric No. </th>
						<th tabindex="0">C. A </th>
						<th tabindex="0"> Exam Score </th>

				</thead>



				<!--<tfoot>
				   		<th > </th>

						<th>Name</th>
						<th> Matric No. </th>
						<th>Level</th>
				</tfoot>-->

				<tbody>';



		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			//$_COOKIE['total_score'] = $row['total_score'];



			$output .= '<tr>';
			//$output .="<td>&nbsp;&nbsp;&nbsp;<input type='checkbox' value='".$row['student_id']."' name='student[]' id='user' class='checkbox1'/></td>" ;
			$output .= "<td>".$row['number']."</td>";
			$output .= "<td>".$row['name']."</td>"; //nam eof the user



			$output .= "<td>".shorten_gender($row['gender'])."</td>";


			$output .= "<td>".$row['level']."</td>";
			$output .= '<td class="xedit" id="'.$row['sc_id'].'" key="ca_score">'.$row['ca_score'].'</td>';

			//$output .= '<td><input  id="title" class="form-control input-sm" type="text" placeholder="Enter CA"  name="title" value="" /></td>';
			//$output .= '<td><input  id="title" class="form-control input-sm" type="text" placeholder="Enter Exam Score"  name="title" value="" /></td>';
			$output .= '<td  class="xedit" id="'.$row['sc_id'].'" key="exam_score">'.$row['exam_score'].'</td>';
			//$output .= '<td class="xedit" id="'.$row['ss_id'].'" key="grade">'.$row['grade'].'</td>';
			//$output .= '<td id="'.$row['total_score'].'"  class="get-score '.get_grade_color(get_student_grade_by_score($row['total_score'])).'"><span id="timeval">--.--</span></td>'; //get grade and pass it to color for status
			//$output .= '<td id="'.$row['total_score'].'"  class="get-score '.get_grade_color(get_student_grade_by_score($row['total_score'])).'">'.$row['total_score'].' / '.get_student_grade_by_score($row['total_score']).'</td>'; //get grade and pass it to color for status
			//$output .= '<td><span id="timeval">--.--</span></td>'; //get grade and pass it to color for status


			$output .= "</tr>";


		}
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;




}//end of student list that take a particular courses and a score sheet



//function that get student list in a particular courses and a scores sheet
function view_enter_score_student_list_per_course_prence($programme_id,$course_id,$session)
{
	//show list of students who are still in school
	//dont show the dropped course bu the students



	$q = "SELECT s.id, CONCAT_WS(' ', s.first_name, s.other_names) as name,s.gender, s.number, s.level, s.validity_status, s.department_id, s.programme_id, s.school_id,
		sc.id as sc_id, sc.student_id, sc.course_id,sc.programme_id, sc.ca_score, sc.exam_score, (sc.ca_score + sc.exam_score) as total_score,  sc.grade, sc.add_drop_status


		 FROM students_prence s, students_courses_prence sc
		 WHERE s.validity_status = '0'

		 AND s.id = sc.student_id
		 AND sc.add_drop_status != '2'
		 AND md5(sc.course_id) = '$course_id'
		 AND sc.programme_id = '$programme_id'
		 AND sc.session_id = '$session'


		 ORDER BY s.number ASC, s.level DESC";
	$r = mysqli_query(dbc(),$q);



	//in the table below result_table stands for resullt fetch throug seraching table(ajax)


	if(mysqli_num_rows($r) > 0)
	{//show table

	$output ='<table id="example" class="table display table-bordered table-hover table-striped responsive" width="100%"  cellspacing="0" style="font-size:12px;">
				<thead>

						<!--<th  > <input type="checkbox" id="selecctall"  value="" data-toggle="tooltip" title="Check All"></th>-->

						<th  tabindex="0">Name</th>
						<th  tabindex="0">Gender</th>
						<th  tabindex="0">Level</th>
						<th tabindex="0"> Matric No. </th>
						<th tabindex="0">C. A </th>
						<th tabindex="0"> Exam Score </th>

				</thead>



				<!--<tfoot>
				   		<th > </th>

						<th>Name</th>
						<th> Matric No. </th>
						<th>Level</th>
				</tfoot>-->

				<tbody>';



		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			//$_COOKIE['total_score'] = $row['total_score'];



			$output .= '<tr>';
			//$output .="<td>&nbsp;&nbsp;&nbsp;<input type='checkbox' value='".$row['student_id']."' name='student[]' id='user' class='checkbox1'/></td>" ;
			$output .= "<td>".$row['number']."</td>";
			$output .= "<td>".$row['name']."</td>"; //nam eof the user



			$output .= "<td>".shorten_gender($row['gender'])."</td>";


			$output .= "<td>".$row['level']."</td>";
			$output .= '<td class="xedit_prence" id="'.$row['sc_id'].'" key="ca_score">'.$row['ca_score'].'</td>';

			//$output .= '<td><input  id="title" class="form-control input-sm" type="text" placeholder="Enter CA"  name="title" value="" /></td>';
			//$output .= '<td><input  id="title" class="form-control input-sm" type="text" placeholder="Enter Exam Score"  name="title" value="" /></td>';
			$output .= '<td  class="xedit_prence" id="'.$row['sc_id'].'" key="exam_score">'.$row['exam_score'].'</td>';
			//$output .= '<td class="xedit" id="'.$row['ss_id'].'" key="grade">'.$row['grade'].'</td>';
			//$output .= '<td id="'.$row['total_score'].'"  class="get-score '.get_grade_color(get_student_grade_by_score($row['total_score'])).'"><span id="timeval">--.--</span></td>'; //get grade and pass it to color for status
			//$output .= '<td id="'.$row['total_score'].'"  class="get-score '.get_grade_color(get_student_grade_by_score($row['total_score'])).'">'.$row['total_score'].' / '.get_student_grade_by_score($row['total_score']).'</td>'; //get grade and pass it to color for status
			//$output .= '<td><span id="timeval">--.--</span></td>'; //get grade and pass it to color for status


			$output .= "</tr>";


		}
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;




}//end of student list that take a particular courses and a score sheet

//function that get student list in a particular courses and a scores sheet fr summer
function view_enter_score_student_list_per_course_summer($programme_id,$course_id,$session)
{
	//show list of students who are still in school
	//dont show the dropped course bu the students



	$q = "SELECT s.id, CONCAT_WS(' ', s.first_name, s.other_names) as name,s.gender, s.number, s.level, s.validity_status, s.department_id, s.programme_id, s.school_id,
		sc.id as sc_id, sc.student_id, sc.course_id,sc.programme_id, sc.ca_score, sc.exam_score, (sc.ca_score + sc.exam_score) as total_score,  sc.grade, sc.add_drop_status


		 FROM summer_students s, summer_students_courses_nce sc
		 WHERE s.validity_status = '0'

		 AND s.id = sc.student_id
		 AND sc.add_drop_status != '2'
		 AND md5(sc.course_id) = '$course_id'
		 AND sc.programme_id = '$programme_id'
		 AND sc.session_id = '$session'


		 ORDER BY s.number ASC, s.level DESC";
	$r = mysqli_query(dbc(),$q);



	//in the table below result_table stands for resullt fetch throug seraching table(ajax)


	if(mysqli_num_rows($r) > 0)
	{//show table

	$output ='<table id="example" class="table display table-bordered table-hover table-striped responsive" width="100%"  cellspacing="0" style="font-size:12px;">
				<thead>

						<!--<th  > <input type="checkbox" id="selecctall"  value="" data-toggle="tooltip" title="Check All"></th>-->

						<th  tabindex="0">Name</th>
						<th  tabindex="0">Gender</th>
						<th  tabindex="0">Level</th>
						<th tabindex="0"> Matric No. </th>
						<th tabindex="0">C. A </th>
						<th tabindex="0"> Exam Score </th>

				</thead>



				<!--<tfoot>
				   		<th > </th>

						<th>Name</th>
						<th> Matric No. </th>
						<th>Level</th>
				</tfoot>-->

				<tbody>';



		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			//$_COOKIE['total_score'] = $row['total_score'];



			$output .= '<tr>';
			//$output .="<td>&nbsp;&nbsp;&nbsp;<input type='checkbox' value='".$row['student_id']."' name='student[]' id='user' class='checkbox1'/></td>" ;
			$output .= "<td>".$row['number']."</td>";
			$output .= "<td>".$row['name']."</td>"; //nam eof the user



			$output .= "<td>".shorten_gender($row['gender'])."</td>";


			$output .= "<td>".$row['level']."</td>";
			$output .= '<td class="xedit_summer" id="'.$row['sc_id'].'" key="ca_score">'.$row['ca_score'].'</td>';

			//$output .= '<td><input  id="title" class="form-control input-sm" type="text" placeholder="Enter CA"  name="title" value="" /></td>';
			//$output .= '<td><input  id="title" class="form-control input-sm" type="text" placeholder="Enter Exam Score"  name="title" value="" /></td>';
			$output .= '<td  class="xedit_summer" id="'.$row['sc_id'].'" key="exam_score">'.$row['exam_score'].'</td>';
			//$output .= '<td class="xedit" id="'.$row['ss_id'].'" key="grade">'.$row['grade'].'</td>';
			//$output .= '<td id="'.$row['total_score'].'"  class="get-score '.get_grade_color(get_student_grade_by_score($row['total_score'])).'"><span id="timeval">--.--</span></td>'; //get grade and pass it to color for status
			//$output .= '<td id="'.$row['total_score'].'"  class="get-score '.get_grade_color(get_student_grade_by_score($row['total_score'])).'">'.$row['total_score'].' / '.get_student_grade_by_score($row['total_score']).'</td>'; //get grade and pass it to color for status
			//$output .= '<td><span id="timeval">--.--</span></td>'; //get grade and pass it to color for status


			$output .= "</tr>";


		}
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';



	return $output;




}//end of student list that take a particular courses and a score sheet for SUMMER



//Function to fetch current session
	function get_current_session($id)
	{
		$result = mysqli_query(dbc(),"SELECT id FROM sessions WHERE current_session = '$id'");
		$row = mysqli_fetch_assoc($result);
		$id = $row['id'];

		$id = 6;

	return $id;
	}


	//Function to fetch  session
	function get_session_title($id)
	{
		$result = mysqli_query(dbc(),"SELECT title FROM sessions WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$title = $row['title'];

	return $title;
	}



	//Function to fetch current semester
	function get_current_semester($id)
	{
		$result = mysqli_query(dbc(),"SELECT id FROM semesters WHERE current_session = '$id'");
		$row = mysqli_fetch_assoc($result);
		$id = $row['id'];

	return $id;
	}


	//Function to fetch  semester
	function get_semester_title($id)
	{
		$result = mysqli_query(dbc(),"SELECT title FROM semesters WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$title = $row['title'];

	return $title;
	}




//A >= 70
//B


#///////////// get student functions
/////////////////////////////////////////

//show grade base on score of ca and exam score
//GetColour code for current project completion status
function get_student_grade_by_score($total_score)
{
	//$total_score = $ca_score + $exam_score;


	if($total_score >= "70"){
	  $grade = 'A';
	  }
	if($total_score >= "60" && $total_score <= "69"){
	  $grade = 'B';
	  }
	  if($total_score >= "50" && $total_score <= "59"){
	  $grade = 'C';
	  }
	  if($total_score >= "45" && $total_score <= "49"){
	  $grade = 'D';
	  }
	  if($total_score >= "40" && $total_score <= "44"){
	  $grade = 'E';
	  }
	  if($total_score >= "0" && $total_score <= "39"){
	  $grade = 'F';
	  }

	return $grade;
}	//end of get student grade by scores



//GetColour code for grade by passing grade
function get_grade_color($grade)
{
	if($grade == 'A'){
	  $color = "text-success";
	  }
	if($grade == 'B'){
	  $color = "text-primary";
	  }
	if($grade == 'C'){
	  $color = "text-info";
	  }
	if($grade == 'D'){
	  $color = "text-warning";
	  }
	if($grade == 'E'){
	  $color = "text-default";
	  }
	if($grade == 'F'){
	  $color = "text-danger";
	  }

	return $color;
}



//GetColour code for current get grade point score
function get_student_grade_point_score($total_score)
{
	//$total_score = $ca_score + $exam_score;


	if($total_score >= 70){
	  $gp = 5;
	  }
	if($total_score >= 60 && $total_score <= 69){
	  $gp = 4;
	  }
	  if($total_score >= 50 && $total_score <= 59){
	  $gp = 3;
	  }
	  if($total_score >= 45 && $total_score <= 49){
	  $gp = 2;
	  }
	  if($total_score >= 40 && $total_score <= 44){
	  $gp = 1;
	  }
	  if($total_score >= 0 && $total_score <= 39){
	  $gp = 0;
	  }

	return $gp;
}	//end of get student gp by scores


//function tha gen delete token for delete
function result_entry_token()
{
		for($i=0;$i<=20;$i++){
			$key .=mt_rand(0,9);
		}
		return $key.time();
}


//function dat get student full name id
function get_student_fullname($user_id)
{
	$q = "SELECT first_name, other_names FROM students_nce WHERE id = '$user_id' ";
	$r = mysqli_query(dbc(),$q);
	$row = mysqli_fetch_assoc($r);

	return $row['first_name'].' '.$row['other_names'];


}



//function dat get student full name id
function get_student_fullname_nce($user_id)
{
	$q = "SELECT first_name, other_names FROM students_nce WHERE id = '$user_id' ";
	$r = mysqli_query(dbc(),$q);
	$row = mysqli_fetch_assoc($r);

	return $row['first_name'].' '.$row['other_names'];


}


//function dat get student full name id for prence
function get_student_fullname_prence($user_id)
{
	$q = "SELECT first_name, other_names FROM students_prence WHERE id = '$user_id' ";
	$r = mysqli_query(dbc(),$q);
	$row = mysqli_fetch_assoc($r);

	return $row['first_name'].' '.$row['other_names'];

}


//function dat get student full name id for summer
function get_student_fullname_summer($user_id)
{
	$q = "SELECT first_name, other_names FROM summer_students WHERE id = '$user_id' ";
	$r = mysqli_query(dbc(),$q);
	$row = mysqli_fetch_assoc($r);

	return $row['first_name'].' '.$row['other_names'];


}

//function dat get student gender
function get_student_gender($user_id)
{
	$q = "SELECT gender FROM students_nce WHERE id = '$user_id' ";
	$r = mysqli_query(dbc(),$q);
	$row = mysqli_fetch_assoc($r);

	return $row['gender'];


}


//function dat get student gender
function get_student_gender_prence($user_id)
{
	$q = "SELECT gender FROM students_prence WHERE id = '$user_id' ";
	$r = mysqli_query(dbc(),$q);
	$row = mysqli_fetch_assoc($r);

	return $row['gender'];


}


//function dat get student gender summer
function get_student_gender_summer($user_id)
{
	$q = "SELECT gender FROM students_summer WHERE id = '$user_id' ";
	$r = mysqli_query(dbc(),$q);
	$row = @mysqli_fetch_assoc($r);

	return $row['gender'];


}


//function that flip gender
function shorten_gender($gender)
{

	//flip gender and shorten it
	if($gender == 'Male')
	{
		$gender = 'M';

	}
	else if ($gender == 'Female')
	{
		$gender = 'F';

	}
	else
	{
		$gender = 'NIL';
	}

	return $gender;

}



//function dat get student department id
function get_student_department_id_nce($user_id)
{
	$q = "SELECT department_id FROM students_nce WHERE id = '$user_id' ";
	$r = mysqli_query(dbc(),$q);
	$row = mysqli_fetch_assoc($r);

	return $row['department_id'];


}


//function dat get student madepartment id
function get_student_department_id_prence($user_id)
{
	$q = "SELECT department_id FROM students_prence WHERE id = '$user_id' ";
	$r = mysqli_query(dbc(),$q);
	$row = mysqli_fetch_assoc($r);

	return $row['department_id'];


}


//function dat get student school id
function get_student_school_id_nce($user_id)
{
	$q = "SELECT school_id FROM students_nce WHERE id = '$user_id' ";
	$r = mysqli_query(dbc(),$q);
	$row = mysqli_fetch_assoc($r);

	return $row['school_id'];


}


//function dat get student school id
function get_student_school_id_prence($user_id)
{
	$q = "SELECT school_id FROM students_prence WHERE id = '$user_id' ";
	$r = mysqli_query(dbc(),$q);
	$row = mysqli_fetch_assoc($r);

	return $row['school_id'];


}



//function dat get student programme id
function get_student_programme_id_nce($user_id)
{
	$q = "SELECT programme_id FROM students_nce WHERE id = '$user_id' ";
	$r = mysqli_query(dbc(),$q);
	$row = mysqli_fetch_assoc($r);

	return $row['programme_id'];


}

//function dat get student programme id
function get_student_programme_id_prence($user_id)
{
	$q = "SELECT programme_id FROM students_prence WHERE id = '$user_id' ";
	$r = mysqli_query(dbc(),$q);
	$row = mysqli_fetch_assoc($r);

	return $row['programme_id'];


}


//function dat get student level
function get_student_level_nce($user_id)
{
	$q = "SELECT level FROM students_nce WHERE id = '$user_id' ";
	$r = mysqli_query(dbc(),$q);
	$row = mysqli_fetch_assoc($r);

	return $row['level'];


}


//function dat get student matric number
function get_student_matric_no_nce($user_id)
{
	$q = "SELECT number FROM students_nce WHERE id = '$user_id' ";
	$r = mysqli_query(dbc(),$q);
	$row = mysqli_fetch_assoc($r);

	return $row['number'];


}

//function dat get student matric number
function get_student_matric_no_prence($user_id)
{
	$q = "SELECT number FROM students_prence WHERE id = '$user_id' ";
	$r = mysqli_query(dbc(),$q);
	$row = mysqli_fetch_assoc($r);

	return $row['number'];


}


//start working for education course
//get total credit unit registered for  courses
function get_total_credit_unit_registered_nce($user_id,$programme_id,$course_category,$level,$session,$semester)
{

		//plaay with course category
		if($course_category == 1 OR $course_category == 2)//gst or education
		{
			$q = "SELECT SUM(course_unit)
			   FROM students_courses_nce  WHERE student_id = '$user_id' AND course_category = '$course_category' AND level = '$level' AND session_id = '$session' AND semester = '$semester' ";
			$r = mysqli_query(dbc(),$q);
			$row2 = mysqli_fetch_array($r);


			return  $row2[0];

		}
		else
		{
			//declare an array
		   $debt_comb_array =array();

			//get department comb of programme combination
		    $debt_comb = get_department_comb_using_programme_id($programme_id);


		    //$countstring = strlen($debt_comb);
			//
			//check if string is greater 1
			//
			if(strpos($debt_comb, ',') !== false )
			{

				for ($i = 0; $i < count($debt_comb);$i++)
				{
					 $debt_comb_array = explode(',', $debt_comb);


				}

			 	 $first_debt = $debt_comb_array[0];

				 $second_debt = $debt_comb_array[1];
				//pass out an array
				$qx = "SELECT SUM(course_unit)
			   FROM students_courses_nce  WHERE student_id = '$user_id' AND course_category = '$course_category' AND level = '$level' AND session_id = '$session' AND semester = '$semester' AND course_department_id = '$first_debt' ";
				$rx = mysqli_query(dbc(),$qx);
				$rowx = mysqli_fetch_array($rx);


				$qy = "SELECT SUM(course_unit)
			   FROM students_courses_nce  WHERE student_id = '$user_id' AND course_category = '$course_category' AND level = '$level' AND session_id = '$session' AND semester = '$semester' AND course_department_id = '$second_debt'";
				$ry = mysqli_query(dbc(),$qy);
				$rowy = mysqli_fetch_array($ry);


			    $return_value = $rowx[0].','.$rowy[0];
				return $return_value;


			}
			else
			{
				$qz = "SELECT SUM(course_unit)
			   FROM students_courses_nce  WHERE student_id = '$user_id' AND course_category = '$course_category' AND level = '$level' AND session_id = '$session' AND semester = '$semester'";//AND course_department_id = '$debt_comb'
				$rz = mysqli_query(dbc(),$qz);
				$rowz = mysqli_fetch_array($rz);

				return $rowz[0];

			}
			//




		}//end of if category is 0




}//end of if function is


//start working for education course for prence
//get total credit unit registered for  courses
function get_total_credit_unit_registered_prence($user_id,$programme_id,$course_category,$level,$session,$semester)
{

		//plaay with course category
		if($course_category == 1 OR $course_category == 2)//gst or education
		{
			$q = "SELECT SUM(course_unit)
			   FROM students_courses_prence  WHERE student_id = '$user_id' AND course_category = '$course_category' AND level = '$level' AND session_id = '$session' AND semester = '$semester' ";
			$r = mysqli_query(dbc(),$q);
			$row2 = mysqli_fetch_array($r);


			return  $row2[0];

		}
		else
		{
			//declare an array
		   $debt_comb_array =array();

			//get department comb of programme combination
		    $debt_comb = get_department_comb_using_programme_id($programme_id);


		    //$countstring = strlen($debt_comb);
			//
			//check if string is greater 1
			//
			if(strpos($debt_comb, ',') !== false )
			{

				for ($i = 0; $i < count($debt_comb);$i++)
				{
					 $debt_comb_array = explode(',', $debt_comb);


				}

			 	 $first_debt = $debt_comb_array[0];

				 $second_debt = $debt_comb_array[1];
				//pass out an array
				$qx = "SELECT SUM(course_unit)
			   FROM students_courses_prence  WHERE student_id = '$user_id' AND course_category = '$course_category' AND level = '$level' AND session_id = '$session' AND semester = '$semester' AND course_department_id = '$first_debt' ";
				$rx = mysqli_query(dbc(),$qx);
				$rowx = mysqli_fetch_array($rx);


				$qy = "SELECT SUM(course_unit)
			   FROM students_courses_prence  WHERE student_id = '$user_id' AND course_category = '$course_category' AND level = '$level' AND session_id = '$session' AND semester = '$semester' AND course_department_id = '$second_debt'";
				$ry = mysqli_query(dbc(),$qy);
				$rowy = mysqli_fetch_array($ry);


			    $return_value = $rowx[0].','.$rowy[0];
				return $return_value;


			}
			else
			{
				$qz = "SELECT SUM(course_unit)
			   FROM students_courses_prence  WHERE student_id = '$user_id' AND course_category = '$course_category' AND level = '$level' AND session_id = '$session' AND semester = '$semester' AND course_department_id = '$debt_comb' ";
				$rz = mysqli_query(dbc(),$qz);
				$rowz = mysqli_fetch_array($rz);

				return $rowz[0];

			}
			//




		}//end of if category is 0




}//end of if function is prence





//get total credit unit registered for  courses previously
function get_total_credit_unit_registered_previously_nce($user_id,$programme_id,$course_category,$level,$session,$semester)
{

		    //In the later version this has to be updated by level
		    if($level == 'I' AND $semester == '1')
		    {

					return 0;



				}//en dof if level I and semester is second
				else if ($level == 'I' AND $semester == '2')
				{

					//plaay with course category
					if($course_category == 1 OR $course_category == 2)//gst or education
					{
						$q = "SELECT SUM(course_unit)
							 FROM students_courses_nce  WHERE student_id = $user_id AND course_category = $course_category  AND semester = 1 AND session_id = $session";
						$r = mysqli_query(dbc(),$q);
						$row2 = mysqli_fetch_array($r);


						return  $row2[0];

					}
					else
					{
						//declare an array
						 $debt_comb_array =array();

						//get department comb of programme combination
							$debt_comb = get_department_comb_using_programme_id($programme_id);


							//$countstring = strlen($debt_comb);
						//
						//check if string is greater 1
						//
						if(strpos($debt_comb, ',') !== false )
						{

							for ($i = 0; $i < count($debt_comb);$i++)
							{
								 $debt_comb_array = explode(',', $debt_comb);


							}

							 $first_debt = $debt_comb_array[0];

							 $second_debt = $debt_comb_array[1];
							//pass out an array
							$qx = "SELECT SUM(course_unit)
							 FROM students_courses_nce  WHERE student_id = '$user_id' AND course_category = '$course_category' AND  semester = 1  AND course_department_id = '$first_debt' AND session_id = $session";
							$rx = mysqli_query(dbc(),$qx);
							$rowx = mysqli_fetch_array($rx);


							$qy = "SELECT SUM(course_unit)
							 FROM students_courses_nce  WHERE student_id = '$user_id' AND course_category = '$course_category'  AND  semester = 1  AND course_department_id = '$second_debt' AND session_id = $session";
							$ry = mysqli_query(dbc(),$qy);
							$rowy = mysqli_fetch_array($ry);


							$return_value = $rowx[0].','.$rowy[0];

							return $return_value;


						}
						else
						{
							$qz = "SELECT SUM(course_unit)
							 FROM students_courses_nce  WHERE student_id = '$user_id' AND course_category = '$course_category' AND semester = 1  AND course_department_id = '$debt_comb' AND session_id = $session";
							$rz = mysqli_query(dbc(),$qz);
							$rowz = mysqli_fetch_array($rz);

							return $rowz[0];

						}
						//
						//



				 }//end of if else category is 0


			 }//end of if semester is 2 and level I
			 else if($level == 'II' AND $semester == '1')
			 {
				 //plaay with course category 0 conventional ,1 -gst , 2 - edu
				 if($course_category == 1)//gst or education
				 {


					 		//query to get gst prvious from last semester
							$r = mysqli_query(dbc(),"SELECT gst_tcur FROM students_results_nce WHERE session_id = ($session - 1)  AND student_id = $user_id AND semester = 2");
			 				$row = mysqli_fetch_assoc($r);
			 				$row2 = $row['gst_tcur'];

			 				return  $row2;

				 }
				 else if ($course_category == 2)
				 {

							$r = mysqli_query(dbc(),"SELECT edu_tcur FROM students_results_nce WHERE session_id = ($session - 1)  AND student_id = $user_id AND semester = 2");
			 				$row = mysqli_fetch_assoc($r);
			 				$row2 = $row['edu_tcur'];

			 				return  $row2;

				 }
				 else
				 {
					  //declare an array
				 		$debt_comb_array =array();

				 	 //get department comb of programme combination
				 		 $debt_comb = get_department_comb_using_programme_id($programme_id);


				 		 //$countstring = strlen($debt_comb);
					 //
					 //check if string is greater 1
					 //if department combination is more than 1 and else is just only one department which stands only for core
					 if(strpos($debt_comb, ',') !== false )
					 {

						 for ($i = 0; $i < count($debt_comb);$i++)
						 {
								$debt_comb_array = explode(',', $debt_comb);


						 }

							$first_debt = $debt_comb_array[0];

							$second_debt = $debt_comb_array[1];
						 //pass out an array
						 // $qx = "SELECT SUM(course_unit)
							// FROM students_courses_nce  WHERE student_id = '$user_id' AND course_category = '$course_category' AND  semester = 2  AND course_department_id = '$first_debt' AND session_id = ($session - 1)";
						 // $rx = mysqli_query(dbc(),$qx);
						 // $rowx = mysqli_fetch_array($rx);

						 $rx = mysqli_query(dbc(),"SELECT core1_tcur FROM students_results_nce WHERE session_id = ($session - 1)  AND student_id = $user_id AND semester = 2");
						 $rowx = mysqli_fetch_assoc($rx);
						 $row2x = $rowx['core1_tcur'];


						 $ry = mysqli_query(dbc(),"SELECT core2_tcur FROM students_results_nce WHERE session_id = ($session - 1)  AND student_id = $user_id AND semester = 2");
						 $rowy = mysqli_fetch_assoc($ry);
						 $row2y = $rowy['core2_tcur'];



						 // $qy = "SELECT SUM(course_unit)
							// FROM students_courses_nce  WHERE student_id = '$user_id' AND course_category = '$course_category'  AND  semester = 2  AND course_department_id = '$second_debt' AND session_id = ($session -1)";
						 // $ry = mysqli_query(dbc(),$qy);
						 // $rowy = mysqli_fetch_array($ry);


						 $return_value = $row2x.','.$row2y;

						 return $return_value;


					 }
					 else
					 {



						 $rz = mysqli_query(dbc(),"SELECT core1_tcur FROM students_results_nce WHERE session_id = ($session - 1)  AND student_id = $user_id AND semester = 2");
						 $rowz = mysqli_fetch_assoc($rz);
						 $row2z = $rowz['core1_tcur'];

						 return  $row2z;

					 }
					 //
					 //



				}//end of if else category is 0




			}//end of else of level = II is semseter 1
			else if($level == 'II' AND $semester == '2')
			{
				//plaay with course category


				//plaay with course category 0 conventional ,1 -gst , 2 - edu
				if($course_category == 1)//gst or education
				{


						 //query to get gst prvious from last semester
						 $r = mysqli_query(dbc(),"SELECT gst_tcur FROM students_results_nce WHERE session_id = $session  AND student_id = $user_id AND semester = 1");
						 $row = mysqli_fetch_assoc($r);
						 $row2 = $row['gst_tcur'];

						 return  $row2;

				}
				else if ($course_category == 2)
				{

						 $r = mysqli_query(dbc(),"SELECT edu_tcur FROM students_results_nce WHERE session_id = $session  AND student_id = $user_id AND semester = 1");
						 $row = mysqli_fetch_assoc($r);
						 $row2 = $row['edu_tcur'];

						 return  $row2;

				}
				else
				{
					 //declare an array
					 $debt_comb_array =array();

					//get department comb of programme combination
						$debt_comb = get_department_comb_using_programme_id($programme_id);


						//$countstring = strlen($debt_comb);
					//
					//check if string is greater 1
					//if department combination is more than 1 and else is just only one department which stands only for core
					if(strpos($debt_comb, ',') !== false )
					{

						for ($i = 0; $i < count($debt_comb);$i++)
						{
							 $debt_comb_array = explode(',', $debt_comb);


						}

						 $first_debt = $debt_comb_array[0];

						 $second_debt = $debt_comb_array[1];
						//pass out an array

						$rx = mysqli_query(dbc(),"SELECT core1_tcur FROM students_results_nce WHERE session_id = $session  AND student_id = $user_id AND semester = 1");
						$rowx = mysqli_fetch_assoc($rx);
						$row2x = $rowx['core1_tcur'];


						$ry = mysqli_query(dbc(),"SELECT core2_tcur FROM students_results_nce WHERE session_id = $session  AND student_id = $user_id AND semester = 1");
						$rowy = mysqli_fetch_assoc($ry);
						$row2y = $rowy['core2_tcur'];



						$return_value = $row2x.','.$row2y;

						return $return_value;


					}
					else
					{
						$rz = mysqli_query(dbc(),"SELECT core1_tcur FROM students_results_nce WHERE session_id = $session  AND student_id = $user_id AND semester = 1");
						$rowz = mysqli_fetch_assoc($rz);
						$row2z = $rowz['core1_tcur'];

						return  $row2z;

					}
					//
					//

				}//end of if else category is 0





			}//end of else o fi flevle is II and semester is 2
			else if($level == 'III' AND $semester == '1')
			{
				//plaay with course category 0 conventional ,1 -gst , 2 - edu
				if($course_category == 1)//gst or education
				{


						 //query to get gst prvious from last semester
						 $r = mysqli_query(dbc(),"SELECT gst_tcur FROM students_results_nce WHERE session_id = ($session - 1)  AND student_id = $user_id AND semester = 2");
						 $row = mysqli_fetch_assoc($r);
						 $row2 = $row['gst_tcur'];

						 return  $row2;

				}
				else if ($course_category == 2)
				{

						 $r = mysqli_query(dbc(),"SELECT edu_tcur FROM students_results_nce WHERE session_id = ($session - 1)  AND student_id = $user_id AND semester = 2");
						 $row = mysqli_fetch_assoc($r);
						 $row2 = $row['edu_tcur'];

						 return  $row2;

				}
				else
				{
					 //declare an array
					 $debt_comb_array =array();

					//get department comb of programme combination
						$debt_comb = get_department_comb_using_programme_id($programme_id);


						//$countstring = strlen($debt_comb);
					//
					//check if string is greater 1
					//if department combination is more than 1 and else is just only one department which stands only for core
					if(strpos($debt_comb, ',') !== false )
					{

						for ($i = 0; $i < count($debt_comb);$i++)
						{
							 $debt_comb_array = explode(',', $debt_comb);


						}

						 $first_debt = $debt_comb_array[0];

						 $second_debt = $debt_comb_array[1];
						//pass out an array
						// $qx = "SELECT SUM(course_unit)
						 // FROM students_courses_nce  WHERE student_id = '$user_id' AND course_category = '$course_category' AND  semester = 2  AND course_department_id = '$first_debt' AND session_id = ($session - 1)";
						// $rx = mysqli_query(dbc(),$qx);
						// $rowx = mysqli_fetch_array($rx);

						$rx = mysqli_query(dbc(),"SELECT core1_tcur FROM students_results_nce WHERE session_id = ($session - 1)  AND student_id = $user_id AND semester = 2");
						$rowx = mysqli_fetch_assoc($rx);
						$row2x = $rowx['core1_tcur'];


						$ry = mysqli_query(dbc(),"SELECT core2_tcur FROM students_results_nce WHERE session_id = ($session - 1)  AND student_id = $user_id AND semester = 2");
						$rowy = mysqli_fetch_assoc($ry);
						$row2y = $rowy['core2_tcur'];



						// $qy = "SELECT SUM(course_unit)
						 // FROM students_courses_nce  WHERE student_id = '$user_id' AND course_category = '$course_category'  AND  semester = 2  AND course_department_id = '$second_debt' AND session_id = ($session -1)";
						// $ry = mysqli_query(dbc(),$qy);
						// $rowy = mysqli_fetch_array($ry);


						$return_value = $row2x.','.$row2y;

						return $return_value;


					}
					else
					{



						$rz = mysqli_query(dbc(),"SELECT core1_tcur FROM students_results_nce WHERE session_id = ($session - 1)  AND student_id = $user_id AND semester = 2");
						$rowz = mysqli_fetch_assoc($rz);
						$row2z = $rowz['core1_tcur'];

						return  $row2z;

					}
					//
					//



			 }//end of if else category is 0




		 }//end of else of level = III is semseter 1
		 else if($level == 'III' AND $semester == '2')
		 {
			 //plaay with course category


			 //plaay with course category 0 conventional ,1 -gst , 2 - edu
			 if($course_category == 1)//gst or education
			 {


						//query to get gst prvious from last semester
						$r = mysqli_query(dbc(),"SELECT gst_tcur FROM students_results_nce WHERE session_id = $session  AND student_id = $user_id AND semester = 1");
						$row = mysqli_fetch_assoc($r);
						$row2 = $row['gst_tcur'];

						return  $row2;

			 }
			 else if ($course_category == 2)
			 {

						$r = mysqli_query(dbc(),"SELECT edu_tcur FROM students_results_nce WHERE session_id = $session  AND student_id = $user_id AND semester = 1");
						$row = mysqli_fetch_assoc($r);
						$row2 = $row['edu_tcur'];

						return  $row2;

			 }
			 else
			 {
					//declare an array
					$debt_comb_array =array();

				 //get department comb of programme combination
					 $debt_comb = get_department_comb_using_programme_id($programme_id);


					 //$countstring = strlen($debt_comb);
				 //
				 //check if string is greater 1
				 //if department combination is more than 1 and else is just only one department which stands only for core
				 if(strpos($debt_comb, ',') !== false )
				 {

					 for ($i = 0; $i < count($debt_comb);$i++)
					 {
							$debt_comb_array = explode(',', $debt_comb);


					 }

						$first_debt = $debt_comb_array[0];

						$second_debt = $debt_comb_array[1];
					 //pass out an array

					 $rx = mysqli_query(dbc(),"SELECT core1_tcur FROM students_results_nce WHERE session_id = $session  AND student_id = $user_id AND semester = 1");
					 $rowx = mysqli_fetch_assoc($rx);
					 $row2x = $rowx['core1_tcur'];


					 $ry = mysqli_query(dbc(),"SELECT core2_tcur FROM students_results_nce WHERE session_id = $session  AND student_id = $user_id AND semester = 1");
					 $rowy = mysqli_fetch_assoc($ry);
					 $row2y = $rowy['core2_tcur'];



					 $return_value = $row2x.','.$row2y;

					 return $return_value;


				 }
				 else
				 {
					 $rz = mysqli_query(dbc(),"SELECT core1_tcur FROM students_results_nce WHERE session_id = $session  AND student_id = $user_id AND semester = 1");
					 $rowz = mysqli_fetch_assoc($rz);
					 $row2z = $rowz['core1_tcur'];

					 return  $row2z;

				 }
				 //
				 //

			 }//end of if else category is 0





		 }//end of else o fi flevle is III and semester is 2




}//end of if function is  previous tottal credit unit registered



//get total credit unit registered for  courses previously prence
function get_total_credit_unit_registered_previously_prence($user_id,$programme_id,$course_category,$level,$session,$semester)
{

		    //In the later version this has to be updated by level
		    if($level == 'PRE' AND $semester == '1')
		    {

					return 0;



				}//en dof if level I and semester is second
				else if ($level == 'PRE' AND $semester == '2')
				{

					//plaay with course category
					if($course_category == 1 OR $course_category == 2)//gst or education
					{
						$q = "SELECT SUM(course_unit)
							 FROM students_courses_prence  WHERE student_id = $user_id AND course_category = $course_category  AND semester = 1 AND session_id = $session";
						$r = mysqli_query(dbc(),$q);
						$row2 = mysqli_fetch_array($r);


						return  $row2[0];

					}
					else
					{
						//declare an array
						 $debt_comb_array =array();

						//get department comb of programme combination
							$debt_comb = get_department_comb_using_programme_id($programme_id);


							//$countstring = strlen($debt_comb);
						//
						//check if string is greater 1
						//
						if(strpos($debt_comb, ',') !== false )
						{

							for ($i = 0; $i < count($debt_comb);$i++)
							{
								 $debt_comb_array = explode(',', $debt_comb);


							}

							 $first_debt = $debt_comb_array[0];

							 $second_debt = $debt_comb_array[1];
							//pass out an array
							$qx = "SELECT SUM(course_unit)
							 FROM students_courses_prence  WHERE student_id = '$user_id' AND course_category = '$course_category' AND  semester = 1  AND course_department_id = '$first_debt' AND session_id = $session";
							$rx = mysqli_query(dbc(),$qx);
							$rowx = mysqli_fetch_array($rx);


							$qy = "SELECT SUM(course_unit)
							 FROM students_courses_prence  WHERE student_id = '$user_id' AND course_category = '$course_category'  AND  semester = 1  AND course_department_id = '$second_debt' AND session_id = $session";
							$ry = mysqli_query(dbc(),$qy);
							$rowy = mysqli_fetch_array($ry);


							$return_value = $rowx[0].','.$rowy[0];

							return $return_value;


						}
						else
						{
							$qz = "SELECT SUM(course_unit)
							 FROM students_courses_prence  WHERE student_id = '$user_id' AND course_category = '$course_category' AND semester = 1  AND course_department_id = '$debt_comb' AND session_id = $session";
							$rz = mysqli_query(dbc(),$qz);
							$rowz = mysqli_fetch_array($rz);

							return $rowz[0];

						}
						//
						//



				 }//end of if else category is 0


			 }//end of if semester is 2 and level PRENCE



}//end of if function is  previous tottal credit unit registered prence


//get total credit unit earned from courses
function get_total_credit_unit_earned_nce($user_id,$programme_id,$course_category,$level,$session,$semester)
{

		//plaay with course category
		if($course_category == 1 OR $course_category == 2)//gst or education
		{
			$q = "SELECT SUM(course_unit)
			   FROM students_courses_nce  WHERE student_id = '$user_id' AND course_category = '$course_category' AND level = '$level' AND session_id = '$session' AND semester = '$semester' AND total_score > 39";
			$r = mysqli_query(dbc(),$q);
			$row2 = mysqli_fetch_array($r);


			return  $row2[0];

		}
		else
		{
			//declare an array
		   $debt_comb_array =array();

			//get department comb of programme combination
		    $debt_comb = get_department_comb_using_programme_id($programme_id);


		    //$countstring = strlen($debt_comb);
			//
			//check if string is greater 1
			//
			if(strpos($debt_comb, ',') !== false )
			{

				for ($i = 0; $i < count($debt_comb);$i++)
				{
					 $debt_comb_array = explode(',', $debt_comb);


				}

			 	 $first_debt = $debt_comb_array[0];

				 $second_debt = $debt_comb_array[1];
				//pass out an array
				$qx = "SELECT SUM(course_unit)
			   FROM students_courses_nce  WHERE student_id = '$user_id' AND course_category = '$course_category' AND level = '$level' AND session_id = '$session' AND semester = '$semester' AND course_department_id = '$first_debt'  AND total_score > 39 ";
				$rx = mysqli_query(dbc(),$qx);
				$rowx = mysqli_fetch_array($rx);


				$qy = "SELECT SUM(course_unit)
			   FROM students_courses_nce  WHERE student_id = '$user_id' AND course_category = '$course_category' AND level = '$level' AND session_id = '$session' AND semester = '$semester' AND course_department_id = '$second_debt'
			    AND total_score > 39";
				$ry = mysqli_query(dbc(),$qy);
				$rowy = mysqli_fetch_array($ry);


			    $return_value = $rowx[0].','.$rowy[0];
				return $return_value;


			}
			else
			{
				$qz = "SELECT SUM(course_unit)
			   FROM students_courses_nce  WHERE student_id = '$user_id' AND course_category = '$course_category' AND level = '$level' AND session_id = '$session' AND semester = '$semester'
			    AND total_score > 39"; // AND course_department_id = '$debt_comb'
				$rz = mysqli_query(dbc(),$qz);
				$rowz = mysqli_fetch_array($rz);

				return $rowz[0];

			}
			//




		}//end of if category is 0




}//get total credit unit eanred from courses present



//get total credit unit earned from courses for prence
function get_total_credit_unit_earned_prence($user_id,$programme_id,$course_category,$level,$session,$semester)
{

		//plaay with course category
		if($course_category == 1 OR $course_category == 2)//gst or education
		{
			$q = "SELECT SUM(course_unit)
			   FROM students_courses_prence  WHERE student_id = '$user_id' AND course_category = '$course_category' AND level = '$level' AND session_id = '$session' AND semester = '$semester' AND total_score > 39";
			$r = mysqli_query(dbc(),$q);
			$row2 = mysqli_fetch_array($r);


			return  $row2[0];

		}
		else
		{
			//declare an array
		   $debt_comb_array =array();

			//get department comb of programme combination
		    $debt_comb = get_department_comb_using_programme_id($programme_id);


		    //$countstring = strlen($debt_comb);
			//
			//check if string is greater 1
			//
			if(strpos($debt_comb, ',') !== false )
			{

				for ($i = 0; $i < count($debt_comb);$i++)
				{
					 $debt_comb_array = explode(',', $debt_comb);


				}

			 	 $first_debt = $debt_comb_array[0];

				 $second_debt = $debt_comb_array[1];
				//pass out an array
				$qx = "SELECT SUM(course_unit)
			   FROM students_courses_prence  WHERE student_id = '$user_id' AND course_category = '$course_category' AND level = '$level' AND session_id = '$session' AND semester = '$semester' AND course_department_id = '$first_debt'  AND total_score > 39 ";
				$rx = mysqli_query(dbc(),$qx);
				$rowx = mysqli_fetch_array($rx);


				$qy = "SELECT SUM(course_unit)
			   FROM students_courses_prence  WHERE student_id = '$user_id' AND course_category = '$course_category' AND level = '$level' AND session_id = '$session' AND semester = '$semester' AND course_department_id = '$second_debt'
			    AND total_score > 39";
				$ry = mysqli_query(dbc(),$qy);
				$rowy = mysqli_fetch_array($ry);


			    $return_value = $rowx[0].','.$rowy[0];
				return $return_value;


			}
			else
			{
				$qz = "SELECT SUM(course_unit)
			   FROM students_courses_prence  WHERE student_id = '$user_id' AND course_category = '$course_category' AND level = '$level' AND session_id = '$session' AND semester = '$semester' AND course_department_id = '$debt_comb'
			    AND total_score > 39";
				$rz = mysqli_query(dbc(),$qz);
				$rowz = mysqli_fetch_array($rz);

				return $rowz[0];

			}
			//




		}//end of if category is 0




}//get total credit unit eanred from courses present prence

//get total credit unit earned from courses previou semster
function get_total_credit_unit_earned_previously_nce($user_id,$programme_id,$course_category,$level,$session,$semester)
{



	//In the later version this has to be updated by level
			if($level == 'I' AND $semester == '1')
			{
				return 0;

			}//end of if level is I and semester 1
	    else if($level == 'I' AND $semester == '2')
	    {

				//0 - conventional courses, 1 - gst courses and 2 is edu courses

				//plaay with course category
				if($course_category == 1 OR $course_category == 2 )//gst or education
				{
					$q = "SELECT SUM(course_unit)
					   FROM students_courses_nce  WHERE student_id = '$user_id' AND course_category = '$course_category'   AND semester = 1 AND session_id = $session AND total_score > 39 ";
					$r = mysqli_query(dbc(),$q);
					$row2 = mysqli_fetch_array($r);


					return  $row2[0];


				}
				else
				{
					//declare an array
				   $debt_comb_array =array();

					//get department comb of programme combination
				    $debt_comb = get_department_comb_using_programme_id($programme_id);


				    //$countstring = strlen($debt_comb);
					//
					//check if string is greater 1
					//
					if(strpos($debt_comb, ',') !== false )
					{

						for ($i = 0; $i < count($debt_comb);$i++)
						{
							 $debt_comb_array = explode(',', $debt_comb);


						}

					 	 $first_debt = $debt_comb_array[0];

						 $second_debt = $debt_comb_array[1];
						//pass out an array
						$qx = "SELECT SUM(course_unit)
					   FROM students_courses_nce  WHERE student_id = '$user_id' AND course_category = '$course_category'   AND semester = 1 AND session_id = $session AND course_department_id = '$first_debt'  AND total_score > 39 ";
						$rx = mysqli_query(dbc(),$qx);
						$rowx = mysqli_fetch_array($rx);


						$qy = "SELECT SUM(course_unit)
					   FROM students_courses_nce  WHERE student_id = '$user_id' AND course_category = '$course_category'   AND semester = 1 AND session_id = $session AND course_department_id = '$second_debt'  AND total_score > 39";
						$ry = mysqli_query(dbc(),$qy);
						$rowy = mysqli_fetch_array($ry);


					    $return_value = $rowx[0].','.$rowy[0];
						return $return_value;


					}
					else
					{
						$qz = "SELECT SUM(course_unit)
					   FROM students_courses_nce  WHERE student_id = '$user_id' AND course_category = '$course_category'   AND semester = 1 AND session_id = $session AND course_department_id = '$debt_comb'
					    AND total_score > 39";
						$rz = mysqli_query(dbc(),$qz);
						$rowz = mysqli_fetch_array($rz);

						return $rowz[0];

					}
					//




				}//end of if category is 0

			}
			else if($level == 'II' AND $semester == '1')
			{
				if($course_category == 1)//gst or education
				{

//gst 1  and edu 2 0 conve
					//query to get gst prvious from last semester
					$r = mysqli_query(dbc(),"SELECT gst_tcue FROM students_results_nce WHERE session_id = ($session - 1)  AND student_id = $user_id AND semester = 2");
					$row = mysqli_fetch_assoc($r);
					$row2 = $row['gst_tcue'];

					return  $row2;

				}
				else if ($course_category == 2)
				{

					//query to get gst prvious from last semester
					$r = mysqli_query(dbc(),"SELECT edu_tcue FROM students_results_nce WHERE session_id = ($session - 1)  AND student_id = $user_id AND semester = 2");
					$row = mysqli_fetch_assoc($r);
					$row2 = $row['edu_tcue'];

					return  $row2;

				}
				else
				{
					//declare an array
				   $debt_comb_array =array();

					//get department comb of programme combination
				    $debt_comb = get_department_comb_using_programme_id($programme_id);


				    //$countstring = strlen($debt_comb);
					//
					//check if string is greater 1
					//
					if(strpos($debt_comb, ',') !== false )
					{

						for ($i = 0; $i < count($debt_comb);$i++)
						{
							 $debt_comb_array = explode(',', $debt_comb);


						}

					 	 $first_debt = $debt_comb_array[0];

						 $second_debt = $debt_comb_array[1];
						//pass out an array

						$rx = mysqli_query(dbc(),"SELECT core1_tcue FROM students_results_nce WHERE session_id = ($session -1)  AND student_id = $user_id AND semester = 2");
						$rowx = mysqli_fetch_assoc($rx);
						$row2x = $rowx['core1_tcue'];


						$ry = mysqli_query(dbc(),"SELECT core2_tcue FROM students_results_nce WHERE session_id = ($session -1)  AND student_id = $user_id AND semester = 2");
						$rowy = mysqli_fetch_assoc($ry);
						$row2y = $rowy['core2_tcue'];


					  $return_value = $row2x.','.$row2y;
						return $return_value;


					}
					else
					{

						$rz = mysqli_query(dbc(),"SELECT core1_tcue FROM students_results_nce WHERE session_id = ($session -1)  AND student_id = $user_id AND semester = 2");
						$rowz = mysqli_fetch_assoc($rz);
						$row2z = $rowz['core1_tcue'];
						return $row2z;

					}
					//




				}//end of if category is 0


			}
			else if($level == 'II' AND $semester == '2')
			{
				if($course_category == 1)//gst or education
				{

//gst 1  and edu 2 0 conve
					//query to get gst prvious from last semester
					$r = mysqli_query(dbc(),"SELECT gst_tcue FROM students_results_nce WHERE session_id = $session  AND student_id = $user_id AND semester = 1");
					$row = mysqli_fetch_assoc($r);
					$row2 = $row['gst_tcue'];

					return  $row2;

				}
				else if ($course_category == 2)
				{

					//query to get gst prvious from last semester
					$r = mysqli_query(dbc(),"SELECT edu_tcue FROM students_results_nce WHERE session_id = $session  AND student_id = $user_id AND semester = 1");
					$row = mysqli_fetch_assoc($r);
					$row2 = $row['edu_tcue'];

					return  $row2;

				}
				else
				{
					//declare an array
				   $debt_comb_array =array();

					//get department comb of programme combination
				    $debt_comb = get_department_comb_using_programme_id($programme_id);


				    //$countstring = strlen($debt_comb);
					//
					//check if string is greater 1
					//
					if(strpos($debt_comb, ',') !== false )
					{

						for ($i = 0; $i < count($debt_comb);$i++)
						{
							 $debt_comb_array = explode(',', $debt_comb);


						}

					 	 $first_debt = $debt_comb_array[0];

						 $second_debt = $debt_comb_array[1];
						//pass out an array

						$rx = mysqli_query(dbc(),"SELECT core1_tcue FROM students_results_nce WHERE session_id = $session  AND student_id = $user_id AND semester = 1");
						$rowx = mysqli_fetch_assoc($rx);
						$row2x = $rowx['core1_tcue'];


						$ry = mysqli_query(dbc(),"SELECT core2_tcue FROM students_results_nce WHERE session_id = $session AND student_id = $user_id AND semester = 1");
						$rowy = mysqli_fetch_assoc($ry);
						$row2y = $rowy['core2_tcue'];


					  $return_value = $row2x.','.$row2y;
						return $return_value;


					}
					else
					{

						$rz = mysqli_query(dbc(),"SELECT core1_tcue FROM students_results_nce WHERE session_id = $session  AND student_id = $user_id AND semester = 1");
						$rowz = mysqli_fetch_assoc($rz);
						$row2z = $rowz['core1_tcue'];
						return $row2z;

					}
					//

				}//end of if category is 0


			}//end of level is II and semester is 2
			else if($level == 'III' AND $semester == '1')
			{
				if($course_category == 1)//gst or education
				{

//gst 1  and edu 2 0 conve
					//query to get gst prvious from last semester
					$r = mysqli_query(dbc(),"SELECT gst_tcue FROM students_results_nce WHERE session_id = ($session - 1)  AND student_id = $user_id AND semester = 2");
					$row = mysqli_fetch_assoc($r);
					$row2 = $row['gst_tcue'];

					return  $row2;

				}
				else if ($course_category == 2)
				{

					//query to get gst prvious from last semester
					$r = mysqli_query(dbc(),"SELECT edu_tcue FROM students_results_nce WHERE session_id = ($session - 1)  AND student_id = $user_id AND semester = 2");
					$row = mysqli_fetch_assoc($r);
					$row2 = $row['edu_tcue'];

					return  $row2;

				}
				else
				{
					//declare an array
				   $debt_comb_array =array();

					//get department comb of programme combination
				    $debt_comb = get_department_comb_using_programme_id($programme_id);


				    //$countstring = strlen($debt_comb);
					//
					//check if string is greater 1
					//
					if(strpos($debt_comb, ',') !== false )
					{

						for ($i = 0; $i < count($debt_comb);$i++)
						{
							 $debt_comb_array = explode(',', $debt_comb);


						}

					 	 $first_debt = $debt_comb_array[0];

						 $second_debt = $debt_comb_array[1];
						//pass out an array

						$rx = mysqli_query(dbc(),"SELECT core1_tcue FROM students_results_nce WHERE session_id = ($session -1)  AND student_id = $user_id AND semester = 2");
						$rowx = mysqli_fetch_assoc($rx);
						$row2x = $rowx['core1_tcue'];


						$ry = mysqli_query(dbc(),"SELECT core2_tcue FROM students_results_nce WHERE session_id = ($session -1)  AND student_id = $user_id AND semester = 2");
						$rowy = mysqli_fetch_assoc($ry);
						$row2y = $rowy['core2_tcue'];


					  $return_value = $row2x.','.$row2y;
						return $return_value;


					}
					else
					{

						$rz = mysqli_query(dbc(),"SELECT core1_tcue FROM students_results_nce WHERE session_id = ($session -1)  AND student_id = $user_id AND semester = 2");
						$rowz = mysqli_fetch_assoc($rz);
						$row2z = $rowz['core1_tcue'];
						return $row2z;

					}
					//




				}//end of if category is 0


			}
			else if($level == 'III' AND $semester == '2')
			{
				if($course_category == 1)//gst or education
				{

//gst 1  and edu 2 0 conve
					//query to get gst prvious from last semester
					$r = mysqli_query(dbc(),"SELECT gst_tcue FROM students_results_nce WHERE session_id = $session  AND student_id = $user_id AND semester = 1");
					$row = mysqli_fetch_assoc($r);
					$row2 = $row['gst_tcue'];

					return  $row2;

				}
				else if ($course_category == 2)
				{

					//query to get gst prvious from last semester
					$r = mysqli_query(dbc(),"SELECT edu_tcue FROM students_results_nce WHERE session_id = $session  AND student_id = $user_id AND semester = 1");
					$row = mysqli_fetch_assoc($r);
					$row2 = $row['edu_tcue'];

					return  $row2;

				}
				else
				{
					//declare an array
				   $debt_comb_array =array();

					//get department comb of programme combination
				    $debt_comb = get_department_comb_using_programme_id($programme_id);


				    //$countstring = strlen($debt_comb);
					//
					//check if string is greater 1
					//
					if(strpos($debt_comb, ',') !== false )
					{

						for ($i = 0; $i < count($debt_comb);$i++)
						{
							 $debt_comb_array = explode(',', $debt_comb);


						}

					 	 $first_debt = $debt_comb_array[0];

						 $second_debt = $debt_comb_array[1];
						//pass out an array

						$rx = mysqli_query(dbc(),"SELECT core1_tcue FROM students_results_nce WHERE session_id = $session  AND student_id = $user_id AND semester = 1");
						$rowx = mysqli_fetch_assoc($rx);
						$row2x = $rowx['core1_tcue'];


						$ry = mysqli_query(dbc(),"SELECT core2_tcue FROM students_results_nce WHERE session_id = $session AND student_id = $user_id AND semester = 1");
						$rowy = mysqli_fetch_assoc($ry);
						$row2y = $rowy['core2_tcue'];


					  $return_value = $row2x.','.$row2y;
						return $return_value;


					}
					else
					{

						$rz = mysqli_query(dbc(),"SELECT core1_tcue FROM students_results_nce WHERE session_id = $session  AND student_id = $user_id AND semester = 1");
						$rowz = mysqli_fetch_assoc($rz);
						$row2z = $rowz['core1_tcue'];
						return $row2z;

					}
					//

				}//end of if category is 0


			}//end of level is III and semester 2




}//get total credit unit earned from courses previously exclusive of the present semester

//get total credit unit earned from courses previou semster for prence
function get_total_credit_unit_earned_previously_prence($user_id,$programme_id,$course_category,$level,$session,$semester)
{



	//In the later version this has to be updated by level
			if($level == 'PRE' AND $semester == '1')
			{
				return 0;

			}//end of if level is pre and semester 1
	    else if($level == 'PRE' AND $semester == '2')
	    {

				//0 - conventional courses, 1 - gst courses and 2 is edu courses

				//plaay with course category
				if($course_category == 1 OR $course_category == 2 )//gst or education
				{
					$q = "SELECT SUM(course_unit)
					   FROM students_courses_prence  WHERE student_id = '$user_id' AND course_category = '$course_category'   AND semester = 1 AND session_id = $session AND total_score > 39 ";
					$r = mysqli_query(dbc(),$q);
					$row2 = mysqli_fetch_array($r);


					return  $row2[0];


				}
				else
				{
					//declare an array
				   $debt_comb_array =array();

					//get department comb of programme combination
				    $debt_comb = get_department_comb_using_programme_id($programme_id);


				    //$countstring = strlen($debt_comb);
					//
					//check if string is greater 1
					//
					if(strpos($debt_comb, ',') !== false )
					{

						for ($i = 0; $i < count($debt_comb);$i++)
						{
							 $debt_comb_array = explode(',', $debt_comb);


						}

					 	 $first_debt = $debt_comb_array[0];

						 $second_debt = $debt_comb_array[1];
						//pass out an array
						$qx = "SELECT SUM(course_unit)
					   FROM students_courses_prence  WHERE student_id = '$user_id' AND course_category = '$course_category'   AND semester = 1 AND session_id = $session AND course_department_id = '$first_debt'  AND total_score > 39 ";
						$rx = mysqli_query(dbc(),$qx);
						$rowx = mysqli_fetch_array($rx);


						$qy = "SELECT SUM(course_unit)
					   FROM students_courses_prence  WHERE student_id = '$user_id' AND course_category = '$course_category'   AND semester = 1 AND session_id = $session AND course_department_id = '$second_debt'  AND total_score > 39";
						$ry = mysqli_query(dbc(),$qy);
						$rowy = mysqli_fetch_array($ry);


					    $return_value = $rowx[0].','.$rowy[0];
						return $return_value;


					}
					else
					{
						$qz = "SELECT SUM(course_unit)
					   FROM students_courses_prence  WHERE student_id = '$user_id' AND course_category = '$course_category'   AND semester = 1 AND session_id = $session AND course_department_id = '$debt_comb'
					    AND total_score > 39";
						$rz = mysqli_query(dbc(),$qz);
						$rowz = mysqli_fetch_array($rz);

						return $rowz[0];

					}
					//




				}//end of if category is 0

			}

}//get total credit unit earned from courses previously exclusive of the present semester for prence





//get total grade point  earned from courses
function get_total_grade_point_earned_previously_nce($user_id,$programme_id,$course_category,$level,$session,$semester)
{



//In the later version this has to be updated by level
			if($level == 'I' AND $semester == '1')
			{
				return 0; //if not second semester

			}//end of if level is I and semester is 1
	    else if($level == 'I' AND $semester == '2')
	    {
				//plaay with course category
				if($course_category == 1 OR $course_category == 2)//gst or education
				{
									$q = "SELECT course_unit,total_score

									     FROM students_courses_nce  WHERE student_id = '$user_id' AND course_category = '$course_category' AND semester = 1 AND session_id = $session";
									$r = mysqli_query(dbc(),$q);
									//$row2 = mysqli_fetch_array($r);
									//
									//initialise
									$total_grade_point = 0;

									while ($row2 =mysqli_fetch_array($r,MYSQLI_ASSOC))
									{
										 $total_grade_point = get_student_grade_point_score($row2['total_score']) * $row2['course_unit'];

										 $total_grade_point2 += $total_grade_point;

									}


									return  $total_grade_point2;

				}
				else
				{
									// //declare an array
								   $debt_comb_array = array();
									//
									 //get department comb of programme combination
								   $debt_comb = get_department_comb_using_programme_id($programme_id);
									//
									//
								  // $countstring = strlen($debt_comb);
					// //
					// //check if string is greater 1
					// //
					   if(strpos($debt_comb, ',') !== false )
					   {
					//
										for ($i = 0; $i < count($debt_comb);$i++)
										{
											 $debt_comb_array = explode(',', $debt_comb);

										}
							//
							  	 $first_debt = $debt_comb_array[0];

							 	   $second_debt = $debt_comb_array[1];

										//pass out an array
								  	$qx = "SELECT course_unit,total_score

								 		FROM students_courses_nce  WHERE student_id = '$user_id' AND course_category = '$course_category'  AND semester = 1 AND session_id = $session AND course_department_id = '$first_debt'";
								  	$rx = mysqli_query(dbc(),$qx);


								  	while ($rowx =mysqli_fetch_array($rx,MYSQLI_ASSOC))
								  	{
								   		 $total_grade_point = get_student_grade_point_score($rowx['total_score']) * $rowx['course_unit'];
								//
								 		 	 $total_grade_point2x += $total_grade_point;

								   	}




									 	$qy = "SELECT course_unit,total_score

									 		 FROM students_courses_nce  WHERE student_id = '$user_id' AND course_category = '$course_category'  AND semester = 1 AND session_id = $session AND course_department_id = '$second_debt'";
									 	$ry = mysqli_query(dbc(),$qy);
					// 	//
									 	while ($rowy =mysqli_fetch_array($ry,MYSQLI_ASSOC))
									 	{
									 		 $total_grade_point = get_student_grade_point_score($rowy['total_score']) * $rowy['course_unit'];

									 		 $total_grade_point2y += $total_grade_point;

									 	}

					//
					 					$return_value = $total_grade_point2x.','.$total_grade_point2y;
					//
					 					return $return_value;
					//
					 }
					else
					{
								 	$qz = "SELECT course_unit,total_score

								      FROM students_courses_nce  WHERE student_id = '$user_id' AND course_category = '$course_category'  AND semester = 1 AND session_id = $session"; //AND course_department_id = '$debt_comb'
								 	$rz = mysqli_query(dbc(),$qz);
								// 	//
								 	while ($rowz = mysqli_fetch_array($rz,MYSQLI_ASSOC))
								 	{
								 		 $total_grade_point = get_student_grade_point_score($rowz['total_score']) * $rowz['course_unit'];

								 		 $total_grade_point2z += $total_grade_point;

								 	}
								//

								 return $total_grade_point2z;
					//
				 }//end of if the its single Combination
					// //




				}//end of if category is 0


				//return 0;


			}
			else if($level == 'II' AND $semester == 1)
			{
				if($course_category == 1 )//gst or education
				{



					$r = mysqli_query(dbc(),"SELECT gst_tgpe FROM students_results_nce WHERE session_id = ($session - 1)  AND student_id = $user_id AND semester = 2");
					$row = mysqli_fetch_assoc($r);
					$row2 = $row['gst_tgpe'];

					return  $row2;

				}
				else if($course_category == 2)
				{
					$r = mysqli_query(dbc(),"SELECT edu_tgpe FROM students_results_nce WHERE session_id = ($session - 1)  AND student_id = $user_id AND semester = 2");
					$row = mysqli_fetch_assoc($r);
					$row2 = $row['edu_tgpe'];

					return  $row2;

				}
				else
				{
					//declare an array
				   $debt_comb_array =array();

					//get department comb of programme combination
				    $debt_comb = get_department_comb_using_programme_id($programme_id);


					//
					//check if string is greater 1
					//
					if(strpos($debt_comb, ',') !== false )
					{

						for ($i = 0; $i < count($debt_comb);$i++)
						{
							 $debt_comb_array = explode(',', $debt_comb);


						}

					 	 $first_debt = $debt_comb_array[0];

						 $second_debt = $debt_comb_array[1];
						//pass out an array
						$rx = mysqli_query(dbc(),"SELECT core1_tgpe FROM students_results_nce WHERE session_id = ($session - 1)  AND student_id = $user_id AND semester = 2");
						$rowx = mysqli_fetch_assoc($rx);
						$row2x = $rowx['core1_tgpe'];


						$ry = mysqli_query(dbc(),"SELECT core2_tgpe FROM students_results_nce WHERE session_id = ($session - 1) AND student_id = $user_id AND semester = 2");
						$rowy = mysqli_fetch_assoc($ry);
						$row2y = $rowy['core2_tgpe'];


					  $return_value = $row2x.','.$row2y;
						return $return_value;


					}
					else
					{
						$rz = mysqli_query(dbc(),"SELECT core1_tgpe FROM students_results_nce WHERE session_id = ($session - 1)  AND student_id = $user_id AND semester = 2");
						$rowz = mysqli_fetch_assoc($rz);
						$row2z = $rowz['core1_tgpe'];
						return $row2z;

					}
					//
///////////////////////check here something is wrong
				}//end of if category is 0
			}
			else if($level == 'II' AND $semester == 2)
			{
				if($course_category == 1 )//gst or education
				{



					$r = mysqli_query(dbc(),"SELECT gst_tgpe FROM students_results_nce WHERE session_id = $session  AND student_id = $user_id AND semester = 1");
					$row = mysqli_fetch_assoc($r);
					$row2 = $row['gst_tgpe'];

					return  $row2;

				}
				else if($course_category == 2)
				{
					$r = mysqli_query(dbc(),"SELECT edu_tgpe FROM students_results_nce WHERE session_id = $session  AND student_id = $user_id AND semester = 1");
					$row = mysqli_fetch_assoc($r);
					$row2 = $row['edu_tgpe'];

					return  $row2;

				}
				else
				{
					//declare an array
				   $debt_comb_array =array();

					//get department comb of programme combination
				    $debt_comb = get_department_comb_using_programme_id($programme_id);


				    //$countstring = strlen($debt_comb);
					//
					//check if string is greater 1
					//
					if(strpos($debt_comb, ',') !== false )
					{

						for ($i = 0; $i < count($debt_comb);$i++)
						{
							 $debt_comb_array = explode(',', $debt_comb);


						}

					 	 $first_debt = $debt_comb_array[0];

						 $second_debt = $debt_comb_array[1];
						//pass out an array
						$rx = mysqli_query(dbc(),"SELECT core1_tgpe FROM students_results_nce WHERE session_id = $session  AND student_id = $user_id AND semester = 1");
						$rowx = mysqli_fetch_assoc($rx);
						$row2x = $rowx['core1_tgpe'];


						$ry = mysqli_query(dbc(),"SELECT core2_tgpe FROM students_results_nce WHERE session_id = $session AND student_id = $user_id AND semester = 1");
						$rowy = mysqli_fetch_assoc($ry);
						$row2y = $rowy['core2_tgpe'];


					  $return_value = $row2x.','.$row2y;
						return $return_value;


					}
					else
					{
						$rz = mysqli_query(dbc(),"SELECT core1_tgpe FROM students_results_nce WHERE session_id = $session  AND student_id = $user_id AND semester = 1");
						$rowz = mysqli_fetch_assoc($rz);
						$row2z = $rowz['core1_tgpe'];
						return $row2z;

					}
					//
///////////////////////check here something is wrong
				}//end of if category is 0

			}//end of else if $level is II and semester is 2
			else if($level == 'III' AND $semester == 1)
			{
				if($course_category == 1 )//gst or education
				{



					$r = mysqli_query(dbc(),"SELECT gst_tgpe FROM students_results_nce WHERE session_id = ($session - 1)  AND student_id = $user_id AND semester = 2");
					$row = mysqli_fetch_assoc($r);
					$row2 = $row['gst_tgpe'];

					return  $row2;

				}
				else if($course_category == 2)
				{
					$r = mysqli_query(dbc(),"SELECT edu_tgpe FROM students_results_nce WHERE session_id = ($session - 1)  AND student_id = $user_id AND semester = 2");
					$row = mysqli_fetch_assoc($r);
					$row2 = $row['edu_tgpe'];

					return  $row2;

				}
				else
				{
					//declare an array
				   $debt_comb_array =array();

					//get department comb of programme combination
				    $debt_comb = get_department_comb_using_programme_id($programme_id);


					//
					//check if string is greater 1
					//
					if(strpos($debt_comb, ',') !== false )
					{

						for ($i = 0; $i < count($debt_comb);$i++)
						{
							 $debt_comb_array = explode(',', $debt_comb);


						}

					 	 $first_debt = $debt_comb_array[0];

						 $second_debt = $debt_comb_array[1];
						//pass out an array
						$rx = mysqli_query(dbc(),"SELECT core1_tgpe FROM students_results_nce WHERE session_id = ($session - 1)  AND student_id = $user_id AND semester = 2");
						$rowx = mysqli_fetch_assoc($rx);
						$row2x = $rowx['core1_tgpe'];


						$ry = mysqli_query(dbc(),"SELECT core2_tgpe FROM students_results_nce WHERE session_id = ($session - 1) AND student_id = $user_id AND semester = 2");
						$rowy = mysqli_fetch_assoc($ry);
						$row2y = $rowy['core2_tgpe'];


					  $return_value = $row2x.','.$row2y;
						return $return_value;


					}
					else
					{
						$rz = mysqli_query(dbc(),"SELECT core1_tgpe FROM students_results_nce WHERE session_id = ($session - 1)  AND student_id = $user_id AND semester = 2");
						$rowz = mysqli_fetch_assoc($rz);
						$row2z = $rowz['core1_tgpe'];
						return $row2z;

					}
					//
///////////////////////check here something is wrong
				}//end of if category is 0
			}//end of level is III and semester is 1
			else if($level == 'III' AND $semester == 2)
			{
				if($course_category == 1 )//gst or education
				{



					$r = mysqli_query(dbc(),"SELECT gst_tgpe FROM students_results_nce WHERE session_id = $session  AND student_id = $user_id AND semester = 1");
					$row = mysqli_fetch_assoc($r);
					$row2 = $row['gst_tgpe'];

					return  $row2;

				}
				else if($course_category == 2)
				{
					$r = mysqli_query(dbc(),"SELECT edu_tgpe FROM students_results_nce WHERE session_id = $session  AND student_id = $user_id AND semester = 1");
					$row = mysqli_fetch_assoc($r);
					$row2 = $row['edu_tgpe'];

					return  $row2;

				}
				else
				{
					//declare an array
				   $debt_comb_array =array();

					//get department comb of programme combination
				    $debt_comb = get_department_comb_using_programme_id($programme_id);


				    //$countstring = strlen($debt_comb);
					//
					//check if string is greater 1
					//
					if(strpos($debt_comb, ',') !== false )
					{

						for ($i = 0; $i < count($debt_comb);$i++)
						{
							 $debt_comb_array = explode(',', $debt_comb);


						}

					 	 $first_debt = $debt_comb_array[0];

						 $second_debt = $debt_comb_array[1];
						//pass out an array
						$rx = mysqli_query(dbc(),"SELECT core1_tgpe FROM students_results_nce WHERE session_id = $session  AND student_id = $user_id AND semester = 1");
						$rowx = mysqli_fetch_assoc($rx);
						$row2x = $rowx['core1_tgpe'];


						$ry = mysqli_query(dbc(),"SELECT core2_tgpe FROM students_results_nce WHERE session_id = $session AND student_id = $user_id AND semester = 1");
						$rowy = mysqli_fetch_assoc($ry);
						$row2y = $rowy['core2_tgpe'];


					  $return_value = $row2x.','.$row2y;
						return $return_value;


					}
					else
					{
						$rz = mysqli_query(dbc(),"SELECT core1_tgpe FROM students_results_nce WHERE session_id = $session  AND student_id = $user_id AND semester = 1");
						$rowz = mysqli_fetch_assoc($rz);
						$row2z = $rowz['core1_tgpe'];
						return $row2z;

					}
					//
///////////////////////check here something is wrong
				}//end of if category is 0

			}//end of else if $level is III and semester is 2





}//function to get previously  tgp



//get total grade point  earned from courses for prence
function get_total_grade_point_earned_previously_prence($user_id,$programme_id,$course_category,$level,$session,$semester)
{



//In the later version this has to be updated by level
			if($level == 'PRE' AND $semester == '1')
			{
				return 0; //if not second semester

			}//end of if level is I and semester is 1
	    else if($level == 'PRE' AND $semester == '2')
	    {
				//plaay with course category
				if($course_category == 1 OR $course_category == 2)//gst or education
				{
									$q = "SELECT course_unit,total_score

									     FROM students_courses_prence  WHERE student_id = '$user_id' AND course_category = '$course_category' AND semester = 1 AND session_id = $session";
									$r = mysqli_query(dbc(),$q);
									//$row2 = mysqli_fetch_array($r);
									//
									//initialise
									$total_grade_point = 0;

									while ($row2 =mysqli_fetch_array($r,MYSQLI_ASSOC))
									{
										 $total_grade_point = get_student_grade_point_score($row2['total_score']) * $row2['course_unit'];

										 $total_grade_point2 += $total_grade_point;

									}


									return  $total_grade_point2;

				}
				else
				{
									// //declare an array
								   $debt_comb_array = array();
									//
									 //get department comb of programme combination
								   $debt_comb = get_department_comb_using_programme_id($programme_id);
									//
									//
								  // $countstring = strlen($debt_comb);
					// //
					// //check if string is greater 1
					// //
					   if(strpos($debt_comb, ',') !== false )
					   {
					//
										for ($i = 0; $i < count($debt_comb);$i++)
										{
											 $debt_comb_array = explode(',', $debt_comb);

										}
							//
							  	 $first_debt = $debt_comb_array[0];

							 	   $second_debt = $debt_comb_array[1];

										//pass out an array
								  	$qx = "SELECT course_unit,total_score

								 		FROM students_courses_prence  WHERE student_id = '$user_id' AND course_category = '$course_category'  AND semester = 1 AND session_id = $session AND course_department_id = '$first_debt'";
								  	$rx = mysqli_query(dbc(),$qx);


								  	while ($rowx =mysqli_fetch_array($rx,MYSQLI_ASSOC))
								  	{
								   		 $total_grade_point = get_student_grade_point_score($rowx['total_score']) * $rowx['course_unit'];
								//
								 		 	 $total_grade_point2x += $total_grade_point;

								   	}




									 	$qy = "SELECT course_unit,total_score

									 		 FROM students_courses_prence  WHERE student_id = '$user_id' AND course_category = '$course_category'  AND semester = 1 AND session_id = $session AND course_department_id = '$second_debt'";
									 	$ry = mysqli_query(dbc(),$qy);
					// 	//
									 	while ($rowy =mysqli_fetch_array($ry,MYSQLI_ASSOC))
									 	{
									 		 $total_grade_point = get_student_grade_point_score($rowy['total_score']) * $rowy['course_unit'];

									 		 $total_grade_point2y += $total_grade_point;

									 	}

					//
					 					$return_value = $total_grade_point2x.','.$total_grade_point2y;
					//
					 					return $return_value;
					//
					 }
					else
					{
								 	$qz = "SELECT course_unit,total_score

								      FROM students_courses_prence  WHERE student_id = '$user_id' AND course_category = '$course_category'  AND semester = 1 AND session_id = $session AND course_department_id = '$debt_comb' ";
								 	$rz = mysqli_query(dbc(),$qz);
								// 	//
								 	while ($rowz = mysqli_fetch_array($rz,MYSQLI_ASSOC))
								 	{
								 		 $total_grade_point = get_student_grade_point_score($rowz['total_score']) * $rowz['course_unit'];

								 		 $total_grade_point2z += $total_grade_point;

								 	}
								//

								 return $total_grade_point2z;
					//
				 }//end of if the its single Combination
					// //




				}//end of if category is 0


				//return 0;


			}




}//function to get previously  tgp prence




//get total grade point  earned from courses
function get_total_grade_point_earned_nce($user_id,$programme_id,$course_category,$level,$session,$semester)
{

		//plaay with course category
		if($course_category == 1 OR $course_category == 2)//gst or education
		{
			$q = "SELECT course_unit,total_score

			     FROM students_courses_nce  WHERE student_id = '$user_id' AND course_category = '$course_category' AND level = '$level' AND session_id = '$session' AND semester = '$semester'";
			$r = mysqli_query(dbc(),$q);
			//$row2 = mysqli_fetch_array($r);
			//
			//initialise
			//$total_grade_point = 0;

			while ($row2 =mysqli_fetch_array($r,MYSQLI_ASSOC))
			{
				 $total_grade_point = get_student_grade_point_score($row2['total_score']) * $row2['course_unit'];

				 $total_grade_point2 += $total_grade_point;

			}


			return  $total_grade_point2;

		}
		else
		{
			//declare an array
		   $debt_comb_array =array();

			//get department comb of programme combination
		    $debt_comb = get_department_comb_using_programme_id($programme_id);


		    //$countstring = strlen($debt_comb);
			//
			//check if string is greater 1
			//
			if(strpos($debt_comb, ',') !== false )
			{

				for ($i = 0; $i < count($debt_comb);$i++)
				{
					 $debt_comb_array = explode(',', $debt_comb);


				}

			 	 $first_debt = $debt_comb_array[0].'<br/>';

				 $second_debt = $debt_comb_array[1];
				//pass out an array
				$qx = "SELECT course_unit,total_score

			     FROM students_courses_nce  WHERE student_id = '$user_id' AND course_category = '$course_category' AND level = '$level' AND session_id = '$session' AND semester = '$semester' AND course_department_id = '$first_debt'";
				$rx = mysqli_query(dbc(),$qx);
				//$rowx = mysqli_fetch_array($rx);


				while ($rowx =mysqli_fetch_array($rx,MYSQLI_ASSOC))
				{
					 $total_grade_point = get_student_grade_point_score($rowx['total_score']) * $rowx['course_unit'];

					 $total_grade_point2x += $total_grade_point;

				}


			//return  $total_grade_point2x;


				$qy = "SELECT course_unit,total_score

			     FROM students_courses_nce  WHERE student_id = '$user_id' AND course_category = '$course_category' AND level = '$level' AND session_id = '$session' AND semester = '$semester' AND course_department_id = '$second_debt'";
				$ry = mysqli_query(dbc(),$qy);
				//$rowy = mysqli_fetch_array($ry);
				//
				while ($rowy =mysqli_fetch_array($ry,MYSQLI_ASSOC))
				{
					 $total_grade_point = get_student_grade_point_score($rowy['total_score']) * $rowy['course_unit'];

					 $total_grade_point2y += $total_grade_point;

				}


			//return  $total_grade_point2y;



			    $return_value = $total_grade_point2x.','.$total_grade_point2y;

				return $return_value;


			}
			else
			{
				$qz = "SELECT course_unit,total_score

			     FROM students_courses_nce  WHERE student_id = '$user_id' AND course_category = '$course_category' AND level = '$level' AND session_id = '$session' AND semester = '$semester'"; //AND course_department_id = '$debt_comb'
				$rz = mysqli_query(dbc(),$qz);
				//$rowz = mysqli_fetch_array($rz);
				//
				while ($rowz =mysqli_fetch_array($rz,MYSQLI_ASSOC))
				{
					 $total_grade_point = get_student_grade_point_score($rowz['total_score']) * $rowz['course_unit'];

					 $total_grade_point2z += $total_grade_point;

				}


				return $total_grade_point2z;

			}
			//




		}//end of if category is 0




}//function to get tgp


//get total grade point  earned from courses prence
function get_total_grade_point_earned_prence($user_id,$programme_id,$course_category,$level,$session,$semester)
{

		//plaay with course category
		if($course_category == 1 OR $course_category == 2)//gst or education
		{
			$q = "SELECT course_unit,total_score

			     FROM students_courses_prence  WHERE student_id = '$user_id' AND course_category = '$course_category' AND level = '$level' AND session_id = '$session' AND semester = '$semester'";
			$r = mysqli_query(dbc(),$q);
			//$row2 = mysqli_fetch_array($r);
			//
			//initialise
			//$total_grade_point = 0;

			while ($row2 =mysqli_fetch_array($r,MYSQLI_ASSOC))
			{
				 $total_grade_point = get_student_grade_point_score($row2['total_score']) * $row2['course_unit'];

				 $total_grade_point2 += $total_grade_point;

			}


			return  $total_grade_point2;

		}
		else
		{
			//declare an array
		   $debt_comb_array =array();

			//get department comb of programme combination
		    $debt_comb = get_department_comb_using_programme_id($programme_id);


		    //$countstring = strlen($debt_comb);
			//
			//check if string is greater 1
			//
			if(strpos($debt_comb, ',') !== false )
			{

				for ($i = 0; $i < count($debt_comb);$i++)
				{
					 $debt_comb_array = explode(',', $debt_comb);


				}

			 	 $first_debt = $debt_comb_array[0].'<br/>';

				 $second_debt = $debt_comb_array[1];
				//pass out an array
				$qx = "SELECT course_unit,total_score

			     FROM students_courses_prence  WHERE student_id = '$user_id' AND course_category = '$course_category' AND level = '$level' AND session_id = '$session' AND semester = '$semester' AND course_department_id = '$first_debt'";
				$rx = mysqli_query(dbc(),$qx);
				//$rowx = mysqli_fetch_array($rx);


				while ($rowx =mysqli_fetch_array($rx,MYSQLI_ASSOC))
				{
					 $total_grade_point = get_student_grade_point_score($rowx['total_score']) * $rowx['course_unit'];

					 $total_grade_point2x += $total_grade_point;

				}


			//return  $total_grade_point2x;


				$qy = "SELECT course_unit,total_score

			     FROM students_courses_prence  WHERE student_id = '$user_id' AND course_category = '$course_category' AND level = '$level' AND session_id = '$session' AND semester = '$semester' AND course_department_id = '$second_debt'";
				$ry = mysqli_query(dbc(),$qy);
				//$rowy = mysqli_fetch_array($ry);
				//
				while ($rowy =mysqli_fetch_array($ry,MYSQLI_ASSOC))
				{
					 $total_grade_point = get_student_grade_point_score($rowy['total_score']) * $rowy['course_unit'];

					 $total_grade_point2y += $total_grade_point;

				}


			//return  $total_grade_point2y;



			    $return_value = $total_grade_point2x.','.$total_grade_point2y;

				return $return_value;


			}
			else
			{
				$qz = "SELECT course_unit,total_score

			     FROM students_courses_prence  WHERE student_id = '$user_id' AND course_category = '$course_category' AND level = '$level' AND session_id = '$session' AND semester = '$semester' AND course_department_id = '$debt_comb'
			    ";
				$rz = mysqli_query(dbc(),$qz);
				//$rowz = mysqli_fetch_array($rz);
				//
				while ($rowz =mysqli_fetch_array($rz,MYSQLI_ASSOC))
				{
					 $total_grade_point = get_student_grade_point_score($rowz['total_score']) * $rowz['course_unit'];

					 $total_grade_point2z += $total_grade_point;

				}


				return $total_grade_point2z;

			}
			//




		}//end of if category is 0




}//function to get tgp prence


//get total credit unit earned from courses per core or elective previou semster
function get_total_credit_unit_earned_per_course_type_nce($user_id,$programme_id,$course_category,$course_type,$level,$session,$semester)
{



// 	if($level == 'III' AND $semester == 2)
// 	{
        if($course_category == 1)//gst or education
				{

//gst 1  and edu 2 0 conve
					//query to get gst prvious from last semester
					$q = "SELECT SUM(course_unit) AS summed
					FROM students_courses_nce, courses
					WHERE student_id = '$user_id'
					AND students_courses_nce.course_category = '$course_category'
					AND  courses.id = students_courses_nce.course_id
					AND  courses.course_type = '$course_type'
					AND students_courses_nce.total_score > 39"; //AND seen_as_elective = '$course_type'
					$r = mysqli_query(dbc(),$q);
					$row2 = mysqli_fetch_array($r);

					return  $row2['summed'];

				}
				else if ($course_category == 2)
				{

					//query to get gst prvious from last semester
					$q = "SELECT SUM(course_unit) AS summed
						FROM students_courses_nce, courses
    					WHERE student_id = '$user_id'
    					AND students_courses_nce.course_category = '$course_category'
    					AND  courses.id = students_courses_nce.course_id
    					AND  courses.course_type = '$course_type'
    					AND students_courses_nce.total_score > 39 "; //AND session_id = $session //AND seen_as_elective = '$course_type'
					$r = mysqli_query(dbc(),$q);
					$row2 = mysqli_fetch_array($r);

					return  $row2['summed'];

				}
				else
				{
					//declare an array
				   $debt_comb_array =array();

					//get department comb of programme combination
				    $debt_comb = get_department_comb_using_programme_id($programme_id);


				    //$countstring = strlen($debt_comb);
					//
					//check if string is greater 1
					//
					if(strpos($debt_comb, ',') !== false )
					{

						for ($i = 0; $i < count($debt_comb);$i++)
						{
							 $debt_comb_array = explode(',', $debt_comb);


						}

					 	 $first_debt = $debt_comb_array[0];

						 $second_debt = $debt_comb_array[1];
						//pass out an array
						$qx = "SELECT SUM(course_unit) AS summed
						       	FROM students_courses_nce, courses
            					WHERE student_id = '$user_id'
            					AND students_courses_nce.course_category = '$course_category'
            					AND  courses.id = students_courses_nce.course_id
            					AND  courses.course_type = '$course_type'
            					AND students_courses_nce.total_score > 39
            					AND students_courses_nce.course_department_id = '$first_debt'";
					  // FROM students_courses_nce  WHERE student_id = '$user_id' AND course_category = '$course_category'  AND course_department_id = '$first_debt'  AND total_score > 39 "; //AND seen_as_elective = '$course_type'
						$rx = mysqli_query(dbc(),$qx);
						$rowx = mysqli_fetch_array($rx);


						$qy = "SELECT SUM(course_unit) AS sum

					   FROM students_courses_nce, courses
            					WHERE student_id = '$user_id'
            					AND students_courses_nce.course_category = '$course_category'
            					AND  courses.id = students_courses_nce.course_id
            					AND  courses.course_type = '$course_type'
            					AND students_courses_nce.total_score > 39
            					AND students_courses_nce.course_department_id = '$second_debt'";

    //         					FROM students_courses_nce  WHERE student_id = '$user_id' AND course_category = '$course_category'  AND course_department_id = '$second_debt'
				// 	    AND total_score > 39";//AND seen_as_elective = '$course_type'
						$ry = mysqli_query(dbc(),$qy);
						$rowy = mysqli_fetch_array($ry);


					    $return_value = $rowx['summed'].','.$rowy['sum'];
						return $return_value;


					}
					else
					{
						$qz = "SELECT SUM(course_unit) AS summed
						FROM students_courses_nce, courses
            					WHERE student_id = '$user_id'
            					AND students_courses_nce.course_category = '$course_category'
            					AND  courses.id = students_courses_nce.course_id
            					AND  courses.course_type = '$course_type'
            					AND students_courses_nce.total_score > 39"; //
            				//	AND students_courses_nce.course_department_id = '$debt_comb'


					   //FROM students_courses_nce  WHERE student_id = '$user_id' AND course_category = '$course_category'  AND course_department_id = '$debt_comb'
					   // AND total_score > 39"


					  	$rz = mysqli_query(dbc(),$qz);
						$rowz = mysqli_fetch_array($rz);

						return $rowz['summed'];

					}
					//

				}//end of if category is 0


	//		}//end of level is III and semester





}//get total credit unit earned from courses per core or elective courses


//function remark on probation
//to improve these codes the best way is to create mor escnearios   honestly these codes are rough because we are rushing
//to actualise the deadline
function get_probation_remark_per_semester_nce($curr_gpa,$level,$session,$semester)
{


	if($level == 'I' AND $semester == 1)
	{
		if($curr_gpa < 1)
		{
			$output = 'PROB';

		}
		else
		{
			$output = '';
		}

	}
	else if($level == 'I' AND $semester == 2)
	{
		if($curr_gpa < 1)
		{
			$output = 'PROB';
		}
		else
		{
			$output = '';

		}

	}
	else if($level == 'II' AND $semester == 1)
	{
		if($curr_gpa < 1)
		{
			$output = 'PROB';
		}
		else
		{
			$output = '';

		}
	}
	else if($level == 'II' AND $semester == 2)
	{
		if($curr_gpa < 1)
		{
			$output = 'PROB';
		}
		else
		{
			$output = '';

		}

	}
	else if ($level == 'III' AND $semester == 1)
	{
		if($curr_gpa < 1)
		{
			$output = 'PROB';
		}
		else
		{
			$output = '';

		}
	}
	else if ($level == 'III' AND $semester == 2)
	{
		if($curr_gpa < 1)
		{
			$output = 'PROB';
		}
		else
		{
			$output = '';

		}
	}


	return $output;

}//nce



//to actualise the deadline prence
function get_probation_remark_per_semester_prence($curr_gpa,$level,$session,$semester)
{


	if($level == 'PRE' AND $semester == 1)
	{
		if($curr_gpa < 1)
		{
			$output = 'PROB';

		}
		else
		{
			$output = '';
		}

	}
	else if($level == 'PRE' AND $semester == 2)
	{
		if($curr_gpa < 1)
		{
			$output = ''; //comment to remove PROB because probation doesnt exist in second semester
		}
		else
		{
			$output = '';

		}

	}


	return $output;

}// to get prence




//function to get academic withdraw probation remark based on two successive probs
function get_acad_with_remark_per_semester_nce($user_id,$prev_gpa,$curr_gpa,$level,$session,$semester)
{


//there is a special consideration for students that are academically withdrawn but have second semester cgpa reading from
//0.95 to 0.99, in this case it happened 2017/2018 session for the first cgpa of the students
//at this stage the session is 3
//echo $curr_gpa;
//


$rounded_prev_gpa = round($prev_gpa,2);

$rounded_curr_gpa = round($curr_gpa,2);

	// if($level == 'I' AND $session == 3 AND $semester == 2)
	// {//for this case
	//
	// 	if(($rounded_prev_gpa < 1.0) &&  ($rounded_curr_gpa  < 0.95))
	// 	{
	// 		$output = 'ACAD WITH';
	//
	// 	}
	// 	else
	// 	{
	// 		$output = '';
	//
	// 	}
	//
	// }
	// else
	if($level == 'I' AND $semester == 1)
	{

		$output = '';

	}
	else if($level == 'I' AND $semester == 2)
	{

		if($session == 3) //special session consideration
		{
					if(($rounded_prev_gpa < 1.0) &&  ($rounded_curr_gpa  < 0.95))
					{
						$output = 'ACAD WITH';

					}
					else
					{
						$output = '';

					}

		}
		else if($session == 5) //another special consdieration
		{
					if(($rounded_prev_gpa < 1.0) &&  ($rounded_curr_gpa  < 0.80))
					{
						$output = 'REPEAT';

					}
					// else if(($rounded_prev_gpa < 1.0) &&  ($rounded_curr_gpa  >= 0.80 && $rounded_curr_gpa <= 1.0))
					// {
					// 	$output = 'PROB';
					//
					// }
					else
					{
						$output = '';

					}

		}
		else
		{//end of if $session

			if($prev_gpa < 1.0  AND $curr_gpa < 1.0)
			{
				$output = 'ACAD WITH';

			}
			else
			{
				$output = '';

			}

		}//end of if session is the amnesty session

	}
	else if($level == 'II' AND $semester == 1)
	{
		if($prev_gpa < 1.0  AND $curr_gpa < 1.0)
		{
			$output = 'ACAD WITH';

		}
		else
		{
			$output = '';

		}

	}
	else if($level == 'II' AND $semester == 2)
	{
		if($prev_gpa < 1.0  AND $curr_gpa < 1.0)
		{
			$output = 'ACAD WITH';

		}
		else
		{
			$output = '';

		}

	}
	else if($level == 'III' AND $semester == 1)
	{
		if($prev_gpa < 1.0  AND $curr_gpa < 1.0)
		{
			$output = 'ACAD WITH';

		}
		else
		{
			$output = '';

		}

	}
	else if($level == 'III' AND $semester == 2)
	{
		if($prev_gpa < 1.0  AND $curr_gpa < 1.0)
		{
			$output = 'ACAD WITH';

		}
		else
		{
			$output = '';

		}

	}


	return $output;

}//end of if probation is


//function to get academic withdraw probation remark based on two successive probs prence
function get_acad_with_remark_per_semester_prence($user_id,$prev_gpa,$curr_gpa,$level,$session,$semester)
{


//there is a special consideration for students that are academically withdrawn but have second semester cgpa reading from
//0.95 to 0.99, in this case it happened 2017/2018 session for the first cgpa of the students
//at this stage the session is 3
//echo $curr_gpa;
//


$rounded_prev_gpa = round($prev_gpa,2);

$rounded_curr_gpa = round($curr_gpa,2);


	if($level == 'PRE' AND $semester == 1)
	{

		$output = '';

	}
	else if($level == 'PRE' AND $semester == 2)
	{
		//
		// 1.50 - 2.39 Pass
		// 2.40 - 3.49 Merit
		// 3.50 - 4.49 Credit
		// 4.50 - 5.00 Distinction


		if($session != 4)
		{
			//work on this by session
			if( $curr_gpa < 1.0)
			{
				$output = 'ACAD WITH';

			}
			else if( $curr_gpa > 0.99 AND $curr_gpa < 1.49)
			{
				$output = 'LOWER PASS';

			}
			else if( $curr_gpa > 1.49 AND $curr_gpa < 2.39)
			{
				$output = 'PASS';

			}
			else if( $curr_gpa > 2.39 AND $curr_gpa < 3.49)
			{
				$output = 'MERIT';

			}
			else if( $curr_gpa > 3.49 AND $curr_gpa < 4.49)
			{
				$output = 'CREDIT';

			}
			else if( $curr_gpa > 4.49 AND $curr_gpa < 5.00)
			{
				$output = 'DISTINCTION';

			}
			else
			{
				$output = '';

			}


		}//end of if session is 4
		else
		{

			if( $curr_gpa < 0.70)
			{
				$output = 'ACAD WITH';

			}
			else if( $curr_gpa > 0.69 AND $curr_gpa < 1.49)
			{
				$output = 'LOWER PASS';

			}
			else if( $curr_gpa > 1.49 AND $curr_gpa < 2.39)
			{
				$output = 'PASS';

			}
			else if( $curr_gpa > 2.39 AND $curr_gpa < 3.49)
			{
				$output = 'MERIT';

			}
			else if( $curr_gpa > 3.49 AND $curr_gpa < 4.49)
			{
				$output = 'CREDIT';

			}
			else if( $curr_gpa > 4.49 AND $curr_gpa < 5.00)
			{
				$output = 'DISTINCTION';

			}
			else
			{
				$output = '';

			}

		}

	}


	return $output;

}//end of if probation is prence this is the academic withdrawal remark1

//old
// if($session == 3 AND $semester == 2)
// {//for this case
//
// 	if(($rounded_prev_gpa < 1.0) &&  ($rounded_curr_gpa  < 0.95))
// 	{
// 		$output = 'ACAD WITH';
//
// 	}
// 	else
// 	{
// 		$output = '';
//
// 	}
//
// }
// else
// {
// 	if($prev_gpa < 1  AND $curr_gpa < 1)
// 	{
// 		$output = 'ACAD WITH';
//
// 	}
// 	else
// 	{
// 		$output = '';
//
// 	}
//
// }


//function to get volunatry with  remark based on two successive probs
function get_vol_with_remark_per_semester_nce($curr_gpa)
{


	if($level == 'I' AND $semester == 1)
	{

		if ($curr_gpa  == 0 )
		{
			$output = 'VOL WITH';

		}
		else
		{
			//do nothing
			$output = '';
		}

	}
	else if($level == 'I' AND $semester == 2)
	{

			if ($curr_gpa  == 0 )
			{
				$output = 'VOL WITH';

			}
			else
			{
				//do nothing
				$output = '';
			}

	}
	else if($level == 'II' AND $semester == 1)
	{
		if ($curr_gpa  == 0 )
		{
			$output = 'VOL WITH';

		}
		else
		{
			//do nothing
			$output = '';
		}

	}
	else if($level == 'II' AND $semester == 2)
	{
		if ($curr_gpa  == 0 )
		{
			$output = 'VOL WITH';

		}
		else
		{
			//do nothing
			$output = '';
		}

	}
	else if($level == 'III' AND $semester == 1)
	{
		if ($curr_gpa  == 0 )
		{
			$output = 'VOL WITH';

		}
		else
		{
			//do nothing
			$output = '';
		}

	}
	else if($level == 'III' AND $semester == 2)
	{
		if ($curr_gpa  == 0 )
		{
			$output = 'VOL WITH';

		}
		else
		{
			//do nothing
			$output = '';
		}

	}



	return $output;

}//end of if vol withdrawal is


//function to get volunatry with  remark based on two successive probs prence
function get_vol_with_remark_per_semester_prence($curr_gpa)
{


	if($level == 'PRE' AND $semester == 1)
	{

		if ($curr_gpa  == 0 )
		{
			$output = 'VOL WITH';

		}
		else
		{
			//do nothing
			$output = '';
		}

	}
	else if($level == 'PRE' AND $semester == 2)
	{

			if ($curr_gpa  == 0 )
			{
				$output = 'VOL WITH';

			}
			else
			{
				//do nothing
				$output = '';
			}

	}



	return $output;

}//end of if vol withdrawal is prence


//function to get  graduate remark is passed unatry with  remark based on two successive probs
function get_graduation_remark_nce($student, $programme_id,$level,$ses, $sem, $curr_gpa)
{


	// if($level == 'III' AND $semester == 2)
	// {

		//get total education core earned

		if( $curr_gpa > 0.99 AND $curr_gpa < 1.49)
		{
			$output = 'LOWER PASS';

		}
		else if( $curr_gpa > 1.49 AND $curr_gpa < 2.39)
		{
			$output = 'PASS';

		}
		else if( $curr_gpa > 2.39 AND $curr_gpa < 3.49)
		{
			$output = 'MERIT';

		}
		else if( $curr_gpa > 3.49 AND $curr_gpa < 4.49)
		{
			$output = 'CREDIT';

		}
		else if( $curr_gpa > 4.49 AND $curr_gpa < 5.00)
		{
			$output = 'DISTINCTION';

		}
		else
		{
			$output = '';

		}


	// }
	// else
	//
	//
	// 		//do nothing
	// 		$output = '';
	//
	//
	// }



	return $output;

}//end of if remark is graudate wihich is passed



//function to get to compare if a student gets to graduate  and check if student graudates
function check_minimum_requirments_nce($user_id, $pid,$level,$ses, $sem) //$pid is programme id
{


	//create a special experience for special education studnets as usual
	//check if programme id falls in the categories of SED programme
// 	 $sed_pids = get_comma_separated_sed_programme_ids('%SED%',$type_id = 2, $mode = 1,$dept_idd = '!= 12');


	 $sed_pids = array(1,4,8,13,14,17,18,19,20,21,22,23,36,43,44,45,52,54,63,65,69,70,71,72,73,223,226,230,233,236,239,242);


	//get pid either for sed or ordinary programme
	// $pid = (in_array($pid,$sed_pids,true))? 	get_student_SED_programme_id($user_id) : 	$pid;



	if(in_array($pid,$sed_pids))
	{//if sed programme
		 $sed_pid = get_student_SED_programme_id($user_id);


		$edu_core_required = (int)get_edu_core_minimum_req_nce($sed_pid, $ses);
		$edu_elective_required = (int)get_edu_elective_minimum_req_nce($sed_pid, $ses);


		$gst_core_required = (int)get_gst_core_minimum_req_nce($sed_pid, $ses);
		$gst_elective_required = (int)get_gst_elective_minimum_req_nce($sed_pid,$ses);


		$core1_core_required = (int)get_core1_core_minimum_req_nce($sed_pid, $ses);
		$core1_elective_required = (int)get_core1_elective_minimum_req_nce($sed_pid, $ses);

		$core2_core_required = (int)get_core2_core_minimum_req_nce($sed_pid, $ses);
		$core2_elective_required = (int)get_core2_elective_minimum_req_nce($sed_pid,$ses);


	}
	else
	{
		$edu_core_required = (int)get_edu_core_minimum_req_nce($pid, $ses);
		$edu_elective_required = (int)get_edu_elective_minimum_req_nce($pid, $ses);


		$gst_core_required = (int)get_gst_core_minimum_req_nce($pid, $ses);
		$gst_elective_required = (int)get_gst_elective_minimum_req_nce($pid,$ses);


		$core1_core_required = (int)get_core1_core_minimum_req_nce($pid, $ses);
		$core1_elective_required = (int)get_core1_elective_minimum_req_nce($pid, $ses);

		$core2_core_required = (int)get_core2_core_minimum_req_nce($pid, $ses);
		$core2_elective_required = (int)get_core2_elective_minimum_req_nce($pid,$ses);


	}

	//
	// if($level == 'III' AND $semester == 2)
	// {
		//get the school required minimum  credit units





		// //get the student's core1 units
		// $earned_core1_core = get_total_credit_unit_earned_per_course_type_nce($user_id,$pid,$course_category = 0, $course_type = 0 ,$level,$ses,$sem);
		// $earned_core1_elective = get_total_credit_unit_earned_per_course_type_nce($user_id,$pid,$course_category = 0, $course_type = 1, $level,$ses,$sem);
		//
		//
		//
		//
		// //get the student's core2 units
		// $earned_core2_core = get_total_credit_unit_earned_per_course_type_nce($user_id,$pid,$course_category = 0, $course_type = 0 ,$level,$ses,$sem);
		// $earned_core2_elective = get_total_credit_unit_earned_per_course_type_nce($user_id,$pid,$course_category = 0, $course_type = 1, $level,$ses,$sem);
		//





				//course course_category starting with education
				// if($course_category == 1)
				// {
					//get the student's gst units
					$earned_gst_core = (int)get_total_credit_unit_earned_per_course_type_nce($user_id,$pid,$course_category = 1, $course_type1 = 1 ,$level,$ses,$sem);
					$earned_gst_elective = (int)get_total_credit_unit_earned_per_course_type_nce($user_id,$pid,$course_category = 1, $course_type2 = 2, $level,$ses,$sem);


					// play with if the gst has met up with the minimm credit requirement and pass if a variable that holds a comment ..
					//test GST core
					if($earned_gst_core  >= $gst_core_required)
					{
						$gst_core_passed = true;

					}
					else
					{
						$gst_core_passed = false;
						$gst = $gst_core_required - $earned_gst_core;
						$gst_core_comment = 'GSE: '.$gst.'C';

					}//end of else  if gst comparison


					//test GST elective
					if($earned_gst_elective >= $gst_elective_required)
					{
						$gst_elective_passed = true;

					}
					else
					{
						$gst_elective_passed = false;
						$gst = $gst_elective_required - $earned_gst_elective;
						$gst_elective_comment = 'GSE: '.$gst.'E';

					}//end of else  if gst comparison





				//}
				// else if ($course_category == 2) //edu comparison
				// {
			 //
				// 	//get the student's edu units
					$earned_edu_core = (int)get_total_credit_unit_earned_per_course_type_nce($user_id,$pid,$course_category2 = 2, $course_type3 = 1 ,$level,$ses,$sem);
					$earned_edu_elective = (int)get_total_credit_unit_earned_per_course_type_nce($user_id,$pid,$course_category2 = 2, $course_type4 = 2, $level,$ses,$sem);

			 //
			 ////test edu core
					if($earned_edu_core  >= $edu_core_required )
					{
						$edu_core_passed = true;

					}
					else
					{
						$edu_core_passed = false;
						$edu = $edu_core_required-$earned_edu_core;
						$edu_core_comment = 'EDU '.$edu.'C';

					}//end of else  if edu comparison


					if($earned_edu_elective >= $edu_elective_required)
					{
						$edu_elective_passed = true;

					}
					else
					{
						$edu_elective_passed = false;
						$edu = $edu_elective_required-$earned_edu_elective;
						$edu_elective_comment = 'EDU:'.$edu.'E';


					}//end of else  if edu comparison

			 //
				// }
				// else
				// {
			 //
			 //
							//declare an array to hold the pices of the
							$earned_core0_core_array = array(); //declared to earned core credeit unit

							//declare an array to hold the pices for elective credit unit earned
							$earned_core0_elective_array = array();

			 //
			 //
			 //
							//get the student's core0 units core means subject here
							$earned_core0_core = get_total_credit_unit_earned_per_course_type_nce($user_id,$pid,$course_category3 = 0, $course_type5 = 1 ,$level,$ses,$sem);
							$earned_core0_elective = get_total_credit_unit_earned_per_course_type_nce($user_id,$pid,$course_category3 = 0, $course_type6 = 2, $level,$ses,$sem);


							///pass the core 0 fresh present total
 						 if(strpos($earned_core0_core, ',') !== false)//check
 						 {

 						 		for ($i = 0; $i < count($earned_core0_core);$i++)
 								{
 									 $earned_core0_core_array = explode(',', $earned_core0_core);

 								}


 								//pass the array to the two variables
 								$earned_core1o =  (int)$earned_core0_core_array[0]; //first summed
 								$earned_core1_core = $earned_core1o;

 								$earned_core2o = (int)$earned_core0_core_array[1]; //second summed
 								$earned_core2_core = $earned_core2o;



								//check if the subject A and SUbject B are been met up with

								if($earned_core1_core  >= $core1_core_required && $earned_core2_core >= $core2_core_required)
								{
									$core_passed = true;

								}
								else
								{
									$core_passed = false;
									$sub1 = $core1_core_required - $earned_core1_core;
									$sub2 = $core2_core_required - $earned_core2_core;
									$core_comment1 = 'SUB-A:'.$sub1.'C';
									$core_comment2 = 'SUB-B:'.$sub2.'C';

									$core_comment = $core_comment1.' '.$core_comment2;


								}//end of else  if edu comparison

 						 }
 						 else
 						 {
 						 	//just collect the single department id
 						 	$earned_core1o = (int)$earned_core0_core;
 						 	$earned_core1_core = (int)$earned_core1o;



							//check if the subject A and SUbject B are been met up with

							if($earned_core1_core  >= $core1_core_required)
							{
								$core_passed = true;

							}
							else
							{
								$core_passed = false;
								$sub = $core1_core_required - $earned_core1_core;
								$core_comment = 'SUB:'.$sub.'C';

							}//end of else  if core 1 comparison

						}// end of else of if core and or returned comma seperated sum


						//subject A or B but elective subject A or B summed up
						if(strpos($earned_core0_elective, ',') !== false)//check
					    {

							for ($i = 0; $i < count($earned_core0_elective);$i++)
							{
								 $earned_core0_elective_array = explode(',', $earned_core0_elective);


							}


							//pass the array to the two variables
							$earned_core1o_elective =  (int)$earned_core0_elective_array[0]; //first summed
							$earned_core1_elective = $earned_core1o_elective;

							$earned_core2o_elective  = (int)$earned_core0_elective_array[1]; //second summed
							$earned_core2_elective = $earned_core2o_elective;



							//check if the subject A and SUbject B are been met up with for the elective

							if($earned_core1_elective  >= $core1_elective_required && $earned_core2_elective >= $core2_elective_required)
							{
								$core_elective_passed = true;

							}
							else
							{
								$core_elective_passed = false;

								$sub1 = $core1_elective_required - $earned_core1_elective;
								$sub2 = $core2_elective_required - $earned_core2_elective;
								$core_elective_comment1 = 'SUB-A:'.$sub1.'E';
								$core_elective_comment2 = 'SUB-B:'.$sub2.'E';

								$core_elective_comment = $core_elective_comment1.' '.$core_elective_comment2;


							}//end of else  if edu comparison

					 }
					 else
					 {
						//just collect the single department id
						$earned_core1o_elective = (int)$earned_core0_elective;
						$earned_core1_elective = $earned_core1o_elective;


								if($earned_core1_elective  >= $core1_elective_required)
								{
									$core_elective_passed = true;

								}
								else
								{
									$sub = $core1_elective_required - $earned_core1_elective;
									$core_elective_passed = false;
									$core_elective_comment = 'SUB: '.$sub.'E';


								}//end of else  if core elective passed comparison

					}// end of else of if core and or returned comma seperated sum for the elective courses

			 //
			 //
			 // }//end of if else category is




			 //compare all the

			 if($gst_core_passed && $gst_elective_passed && $edu_core_passed && $edu_elective_passed  && $core_passed && $core_elective_passed )
			 {
				 $output = 'Pass';
			 }
			 else
			 {
				 //concatenate all comments together
				 $output = $gst_core_comment . $gst_elective_comment . $edu_core_comment . $edu_elective_comment . $core_comment . $core_elective_comment;

			 }







	return $output;

}//end of check if student graduates or not


//get compounded remark and refine it
function get_compounded_remark_nce($vol_with, $acad_with_remark,$repeat_with_remark,$probation_remark,$oc_remark,$no_oc, $min_grad_remark, $grad_grade, $non_grad_remark)
{
	if($vol_with  == 'VOL WITH')
	{
		return $vol_with;

	}


	if ($acad_with_remark == 'ACAD WITH')
	{
		return $acad_with_remark;
	}


	if($probation_remark == 'PROB')
	{
		return $probation_remark.' ; '.$oc_remark.'-'.$no_oc;
	}


	if($oc_remark == 'PASSED')
	{
		return $oc_remark;
	}

	if($repeat_with_remark == 'REPEAT')
	{
		return $repeat_with_remark;
	}


	if($oc_remark == 'OC')
	{
		return $oc_remark.'-'.$no_oc;
	}


	//add a remark of passed for the graduating students

	//graduating
	if($min_grad_remark == 'Pass')
	{
		return $grad_grade;
	}


	//graduating
	if($non_grad_remark != '')
	{
		return $non_grad_remark;
	}




}



//get compounded remark and refine it prence
function get_compounded_remark_prence($vol_with, $acad_with_remark,$probation_remark,$oc_remark,$no_oc)
{
	if($vol_with  == 'VOL WITH')
	{
		return $vol_with;

	}


	if ($acad_with_remark == 'ACAD WITH')
	{
		return $acad_with_remark;
	}


	if($probation_remark == 'PROB')
	{
		return $probation_remark.' ; '.$oc_remark.'-'.$no_oc;
	}


	if($oc_remark == 'PASSED')
	{
		return $oc_remark;
	}


	if($oc_remark == 'OC')
	{
		return $oc_remark.'-'.$no_oc;
	}


	//get more remarks
//heare I used acad_with_remark

	if ($acad_with_remark == 'LOWER PASS')
	{
		return $acad_with_remark;
	}

	if ($acad_with_remark == 'PASS')
	{
		return $acad_with_remark;
	}

	if ($acad_with_remark == 'MERIT')
	{
		return $acad_with_remark;
	}

	if ($acad_with_remark == 'CREDIT')
	{
		return $acad_with_remark;
	}

	if ($acad_with_remark == 'DISTINCTION')
	{
		return $acad_with_remark;
	}

}//prence


//function to grade using CGPA for varioous subject
function get_grade_by_various_subjects($curr_gpa) //$student, $programme_id,$level,$ses, $sem,
{


	// if($level == 'III' AND $semester == 2)
	// {

		//get total education core earned

		if( $curr_gpa >= 0.00 AND $curr_gpa <= 0.99)
		{
			$output = 'F';

		}
		else if( $curr_gpa >= 1.00 AND $curr_gpa <= 1.49)
		{
			$output = 'E';

		}
		else if( $curr_gpa >= 1.50 AND $curr_gpa <= 2.39)
		{
			$output = 'D';

		}
		else if( $curr_gpa >= 2.40 AND $curr_gpa <= 3.49)
		{
			$output = 'C';

		}
		else if( $curr_gpa >= 3.50 AND $curr_gpa <= 4.49)
		{
			$output = 'B';

		}
		else if( $curr_gpa >= 4.50 AND $curr_gpa <= 5.00)
		{
			$output = 'A';

		}
		else
		{
			$output = '';

		}


	// }
	// else
	//
	//
	// 		//do nothing
	// 		$output = '';
	//
	//
	// }



	return $output;

}//end of if grade by various combination




//function to get academic withdraw probation remark based on two successive probs
function get_student_previous_gpa_nce($user_id,$programme_id,$level,$session,$semester)
{

	//manipulate getting old session
	$manipulated_session = $session - 1;

	////manipulate getting old semester
	$manipulated_semester = $semester - 1;


	if($level == 'I' AND $semester == '1')
	{
		$output = '';
	}
	else if ($level == 'I' AND $semester == '2')
	{

		$q = "SELECT cum_cgpa
		  FROM students_results_nce  WHERE student_id = '$user_id'  AND level = '$level'
		  AND programme_id = '$programme_id' AND session_id = '$session' AND semester = '$manipulated_semester'";


		 $r = mysqli_query(dbc(),$q); //query the result


		 //check if the result has values
		 if(mysqli_num_rows($r) > 0 )
		 {
		 	$row = mysqli_fetch_array($r, MYSQLI_ASSOC);

		 	$output = $row['cum_cgpa'];

		 }
		 else
		 {
		 	$output = '';
		 }

	}
	else if ($level == 'II' AND $semester == '1')
	{
	// 	//going forward we have to work on each level's condition and semester
			$q = "SELECT cum_cgpa
				FROM students_results_nce  WHERE student_id = '$user_id'
				AND session_id = ($session - 1) AND semester = 2";


			 $r = mysqli_query(dbc(),$q); //query the result


			 //check if the result has values
			 if(mysqli_num_rows($r) > 0 )
			 {
				$row = mysqli_fetch_array($r, MYSQLI_ASSOC);

				$output = $row['cum_cgpa'];

			 }
			 else
			 {
				$output = '';
			 }

	}
	else if ($level == 'II' AND $semester == '2')
	{
		$q = "SELECT cum_cgpa
			FROM students_results_nce  WHERE student_id = '$user_id'
			AND session_id = $session AND semester = 1";


		 $r = mysqli_query(dbc(),$q); //query the result


		 //check if the result has values
		 if(mysqli_num_rows($r) > 0 )
		 {
			$row = mysqli_fetch_array($r, MYSQLI_ASSOC);

			$output = $row['cum_cgpa'];

		 }
		 else
		 {
			$output = '';
		 }

	}
	else if ($level == 'III' AND $semester == '1')
	{
				$q = "SELECT cum_cgpa
					FROM students_results_nce  WHERE student_id = '$user_id'
					AND session_id = ($session - 1) AND semester = 2";


				 $r = mysqli_query(dbc(),$q); //query the result


				 //check if the result has values
				 if(mysqli_num_rows($r) > 0 )
				 {
					$row = mysqli_fetch_array($r, MYSQLI_ASSOC);

					$output = $row['cum_cgpa'];

				 }
				 else
				 {
					$output = '';
				 }
	}
	else if ($level == 'III' AND $semester == '2')
	{
		$q = "SELECT cum_cgpa
			FROM students_results_nce  WHERE student_id = '$user_id'
			AND session_id = $session AND semester = 1";


		 $r = mysqli_query(dbc(),$q); //query the result


		 //check if the result has values
		 if(mysqli_num_rows($r) > 0 )
		 {
			$row = mysqli_fetch_array($r, MYSQLI_ASSOC);

			$output = $row['cum_cgpa'];

		 }
		 else
		 {
			$output = '';
		 }

	}// end of if level is III
	else
	{
		//do nothing for now
	}



	//if out put is not empty
	if($output != '')
	{
		$outputr = $output;

	}
	else
	{
		$outputr = 'false';
	}

	//$return = ($output0 != '' ? $output = $outputv : $output = false); //return false if there is no value as there wound


	return $outputr;

}//end of get previous semester gpa to pass to academic withdrawal function



//function to get academic withdraw probation remark based on two successive probs prence
function get_student_previous_gpa_prence($user_id,$programme_id,$level,$session,$semester)
{

	//manipulate getting old session
	$manipulated_session = $session - 1;

	////manipulate getting old semester
	$manipulated_semester = $semester - 1;


	if($level == 'PRE' AND $semester == '1')
	{
		$output = '';
	}
	else if ($level == 'PRE' AND $semester == '2')
	{

		$q = "SELECT cum_cgpa
		  FROM students_results_prence  WHERE student_id = '$user_id'  AND level = '$level'
		  AND programme_id = '$programme_id' AND session_id = '$session' AND semester = '$manipulated_semester'";


		 $r = mysqli_query(dbc(),$q); //query the result


		 //check if the result has values
		 if(mysqli_num_rows($r) > 0 )
		 {
		 	$row = mysqli_fetch_array($r, MYSQLI_ASSOC);

		 	$output = $row['cum_cgpa'];

		 }
		 else
		 {
		 	$output = '';
		 }

	}//end of if prence





	//if out put is not empty
	if($output != '')
	{
		$outputr = $output;

	}
	else
	{
		$outputr = 'false';
	}

	//$return = ($output0 != '' ? $output = $outputv : $output = false); //return false if there is no value as there wound


	return $outputr;

}//end of get previous semester gpa to pass to academic withdrawal function prence



//function to get academic withdraw for the last semester
function get_previous_remark2($user_id,$programme_id,$level,$session,$semester)
{

	//manipulate getting old session
	$manipulated_session = $session - 1;

	////manipulate getting old semester
	$manipulated_semester = $semester - 1;


	if($level == 'I' AND $semester == '1')
	{
		$output = '';
	}
	else if ($level == 'I' AND $semester == '2')
	{

		$q = "SELECT remark2
		  FROM students_results_nce  WHERE student_id = '$user_id'
		  AND programme_id = '$programme_id' AND session_id = '$session' AND semester = '$manipulated_semester'";


		 $r = mysqli_query(dbc(),$q); //query the result
		 $row = mysqli_fetch_array($r, MYSQLI_ASSOC);

		 $output = $row['remark2'];



	}
	else if ($level == 'II' AND $semester == '1')
	{
	// 	//going forward we have to work on each level's condition and semester
			$q = "SELECT remark2
				FROM students_results_nce  WHERE student_id = '$user_id'
				AND session_id = ($session - 1) AND semester = 2";


			 $r = mysqli_query(dbc(),$q); //query the result

			 $row = mysqli_fetch_array($r, MYSQLI_ASSOC);

			 $output = $row['remark2'];


	}
	else if ($level == 'II' AND $semester == '2')
	{
		$q = "SELECT remark2
			FROM students_results_nce  WHERE student_id = '$user_id'
			AND session_id = $session AND semester = 1";


		 $r = mysqli_query(dbc(),$q); //query the result


			$row = mysqli_fetch_array($r, MYSQLI_ASSOC);

			$output = $row['remark2'];



	}
	else if ($level == 'III' AND $semester == '1')
	{
				$q = "SELECT remark2
					FROM students_results_nce  WHERE student_id = '$user_id'
					AND session_id = ($session - 1) AND semester = 2";


				 $r = mysqli_query(dbc(),$q); //query the result


				 $row = mysqli_fetch_array($r, MYSQLI_ASSOC);

				 $output = $row['remark2'];


	}
	else if ($level == 'III' AND $semester == '2')
	{
		$q = "SELECT remark2
			FROM students_results_nce  WHERE student_id = '$user_id'
			AND session_id = $session AND semester = 1";


		 $r = mysqli_query(dbc(),$q); //query the result


		 $row = mysqli_fetch_array($r, MYSQLI_ASSOC);

		 $output = $row['remark2'];


	}// end of if level is III
	else
	{
		//do nothing for now
	}


	//$return = ($output0 != '' ? $output = $outputv : $output = false); //return false if there is no value as there wound


	return $output;

}//end of get previous semester gpa to pass to academic withdrawal function



//function to get academic withdraw for the last semester prence
function get_previous_remark2_prence($user_id,$programme_id,$level,$session,$semester)
{

	//manipulate getting old session
	$manipulated_session = $session - 1;

	////manipulate getting old semester
	$manipulated_semester = $semester - 1;


	if($level == 'PRE' AND $semester == '1')
	{
		$output = '';
	}
	else if ($level == 'PRE' AND $semester == '2')
	{

		$q = "SELECT remark2
		  FROM students_results_prence  WHERE student_id = '$user_id'
		  AND programme_id = '$programme_id' AND session_id = '$session' AND semester = '$manipulated_semester'";


		 $r = mysqli_query(dbc(),$q); //query the result
		 $row = mysqli_fetch_array($r, MYSQLI_ASSOC);

		 $output = $row['remark2'];



	}
	else
	{
		//do nothing for now
	}


	//$return = ($output0 != '' ? $output = $outputv : $output = false); //return false if there is no value as there wound


	return $output;

}//end of get previous semester gpa to pass to academic withdrawal function for prence



//get remark for cummulative for outstanding courses or not
function get_remark_for_cummulative_per_student_nce($user_id,$programme_id,$level,$session,$semester)
{

		  //check if there is carry over
		  if(carry_over_exists_per_student_nce($user_id,$programme_id, $level, $session, $semester))
		  {
		  	//return OC if a student has outstanding course
		  	return 'OC';

		  }
		  else
		  {

		  	//means all passed
		  		return 'PASSED';

		  }


		// if($level == 'I' AND $semester == '1')
		// {
		//
		// 	$q = "SELECT course_id
		// 		  FROM students_courses_nce  WHERE student_id = '$user_id'  AND level = '$level'
		// 		  AND programme_id = '$programme_id' AND session_id = '$session'
		// 		  AND semester = '$semester' AND total_score < 40";
		// 	$r = mysqli_query(dbc(),$q);
		//
		//
		//     ////if there is carry over
		// 	if(mysqli_num_rows($r) > 0)
		// 	{
		// 		return 'OC';
		// 	}
		// 	else
		// 	{
		// 		return 'PASSED';
		//
		// 	}
		//
		// }//end of if $level is  I and $seemster is 1
		// // else if($level == 'I' AND $semester == '2')
		// {
		// 	$q = "SELECT course_id
		// 		  FROM students_courses_nce  WHERE student_id = $user_id  AND level = '$level'
		// 		  AND programme_id = $programme_id AND total_score < 40";
		// 	$r = mysqli_query(dbc(),$q);
		//
		//
		//     ////if there is carry over
		// 	if(mysqli_num_rows($r) > 0)
		// 	{
		// 		return 'OC';
		// 	}
		// 	else
		// 	{
		// 		return 'PASSED';
		//
		// 	}
		//
		// }//end of else if semester is 2 and level is
		// elseif ($level == 'II' AND $semester == '1')
		// {//
		//
		//
		// 	carry_over_exists_per_student_nce($user_id,$programme_id, $level, $session, $semester)
		//
		//
		//     ////if there is carry over
		// 	if(mysqli_num_rows($r) > 0)
		// 	{
		// 		return 'OC';
		// 	}
		// 	else
		// 	{
		// 		return 'PASSED';
		//
		// 	}
		//
		// 	// code...
		// }//end of if $level is II and semester is I
		// else if ($level == 'II' AND $semester == '2')
		// {
		// 	// code...
		// }
		// else if ($level == 'III' AND $semester == '1')
		// {
		// 	// code...
		// }
		// else if ($level == 'III' AND $semester == '2')
		// {
		// 	// code...
		// }


}//get remark for cummulative



//get remark for cummulative for outstanding courses or not prence
function get_remark_for_cummulative_per_student_prence($user_id,$programme_id,$level,$session,$semester)
{

		  //check if there is carry over
		  if(carry_over_exists_per_student_prence($user_id,$programme_id, $level, $session, $semester))
		  {
		  	//return OC if a student has outstanding course
		  	return 'OC';

		  }
		  else
		  {

				if($semester == 1)
				{

		  	//means all passed

				//return 'PASSED';

				}
				else
				{
					return '';
				}

		  }




}//get remark for cummulative prence`




//function dat check if student have carry over  per student
function carry_over_exists_per_student_nce($user_id,$programme_id, $level, $session, $semester)
{

	if($level == 'I' AND $semester == '1')
	{

		$q = "SELECT course_id
			  FROM students_courses_nce  WHERE student_id = '$user_id'  AND level = '$level'
			  AND programme_id = '$programme_id' AND session_id = '$session'
			  AND semester = '$semester' AND total_score < 40";
		$r = mysqli_query(dbc(),$q);


	    ////if there is carry over
		if(mysqli_num_rows($r) > 0)
		{
			return true;
		}
		else
		{
			return false;

		}

	}
	else if ($level == 'I' AND $semester == '2')
	{
		$q = "SELECT course_id
			  FROM students_courses_nce  WHERE student_id = '$user_id'  AND level = '$level'
			  AND programme_id = '$programme_id' AND total_score < 40";
		$r = mysqli_query(dbc(),$q);


				////if there is carry over
			if(mysqli_num_rows($r) > 0)
			{
				return true;
			}
			else
			{
				return false;

			}

	}//end of else of level //
	else if($level == 'II' AND $semester == '1')
	{

					//get for first semseter level I
					$q1 = "SELECT remark1
							FROM students_results_nce  WHERE  student_id = $user_id  AND session_id = ($session - 1) AND semester = 1";
					$r1 = mysqli_query(dbc(),$q1);

					$row1 = mysqli_fetch_assoc($r1);

					$remark1 = $row1['remark1'];

					//get for second semester level II
					$q2 = "SELECT remark1
							FROM students_results_nce  WHERE  student_id = $user_id  AND session_id = ($session - 1) AND semester = 2";
					$r2 = mysqli_query(dbc(),$q2);

					$row2 = mysqli_fetch_assoc($r2);

					$remark12 = $row2['remark1'];

					$remark_concat = $remark1.','.$remark12;


					// //get current semester
					// $q12 = "SELECT GROUP_CONCAT(course_id)  AS comma_separated_courses
					// 			FROM students_courses_nce  WHERE student_id = $user_id
					// 			AND session_id = ($session - 1)  AND total_score < 40";
					//
					//
					// $r12 = mysqli_query(dbc(),$q12);
					//
					//
					// $output12 = '';
					//
					// if(mysqli_num_rows($r12) > 0 )
					// {
					// 	$row12 = mysqli_fetch_array($r12, MYSQLI_ASSOC);
					//
					// 	$remark_concat = $row12['comma_separated_courses'];
					//
					//
					// 	//remove the duplicate courses for the outstandin
					//
					// }//end of if there is value
					// else
					// {
					// 	$remark_concat = '';
					// } //end if if candidate has oC


					//do so


					//get current semester
					$q3 = "SELECT GROUP_CONCAT(course_id)  AS comma_separated_courses
								FROM students_courses_nce  WHERE student_id = $user_id  AND level = '$level'
								AND session_id = $session AND semester = $semester AND total_score < 40";


					$r3 = mysqli_query(dbc(),$q3);


					$output = '';

					if(mysqli_num_rows($r3) > 0 )
					{
						$row3 = mysqli_fetch_array($r3, MYSQLI_ASSOC);

						$output = $row3['comma_separated_courses'];

						$output = $remark_concat.','.$output;
						//$output = $remark_concat.','$output;


						$passed_courses = get_students_passed_courses_per_semester_nce($user_id,$programme_id, $level, $session, $semester);


						//remove the duplicate courses for the outstandin

						$output = implode(',', array_filter(array_unique(explode(',', $output))));  //array unique removed duplicate ids // array filter removes empty courses


						$output = array_diff(explode(',' , $output), explode(',' , $passed_courses));


						//implode back t strings
						$output = implode(',', $output);


					}//end of if there is value
					else
					{
						$output = '';
					} //end if if candidate has oC


					if(!empty($output))
					{
						return true;
					}
					else
					{
						return false;

					}

	}//end of if level is II and semester is 1
	else if($level == 'II' AND $semester == '2')
	{
					//get for first semseter level I
					$q1 = "SELECT remark1
							FROM students_results_nce  WHERE  student_id = $user_id  AND session_id = $session  AND semester = 1";
					$r1 = mysqli_query(dbc(),$q1);

					$row1 = mysqli_fetch_assoc($r1);

					$remark1 = $row1['remark1'];


					//get current semester
					$q3 = "SELECT GROUP_CONCAT(course_id)  AS comma_separated_courses
								FROM students_courses_nce  WHERE student_id = $user_id  AND level = '$level'
								AND session_id = $session AND semester = $semester AND total_score < 40";


					$r3 = mysqli_query(dbc(),$q3);


					$output = '';

					if(mysqli_num_rows($r3) > 0 )
					{
						$row3 = mysqli_fetch_array($r3, MYSQLI_ASSOC);

						$output = $row3['comma_separated_courses'];

						$output = $remark1.','.$output;
						//remove the duplicate courses for the outstandin

						//$output = implode(',', array_filter(array_unique(explode(',', $output))));  //array unique removed duplicate ids // array filter removes empty courses

						$passed_courses = get_students_passed_courses_per_semester_nce($user_id,$programme_id, $level, $session, $semester);


						//remove the duplicate courses for the outstandin

						$output = implode(',', array_filter(array_unique(explode(',', $output))));  //array unique removed duplicate ids // array filter removes empty courses


						$output = array_diff(explode(',' , $output), explode(',' , $passed_courses));


						//implode back t strings
						$output = implode(',', $output);


					}//end of if there is value
					else
					{
						$output = '';
					} //end if if candidate has oC


					if(!empty($output))
					{
						return true;
					}
					else
					{
						return false;

					}

	}//end of if level is II and semester is 2
	else if($level == 'III' AND $semester == '1')
	{

		//automatically adds the TP course as an outsanding course for the reason that you must pass and pick TP as course before graudation
		$tp_course_id = '';
		$tp_course_id = get_tp_course_id();


					//get for first semseter level I
					$q1 = "SELECT remark1
							FROM students_results_nce  WHERE  student_id = $user_id  AND session_id = ($session - 1)  AND semester = 2";
					$r1 = mysqli_query(dbc(),$q1);

					$row1 = mysqli_fetch_assoc($r1);

					$remark1 = $row1['remark1'];


					//get current semester
					$q3 = "SELECT GROUP_CONCAT(course_id)  AS comma_separated_courses
								FROM students_courses_nce  WHERE student_id = $user_id  AND level = '$level'
								AND session_id = $session AND semester = $semester AND total_score < 40";


					$r3 = mysqli_query(dbc(),$q3);


					$output = '';

					if(mysqli_num_rows($r3) > 0 )
					{
						$row3 = mysqli_fetch_array($r3, MYSQLI_ASSOC);

						$output = $row3['comma_separated_courses'];

						$output = $remark1.','.$output.','.$tp_course_id;
						//remove the duplicate courses for the outstandin

						//$output = implode(',', array_filter(array_unique(explode(',', $output))));  //array unique removed duplicate ids // array filter removes empty courses

						$passed_courses = get_students_passed_courses_per_semester_nce($user_id,$programme_id, $level, $session, $semester);


						//remove the duplicate courses for the outstandin

						$output = implode(',', array_filter(array_unique(explode(',', $output))));  //array unique removed duplicate ids // array filter removes empty courses


						$output = array_diff(explode(',' , $output), explode(',' , $passed_courses));


						//implode back t strings
						$output = implode(',', $output);


					}//end of if there is value
					else
					{
						$output = '';
					} //end if if candidate has oC


					//check if it has carry over
					if(!empty($output))
					{
						return true;
					}
					else
					{
						return false;

					}

	}//end of if level is III and semester is 1
	else if($level == 'III' AND $semester == '2')
	{

					//get for first semseter level I
					$q1 = "SELECT remark1
							FROM students_results_nce  WHERE  student_id = $user_id  AND session_id = $session  AND semester = 1";
					$r1 = mysqli_query(dbc(),$q1);

					$row1 = mysqli_fetch_assoc($r1);

					$remark1 = $row1['remark1'];


					//get current semester
					$q3 = "SELECT GROUP_CONCAT(course_id)  AS comma_separated_courses
								FROM students_courses_nce  WHERE student_id = $user_id  AND level = '$level'
								AND session_id = $session AND semester = $semester AND total_score < 40";


					$r3 = mysqli_query(dbc(),$q3);


					$output = '';

					if(mysqli_num_rows($r3) > 0 )
					{
						$row3 = mysqli_fetch_array($r3, MYSQLI_ASSOC);

						$output = $row3['comma_separated_courses'];

						$output = $remark1.','.$output; //bind the output with TP course
						//remove the duplicate courses for the outstandin

						//$output = implode(',', array_filter(array_unique(explode(',', $output))));  //array unique removed duplicate ids // array filter removes empty courses

						$passed_courses = get_students_passed_courses_per_semester_nce($user_id,$programme_id, $level, $session, $semester);


						//remove the duplicate courses for the outstandin

						$output = implode(',', array_filter(array_unique(explode(',', $output))));  //array unique removed duplicate ids // array filter removes empty courses


						$output = array_diff(explode(',' , $output), explode(',' , $passed_courses));


						//implode back t strings
						$output = implode(',', $output);


					}//end of if there is value
					else
					{
						$output = '';
					} //end if if candidate has oC


					//check if it has carry over
					if(!empty($output))
					{
						return true;
					}
					else
					{
						return false;

					}

	}//end of if level is III and semester is 2



}//is there carry over per user...


//function dat check if student have carry over  per student prence
function carry_over_exists_per_student_prence($user_id,$programme_id, $level, $session, $semester)
{

	if($level == 'PRE' AND $semester == '1')
	{

		$q = "SELECT course_id
			  FROM students_courses_prence  WHERE student_id = '$user_id'  AND level = '$level'
			  AND programme_id = '$programme_id' AND session_id = '$session'
			  AND semester = '$semester' AND total_score < 40";
		$r = mysqli_query(dbc(),$q);


	    ////if there is carry over
		if(mysqli_num_rows($r) > 0)
		{
			return true;
		}
		else
		{
			return false;

		}

	}
	else if ($level == 'PRE' AND $semester == '2')
	{
		$q = "SELECT course_id
			  FROM students_courses_prence  WHERE student_id = '$user_id'  AND level = '$level'
			  AND programme_id = '$programme_id' AND total_score < 40";
		$r = mysqli_query(dbc(),$q);


				////if there is carry over
			if(mysqli_num_rows($r) > 0)
			{
				return true;
			}
			else
			{
				return false;

			}

	}//end of else of level // PRE



}//is there carry over per user... prence

//function dat check if student have carry over  student id by matric number
function carry_over_exists_per_programme_nce($programme_id, $level, $session, $semester)
{
	$q = "SELECT course_id
		  FROM students_courses_nce  WHERE  level = '$level' AND session_id = '$session'
		  AND programme_id = '$programme_id' AND semester = '$semester' AND total_score < 40";
	$r = mysqli_query(dbc(),$q);


    ////if there is carry over
	if(mysqli_num_rows($r) > 0)
	{
		return true;
	}
	else
	{
		return false;

	}


}//is there carry over per programme...




//function tha counts how many carry overs  per user
//this should be per semester for now and to stop in the level I going forward we have to work to get the general or
// level II or III own by not including the current session
function count_carry_overs_per_student_nce($user_id,$programme_id, $level, $session, $semester)
{

	if($level == 'I' AND $semester == '1')
	{
					$q = "SELECT COUNT(course_id)
					  	  FROM students_courses_nce  WHERE student_id = '$user_id'  AND level = '$level'
					  	  AND programme_id = '$programme_id' AND session_id = '$session' AND semester = '$semester'
					  	  AND total_score < 40";


					$r = mysqli_query(dbc(),$q);

					$row = mysqli_fetch_array($r, MYSQLI_NUM);

					return number_format($row[0]);

	}
	else if ($level == 'I' AND $semester == '2')
	{
					$q = "SELECT COUNT(course_id)
					  	  FROM students_courses_nce  WHERE student_id = '$user_id'  AND level = '$level'
					  	  AND programme_id = '$programme_id' AND session_id = '$session'
					  	  AND total_score < 40"; //AND semester = '$semester'

					$r = mysqli_query(dbc(),$q);

					$row = mysqli_fetch_array($r, MYSQLI_NUM);

					return number_format($row[0]);


	}
	else if ($level == 'II' AND $semester == 1)
	{
		//get previous semester own and join it with new semester own
		//get for first semseter level I
				$q1 = "SELECT remark1
						FROM students_results_nce  WHERE  student_id = $user_id  AND session_id = ($session - 1) AND semester = 1";
				$r1 = mysqli_query(dbc(),$q1);

				$row1 = mysqli_fetch_assoc($r1);

				$remark1 = $row1['remark1'];

				//get for second semester level II
				$q2 = "SELECT remark1
						FROM students_results_nce  WHERE  student_id = $user_id  AND session_id = ($session - 1) AND semester = 2";
				$r2 = mysqli_query(dbc(),$q2);

				$row2 = mysqli_fetch_assoc($r2);

				$remark12 = $row2['remark1'];

				$remark_concat = $remark1.','.$remark12;

				//do so


				//get current semester
				$q3 = "SELECT GROUP_CONCAT(course_id)  AS comma_separated_courses
							FROM students_courses_nce  WHERE student_id = $user_id  AND level = '$level'
							AND session_id = $session AND semester = $semester AND total_score < 40";


				$r3 = mysqli_query(dbc(),$q3);


				$output = '';

				// if(mysqli_num_rows($r3) > 0 )
				// {
					$row3 = mysqli_fetch_array($r3, MYSQLI_ASSOC);

					$output = $row3['comma_separated_courses'];

					$output = $remark_concat.','.$output;
					//remove the duplicate courses for the outstandin

					//get passed courses first
					$passed_courses = get_students_passed_courses_per_semester_nce($user_id,$programme_id, $level, $session, $semester);



					$output = implode(',', array_filter(array_unique(explode(',', $output))));  //array unique removed duplicate ids // array filter removes empty courses


					//array_diff() compares two arrays and remve the ones that matches each other, thus returns only the ones that the didnt m

					$output = array_diff(explode(',' , $output), explode(',' , $passed_courses));


					//implode back t strings
					$output = implode(',', $output);

					//before counting u need to see eliminate the passed courses
					//count the filterd array using
					$count_output = !empty(explode(',', $output)) ? count(explode(',', $output)) : '';

					return $count_output;


	}
	else if ($level == 'II' AND $semester == '2')
	{


		//get for first semseter level I
				$q1 = "SELECT remark1
						FROM students_results_nce  WHERE  student_id = $user_id  AND session_id = $session AND semester = 1";
				$r1 = mysqli_query(dbc(),$q1);

				$row1 = mysqli_fetch_assoc($r1);

				$remark1 = $row1['remark1'];



				//get current semester
				$q3 = "SELECT GROUP_CONCAT(course_id)  AS comma_separated_courses
							FROM students_courses_nce  WHERE student_id = $user_id  AND level = '$level'
							AND session_id = $session AND semester = $semester AND total_score < 40";


				$r3 = mysqli_query(dbc(),$q3);


				$output = '';

				// if(mysqli_num_rows($r3) > 0 )
				// {
					$row3 = mysqli_fetch_array($r3, MYSQLI_ASSOC);

					$output = $row3['comma_separated_courses'];

					$output = $remark1.','.$output;

					//remove the duplicate courses for the outstandin

					//get passed courses first
					$passed_courses = get_students_passed_courses_per_semester_nce($user_id,$programme_id, $level, $session, $semester);



					$output = implode(',', array_filter(array_unique(explode(',', $output))));  //array unique removed duplicate ids // array filter removes empty courses


					//array_diff() compares two arrays and remve the ones that matches each other, thus returns only the ones that the didnt m

					$output = array_diff(explode(',' , $output), explode(',' , $passed_courses));


					//implode back t strings
					$output = implode(',', $output);

					//before counting u need to see eliminate the passed courses
					//count the filterd array using
					$count_output = !empty(explode(',', $output)) ? count(explode(',', $output)) : '';

					return $count_output;



	}
	else if ($level == 'III' AND $semester == '1')
	{

					//automatically assign TP as a compulsary course
					$tp_course_id = '';
					$tp_course_id = get_tp_course_id();


					//get previous semester own and join it with new semester own
					$q1 = "SELECT remark1
					FROM students_results_nce  WHERE  student_id = $user_id  AND session_id = ($session - 1)  AND semester = 2";
					$r1 = mysqli_query(dbc(),$q1);

					$row1 = mysqli_fetch_assoc($r1);

					$remark1 = $row1['remark1'];


					// //get for second semester level II
					// $q2 = "SELECT remark1
					// 		FROM students_results_nce  WHERE  student_id = $user_id  AND session_id = $session AND semester = 1";
					// $r2 = mysqli_query(dbc(),$q2);
					//
					// $row2 = mysqli_fetch_assoc($r2);
					//
					// $remark12 = $row2['remark1'];

					//$remark_concat = $remark1.','.$remark12;



					//get current semester
					$q3 = "SELECT GROUP_CONCAT(course_id)  AS comma_separated_courses
								FROM students_courses_nce  WHERE student_id = $user_id  AND level = '$level'
								AND session_id = $session AND semester = $semester AND total_score < 40";


					$r3 = mysqli_query(dbc(),$q3);


					$output = '';

					// if(mysqli_num_rows($r3) > 0 )
					// {
						$row3 = mysqli_fetch_array($r3, MYSQLI_ASSOC);

						$output = $row3['comma_separated_courses'];

						//$output = $remark_concat.','.$output;

						$output = $remark1.','.$output.','.$tp_course_id;

						//remove the duplicate courses for the outstandin

						//get passed courses first
						$passed_courses = get_students_passed_courses_per_semester_nce($user_id,$programme_id, $level, $session, $semester);



						$output = implode(',', array_filter(array_unique(explode(',', $output))));  //array unique removed duplicate ids // array filter removes empty courses


						//array_diff() compares two arrays and remve the ones that matches each other, thus returns only the ones that the didnt m

						$output = array_diff(explode(',' , $output), explode(',' , $passed_courses));


						//implode back t strings
						$output = implode(',', $output);

						//before counting u need to see eliminate the passed courses
						//count the filterd array using
						$count_output = !empty(explode(',', $output)) ? count(explode(',', $output)) : '';

						return $count_output;
	}
	else if ($level == 'III' AND $semester == '2')
	{
		// return counted cos




		$q1 = "SELECT remark1
		FROM students_results_nce  WHERE  student_id = $user_id  AND session_id = $session  AND semester = 1";
		$r1 = mysqli_query(dbc(),$q1);

		$row1 = mysqli_fetch_assoc($r1);

		$remark1 = $row1['remark1'];



		//get current semester
		$q3 = "SELECT GROUP_CONCAT(course_id)  AS comma_separated_courses
					FROM students_courses_nce  WHERE student_id = $user_id  AND level = '$level'
					AND session_id = $session AND semester = $semester AND total_score < 40";


		$r3 = mysqli_query(dbc(),$q3);


		$output = '';

		// if(mysqli_num_rows($r3) > 0 )
		// {
			$row3 = mysqli_fetch_array($r3, MYSQLI_ASSOC);

			$output = $row3['comma_separated_courses'];

			$output = $remark1.','.$output;
			//remove the duplicate courses for the outstandin

			$passed_courses = get_students_passed_courses_per_semester_nce($user_id,$programme_id, $level, $session, $semester); //get the courses the student has passed



			$output = implode(',', array_filter(array_unique(explode(',', $output))));  //array unique removed duplicate ids // array filter removes empty courses


			//array_diff() compares two arrays and remve the ones that matches each other, thus returns only the ones that the didnt m

			$output = array_diff(explode(',' , $output), explode(',' , $passed_courses));


			//implode back t strings
			$output = implode(',', $output);

			//before counting u need to see eliminate the passed courses
			//count the filterd array using
			$count_output = !empty(explode(',', $output)) ? count(explode(',', $output)) : '';

			return $count_output;
	}


	// $r = mysqli_query(dbc(),$q);
	//
	// $row = mysqli_fetch_array($r, MYSQLI_NUM);
	//
	// return number_format($row[0]);


}//end of function to count how many carry overs per user


// levelprence own by not including the current session
function count_carry_overs_per_student_prence($user_id,$programme_id, $level, $session, $semester)
{

	if($level == 'PRE' AND $semester == '1')
	{
					$q = "SELECT COUNT(course_id)
					  	  FROM students_courses_prence  WHERE student_id = '$user_id'  AND level = '$level'
					  	  AND programme_id = '$programme_id' AND session_id = '$session' AND semester = '$semester'
					  	  AND total_score < 40";


					$r = mysqli_query(dbc(),$q);

					$row = mysqli_fetch_array($r, MYSQLI_NUM);

					return number_format($row[0]);

	}
	else if ($level == 'PRE' AND $semester == '2')
	{
					$q = "SELECT COUNT(course_id)
					  	  FROM students_courses_prence  WHERE student_id = '$user_id'  AND level = '$level'
					  	  AND programme_id = '$programme_id' AND session_id = '$session'
					  	  AND total_score < 40"; //AND semester = '$semester'

					$r = mysqli_query(dbc(),$q);

					$row = mysqli_fetch_array($r, MYSQLI_NUM);

					return number_format($row[0]);


	}





}//end of function to count how many carry overs per user prence





//function tha counts how many carry overs  per programmes
function count_carry_overs_per_programme_nce($programme_id, $level, $session, $semester)
{
	$q = "SELECT COUNT(course_id)
		  FROM students_courses_nce  WHERE  level = '$level' AND programme_id = '$programme_id' AND session_id = '$session' AND semester = '$semester' AND total_score < 40";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_array($r, MYSQLI_NUM);

	return number_format($row[0]);


}//end of function to count how many carry overs per programmes



//count total students in programme after result is processed
function get_count_total_students_per_programme_nce_pdf($programme_id, $level, $session, $semester)
{
	$q = "SELECT COUNT(id) AS total
		  FROM students_results_nce   WHERE  level = '$level' AND programme_id = $programme_id AND session_id = $session AND semester = $semester";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['total']);


}//end of function to count how many carry overs per programmes


//count total expelled or suspended
function get_count_total_students_sus_exp_per_programme_nce_pdf($programme_id, $level, $session, $semester)
{
	$q = "SELECT COUNT(id) AS total
		  FROM students_nce   WHERE  level = '$level' AND programme_id = $programme_id  AND validity_status > 0";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['total']);


}//end of function to count how many carry overs per programmes

//function tha counts how many studnets passed  per programmes -- students dat passed by all courses withou deficiency
function get_count_passed_students_per_programme_nce($programme_id, $level, $session, $semester)
{
	$q = "SELECT passed
		  FROM students_results_programme_remark_nce  WHERE  level = '$level' AND programme_id = '$programme_id' AND session_id = '$session' AND semester = '$semester'";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['passed']);


}//end of function to count how many carry overs per programmes


//count passed by real time
function get_count_passed_students_per_programme_nce_pdf($programme_id, $level, $session, $semester)
{
	$q = "SELECT COUNT(id) AS passed
		    FROM students_results_nce   WHERE  level = '$level' AND programme_id = $programme_id AND session_id = $session AND semester = $semester
				AND (`remark2` LIKE '%LOWER PASS%'
	      OR `remark2` LIKE '%PASS%'
	      OR `remark2` LIKE '%MERIT%'
	      OR `remark2` LIKE '%CREDIT%'
	      OR `remark2` LIKE '%DISTINCTION%')";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['passed']);


}//end of function to count how many carry overs per programmes




//function tha counts how many studnets passed  per programmes -- students dat passed by all courses withou deficiency prence
function get_count_passed_students_per_programme_prence($programme_id, $level, $session, $semester)
{
	$q = "SELECT passed
		  FROM students_results_programme_remark_prence  WHERE  level = '$level' AND programme_id = '$programme_id' AND session_id = '$session' AND semester = '$semester'";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['passed']);


}//end of function to count how many carry overs per programmes



//function tha counts how many studnets reoffers  per programmes -- students dat reoffers by all courses
function get_count_reoffers_students_per_programme_nce($programme_id, $level, $session, $semester)
{
	$q = "SELECT reoffers
		  FROM students_results_programme_remark_nce  WHERE  level = '$level' AND programme_id = '$programme_id' AND session_id = '$session' AND semester = '$semester'";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['reoffers']);


}//end of function to count how many students that failed




//function tha counts how many studnets reoffers  per programmes -- students dat reoffers by all courses PDF
function get_count_reoffers_students_per_programme_nce_pdf($programme_id, $level, $session, $semester)
{
	$q = "SELECT  COUNT(id) AS reoffers
		  FROM students_results_nce   WHERE  level = '$level' AND programme_id = '$programme_id' AND session_id = '$session' AND semester = '$semester' AND remark2 LIKE '%OC%'";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['reoffers']);


}//end of function to count how many students that failed




//function tha counts how many studnets reoffers  per programmes -- students dat reoffers by all courses for prence
function get_count_reoffers_students_per_programme_prence($programme_id, $level, $session, $semester)
{
	$q = "SELECT reoffers
		  FROM students_results_programme_remark_prence  WHERE  level = '$level' AND programme_id = '$programme_id' AND session_id = '$session' AND semester = '$semester'";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['reoffers']);


}//end of function to count how many students that failed prence



//function tha counts how many studnets  on probation  per programmes --
function get_count_probation_students_per_programme_nce($programme_id, $level, $session, $semester)
{
	$q = "SELECT probation
		  FROM students_results_programme_remark_nce  WHERE  level = '$level' AND programme_id = '$programme_id' AND session_id = '$session' AND semester = '$semester'";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['probation']);


}//end of function to count how many students that are on probation


//function tha counts how many studnets  on probation  per programmes -- PDF
function get_count_probation_students_per_programme_nce_pdf($programme_id, $level, $session, $semester)
{
	$q = "SELECT COUNT(id) AS probation
		  FROM students_results_nce   WHERE  level = '$level' AND programme_id = '$programme_id' AND session_id = '$session' AND semester = '$semester' AND remark2 LIKE '%PROB%'";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['probation']);


}//end of function to count how many students that are on probation




//function tha counts how many studnets  on probation  per programmes -- for prence
function get_count_probation_students_per_programme_prence($programme_id, $level, $session, $semester)
{
	$q = "SELECT probation
		  FROM students_results_programme_remark_prence  WHERE  level = '$level' AND programme_id = '$programme_id' AND session_id = '$session' AND semester = '$semester'";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['probation']);


}//end of function to count how many students that are on probation prence



//function tha counts how many studnets  on academic with drawal  per programmes --
function get_count_acad_with_students_per_programme_nce($programme_id, $level, $session, $semester)
{
	$q = "SELECT acad_with
		  FROM students_results_programme_remark_nce  WHERE  level = '$level' AND programme_id = '$programme_id' AND session_id = '$session' AND semester = '$semester'";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['acad_with']);


}//end of function to count how many students that are on acad withdrawal



//function tha counts how many studnets  on academic with drawal  per programmes -- PDF
function get_count_acad_with_students_per_programme_nce_pdf($programme_id, $level, $session, $semester)
{
	$q = "SELECT COUNT(id) AS acad_with
		  FROM students_results_nce   WHERE  level = '$level' AND programme_id = '$programme_id' AND session_id = '$session' AND semester = '$semester' AND remark2 LIKE '%ACAD WITH%' ";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['acad_with']);


}//end of function to count how many students that are on acad withdrawal


//function tha counts how many studnets  on academic with drawal  per programmes -- for prence
function get_count_acad_with_students_per_programme_prence($programme_id, $level, $session, $semester)
{
	$q = "SELECT acad_with
		  FROM students_results_programme_remark_prence  WHERE  level = '$level' AND programme_id = '$programme_id' AND session_id = '$session' AND semester = '$semester'";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['acad_with']);


}//end of function to count how many students that are on acad withdrawal for prence




//function tha counts how many studnets  volunatry withdrawal   per programmes --
function get_count_vol_with_students_per_programme_nce($programme_id, $level, $session, $semester)
{
	$q = "SELECT vol_with
		  FROM students_results_programme_remark_nce  WHERE  level = '$level' AND programme_id = $programme_id AND session_id = $session AND semester = $semester";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['vol_with']);


}//end of function to count how many students that are on acad withdrawal



//function tha counts how many studnets  volunatry withdrawal   per programmes --
function get_count_vol_with_students_per_programme_nce_pdf($programme_id, $level, $session, $semester)
{
	$q = "SELECT COUNT(id) AS vol_with
		  FROM students_results_nce   WHERE  level = '$level' AND programme_id = $programme_id AND session_id = $session AND semester = $semester AND reamrk2 LIKE '%VOL WITH%'";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['vol_with']);


}//end of function to count how many students that are on acad withdrawal


//function tha counts how many studnets  volunatry withdrawal   per programmes -- prence
function get_count_vol_with_students_per_programme_prence($programme_id, $level, $session, $semester)
{
	$q = "SELECT vol_with
		  FROM students_results_programme_remark_prence  WHERE  level = '$level' AND programme_id = $programme_id AND session_id = $session AND semester = $semester";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['vol_with']);


}//end of function to count how many students that are on acad withdrawal prence


//function tha counts how many studnets  lower pass   per programmes -- prence
function get_count_lower_pass_students_per_programme_prence($programme_id, $level, $session, $semester)
{
	$q = "SELECT lower_pass
		  FROM students_results_programme_remark_prence  WHERE  level = '$level' AND programme_id = $programme_id AND session_id = $session AND semester = $semester";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['lower_pass']);


}//end of function to count how many students that are on lower_pass prence



//function tha counts how many studnets pass   per programmes -- prence
function get_count_pass_students_per_programme_prence($programme_id, $level, $session, $semester)
{
	$q = "SELECT pass
		  FROM students_results_programme_remark_prence  WHERE  level = '$level' AND programme_id = $programme_id AND session_id = $session AND semester = $semester";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['pass']);


}//end of function to count how many students that are on pass prence


//function tha counts how many studnets merit   per programmes -- prence
function get_count_merit_students_per_programme_prence($programme_id, $level, $session, $semester)
{
	$q = "SELECT merit
		  FROM students_results_programme_remark_prence  WHERE  level = '$level' AND programme_id = $programme_id AND session_id = $session AND semester = $semester";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['merit']);


}//end of function to count how many students that are on merit prence



//function tha counts how many studnets credit   per programmes -- prence
function get_count_credit_students_per_programme_prence($programme_id, $level, $session, $semester)
{
	$q = "SELECT credit
		  FROM students_results_programme_remark_prence  WHERE  level = '$level' AND programme_id = $programme_id AND session_id = $session AND semester = $semester";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['credit']);


}//end of function to count how many students that are on Credit prence



//function tha counts how many studnets DISTINCTION   per programmes -- prence
function get_count_distinction_students_per_programme_prence($programme_id, $level, $session, $semester)
{
	$q = "SELECT distinction
		  FROM students_results_programme_remark_prence  WHERE  level = '$level' AND programme_id = $programme_id AND session_id = $session AND semester = $semester";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['distinction']);


}//end of function to count how many students that are on distinction prence


//get outstanding courses OC for particular students in comma separated values
function get_oc_courses_nce($user_id,$programme_id, $level, $session, $semester)
{


	//check if level is I and semester is 1
	if($level == 'I' AND $semester == 1)
	{
				$q = "SELECT GROUP_CONCAT(course_id)  AS comma_separated_courses
				  	  FROM students_courses_nce  WHERE student_id = $user_id  AND level = '$level'
				  	  AND programme_id = $programme_id AND session_id = $session AND semester = $semester
				  	  AND total_score < 40";

				$r = mysqli_query(dbc(),$q);
				$output = '';

				if(mysqli_num_rows($r) > 0 )
				{
					$row = mysqli_fetch_array($r, MYSQLI_ASSOC);

					$output = $row['comma_separated_courses'];

				}//end of if there is value
				else
				{
					$output = '';
				} //end if if candidate has oC

	}
	else if($level == 'I' AND $semester == 2)
	{

				$q = "SELECT GROUP_CONCAT(course_id)  AS comma_separated_courses
							FROM students_courses_nce  WHERE student_id = $user_id  AND level = '$level'
							AND programme_id = $programme_id AND session_id = $session AND semester = $semester
							AND total_score < 40";


				$r = mysqli_query(dbc(),$q);


				$output = '';

				if(mysqli_num_rows($r) > 0 )
				{
					$row = mysqli_fetch_array($r, MYSQLI_ASSOC);

					$output = $row['comma_separated_courses'];

				}//end of if there is value
				else
				{
					$output = '';
				} //end if if candidate has oC

	}//end of level is I and sems is 2
	else if($level == 'II' AND $semester == 1)
	{


			//get for first semseter level I
			$q1 = "SELECT remark1
					FROM students_results_nce  WHERE  student_id = $user_id  AND session_id = ($session - 1) AND semester = 1";
			$r1 = mysqli_query(dbc(),$q1);

			$row1 = mysqli_fetch_assoc($r1);

			$remark1 = $row1['remark1'];



			//get for second semester level II
			$q2 = "SELECT remark1
					FROM students_results_nce  WHERE  student_id = $user_id  AND session_id = ($session - 1) AND semester = 2";
			$r2 = mysqli_query(dbc(),$q2);

			$row2 = mysqli_fetch_assoc($r2);

			$remark12 = $row2['remark1'];

			//$remark_concat = $remark1.','.$remark12;

			//get current semester
			$q3 = "SELECT GROUP_CONCAT(course_id)  AS comma_separated_courses
						FROM students_courses_nce  WHERE student_id = $user_id  AND level = '$level'
						AND session_id = $session AND semester = $semester AND total_score < 40";


			$r3 = mysqli_query(dbc(),$q3);


			$output = '';

			if(mysqli_num_rows($r3) > 0 )
			{
				$row3 = mysqli_fetch_array($r3, MYSQLI_ASSOC);

				$output = $row3['comma_separated_courses'];


			//	$compared_array = array_diff($remark1, $output);

				//check if

				$remark_concat = $remark1.','.$remark12;


				$output = $remark_concat.','.$output; //test

				//$output = $output.','.$remark_concat; //test



				//remove the duplicate courses for the outstanding

				//empty courses exampls 23,24,,28,90
				//duplicate courses example 23,23,24,28,28,90

				//remove the empty ones first


				$passed_courses = get_students_passed_courses_per_semester_nce($user_id,$programme_id, $level, $session, $semester);

				$output = implode(',', array_filter(array_unique(explode(',', $output))));  //array unique removed duplicate ids // array filter removes empty courses

				//check all the collect courses and check one by one if any course is passed delete from year 1 to latest year


				//array_diff() compares two arrays and remve the ones that matches each other, thus returns only the ones that the didnt match

				$output = array_diff(explode(',' , $output), explode(',' , $passed_courses));

				$output = implode(',', $output);
				//$output = array_filter($output);


			}//end of if there is value
			else
			{
				$output = '';
			} //end if if candidate has oC

	}
	else if($level == 'II' AND $semester == 2)
	{
		//get for first semseter level I
		$q1 = "SELECT remark1
				FROM students_results_nce  WHERE  student_id = $user_id  AND session_id = $session  AND semester = 1";
		$r1 = mysqli_query(dbc(),$q1);

		$row1 = mysqli_fetch_assoc($r1);

		$remark1 = $row1['remark1'];

		//get current semester
		$q3 = "SELECT GROUP_CONCAT(course_id)  AS comma_separated_courses
					FROM students_courses_nce  WHERE student_id = $user_id  AND level = '$level'
					AND session_id = $session AND semester = $semester AND total_score < 40";


		$r3 = mysqli_query(dbc(),$q3);


		$output = '';

		if(mysqli_num_rows($r3) > 0 )
		{
			$row3 = mysqli_fetch_array($r3, MYSQLI_ASSOC);

			$output = $row3['comma_separated_courses'];


			$output = $remark1.','.$output; //concat with older semester


			//remove the duplicate courses for the outstanding

			//empty courses exampls 23,24,,28,90
			//duplicate courses example 23,23,24,28,28,90 //remove the empty ones first //$output = array_filter($output);


			$passed_courses = get_students_passed_courses_per_semester_nce($user_id,$programme_id, $level, $session, $semester);

			$output = implode(',', array_filter(array_unique(explode(',', $output))));  //array unique removed duplicate ids // array filter removes empty courses

			//check all the collect courses and check one by one if any course is passed delete from year 1 to latest year


			//array_diff() compares two arrays and remve the ones that matches each other, thus returns only the ones that the didnt m

			$output = array_diff(explode(',' , $output), explode(',' , $passed_courses));

			$output = implode(',', $output);

		}//end of if there is value
		else
		{
			$output = '';
		}

	}//end of if level is II and semester is 2
	else if($level == 'III' AND $semester == 1)
	{
			//set the tp as automatic CO

			$tp_course_id = '';
			$tp_course_id = get_tp_course_id();

			//get for first semseter level I
			$q1 = "SELECT remark1
					FROM students_results_nce  WHERE  student_id = $user_id  AND session_id = ($session - 1) AND semester = 2";
			$r1 = mysqli_query(dbc(),$q1);

			$row1 = mysqli_fetch_assoc($r1);

			$remark1 = $row1['remark1'];



			//$remark_concat = $remark1.','.$remark12;

			//get current semester
			$q3 = "SELECT GROUP_CONCAT(course_id)  AS comma_separated_courses
						FROM students_courses_nce  WHERE student_id = $user_id  AND level = '$level'
						AND session_id = $session AND semester = $semester AND total_score < 40";


			$r3 = mysqli_query(dbc(),$q3);


			$output = '';

			if(mysqli_num_rows($r3) > 0 )
			{
				$row3 = mysqli_fetch_array($r3, MYSQLI_ASSOC);

				$output = $row3['comma_separated_courses'];


			//	$compared_array = array_diff($remark1, $output);

				//check if

				//$remark_concat = $remark1.','.$remark12;


				$output = $remark1.','.$output.','.$tp_course_id; //test //add automatic CO of TP or as outstanding

				//$output = $output.','.$remark_concat; //test



				//remove the duplicate courses for the outstanding

				//empty courses exampls 23,24,,28,90
				//duplicate courses example 23,23,24,28,28,90

				//remove the empty ones first


				$passed_courses = get_students_passed_courses_per_semester_nce($user_id,$programme_id, $level, $session, $semester);

				$output = implode(',', array_filter(array_unique(explode(',', $output))));  //array unique removed duplicate ids // array filter removes empty courses

				//check all the collect courses and check one by one if any course is passed delete from year 1 to latest year


				//array_diff() compares two arrays and remve the ones that matches each other, thus returns only the ones that the didnt match

				$output = array_diff(explode(',' , $output), explode(',' , $passed_courses));

				$output = implode(',', $output);
				//$output = array_filter($output);


			}//end of if there is value
			else
			{
				$output = '';
			} //end if if candidate has oC

	}//end of if level is III and Semester is 1
	else if($level == 'III' AND $semester == 2)
	{
		//get for first semseter level I
		$q1 = "SELECT remark1
				FROM students_results_nce  WHERE  student_id = $user_id  AND session_id = $session  AND semester = 1";
		$r1 = mysqli_query(dbc(),$q1);

		$row1 = mysqli_fetch_assoc($r1);

		$remark1 = $row1['remark1'];

		//get current semester
		$q3 = "SELECT GROUP_CONCAT(course_id)  AS comma_separated_courses
					FROM students_courses_nce  WHERE student_id = $user_id  AND level = '$level'
					AND session_id = $session AND semester = $semester AND total_score < 40";


		$r3 = mysqli_query(dbc(),$q3);


		$output = '';

		if(mysqli_num_rows($r3) > 0 )
		{
			$row3 = mysqli_fetch_array($r3, MYSQLI_ASSOC);

			$output = $row3['comma_separated_courses'];


			$output = $remark1.','.$output; //concat with older semester


			//remove the duplicate courses for the outstanding

			//empty courses exampls 23,24,,28,90
			//duplicate courses example 23,23,24,28,28,90 //remove the empty ones first //$output = array_filter($output);


			$passed_courses = get_students_passed_courses_per_semester_nce($user_id,$programme_id, $level, $session, $semester);

			$output = implode(',', array_filter(array_unique(explode(',', $output))));  //array unique removed duplicate ids // array filter removes empty courses

			//check all the collect courses and check one by one if any course is passed delete from year 1 to latest year


			//array_diff() compares two arrays and remve the ones that matches each other, thus returns only the ones that the didnt m

			$output = array_diff(explode(',' , $output), explode(',' , $passed_courses));

			$output = implode(',', $output);

		}//end of if there is value
		else
		{
			$output = '';
		}

	}//end of level is III and semester is 2
	else {
		// code...
	}




	return $output;


}//end of function that get OC for particular students


//get outstanding courses OC for particular students in comma separated values prence
function get_oc_courses_prence($user_id,$programme_id, $level, $session, $semester)
{


	//check if level is PRE and semester is 1
	if($level == 'PRE' AND $semester == 1)
	{
				$q = "SELECT GROUP_CONCAT(course_id)  AS comma_separated_courses
				  	  FROM students_courses_prence  WHERE student_id = $user_id  AND level = '$level'
				  	  AND programme_id = $programme_id AND session_id = $session AND semester = $semester
				  	  AND total_score < 40";

				$r = mysqli_query(dbc(),$q);
				$output = '';

				if(mysqli_num_rows($r) > 0 )
				{
					$row = mysqli_fetch_array($r, MYSQLI_ASSOC);

					$output = $row['comma_separated_courses'];

				}//end of if there is value
				else
				{
					$output = '';
				} //end if if candidate has oC

	}
	else if($level == 'PRE' AND $semester == 2)
	{

				$q = "SELECT GROUP_CONCAT(course_id)  AS comma_separated_courses
							FROM students_courses_prence  WHERE student_id = $user_id  AND level = '$level'
							AND programme_id = $programme_id AND session_id = $session AND semester = $semester
							AND total_score < 40";


				$r = mysqli_query(dbc(),$q);


				$output = '';

				if(mysqli_num_rows($r) > 0 )
				{
					$row = mysqli_fetch_array($r, MYSQLI_ASSOC);

					$output = $row['comma_separated_courses'];

				}//end of if there is value
				else
				{
					$output = '';
				} //end if if candidate has oC

	}//end of level is PRE and sems is 2
	else {
		// code...
	}




	return $output;


}//end of function that get OC for particular students prence


//cehck if student has ever passed particular course during his stay in the schools
function get_students_passed_courses_per_semester_nce($user_id,$programme_id, $level, $session, $semester)
{
	//check if level is I and semester is 1
	if($level == 'II' AND $semester == 1)
	{
				$q = "SELECT GROUP_CONCAT(course_id)  AS comma_separated_courses
							FROM students_courses_nce  WHERE student_id = $user_id AND semester = $semester
							AND total_score > 39";

							//AND level = '$level'
							//AND programme_id = $programme_id AND session_id = $session

				$r = mysqli_query(dbc(),$q);
				$output = '';

				if(mysqli_num_rows($r) > 0 )
				{
					$row = mysqli_fetch_array($r, MYSQLI_ASSOC);

					$output = $row['comma_separated_courses'];

				}//end of if there is value
				else
				{
					$output = '';
				} //end if if candidate has oC

	}
	else if($level == 'II' AND $semester == 2)
	{

		$q = "SELECT GROUP_CONCAT(course_id)  AS comma_separated_courses
					FROM students_courses_nce  WHERE student_id = $user_id AND semester = $semester
					AND total_score > 39";

					//AND level = '$level'
					//AND programme_id = $programme_id AND session_id = $session


				$r = mysqli_query(dbc(),$q);


				$output = '';

				if(mysqli_num_rows($r) > 0 )
				{
					$row = mysqli_fetch_array($r, MYSQLI_ASSOC);

					$output = $row['comma_separated_courses'];

				}//end of if there is value
				else
				{
					$output = '';
				} //end if if candidate has oC

	}//end of level is I and sems is 2
	else if($level == 'III' AND $semester == 1)
	{

		$q = "SELECT GROUP_CONCAT(course_id)  AS comma_separated_courses
					FROM students_courses_nce  WHERE student_id = $user_id AND semester = $semester
					AND total_score > 39";

					//AND level = '$level'
					//AND programme_id = $programme_id AND session_id = $session


				$r = mysqli_query(dbc(),$q);


				$output = '';

				if(mysqli_num_rows($r) > 0 )
				{
					$row = mysqli_fetch_array($r, MYSQLI_ASSOC);

					$output = $row['comma_separated_courses'];

				}//end of if there is value
				else
				{
					$output = '';
				} //end if if candidate has oC

	}
	else if($level == 'III' AND $semester == 2)
	{
		$q = "SELECT GROUP_CONCAT(course_id)  AS comma_separated_courses
					FROM students_courses_nce  WHERE student_id = $user_id AND semester = $semester
					AND total_score > 39";

					//AND level = '$level'
					//AND programme_id = $programme_id AND session_id = $session


				$r = mysqli_query(dbc(),$q);


				$output = '';

				if(mysqli_num_rows($r) > 0 )
				{
					$row = mysqli_fetch_array($r, MYSQLI_ASSOC);

					$output = $row['comma_separated_courses'];

				}//end of if there is value
				else
				{
					$output = '';
				} //end if if candidate has oC


	}




	return $output;

}




//check if the programme grading aggregate summary has been inserted
function check_if_programme_aggregate_summary_exist($programme_id, $session, $semester, $level)
{
	//check if invoice id generated exist
	$q1 = "SELECT programme_id
		   FROM students_results_programme_remark_nce
		   WHERE programme_id = '$programme_id' AND session_id = '$session' AND semester = '$semester' AND level = '$level'";

	$r1 = mysqli_query(dbc(),$q1);

	if(mysqli_num_rows($r1) > 0 )
	{
		return true;
	}
	else
	{
		return false;
	}


}//end of if the aggregate is added already


//check if the programme grading aggregate summary has been inserted prence
function check_if_programme_aggregate_summary_exist_prence($programme_id, $session, $semester, $level)
{
	//check if invoice id generated exist
	$q1 = "SELECT programme_id
		   FROM students_results_programme_remark_prence
		   WHERE programme_id = '$programme_id' AND session_id = '$session' AND semester = '$semester' AND level = '$level'";

	$r1 = mysqli_query(dbc(),$q1);

	if(mysqli_num_rows($r1) > 0 )
	{
		return true;
	}
	else
	{
		return false;
	}


}//end of if the aggregate is added already prence


//functio to update the table for total score

//function dat check if student have carry over  student id by matric number
function update_students_courses_db_nce($user_id, $programme_id, $level, $session, $semester)
{
	$q = "UPDATE students_courses_nce
		  SET total_score = ca_score + exam_score  WHERE student_id = '$user_id'
		  AND  programme_id = '$programme_id' AND level = '$level' AND session_id = $session AND semester = $semester";
	$r = mysqli_query(dbc(),$q);


    ////////


}//is there carry over per programme...


//function dat check if update score by programme
function update_programme_courses_db_nce( $programme_id, $level, $session, $semester)
{
	$q = "UPDATE students_courses_nce
		  SET total_score = ca_score + exam_score  WHERE  programme_id = $programme_id AND level = '$level' AND session_id = $session AND semester = $semester";
	$r = mysqli_query(dbc(),$q);


    ////////


}//is there carry over per programme...


//function dat check if student have carry over  student id by matric number for prence
function update_students_courses_db_prence($user_id, $programme_id, $level, $session, $semester)
{
	$q = "UPDATE students_courses_prence
		  SET total_score = ca_score + exam_score  WHERE student_id = '$user_id'
		  AND  programme_id = '$programme_id' AND level = '$level' AND session_id = '$session' AND semester = '$semester'";
	$r = mysqli_query(dbc(),$q);


    ////////


}//is there carry over per programme... for prence


//get total score per student per session per course per semester
function get_total_score_per_student_per_course_nce($user_id,$programme_id, $level, $session, $semester,$course_id)
{

		$q = "SELECT total_score
		  	  FROM students_courses_nce  WHERE student_id = $user_id  AND level = '$level'
		  	  AND programme_id = $programme_id AND session_id = $session AND semester = $semester
		  	  AND course_id  = $course_id";


	$r = mysqli_query(dbc(),$q);


	$output = '';

	if(mysqli_num_rows($r) > 0 )
	{
		$row = mysqli_fetch_assoc($r);

		$output = number_format($row['total_score']);

	}//end of if there is value
	else
	{
		$output = 'X';
	}


	return $output;


}//end of function that  get total score for student per student per session per semester per level


//get total score per student per session per course per semester prence
function get_total_score_per_student_per_course_prence($user_id,$programme_id, $level, $session, $semester,$course_id)
{

		$q = "SELECT total_score
		  	  FROM students_courses_prence  WHERE student_id = $user_id  AND level = '$level'
		  	  AND programme_id = $programme_id AND session_id = $session AND semester = $semester
		  	  AND course_id  = $course_id";


	$r = mysqli_query(dbc(),$q);


	$output = '';

	if(mysqli_num_rows($r) > 0 )
	{
		$row = mysqli_fetch_assoc($r);

		$output = number_format($row['total_score']);

	}//end of if there is value
	else
	{
		$output = 'X';
	}


	return $output;


}//end of function that  get total score for student per student per session per semester per level prence


//get total score per student per session per course per semester for summer
function get_total_score_per_student_per_course_nce_summer($user_id,$programme_id, $level, $session, $semester,$course_id)
{

		$q = "SELECT total_score
		  	  FROM summer_students_courses_nce   WHERE student_id = $user_id
		  	  AND programme_id = $programme_id AND session_id = $session AND semester = $semester
		  	  AND course_id  = $course_id"; //AND level = '$level'


	$r = mysqli_query(dbc(),$q);


	$output = '';

	if(mysqli_num_rows($r) > 0 )
	{
		$row = mysqli_fetch_assoc($r);

		$output = number_format($row['total_score']);

	}//end of if there is value
	else
	{
		$output = 'X';
	}


	return $output;


}//end of function that  get total score for student per student per session per semester per  for summer


//function that gets total credit unit registered per semester for aparticular student --
function get_tcur_students_per_semester_nce($user_id,$programme_id, $level, $session, $semester)
{
	$q = "SELECT cum_tcur
		  FROM students_results_nce  WHERE  student_id = $user_id AND level = '$level' AND programme_id = $programme_id AND session_id = $session AND semester = $semester";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['cum_tcur']);


}//end of function togets total credit unit registered per semester for aparticular student




//function that gets total credit unit registered per semester for aparticular student -- for prence
function get_tcur_students_per_semester_prence($user_id,$programme_id, $level, $session, $semester)
{
	$q = "SELECT cum_tcur
		  FROM students_results_prence  WHERE  student_id = $user_id AND level = '$level' AND programme_id = $programme_id AND session_id = $session AND semester = $semester";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['cum_tcur']);


}//end of function togets total credit unit registered per semester for aparticular student for prence



//function that gets total credit unit registered per semester for aparticular student --   for edu
function get_edu_tcur_students_per_semester_nce($user_id,$programme_id, $level, $session, $semester)
{
	$q = "SELECT edu_tcur
		  FROM students_results_nce  WHERE  student_id = $user_id AND level = '$level' AND programme_id = $programme_id AND session_id = $session AND semester = $semester";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['edu_tcur']);


}//end of function togets total credit unit registered per semester for aparticular student

//function that gets total credit unit registered per semester for aparticular student --   for edu for prence
function get_edu_tcur_students_per_semester_prence($user_id,$programme_id, $level, $session, $semester)
{
	$q = "SELECT edu_tcur
		  FROM students_results_prence  WHERE  student_id = $user_id AND level = '$level' AND programme_id = $programme_id AND session_id = $session AND semester = $semester";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['edu_tcur']);


}//end of function togets total credit unit registered per semester for aparticular student for pre nce


//function that gets total credit unit registered per semester for aparticular student --   for gse
function get_gst_tcur_students_per_semester_nce($user_id,$programme_id, $level, $session, $semester)
{
	$q = "SELECT gst_tcur
		  FROM students_results_nce  WHERE  student_id = $user_id AND level = '$level' AND programme_id = $programme_id AND session_id = $session AND semester = $semester";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['gst_tcur']);


}//end of function togets total credit unit registered per semester for aparticular student


//function that gets total credit unit registered per semester for aparticular student --   for gse for prence
function get_gst_tcur_students_per_semester_prence($user_id,$programme_id, $level, $session, $semester)
{
	$q = "SELECT gst_tcur
		  FROM students_results_prence  WHERE  student_id = $user_id AND level = '$level' AND programme_id = $programme_id AND session_id = $session AND semester = $semester";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['gst_tcur']);


}//end of function togets total credit unit registered per semester for aparticular student for prence


//function that gets total credit unit registered per semester for aparticular student --   for core1
function get_core_tcur_students_per_semester_nce($core_type, $user_id,$programme_id, $level, $session, $semester)
{
	if($core_type == 1)
	{
			$q = "SELECT core1_tcur
		  FROM students_results_nce  WHERE  student_id = $user_id AND level = '$level' AND programme_id = $programme_id AND session_id = $session AND semester = $semester";
			$r = mysqli_query(dbc(),$q);

			$row = mysqli_fetch_assoc($r);

			return number_format($row['core1_tcur']);

	}
	else
	{
		$q = "SELECT core2_tcur
		  FROM students_results_nce  WHERE  student_id = $user_id AND level = '$level' AND programme_id = $programme_id AND session_id = $session AND semester = $semester";
			$r = mysqli_query(dbc(),$q);

			$row = mysqli_fetch_assoc($r);

			return number_format($row['core2_tcur']);
	}



}//end of function togets total credit unit registered per semester for aparticular student


//function that gets total credit unit registered per semester for aparticular student --   for core1 for PRENCE
function get_core_tcur_students_per_semester_prence($core_type, $user_id,$programme_id, $level, $session, $semester)
{
	if($core_type == 1)
	{
			$q = "SELECT core1_tcur
		  FROM students_results_prence  WHERE  student_id = $user_id AND level = '$level' AND programme_id = $programme_id AND session_id = $session AND semester = $semester";
			$r = mysqli_query(dbc(),$q);

			$row = mysqli_fetch_assoc($r);

			return number_format($row['core1_tcur']);

	}
	else
	{
		$q = "SELECT core2_tcur
		  FROM students_results_prence  WHERE  student_id = $user_id AND level = '$level' AND programme_id = $programme_id AND session_id = $session AND semester = $semester";
			$r = mysqli_query(dbc(),$q);

			$row = mysqli_fetch_assoc($r);

			return number_format($row['core2_tcur']);
	}



}//end of function togets total credit unit registered per semester for aparticular student for PRENCE



//function that gets cgpa if there is any --
function get_cum_prev_cgpa_students_per_semester_nce($user_id,$programme_id, $level, $session, $semester)
{
	$q = "SELECT cum_pcgpa
		  FROM students_results_nce  WHERE  student_id = $user_id AND level = '$level' AND programme_id = $programme_id AND session_id = $session AND semester = $semester";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['cum_pcgpa'],2);


}//end of function togets total credit unit registered per semester for aparticular student


//function that gets cgpa if there is any -- prence
function get_cum_prev_cgpa_students_per_semester_prence($user_id,$programme_id, $level, $session, $semester)
{
	$q = "SELECT cum_pcgpa
		  FROM students_results_prence  WHERE  student_id = $user_id AND level = '$level' AND programme_id = $programme_id AND session_id = $session AND semester = $semester";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['cum_pcgpa'],2);


}//end of function togets total credit unit registered per semester for aparticular student prence




//function that gets total remark   per semester for aparticular student --
function get_remark2_students_per_semester_nce($user_id,$programme_id, $level, $session, $semester)
{
	$q = "SELECT remark2
		  FROM students_results_nce  WHERE  student_id = $user_id AND level = '$level' AND programme_id = $programme_id AND session_id = $session AND semester = $semester";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return $row['remark2'];


}//end of function togets gets total remark   per semester for aparticular student


//function that gets total remark   per semester for aparticular student -- for prence
function get_remark2_students_per_semester_prence($user_id,$programme_id, $level, $session, $semester)
{
	$q = "SELECT remark2
		  FROM students_results_prence  WHERE  student_id = $user_id AND level = '$level' AND programme_id = $programme_id AND session_id = $session AND semester = $semester";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return $row['remark2'];


}//end of function togets gets total remark   per semester for aparticular student prence


//function that gets total remark   per semester for aparticular student -- for pdf printing
function get_remark2_students_per_semester_nce_pdf($user_id, $level, $session, $semester)
{
	$q = "SELECT remark2
		  FROM students_results_nce  WHERE  student_id = $user_id AND level = '$level'  AND session_id = $session AND semester = $semester";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return $row['remark2'];


}//end of function togets gets total remark   per semester for aparticular student



//function that gets total remark   per semester for aparticular student -- for pdf printing for prence
function get_remark2_students_per_semester_nce_pdf_prence($user_id, $level, $session, $semester)
{
	$q = "SELECT remark2
		  FROM students_results_prence  WHERE  student_id = $user_id AND level = '$level'  AND session_id = $session AND semester = $semester";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return $row['remark2'];


}//end of function togets gets total remark   per semester for aparticular student for prence




//function that gets total remark   per semester for aparticular student --
function get_remark1_students_per_semester_nce($user_id,$programme_id, $level, $session, $semester)
{
	$q = "SELECT remark1
		  FROM students_results_nce  WHERE  student_id = $user_id AND level = '$level' AND programme_id = $programme_id AND session_id = $session AND semester = $semester";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	$codes = $row['remark1'];




    for ($i = 0; $i < count($codes);$i++)
    {
       $splitted_codes = explode(',', $codes);


    }

    //pass array for output
    foreach ($splitted_codes as $item)
    {
      $output .=  get_course_code($item).',';
    }

    return $output;


}//end of function togets gets total remark   per semester for aparticular student

//function that gets total remark   per semester for aparticular student --  for prence
function get_remark1_students_per_semester_prence($user_id,$programme_id, $level, $session, $semester)
{
	$q = "SELECT remark1
		  FROM students_results_prence  WHERE  student_id = $user_id AND level = '$level' AND programme_id = $programme_id AND session_id = $session AND semester = $semester";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	$codes = $row['remark1'];




    for ($i = 0; $i < count($codes);$i++)
    {
       $splitted_codes = explode(',', $codes);


    }

    //pass array for output
    foreach ($splitted_codes as $item)
    {
      $output .=  get_course_code($item).',';
    }

    return $output;


}//end of function togets gets total remark   per semester for aparticular student for prence


//function that gets total remark   per semester for aparticular student --
function get_remark1_students_per_semester_nce_pdf($user_id, $level, $session, $semester)
{
	$q = "SELECT remark1
		  FROM students_results_nce  WHERE  student_id = $user_id AND level = '$level'  AND session_id = $session AND semester = $semester";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	$codes = $row['remark1'];




    for ($i = 0; $i < count($codes);$i++)
    {
       $splitted_codes = explode(',', $codes);


    }

    //pass array for output
    foreach ($splitted_codes as $item)
    {
      $output .=  get_course_code($item).',';
    }

    return $output;


}//end of function togets gets total remark   per semester for aparticular student



//function that gets total remark   per semester for aparticular student -- for PRENCE
function get_remark1_students_per_semester_nce_pdf_prence($user_id, $level, $session, $semester)
{
	$q = "SELECT remark1
		  FROM students_results_prence  WHERE  student_id = $user_id AND level = '$level'  AND session_id = $session AND semester = $semester";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	$codes = $row['remark1'];




    for ($i = 0; $i < count($codes);$i++)
    {
       $splitted_codes = explode(',', $codes);


    }

    //pass array for output
    foreach ($splitted_codes as $item)
    {
      $output .=  get_course_code($item).',';
    }

    return $output;


}//end of function togets gets total remark   per semester for aparticular student for PRENCE




//function dat get student id by matric number
function get_student_id_by_matric_no($id)
{
	$q = "SELECT id FROM students_nce WHERE number = '$id' ";
	$r = mysqli_query(dbc(),$q);
	$row = mysqli_fetch_assoc($r);

	return $row['id'];


}


//function get student course title using  md5
function  get_student_course_code($id)
{
	$result = mysqli_query(dbc(),"SELECT code FROM courses WHERE md5(id) = '$id'");
		$row = mysqli_fetch_assoc($result);
		$v = $row['code'];

	return $v;

}




//function view trashed courses
function view_trashed_courses()
{


	//query the database
	$q = "SELECT id, title, description, code, department_id, status,
		 DATE_FORMAT(date_added, '%M %d, %Y %l:%i:%p') as date_added,  DATE_FORMAT(date_trashed, '%M %d, %Y %l:%i:%p') as date_trashed,
		 DATE_FORMAT(date_modified, '%M %d, %Y %l:%i:%p') as date_modified, added_by, modified_by
		 FROM  courses
		 WHERE status = 2
		 ORDER BY date_added DESC, date_modified DESC";
	$r = mysqli_query(dbc(),$q);

	if(mysqli_num_rows($r) > 0)
	{//show table



		  $output =
		  '<table id="example" class="user display table-bordered table-hover table-striped" cellspacing="0" width="100%" style="font-size:12px;">
			<thead>
						<th> <input type="checkbox" id="selecctall"  value=""> </th>
						<th>Title</th>
						<th>Code</th>
						<th>Department</th>
						<th>Description</th>
						<th>Date Added</th>
						<th>Date Mod.</th>
						<th>Added By</th>
						<th>Modified By</th>
						<th>Deleted</th>
						<th></th>

			</thead>
			<tfoot>
						<th> <input type="checkbox" id="selecctall"  value=""> </th>
						<th>Title</th>
						<th>Code</th>
						<th>Department</th>
						<th>Description</th>
						<th>Date Added</th>
						<th>Date Mod.</th>
						<th>Added By</th>
						<th>Modified By</th>
						<th>Deleted</th>
						<th></th>


			</tfoot>

			<tbody>';

		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			$output .= "<tr>";
			$output .="<td><input type='checkbox' value='".$row['id']."' name='course[]' id='course' class='checkbox1'/></td>" ;
			$output .= "<td> <a href=''>".$row['title']."</a></td>";
			$output .= "<td>".$row['code']."</td>";
			$output .= "<td>".get_department_title($row['department_id'])."</td>";
			$output .= "<td>".$row['description']."</td>";
			$output .= "<td>".$row['date_added']."</td>";
			$output .= "<td>".$row['date_modified']."</td>";
			$output .= "<td>".$row['added_by']."</td>";
			$output .= "<td>".$row['modified_by']."</td>";
			$output .= "<td>".$row['date_trashed']."</td>";
			$output .= '<td><a class="btn btn-success btn-sm pull-right restore_course" id="'.$row['id'].'" > Restore</a>
						 <span id="loading"></span></td>';
			$output .= "</tr>";


		}
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;




}//end of view  trashed courses

//function that shows course publish status image
function course_publish_status_image($status)
{

	$st = $status;

	if($st == 0)
	{
		$output =  '<input type="submit" name="act" class="publish-icon-small" value="unpublish_courses" id="publish_cs"
				data-toggle="tooltip" data-placement="right" title="Published: Click to unpublish item">';
	}
	else
	{
		$output =  '<input type="submit" name="act" class="unpublish-icon-small" value="publish_courses" id="unpublish_cs"
					data-toggle="tooltip" data-placement="right" title="Unpublished: Click to publish item">';
	}

	return $output;


}//end of function dat shows publish image  for courses




//function view subjects
function view_subjects()
{

	//comment incase


	//query the database
	$q = "SELECT id, title, description, course_id, department_id, code, unit, level, semester, status,
		 DATE_FORMAT(date_added, '%M %d, %Y %l:%i:%p') as date_added,
		 DATE_FORMAT(date_modified, '%M %d, %Y %l:%i:%p') as date_modified, added_by, modified_by
		 FROM  subjects
		 WHERE status = 0 OR status = 1
		 ORDER BY date_added DESC, date_modified DESC";
	$r = mysqli_query(dbc(),$q);

	if(mysqli_num_rows($r) > 0)
	{//show table



		  $output =
		  '<table id="example" class="user display table-bordered table-hover table-striped" cellspacing="0" width="100%" style="font-size:12px;">
			<thead>
						<th> <input type="checkbox" id="selecctall" data-toggle = "tooltip" title = "Check All"   value=""></th>
						<th>Title</th>
						<th>Code</th>
						<th>Status</th>
						<th>Department</th>
						<th>Course</th>
						<th>Unit</th>
						<th>Level</th>
						<th>Semester</th>
						<th>Description</th>
						<th>Date Added</th>
						<th>Date Mod.</th>
						<th>Added By</th>
						<th>Modified By</th>

			</thead>
			<tfoot>
						<th> <input type="checkbox" id="selecctall"  data-toggle = "tooltip" title = "Check All" value=""> </th>
						<th>Title</th>
						<th>Code</th>
						<th>Status</th>
						<th>Department</th>
						<th>Course</th>
						<th>Unit</th>
						<th>Level</th>
						<th>Semester</th>
						<th>Description</th>
						<th>Date Added</th>
						<th>Date Mod.</th>
						<th>Added By</th>
						<th>Modified By</th>

			</tfoot>

			<tbody>';

		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			$output .= "<tr>";
			$output .="<td><input type='checkbox' value='".$row['id']."' name='subject[]' id='subject' class='checkbox1'/></td>" ;
			$output .= "<td> <a href=''>".$row['title']."</a></td>";
			$output .= "<td>".$row['code']."</td>";
			$output .= "<td>".subject_publish_status_image($row['status'])."</td>";
			$output .= "<td>".get_department_title($row['department_id'])."</td>";
			$output .= "<td>".get_course_title($row['course_id'])."</td>";
			$output .= "<td>".$row['unit']."</td>";
			$output .= "<td>".$row['level']."</td>";
			$output .= "<td>".$row['semester']."</td>";
			$output .= "<td>".$row['description']."</td>";
			$output .= "<td>".$row['date_added']."</td>";
			$output .= "<td>".$row['date_modified']."</td>";
			$output .= "<td>".$row['added_by']."</td>";
			$output .= "<td>".$row['modified_by']."</td>";
			$output .= "</tr>";


		}
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;




}//end of view subjects

//function view trashed subjects
function view_trashed_subjects()
{

	//comment incase


	//query the database
	$q = "SELECT id, title, description, course_id, department_id, code, unit, level, semester, status,
		 DATE_FORMAT(date_added, '%M %d, %Y %l:%i:%p') as date_added, DATE_FORMAT(date_trashed, '%M %d, %Y %l:%i:%p') as date_trashed,
		 DATE_FORMAT(date_modified, '%M %d, %Y %l:%i:%p') as date_modified, added_by, modified_by
		 FROM  subjects
		  WHERE status = 2
		  ORDER BY date_added DESC, date_modified DESC";
	$r = mysqli_query(dbc(),$q);

	if(mysqli_num_rows($r) > 0)
	{//show table



		  $output =
		  '<table id="example" class="user display table-bordered table-hover table-striped" cellspacing="0" width="100%" style="font-size:12px;">
			<thead>
						<th> <input type="checkbox" id="selecctall" data-toggle = "tooltip" title = "Check All"   value=""></th>
						<th>Title</th>
						<th>Code</th>
						<th>Department</th>
						<th>Course</th>
						<th>Unit</th>
						<th>Level</th>
						<th>Semester</th>
						<th>Description</th>
						<th>Date Added</th>
						<th>Date Mod.</th>
						<th>Added By</th>
						<th>Deleted</th>
						<th></th>

			</thead>
			<tfoot>
						<th> <input type="checkbox" id="selecctall"  data-toggle = "tooltip" title = "Check All" value=""> </th>
						<th>Title</th>
						<th>Code</th>
						<th>Department</th>
						<th>Course</th>
						<th>Unit</th>
						<th>Level</th>
						<th>Semester</th>
						<th>Description</th>
						<th>Date Added</th>
						<th>Date Mod.</th>
						<th>Added By</th>
						<th>Deleted</th>
						<th></th>


			</tfoot>

			<tbody>';

		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			$output .= "<tr>";
			$output .="<td><input type='checkbox' value='".$row['id']."' name='subject[]' id='subject' class='checkbox1'/></td>" ;
			$output .= "<td> <a href=''>".$row['title']."</a></td>";
			$output .= "<td>".$row['code']."</td>";
			$output .= "<td>".get_department_title($row['department_id'])."</td>";
			$output .= "<td>".get_course_title($row['course_id'])."</td>";
			$output .= "<td>".$row['unit']."</td>";
			$output .= "<td>".$row['level']."</td>";
			$output .= "<td>".$row['semester']."</td>";
			$output .= "<td>".$row['description']."</td>";
			$output .= "<td>".$row['date_added']."</td>";
			$output .= "<td>".$row['date_modified']."</td>";
			$output .= "<td>".$row['added_by']."</td>";
			$output .= "<td>".$row['date_trashed']."</td>";
			$output .= '<td><a class="btn btn-success btn-sm pull-right restore_subject" id="'.$row['id'].'" > Restore</a>
						 <span id="loading"></span></td>';
			$output .= "</tr>";


		}
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;




}//end of view trashed subjects



//function that shows subject publish status image
function subject_publish_status_image($status)
{

	$st = $status;

	if($st == 0)
	{
		$output =  '<input type="submit" name="act" class="publish-icon-small" value="unpublish_subjects" id="publish_sj"
				data-toggle="tooltip" data-placement="right" title="Published: Click to unpublish item">';
	}
	else
	{
		$output =  '<input type="submit" name="act" class="unpublish-icon-small" value="publish_subjects" id="unpublish_sj"
					data-toggle="tooltip" data-placement="right" title="Unpublished: Click to publish item">';
	}

	return $output;


}//end of function dat shows publish image  for subjects



//function that filters the ip
function filter_ip()
{

  $ip = getenv('REMOTE_ADDR'); //get user ip
  $ip=str_replace('.','',$ip); //str replace of dot

  $query_ip= mysqli_query(dbc(),"SELECT * FROM ip_filter WHERE ips='$ip'") or die(mysql_error()); //query
  if($query_ip){

    $row=mysqli_num_rows($query_ip);
    if($row==0){

      header('location:autorize_message/'); // show authorize message
    }

  }
}


//view ips
//function that get ips informatn
function view_ips()
{

	//query the database
	$q = "SELECT `id`, `ips`, `title`, `description`, `status`, `activate`,
		 DATE_FORMAT(date_added, '%b %e, %Y  %l:%i:%p') as date_added, DATE_FORMAT(date_modified, '%b %e, %Y  %l:%i:%p') as date_modified,
		 `added_by`, `modified_by`
		 FROM `ip_filter`
		 WHERE status = 1 OR status = 0

		 ORDER BY date_added DESC, date_modified DESC";
	$r = mysqli_query(dbc(),$q);



	//in the table below result_table stands for resullt fetch throug seraching table(ajax)


	if(mysqli_num_rows($r) > 0)
	{//show table

	$output ='<table id="example" class="ip display table-bordered table-hover table-striped responsive" width="100%"  cellspacing="0" style="font-size:12px;">
				<thead>




						<th  > <input type="checkbox" id="selecctall"  data-toggle = "tooltip" title = "Check All" value=""></th>
			  			<th>Title</th>tle
						<th>IPs</th>

						<th>Description</th>
						<th>Active Status</th>
						<th>Date Added</th>
						<th>Date Mod.</th>
						<th>Added By</th>
						<th>Modified By</th>

				</thead>



				<tfoot>


						<th  > <input type="checkbox" id="selecctall" data-toggle = "tooltip" title = "Check All"  value=""></th>
			  			<th>Title</th>
						<th>IPs</th>
						<th>Description</th>
						<th>Active Status</th>
						<th>Date Added</th>
						<th>Date Mod.</th>
						<th>Added By</th>
						<th>Modified By</th>
				</tfoot>

				<tbody>';



		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			$output .= "<tr>";
			$output .="<td>&nbsp;&nbsp;&nbsp;<input type='checkbox' value='".$row['id']."' name='ip[]' id='ip' class='checkbox1'/></td>" ;
			$output .= "<td> <a href=''>".$row['title']."</a></td>"; //nam eof the user
			$output .= "<td>".$row['ips']."</td>";
			$output .= "<td>".$row['description']."</td>";
			$output .= "<td>".ip_status_img($row['activate'])."</td>";
			$output .= "<td>".$row['date_added']."</td>";
			$output .= "<td>".$row['date_modified']."</td>";
			$output .= "<td>".$row['added_by']."</td>";
			$output .= "<td>".$row['modified_by']."</td>";
			$output .= "</tr>";



		}
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;




}//end of view  ips


//view trashed ips
//function that get ips informatn
function view_trashed_ips()
{

	//query the database
	$q = "SELECT `id`, `ips`, `title`, `description`, `status`, `activate`, DATE_FORMAT(date_trashed, '%b %e, %Y  %l:%i:%p') as date_trashed,
		 DATE_FORMAT(date_added, '%b %e, %Y  %l:%i:%p') as date_added, DATE_FORMAT(date_modified, '%b %e, %Y  %l:%i:%p') as date_modified,
		 `added_by`, `modified_by`
		 FROM `ip_filter`
		 WHERE status = 2

		 ORDER BY date_added DESC, date_modified DESC";
	$r = mysqli_query(dbc(),$q);



	//in the table below result_table stands for resullt fetch throug seraching table(ajax)


	if(mysqli_num_rows($r) > 0)
	{//show table

	$output ='<table id="example" class="ip display table-bordered table-hover table-striped responsive" width="100%"  cellspacing="0" style="font-size:12px;">
				<thead>

				     	<th  > <input type="checkbox" id="selecctall"  data-toggle = "tooltip" title = "Check All" value=""></th>
			  			<th>Title</th>tle
						<th>IPs</th>
						<th>Description</th>
						<th>Active Status</th>
						<th>Date Added</th>
						<th>Date Mod.</th>
						<th>Added By</th>
						<th>Modified By</th>
						<th>Deleted </th>
						<th></th>

				</thead>



				<tfoot>


						<th  > <input type="checkbox" id="selecctall" data-toggle = "tooltip" title = "Check All"  value=""></th>
			  			<th>Title</th>
						<th>IPs</th>
						<th>Description</th>
						<th>Active Status</th>
						<th>Date Added</th>
						<th>Date Mod.</th>
						<th>Added By</th>
						<th>Modified By</th>
						<th>Deleted </th>
						<th></th>
				</tfoot>

				<tbody>';



		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			$output .= "<tr>";
			$output .="<td>&nbsp;&nbsp;&nbsp;<input type='checkbox' value='".$row['id']."' name='ip[]' id='ip' class='checkbox1'/></td>" ;
			$output .= "<td> <a href=''>".$row['title']."</a></td>"; //nam eof the user
			$output .= "<td>".$row['ips']."</td>";
			$output .= "<td>".$row['description']."</td>";
			$output .= "<td>".ip_status_img($row['activate'])."</td>";
			$output .= "<td>".$row['date_added']."</td>";
			$output .= "<td>".$row['date_modified']."</td>";
			$output .= "<td>".$row['added_by']."</td>";
			$output .= "<td>".$row['modified_by']."</td>";
			$output .= "<td>".$row['date_trashed']."</td>";
			$output .= '<td><a class="btn btn-success btn-sm pull-right restore_ip" id="'.$row['id'].'" > Restore</a>
						 <span id="loading"></span></td>';
			$output .= "</tr>";



		}
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;




}//end of view trashed ips

//ip image status
//by passing the blocked status

function ip_status_img($status)
{
	$st = $status;

	if($st == 1)
	{
		return '<img src="images/active.png" data-toggle="tooltip" title="Active"/>';
	}
	else
	{
		return '<img src="images/blocked.png" data-toggle="tooltip" title="Blocked" />';
	}
}





//function that shows ips publish status image
function ip_publish_status_image($status)
{

	$st = $status;

	if($st == 0)
	{
		$output =  '<input type="submit" name="act" class="publish-icon-small disabled" value="unpublish_ips" id="publish_ip"
				data-toggle="tooltip" data-placement="right" title="Published" disabled="disabled">';
	}
	else
	{
		$output =  '<input type="submit" name="act" class="unpublish-icon-small disabled" value="publish_ips" id="unpublish_ip"
					data-toggle="tooltip" data-placement="right" title="Unpublished" disabled="disabled">';
	}

	return $output;


}//end of function dat shows publish image


//function that get control boxes informatn
function view_control_boxs()
{

	//query the database
	$q = "SELECT `id`, `controls_value`, `title`, `description`, `status`, `active`,
		 DATE_FORMAT(date_added, '%b %e, %Y  %l:%i:%p') as date_added, DATE_FORMAT(date_modified, '%b %e, %Y  %l:%i:%p') as date_modified,
		 `added_by`, `modified_by`
		 FROM `controls`
		 WHERE status = 1 OR status = 0

		 ORDER BY date_added DESC, date_modified DESC";
	$r = mysqli_query(dbc(),$q);



	//in the table below result_table stands for resullt fetch throug seraching table(ajax)


	if(mysqli_num_rows($r) > 0)
	{//show table

	$output ='<table id="example" class="control_box display table-bordered table-hover table-striped responsive" width="100%"  cellspacing="0" style="font-size:12px;">
				<thead>




						<th  > <input type="checkbox" id="selecctall"  data-toggle = "tooltip" title = "Check All" value=""></th>
			  			<th>Title</th>
						<th>Controls</th>

						<th>Description</th>
						<th>Active Status</th>
						<th>Date Added</th>
						<th>Date Mod.</th>
						<th>Added By</th>
						<th>Modified By</th>

				</thead>



				<tfoot>


						<th  > <input type="checkbox" id="selecctall" data-toggle = "tooltip" title = "Check All"  value=""></th>
			  			<th>Title</th>
						<th>Controls</th>
						<th>Description</th>
						<th>Active Status</th>
						<th>Date Added</th>
						<th>Date Mod.</th>
						<th>Added By</th>
						<th>Modified By</th>
				</tfoot>

				<tbody>';



		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			$output .= "<tr>";
			$output .="<td>&nbsp;&nbsp;&nbsp;<input type='checkbox' value='".$row['id']."' name='control_box[]' id='ip' class='checkbox1'/></td>" ;
			$output .= "<td> <a href=''>".$row['title']."</a></td>"; //nam eof the user
			$output .= "<td>".$row['controls_value']."</td>";
			$output .= "<td>".$row['description']."</td>";
			$output .= "<td>".control_box_status_img($row['active'])."</td>";
			$output .= "<td>".$row['date_added']."</td>";
			$output .= "<td>".$row['date_modified']."</td>";
			$output .= "<td>".$row['added_by']."</td>";
			$output .= "<td>".$row['modified_by']."</td>";
			$output .= "</tr>";



		}
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;




}//end of view  control boxes

//function that get control_boxs informatn
function view_trashed_control_boxs()
{

	//query the database
	$q = "SELECT `id`, `controls_value`, `title`, `description`,  `active`, DATE_FORMAT(date_trashed, '%b %e, %Y  %l:%i:%p') as date_trashed,
		 DATE_FORMAT(date_added, '%b %e, %Y  %l:%i:%p') as date_added, DATE_FORMAT(date_modified, '%b %e, %Y  %l:%i:%p') as date_modified,
		 `added_by`, `modified_by`
		 FROM `controls`
		 WHERE status = 2

		 ORDER BY date_added DESC, date_modified DESC";
	$r = mysqli_query(dbc(),$q);



	//in the table below result_table stands for resullt fetch throug seraching table(ajax)


	if(mysqli_num_rows($r) > 0)
	{//show table

	$output ='<table id="example" class="control_box display table-bordered table-hover table-striped responsive" width="100%"  cellspacing="0" style="font-size:12px;">
				<thead>

				     	<th  > <input type="checkbox" id="selecctall"  data-toggle = "tooltip" title = "Check All" value=""></th>
			  			<th>Title</th>tle
						<th>Controls</th>
						<th>Description</th>
						<th>Active Status</th>
						<th>Date Added</th>
						<th>Date Mod.</th>
						<th>Added By</th>
						<th>Modified By</th>
						<th>Deleted </th>
						<th></th>

				</thead>



				<tfoot>


						<th  > <input type="checkbox" id="selecctall" data-toggle = "tooltip" title = "Check All"  value=""></th>
			  			<th>Title</th>
						<th>Controls</th>
						<th>Description</th>
						<th>Active Status</th>
						<th>Date Added</th>
						<th>Date Mod.</th>
						<th>Added By</th>
						<th>Modified By</th>
						<th>Deleted </th>
						<th></th>
				</tfoot>

				<tbody>';



		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			$output .= "<tr>";
			$output .="<td>&nbsp;&nbsp;&nbsp;<input type='checkbox' value='".$row['id']."' name='control_box[]' id='control_box' class='checkbox1'/></td>" ;
			$output .= "<td> <a href=''>".$row['title']."</a></td>"; //nam eof the user
			$output .= "<td>".$row['controls_value']."</td>";
			$output .= "<td>".$row['description']."</td>";
			$output .= "<td>".control_box_status_img($row['activate'])."</td>";
			$output .= "<td>".$row['date_added']."</td>";
			$output .= "<td>".$row['date_modified']."</td>";
			$output .= "<td>".$row['added_by']."</td>";
			$output .= "<td>".$row['modified_by']."</td>";
			$output .= "<td>".$row['date_trashed']."</td>";
			$output .= '<td><a class="btn btn-success btn-sm pull-right restore_control_box" id="'.$row['id'].'" > Restore</a>
						 <span id="loading"></span></td>';
			$output .= "</tr>";



		}
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;




}//end of view trashed control_boxs

//control box image status
function control_box_status_img($status)
{
	$st = $status;

	if($st == 1)
	{
		return '<img src="images/active.png" data-toggle="tooltip" title="Active"/>';
	}
	else
	{
		return '<img src="images/blocked.png" data-toggle="tooltip" title="Inactive" />';
	}
}





//function view batches

function view_states()
{

	//query the database
	$q = "SELECT `id`, `title`,  `description`, DATE_FORMAT(date_added, '%M %d, %Y %l:%i:%p') as date_added,
		 DATE_FORMAT(date_modified, '%M %d, %Y %l:%i:%p') as date_modified, `added_by` FROM `state`
		 ORDER BY date_added  DESC";
	$r = mysqli_query(dbc(),$q);

	if(mysqli_num_rows($r) > 0)
	{//show table


		 $output =
		  '<table id="example" class="user display table-bordered table-hover table-striped" cellspacing="0" width="100%" style="font-size:12px;">
		  	<thead>
			  <th > <input type="checkbox" id="selecctall"  value=""> &nbsp;Check All</th>
			  <th>Title</th>
			  <th  >Description</th>
			  <th>Date Added</th>
			  <th>Added By</th>

		  </thead>

		  <tfoot>
			  <th > <input type="checkbox" id="selecctall"  value=""> &nbsp;Check All</th>
			  <th>Title</th>
			  <th>Description</th>
			  <th>Date Added</th>
			  <th>Added By</th>

		  </tfoot>

		  <tbody>';




		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			$output .= "<tr>";
			$output .="<td><input type='checkbox' value='".$row['id']."' name='state[]' id='state' class='checkbox1'/></td>" ;
			$output .= "<td>".$row['title']."</td>"; //name
			$output .= "<td>".$row['description']."</td>";
			$output .= "<td>".$row['date_added']."</td>";
			$output .= "<td>".$row['added_by']."</td>";
			$output .= "</tr>";

		}
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;







}//end of view states





//function select state
function select_state( $state)
{
	$r = mysqli_query(dbc(),"SELECT id, title  FROM state  ORDER BY title ");
	if(mysqli_num_rows($r) > 0 )
	{
		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			if($state == $row['id'])
			{
				$output = "<option value=\"$row[id]\" selected>";
				$output .=  $row['title'];
				$output .="</option>";

			}
			else
			{
				$output = "<option value=\"$row[id]\" >";
				$output .= $row['title'];
				$output .="</option>";

			}


			echo $output;
		}
	}
	else
	{

			$output = "<option>";
			$output .="Not added yet";
			$output .="</option>";

			echo $output;
	}
}
//end of select state



//fucntion that returns searched candidates
function view_search_candidate($search_c)
{





	//in the table below result_table stands for resullt fetch throug seraching table(ajax)

	echo
	'<table id="background-image" class="user tablesorter table-responsive" cellspacing="0">
	  <thead>
			 <th class="header" > <input type="checkbox" id="selecctall"  value=""> &nbsp;Check All</th>
				  <th class="header" ><a href="gateway.php?act=view_users&sort=name">Name</a></th>
				  <th class="header" ><a href="gateway.php?act=view_users&sort=number">ID</a></th>
				  <!--<th class="header" ><a href="gateway.php?act=view_users&sort=image">Photo</a></th>-->

				  <th class="header" ><a href="gateway.php?act=view_users&sort=date_added">Last Visit</a></th>

	  </thead>

	  <tbody>';






	//query the database
	$q = "SELECT u.user_id AS user_id, u.other_names as name, u.phone_number, u.transaction_id, u.group_id,
		  DATE_FORMAT(u.date_added, '%b %e, %Y  %l:%i:%p') as date_added,  u.email, u.image


		 FROM users u

		 WHERE u.transaction_id = '$search_c'";

		 //LIMIT $start, $display_per_page";
	$r = mysqli_query(dbc(),$q) or die (mysql_error());

	if($r )
	{//show table

		$row = mysqli_fetch_array($r, MYSQLI_ASSOC);

			$output = "<tr>";
			$output .="<td><input type='checkbox' value='".$row['user_id']."' name='user[]' id='user' class='checkbox1'/></td>" ;
			$output .= "<td> <a href=''>".$row['name']."</a></td>"; //nam eof the user

			$output .= "<td><h3 class='badge badge-info'>".$row['transaction_id']."</h3></td>";
			//$output .= '<td><img class="img-responsive img-circle" src="uploads/pictures/'.$row['image'].'"  style="width:150px; height:150px;" />
					//	'.$row['image'].'</td>';
			$output .= "<td>".$row['date_added']."</td>";
			$output .= "</tr>";

			echo $output;


	}else
	{
		$errors['error'] =  'Candidate not recognise by the system. We apologize for any inconvenience.';

		header("Location: gateway.php?act=search_candidate&error=".urlencode($errors['error'])."");
	}


	//end table view
	echo
	'</tbody>
    </table>';







}//end of view search candidate




//function get candidate image by passing id alone
function get_candidate_image($user_id)
{
	$q = "SELECT u.user_id, u.image FROM users u
		  WHERE  u.user_id = '$user_id'";

	$r 	= mysqli_query(dbc(),$q);

	if(mysqli_num_rows($r) > 0)
	{//show table

		$row = mysqli_fetch_array($r, MYSQLI_ASSOC);

			$output = '<img class="img-responsive img-rounded img-thumbnail center-block" src="uploads/pictures/'.$row['image'].'" style="height:150px ;width:200px"    />';

			return $output;


	}



}//end of function that shows candidate image


//generate serial number fro logging in
function generate_serial_number()
{
	$result = mysqli_query(dbc(),"SELECT * FROM generate_serial_number");
	while($row = mysqli_fetch_array($result))
	{
		$g_code = $row['code'];
	}

	//add 1 to $g_code and tek to d db
	$g_coded = $g_code + 1;

	mysqli_query(dbc(),"UPDATE generate_serial_number  SET code = '$g_coded'");


	//add random four values before adding to the database
	$add_random_value = mt_rand(1000000,9999999);
	$code = $add_random_value.$g_coded;
	$serial_number  = $code;

	return $serial_number;
}
//end of function generate serial number for logging in





//select course
function select_course($course)
{
	$r = mysqli_query(dbc(),"SELECT id, title  FROM courses  ORDER BY title");
	if(mysqli_num_rows($r) > 0 )
	{
		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			if($course == $row['id'])
			{
				$output = "<option value=\"$row[id]\" selected>";
				$output .=  $row['title'];
				$output .="</option>";

			}
			else
			{
				$output = "<option value=\"$row[id]\" >";
				$output .= $row['title'];
				$output .="</option>";

			}


			echo $output;
		}
	}
	else
	{

			$output = "<option>";
			$output .="Not added yet";
			$output .="</option>";

			echo $output;
	}
}
//end of select course



//select faculty
function select_faculty($faculty)
{
	$r = mysqli_query(dbc(),"SELECT id, title  FROM faculties  ORDER BY title");
	if(mysqli_num_rows($r) > 0 )
	{
		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			if($faculty == $row['id'])
			{
				$output = "<option value=\"$row[id]\" selected>";
				$output .=  $row['title'];
				$output .="</option>";

			}
			else
			{
				$output = "<option value=\"$row[id]\" >";
				$output .= $row['title'];
				$output .="</option>";

			}


			echo $output;
		}
	}
	else
	{

			$output = "<option>";
			$output .="Not added yet";
			$output .="</option>";

			echo $output;
	}
}
//end of select faculties


//select department
function select_department($department)
{
	$r = mysqli_query(dbc(),"SELECT id, title  FROM departments  ORDER BY title");
	if(mysqli_num_rows($r) > 0 )
	{
		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			if($department == $row['id'])
			{
				$output = "<option value=\"$row[id]\" selected>";
				$output .=  $row['title'];
				$output .="</option>";

			}
			else
			{
				$output = "<option value=\"$row[id]\" >";
				$output .= $row['title'];
				$output .="</option>";

			}


			echo $output;
		}
	}
	else
	{

			$output = "<option>";
			$output .="Not added yet";
			$output .="</option>";

			echo $output;
	}
}
//end of select department














//get course name passed by id of the course
function get_course_title($id)
{
	$result = mysqli_query(dbc(),"SELECT title FROM courses WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$title = $row['title'];

	return $title;
}

//get course name passed by id of the course
function get_course_title_by_md5($id)
{
	$result = mysqli_query(dbc(),"SELECT title FROM courses WHERE md5(id) = '$id'");
		$row = mysqli_fetch_assoc($result);
		$title = $row['title'];

	return $title;
}



//get course name passed by id of the course
function get_course_code($id)
{
	$result = mysqli_query(dbc(),"SELECT code FROM courses WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$title = $row['code'];

	return $title;
}


//get course name passed by id of the course unit
function get_course_unit($id)
{
	$result = mysqli_query(dbc(),"SELECT unit FROM courses WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$title = $row['unit'];

	return $title;
}



//get course name pasget course type
function get_course_type($id)
{
	$result = mysqli_query(dbc(),"SELECT course_type FROM courses WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$v = $row['course_type'];

	return $v;
}


//function get course type retrun value
function get_course_type_string($id)
{
	if($id == 1)
	{
		return "C";
	}
	else
	{
		return "E";
	}

}





//get course name passed by id of the course
function get_course_code_by_md5($id)
{
	$result = mysqli_query(dbc(),"SELECT code FROM courses WHERE md5(id) = '$id'");
		$row = mysqli_fetch_assoc($result);
		$title = $row['code'];

	return $title;
}






//get course name passed by id of the course
function get_course_category_by_md5($id)
{
	$result = mysqli_query(dbc(),"SELECT course_category FROM courses WHERE md5(id) = '$id'");
		$row = mysqli_fetch_assoc($result);
		$course_category = $row['course_category'];

	return $course_category;
}


//get 100 level SED courses for
function get_comma_separated_courses($session, $semester, $level, $programme_id, $department)
{
	//get the headers in spilited format
	$qh = "SELECT GROUP_CONCAT(pc.course_id ORDER BY c.code DESC)  AS coded

				FROM `programmes_courses_nce` pc , courses c

				WHERE pc.level = '$level' AND pc.programme_id = $programme_id
				AND c.id = pc.course_id AND c.semester = $semester
				AND c.course_category = 0 AND c.department_id = $department";



		$rh = mysqli_query(dbc(),$qh);

		if(mysqli_num_rows($rh) > 0)
		{


		  while($rowh = mysqli_fetch_array($rh,MYSQLI_ASSOC))
		  {


		       $couse_codes_h = $rowh['coded'];
		  }

		}


	return $couse_codes_h;
}


//function that generates admission number students

//first we need to get applied  department of the student

//second we need to get department title by id

//we need to get department code by id

//we need to get the total number of people in the dept




//function that gets school title
function  get_school_title($id)
{
	$result = mysqli_query(dbc(),"SELECT title FROM schools WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$title = $row['title'];

	return $title;

}


//function that gets department title
function  get_department_title($id)
{
	$result = mysqli_query(dbc(),"SELECT * FROM departments WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$title = $row['title'];

	return $title;

}

//function that gets department code base department id
function  get_department_code($id)
{
	$result = mysqli_query(dbc(),"SELECT code FROM departments WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$code = $row['code'];

	return $code;

}




//programme function
//get progrmmae title
function  get_programme_title($id)
{
		$result = mysqli_query(dbc(),"SELECT title FROM programmes WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$title = $row['title'];

	return $title;

}


//programme function
//get progrmmae code
function  get_programme_code($id)
{
		$result = mysqli_query(dbc(),"SELECT code FROM programmes WHERE id = '$id'");
		$row = mysqli_fetch_assoc($result);
		$v = $row['code'];

	return $v;

}

//get programme id using  code
function get_programme_id_by_code($code)
{
	$result = mysqli_query(dbc(),"SELECT id FROM programmes WHERE code = '$code' AND real_ = '1'");
		$row = mysqli_fetch_assoc($result);
		$id = $row['id'];

	return $id;
}

//function that gets programme_id base on user id
	 function  get_sed_programme_ids($sed,$type_id, $mode,$dept_id)
	 {
		 $result = mysqli_query(dbc(),"SELECT id  FROM `programmes` WHERE `code` LIKE '$sed' AND type_id = '$type_id' AND mode = '$mode' AND department_id ".$dept_id);

		 $pids = [];
		 while($row = mysqli_fetch_array($result))
		 {
			 $pid = $row['id'];
			 array_push($pids, $pid);
		 }



		 return $pids;

	 }



	 //function that gets programme_id base on user id
	 	 function  get_comma_separated_sed_programme_ids($sed,$type_id, $mode,$dept_id)
	 	 {
	 		 $q = "SELECT GROUP_CONCAT(id) as prog  FROM `programmes` WHERE `code` LIKE '$sed' AND type_id = '$type_id' AND mode = '$mode' AND department_id ".$dept_idv;

			 	$r = mysqli_query(dbc(),$q);


			 	$output = '';

			 	if(mysqli_num_rows($r) > 0 )
			 	{
			 		$row = mysqli_fetch_array($r, MYSQLI_ASSOC);

			 		$output = $row['prog'];

			 	}//end of if there is value
			 	else
			 	{
			 		$output = '';
			 	}


			 	return $output;

	 	 }



	 //displays course based on title
function list_special_sed_programme_codes($cs_arr,$old_pid, $session,$semester,$sid,$second_debt,$level)
{
	 $dt = '';
	foreach ($cs_arr  as $cs) {
      // $dt .= '<option value='.$cs.'>'. get_programme_title( $cs).'</option>';

			 $dt .= '<li><a target="_blank" href="print_form_a2_per_semester_core_sed.php?mis='.md5('mis').'&ses='. $session.'&sem='. $semester.'&sid='.$sid.'&pid='.$cs.'&old_pid='.$old_pid.'&did='.$second_debt.'&lvl='.$level.'&core=2" > '.get_programme_code($cs).' FORM A </a></li>';

    }

    return $dt;



}


//displays course based on title for summer
function list_special_sed_programme_codes_summer($cs_arr,$old_pid, $session,$semester,$sid,$second_debt,$level)
{
$dt = '';
foreach ($cs_arr  as $cs) {
	 // $dt .= '<option value='.$cs.'>'. get_programme_title( $cs).'</option>';

		$dt .= '<li><a target="_blank" href="print_form_a2_per_semester_core_sed.php?mis='.md5('mis').'&ses='. $session.'&sem='. $semester.'&sid='.$sid.'&pid='.$cs.'&old_pid='.$old_pid.'&did='.$second_debt.'&lvl='.$level.'&core=2" > '.get_programme_code($cs).' FORM A </a></li>';

 }

 return $dt;



}


//displays course based on title for printing form b2
function list_special_sed_programme_codes_form_b2($cs_arr,$old_pid, $session,$semester,$sid,$second_debt,$level)
{
$dt = '';
foreach ($cs_arr  as $cs) {
	 // $dt .= '<option value='.$cs.'>'. get_programme_title( $cs).'</option>';

		$dt .= '<li><a target="_blank" href="print_form_b2_per_semester_sed.php?mis='.md5('mis').'&ses='. $session.'&sem='. $semester.'&sid='.$sid.'&pid='.$cs.'&old_pid='.$old_pid.'&did='.$second_debt.'&lvl='.$level.'" > '.get_programme_code($cs).' FORM B2 </a></li>';



 }

 return $dt;



}


//displays course based on title for printing form b2
function list_special_sed_programme_codes_cummulative_summary($cs_arr,$old_pid, $session,$semester,$sid,$second_debt,$level)
{
$dt = '';
foreach ($cs_arr  as $cs) {
	 // $dt .= '<option value='.$cs.'>'. get_programme_title( $cs).'</option>';

		$dt .= '<li><a target="_blank" href="print_cummulative_summary_per_semester_sed.php?mis='.md5('mis').'&ses='. $session.'&sem='. $semester.'&sid='.$sid.'&pid='.$cs.'&old_pid='.$old_pid.'&did='.$second_debt.'&lvl='.$level.'" > '.get_programme_code($cs).' CUMMULATIVE SUMMARY </a></li>';
		$dt .= '<li><a target="_blank" href="print_graduation_summary_per_semester_sed.php?mis='.md5('mis').'&ses='. $session.'&sem='. $semester.'&sid='.$sid.'&pid='.$cs.'&old_pid='.$old_pid.'&did='.$second_debt.'&lvl='.$level.'" > '.get_programme_code($cs).' CUMMULATIVE SUMMARY </a></li>';



 }

 return $dt;



}


//get subject name passed by  md5 id of the course
function get_md5_course_title($id)
{
	$result = mysqli_query(dbc(),"SELECT * FROM courses WHERE md5(id) = '$id'");
		$row = mysqli_fetch_assoc($result);
		$title = $row['title'];

	return $title;
}

//get school id using programme _id
function get_school_id_using_programme_id($id)
{
	$query = "SELECT  school_id   FROM programmes WHERE id ='$id'";
	$result = mysqli_query(dbc(),$query);
	$row = mysqli_fetch_assoc($result);

	$v =  $row['school_id'];

	return $v;

}




//function that gets course code base on course id
//function  get_course_code($id)
//{
//	$result = mysqli_query(dbc(),"SELECT * FROM courses WHERE id = '$id'");
//		$row = mysqli_fetch_assoc($result);
//		$code = $row['course_code'];
//
//	return $code;
//
//}


//function get schools list fro cummulative summary
function get_schools_list_cummulative_summary()
{

	$sn = 0; // serial no
	//query the database
	$q = "SELECT id, title, description, status
		 FROM  schools
		 WHERE status = 0
		 AND id != 8
		 AND id != 9
		 ORDER BY title ASC"; //AND id = '$department'
	$r = mysqli_query(dbc(),$q);

	if(mysqli_num_rows($r) > 0)
	{//show table



		  $output =
		  '<table id="example" class="user display table-bordered table-hover table-striped" cellspacing="0" width="100%" style="font-size:12px;">
			<thead>
						<th>S/NO. </th>
						<th>SCHOOLS / GENERAL STUDIES / EDUCATION </th>
						<th></th>


			</thead>
			<tfoot>
						<th>S/NO. </th>
						<th>SCHOOLS / GENERAL STUDIES / EDUCATION </th>
						<th></th>




			</tfoot>

			<tbody>';

		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			$sn = $sn + 1;

			$output .= "<tr>";
			$output .="<td>".$sn."</td>" ;
			$output .= "<td>".$row['title']."</td>";

			$output .= "<td>";
			$output .= '<div class="btn-group">
		 <button type="button" class="btn btn-success dropdown-toggle" data-toggle="dropdown"><i class="glyphicon glyphicon-search"></i>
			 VIEW <span class="caret"></span>
		 </button>';
		 $output .= '<ul class="dropdown-menu">';
		 $output .= '  <li><a href="gateway.php?act=view_programmes_list_cummulative_summary&ses=5&sem=1&sid='.$row['id'].'&pid='.$pid.'&level=III" > 2019/2020 </a></li>

				<li><a  href="gateway.php?act=view_programmes_list_cummulative_summary&ses=6&sem=1&sid='.$row['id'].'&pid='.$pid.'&level=III" > 2020/2021 </a></li>


				<li><a  href="gateway.php?act=view_programmes_list_cummulative_summary&ses=7&sem=1&sid='.$row['id'].'&pid='.$pid.'&level=III" > 2021/2022 </a></li>
				<li><a  href="gateway.php?act=view_programmes_list_cummulative_summary&ses=8&sem=1&sid='.$row['id'].'&pid='.$pid.'&level=III" > 2022/2023 </a></li>
				<li><a  href="gateway.php?act=view_programmes_list_cummulative_summary&ses=9&sem=1&sid='.$row['id'].'&pid='.$pid.'&level=III" > 2023/2024 </a></li>
				<li><a  href="gateway.php?act=view_programmes_list_cummulative_summary&ses=10&sem=1&sid='.$row['id'].'&pid='.$pid.'&level=III" > 2024/2025 </a></li>
				<li><a  href="gateway.php?act=view_programmes_list_cummulative_summary&ses=11&sem=1&sid='.$row['id'].'&pid='.$pid.'&level=III" > 2025/2026 </a></li>';


		 $output .= '</ul>';
	   $output .= '</div>';

     $output .= "</td>";

		 $output .= "</tr>";


		// 	 "<a href='gateway.php?act=view_programmes_list_cummulative_summary&xid=".md5(8)."&sid=".$row['id']."' class='btn btn-success btn-sm'  >  NCE </a>
		//
		//
    //    echo '&nbsp&nbsp <div class="btn-group">
    //   <button type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown"><i class="glyphicon glyphicon-search"></i>
    //     View <span class="caret"></span>
    //   </button>
    //   <ul class="dropdown-menu">
    //     <li><a target="_blank" href="gateway.php?act=view_students_list_form_b2&ses='. $session.'&sem=1&sid='.$sid.'&pid='.$pid.'&level=III" > Students </a></li>
		//
    //      <li><a target="_blank" href="gateway.php?act=view_students_list_enter_scores&ses='. $session.'&sem=1&sid='.$sid.'&pid='.$pid.'&level=III" > Students (Enter Scores) </a></li>
		//
		//
		// 		 <li><a target="_blank" href="gateway.php?act=view_students_reg&ses='. $session.'&sem=1&sid='.$sid.'&pid='.$pid.'&level=III" > Reg. Students </a></li>
		//
    //   </ul>
    // </div>';

			// <a href='gateway.php?act=view_programmes_list_prence_cummulative_summary&xid=".md5(8)."&sid=".$row['id']."' class='btn btn-default btn-sm'  > PRE NCE </a>

			// <a href='gateway.php?act=view_programmes_list_cummulative_summary_summer&xid=".md5(8)."&sid=".$row['id']."' class='btn btn-danger btn-sm'  >SMR </a>

// <a href='gateway.php?act=view_programmes_list&xid=".md5(8)."&sid=".$row['id']."' class='btn btn-success btn-sm'  > VIEW NCE </a>
			//<a href='gateway.php?act=view_programmes_list&xid=".md5(8)."&sid=".$row['id']."' class='btn btn-success btn-sm'  > NCE </a>
			//$output .= "<td>".get_faculty_title($row['faculty_id'])."</td>";
			//$output .= "<td><img src='../departments/hods/".$row['hod_picture']."' height='100px' width='100px' /> </td>";
			//$output .= "<td>".get_school_title($row['school_id'])."</td>";



		}
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;




}//end of get school lists for cummulative summary


//function get schools list fro result computation
function get_schools_list_cr()
{

	$sn = 0; // serial no
	//query the database
	$q = "SELECT id, title, description, status
		 FROM  schools
		 WHERE status = 0
		 ORDER BY date_added DESC, date_modified DESC"; //AND id = '$department'
	$r = mysqli_query(dbc(),$q);

	if(mysqli_num_rows($r) > 0)
	{//show table



		  $output =
		  '<table id="example" class="user display table-bordered table-hover table-striped" cellspacing="0" width="100%" style="font-size:12px;">
			<thead>
						<th>S/NO. </th>
						<th>SCHOOLS / GENERAL STUDIES / EDUCATION </th>
						<th></th>


			</thead>
			<tfoot>
						<th>S/NO. </th>
						<th>SCHOOLS / GENERAL STUDIES / EDUCATION </th>
						<th></th>




			</tfoot>

			<tbody>';

		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			$sn = $sn + 1;

			$output .= "<tr>";
			$output .="<td>".$sn."</td>" ;
			$output .= "<td>".$row['title']."</td>";

			$output .= "<td><a href='gateway.php?act=view_programmes_list_cr&xid=".md5(8)."&sid=".$row['id']."' class='btn btn-success btn-sm'  >  NCE </a>

			&nbsp &nbsp

			    <a href='gateway.php?act=view_programmes_list_prence_cr&xid=".md5(8)."&sid=".$row['id']."' class='btn btn-default btn-sm'  > PRE NCE </a>


					&nbsp &nbsp

			 	<a href='gateway.php?act=view_programmes_list_cr_summer&xid=".md5(8)."&sid=".$row['id']."' class='btn btn-danger btn-sm'  >SMR </a>





			</td>";
// <a href='gateway.php?act=view_programmes_list&xid=".md5(8)."&sid=".$row['id']."' class='btn btn-success btn-sm'  > VIEW NCE </a>
			//<a href='gateway.php?act=view_programmes_list&xid=".md5(8)."&sid=".$row['id']."' class='btn btn-success btn-sm'  > NCE </a>
			//$output .= "<td>".get_faculty_title($row['faculty_id'])."</td>";
			//$output .= "<td><img src='../departments/hods/".$row['hod_picture']."' height='100px' width='100px' /> </td>";
			//$output .= "<td>".get_school_title($row['school_id'])."</td>";

			$output .= "</tr>";


		}
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;




}//end of get school lists for compute result

//function get schools list
function get_schools_list()
{

	$sn = 0; // serial no
	//query the database
	$q = "SELECT id, title, description, status
		 FROM  schools
		 WHERE status = 0
		 ORDER BY date_added DESC, date_modified DESC"; //AND id = '$department'
	$r = mysqli_query(dbc(),$q);

	if(mysqli_num_rows($r) > 0)
	{//show table



		  $output =
		  '<table id="example" class="user display table-bordered table-hover table-striped" cellspacing="0" width="100%" style="font-size:12px;">
			<thead>
						<th>S/NO. </th>
						<th>SCHOOLS / GENERAL STUDIES / EDUCATION </th>
						<th></th>


			</thead>
			<tfoot>
						<th>S/NO. </th>
						<th>SCHOOLS / GENERAL STUDIES / EDUCATION </th>
						<th></th>




			</tfoot>

			<tbody>';

		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			$sn = $sn + 1;

			$output .= "<tr>";
			$output .="<td>".$sn."</td>" ;
			$output .= "<td>".$row['title']."</td>";

			$output .= "<td><a href='gateway.php?act=view_programmes_list&xid=".md5(8)."&sid=".$row['id']."' class='btn btn-success btn-sm'  > NCE </a>
			           <a href='gateway.php?act=view_programmes_list_prence&xid=".md5(8)."&sid=".$row['id']."' class='btn btn-default btn-sm'  > PRE NCE </a>
								 <a href='gateway.php?act=view_programmes_list_summer&xid=".md5(8)."&sid=".$row['id']."' class='btn btn-danger btn-sm'> SMR </a>

								 	 <a href='gateway.php?act=view_courses_gen_export&xid=".md5(8)."&sid=".$row['id']."' class='btn btn-default btn-sm'> GEN EXP. </a>

								 </td>";

			//$output .= "<td> <a href='gateway.php?act=view_courses&xid=".md5(8)."&sid=".$sid."&pid=".$row['id']."'>".$row['title']."</a></td>";

			//$output .= "<td>".get_faculty_title($row['faculty_id'])."</td>";
			//$output .= "<td><img src='../departments/hods/".$row['hod_picture']."' height='100px' width='100px' /> </td>";
			//$output .= "<td>".get_school_title($row['school_id'])."</td>";

			$output .= "</tr>";


		}
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;




}//end of get school lists




//function get departments list
function get_departments_list()
{

	$sn = 0; // serial no
	//query the database
	$q = "SELECT id, title, description, status, school_id
		 FROM  departments
		 WHERE status = '0'
		 ORDER BY date_added DESC, date_modified DESC"; //AND id = '$department'
	$r = mysqli_query(dbc(),$q);

	if(mysqli_num_rows($r) > 0)
	{//show table



		  $output =
		  '<table id="example" class="user display table-bordered table-hover table-striped" cellspacing="0" width="100%" style="font-size:12px;">
			<thead>
						<th>S/No. </th>
						<th>Title</th>
						<th>School</th>


			</thead>
			<tfoot>
						<th>S/No. </th>
						<th>Title</th>
						<th>School</th>




			</tfoot>

			<tbody>';

		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			$sn = $sn + 1;

			$output .= "<tr>";
			$output .="<td>".$sn."</td>" ;
			$output .= "<td> <a href='gateway.php?act=view_programmes_list&xid=".md5(8)."&did=".$row['id']."'>".$row['title']."</a></td>";
			//$output .= "<td>".get_faculty_title($row['faculty_id'])."</td>";
			//$output .= "<td><img src='../departments/hods/".$row['hod_picture']."' height='100px' width='100px' /> </td>";
			$output .= "<td>".get_school_title($row['school_id'])."</td>";

			$output .= "</tr>";


		}
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;




}//end of get department lists


//function get programme list for cummulative summary
function get_programmes_list_cummulative_summary($sid,$ses)
{  //now switch the programme list based on core / general studies / education



	$mid = get_user_department($user_id); // the main department_id


	//check if the programme is a sed programme
			//checking eiither new special edu course or old
			// if ($mid != 12) //12 is set for old sed structure
			// {
			//
			//  $sed_pids = get_sed_programme_ids( '%SED%',$type_id = 2, $mode = 1,$dept_idd = '!= 12');
			// }
			// else
			// {
			 $sed_pids = get_sed_programme_ids( '%SED%',$type_id = 2, $mode = 1,$dept_idd = '= 12');
			// }




		//query the database
		$q = "SELECT id, title, description, status, school_id,department_id
			 FROM  programmes
			 WHERE school_id = '$sid'
			 AND status = 0
			 AND type_id = 2
			 AND mode = 1
			 AND code NOT LIKE '%SHI%'
 			 AND code NOT LIKE '%SLD%'
 			 AND code NOT LIKE '%SVI%'
			 AND department_id != 12

			 ORDER BY title ASC";

			// commented archaic special department
			//  AND code NOT LIKE '%SHI%'
			// AND code NOT LIKE '%SLD%'
			// AND code NOT LIKE '%SVI%'



	// }


		$r = mysqli_query(dbc(),$q); //result of the sql query




		if(mysqli_num_rows($r) > 0)
		{//show table


			$sn = 0; // serial no

			//play arround


			  $output =
			  '<table id="example" class="user display table-bordered table-hover table-striped" cellspacing="0" width="100%" style="font-size:12px;">
				<thead>
							<th>S/No. </th>
							<th>Programme Combination</th>
							<th>Department</th>
							<th>Action</th>



				</thead>
				<tfoot>

							<th>S/No. </th>
							<th>Programme Combination</th>
							<th>Department</th>
							<th>Action</th>





				</tfoot>

				<tbody>';

			while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
			{
				//here sid passed is collected from the parameters because we want to track virtual schools


				$sn = $sn + 1;

				//programme id
				$pid = $row['id'];
				$prog_code = get_programme_code($pid); //get programme code



				$sed_std = false;
				if(in_array($pid, $sed_pids))
				{
				  $sed_pro = true;
				  //echo  'yes';
				  //$sed_prog_id = get_user_sed_prog_id($user_id);
				}

				$output .= "<tr>";
				$output .="<td>".$sn."</td>" ;
				$output .= "<td> ".$row['title']."</td>";
				$output .= "<td>".get_department_title($row['department_id'])."</td>";

			  $output .= "<td>"; //"<a href='gateway.php?act=view_programmes_list_cummulative_summary&xid=".md5(8)."&sid=".$row['id']."' class='btn btn-success btn-sm'  >  NCE </a>



					//work on the short code for different core courses
				 		 $debt_comb_array =array();

				 		 //get department comb of programme combination
				 		 $debt_comb = get_department_comb_using_programme_id($pid);

				 			 //get headings for the core departments


				 			 //
				 			 if(strpos($debt_comb, ',') !== false )
				 			 {

				 				 for ($i = 0; $i < count($debt_comb);$i++)
				 				 {
				 						$debt_comb_array = explode(',', $debt_comb);


				 				 }

				 					$first_debt = $debt_comb_array[0];

				 					$second_debt = $debt_comb_array[1];


				 					$first_debt_code = get_department_code($first_debt);

				 					 $second_debt_code = get_department_code($second_debt);

				 			 }
				 			 else
				 			 {

				 				 //get department id using programme id
				 				$first_debt =  get_department_using_programme_id($pid);

				 				$first_debt_code = get_department_code($first_debt);
				 				$second_debt = '';



				 				 //get short code for department

				 			 }


				 																					$output .= '&nbsp&nbsp <div class="btn-group">
				 	 <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown"> <i class="glyphicon glyphicon-print"></i>
				 		 PRINT  <span class="caret"></span>
				 	 </button>
				 	 <ul class="dropdown-menu">';



				 		 if ($sed_pro )//&& isset($sed_pids) && !empty($sed_pids)  && $level != 'I'
				 		 {


				 				 //geting the prog sub string since it is 3
				 				 $prog_full_code = '';
				 				 $prog_code_str1 = substr($prog_code,0,3);
				 				 $prog_code_str2 = substr($prog_code,4);

				 				 $prg_str_arr = ['SHI','SLD','SVI'];
				 				 $prog_ids_arr = [];

				 				 //get the Programmes for dropdown
				 				 foreach ($prg_str_arr  as $ps)
				 				 {
				 					 if ($row['department_id'] != '12')
				 					 {

				 						 $prog_full_code = $prog_code_str1.'-'.$ps;
				 					 }
				 					 else
				 					 {

				 						 $prog_full_code = $prog_code_str2.'-'.$ps;
				 					 }

				 					 $new_pid = get_programme_id_by_code($prog_full_code);
				 					 //echo $prog_full_code;
				 					 //validate the new ids
				 					 if (strlen($new_pid) > 0)
				 					 {
				 						 array_push($prog_ids_arr, $new_pid);
				 					 }
				 				 }

				 				 //print_r($prog_ids_arr);

				 					$output .=  list_special_sed_programme_codes_cummulative_summary($prog_ids_arr,$pid,$ses,$semester=2,$sid,$second_debt,$level='III');
				 		 }
				 		 else //if not sed
				 		 {
				 			 $output .= '<li><a target="_blank" href="print_cummulative_summary_per_semester.php?mis='.md5('mis').'&ses='. $ses.'&sem=2&sid='.$sid.'&pid='.$pid.'&lvl=III" > CUMMULATIVE SUMMARY</a> </li>';
							 $output .= '<li><a target="_blank" href="print_graduation_summary_per_semester.php?mis='.md5('mis').'&ses='. $ses.'&sem=2&sid='.$sid.'&pid='.$pid.'&lvl=III" > GRADUATION LIST SUMMARY PDF</a> </li>';
							 $output .= '<li><a target="_blank" href="includes/tab_menu/tab_view_graduation_summary_per_semester.php?mis='.md5('mis').'&ses='. $ses.'&sem=2&sid='.$sid.'&pid='.$pid.'&lvl=III" > GRADUATION LIST SUMMARY CSV</a> </li>';

				 		 }


				$output .= "</ul></div>";

				$output .= "&nbsp &nbsp</td>";


				$output .= "</tr>";


			}
		}
		else
		{//show the msg

				$output =
					   '<div class="alert alert-danger alert-dismissable">
						<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
						<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
					   </div>';


		}



		$output .=
		'</tbody>
	    </table>';






	return $output;




}//end of get programme lists for cummulative summary


//function get programme list for computing result
function get_programmes_list_cr($sid)
{  //now switch the programme list based on core / general studies / education



	// if($sid == 8)//if general studies
	// {

	// 	//fetch by all schools base on general studies
	// 	$q = "SELECT id, title, description, status, school_id,department_id
	// 		 FROM  programmes
	// 		 WHERE  status = 0
	// 		 AND type_id = 2
	// 		 AND mode = 1

	// 		 ORDER BY title ASC";


	// }
	// else if($sid == 9)//if education
	// {

	// 	//fetch by all schools base on education
	// 	$q = "SELECT id, title, description, status, school_id,department_id
	// 		 FROM  programmes
	// 		 WHERE  status = 0
	// 		 AND type_id = 2
	// 		 AND mode = 1

	// 		 ORDER BY title ASC";

	// }
	// else
	// {

		//query the database
		$q = "SELECT id, title, description, status, school_id,department_id
			 FROM  programmes
			 WHERE school_id = '$sid'
			 AND status = 0
			 AND type_id = 2
			 AND mode = 1
			 AND code NOT LIKE '%SHI%'
			 AND code NOT LIKE '%SLD%'
			 AND code NOT LIKE '%SVI%'

			 ORDER BY date_added DESC, date_modified DESC";



	// }


		$r = mysqli_query(dbc(),$q); //result of the sql query




		if(mysqli_num_rows($r) > 0)
		{//show table


			$sn = 0; // serial no


			  $output =
			  '<table id="example" class="user display table-bordered table-hover table-striped" cellspacing="0" width="100%" style="font-size:12px;">
				<thead>
							<th>S/No. </th>
							<th>Programme Combination</th>
							<th>Department</th>
							<th>School</th>



				</thead>
				<tfoot>

							<th>S/No. </th>
							<th>Programme Combination</th>
							<th>Department</th>
							<th>School</th>





				</tfoot>

				<tbody>';

			while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
			{
				//here sid passed is collected from the parameters because we want to track virtual schools


				$sn = $sn + 1;

				$output .= "<tr>";
				$output .="<td>".$sn."</td>" ;
				$output .= "<td> <a href='gateway.php?act=view_courses_cr&xid=".md5(8)."&sid=".$sid."&pid=".$row['id']."'>".$row['title']."</a></td>";
				$output .= "<td>".get_department_title($row['department_id'])."</td>";

			    $output .= "<td>".get_school_title($row['school_id'])."</td>";


				$output .= "</tr>";


			}
		}
		else
		{//show the msg

				$output =
					   '<div class="alert alert-danger alert-dismissable">
						<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
						<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
					   </div>';


		}



		$output .=
		'</tbody>
	    </table>';






	return $output;




}//end of get programme lists for computing results

//function get programme list for computing result for summer
function get_programmes_list_cr_summer($sid)
{  //now switch the programme list based on core / general studies / education



$session = 6;

//for query and open the summer

		//query the database
		$q = "SELECT id, title, description, status, school_id,department_id
			 FROM  programmes
			 WHERE school_id = '$sid'
			 AND status = 0
			 AND type_id = 2
			 AND mode = 1

			 ORDER BY date_added DESC, date_modified DESC";



	// }
	//
	// AND code NOT LIKE '%SHI%'
	// AND code NOT LIKE '%SLD%'
	// AND code NOT LIKE '%SVI%'


		$r = mysqli_query(dbc(),$q); //result of the sql query




		if(mysqli_num_rows($r) > 0)
		{//show table


			$sn = 0; // serial no


			  $output =
			  '<table id="example" class="user display table-bordered table-hover table-striped" cellspacing="0" width="100%" style="font-size:12px;">
				<thead>
							<th>S/No. </th>
							<th>Programme Combination</th>
							<th>Department</th>
							<th>School</th>
							<th>Action</th>



				</thead>
				<tfoot>

							<th>S/No. </th>
							<th>Programme Combination</th>
							<th>Department</th>
							<th>School</th>
							<th>Action</th>



				</tfoot>

				<tbody>';

			while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
			{
				//here sid passed is collected from the parameters because we want to track virtual schools

				$pid = $row['id'];


				$sn = $sn + 1;

				$output .= "<tr>";
				$output .="<td>".$sn."</td>" ;
				//gateway.php?act=view_courses_cr_summer&xid=".md5(8)."&sid=".$sid."&pid=".$row['id']."
				$output .= "<td> <a href='#'>".$row['title']."</a></td>";
				$output .= "<td>".get_department_title($row['department_id'])."</td>";

			  $output .= "<td>".get_school_title($row['school_id'])."</td>";



$output .= "<td><a href='includes/tab_menu/tab_view_course_export_students_list_summer_export.php?xid=".md5(8)."&sid=".$sid."&pid=".$row['id']."&ses=xx&sem=x' class='btn btn-danger btn-sm'> DOWNLOAD LIST </a>
";

//includes/tab_menu/
//http://staff.ibbuiceel.edu.ng/includes/tab_menu/tab_view_course_export_students_list.php?cid=&mis=2726b49efa173a4e13707939a6925cde&did=1&ses=1&sem=1&level=100





										                                                  //work on the short code for different core courses
										                                                      $debt_comb_array =array();

										                                                      //get department comb of programme combination
										                                                      $debt_comb = get_department_comb_using_programme_id($pid);

										                                                        //get headings for the core departments


										                                                        //
										                                                        if(strpos($debt_comb, ',') !== false )
										                                                        {

										                                                          for ($i = 0; $i < count($debt_comb);$i++)
										                                                          {
										                                                             $debt_comb_array = explode(',', $debt_comb);


										                                                          }

										                                                           $first_debt = $debt_comb_array[0];

										                                                           $second_debt = $debt_comb_array[1];


										                                                           $first_debt_code = get_department_code($first_debt);

										                                                            $second_debt_code = get_department_code($second_debt);

										                                                        }
										                                                        else
										                                                        {

										                                                          //get department id using programme id
										                                                         $first_debt =  get_department_using_programme_id($pid);

										                                                         $first_debt_code = get_department_code($first_debt);
										                                                         $second_debt = '';

										                                                          //get short code for department

										                                                        }

																																						//'. 5.'


										                                                      $output .= '
																																					&nbsp&nbsp <div class="btn-group">
																																				 <button type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown"><i class="glyphicon glyphicon-search"></i>
																																					 1ST Sem. <span class="caret"></span>
																																				 </button>
																																				 <ul class="dropdown-menu">



																																					    <li><a target="_blank" href="print_form_a2_per_semester_summer.php?mis='.md5('mis').'&ses='.$session.'&sem=1&sid='.$sid.'&pid='.$pid.'&lvl=SMR" > FORM A2 </a></li>

										                                                          <li><a target="_blank" href="print_form_a2_per_semester_gse_summer.php?mis='.md5('mis').'&ses='. $session.'&sem=1&sid='.$sid.'&pid='.$pid.'&lvl=SMR" > GSE FORM A </a></li>

										                                                          <li><a target="_blank" href="print_form_a2_per_semester_edu_summer.php?mis='.md5('mis').'&ses='. $session.'&sem=1&sid='.$sid.'&pid='.$pid.'&lvl=SMR" > EDU FORM A </a></li>


										                                                          <li class="divider"></li>';

										                                                      $output .= '<li><a target="_blank" href="print_form_a2_per_semester_core_summer.php?mis='.md5('mis').'&ses='. $session.'&sem=1&sid='.$sid.'&pid='.$pid.'&did='.$first_debt.'&lvl=SMR&core=1" > '.$first_debt_code.' FORM A </a></li>';

										                                                      if($second_debt !== '')
										                                                      {


																																						//if not epmty check if its SED programme or not
																																						//convert this guy to function in the next session
																																						//
																																						if ($sed_pro && isset($sed_pids) && !empty($sed_pids)  && $level != 'I')
																																						{


																																		            //geting the prog sub string since it is 3
																																		            $prog_full_code = '';
																																		            $prog_code_str1 = substr($prog_code,0,3);
																																		            $prog_code_str2 = substr($prog_code,4);

																																		            $prg_str_arr = ['SHI','SLD','SVI'];
																																		            $prog_ids_arr = [];

																																		            //get the Programmes for dropdown
																																		            foreach ($prg_str_arr  as $ps)
																																								{
																																		              if ($mid != '12')
																																									{

																																		                $prog_full_code = $prog_code_str1.'-'.$ps;
																																		              }
																																									else
																																									{

																																		                $prog_full_code = $prog_code_str2.'-'.$ps;
																																		              }

																																		              $new_pid = get_programme_id_by_code($prog_full_code);
																																		              //echo $prog_full_code;
																																		              //validate the new ids
																																		              if (strlen($new_pid) > 0)
																																									{
																																		                array_push($prog_ids_arr, $new_pid);
																																		              }
																																		            }

																																		            //print_r($prog_ids_arr);

																																								 $output .= list_special_sed_programme_codes_summer($prog_ids_arr,$pid,$session,$semester=1,$sid,$second_debt,$level='SMR');
																																		        }
																																						else //if not sed
																																						{
																																							$output .='<li><a target="_blank" href="print_form_a2_per_semester_core_summer.php?mis='.md5('mis').'&ses='. $session.'&sem=1&sid='.$sid.'&pid='.$pid.'&did='.$second_debt.'&lvl=SMR&core=2" > '.$second_debt_code.' FORM A </a></li>';

																																						}

										                                                      }
																																					else //if it doesnt have second combination
																																					{
																																							$output .= '<li><a target="_blank" href="print_form_a2_per_semester_core_summer.php?mis='.md5('mis').'&ses='. $session.'&sem=1&sid='.$sid.'&pid='.$pid.'&did='.$second_debt.'&lvl=SMR&core=2" > '.$second_debt_code.' FORM A </a></li>';

																																					}



										                                                  $output .= '
																																			</ul>
										                                                  </span>'; //end of  /.btn group




																																			$output .= '
																																			&nbsp&nbsp <div class="btn-group">
																																		 <button type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown"><i class="glyphicon glyphicon-search"></i>
																																			 2ND Sem. <span class="caret"></span>
																																		 </button>
																																		 <ul class="dropdown-menu">



																																					<li><a target="_blank" href="print_form_a2_per_semester_summer.php?mis='.md5('mis').'&ses='.$session.'&sem=2&sid='.$sid.'&pid='.$pid.'&lvl=SMR" > FORM A2 </a></li>

																																					<li><a target="_blank" href="print_form_a2_per_semester_gse_summer.php?mis='.md5('mis').'&ses='. $session.'&sem=2&sid='.$sid.'&pid='.$pid.'&lvl=SMR" > GSE FORM A </a></li>

																																					<li><a target="_blank" href="print_form_a2_per_semester_edu_summer.php?mis='.md5('mis').'&ses='. $session.'&sem=2&sid='.$sid.'&pid='.$pid.'&lvl=SMR" > EDU FORM A </a></li>


																																					<li class="divider"></li>';

																																			 $output .=  '<li><a target="_blank" href="print_form_a2_per_semester_core_summer.php?mis='.md5('mis').'&ses='. $session.'&sem=2&sid='.$sid.'&pid='.$pid.'&did='.$first_debt.'&lvl=SMR&core=1" > '.$first_debt_code.' FORM A </a></li>';

																																			if($second_debt !== '')
																																			{


																																				//if not epmty check if its SED programme or not
																																				//convert this guy to function in the next session
																																				//
																																				if ($sed_pro && isset($sed_pids) && !empty($sed_pids)  && $level != 'I')
																																				{


																																						//geting the prog sub string since it is 3
																																						$prog_full_code = '';
																																						$prog_code_str1 = substr($prog_code,0,3);
																																						$prog_code_str2 = substr($prog_code,4);

																																						$prg_str_arr = ['SHI','SLD','SVI'];
																																						$prog_ids_arr = [];

																																						//get the Programmes for dropdown
																																						foreach ($prg_str_arr  as $ps)
																																						{
																																							if ($mid != '12')
																																							{

																																								$prog_full_code = $prog_code_str1.'-'.$ps;
																																							}
																																							else
																																							{

																																								$prog_full_code = $prog_code_str2.'-'.$ps;
																																							}

																																							$new_pid = get_programme_id_by_code($prog_full_code);
																																							//echo $prog_full_code;
																																							//validate the new ids
																																							if (strlen($new_pid) > 0)
																																							{
																																								array_push($prog_ids_arr, $new_pid);
																																							}
																																						}

																																						//print_r($prog_ids_arr);

																																						 $output .= list_special_sed_programme_codes_summer($prog_ids_arr,$pid,$session,$semester=2,$sid,$second_debt,$level='SMR');
																																				}
																																				else //if not sed
																																				{
																																					$output .='<li><a target="_blank" href="print_form_a2_per_semester_core_summer.php?mis='.md5('mis').'&ses='. $session.'&sem=2&sid='.$sid.'&pid='.$pid.'&did='.$second_debt.'&lvl=SMR&core=2" > '.$second_debt_code.' FORM A </a></li>';

																																				}

																																			}
																																			else //if it doesnt have second combination
																																			{
																																					$output .= '<li><a target="_blank" href="print_form_a2_per_semester_core_summer.php?mis='.md5('mis').'&ses='. $session.'&sem=2&sid='.$sid.'&pid='.$pid.'&did='.$second_debt.'&lvl=SMR&core=2" > '.$second_debt_code.' FORM A </a></li>';

																																			}



																																	$output .= '
																																	</ul>
																																	</span>'; //end of  /.btn group



				$output .= "</td></tr>";


			}
		}
		else
		{//show the msg

				$output =
					   '<div class="alert alert-danger alert-dismissable">
						<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
						<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
					   </div>';


		}



		$output .=
		'</tbody>
	    </table>';


	return $output;




}//end of get programme lists for computing results for summer





//function get programme list for computing result fr prence
function get_programmes_list_prence_cr($sid)
{  //now switch the programme list based on core / general studies / education


		//query the database
		$q = "SELECT id, title, description, status, school_id,department_id
			 FROM  programmes
			 WHERE school_id = '$sid'
			 AND status = 0
			 AND type_id = 1
			 AND mode = 1
			 AND code NOT LIKE '%SHI%'
			 AND code NOT LIKE '%SLD%'
			 AND code NOT LIKE '%SVI%'

			 ORDER BY date_added DESC, date_modified DESC";



	// }


		$r = mysqli_query(dbc(),$q); //result of the sql query




		if(mysqli_num_rows($r) > 0)
		{//show table


			$sn = 0; // serial no


			  $output =
			  '<table id="example" class="user display table-bordered table-hover table-striped" cellspacing="0" width="100%" style="font-size:12px;">
				<thead>
							<th>S/No. </th>
							<th>Programme Combination</th>
							<th>Department</th>
							<th>School</th>



				</thead>
				<tfoot>

							<th>S/No. </th>
							<th>Programme Combination</th>
							<th>Department</th>
							<th>School</th>





				</tfoot>

				<tbody>';

			while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
			{
				//here sid passed is collected from the parameters because we want to track virtual schools


				$sn = $sn + 1;

				$output .= "<tr>";
				$output .="<td>".$sn."</td>" ;
				$output .= "<td> <a href='gateway.php?act=view_courses_prence_cr&xid=".md5(8)."&sid=".$sid."&pid=".$row['id']."'>".$row['title']."</a></td>";
				$output .= "<td>".get_department_title($row['department_id'])."</td>";

			    $output .= "<td>".get_school_title($row['school_id'])."</td>";


				$output .= "</tr>";


			}
		}
		else
		{//show the msg

				$output =
					   '<div class="alert alert-danger alert-dismissable">
						<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
						<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
					   </div>';


		}



		$output .=
		'</tbody>
	    </table>';






	return $output;




}//end of get programme lists for computing results for PRENCE




//check if inserted already computation inserted already
function check_if_student_computatation_exist($student, $session, $semester, $level)
{
	//check if invoice id generated exist
	$q1 = "SELECT student_id
		   FROM students_results_nce
		   WHERE student_id = '$student'
		   AND session_id = '$session' AND semester = '$semester' AND level = '$level'";

	$r1 = mysqli_query(dbc(),$q1);

	if(mysqli_num_rows($r1) > 0 )
	{
		return true;
	}
	else
	{
		return false;
	}


}//end of if the computation is added already


//check if inserted already computation inserted already prence
function check_if_student_computatation_exist_prence($student, $session, $semester, $level)
{
	//check if invoice id generated exist
	$q1 = "SELECT student_id
		   FROM students_results_prence
		   WHERE student_id = '$student'
		   AND session_id = '$session' AND semester = '$semester' AND level = '$level'";

	$r1 = mysqli_query(dbc(),$q1);

	if(mysqli_num_rows($r1) > 0 )
	{
		return true;
	}
	else
	{
		return false;
	}


}//end of if the computation is added already prence


//check if inserted already computation inserted already
function check_if_computatation_exist_per_semester($programme_id,$session, $semester, $level)
{
	//check if invoice id generated exist
	$q1 = "SELECT programme_id
		   FROM students_results_nce
		   WHERE  programme_id = '$programme_id' AND session_id = '$session' AND semester = '$semester' AND level = '$level'";

	$r1 = mysqli_query(dbc(),$q1);

	if(mysqli_num_rows($r1) > 0 )
	{
		return true;
	}
	else
	{
		return false;
	}


}//end of if the computation is added already


//check if inserted already computation inserted already prence
function check_if_computatation_exist_per_semester_prence($programme_id,$session, $semester, $level)
{
	//check if invoice id generated exist
	$q1 = "SELECT programme_id
		   FROM students_results_prence
		   WHERE  programme_id = '$programme_id' AND session_id = '$session' AND semester = '$semester' AND level = '$level'";

	$r1 = mysqli_query(dbc(),$q1);

	if(mysqli_num_rows($r1) > 0 )
	{
		return true;
	}
	else
	{
		return false;
	}


}//end of if the computation is added already prence




//check if inserted already computation inserted already per student
function check_if_computatation_exist_per_semester_per_student($student_id, $programme_id,$session, $semester, $level)
{
	//check if invoice id generated exist
	$q1 = "SELECT programme_id
		   FROM students_results_nce
		   WHERE  student_id = $student_id AND programme_id = $programme_id AND session_id = $session AND semester = $semester AND level = '$level'";

	$r1 = mysqli_query(dbc(),$q1);

	if(mysqli_num_rows($r1) > 0 )
	{
		return true;
	}
	else
	{
		return false;
	}


}//end of if the computation is added already


//check if inserted already computation inserted already per student for prence
function check_if_computatation_exist_per_semester_per_student_prence($student_id, $programme_id,$session, $semester, $level)
{
	//check if invoice id generated exist
	$q1 = "SELECT programme_id
		   FROM students_results_prence
		   WHERE  student_id = $student_id AND programme_id = $programme_id AND session_id = $session AND semester = $semester AND level = '$level'";

	$r1 = mysqli_query(dbc(),$q1);

	if(mysqli_num_rows($r1) > 0 )
	{
		return true;
	}
	else
	{
		return false;
	}


}//end of if the computation is added already for prence



//function that get student list in of computed results per semester
function view_students_list_form_b2($ses,$sem,$sid,$pid,$level)
{




	 //work on the short code for different core courses
    $debt_comb_array =array();

    //get department comb of programme combination
    $debt_comb = get_department_comb_using_programme_id($pid);

      //get headings for the core departments


      //
      if(strpos($debt_comb, ',') !== false )
      {

        for ($i = 0; $i < count($debt_comb);$i++)
        {
           $debt_comb_array = explode(',', $debt_comb);


        }

         $first_debt = $debt_comb_array[0];

         $second_debt = $debt_comb_array[1];


        $first_debt = get_department_code($first_debt);

        $second_debt = get_department_code($second_debt);

      }
      else
      {

        //get department id using programme id
       $first_debt =  get_department_using_programme_id($pid);

       $first_debt = get_department_code($first_debt);
       $second_debt = '';



        //get short code for department

      }




	//show list of students who are still in school
	//dont show the dropped course bu the students

	$q = "SELECT sr.`id` AS srid, sr.`student_id`, sr.`programme_id`, sr.`session_id`, sr.`semester`, sr.`level`,
      sr.`delete_token`, sr.`result_date_added`, sr.`status`, sr.`date_trashed`, sr.`date_added`, sr.`date_modified`,
      sr.`added_by`, sr.`modified_by`, sr.`edu_ptcur`, sr.`edu_tcur`, sr.`edu_ptcue`, sr.`edu_tcue`, sr.`edu_ptgp`,
      sr.`edu_tgp`, sr.`edu_ptgpe`, sr.`edu_tgpe`, sr.`edu_pcgpa`, sr.`edu_cgpa`, sr.`gst_ptcur`, sr.`gst_tcur`,
      sr.`gst_ptcue`, sr.`gst_tcue`, sr.`gst_ptgp`, sr.`gst_tgp`, sr.`gst_ptgpe`, sr.`gst_tgpe`, sr.`gst_pcgpa`,
      sr.`gst_cgpa`, sr.`core1_ptcur`, sr.`core1_tcur`,sr.`core1_ptcue`, sr.`core1_tcue`, sr.`core1_ptgp`, sr.`core1_tgp`,
      sr.`core1_ptgpe`, sr.`core1_tgpe`, sr.`core1_pcgpa`, sr.`core1_cgpa`, sr.`core2_ptcur`, sr.`core2_tcur`,
      sr.`core2_ptcue`, sr.`core2_tcue`, sr.`core2_ptgp`, sr.`core2_tgp`, sr.`core2_ptgpe`, sr.`core2_tgpe`,
      sr.`core2_pcgpa`, sr.`core2_cgpa`, sr.`cum_ptcur`, sr.`cum_tcur`, sr.`cum_ptcue`, sr.`cum_tcue`, sr.`cum_ptgpe`,
      sr.`cum_tgpe`, sr.`cum_pcgpa`, sr.`cum_cgpa`,sr.`remark2`, s.`id` AS stud_id, s.`number`, s.`first_name`,s.`other_names`



	FROM  `students_nce` s, `students_results_nce` sr



	WHERE
	sr.`student_id` = s.`id` AND
    sr.`session_id` = '$ses' AND sr.`semester` = '$sem' AND sr.`programme_id` = '$pid' AND sr.`level` = '$level'



	ORDER BY s.`number` ASC ";

	//AND s.id NOT IN (SELECT GROUP_CONCAT(student_id) FROM students_results_nce WHERE `session_id` = '$ses' AND `semester` = '$sem' AND `programme_id` = '$pid' AND `level` = '$level'  )
	//
	//sr.`student_id` = s.`id` AND




	$r = mysqli_query(dbc(),$q);



	//in the table below result_table stands for resullt fetch throug seraching table(ajax)


	if(mysqli_num_rows($r) > 0)
	{//show table




	$output ='<table id="example" class="user display table-bordered table-hover table-striped responsive" width="100%"  cellspacing="0" style="font-size:10px;">


				<thead>
<tr>

						<th width = "3%" > <input type="checkbox" id="selecctall"  value="" data-toggle="tooltip" title="Check All"></th>
				  		<th width = "22%" colspan="2"></th>



				  		<th width = "3%" >TCUR</th>
				  		<th width = "3%" >TCUE</th>
				  		<th width = "4%" >TGP</th>
				  		<th width = "4%" >CGPA</th>

						<th width = "3%" >TCUR</th>
				  		<th width = "3%" >TCUE</th>
				  		<th width = "4%" >TGP</th>
				  		<th width = "4%" >CGPA</th>

				  		<th width = "3%" >TCUR</th>
				  		<th width = "3%" >TCUE</th>
				  		<th width = "3%" >TGP</th>
				  		<th width = "3%" >CGPA</th>

				  		<th width = "3%" >TCUR</th>
				  		<th width = "3%" >TCUE</th>
				  		<th width = "3%" >TGP</th>
				  		<th width = "3%" >CGPA</th>

						<th width = "2%"> </th>

						<th width = "3%" >TCUR</th>
				  		<th width = "3%" >TCUE</th>
				  		<th width = "4%">TGP</th>
				  		<th width = "4%" >CGPA</th>

				  		<th width = "8%">REMARK</th>
				  		<th width = "8%"></th>
</tr>



				<tr>


				  		<td width = "3%" ></td>
				  		<td width = "9%" >MATRIC NO</td>

				  		<td width = "13%" >NAMES</td>

				  		<td width = "14%" align="center" colspan = "4"> EDUCATION </td>


				  		<td width = "14%" align="center" colspan = "4"> GENERAL STUDIES</td>


				  		<td width = "12%" align="center" colspan = "4">'.$first_debt.'</td>


				  		<td width = "12%" align="center" colspan = "4">'.$second_debt.'</td>

						<td width = "2%" > TP </td>

						<td width = "13%" align="center" colspan ="4">CUMMULATIVE</td>


				  		<td width = "8%" >REMARK</td>
				  		<td width = "8%" >ACTION</td>


				</tr>
				</thead>







				<tbody>
				';



				//$sn = 0;

		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			$output .= "<tr>";

			$output .='<td width = "3%">&nbsp;&nbsp;<input type="checkbox" value="'.$row['srid'].'" name="result[]" id="result" class="checkbox1"/></td>' ;

			$output .= '<td width = "9%">'.$row['number'].'</td>';
			$output .= '<td width = "13%">'.strtoupper($row['first_name'].' '.$row['other_names']).'</td>';

			$output .= '<td width = "3%" >'.$row['edu_tcur'].'</td>';
			$output .= '<td width = "3%" >'.$row['edu_tcue'].'</td>';
			$output .= '<td width = "4%" >'.$row['edu_tgpe'].'</td>';
			$output .= '<td width = "4%" >'.$row['edu_cgpa'].'</td>';

			$output .= '<td width = "3%" >'.$row['gst_tcur'].'</td>';
			$output .= '<td width = "3%" >'.$row['gst_tcue'].'</td>';
			$output .= '<td width = "4%" >'.$row['gst_tgpe'].'</td>';
			$output .= '<td width = "4%" >'.$row['gst_cgpa'].'</td>';


			$output .= '<td width = "3%" >'.$row['core1_tcur'].'</td>';
			$output .= '<td width = "3%" >'.$row['core1_tcue'].'</td>';
			$output .= '<td width = "3%" >'.$row['core1_tgpe'].'</td>';
			$output .= '<td width = "3%" >'.$row['core1_cgpa'].'</td>';


			$output .= '<td width = "3%" >'.$row['core2_tcur'].'</td>';
			$output .= '<td width = "3%" >'.$row['core2_tcue'].'</td>';
			$output .= '<td width = "3%" >'.$row['core2_tgpe'].'</td>';
			$output .= '<td width = "3%" >'.$row['core2_cgpa'].'</td>';

			//tp out put
			$output .= '<td width = "2%" ></td>';


			$output .= '<td width = "3%" >'.$row['cum_tcur'].'</td>';
			$output .= '<td width = "3%" >'.$row['cum_tcue'].'</td>';
			$output .= '<td width = "4%" >'.$row['cum_tgpe'].'</td>';
			$output .= '<td width = "4%" >'.$row['cum_cgpa'].'</td>';





			$output .= '<td width = "8%" >'.$row['remark2'].'</td>';
			$output .= '<td width = "8%" > <a href="gateway.php?act=view_course_reg&u='.$row['stud_id'].'&pid='.$pid.'&ses='.$ses.'&sem='.$sem.'&level='.$level.'" class="btn btn-success" > View Course Reg. </a> &nbsp &nbsp ';


			//$output .= '</td>';


                if(!check_if_computatation_exist_per_semester_per_student($row['stud_id'],$pid,$ses,$sem,$level))
                {
                $output .= '<a target="_blank" href="gateway.php?act=compute_by_student_nce&ses='. $ses.'&sem='.$sem.'&sid='.$sid.'&pid='.$pid.'&level='.$level.'&stu_id='.$row['stud_id'].'&type=do" class="btn btn-warning"> COMPUTE RESULT</a>';

               }
               else
               {
                  $output .= '<a target="_blank" href="gateway.php?act=compute_by_student_nce&ses='. $ses.'&sem='.$sem.'&sid='.$sid.'&pid='.$pid.'&level='.$level.'&stu_id='.$row['stud_id'].'&type=redo" class="btn btn-warning"> RE-COMPUTE RESULT</a>';

               }





               $output .=  '&nbsp&nbsp <div class="btn-group">
                <button type="button" class="btn btn-warning dropdown-toggle" data-toggle="dropdown"><i class="glyphicon glyphicon-warning-sign"></i>
                  Suspend <span class="caret"></span>
                </button>
                <ul class="dropdown-menu">
                  <li><a  href="gateway.php?act=suspend_student_nce&ses='. $ses.'&sem='.$sem.'&sid='.$sid.'&pid='.$pid.'&level='.$level.'&stu_id='.$row['stud_id'].'&type=one_semester" > First Semester </a></li>

                   <li><a  href="gateway.php?act=suspend_student_nce&ses='. $ses.'&sem='.$sem.'&sid='.$sid.'&pid='.$pid.'&level='.$level.'&stu_id='.$row['stud_id'].'&type=both_semesters" > Both Semesters </a></li>


                   <li><a  href="gateway.php?act=suspend_student_nce&ses='. $ses.'&sem='.$sem.'&sid='.$sid.'&pid='.$pid.'&level='.$level.'&stu_id='.$row['stud_id'].'&type=expel" > Expel </a></li>

                </ul>
              </div>';



              //get validity status of a particular student
           		if(is_suspended_or_rusticated_nce($row['stud_id']))
           		{

           			 $output .= '&nbsp&nbsp <a  href="gateway.php?act=suspend_student_nce&ses='. $ses.'&sem='.$sem.'&sid='.$sid.'&pid='.$pid.'&level='.$level.'&stu_id='.$row['stud_id'].'&type=reset" class="btn btn-success"> RESET SUS./RUS.</a>';

           		}


							$output .= 		'&nbsp&nbsp<a target="_blank" href="print_transcript_per_semester.php?mis='.md5('mis').'&ses='. $ses.'&sem='.$sem.'&sid='.$sid.'&pid='.$pid.'&lvl='.$level.'&stu_id='.$row['stud_id'].'" class="btn btn-info" > PRINT TRANSCRIPT </a>';




			$output .= '</td>';

			$output .= '</tr>';










		}





		//comment it if its 200 level and above commented for security reasons
		//	echo view_students_list_form_b2_2($ses,$sem,$sid,$pid,$level);


		//do the same thing above and add another row
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;




}//end of view students list of computed result


//function that get student list in of computed results per semester for PRENCE
function view_students_list_form_b2_prence($ses,$sem,$sid,$pid,$level)
{




	 //work on the short code for different core courses
    $debt_comb_array =array();

    //get department comb of programme combination
    $debt_comb = get_department_comb_using_programme_id($pid);

      //get headings for the core departments


      //
      if(strpos($debt_comb, ',') !== false )
      {

        for ($i = 0; $i < count($debt_comb);$i++)
        {
           $debt_comb_array = explode(',', $debt_comb);


        }

         $first_debt = $debt_comb_array[0];

         $second_debt = $debt_comb_array[1];


        $first_debt = get_department_code($first_debt);

        $second_debt = get_department_code($second_debt);

      }
      else
      {

        //get department id using programme id
       $first_debt =  get_department_using_programme_id($pid);

       $first_debt = get_department_code($first_debt);
       $second_debt = '';



        //get short code for department

      }




	//show list of students who are still in school
	//dont show the dropped course bu the students

	$q = "SELECT sr.`id` AS srid, sr.`student_id`, sr.`programme_id`, sr.`session_id`, sr.`semester`, sr.`level`,
      sr.`delete_token`, sr.`result_date_added`, sr.`status`, sr.`date_trashed`, sr.`date_added`, sr.`date_modified`,
      sr.`added_by`, sr.`modified_by`, sr.`edu_ptcur`, sr.`edu_tcur`, sr.`edu_ptcue`, sr.`edu_tcue`, sr.`edu_ptgp`,
      sr.`edu_tgp`, sr.`edu_ptgpe`, sr.`edu_tgpe`, sr.`edu_pcgpa`, sr.`edu_cgpa`, sr.`gst_ptcur`, sr.`gst_tcur`,
      sr.`gst_ptcue`, sr.`gst_tcue`, sr.`gst_ptgp`, sr.`gst_tgp`, sr.`gst_ptgpe`, sr.`gst_tgpe`, sr.`gst_pcgpa`,
      sr.`gst_cgpa`, sr.`core1_ptcur`, sr.`core1_tcur`,sr.`core1_ptcue`, sr.`core1_tcue`, sr.`core1_ptgp`, sr.`core1_tgp`,
      sr.`core1_ptgpe`, sr.`core1_tgpe`, sr.`core1_pcgpa`, sr.`core1_cgpa`, sr.`core2_ptcur`, sr.`core2_tcur`,
      sr.`core2_ptcue`, sr.`core2_tcue`, sr.`core2_ptgp`, sr.`core2_tgp`, sr.`core2_ptgpe`, sr.`core2_tgpe`,
      sr.`core2_pcgpa`, sr.`core2_cgpa`, sr.`cum_ptcur`, sr.`cum_tcur`, sr.`cum_ptcue`, sr.`cum_tcue`, sr.`cum_ptgpe`,
      sr.`cum_tgpe`, sr.`cum_pcgpa`, sr.`cum_cgpa`,sr.`remark2`, s.`id` AS stud_id, s.`number`, s.`first_name`,s.`other_names`



	FROM  `students_prence` s, `students_results_prence` sr



	WHERE
	sr.`student_id` = s.`id` AND
    sr.`session_id` = '$ses' AND sr.`semester` = '$sem' AND sr.`programme_id` = '$pid' AND sr.`level` = '$level'



	ORDER BY s.`number` ASC ";

	//AND s.id NOT IN (SELECT GROUP_CONCAT(student_id) FROM students_results_nce WHERE `session_id` = '$ses' AND `semester` = '$sem' AND `programme_id` = '$pid' AND `level` = '$level'  )
	//
	//sr.`student_id` = s.`id` AND




	$r = mysqli_query(dbc(),$q);



	//in the table below result_table stands for resullt fetch throug seraching table(ajax)


	if(mysqli_num_rows($r) > 0)
	{//show table




	$output ='<table id="example" class="user display table-bordered table-hover table-striped responsive" width="100%"  cellspacing="0" style="font-size:10px;">


				<thead>
<tr>

						<th width = "3%" > <input type="checkbox" id="selecctall"  value="" data-toggle="tooltip" title="Check All"></th>
				  		<th width = "22%" colspan="2"></th>



				  		<th width = "3%" >TCUR</th>
				  		<th width = "3%" >TCUE</th>
				  		<th width = "4%" >TGP</th>
				  		<th width = "4%" >CGPA</th>

						<th width = "3%" >TCUR</th>
				  		<th width = "3%" >TCUE</th>
				  		<th width = "4%" >TGP</th>
				  		<th width = "4%" >CGPA</th>

				  		<th width = "3%" >TCUR</th>
				  		<th width = "3%" >TCUE</th>
				  		<th width = "3%" >TGP</th>
				  		<th width = "3%" >CGPA</th>

				  		<th width = "3%" >TCUR</th>
				  		<th width = "3%" >TCUE</th>
				  		<th width = "3%" >TGP</th>
				  		<th width = "3%" >CGPA</th>

						<th width = "2%"> </th>

						<th width = "3%" >TCUR</th>
				  		<th width = "3%" >TCUE</th>
				  		<th width = "4%">TGP</th>
				  		<th width = "4%" >CGPA</th>

				  		<th width = "8%">REMARK</th>
				  		<th width = "8%"></th>
</tr>



				<tr>


				  		<td width = "3%" ></td>
				  		<td width = "9%" >MATRIC NO</td>

				  		<td width = "13%" >NAMES</td>

				  		<td width = "14%" align="center" colspan = "4"> EDUCATION </td>


				  		<td width = "14%" align="center" colspan = "4"> GENERAL STUDIES</td>


				  		<td width = "12%" align="center" colspan = "4">'.$first_debt.'</td>


				  		<td width = "12%" align="center" colspan = "4">'.$second_debt.'</td>

						<td width = "2%" > TP </td>

						<td width = "13%" align="center" colspan ="4">CUMMULATIVE</td>


				  		<td width = "8%" >REMARK</td>
				  		<td width = "8%" >ACTION</td>


				</tr>
				</thead>







				<tbody>
				';



				//$sn = 0;

		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			$output .= "<tr>";

			$output .='<td width = "3%">&nbsp;&nbsp;<input type="checkbox" value="'.$row['srid'].'" name="result[]" id="result" class="checkbox1"/></td>' ;

			$output .= '<td width = "9%">'.$row['number'].'</td>';
			$output .= '<td width = "13%">'.strtoupper($row['first_name'].' '.$row['other_names']).'</td>';

			$output .= '<td width = "3%" >'.$row['edu_tcur'].'</td>';
			$output .= '<td width = "3%" >'.$row['edu_tcue'].'</td>';
			$output .= '<td width = "4%" >'.$row['edu_tgpe'].'</td>';
			$output .= '<td width = "4%" >'.$row['edu_cgpa'].'</td>';

			$output .= '<td width = "3%" >'.$row['gst_tcur'].'</td>';
			$output .= '<td width = "3%" >'.$row['gst_tcue'].'</td>';
			$output .= '<td width = "4%" >'.$row['gst_tgpe'].'</td>';
			$output .= '<td width = "4%" >'.$row['gst_cgpa'].'</td>';


			$output .= '<td width = "3%" >'.$row['core1_tcur'].'</td>';
			$output .= '<td width = "3%" >'.$row['core1_tcue'].'</td>';
			$output .= '<td width = "3%" >'.$row['core1_tgpe'].'</td>';
			$output .= '<td width = "3%" >'.$row['core1_cgpa'].'</td>';


			$output .= '<td width = "3%" >'.$row['core2_tcur'].'</td>';
			$output .= '<td width = "3%" >'.$row['core2_tcue'].'</td>';
			$output .= '<td width = "3%" >'.$row['core2_tgpe'].'</td>';
			$output .= '<td width = "3%" >'.$row['core2_cgpa'].'</td>';

			//tp out put
			$output .= '<td width = "2%" ></td>';


			$output .= '<td width = "3%" >'.$row['cum_tcur'].'</td>';
			$output .= '<td width = "3%" >'.$row['cum_tcue'].'</td>';
			$output .= '<td width = "4%" >'.$row['cum_tgpe'].'</td>';
			$output .= '<td width = "4%" >'.$row['cum_cgpa'].'</td>';





			$output .= '<td width = "8%" >'.$row['remark2'].'</td>';
			$output .= '<td width = "8%" > <a href="gateway.php?act=view_course_reg_prence&u='.$row['stud_id'].'&pid='.$pid.'&ses='.$ses.'&sem='.$sem.'&level='.$level.'" class="btn btn-success" > View Course Reg. </a> &nbsp &nbsp ';


			//$output .= '</td>';


                if(!check_if_computatation_exist_per_semester_per_student_prence($row['stud_id'],$pid,$ses,$sem,$level))
                {
                $output .= '<a target="_blank" href="gateway.php?act=compute_by_student_prence&ses='. $ses.'&sem='.$sem.'&sid='.$sid.'&pid='.$pid.'&level='.$level.'&stu_id='.$row['stud_id'].'&type=do" class="btn btn-warning"> COMPUTE RESULT</a>';

               }
               else
               {
                  $output .= '<a target="_blank" href="gateway.php?act=compute_by_student_prence&ses='. $ses.'&sem='.$sem.'&sid='.$sid.'&pid='.$pid.'&level='.$level.'&stu_id='.$row['stud_id'].'&type=redo" class="btn btn-warning"> RE-COMPUTE RESULT</a>';

               }





               $output .=  '&nbsp&nbsp <div class="btn-group">
                <button type="button" class="btn btn-warning dropdown-toggle" data-toggle="dropdown"><i class="glyphicon glyphicon-warning-sign"></i>
                  Suspend <span class="caret"></span>
                </button>
                <ul class="dropdown-menu">
                  <li><a  href="gateway.php?act=suspend_student_prence&ses='. $ses.'&sem='.$sem.'&sid='.$sid.'&pid='.$pid.'&level='.$level.'&stu_id='.$row['stud_id'].'&type=one_semester" > First Semester </a></li>

                   <li><a  href="gateway.php?act=suspend_student_prence&ses='. $ses.'&sem='.$sem.'&sid='.$sid.'&pid='.$pid.'&level='.$level.'&stu_id='.$row['stud_id'].'&type=both_semesters" > Both Semesters </a></li>


                   <li><a  href="gateway.php?act=suspend_student_prence&ses='. $ses.'&sem='.$sem.'&sid='.$sid.'&pid='.$pid.'&level='.$level.'&stu_id='.$row['stud_id'].'&type=expel" > Expel </a></li>

                </ul>
              </div>';



              //get validity status of a particular student
           		if(is_suspended_or_rusticated_prence($row['stud_id']))
           		{

           			 $output .= '&nbsp&nbsp <a  href="gateway.php?act=suspend_student_prence&ses='. $ses.'&sem='.$sem.'&sid='.$sid.'&pid='.$pid.'&level='.$level.'&stu_id='.$row['stud_id'].'&type=reset" class="btn btn-success"> RESET SUS./RUS.</a>';

           		}


							$output .= 		'&nbsp&nbsp<a target="_blank" href="print_transcript_per_semester_prence.php?mis='.md5('mis').'&ses='. $ses.'&sem='.$sem.'&sid='.$sid.'&pid='.$pid.'&lvl='.$level.'&stu_id='.$row['stud_id'].'" class="btn btn-info" > PRINT TRANSCRIPT </a>';




			$output .= '</td>';

			$output .= '</tr>';










		}





		//comment it if its 200 level and above
//			echo view_students_list_form_b2_2($ses,$sem,$sid,$pid,$level);


		//do the same thing above and add another row
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;




}//end of view students list of computed result for prence



//function that get student list in of computed results per semester  not in the same result sheet
function view_students_list_form_b2_2($ses,$sem,$sid,$pid,$level)
{






	//show list of students who are still in school
	//dont show the dropped course bu the students `students_courses_nce` sr, sr.`student_id` =  sr.`session_id` = '$ses' AND sr.`semester` = '$sem' AND sr.`programme_id` = '$pid' AND sr.`level` = '$level'

	$q = "SELECT  s.`id` AS stud_id, s.`number`, s.`first_name`,s.`other_names`,sc.`student_id`



	FROM `students_nce` s, school_fee_payments_nce sc


	WHERE s.`programme_id` = '$pid' AND

	s.`id` = sc.`student_id`  AND
	sc.`session` = '$ses' AND
	sc.`semester` = '$sem' AND


	NOT EXISTS (SELECT sr.`student_id` FROM `students_courses_nce` sr  WHERE sr.`student_id`= s.`id` AND  sr.`session_id` = '$ses' AND sr.`semester` = '$sem' AND sr.`programme_id` = '$pid' AND sr.`level` = '$level')";


//AND
//s.`level` = '$level'


	$r = mysqli_query(dbc(),$q);



	//in the table below result_table stands for resullt fetch throug seraching table(ajax)


	if(mysqli_num_rows($r) > 0)
	{//show table




// 	$output ='<table id="example" class="user display table-bordered table-hover table-striped responsive" width="100%"  cellspacing="0" style="font-size:10px;">


// 				<thead>
// <tr>

// 						<th width = "3%" > <input type="checkbox" id="selecctall"  value="" data-toggle="tooltip" title="Check All"></th>
// 				  		<th width = "22%" colspan="2"></th>



// 				  		<th width = "3%" >TCUR</th>
// 				  		<th width = "3%" >TCUE</th>
// 				  		<th width = "4%" >TGP</th>
// 				  		<th width = "4%" >CGPA</th>

// 						<th width = "3%" >TCUR</th>
// 				  		<th width = "3%" >TCUE</th>
// 				  		<th width = "4%" >TGP</th>
// 				  		<th width = "4%" >CGPA</th>

// 				  		<th width = "3%" >TCUR</th>
// 				  		<th width = "3%" >TCUE</th>
// 				  		<th width = "3%" >TGP</th>
// 				  		<th width = "3%" >CGPA</th>

// 				  		<th width = "3%" >TCUR</th>
// 				  		<th width = "3%" >TCUE</th>
// 				  		<th width = "3%" >TGP</th>
// 				  		<th width = "3%" >CGPA</th>

// 						<th width = "2%"> </th>

// 						<th width = "3%" >TCUR</th>
// 				  		<th width = "3%" >TCUE</th>
// 				  		<th width = "4%">TGP</th>
// 				  		<th width = "4%" >CGPA</th>

// 				  		<th width = "8%">REMARK</th>
// 				  		<th width = "8%"></th>
// </tr>



// 				<tr>


// 				  		<td width = "3%" ></td>
// 				  		<td width = "9%" >MATRIC NO</td>

// 				  		<td width = "13%" >NAMES</td>

// 				  		<td width = "14%" align="center" colspan = "4"> EDUCATION </td>


// 				  		<td width = "14%" align="center" colspan = "4"> GENERAL STUDIES</td>


// 				  		<td width = "12%" align="center" colspan = "4">'.$first_debt.'</td>


// 				  		<td width = "12%" align="center" colspan = "4">'.$second_debt.'</td>

// 						<td width = "2%" > TP </td>

// 						<td width = "13%" align="center" colspan ="4">CUMMULATIVE</td>


// 				  		<td width = "8%" >REMARK</td>
// 				  		<td width = "8%" >ACTION</td>


// 				</tr>
// 				</thead>



// 				<tbody>
// 				';

		$output = '';

				//$sn = 0;

		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			$output .= "<tr>";

			$output .= '<td></td>';

			$output .= '<td>'.$row['number'].'</td>';
			$output .= '<td>'.strtoupper($row['first_name'].' '.$row['other_names']).'</td>';

			$output .= '<td ></td>';
			$output .= '<td ></td>';
			$output .= '<td ></td>';
			$output .= '<td ></td>';

			$output .= '<td ></td>';
			$output .= '<td ></td>';
			$output .= '<td ></td>';
			$output .= '<td ></td>';


			$output .= '<td ></td>';
			$output .= '<td ></td>';
			$output .= '<td ></td>';
			$output .= '<td ></td>';


			$output .= '<td ></td>';
			$output .= '<td ></td>';
			$output .= '<td ></td>';
			$output .= '<td ></td>';

			//tp out put
			$output .= '<td ></td>';


			$output .= '<td ></td>';
			$output .= '<td ></td>';
			$output .= '<td ></td>';
			$output .= '<td ></td>';





			$output .= '<td ></td>';
			$output .= '<td > <a href="gateway.php?act=view_course_reg&u='.$row['stud_id'].'&pid='.$pid.'&ses='.$ses.'&sem='.$sem.'&level='.$level.'" class="btn btn-success" > View Course Reg. </a> &nbsp &nbsp <a href="gateway.php?act=view_course_reg&u='.$row['stud_id'].'&pid='.$pid.'&ses='.$ses.'&sem='.$sem.'&level='.$level.'" class="btn btn-success" > Compute Results </a></td>';

			$output .= '</tr><br/>';



		}



		//do the same thing above and add another row
	}
	else
	{//show the msg
			//
			// $output =
			// 	   '<div class="alert alert-danger alert-dismissable">
			// 		<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
			// 		<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
			// 	   </div>';


	}



	// $output .=
	// '</tbody>
 //    </table>';





	echo $output;




}//end of view students list of computed result not in the course table or result sheet




//function that get student list in of computed results per semester
function view_students_list_enter_scores($ses,$sem,$sid,$pid,$level)
{




	//check for the first session


	if($ses == 3)
	{//if session is 2017/2018

			$q = "SELECT  s.`id` AS stud_id, s.`number`, s.`first_name`,s.`other_names`,sc.`student_id`



			FROM `students_nce` s, school_fee_payments_nce sc


			WHERE s.`programme_id` = '$pid' AND

			s.`id` = sc.`student_id` AND
			sc.`session` = '$ses' AND
			sc.`semester` = '$sem'





			ORDER BY s.`number` ASC ";
	}
	else if($ses == 4)
	{

	        $q = "SELECT  s.`id` AS stud_id, s.`number`, s.`first_name`,s.`other_names`,sc.`student_id`



			FROM `students_nce` s, school_fee_payments_nce sc


			WHERE s.`programme_id` = '$pid' AND

			s.`id` = sc.`student_id` AND
			sc.`session` = '$ses' AND
			sc.`semester` = '$sem' AND
 			s.`level` = '$level'


			ORDER BY s.`number` ASC ";

	}
	else
	{

		$q = "SELECT  s.`id` AS stud_id, s.`number`, s.`first_name`,s.`other_names`,sc.`student_id`



			FROM `students_nce` s, school_fee_payments_nce sc


			WHERE s.`programme_id` = '$pid' AND

			s.`id` = sc.`student_id` AND
			sc.`session` = '$ses' AND
			sc.`semester` = '$sem' AND
 			s.`level` = '$level'




			ORDER BY s.`number` ASC ";

	}



	//show list of students who are still in school
	//dont show the dropped course bu the students



	//AND s.id NOT IN (SELECT GROUP_CONCAT(student_id) FROM students_results_nce WHERE `session_id` = '$ses' AND `semester` = '$sem' AND `programme_id` = '$pid' AND `level` = '$level'  )
	//
	//sr.`student_id` = s.`id` AND




	$r = mysqli_query(dbc(),$q);



	//in the table below result_table stands for resullt fetch throug seraching table(ajax)


	if(mysqli_num_rows($r) > 0)
	{//show table




	$output ='<table id="example" class="user display table-bordered table-hover table-striped responsive" width="100%"  cellspacing="0" style="font-size:10px;">


				<thead>




				<tr>


				  		<td width = "3%" >S/No</td>
				  		<td width = "9%" >MATRIC NO</td>

				  		<td width = "13%" >NAMES</td>



				  		<td width = "8%" >ACTION</td>


				</tr>
				</thead>

			<tbody>
				';



				$sn = 0;

		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{

			$sn = $sn +1 ;
			$output .= "<tr>";

			$output .='<td width = "3%">'. $sn .'</td>' ;

			$output .= '<td width = "9%">'.$row['number'].'</td>';
			$output .= '<td width = "13%">'.strtoupper($row['first_name'].' '.$row['other_names']).'</td>';





			$output .= '<td width = "8%" >';



			// if (has_done_registration($row['stud_id'], $ses))
			// {

				$output .= '<a href="gateway.php?act=view_courses_enter_scores&u='.$row['stud_id'].'&pid='.$pid.'&ses='.$ses.'&sem='.$sem.'&level='.$level.'" class="btn btn-success" > View Course Scores. </a> &nbsp &nbsp


						<div class="btn-group">
                                                    <button type="button" class="btn btn-danger dropdown-toggle" data-toggle="dropdown"><i class="glyphicon glyphicon-trash"></i>
                                                      Clear Courses <span class="caret"></span>
                                                    </button>
                                                    <ul class="dropdown-menu">





									 <li><a target="_blank" href="gateway.php?act=clear_courses&u='.$row['stud_id'].'&ses='. $ses.'&sem=1&sid='.$sid.'&pid='.$pid.'&level=II" > First Semester </a></li>


                                     <li><a target="_blank" href="gateway.php?act=clear_courses&u='.$row['stud_id'].'&ses='. $ses.'&sem=1&sid='.$sid.'&pid='.$pid.'&level=II" > Second Semester </a></li>


                                     <li><a target="_blank" href="gateway.php?act=clear_courses&u='.$row['stud_id'].'&ses='. $ses.'&sem=1&sid='.$sid.'&pid='.$pid.'&level=II" > Both </a></li>



                                                    </ul>
                                                  </div>



						 ';
		// }









			$output .= '</td>';

			$output .= '</tr>';










		}









		//do the same thing above and add another row
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;




}//end of view students list of computed result



//function that get student list in of computed results per semester for PRENCE
function view_students_list_enter_scores_prence($ses,$sem,$sid,$pid,$level)
{

	//check for the first session



		$q = "SELECT  s.`id` AS stud_id, s.`number`, s.`first_name`,s.`other_names`,sc.`student_id`
			FROM `students_prence` s, school_fee_payments_prence sc


			WHERE s.`programme_id` = '$pid' AND

			s.`id` = sc.`student_id` AND
			sc.`session` = '$ses' AND
			sc.`semester` = '$sem'  AND
			s.`level` = '$level'





			ORDER BY s.`number` ASC ";



	//show list of students who are still in school
	//dont show the dropped course bu the students



	//AND s.id NOT IN (SELECT GROUP_CONCAT(student_id) FROM students_results_nce WHERE `session_id` = '$ses' AND `semester` = '$sem' AND `programme_id` = '$pid' AND `level` = '$level'  )
	//
	//sr.`student_id` = s.`id` AND




	$r = mysqli_query(dbc(),$q);



	//in the table below result_table stands for resullt fetch throug seraching table(ajax)


	if(mysqli_num_rows($r) > 0)
	{//show table




	$output ='<table id="example" class="user display table-bordered table-hover table-striped responsive" width="100%"  cellspacing="0" style="font-size:10px;">


				<thead>




				<tr>


				  		<td width = "3%" >S/No</td>
				  		<td width = "9%" >MATRIC NO</td>

				  		<td width = "13%" >NAMES</td>



				  		<td width = "8%" >ACTION</td>


				</tr>
				</thead>

			<tbody>
				';



				$sn = 0;

		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{

			$sn = $sn +1 ;
			$output .= "<tr>";

			$output .='<td width = "3%">'. $sn .'</td>' ;

			$output .= '<td width = "9%">'.$row['number'].'</td>';
			$output .= '<td width = "13%">'.strtoupper($row['first_name'].' '.$row['other_names']).'</td>';





			$output .= '<td width = "8%" >';



			// if (has_done_registration($row['stud_id'], $ses))
			// {

				$output .= '<a href="gateway.php?act=view_courses_enter_scores_prence&u='.$row['stud_id'].'&pid='.$pid.'&ses='.$ses.'&sem='.$sem.'&level='.$level.'" class="btn btn-success" > View Course Scores. </a> &nbsp &nbsp


						<div class="btn-group">
                                                    <button type="button" class="btn btn-danger dropdown-toggle" data-toggle="dropdown"><i class="glyphicon glyphicon-trash"></i>
                                                      Clear Courses <span class="caret"></span>
                                                    </button>
                                                    <ul class="dropdown-menu">





									 <li><a target="_blank" href="gateway.php?act=clear_courses_prence&u='.$row['stud_id'].'&ses='. $ses.'&sem=1&sid='.$sid.'&pid='.$pid.'&level=II" > First Semester </a></li>


                                     <li><a target="_blank" href="gateway.php?act=clear_courses_prence&u='.$row['stud_id'].'&ses='. $ses.'&sem=1&sid='.$sid.'&pid='.$pid.'&level=II" > Second Semester </a></li>


                                     <li><a target="_blank" href="gateway.php?act=clear_courses_prence&u='.$row['stud_id'].'&ses='. $ses.'&sem=1&sid='.$sid.'&pid='.$pid.'&level=II" > Both </a></li>



                                                    </ul>
                                                  </div>



						 ';
		// }


			$output .= '</td>';

			$output .= '</tr>';



		}



		//do the same thing above and add another row
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;




}//end of view students list of computed result for prence





//function that get student list that paid for a session
function view_students_reg($ses,$sem,$sid,$pid,$level)
{


	//check for the first session


	$q = "SELECT  s.`id` AS stud_id, s.`number`, s.`first_name`,s.`other_names`,sc.`student_id`

			FROM `students_nce` s, school_fee_payments_nce sc
			WHERE s.`programme_id` = '$pid' AND
			s.`id` = sc.`student_id` AND
			sc.`session` = '$ses'
			ORDER BY s.`number` ASC"; //AND sc.`semester` = '$sem'


	//show list of students who are still in school
	//dont show the dropped course bu the students


	$r = mysqli_query(dbc(),$q);



	//in the table below result_table stands for resullt fetch throug seraching table(ajax)


	if(mysqli_num_rows($r) > 0)
	{//show table




	$output ='<table id="example" class="user display table-bordered table-hover table-striped responsive" width="100%"  cellspacing="0" style="font-size:10px;">


				<thead>

				<tr>
			  		<td >S/No</td>
				  		<td >MATRIC NO</td>

				  		<td >NAMES</td>
			  		<td >ACTION</td>

				</tr>
				</thead>

			<tbody>
				';



				$sn = 0;

		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{

			$sn = $sn +1 ;
			$output .= "<tr>";

			$output .='<td >'. $sn .'</td>' ;

			$output .= '<td >'.$row['number'].'</td>';
			$output .= '<td >'.strtoupper($row['first_name'].' '.$row['other_names']).'</td>';





			$output .= '<td  >';



			// if (has_done_registration($row['stud_id'], $ses))
			// {

				$output .= '<a href="gateway.php?act=view_courses_enter_scores&u='.$row['stud_id'].'&pid='.$pid.'&ses='.$ses.'&sem='.$sem.'&level='.$level.'" class="btn btn-success" > Enter Course Scores. </a> &nbsp &nbsp
				<a href="gateway.php?act=view_course_reg&u='.$row['stud_id'].'&pid='.$pid.'&ses='.$ses.'&sem='.$sem.'&level='.$level.'" class="btn btn-success" > View Course / Edit Reg. </a> &nbsp &nbsp


						<div class="btn-group">
                                                    <button type="button" class="btn btn-danger dropdown-toggle" data-toggle="dropdown"><i class="glyphicon glyphicon-trash"></i>
                                                      Clear Courses <span class="caret"></span>
                                                    </button>
                                                    <ul class="dropdown-menu">





									 <li><a target="_blank" href="gateway.php?act=clear_courses&u='.$row['stud_id'].'&ses='. $ses.'&sem=1&sid='.$sid.'&pid='.$pid.'&level=II" > First Semester </a></li>


                                     <li><a target="_blank" href="gateway.php?act=clear_courses&u='.$row['stud_id'].'&ses='. $ses.'&sem=1&sid='.$sid.'&pid='.$pid.'&level=II" > Second Semester </a></li>


                                     <li><a target="_blank" href="gateway.php?act=clear_courses&u='.$row['stud_id'].'&ses='. $ses.'&sem=1&sid='.$sid.'&pid='.$pid.'&level=II" > Both </a></li>

                                                    </ul>
                                                  </div>
						 ';
		// }


			$output .= '</td>';

			$output .= '</tr>';



		}



		//do the same thing above and add another row
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;




}//end of view students list with or without registration

//function that get total number of courses assigned for this programme per semster
function get_total_courses_per_semester_nce($pid,$semester,$level)
{
	$q = "SELECT count(pc.course_id)
		  FROM `programmes_courses_nce` pc , courses c

		  WHERE pc.level = '$level' AND pc.programme_id = '$pid'
		  AND c.id = pc.course_id AND c.semester = '$semester'";

	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_array($r, MYSQLI_NUM);

	return number_format($row[0]);
}



//function that get total number of courses assigned for this programme per semster for prence
function get_total_courses_per_semester_prence($pid,$semester,$level)
{
	$q = "SELECT count(pc.course_id)
		  FROM `programmes_courses_nce` pc , courses c

		  WHERE pc.level = '$level' AND pc.programme_id = '$pid'
		  AND c.id = pc.course_id AND c.semester = '$semester'";

	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_array($r, MYSQLI_NUM);

	return number_format($row[0]);
}
//for prence



//get exisitng token from result table
//get department for staff
function get_existing_result_token($pid,$ses,$sem,$level)
{
	$query = "SELECT delete_token FROM `students_results_nce` WHERE  programme_id ='$pid' AND session_id = '$ses' AND semester = '$sem' AND level ='$level'";
	$result = mysqli_query(dbc(),$query);
	$row = mysqli_fetch_assoc($result);

	$v =  $row['delete_token'];

	return $v;

}//////



//get  token prence
function get_existing_result_token_prence($pid,$ses,$sem,$level)
{
	$query = "SELECT delete_token FROM `students_results_prence` WHERE  programme_id ='$pid' AND session_id = '$ses' AND semester = '$sem' AND level ='$level'";
	$result = mysqli_query(dbc(),$query);
	$row = mysqli_fetch_assoc($result);

	$v =  $row['delete_token'];

	return $v;

}////// prence




//get exisitng result token per student
function get_existing_result_token_per_student($stud_id, $pid,$ses,$sem,$level)
{
	$query = "SELECT delete_token FROM `students_results_nce` WHERE student_id = '$stud_id' AND  programme_id ='$pid' AND session_id = '$ses' AND semester = '$sem' AND level ='$level'";
	$result = mysqli_query(dbc(),$query);
	$row = mysqli_fetch_assoc($result);

	$v =  $row['delete_token'];

	return $v;

}//////


//get exisitng result token per student for prence
function get_existing_result_token_per_student_prence($stud_id, $pid,$ses,$sem,$level)
{
	$query = "SELECT delete_token FROM `students_results_prence` WHERE student_id = '$stud_id' AND  programme_id ='$pid' AND session_id = '$ses' AND semester = '$sem' AND level ='$level'";
	$result = mysqli_query(dbc(),$query);
	$row = mysqli_fetch_assoc($result);

	$v =  $row['delete_token'];

	return $v;

}//////for prence

//function that get school id from results sheets
function get_sid_from_results_sheet($id)
{
	$q = "SELECT school_id
		  FROM `students_results_nce`

		  WHERE id = $id";

	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_array($r, MYSQLI_ASSOC);



	$v = $row['school_id'];

	return $v;
}

//function that get school id from results sheets for PRENCE
function get_sid_from_results_sheet_prence($id)
{
	$q = "SELECT school_id
		  FROM `students_results_prence`

		  WHERE id = $id";

	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_array($r, MYSQLI_ASSOC);



	$v = $row['school_id'];

	return $v;
}




//function that get programme id from results sheets
function get_pid_from_results_sheet($id)
{
	$q = "SELECT programme_id
		  FROM `students_results_nce`

		  WHERE id = $id";

	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_array($r, MYSQLI_ASSOC);



	$v = $row['programme_id'];

	return $v;
}


//function that get programme id from results sheets for prence
function get_pid_from_results_sheet_prence($id)
{
	$q = "SELECT programme_id
		  FROM `students_results_prence`

		  WHERE id = $id";

	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_array($r, MYSQLI_ASSOC);



	$v = $row['programme_id'];

	return $v;
}// for prence


//function that get session id from results sheets
function get_sess_id_from_results_sheet($id)
{
	$q = "SELECT session_id
		  FROM `students_results_nce`

		  WHERE id = $id";

	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_array($r, MYSQLI_ASSOC);



	$v = $row['session_id'];

	return $v;
}


//function that get session id from results sheets for prence
function get_sess_id_from_results_sheet_prence($id)
{
	$q = "SELECT session_id
		  FROM `students_results_prence`

		  WHERE id = $id";

			$r = mysqli_query(dbc(),$q);
			$row = mysqli_fetch_array($r, MYSQLI_ASSOC);

	$v = $row['session_id'];

	return $v;
}//for prence


//function that get semester id from results sheets
function get_sem_id_from_results_sheet($id)
{
	$q = "SELECT semester
		  FROM `students_results_nce`

		  WHERE id = $id";

	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_array($r, MYSQLI_ASSOC);



	$v = $row['semester'];

	return $v;
}


//function that get semester id from results sheets for PRENCE
function get_sem_id_from_results_sheet_prence($id)
{
	$q = "SELECT semester
		  FROM `students_results_prence`

		  WHERE id = $id";

	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_array($r, MYSQLI_ASSOC);



	$v = $row['semester'];

	return $v;
}//for prence

//function that get level id from results sheets
function get_level_from_results_sheet($id)
{
	$q = "SELECT level
		  FROM `students_results_nce`

		  WHERE id = $id";

	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_array($r, MYSQLI_ASSOC);



	$v = $row['level'];

	return $v;
}


//function that get level id from results sheets for prence
function get_level_from_results_sheet_prence($id)
{
	$q = "SELECT level
		  FROM `students_results_prence` WHERE id = $id";

	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_array($r, MYSQLI_ASSOC);



	$v = $row['level'];

	return $v;
}//for prence







//function get programme list
function get_programmes_list($sid)
{  //now switch the programme list based on core / general studies / education



	if($sid == 8)//if general studies
	{

		//fetch by all schools base on general studies
		$q = "SELECT id, title, description, status, school_id,department_id
			 FROM  programmes
			 WHERE  status = 0
			 AND type_id = 2
			 AND mode = 1

			 ORDER BY title ASC";


	}
	else if($sid == 9)//if education
	{

		//fetch by all schools base on education
		$q = "SELECT id, title, description, status, school_id,department_id
			 FROM  programmes
			 WHERE  status = 0
			 AND type_id = 2
			 AND mode = 1

			 ORDER BY title ASC";

	}
	else
	{

		//query the database
		$q = "SELECT id, title, description, status, school_id,department_id
			 FROM  programmes
			 WHERE school_id = '$sid'
			 AND status = 0
			 AND type_id = 2
			 AND mode = 1

			 ORDER BY date_added DESC, date_modified DESC";



	}


		$r = mysqli_query(dbc(),$q); //result of the sql query




		if(mysqli_num_rows($r) > 0)
		{//show table


			$sn = 0; // serial no


			  $output =
			  '<table id="example" class="user display table-bordered table-hover table-striped" cellspacing="0" width="100%" style="font-size:12px;">
				<thead>
							<th>S/No. </th>
							<th>Programme Combination</th>
							<th>Department</th>
							<th>School</th>



				</thead>
				<tfoot>

							<th>S/No. </th>
							<th>Programme Combination</th>
							<th>Department</th>
							<th>School</th>





				</tfoot>

				<tbody>';

			while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
			{
				//here sid passed is collected from the parameters because we want to track virtual schools


				$sn = $sn + 1;

				$output .= "<tr>";
				$output .="<td>".$sn."</td>" ;
				$output .= "<td> <a href='gateway.php?act=view_courses&xid=".md5(8)."&sid=".$sid."&pid=".$row['id']."'>".$row['title']."</a></td>";
				$output .= "<td>".get_department_title($row['department_id'])."</td>";

			    $output .= "<td>".get_school_title($row['school_id'])."</td>";


				$output .= "</tr>";


			}
		}
		else
		{//show the msg

				$output =
					   '<div class="alert alert-danger alert-dismissable">
						<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
						<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
					   </div>';


		}



		$output .=
		'</tbody>
	    </table>';






	return $output;




}//end of get programme lists



//function get programme list for summer
function get_programmes_list_summer($sid)
{  //now switch the programme list based on core / general studies / education



	if($sid == 8)//if general studies
	{

		//fetch by all schools base on general studies
		$q = "SELECT id, title, description, status, school_id,department_id
			 FROM  programmes
			 WHERE  status = 0
			 AND type_id = 2
			 AND mode = 1

			 ORDER BY title ASC";


	}
	else if($sid == 9)//if education
	{

		//fetch by all schools base on education
		$q = "SELECT id, title, description, status, school_id,department_id
			 FROM  programmes
			 WHERE  status = 0
			 AND type_id = 2
			 AND mode = 1

			 ORDER BY title ASC";

	}
	else
	{

		//query the database
		$q = "SELECT id, title, description, status, school_id,department_id
			 FROM  programmes
			 WHERE school_id = '$sid'
			 AND status = 0
			 AND type_id = 2
			 AND mode = 1

			 ORDER BY date_added DESC, date_modified DESC";



	}


		$r = mysqli_query(dbc(),$q); //result of the sql query




		if(mysqli_num_rows($r) > 0)
		{//show table


			$sn = 0; // serial no


			  $output =
			  '<table id="example" class="user display table-bordered table-hover table-striped" cellspacing="0" width="100%" style="font-size:12px;">
				<thead>
							<th>S/No. </th>
							<th>Programme Combination</th>
							<th>Department</th>
							<th>School</th>



				</thead>
				<tfoot>

							<th>S/No. </th>
							<th>Programme Combination</th>
							<th>Department</th>
							<th>School</th>





				</tfoot>

				<tbody>';

			while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
			{
				//here sid passed is collected from the parameters because we want to track virtual schools


				$sn = $sn + 1;

				$output .= "<tr>";
				$output .="<td>".$sn."</td>" ;
				$output .= "<td> <a href='gateway.php?act=view_courses_summer&xid=".md5(8)."&sid=".$sid."&pid=".$row['id']."'>".$row['title']."</a></td>";
				$output .= "<td>".get_department_title($row['department_id'])."</td>";

			    $output .= "<td>".get_school_title($row['school_id'])."</td>";


				$output .= "</tr>";


			}
		}
		else
		{//show the msg

				$output =
					   '<div class="alert alert-danger alert-dismissable">
						<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
						<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
					   </div>';


		}



		$output .=
		'</tbody>
	    </table>';






	return $output;




}//end of get programme lists for summer



//function get programme list prence
function get_programmes_list_prence($sid)
{  //now switch the programme list based on core / general studies / education



	if($sid == 8)//if general studies
	{

		//fetch by all schools base on general studies
		$q = "SELECT id, title, description, status, school_id,department_id
			 FROM  programmes
			 WHERE  status = 0
			 AND type_id = 1
			 AND mode = 1

			 ORDER BY title ASC";


	}
	else if($sid == 9)//if education
	{

		//fetch by all schools base on education
		$q = "SELECT id, title, description, status, school_id,department_id
			 FROM  programmes
			 WHERE  status = 0
			 AND type_id = 1
			 AND mode = 1

			 ORDER BY title ASC";

	}
	else
	{

		//query the database
		$q = "SELECT id, title, description, status, school_id,department_id
			 FROM  programmes
			 WHERE school_id = '$sid'
			 AND status = 0
			 AND type_id = 1
			 AND mode = 1

			 ORDER BY date_added DESC, date_modified DESC";



	}


		$r = mysqli_query(dbc(),$q); //result of the sql query




		if(mysqli_num_rows($r) > 0)
		{//show table


			$sn = 0; // serial no


			  $output =
			  '<table id="example" class="user display table-bordered table-hover table-striped" cellspacing="0" width="100%" style="font-size:12px;">
				<thead>
							<th>S/No. </th>
							<th>Programme Combination</th>
							<th>Department</th>
							<th>School</th>



				</thead>
				<tfoot>

							<th>S/No. </th>
							<th>Programme Combination</th>
							<th>Department</th>
							<th>School</th>





				</tfoot>

				<tbody>';

			while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
			{
				//here sid passed is collected from the parameters because we want to track virtual schools


				$sn = $sn + 1;

				$output .= "<tr>";
				$output .="<td>".$sn."</td>" ;
				$output .= "<td> <a href='gateway.php?act=view_courses_prence&xid=".md5(8)."&sid=".$sid."&pid=".$row['id']."'>".$row['title']."</a></td>";
				$output .= "<td>".get_department_title($row['department_id'])."</td>";

			    $output .= "<td>".get_school_title($row['school_id'])."</td>";


				$output .= "</tr>";


			}
		}
		else
		{//show the msg

				$output =
					   '<div class="alert alert-danger alert-dismissable">
						<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
						<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
					   </div>';


		}



		$output .=
		'</tbody>
	    </table>';






	return $output;




}//end of get programme lists pre nce

//function that checks if staff status is blocked or unblocked 0- blocked 1 means unblocked
//by passing the blocked status

function staff_status_img($status)
{
	$st = $status;

	if($st == 1)
	{
		return '<img src="images/active.png" data-toggle="tooltip" title="Active"/>';
	}
	else
	{
		return '<img src="images/blocked.png" data-toggle="tooltip" title="Blocked" />';
	}
}


//function that shows staff publish status image
function staff_publish_status_image($status)
{

	$st = $status;

	if($st == 0)
	{
		$output =  '<input type="submit" name="act" class="publish-icon-small" value="unpublish_staffs" id="publish_s"
				data-toggle="tooltip" data-placement="right" title="Published: Click to unpublish item">';
	}
	else
	{
		$output =  '<input type="submit" name="act" class="unpublish-icon-small" value="publish_staffs" id="unpublish_s"
					data-toggle="tooltip" data-placement="right" title="Unpublished: Click to publish item">';
	}

	return $output;


}//end of function dat shows publish staffs image




//function view staff
//function that get staffs informatn
function view_staffs()
{

	//$user_id = get_user_id();

	//query the database
	$q = "SELECT id,  CONCAT_WS(' ', first_name, other_names) as name, phone_number, username,number, department_id,
		  DATE_FORMAT(date_added, '%b %e, %Y  %l:%i:%p') as date_added,  online_status, user_status, email, status,
		  last_login, last_login_ip,
		  DATE_FORMAT(last_logout, '%b %e, %Y  %l:%i:%p') as last_logout


		 FROM staff
		 WHERE status = 0 OR status = 1



		 ORDER BY date_added DESC";
	$r = mysqli_query(dbc(),$q);



	//in the table below result_table stands for resullt fetch throug seraching table(ajax)


	if(mysqli_num_rows($r) > 0)
	{//show table

	$output ='<table id="example" class="staff display table-bordered table-hover table-striped responsive" width="100%"  cellspacing="0" style="font-size:12px;">
				<thead>




						<th  > <input type="checkbox" id="selecctall"  value="" data-toggle="tooltip" title="Check All"></th>


						<th>Name</th>
						<th>C-No.</th>
						<th>Status </th>
						<th>Username</th>
						<th>Active</th>
						<th>Ph No.</th>
						<th>Email</th>
						<th>Department</th>
						<th>Last Login Ip</th>
						<th>Last Visit Date</th>
						<th>Registration Date</th>

				</thead>



				<tfoot>
				   		<th > </th>
			  			<th>Name</th>
			  			<th>C-No.</th>
						<th> Status </th>
						<th>Username</th>
						<th>Active</th>
						<th>Ph No.</th>
						<th>Email</th>

						<th>Department</th>
						<th>Last Login Ip</th>
						<th>Last Visit Date</th>
						<th>Registration Date</th>
				</tfoot>

				<tbody>';



		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			$output .= "<tr>";
			$output .="<td>&nbsp;&nbsp;&nbsp;<input type='checkbox' value='".$row['id']."' name='staff[]' id='staff' class='checkbox1'/></td>" ;
			$output .= "<td> <a href=''>".$row['name']."</a></td>"; //nam eof the staff
			$output .= "<td>".$row['number']."</td>";
			$output .= "<td>".staff_publish_status_image($row['status'])."</td>";
			$output .= "<td>".$row['username']."</td>";
			$output .= "<td>". staff_status_img($row['user_status'])."</td>";
			$output .= "<td>".$row['phone_number']."</td>";
			$output .= "<td>".$row['email']."</td>";
			$output .= "<td>".get_department_title($row['department_id'])."</td>";
			$output .= "<td>".$row['last_login_ip']."</td>";
			$output .= "<td>".$row['last_logout']."</td>";
			$output .= "<td>".$row['date_added']."</td>";
			$output .= "</tr>";



		}
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;




}//end of view staff



//function that get trashed  staff informatn
function view_trashed_staffs()
{

	//query the database
	$q = "SELECT id, CONCAT_WS(' ', first_name, other_names) as name, phone_number, number,
		  DATE_FORMAT(date_added, '%b %e, %Y  %l:%i:%p') as date_added,  DATE_FORMAT(date_modified, '%b %e, %Y  %l:%i:%p') as date_modified,

		  DATE_FORMAT(date_trashed, '%b %e, %Y  %l:%i:%p') as date_trashed



		 FROM staff
		 WHERE status = 2

		 ORDER BY date_added DESC";
	$r = mysqli_query(dbc(),$q);






	if(mysqli_num_rows($r) > 0)
	{//show table

	$output ='<table id="example" class="staff display table-bordered table-hover table-striped responsive" width="100%"  cellspacing="0" style="font-size:12px;">
				<thead>




						<th  > <input type="checkbox" id="selecctall"  value=""></th>


						<th>Name</th>
						<th>Username</th>
						<th>C-No.</th>
						<th>Email</th>
						<th>Registration Date</th>
						<th>Last Modified</th>
						<th>Deleted </th>
						<th>

				</thead>



				<tfoot>
				   		<th > </th>
			  			<th>Name</th>
						<th>Username</th>
						<th>C-No.</th>
						<th>Email</th>
						<th>Registration Date</th>
						<th>Last Modified</th>
						<th>Deleted </th>
						<th></th>
				</tfoot>

				<tbody>';



		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			$output .= "<tr>";
			$output .="<td>&nbsp;&nbsp;&nbsp;<input type='checkbox' value='".$row['id']."' name='staff[]' id='staff' class='checkbox1'/></td>" ;
			$output .= "<td> <a href=''>".$row['name']."</a></td>"; //nam eof the user
			$output .= "<td>".$row['number']."</td>";
			$output .= "<td>".$row['phone_number']."</td>";
			$output .= "<td>".$row['email']."</td>";
			$output .= "<td>".$row['date_added']."</td>";
			$output .= "<td>".$row['date_modified']."</td>";
			$output .= "<td>".$row['date_trashed']."</td>";
			$output .= '<td><a class="btn btn-success btn-sm pull-right restore" id="'.$row['id'].'" > Restore</a>
						 <span id="loading"></span></td>';
			$output .= "</tr>";



		}
	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;




}//end of view staff

//function that get tsaff course connection
function view_staff_courses($session)
{

	//query the database
	$q = "SELECT `id`, `staff_id`, `course_id`, `session_id`, `semester`, `programme_id`
	 FROM `staff_courses`
	 WHERE session_id = '$session'

	ORDER BY date_added DESC";
	$r = mysqli_query(dbc(),$q);



	//in the table below result_table stands for resullt fetch throug seraching table(ajax)


	if(mysqli_num_rows($r) > 0)
	{//show table

	$output ='<table id="example" class="staff display table-bordered table-hover table-striped responsive" width="100%"  cellspacing="0" style="font-size:12px;">
				<thead>




						<!--<th  > <input type="checkbox" id="selecctall"  value="" data-toggle="tooltip" title="Check All"></th> -->


						<th>Name</th>
						<th>C-No.</th>
						<th>Course </th>
						<th>Prog. </th>
						<th>Session</th>
						<th>Semester</th>
						<th>Action</th>


				</thead>



				<tfoot>
				   		<!-- <th > </th> -->
							<th>Name</th>
							<th>C-No.</th>
							<th>Course </th>
							<th>Prog. </th>
							<th>Session</th>
							<th>Semester</th>
							<th>Action</th>
				</tfoot>

				<tbody>';



		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			$output .= "<tr>";
			//$output .="<td>&nbsp;&nbsp;&nbsp;<input type='checkbox' value='".$row['id']."' name='staff[]' id='staff' class='checkbox1'/></td>" ;
			$output .= "<td> <a href=''>".get_staff_name($row['staff_id'])."</a></td>"; //nam eof the staff
			$output .= "<td>".get_staff_cno($row['staff_id'])."</td>";
			$output .= "<td>".get_course_title_by_md5($row['course_id'])." (".get_course_code_by_md5($row['course_id']).")</td>";
				$output .= "<td>".get_programme_title($row['programme_id'])."</td>";
			$output .= "<td>".get_session_title($row['session_id'])."</td>";
			$output .= "<td>". get_semester_title($row['semester'])."</td>";
			$output .= '<td><a class="btn btn-success btn-sm pull-right set_course_free" id="'.$row['id'].'" > Set Free</a>
						 <span id="loading"></span></td>';
			$output .= "</tr>";
		}

	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;




}//end of view staff



//function that get staff course connection summer
function view_staff_courses_summer($session)
{

	$session = 6;//get_current_session(1);

	//query the database
	$q = "SELECT `id`, `staff_id`, `course_id`, `session_id`, `semester`, `programme_id`
	 FROM `staff_courses`
	 WHERE session_id = '$session'

	ORDER BY date_added DESC";
	$r = mysqli_query(dbc(),$q);



	//in the table below result_table stands for resullt fetch throug seraching table(ajax)


	if(mysqli_num_rows($r) > 0)
	{//show table

	$output ='<table id="example" class="staff display table-bordered table-hover table-striped responsive" width="100%"  cellspacing="0" style="font-size:12px;">
				<thead>




						<!--<th  > <input type="checkbox" id="selecctall"  value="" data-toggle="tooltip" title="Check All"></th> -->


						<th>Name</th>
						<th>C-No.</th>
						<th>Course </th>
						<th>Prog. </th>
						<th>Session</th>
						<th>Semester</th>
						<th>Action</th>


				</thead>



				<tfoot>
				   		<!-- <th > </th> -->
							<th>Name</th>
							<th>C-No.</th>
							<th>Course </th>
							<th>Prog. </th>
							<th>Session</th>
							<th>Semester</th>
							<th>Action</th>
				</tfoot>

				<tbody>';



		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			$output .= "<tr>";
			//$output .="<td>&nbsp;&nbsp;&nbsp;<input type='checkbox' value='".$row['id']."' name='staff[]' id='staff' class='checkbox1'/></td>" ;
			$output .= "<td> <a href=''>".get_staff_name($row['staff_id'])."</a></td>"; //nam eof the staff
			$output .= "<td>".get_staff_cno($row['staff_id'])."</td>";
			$output .= "<td>".get_course_title_by_md5($row['course_id'])." (".get_course_code_by_md5($row['course_id']).")</td>";
				$output .= "<td>".get_programme_title($row['programme_id'])."</td>";
			$output .= "<td>".get_session_title($row['session_id'])."</td>";
			$output .= "<td>". get_semester_title($row['semester'])."</td>";
			$output .= '<td><a class="btn btn-success btn-sm pull-right set_course_free_sm" id="'.$row['id'].'" > Set Free</a>
						 <span id="loading"></span></td>';
			$output .= "</tr>";
		}

	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;




}//end of view staff summer

//function that get tsaff course upload status
function view_staff_course_upload_status($session)
{

	//get current semester'
//	$semester = get_current_semester(1);

	// //query the database
	// $q = "SELECT `id`, `staff_id`, `course_id`, `session_id`, `semester`, `programme_id`
	//  FROM `staff_courses`
	//  WHERE session_id = '$session'
	//
	// ORDER BY date_added DESC";
	// $r = mysqli_query(dbc(),$q);


	//query the database
	$q = "SELECT `id`, `school_id`, `department_id`, `programme_id`, `type_id`, `title`, `code`, `unit`, `major_status`, `course_type`,
	 `course_category`, `description`, `course_description`, `level`, `semester`, `prerequisite_of`, `status`, `date_added`, `date_modified`,
	 `date_trashed`, `added_by`, `modified_by`
	  FROM `courses`
	 WHERE status = 0  AND type_id = 2

	ORDER BY date_added DESC";
	$r = mysqli_query(dbc(),$q);

	//AND semester = '$semester'



	//in the table below result_table stands for resullt fetch throug seraching table(ajax)


	if(mysqli_num_rows($r) > 0)
	{//show table

	$output ='<table id="example" class="staff display table-bordered table-hover table-striped responsive" width="100%"  cellspacing="0" style="font-size:12px;">
				<thead>




						<!--<th  > <input type="checkbox" id="selecctall"  value="" data-toggle="tooltip" title="Check All"></th> -->


						<th>Code</th>
						<th>Title</th>
						<th>Department</th>
						<th>Semester</th>
						<th>Action</th>


				</thead>



				<tfoot>
				   		<!-- <th > </th> -->
							<th>Code</th>
							<th>Title</th>
							<th>Department</th>
							<th>Semester</th>
							<th>Action</th>
				</tfoot>

				<tbody>';



		while($row = mysqli_fetch_array($r, MYSQLI_ASSOC))
		{
			$output .= "<tr>";
			//$output .="<td>&nbsp;&nbsp;&nbsp;<input type='checkbox' value='".$row['id']."' name='staff[]' id='staff' class='checkbox1'/></td>" ;
			//$output .= "<td> <a href=''>".get_staff_name($row['staff_id'])."</a></td>"; //nam eof the staff
			$output .= "<td>".get_course_code($row['id'])."</td>";
			$output .= "<td>".get_course_title($row['id'])."</td>";
			$output .= "<td>".get_department_title($row['department_id'])."</td>";
			$output .= "<td>". get_semester_title($row['semester'])."</td>";

			if(!check_if_course_has_upload($row['id'], $session, $row['semester']))
			{
				$output .= '<td><span class="label label-danger"> No upload </span></td>';

			}
			else {
				// code...
				$output .= '<td><span class="label label-success"> Uploaded </span></td>';

			}

			$output .= "</tr>";
		}

	}
	else
	{//show the msg

			$output =
				   '<div class="alert alert-danger alert-dismissable">
					<button class="close" aria-hidden="true" data-dismiss="alert" type="button">x</button>
					<img src="images/info.png" />&nbsp;&nbsp; No record found in the system.
				   </div>';


	}



	$output .=
	'</tbody>
    </table>';





	return $output;




}//end of view courses uplaod status



//get staff first name, last name
function get_staff_userid_by_course($course_id,$session,$semester,$pid)
{
	$query = "SELECT  staff_id   FROM staff_courses WHERE course_id = MD5('$course_id') AND programme_id = $pid AND session_id = $session AND semester = $semester";
	$result = mysqli_query(dbc(),$query);
	$row = mysqli_fetch_assoc($result);

	return $row['staff_id'];

}


//Function to fetch check if student is suspended or rusticated
function is_suspended_or_rusticated_nce($user_id)
{
	$q = "SELECT validity_status FROM students_nce  WHERE id = $user_id";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	if($row['validity_status'] == '0')
	{
		return false;

	}
	else
	{
		return true;
	}

}



//Function to fetch check if student is suspended or rusticated for PRENCE
function is_suspended_or_rusticated_prence($user_id)
{
	$q = "SELECT validity_status FROM students_prence  WHERE id = $user_id";
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	if($row['validity_status'] == '0')
	{
		return false;

	}
	else
	{
		return true;
	}

} /// for prence


//check if course has an entry made already
function check_if_course_has_upload($course_id, $session, $semester)
{
	//check if invoice id generated exist
	$q1 = "SELECT course_id
		   FROM staff_courses
		   WHERE course_id = MD5('$course_id')
			 AND session_id = '$session'
			 AND semester = '$semester'";

	$r1 = mysqli_query(dbc(),$q1);

	if(mysqli_num_rows($r1) > 0 )
	{
		return true;
	}
	else
	{
		return false;
	}


}//end of if the staff id exist per course is added already



//check if course has an entry made already per user per programme
function check_if_course_has_upload_per_user($course_id, $session, $semester, $prog_id)
{
	//check if invoice id generated exist
	$q1 = "SELECT course_id
		   FROM staff_courses
		   WHERE course_id = MD5('$course_id')
			 AND session_id = '$session'
			 AND semester = '$semester'
			 AND programme_id = '$prog_id'";

	$r1 = mysqli_query(dbc(),$q1);

	if(mysqli_num_rows($r1) > 0 )
	{
		return true;
	}
	else
	{
		return false;
	}


}//end of if the staff id exist per course is added already

//check if inserted already staff entered score already
//$programme id parameter is added because there was a complain on if upload is done it block
// other staff of other combination from uploading
function check_if_staff_entered_score($staff_id,$course_id, $session, $semester,$programme_id)
{
	//check if invoice id generated exist
	$q1 = "SELECT staff_id
		   FROM staff_courses
		   WHERE course_id = '$course_id'
			 AND session_id = '$session'
			 AND semester = '$semester'
			 AND programme_id = '$programme_id'";

	$r1 = mysqli_query(dbc(),$q1);

	if(mysqli_num_rows($r1) > 0 )
	{
		return true;
	}
	else
	{
		return false;
	}


}//end of if the staff id exist per course is added already



//function to check if the score uploaded is by admin staff
function check_if_admin_staff_entered_score($staff_id,$course_id, $session, $semester,$programme_id)
{
	//check if invoice id generated exist
	$q1 = "SELECT staff_id
		   FROM staff_courses
		   WHERE course_id = '$course_id'
			 AND session_id = '$session'
			 AND semester = '$semester'
			 AND added_by = '$staff_id'";

	$r1 = mysqli_query(dbc(),$q1);




	if(mysqli_num_rows($r1) > 0 )
	{
		//$row = mysqli_fetch_assoc($r1); //fetch staff id

	//	$staff_id = $row['staff_id']; //pass it to a variable

		// if(is_admin($staff_id))
		// {

			return true;

		// }
		// else
		// {
		// 	return false;
		// }


		//before returning true the staff must be an admin user
	}
	else
	{
		return false;
	}


}//end of if the staff id exist per course is added already




// //track scores entered by staff
function track_staff_score_entry($staff_id,$course_id, $session, $sem, $programme_id)
{
    
    //check if not admin keep track
	if(!is_admin($staff_id))
	{

		if(!check_if_staff_entered_score($staff_id,$course_id, $session, $sem, $programme_id))
		{
						$q5 = "INSERT INTO `staff_courses`(`staff_id`, `course_id`, `session_id`,
							 `semester`,  `date_added`, `programme_id`)

								VALUES ('$staff_id','$course_id','$session','$sem',NOW(), '$programme_id')";


						$r5 = mysqli_query(dbc(),$q5);

						/*if($r5) { die("<span class='btn btn-danger'>SERVER ERROR: Please retry again</span>");}*/

		}
		
	}
	else
	{
		$q6 = "INSERT INTO `staff_courses`(`staff_id`, `course_id`, `session_id`,
			 `semester`,  `date_added`, `programme_id`,`added_by`)

				VALUES ('','$course_id','$session','$sem',NOW(), '','$staff_id')";


		$r6 = mysqli_query(dbc(),$q6);


	}

}


// set new department id for ted students in 100level
function set_new_department_id_for_ted($didx,$level)
{
	$level = $level;
	$did = $didx;

	if($level == 'I')
	{
		if($did == 24 OR $did == 25 OR $did == 26 OR $did == 27 OR $did == 28 )
		{
			return 67;
		}
		else
		{
			return $didx;
		}

	}
	else {
		return $didx;
	}
}



//tp inclusion in 300 Level result
function get_tp_course_id()
{
	//set course id of the TP courses
	$tp_course_id = 1268;

	return $tp_course_id;
}


/// starting  out the 300 level graduation requirments
//function to get minimum required core courses for education --   for edu
function get_edu_core_minimum_req_nce($programme_id, $session)
{
	$q = "SELECT edu_core
		    FROM students_results_minimum_req_prog_grad  WHERE   programme_id = $programme_id AND session_id = $session "; //AND semester = $semester student_id = $user_id AND level = '$level' AND
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['edu_core']);


}//end of function that gets edu minimum core requirement

//function to get minimum required elective courses for education --   for edu
function get_edu_elective_minimum_req_nce($programme_id, $session)
{
	$q = "SELECT edu_elective
		    FROM students_results_minimum_req_prog_grad  WHERE   programme_id = $programme_id AND session_id = $session "; //AND semester = $semester student_id = $user_id AND level = '$level' AND
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['edu_elective']);


}//end of function that gets edu minimum elective requirement





//function to get minimum required core courses for general studies --   for
function get_gst_core_minimum_req_nce($programme_id, $session)
{
	$q = "SELECT gst_core
		    FROM students_results_minimum_req_prog_grad  WHERE   programme_id = $programme_id AND session_id = $session"; //AND semester = $semester student_id = $user_id AND level = '$level' AND
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['gst_core']);


}//end of function that gets gst minimum core requirement


//function to get minimum required elective courses for general studies --   for
function get_gst_elective_minimum_req_nce($programme_id, $session)
{
	$q = "SELECT gst_elective
		    FROM students_results_minimum_req_prog_grad  WHERE   programme_id = $programme_id AND session_id = $session"; //AND semester = $semester student_id = $user_id AND level = '$level' AND
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['gst_elective']);


}//end of function that gets gst minimum elective requirement


//function to get minimum required core courses for core 1 or subject 1--   for
function get_core1_core_minimum_req_nce($programme_id, $session)
{
	$q = "SELECT core1_core
		    FROM students_results_minimum_req_prog_grad  WHERE   programme_id = $programme_id AND session_id = $session"; //AND semester = $semester student_id = $user_id AND level = '$level' AND
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['core1_core']);


}//end of function that gets core1_core or subject A  minimum core requirement


//function to get minimum required elective courses for core 1 or subject 1--   for
function get_core1_elective_minimum_req_nce($programme_id, $session)
{
	$q = "SELECT core1_elective
		    FROM students_results_minimum_req_prog_grad  WHERE   programme_id = $programme_id AND session_id = $session"; //AND semester = $semester student_id = $user_id AND level = '$level' AND
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['core1_elective']);


}//end of function that gets core1_elective or subject A  minimum core requirement




//function to get minimum required core courses for core 1 or subject B--   for
function get_core2_core_minimum_req_nce($programme_id, $session)
{
	$q = "SELECT core2_core
		    FROM students_results_minimum_req_prog_grad  WHERE   programme_id = $programme_id AND session_id = $session"; //AND semester = $semester student_id = $user_id AND level = '$level' AND
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['core2_core']);


}//end of function that gets core2_core or subject AB minimum core requirement


//function to get minimum required elective courses for core 1 or subject B--   for
function get_core2_elective_minimum_req_nce($programme_id, $session)
{
	$q = "SELECT core2_elective
		    FROM students_results_minimum_req_prog_grad  WHERE   programme_id = $programme_id AND session_id = $session"; //AND semester = $semester student_id = $user_id AND level = '$level' AND
	$r = mysqli_query(dbc(),$q);

	$row = mysqli_fetch_assoc($r);

	return number_format($row['core2_elective']);


}//end of function that gets core2_core or subject AB minimum core requirement


//fetch particular combination to compute
//function to get minimum required elective courses for core 1 or subject B--   for
function get_students_per_programme($programme_id, $session, $level)
{

	$students_array = array();
	$q = "SELECT distinct (student_id) FROM students_courses_nce WHERE programme_id = $programme_id AND session_id = $session AND level = '$level' LIMIT 10"; //AND semester = $semester student_id = $user_id AND level = '$level' AND
	$r = mysqli_query(dbc(),$q);


	if($r)
	{
		while($row = mysqli_fetch_array($r,MYSQLI_ASSOC))
		{
			$students_array[] = $row['student_id'];

		}

		return 	$students_array;
	}
	else
	{

		return 0;
	}




}//end of function that gets core2_core or subject AB minimum core requirement



?>
